/*
// "Frontpage Slideshow" for Joomla! 1.0.x - Version 1.1
// Copyright (c) 2006 - 2007 JoomlaWorks.gr - http://www.joomlaworks.gr
// This code cannot be redistributed without permission from http://www.joomlaworks.gr/
// More info at: http://www.joomlaworks.gr/
// Developers: Fotis Evangelou - George Chouliaras
// ***Last update: February 9th, 2007***
*/

// Parameters
var speed_delay = 6000; // adjust delay length here, in miliseconds
var slide_speed = 1000; // adjust fade duration here, in miliseconds

// Don't change anything below this point!
var autoslide = true;
var slideOuter = "slide-wrapper";
var slideLoading = "slide-loading";
var slideClass = "slide";
var naviClass = "navi";
var activeSuffix = "-active";

// Effect handle
var isShowing = 0;
var slides;
var navis;
var fx1 = new Array();
var firstDelay = false;
var pauseFlag = false;
var timer;
var playButton;

function initFrontpageSlideshow() {
	displayloading = document.getElementById(slideLoading);
	if (displayloading) displayloading.style.display = "none";
	else return;
	displayslide = document.getElementById(slideOuter);
	if (displayslide) displayslide.style.display = "block";
	
	if (readCookie("com_jw_fpss") == "true") autoslide = true;
	else if (readCookie("com_jw_fpss") == "false") autoslide = false;	
	playButton = document.getElementById('playButton');
	if (autoslide) { showPauseButton(); }
	else { showPlayButton(); }

	slides = document.getElementsByClassName(slideClass);
	navis = document.getElementsByClassName(naviClass);
	
	if (slides.length == 0 || navis.length == 0) return;
	
	for (i = 0; i < slides.length; ++i) {
		fx1[i] = new fx.Combo(slides[i], { opacity: true, width: false, duration: slide_speed, height: false, toggle: false });
		navis[i].onclick = function() {
			current = null;
			for (j = 0; j < navis.length; ++j) {
				if (this == navis[j]) current = j;
			}
			if (current != isShowing) {
				fx1[isShowing].clearTimer();
				if (fx1[isShowing].el.offsetHeight) fx1[isShowing].hide();
				fx1[current].toggle();
				navis[isShowing].className = naviClass;
				navis[current].className = naviClass + activeSuffix;
				isShowing = current;
				clearSlide();
			}
			
			return false;
		}
		if (i != 0) {
			fx1[i].hide();
		} else {
			navis[i].className = naviClass + activeSuffix;
		}
	}
}

function showPauseButton() {
	createCookie("com_jw_fpss", "true");
	playButton.innerHTML = "Pause"; // change "Pause" label here
	playButton.title = "Pause"; // change "Pause" label here
	pauseFlag = false;
	autoSlide();
}

function showPlayButton() {
	createCookie("com_jw_fpss", "false");
	playButton.innerHTML = "Play"; // change "Play" label here
	playButton.title = "Play"; // change "Play" label here
	pauseFlag = true;
	clearTimeout(timer);
	firstDelay = false;
}

function showNext() {
	if (slides.length <= 1) return;
	fx1[isShowing].clearTimer();
	if (fx1[isShowing].el.offsetHeight) fx1[isShowing].hide();
	navis[isShowing].className = naviClass;
	if (isShowing == slides.length - 1) {
		fx1[0].toggle();
		isShowing = 0;
	} else {
		fx1[++isShowing].toggle();
	}
	navis[isShowing].className = naviClass + activeSuffix;
}

function showPrev() {
	if (slides.length <= 1) return;
	fx1[isShowing].clearTimer();
	if (fx1[isShowing].el.offsetHeight) fx1[isShowing].hide();
	navis[isShowing].className = naviClass;
	if (isShowing == 0) {
		fx1[slides.length - 1].toggle();
		isShowing = slides.length - 1;
	} else {
		fx1[--isShowing].toggle();
	}
	navis[isShowing].className = naviClass + activeSuffix;
}

function autoSlide() {
	if (!pauseFlag) {
		timer = setTimeout('autoSlide()', speed_delay);
		if (!firstDelay) firstDelay = true;
		else showNext();
	}
}

function clearSlide() {
	if (!pauseFlag) {
		clearTimeout(timer);
		firstDelay = false;
		autoSlide();
	}
}

function playButtonClicked() {
	if (pauseFlag) showPauseButton();
	else showPlayButton();
}

// Cookie handle
function createCookie(name,value,days) {
  if (days) {
    var date = new Date();
    date.setTime(date.getTime()+(days*24*60*60*1000));
    var expires = "; expires="+date.toGMTString();
  }
  else expires = "";
  document.cookie = name+"="+value+expires+"; path=/";
}
function readCookie(name) {
  var nameEQ = name + "=";
  var ca = document.cookie.split(';');
  for(var i=0;i < ca.length;i++) {
    var c = ca[i];
    while (c.charAt(0)==' ') c = c.substring(1,c.length);
    if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
  }
  return null;
}

// Load everything up
function fpssinit() {
    if (arguments.callee.done) return;
    arguments.callee.done = true;
    if (_timer) clearInterval(_timer);
	initFrontpageSlideshow();
};
if (document.addEventListener) {
    document.addEventListener("DOMContentLoaded", fpssinit, false);
}
/*@cc_on @*/
/*@if (@_win32)
    document.write("<script id=__ie_onload_fpss defer src=javascript:void(0)><\/script>");
    var scriptFPSS = document.getElementById("__ie_onload_fpss");
    scriptFPSS.onreadystatechange = function() {
        if (this.readyState == "complete") {
            fpssinit();
        }
    };
/*@end @*/
if (/WebKit/i.test(navigator.userAgent)) {
    var _timer = setInterval(function() {
        if (/loaded|complete/.test(document.readyState)) {
            fpssinit();
        }
    }, 10);
}
window.onload = fpssinit;

// end
