<?php
/*
// "Frontpage Slideshow" for Joomla! 1.0.x - Version 1.1
// Copyright (c) 2006 - 2007 JoomlaWorks.gr - http://www.joomlaworks.gr
// This code cannot be redistributed without permission from http://www.joomlaworks.gr/
// More info at: http://www.joomlaworks.gr/
// Developers: Fotis Evangelou - George Chouliaras
// ***Last update: February 9th, 2007***
*/

// no direct access
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

global $mosConfig_offset, $mosConfig_live_site, $mainframe, $mosConfig_absolute_path, $mosConfig_lang, $_VERSION;

// Compatibility check
$fpss = "com_fpslideshow";
if ( $_VERSION->PRODUCT == 'Joomla!' ){   
	$nullDate = $database->getNullDate();
	$now = _CURRENT_SERVER_TIME;
} elseif ( $_VERSION->PRODUCT == 'Mambo' ) {
	$nullDate = "0000-00-00 00:00:00";
	$now = date( 'Y-m-d H:i:s', time()+$mosConfig_offset*60*60 );
}
$access = !$mainframe->getCfg( 'shownoauth' );
$bs 	= $mainframe->getBlogSectionCount();
$bc 	= $mainframe->getBlogCategoryCount();
$gbs 	= $mainframe->getGlobalBlogSectionCount();

$database->setQuery("SELECT link FROM #__components"
	.	"\nWHERE link='option=com_fpslideshow'"
	.	"\nLIMIT 1");
$FPSScom = $database->loadResult();
if(count($FPSScom)>0) { 
    if (file_exists($mosConfig_absolute_path.'/components/'.$fpss.'/language/'.$mosConfig_lang.'.php')) {
	   include_once ($mosConfig_absolute_path.'/components/'.$fpss.'/language/'.$mosConfig_lang.'.php');
    } else {
	   include_once ($mosConfig_absolute_path.'/components/'.$fpss.'/language/english.php');
    }
	if(!isset($MOD_FPSS_CONFIG)) {
	   $MOD_FPSS_CONFIG = array();
	   $database->setQuery("SELECT name, value FROM "._FPSS_TABLE_CONFIG);
       $MOD_FPSS_CONFIG_tmp = $database->loadObjectList();
       foreach ($MOD_FPSS_CONFIG_tmp as $c){
	      $MOD_FPSS_CONFIG[$c->name] =$c->value;
       }
	}
	
	// Parameters
	$chars					= intval( $MOD_FPSS_CONFIG['chars'] );
    $words					= intval( $MOD_FPSS_CONFIG['words'] );
    $delay					= intval( $MOD_FPSS_CONFIG['delay'] );
    $speed					= intval( $MOD_FPSS_CONFIG['speed'] );
    $width					= intval( $MOD_FPSS_CONFIG['width'] );
	$height					= intval( $MOD_FPSS_CONFIG['height'] );
	
	$show_title 			= intval($MOD_FPSS_CONFIG['show_title'] );
    $show_section_title 	= intval($MOD_FPSS_CONFIG['show_section_title'] );
    $show_category_title 	= intval($MOD_FPSS_CONFIG['show_category_title'] );
    $seperator 				= trim($MOD_FPSS_CONFIG['seperator'] );
    $show_introtext			= intval($MOD_FPSS_CONFIG['show_introtext'] );
    $show_readmore		 	= intval($MOD_FPSS_CONFIG['show_readmore'] );
	
	// FIND WHAT CONTENT ITEMS WE CAN SEE
	$query = "SELECT a.id, a.introtext, a.title, a.sectionid, a.catid, s.title as stitle, cc.title as ctitle"
	. "\n FROM #__content AS a"
	. "\n INNER JOIN #__categories AS cc ON cc.id = a.catid"
	. "\n INNER JOIN #__sections AS s ON s.id = a.sectionid"
	. "\n WHERE ( a.state = 1 AND a.sectionid > 0 )"
	. "\n AND ( a.publish_up = '$nullDate' OR a.publish_up <= '$now' )"
	. "\n AND ( a.publish_down = '$nullDate' OR a.publish_down >= '$now' )"
	. ( $access ? "\n AND a.access <= $my->gid AND cc.access <= $my->gid AND s.access <= $my->gid" : '' )
	. "\n AND s.published = 1"
	. "\n AND cc.published = 1"
	. "\n ORDER BY a.created DESC"
	; 
	$database->setQuery( $query );
	$contents_tmp = $database->loadObjectList();
	$okItems_tmp = array();
	$titleTextArray = array();
	$introTextArray = array();
	$sectionTitleArray = array();
	$categoryTitleArray = array();
	foreach ($contents_tmp as $content_tmp) {
		$okItems_tmp[] = $content_tmp->id;
		$titleTextArray[$content_tmp->id] = $content_tmp->title;
		$introTextArray[$content_tmp->id] = $content_tmp->introtext;
		$sectionTitleArray[$content_tmp->id] = $content_tmp->stitle;
		$categoryTitleArray[$content_tmp->id] = $content_tmp->ctitle;
	}	
	$okItems = implode(",", $okItems_tmp);
	
	// ORDERING
	$orderBy = ($MOD_FPSS_CONFIG['random']==1)?"\n ORDER BY RAND()":"\n ORDER BY ordering ";
	
	// FIND WHAT SLIDES WE CAN SEE
	$query = "SELECT *"
	. "\n FROM "._FPSS_TABLE_IMAGES
	. "\n WHERE state = 1"
	. "\n AND ( publish_up = '$nullDate' OR publish_up <= '$now' )"
	. "\n AND ( publish_down = '$nullDate' OR publish_down >= '$now' )"
	//. "\n AND menu IN ( $okItems )"
	. $orderBy
	;
	$database->setQuery( $query );
	$images = $database->loadObjectList();

	if ($database->getErrorNum()) {
		echo $database->stderr();
		return false;
	}
	

// ------------------------------------ FPSS JS ------------------------------------ //
$jsoutput = '
/*
// "Frontpage Slideshow" for Joomla! 1.0.x - Version 1.1
// Copyright (c) 2006 - 2007 JoomlaWorks.gr - http://www.joomlaworks.gr
// This code cannot be redistributed without permission from http://www.joomlaworks.gr/
// More info at: http://www.joomlaworks.gr/
// Developers: Fotis Evangelou - George Chouliaras
// ***Last update: February 9th, 2007***
*/

// Parameters
var speed_delay = '.$delay.'; // adjust delay length here, in miliseconds
var slide_speed = '.$speed.'; // adjust fade duration here, in miliseconds

// Don\'t change anything below this point!
var autoslide = true;
var slideOuter = "slide-wrapper";
var slideLoading = "slide-loading";
var slideClass = "slide";
var naviClass = "navi";
var activeSuffix = "-active";

// Effect handle
var isShowing = 0;
var slides;
var navis;
var fx1 = new Array();
var firstDelay = false;
var pauseFlag = false;
var timer;
var playButton;

function initFrontpageSlideshow() {
	displayloading = document.getElementById(slideLoading);
	if (displayloading) displayloading.style.display = "none";
	else return;
	displayslide = document.getElementById(slideOuter);
	if (displayslide) displayslide.style.display = "block";
	
	if (readCookie("com_jw_fpss") == "true") autoslide = true;
	else if (readCookie("com_jw_fpss") == "false") autoslide = false;	
	playButton = document.getElementById(\'playButton\');
	if (autoslide) { showPauseButton(); }
	else { showPlayButton(); }

	slides = document.getElementsByClassName(slideClass);
	navis = document.getElementsByClassName(naviClass);
	
	if (slides.length == 0 || navis.length == 0) return;
	
	for (i = 0; i < slides.length; ++i) {
		fx1[i] = new fx.Combo(slides[i], { opacity: true, width: false, duration: slide_speed, height: false, toggle: false });
		navis[i].onclick = function() {
			current = null;
			for (j = 0; j < navis.length; ++j) {
				if (this == navis[j]) current = j;
			}
			if (current != isShowing) {
				fx1[isShowing].clearTimer();
				if (fx1[isShowing].el.offsetHeight) fx1[isShowing].hide();
				fx1[current].toggle();
				navis[isShowing].className = naviClass;
				navis[current].className = naviClass + activeSuffix;
				isShowing = current;
				clearSlide();
			}
			
			return false;
		}
		if (i != 0) {
			fx1[i].hide();
		} else {
			navis[i].className = naviClass + activeSuffix;
		}
	}
}

function showPauseButton() {
	createCookie("com_jw_fpss", "true");
	playButton.innerHTML = "Pause"; // change "Pause" label here
	playButton.title = "Pause"; // change "Pause" label here
	pauseFlag = false;
	autoSlide();
}

function showPlayButton() {
	createCookie("com_jw_fpss", "false");
	playButton.innerHTML = "Play"; // change "Play" label here
	playButton.title = "Play"; // change "Play" label here
	pauseFlag = true;
	clearTimeout(timer);
	firstDelay = false;
}

function showNext() {
	if (slides.length <= 1) return;
	fx1[isShowing].clearTimer();
	if (fx1[isShowing].el.offsetHeight) fx1[isShowing].hide();
	navis[isShowing].className = naviClass;
	if (isShowing == slides.length - 1) {
		fx1[0].toggle();
		isShowing = 0;
	} else {
		fx1[++isShowing].toggle();
	}
	navis[isShowing].className = naviClass + activeSuffix;
}

function showPrev() {
	if (slides.length <= 1) return;
	fx1[isShowing].clearTimer();
	if (fx1[isShowing].el.offsetHeight) fx1[isShowing].hide();
	navis[isShowing].className = naviClass;
	if (isShowing == 0) {
		fx1[slides.length - 1].toggle();
		isShowing = slides.length - 1;
	} else {
		fx1[--isShowing].toggle();
	}
	navis[isShowing].className = naviClass + activeSuffix;
}

function autoSlide() {
	if (!pauseFlag) {
		timer = setTimeout(\'autoSlide()\', speed_delay);
		if (!firstDelay) firstDelay = true;
		else showNext();
	}
}

function clearSlide() {
	if (!pauseFlag) {
		clearTimeout(timer);
		firstDelay = false;
		autoSlide();
	}
}

function playButtonClicked() {
	if (pauseFlag) showPauseButton();
	else showPlayButton();
}

// Cookie handle
function createCookie(name,value,days) {
  if (days) {
    var date = new Date();
    date.setTime(date.getTime()+(days*24*60*60*1000));
    var expires = "; expires="+date.toGMTString();
  }
  else expires = "";
  document.cookie = name+"="+value+expires+"; path=/";
}
function readCookie(name) {
  var nameEQ = name + "=";
  var ca = document.cookie.split(\';\');
  for(var i=0;i < ca.length;i++) {
    var c = ca[i];
    while (c.charAt(0)==\' \') c = c.substring(1,c.length);
    if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
  }
  return null;
}

// Load everything up
function fpssinit() {
    if (arguments.callee.done) return;
    arguments.callee.done = true;
    if (_timer) clearInterval(_timer);
	initFrontpageSlideshow();
};
if (document.addEventListener) {
    document.addEventListener("DOMContentLoaded", fpssinit, false);
}
/*@cc_on @*/
/*@if (@_win32)
    document.write("<script id=__ie_onload_fpss defer src=javascript:void(0)><\/script>");
    var scriptFPSS = document.getElementById("__ie_onload_fpss");
    scriptFPSS.onreadystatechange = function() {
        if (this.readyState == "complete") {
            fpssinit();
        }
    };
/*@end @*/
if (/WebKit/i.test(navigator.userAgent)) {
    var _timer = setInterval(function() {
        if (/loaded|complete/.test(document.readyState)) {
            fpssinit();
        }
    }, 10);
}
window.onload = fpssinit;

// end
';
$jsfpss = fopen("modules/mod_fpslideshow/mod_fpslideshow.js",'w');
fwrite($jsfpss,$jsoutput);
fclose($jsfpss);
// ------------------------------------ FPSS JS ------------------------------------ //
?>
<!-- JoomlaWorks "Frontpage Slideshow" for Joomla 1.0.x (v1.1) -->
<link href="modules/mod_fpslideshow/mod_fpslideshow.css" rel="stylesheet" type="text/css"/>
<style type="text/css" media="screen">
	#fpss-container {width:<?php echo $width; ?>px;}
	#fpss-slider, #slide-loading, .slide {width:<?php echo $width; ?>px;height:<?php echo $height; ?>px;}
	#slide-outer, #slide-outer .slide-inner {height:<?php echo $height; ?>px;}
</style>
<!--[if lt IE 7]>
<style type="text/css" media="screen">
	html {filter:expression(document.execCommand("BackgroundImageCache", false, true));}
</style>
<![endif]-->
<script language="javascript" type="text/javascript" src="modules/mod_fpslideshow/prototype.lite.js"></script>
<script language="javascript" type="text/javascript" src="modules/mod_fpslideshow/moo.fx.js"></script>
<script language="javascript" type="text/javascript" src="modules/mod_fpslideshow/moo.fx.pack.js"></script>
<script language="javascript" type="text/javascript" src="modules/mod_fpslideshow/mod_fpslideshow.js"></script>
<div id="fpss-container">
  <div id="fpss-slider">
    <div id="slide-loading"></div>
    <div id="slide-wrapper">
      <div id="slide-outer">
<?php 
	// Start loop
	$div_id = 1;
    foreach ($images as $image) {
    	
    // CHECK WHAT CONTENT ITEMS WE CAN SEE
    if($image->menu!=0) {
    	if(!in_array($image->menu,$okItems_tmp)) continue;
    }

    // SEF links
    if($image->clink!="") { 
       $link = $image->clink;
    } elseif($image->menu!=0) {
       // GET ITEMID
       $Itemid = $mainframe->getItemid( $image->menu, 0, 0, $bs, $bc, $gbs );
	   $link = sefRelToAbs( 'index.php?option=com_content&task=view&id='.$image->menu.'&Itemid='.$Itemid );
    } elseif($image->menu2!=0) {
       $database->setQuery("SELECT link, name FROM #__menu"
          . "\nWHERE id='$image->menu2'"
          . "\nLIMIT 1");
       $menu2array = $database->loadRow();
       $link = sefRelToAbs( $menu2array[0]."&Itemid=".$image->menu2 ); 
       $menu2name = $menu2array[1];
    }	

// ------------------------------------------
// Display Slide
// ------------------------------------------

   //IF LINK TO CONTENT ITEM
   if($image->menu!=0) {
   	
	 // GET TITLE OF CONTENT
	 $titleContent = $titleTextArray[$image->menu];
	 // GET INTROTEXT AND REMOVE ANY MAMBOT TAGS
	 $introtext = preg_replace("#{(.*?)}#s","",$introTextArray[$image->menu]);
	 // GET TITLE OF CATEGORY
	 $titleCategory = $categoryTitleArray[$image->menu];
	 // GET TITLE OF SECTION
	 $titleSection = $sectionTitleArray[$image->menu]; 
	 // if character limitation is defined
	 if ($chars) { 
	   if(function_exists("mb_string")) {
	 		$introtext = mb_substr($introtext, 0, $chars).'...'; 
		} else {
	    	$introtext = substr($introtext, 0, $chars).'...';
		}
	 }
	 // if word limitation is defined
	 if ($words) {
		$word_arr = str_word_count($introtext, 2);
		$c = 0;
		foreach ($word_arr AS $k => $v) {
			if ($c == $words) {
				if(function_exists("mb_string")) {
					$introtext = mb_substr($introtext, 0, $k).'...';
				} else {
					$introtext = substr($introtext, 0, $k).'...';
				}
				break;
			}
			$c++;
		}
	 } 
	 // some more cleanup
	 $introtext = preg_replace("/<img.+?>/", "", $introtext); // hide images
   	
     $html = "<div class=\"slide\">\n<div class=\"slide-inner\">\n<a href=".$link."><img src=\"".$image->path."\" /></a>\n<div class=\"fpss_introtext\">";
     if ($show_title) {
       $html .= "<h1><a href=".$link.">".$titleContent."</a></h1>";
     }
     if ($show_section_title || $show_category_title) {
	  $html .= '<h2>';
	  if ($show_section_title) {
		 $html .= $titleSection;
		 if ($show_category_title) { $html .= ' '.$seperator.' '.$titleCategory; }
	  } else {
		 if ($show_category_title) { $html .= $titleCategory;}
	  }
	  $html .= '</h2>';
     }
     if ($show_introtext) {	
       $html .= '<p>'.$introtext.'</p>';
     }
     if ($show_readmore) {
	  $html .= "<a class=\"readon\" href=".$link.">"._MORE."</a>";
     }
     $html .= "</div>\n</div>\n</div>\n";
     
   }
   
   // IF LINK TO MENU ITEM
   elseif ($image->menu2!=0) {
   	 $introtext = $image->ctext;
	 if ($chars) { 
	   if(function_exists("mb_string")) {
	 	$introtext = mb_substr($introtext, 0, $chars).'...';
		} else {
	    $introtext = substr($introtext, 0, $chars).'...';
		}
	 }
	 // if word limitation is defined
	 if ($words) {
		$word_arr = str_word_count($introtext, 2);
		$c = 0;
		foreach ($word_arr AS $k => $v) {
			if ($c == $words) {
				if(function_exists("mb_string")) {
				  $introtext = mb_substr($introtext, 0, $k).'...';
				} else {
				  $introtext = substr($introtext, 0, $k).'...';
				}
				break;
			}
			$c++;
		}
	 } 
	 $introtext = preg_replace("/<img.+?>/", "", $introtext); // hide images
   	
     $html = "<div class=\"slide\">\n<div class=\"slide-inner\">\n<a href=".$link."><img src=\"".$image->path."\" /></a>\n<div class=\"fpss_introtext\">";
	 // SAME TO SHOW MENU ITEM NAME
     if ($show_title) {
       $html .= "<h1><a href=".$link.">".$menu2name."</a></h1>";
     }
	 // SAME TO SHOW CUSTOM TEXT
     if ($show_introtext) {
       $html .= '<p>'.$introtext.'</p>';
     }
     if ($show_readmore) {
	  $html .= "<a class=\"readon\" href=".$link.">"._MORE."</a>";
     }
     $html .= "</div>\n</div>\n</div>\n";
   	
   }
   
   // IF LINK TO URL
   elseif ($image->clink!="") {
   	
   	 $introtext = $image->ctext;
	 if ($chars) { 
	   if(function_exists("mb_string")) {
	 	$introtext = mb_substr($introtext, 0, $chars).'...'; 
	   } else {
	    $introtext = substr($introtext, 0, $chars).'...';
	   }
	 }
	 // if word limitation is defined
	 if ($words) {
		$word_arr = str_word_count($introtext, 2);
		$c = 0;
		foreach ($word_arr AS $k => $v) {
			if ($c == $words) {
				if(function_exists("mb_string")) {
				  $introtext = mb_substr($introtext, 0, $k).'...';
				} else {
				  $introtext = substr($introtext, 0, $k).'...';
				}
				break;
			}
			$c++;
		}
	 } 
	 $introtext = preg_replace("/<img.+?>/", "", $introtext); // hide images
   	
     $html = "<div class=\"slide\">\n<div class=\"slide-inner\">\n<a href=".$link."><img src=\"".$image->path."\" /></a>\n<div class=\"fpss_introtext\">";
	 
	 // SAME TO SHOW SLIDES NAME
     if ($show_title) {
       $html .= "<h1><a href=".$link.">".$image->name."</a></h1>";
     }
	 // SAME TO SHOW CUSTOM TEXT
     if ($show_introtext) {
       $html .= '<p>'.$image->ctext.'</p>';
     }
     if ($show_readmore) {
	  $html .= "<a href=".$link." class=\"readon\">"._MORE."</a>";
     }
     $html .= "</div>\n</div>\n</div>\n";
   	
   }

   //$image->name
   echo $html; 

   $div_id++;
   }
   // End loop
?>
      </div>
    </div>
  </div>
  <div id="navi-outer">
    <div class="ul_container">
      <ul>
        <li>
			<a href="#prev" onclick="showPrev();clearSlide();" title="<?php echo _FPSS_MOD_PREV; ?>">&laquo;</a>
		</li>
        <?php
		$fpss_nav_buttons = $div_id++;
		for ($i=1;$i<$fpss_nav_buttons;++$i) {
		?>
        <li>
			<a class="navi" href="#<?php echo ($i < 10) ? "0".$i : $i; ?>"><?php echo ($i < 10) ? "0".$i : $i; ?></a>
		</li>
        <?php } ?>
        <li><a href="#next" onclick="showNext();clearSlide();" title="<?php echo _FPSS_MOD_NEXT; ?>">&raquo;</a></li>
        <li><a href="#play/pause" onclick="playButtonClicked();return false;" id="playButton">Pause</a></li>
      </ul>
    </div>
  </div>
</div>
<!-- JoomlaWorks "Frontpage Slideshow" for Joomla 1.0.x (v1.1) -->
<?php    
} else { echo "<h1>Please, install JoomlaWorks \"Frontpage Slideshow\" Component!</h1>"; }
?>
