<?php

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( $mainframe->getPath( 'front_html', 'com_mamboezine' ) );
if (file_exists('language/'.$mosConfig_lang.'.php') AND file_exists('components/com_mamboezine/language/'.$mosConfig_lang.'.php'))
	require_once('components/com_mamboezine/language/'.$mosConfig_lang.'.php');
else
	require_once('components/com_mamboezine/language/english.php');
include_once( 'components/com_mamboezine/mamboezine.css.html' );

$now        = date( 'Y-m-d H:i:s', time() + $mosConfig_offset * 60 * 60 );
$noauth     = !$mainframe->getCfg( 'shownoauth' );

// Editor usertype check
$access = new stdClass();
$access->canEdit 	= $acl->acl_check( 'action', 'edit', 'users', $my->usertype, 'content', 'all' );
$access->canEditOwn = $acl->acl_check( 'action', 'edit', 'users', $my->usertype, 'content', 'own' );
$access->canPublish = $acl->acl_check( 'action', 'publish', 'users', $my->usertype, 'content', 'all' );

// cache activation
$cache =& mosCache::getCache( 'com_mamboezine' );

// Parameters
$params = new stdClass();
if ( $Itemid ) {
	$menu = new mosMenu( $database );
	$menu->load( $Itemid );
	$params =& new mosParameters( $menu->params );
} else {
	$menu = "";
	$params =& new mosParameters( '' );
}

// Get Parameters
$params->def( 'pageclass_sfx', $params->get('pageclass_sfx', '') );
$params->def( 'link_titles', $params->get('link_titles', $mainframe->getCfg( 'link_titles' )) );
$params->def( 'readmore', $params->get('readmore', $mainframe->getCfg( 'readmore' )) );
$params->def( 'rating', $params->get('rating', $mainframe->getCfg( 'vote' )) );
$params->def( 'author', $params->get('author', !$mainframe->getCfg( 'hideAuthor' )) );
$params->def( 'createdate', $params->get('createdate', !$mainframe->getCfg( 'hideCreateDate' )) );
$params->def( 'modifydate', $params->get('modifydate', !$mainframe->getCfg( 'hideModifyDate' )) );
$params->def( 'pdf', $params->get('pdf', !$mainframe->getCfg( 'hidePdf' )) );
$params->def( 'print', $params->get('print', !$mainframe->getCfg( 'hidePrint' )) );
$params->def( 'email', $params->get('email', !$mainframe->getCfg( 'hideEmail' )) );
$params->def( 'icons', $params->get('icons', $mainframe->getCfg( 'icons' )) );

// Other Params
$params->def( 'item_title', 1 );
$pageid = $params->get('page_id') ? $params->get('page_id') : 1;

// Dynamic Page Title
if ($menu) {
	$mainframe->setPageTitle( $menu->name );
}

$database->setQuery( "SELECT * FROM #__mamboezine_page WHERE id = '$pageid' LIMIT 0,1" );
$database->loadObject( $page );
if ( $page->show_title AND ($page->page_title <> '') ) {
	?>
	<h3 class="page_title<?php echo $params->get( 'pageclass_sfx' ); ?>">
	<?php echo $page->page_title; ?></h3>
	<?php
}

$query = "SELECT * FROM #__mamboezine_category WHERE pageid = '$pageid' ORDER BY `ordering`";
$database->setQuery( $query );
$rows = $database->loadObjectList();

foreach ($rows AS $row) {
	// show frontpage item only or not?
	if ($row->frontpage_only <> 0) {
		$frontpage_item_only_query = "\n INNER JOIN #__content_frontpage AS f ON f.content_id = a.id";
	} else {
		$frontpage_item_only_query = '';
	}

	// query records
	$query = "SELECT a.*, ROUND( v.rating_sum / v.rating_count ) AS rating, v.rating_count, u.name AS author, u.usertype, s.name AS section, cc.name AS category, g.name AS groups"
	. "\n FROM #__content AS a"
	. $frontpage_item_only_query
	. "\n INNER JOIN #__categories AS cc ON cc.id = a.catid"
	. "\n INNER JOIN #__sections AS s ON s.id = a.sectionid"
	. "\n LEFT JOIN #__users AS u ON u.id = a.created_by"
	. "\n LEFT JOIN #__content_rating AS v ON a.id = v.content_id"
	. "\n LEFT JOIN #__groups AS g ON a.access = g.id"
	. "\n WHERE a.state = '1'"
	. ( $noauth ? "\n AND a.access <= '". $my->gid ."'" : '' )
	. "\n AND ( publish_up = '0000-00-00 00:00:00' OR publish_up <= '$now'  )"
	. "\n AND ( publish_down = '0000-00-00 00:00:00' OR publish_down >= '$now' )"
	. "\n AND a.catid = '" . $row->catid . "'"
	. "\n ORDER BY a.created DESC"
	;
	$database->setQuery( $query );
	$news = $database->loadObjectList();
	$columns = $row->columns;
	if ( $columns == 0 ) {
		$columns = 1;
	}
	$intros = $row->intros;
	$links = $row->links;
	$total = count($news);
	$params->set( 'intro_only', $row->intro_only );
	// needed to reduce queries used by getItemid
	$ItemidCount['bs'] 		= $mainframe->getBlogSectionCount();
	$ItemidCount['bc'] 		= $mainframe->getBlogCategoryCount();
	$ItemidCount['gbs'] 	= $mainframe->getGlobalBlogSectionCount();

	// Page Output
	$database->setQuery( "SELECT `id`,`name` FROM #__categories WHERE id = '$row->catid'" );
	$cat = $database->loadObjectList();
	if ($row->img_cat_title <> '') {
		echo '<div><img src="'. $row->img_cat_title .'" border="0" alt="'. $cat[0]->name .'" /></div>';
	} else {
		echo '<div class="componentheading'. $params->get( 'pageclass_sfx' ) .'">'. $cat[0]->name .'</div>';
	}
	// checks to see if there are any items to display
	if ( $total ) {
		$col_with = 100 / $columns;			// width of each column
		$width = 'width="'. $col_with .'%"';
		echo '<table class="blog' . $params->get( 'pageclass_sfx' ) . '" cellpadding="0" cellspacing="0">';
		$i = 0;
		if ( $intros ) {
			echo '<tr>';
			echo '<td valign="top">';
			echo '<table width="100%" cellpadding="0" cellspacing="0">';
			// intro story output
			for ( $z = 0; $z < $intros; $z++ ) {
				if ( $i >= $total ) {
					// stops loop if total number of items is less than the number set to display as intros
					break;
				}
				if ( !( $z % $columns ) || $columns == 1 ) {
					echo '<tr>';
				}
				echo '<td valign="top" '. $width .'>';
				// outputs either intro or only a link
				if ( $z < $intros ) {
					show( $news[$i], $params, $gid, $access, $ItemidCount );
				} else {
					echo '</td>';
					echo '</tr>';
					break;
				}
				echo '</td>';
				if ( !( ( $z + 1 ) % $columns ) || $columns == 1 ) {
					echo '</tr>';
				}
				$i++;
			}
			// this is required to output a final closing </tr> tag when the number of items does not fully
			// fill the last row of output - a blank column is left
			if ( $intros % $columns ) {
				echo '</tr>';
			}
			echo '</table>';
			echo '</td>';
			echo '</tr>';
		}
		// Links output
		if ( $links && ( $i < $total ) ) {
			echo '<tr>';
			echo '<td valign="top" width="100%">';
			if ($intros == 0) $show_more = 0; else $show_more = 1;
			if ($row->img_in_link == 0) $show_img = 0; else $show_img = 1;
			HTML_mamboezine::showLinks( $news, $links, $total, $i, $show_more, $show_img, $ItemidCount );
			echo '</td>';
			echo '</tr>';
		}
		echo '</table><br/>';

		// loads the link for Category name
		$query = "SELECT a.id"
		. "\n FROM #__menu AS a"
		. "\n WHERE a.componentid = ". $cat[0]->id.""
		;
		$database->setQuery( $query );
		$_Itemid = $database->loadResult();
		$link = sefRelToAbs( 'index.php?option=com_content&amp;task=blogcategory&amp;id='. $cat[0]->id .'&amp;Itemid='.$_Itemid );
		if ($row->img_cat_more <> '') {
			echo '<div class="more_category_news'. $params->get( 'pageclass_sfx' ) .'"><a href="'. $link .'" title="'. str_replace('%CAT_NAME%', $cat[0]->name, _MORE_CATEGORY_NEWS) .'"><img src="'. $row->img_cat_more .'" border="0" alt="'. str_replace('%CAT_NAME%', $cat[0]->name, _MORE_CATEGORY_NEWS) .'" /></a></div>';
		} else {
			echo '<div class="more_category_news'. $params->get( 'pageclass_sfx' ) .'"><a href="'. $link .'" title="'. str_replace('%CAT_NAME%', $cat[0]->name, _MORE_CATEGORY_NEWS) .'">'. str_replace('%CAT_NAME%', $cat[0]->name, _MORE_CATEGORY_NEWS) .'</a></div>';
		}
	} else {
		// Generic blog empty display
		echo _EMPTY_BLOG;
	}
	echo '<br/>';
}

function show( $news, $params, $gid, &$access, $option, $ItemidCount=NULL ) {
	global $database, $mainframe, $Itemid;
	global $mosConfig_live_site, $mosConfig_absolute_path;
	global $options, $cache, $noauth;

	if ( $access->canEdit ) {
		if ( $news->id === null || $news->access > $gid ) {
			mosNotAuth();
			return;
		}
	} else {
		if ( $news->id === null || $news->state == 0 ) {
			mosNotAuth();
			return;
		}
		if ( $news->access > $gid ) {
			if ( $noauth ) {
				mosNotAuth();
				return;
			} else {
				if ( !( $params->get( 'intro_only' ) ) ) {
					mosNotAuth();
					return;
				}
			}
		}
	}

	// show intro text only or not
	$news->text = $news->introtext. ( $params->get( 'intro_only' ) ? '' : chr(13) . chr(13) . $news->fulltext);

	// show {mosimage} in intro or not
	global $row;
	if ( $params->get( 'intro_only' ) AND !$row->img_in_intro ) {
		$news->text = str_replace('{mosimage}', '', $news->text);
	}

	// record the hit
	if ( !$params->get( 'intro_only' ) ) {
		$obj = new mosContent( $database );
		$obj->hit( $news->id );
	}

	$cache->call( 'HTML_mamboezine::show', $news, $params, $access, 0, $option, $ItemidCount );
}

?>
