<?php

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( $GLOBALS['mosConfig_absolute_path'] . '/includes/HTML_toolbar.php' );

class HTML_mamboezine {

	/**
	* Display links to content items
	*/
	function showLinks( &$rows, $links, $total, $i=0, $show, $img, $ItemidCount ) {
		global $mainframe, $mosConfig_live_site, $mosConfig_absolute_path, $params, $columns;
		if ( $show ) {
			echo '<div class="blog_more'. $params->get( 'pageclass_sfx' ) .'">';
			?>
			<strong>
			<?php echo _MORE; ?>
			</strong>
			<?php
			echo '</div>';
		}
		if ($img <> 0) {
			$col_with = 100 / $columns;			// width of each column
			$width = 'width="'. $col_with .'%"';
			echo '<table width="100%" cellpadding="3" cellspacing="3" border="0">';
			for ( $z = 0; $z < $links; $z++ ) {
				if ( $i >= $total ) {
					// stops loop if total number of items is less than the number set to display as intro + leading
					break;
				}
				// needed to reduce queries used by getItemid
				$_Itemid = $mainframe->getItemid( $rows[$i]->id, 0, 0, $ItemidCount['bs'], $ItemidCount['bc'], $ItemidCount['gbs']  );
				$link = sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id='. $rows[$i]->id .'&amp;Itemid='. $_Itemid );

				if ( !( $z % $columns ) || $columns == 1 ) {
					echo '<tr>';
				}
				echo '<td '. $width .'>';
				// show links with the first image of news item
				$images = explode( "\n", $rows[$i]->images );
				$image = trim( $images[0] );
				$image_code = '<img src="'. $mosConfig_live_site .'/images/M_images/arrow.png" border="0" align="absmiddle" />';
				if ($image) {
				  $temp = explode( '|', trim( $image ) );
				  if (isset($temp[0]) AND ($temp[0] != '')) {
				    $img_size = @getimagesize( $mosConfig_absolute_path .'/images/stories/'. $temp[0] );
					if ($img_size[0] > 50) {
						$new_x = 50;
						$size_ratio = (double) (50 / $img_size[0]);
						$new_y = (int) ($img_size[1] * $size_ratio);
					} else {
						$new_x = $img_size[0];
						$new_y = $img_size[1];
					}
					$size = "width=\"$new_x\" height=\"$new_y\"";
				    $image_code = '<img src="'. $mosConfig_live_site .'/images/stories/'. $temp[0] .'" '. $size;
				    $image_code .= ' align="absmiddle" alt="'. $temp[2] .'" title="'. $temp[2] .'" border="0" />';
				  }
				}
			    echo '<table width="100%" cellspacing="1" cellpadding="1" border="0"><tr><td width="25%" align="right"><a href="' . $link . '">' . $image_code . '</a></td><td width="75%" align="left"><a href="' . $link . '">' . $rows[$i]->title . '</a></td></tr></table>';
				echo '</td>';
				if ( !( ( $z + 1 ) % $columns ) || $columns == 1 ) {
					echo '</tr>';
				}
				unset($image_code);
				unset($temp);
				unset($image);
				unset($images);
				$i++;
			}
			// this is required to output a final closing </tr> tag when the number of items does not fully
			// fill the last row of output - a blank column is left
			if ( $links % $columns ) {
				echo '</tr>';
			}
			echo '</table>';
		} else {
		?>
			<ul>
			<?php
			for ( $z = 0; $z < $links; $z++ ) {
				if ( $i >= $total ) {
					// stops loop if total number of items is less than the number set to display as intro + leading
					break;
				}
				// needed to reduce queries used by getItemid
				$_Itemid = $mainframe->getItemid( $rows[$i]->id, 0, 0, $ItemidCount['bs'], $ItemidCount['bc'], $ItemidCount['gbs']  );
				$link = sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id='. $rows[$i]->id .'&amp;Itemid='. $_Itemid );
				?>
				<li>
				<a class="blogsection" href="<?php echo $link; ?>">
				<?php echo $rows[$i]->title; ?>
				</a>
				</li>
				<?php
				$i++;
			}
			?>
			</ul>
		<?php
		}
	}

	/**
	* Show a content item
	* @param object An object with the record data
	* @param boolean If <code>false</code>, the print button links to a popup window.  If <code>true</code> then the print button invokes the browser print method.
	*/
	function show( $row, $params, $access, $page=0, $option, $ItemidCount=NULL ) {
		global $mainframe, $my, $hide_js;
		global $mosConfig_sitename, $Itemid, $mosConfig_live_site, $task;
		global $_MAMBOTS;

		$mainframe->appendMetaTag( 'description', $row->metadesc );
		$mainframe->appendMetaTag( 'keywords', $row->metakey );

		$gid 		= $my->gid;
		$_Itemid 	= $Itemid;
		$link_on 	= '';
		$link_text 	= '';

		// process the new bots
		$_MAMBOTS->loadBotGroup( 'content' );
		$results = $_MAMBOTS->trigger( 'onPrepareContent', array( &$row, &$params, $page ), true );

		// adds mospagebreak heading or title to <site> Title
		if ( @$row->page_title ) {
			$mainframe->SetPageTitle( $row->title .': '. $row->page_title );
		}

		// determines the link and link text of the readmore button
		if ( $params->get( 'intro_only' ) ) {
			// checks if the item is a public or registered/special item
			if ( $row->access <= $gid ) {
				if ($task != "view") {
					$_Itemid = $mainframe->getItemid( $row->id, 0, 0, $ItemidCount['bs'], $ItemidCount['bc'], $ItemidCount['gbs'] );
				}
				$link_on = sefRelToAbs("index.php?option=com_content&amp;task=view&amp;id=".$row->id."&amp;Itemid=".$_Itemid);
				if ( strlen( trim( $row->fulltext ) )) {
					$link_text = _READ_MORE;
				}
			} else {
				$link_on = sefRelToAbs("index.php?option=com_registration&amp;task=register");
				if (strlen( trim( $row->fulltext ) )) {
					$link_text = _READ_MORE_REGISTER;
				}
			}
		}

		$no_html = mosGetParam( $_REQUEST, 'no_html', null);

		if ( $params->get( 'item_title' ) || $params->get( 'pdf' )  || $params->get( 'print' ) || $params->get( 'email' ) ) {
			// link used by print button
			$print_link = $mosConfig_live_site. '/index2.php?option=com_content&amp;task=view&amp;id='. $row->id .'&amp;Itemid='. $Itemid .'&amp;pop=1&amp;page='. @$page;
			?>
			<table width="100%" class="contentpaneopen<?php echo $params->get( 'pageclass_sfx' ); ?>">
			<tr>
				<?php
				// displays Item Title
				HTML_mamboezine::Title( $row, $params, $link_on, $access );

				// displays PDF Icon
				HTML_mamboezine::PdfIcon( $row, $params, $link_on, $hide_js );

				// displays Print Icon
				mosHTML::PrintIcon( $row, $params, $hide_js, $print_link );

				// displays Email Icon
				HTML_mamboezine::EmailIcon( $row, $params, $hide_js );
				?>
			</tr>
			</table>
			<?php
 		} else if ( $access->canEdit ) {
 			// edit icon when item title set to hide
 			?>
			<table class="contentpaneopen<?php echo $params->get( 'pageclass_sfx' ); ?>">
 			<tr>
 				<td>
 				<?php
 				HTML_mamboezine::EditIcon( $row, $params, $access );
 				?>
 				</td>
 			</tr>
 			</table>
 			<?php
  		}

		if ( !$params->get( 'intro_only' ) ) {
			$results = $_MAMBOTS->trigger( 'onAfterDisplayTitle', array( &$row, &$params, $page ) );
			echo trim( implode( "\n", $results ) );
		}

		$results = $_MAMBOTS->trigger( 'onBeforeDisplayContent', array( &$row, &$params, $page ) );
		echo trim( implode( "\n", $results ) );
		?>

		<table class="contentpaneopen<?php echo $params->get( 'pageclass_sfx' ); ?>">
		<?php
		// displays Author Name
		HTML_mamboezine::Author( $row, $params );

		// displays Created Date
		HTML_mamboezine::CreateDate( $row, $params );

		// displays Urls
		HTML_mamboezine::URL( $row, $params );
		?>
		<tr>
			<td valign="top" colspan="2">
			<?php
			// displays Table of Contents
			HTML_mamboezine::TOC( $row );

			// displays Item Text
			echo $row->text;
			?>
			</td>
		</tr>
		<?php

		// displays Modified Date
		HTML_mamboezine::ModifiedDate( $row, $params );

		// displays Readmore button
		HTML_mamboezine::ReadMore( $params, $link_on, $link_text );
		?>
		</table>
		<?php
		$results = $_MAMBOTS->trigger( 'onAfterDisplayContent', array( &$row, &$params, $page ) );
		echo trim( implode( "\n", $results ) );
	}

	/**
	* Writes PDF icon
	*/
	function PdfIcon( $row, $params, $link_on, $hide_js ) {
		global $mosConfig_live_site;
		if ( $params->get( 'pdf' ) && !$params->get( 'popup' ) && !$hide_js ) {
			$status = 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no';
			$link = $mosConfig_live_site. '/index2.php?option=com_content&amp;do_pdf=1&amp;id='. $row->id;
			if ( $params->get( 'icons' ) ) {
				$image = mosAdminMenus::ImageCheck( 'pdf_button.png', '/images/M_images/', NULL, NULL, _CMN_PDF );
			} else {
				$image = _CMN_PDF .'&nbsp;';
			}
			?>
			<td align="right" width="100%" class="buttonheading">
			<a href="javascript:void window.open('<?php echo $link; ?>', 'win2', '<?php echo $status; ?>');" title="<?php echo _CMN_PDF;?>">
			<?php echo $image; ?>
			</a>
			</td>
			<?php
		}
	}


	/**
	* Writes Email icon
	*/
	function EmailIcon( $row, $params, $hide_js ) {
		global $mosConfig_live_site;
		if ( $params->get( 'email' ) && !$params->get( 'popup' ) && !$hide_js ) {
			$status = 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=400,height=250,directories=no,location=no';
			$link = $mosConfig_live_site .'/index2.php?option=com_content&amp;task=emailform&amp;id='. $row->id;
			if ( $params->get( 'icons' ) ) {
				$image = mosAdminMenus::ImageCheck( 'emailButton.png', '/images/M_images/', NULL, NULL, _CMN_EMAIL );
			} else {
				$image = '&nbsp;'. _CMN_EMAIL;
			}
			?>
			<td align="right" width="100%" class="buttonheading">
			<a href="javascript:void window.open('<?php echo $link; ?>', 'win2', '<?php echo $status; ?>');" title="<?php echo _CMN_EMAIL;?>">
			<?php echo $image; ?>
			</a>
			</td>
			<?php
		}
	}

	/**
	* Writes Title
	*/
	function Title( $row, $params, $link_on, $access ) {
		global $mosConfig_live_site, $Itemid;
		if ( $params->get( 'item_title' ) ) {
			if ( $params->get( 'link_titles' ) && $link_on != '' ) {
				?>
				<td class="contentheading<?php echo $params->get( 'pageclass_sfx' ); ?>" width="100%">
				<a href="<?php echo $link_on;?>" class="contentpagetitle<?php echo $params->get( 'pageclass_sfx' ); ?>">
				<?php echo $row->title;?>
				</a>
				<?php HTML_mamboezine::EditIcon( $row, $params, $access ); ?>
				</td>
				<?php
			} else {
				?>
				<td class="contentheading<?php echo $params->get( 'pageclass_sfx' ); ?>" width="100%">
				<?php echo $row->title;?>
				<?php HTML_mamboezine::EditIcon( $row, $params, $access ); ?>
				</td>
				<?php
			}
		}
	}

	/**
	* Writes Edit icon that links to edit page
	*/
	function EditIcon( $row, $params, $access ) {
		global $mosConfig_live_site, $Itemid, $my;
		if ( $params->get( 'popup' ) ) {
			return;
		}
		if ( $row->state < 0 ) {
			return;
		}
		if ( !$access->canEdit && !( $access->canEditOwn && $row->created_by == $my->id ) ) {
			return;
		}
		$link = 'index.php?option=com_content&amp;task=edit&amp;id='. $row->id .'&amp;Itemid='. $Itemid .'&amp;Returnid='. $Itemid;
		$image = mosAdminMenus::ImageCheck( 'edit.png', '/images/M_images/', NULL, NULL, _E_EDIT );
		?>
		<a href="<?php echo sefRelToAbs( $link ); ?>" title="<?php echo _E_EDIT;?>">
		<?php echo $image; ?>
		</a>
		<?php
		if ( $row->state == 0 ) {
			echo '( '. _CMN_UNPUBLISHED .' )';
		}
		echo '  ( '. $row->groups .' )';
	}

	/**
	* Writes Author name
	*/
	function Author( $row, $params ) {
		global $acl;
		if ( ( $params->get( 'author' ) ) && ( $row->author != "" ) ) {
			$grp = $acl->getAroGroup( $row->created_by );
			$is_frontend_user = $acl->is_group_child_of( intval( $grp->group_id ), 'Public Frontend', 'ARO' );
			$by = $is_frontend_user ? _AUTHOR_BY : _WRITTEN_BY;
		?>
		<tr>
			<td width="70%" align="left" valign="top" colspan="2">
			<span class="small">
			<?php echo $by. ' '.( $row->created_by_alias ? $row->created_by_alias : $row->author ); ?>
			</span>
			&nbsp;&nbsp;
			</td>
		</tr>
		<?php
		}
	}


	/**
	* Writes Create Date
	*/
	function CreateDate( $row, $params ) {
		$create_date = null;
		if ( intval( $row->created ) != 0 ) {
			$create_date = mosFormatDate( $row->created );
		}
		if ( $params->get( 'createdate' ) ) {
			?>
			<tr>
				<td valign="top" colspan="2" class="createdate">
				<?php echo $create_date; ?>
				</td>
			</tr>
			<?php
		}
	}

	/**
	* Writes URL's
	*/
	function URL( $row, $params ) {
		if ( $params->get( 'url' ) && $row->urls ) {
			?>
			<tr>
				<td valign="top" colspan="2">
				<a href="http://<?php echo $row->urls ; ?>" target="_blank">
				<?php echo $row->urls; ?>
				</a>
				</td>
			</tr>
			<?php
		}
	}

	/**
	* Writes TOC
	*/
	function TOC( $row ) {
		if ( @$row->toc ) {
			echo $row->toc;
		}
	}

	/**
	* Writes Modified Date
	*/
	function ModifiedDate( $row, $params ) {
		$mod_date = null;
		if ( intval( $row->modified ) != 0) {
			$mod_date = mosFormatDate( $row->modified );
		}
		if ( ( $mod_date != '' ) && $params->get( 'modifydate' ) ) {
			?>
			<tr>
				<td colspan="2" align="left" class="modifydate">
				<?php echo _LAST_UPDATED; ?> ( <?php echo $mod_date; ?> )
				</td>
			</tr>
			<?php
		}
	}

	/**
	* Writes Readmore Button
	*/
	function ReadMore ( $params, $link_on, $link_text ) {
		if ( $params->get( 'readmore' ) ) {
			if ( $params->get( 'intro_only' ) && $link_text ) {
				?>
				<tr>
					<td align="left" colspan="2">
					<a href="<?php echo $link_on;?>" class="readon<?php echo $params->get( 'pageclass_sfx' ); ?>">
					<?php echo $link_text;?>
					</a>
					</td>
				</tr>
				<?php
			}
		}
	}

}
?>
