<?php

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
$mamboezineVer = 'v1.7 stable';

require_once( $mainframe->getPath( 'admin_html' ) );
if (file_exists($mosConfig_absolute_path.'/language/'.$mosConfig_lang.'.php') AND file_exists($mosConfig_absolute_path.'/components/com_mamboezine/language/'.$mosConfig_lang.'.php'))
	require_once($mosConfig_absolute_path.'/components/com_mamboezine/language/'.$mosConfig_lang.'.php');
else
	require_once($mosConfig_absolute_path.'/components/com_mamboezine/language/english.php');

// get parameters from the URL or submitted form
$cid = mosGetParam( $_REQUEST, 'cid', array(0) );
if (!is_array( $cid )) $cid = array(0);

if ($task <> ''){
	$func = $task;
} elseif ($act <> '') {
	$func = $act;
} elseif (!isset($func)) {
	$func = '';
}

switch ($func) {
	// Page management functions
	case 'managepage':
		showPage( $option );
		break;
	case 'newpage':
	case 'editpage':
		$page_id = isset($pid) ? $pid : $cid[0];
		editPage( $func, $page_id );
		break;
	case 'savepage':
		$params = mosGetParam( $_POST, 'params', '' );
		savePage( $pageid, $menu_name, $page_title, $show_title );
		break;
	case 'delpage':
		removePage( $cid );
		break;
	case 'link_to_menu':
		linkToMenu( $pageid );
		break;
	case 'toggle_show_title':
		toggleShowTitle( $cid[0] );
		break;

	// Category management functions
	case 'managecat':
		$page_id = isset($pid) ? $pid : -1;
		showCategory( $option, $page_id );
		break;
	case 'addcat':
		addCategory( $option, $pageid );
		break;
	case 'add_cat_to_page':
		addCategoryToPage( $cid, $pageid );
		break;
	case 'editcat':
		$cat = isset($catid) ? $catid : $cid[0];
		editCategory( $cat, $pageid );
		break;
	case 'savecat':
		saveCategory( $pageid, $catid, $intros, $links, $columns, $intro_only, $frontpage_only, $img_in_intro, $img_in_link, $img_cat_title, $img_cat_more );
		break;
	case 'delcat':
		removeCategory( $cid, $pageid );
		break;
	case 'toggle_image_intro':
		toggleImageIntro( $cid[0], $pageid );
		break;
	case 'toggle_image_link':
		toggleImageLink( $cid[0], $pageid );
		break;
	case 'toggle_intro_only':
		toggleIntroOnly( $cid[0], $pageid );
		break;
	case 'toggle_frontpage_only':
		toggleFrontpageOnly( $cid[0], $pageid );
		break;
	case 'orderup':
		reorderCategories( $cid[0], $pageid, -1 );
		break;
	case 'orderdown':
		reorderCategories( $cid[0], $pageid, 1 );
		break;
	case 'saveorder':
		saveCategoriesOrder( $cid, $pageid );
		break;

	// Other functions
	case 'editcss':
		editCSS();
		break;
	case 'savecss':
		saveCSS();
		break;
	case 'editlang':
		editLang();
		break;
	case 'savelang':
		saveLang();
		break;
	case 'back':
	case 'cancel':
		if ( (isset($_SERVER[HTTP_REFERER])) AND ($_SERVER[HTTP_REFERER] != '') ) {
			$return_url = $_SERVER[HTTP_REFERER];
		} else {
			$return_url = "index2.php?option=com_mamboezine";
		}
		mosRedirect( $return_url );
		break;
	default:
		mamboezineCredit();
		break;
}

// Functions act with Page Management
function showPage( $option ) {
	global $database, $mainframe, $mosConfig_list_limit;

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );

	// get the total number of records
	$database->setQuery( "SELECT count(*) FROM #__mamboezine_page WHERE 1" );
	$total = $database->loadResult();

	require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	$query = "SELECT * FROM #__mamboezine_page"
	. "\n LIMIT $pageNav->limitstart, $pageNav->limit";
	$database->setQuery( $query );
	$rows = $database->loadObjectList();

	HTML_mamboezine::showP( $rows, $pageNav );
}

function editPage( $func, $pageid ) {
	if ($func == 'editpage') {
		global $database;

		$query = "SELECT * FROM #__mamboezine_page"
		. "\n WHERE id = '$pageid' LIMIT 0,1";
		$database->setQuery( $query );
		$database->loadObject( $row );

		$link_to_menu = mosAdminMenus::MenuSelect();
	} else {
		$row = '';
		$link_to_menu = '';
	}
	HTML_mamboezine::editP( $func, $pageid, $row, $link_to_menu );
}

function savePage( $pageid, $menu_name, $page_title, $show_title ) {
	global $database;
	if ($pageid <> 0) {
		$sql="UPDATE #__mamboezine_page SET `menu_name`='$menu_name',`page_title`='$page_title',`show_title`='$show_title' WHERE `id`='$pageid' LIMIT 1";
	} else {
		$sql="INSERT INTO #__mamboezine_page (`menu_name`,`page_title`,`show_title`) VALUES ('$menu_name','$page_title','$show_title')";
	}
	$database->setQuery( $sql );
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}
	mosRedirect( "index2.php?option=com_mamboezine&act=managepage" );
}

function removePage( $cid ) {
	global $database;

	foreach ($cid AS $page) {
		$sql="DELETE FROM #__mamboezine_page WHERE `id`='$page'";
		$database->setQuery( $sql );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
			exit();
		}
	}

	mosRedirect( "index2.php?option=com_mamboezine&act=managepage" );
}

function linkToMenu( $pageid ) {
	global $database;

	$query = "SELECT menu_name FROM #__mamboezine_page"
	. "\n WHERE id = '$pageid' LIMIT 0,1";
	$database->setQuery( $query );
	$database->loadObject( $menu_data );

	$query = "SELECT id FROM #__components"
	. "\n WHERE `name` = 'Mambo eZine' AND `link` = 'option=com_mamboezine' LIMIT 0,1";
	$database->setQuery( $query );
	$componentid = $database->loadResult();

	$menu 		= mosGetParam( $_POST, 'menuselect', 'mainmenu' );
	$status     = mosGetParam( $_POST, 'published', 0 );

	$row 				= new mosMenu( $database );
	$row->menutype 		= $menu;
	$row->name 			= $menu_data->menu_name;
	$row->type 			= 'components';
	$row->published		= $status;
	$row->componentid	= $componentid;
	$row->link			= 'index.php?option=com_mamboezine';
	if ( mosGetParam( $_POST, 'frontpage', 0 ) ) {
		$row->ordering = -9999;
	} else {
		$row->ordering = 9999;
	}
	$row->params        = 'page_id='.$pageid;

	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();

	mosRedirect( 'index2.php?option=com_menus&menutype=mainmenu&task=edit&id='.$row->id.'&hidemainmenu=1', 'New menu item named `'.$menu_data->menu_name.'` successfully created in `'.$menu.'`' );
}

function toggleShowTitle( $pageid ) {
	global $database;

	$database->setQuery( "SELECT `show_title` FROM #__mamboezine_page WHERE id = '$pageid' LIMIT 0,1" );
	$database->loadObject( $row );
	$new_value = ($row->show_title <> 0) ? 0 : 1;
	
	$database->setQuery( "UPDATE #__mamboezine_page SET `show_title` = '$new_value' WHERE id = '$pageid' LIMIT 1" );
    if (!$database->query()) {
    	echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
	    exit();
	}

	mosRedirect( "index2.php?option=com_mamboezine&act=managepage" );
}

// Functions act with Category Management
function showCategory( $option, $pid = -1 ) {
	global $database, $mainframe, $mosConfig_list_limit;

	if ($pid == -1) {
		$page_id = intval( mosGetParam( $_REQUEST, 'page_id', '1' ) );
	} else {
		$page_id = $pid;
	}
	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );

	// get the total number of records
	$database->setQuery( "SELECT count(*) FROM #__mamboezine_category WHERE page_id='$page_id'" );
	$total = $database->loadResult();

	require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
	$pageNav = new mosPageNav( $total, $limitstart, $limit );
	
	$database->setQuery( "SELECT id AS value, menu_name AS text FROM #__mamboezine_page ORDER BY id" );
	$secs = $database->loadObjectList();
	$seclist = mosHTML::selectList( $secs, 'page_id', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text', $page_id );

	$query = "SELECT e.*,c.name,c.title,s.name AS section_name,s.title AS section_title FROM #__mamboezine_category AS e"
	. "\n LEFT JOIN #__categories AS c ON c.id = e.catid"
	. "\n LEFT JOIN #__sections AS s ON s.id = c.section"
	. "\n WHERE e.pageid = '$page_id'"
	. "\n ORDER BY e.ordering LIMIT $pageNav->limitstart, $pageNav->limit";
	$database->setQuery( $query );
	$rows = $database->loadObjectList();

	HTML_mamboezine::showC( $page_id, $rows, $pageNav, $seclist );
}

function addCategory( $option, $pageid ) {
	global $database, $mainframe, $mosConfig_list_limit, $mosConfig_absolute_path;

	$sectionid      = intval( mosGetParam( $_REQUEST, 'sectionid', 0 ) );
	$limit 			= $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit );
	$limitstart 	= $mainframe->getUserStateFromRequest( "view{content}limitstart", 'limitstart', 0 );

	$content_add 	= '';
	$content_join 	= '';
	$order 			= "\n ORDER BY c.ordering, c.name";

	// Not show categories already added to Fronpage
	$fcatsql = "SELECT catid FROM #__mamboezine_category WHERE pageid = '$pageid'";
	$database->setQuery( $fcatsql );
	$fcats = $database->loadObjectList();
	if (count($fcats) > 0) {
		foreach ($fcats AS $fcat) {
			$fcats_id[] = "'$fcat->catid'";
		}
	}

	// used by filter
	if ( $sectionid > 0 ) {
		$filter = "\n AND c.section = '$sectionid'";
	} else {
		$filter = '';
	}

	$table 			= 'content';
	$content_add 	= "\n , z.title AS section_name";
	$content_join 	= "\n LEFT JOIN #__sections AS z ON z.id = c.section";
	$where 			= "\n WHERE c.section NOT LIKE '%com_%'";
	$order 			= "\n ORDER BY c.section, c.ordering, c.name";
	// get the total number of records
	$database->setQuery( "SELECT count(*) FROM #__categories INNER JOIN #__sections AS s ON s.id = section".(($filter <> '') ? " WHERE section = '$sectionid'" : '') );
	$total = $database->loadResult();
	if (count($fcats) > 0) {
		$database->setQuery( "SELECT count(*) FROM #__categories WHERE section NOT LIKE '%com_%' AND id IN (".(implode(',',$fcats_id)).")".(($filter <> '') ? " AND section = '$sectionid'" : '') );
		$total = $total - $database->loadResult();
	}

	require_once( $mosConfig_absolute_path . '/administrator/includes/pageNavigation.php' );
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	$query = "SELECT  c.*, c.checked_out as checked_out_contact_category, g.name AS groupname, u.name AS editor,"
	. "COUNT(DISTINCT s2.checked_out) AS checked_out"
	. $content_add
	. "\n FROM #__categories AS c"
	. "\n LEFT JOIN #__users AS u ON u.id = c.checked_out"
	. "\n LEFT JOIN #__groups AS g ON g.id = c.access"
	. "\n LEFT JOIN #__$table AS s2 ON s2.catid = c.id AND s2.checked_out > 0"
	. $content_join
	. $where
	. $filter
	. ((count($fcats) > 0) ? "\n AND c.id NOT IN (".implode(',',$fcats_id).")" : '')
	. "\n AND c.published != -2"
	. "\n GROUP BY c.id"
	. $order
	. "\n LIMIT $pageNav->limitstart, $pageNav->limit"
	;
	$database->setQuery( $query );
	$rows = $database->loadObjectList();
	if ($database->getErrorNum()) {
		echo $database->stderr();
		return;
	}

	$count = count( $rows );
	// number of Active Items
	for ( $i = 0; $i < $count; $i++ ) {
		$query = "SELECT COUNT( a.id )"
		. "\n FROM #__content AS a"
		. "\n WHERE a.catid = ". $rows[$i]->id
		. "\n AND a.state <> '-2'"
		;
		$database->setQuery( $query );
		$active = $database->loadResult();
		$rows[$i]->active = $active;
	}
	// number of Trashed Items
	for ( $i = 0; $i < $count; $i++ ) {
		$query = "SELECT COUNT( a.id )"
		. "\n FROM #__content AS a"
		. "\n WHERE a.catid = ". $rows[$i]->id
		. "\n AND a.state = '-2'"
		;
		$database->setQuery( $query );
		$trash = $database->loadResult();
		$rows[$i]->trash = $trash;
	}

	// get list of sections for dropdown filter
	$database->setQuery( "SELECT id AS value, `title` AS text FROM #__sections ORDER BY id" );
	$secs = $database->loadObjectList();
	$addon[] = mosHTML::makeOption( '0', '- Select Section -' );
	$secs = array_merge( $addon, $secs );
	$lists = mosHTML::selectList( $secs, 'sectionid', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text', $sectionid );

	HTML_mamboezine::addC( $rows, $pageNav, $lists, $pageid );
}

function addCategoryToPage( $cid, $pageid ) {
	global $database;

	$query = "SELECT COUNT(*) FROM #__mamboezine_category WHERE pageid='$pageid'";
	$database->setQuery( $query );
	$total = $database->loadResult();

	foreach ($cid AS $cat) {
		$total++;
		$sql="INSERT INTO #__mamboezine_category (`pageid`,`catid`,`ordering`) VALUES ('$pageid','$cat','$total')";
		$database->setQuery( $sql );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
			exit();
		}
	}

	mosRedirect( "index2.php?option=com_mamboezine&act=managecat&pid=$pageid" );
}

function editCategory( $cat, $pid ) {
	global $database;

	$query = "SELECT e.*, c.name, c.title FROM #__mamboezine_category AS e LEFT JOIN #__categories AS c ON c.id = e.catid WHERE catid = '$cat' AND pageid = '$pid' LIMIT 0,1";
	$database->setQuery( $query );
	if ( !$database->loadObject( $row ) ) {
		echo "<script> alert('"._SELECT_CATEGORY."'); window.history.go(-1); </script>\n";
		exit();
	}

	HTML_mamboezine::editC( $cat, $row, $pid );
}

function saveCategory( $pageid, $catid, $intros, $links, $columns, $intro_only, $frontpage_only, $img_in_intro, $img_in_link, $img_cat_title, $img_cat_more ) {
	global $database;

	$sql="UPDATE #__mamboezine_category SET `intros`='$intros',`links`='$links',`columns`='$columns',`intro_only`='$intro_only',`frontpage_only`='$frontpage_only',`img_in_intro`='$img_in_intro',`img_in_link`='$img_in_link',`img_cat_title`='".($img_cat_title == 'http://' ? '' : $img_cat_title)."',`img_cat_more`='".($img_cat_more == 'http://' ? '' : $img_cat_more)."' WHERE catid = '$catid' AND pageid = '$pageid' LIMIT 1";
	$database->setQuery( $sql );
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}

	mosRedirect( "index2.php?option=com_mamboezine&act=managecat&pid=$pageid" );
}

function removeCategory( $cid, $pid ) {
	global $database;

	foreach ($cid AS $cat) {
		$sql="DELETE FROM #__mamboezine_category WHERE `catid`='$cat' AND pageid = '$pid'";
		$database->setQuery( $sql );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
			exit();
		}
	}

	mosRedirect( "index2.php?option=com_mamboezine&act=managecat&pid=$pid" );
}

function toggleImageIntro( $catid, $pageid ) {
	global $database;

	$database->setQuery( "SELECT `img_in_intro` FROM #__mamboezine_category WHERE catid = '$catid' AND pageid = '$pageid' LIMIT 0,1" );
	$row = $database->loadObjectList();
	$new_value = ($row[0]->img_in_intro <> 0) ? 0 : 1;
	
	$database->setQuery( "UPDATE #__mamboezine_category SET `img_in_intro` = '$new_value' WHERE catid = '$catid' AND pageid = '$pageid' LIMIT 1" );
    if (!$database->query()) {
    	echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
	    exit();
	}

	mosRedirect( "index2.php?option=com_mamboezine&act=managecat&pid=$pageid" );
}

function toggleImageLink( $catid, $pageid ) {
	global $database;

	$database->setQuery( "SELECT `img_in_link` FROM #__mamboezine_category WHERE catid = '$catid' AND pageid = '$pageid' LIMIT 0,1" );
	$row = $database->loadObjectList();
	$new_value = ($row[0]->img_in_link <> 0) ? 0 : 1;
	
	$database->setQuery( "UPDATE #__mamboezine_category SET `img_in_link` = '$new_value' WHERE catid = '$catid' AND pageid = '$pageid' LIMIT 1" );
    if (!$database->query()) {
    	echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
	    exit();
	}

	mosRedirect( "index2.php?option=com_mamboezine&act=managecat&pid=$pageid" );
}

function toggleIntroOnly( $catid, $pageid ) {
	global $database;

	$database->setQuery( "SELECT `intro_only` FROM #__mamboezine_category WHERE catid = '$catid' AND pageid = '$pageid' LIMIT 0,1" );
	$row = $database->loadObjectList();
	$new_value = ($row[0]->intro_only <> 0) ? 0 : 1;
	
	$database->setQuery( "UPDATE #__mamboezine_category SET `intro_only` = '$new_value' WHERE catid = '$catid' AND pageid = '$pageid' LIMIT 1" );
    if (!$database->query()) {
    	echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
	    exit();
	}

	mosRedirect( "index2.php?option=com_mamboezine&act=managecat&pid=$pageid" );
}

function toggleFrontpageOnly( $catid, $pageid ) {
	global $database;

	$database->setQuery( "SELECT `frontpage_only` FROM #__mamboezine_category WHERE catid = '$catid' AND pageid = '$pageid' LIMIT 0,1" );
	$row = $database->loadObjectList();
	$new_value = ($row[0]->frontpage_only <> 0) ? 0 : 1;
	
	$database->setQuery( "UPDATE #__mamboezine_category SET `frontpage_only` = '$new_value' WHERE catid = '$catid' AND pageid = '$pageid' LIMIT 1" );
    if (!$database->query()) {
    	echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
	    exit();
	}

	mosRedirect( "index2.php?option=com_mamboezine&act=managecat&pid=$pageid" );
}


function reorderCategories( $catid, $pageid, $direction ) {
	global $database;

	$database->setQuery( "SELECT `ordering` FROM #__mamboezine_category WHERE catid = '$catid' AND pageid = '$pageid' LIMIT 0,1" );
	$row1 = $database->loadObjectList();

	if ($direction == -1) $neworder = $row1[0]->ordering - 1;
	elseif ($direction == 1) $neworder = $row1[0]->ordering + 1;
	
	$database->setQuery( "SELECT `catid` FROM #__mamboezine_category WHERE `ordering` = '$neworder' AND pageid = '$pageid' LIMIT 0,1" );
	$row2 = $database->loadObjectList();

	$database->setQuery( "UPDATE #__mamboezine_category SET `ordering` = '".$row1[0]->ordering."' WHERE catid = '".$row2[0]->catid."' AND pageid = '$pageid' LIMIT 1" );
    if (!$database->query()) {
    	echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
	    exit();
	}

	$database->setQuery( "UPDATE #__mamboezine_category SET `ordering` = '$neworder' WHERE catid = '$catid' AND pageid = '$pageid' LIMIT 1" );
    if (!$database->query()) {
    	echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
	    exit();
	}

	mosRedirect( "index2.php?option=com_mamboezine&act=managecat&pid=$pageid" );
}

function saveCategoriesOrder( &$cid, $pageid ) {
	global $database;

	$total		= count( $cid );
	$order 		= mosGetParam( $_POST, 'order', array(0) );

    // update ordering values
	for( $i=0; $i < $total; $i++ ) {
		$database->setQuery( "SELECT `ordering` FROM #__mamboezine_category WHERE catid = '$cid[$i]' AND pageid = '$pageid' LIMIT 0,1" );
		$row = $database->loadObjectList();
		if ($row[0]->ordering != $order[$i]) {
			$database->setQuery( "UPDATE #__mamboezine_category SET `ordering` = '$order[$i]' WHERE catid = '$cid[$i]' AND pageid = '$pageid' LIMIT 1" );
	        if (!$database->query()) {
	            echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
	            exit();
	        }
		}
	}

	mosRedirect( "index2.php?option=com_mamboezine&act=managecat&pid=$pageid" );
}

// Functions act with CSS and Language Editor
function editCSS() {
	global $mosConfig_absolute_path;
	if ($fp = fopen( $mosConfig_absolute_path.'/components/com_mamboezine/mamboezine.css.html', "r" )) {
		$content = fread( $fp, filesize( $mosConfig_absolute_path.'/components/com_mamboezine/mamboezine.css.html' ) );
		$content = htmlspecialchars( $content );
		HTML_mamboezine::editCSS( $content );
	} else {
	 	echo "<script> alert('".str_replace('%FILE_NAME%', 'mamboezine.css.html', _UNABLE_OPEN_FILE)."'); window.history.go(-1); </script>\n";
		exit();
	}
}

function saveCSS() {
	global $mosConfig_absolute_path;

	$filecontent = mosGetParam( $_POST, 'filecontent', '', _MOS_ALLOWHTML );
	if (!$filecontent) {
	 	echo "<script> alert('"._CONTENT_EMPTY."'); window.history.go(-1); </script>\n";
		exit();
	}
	$filecontent = "<style>\n".$filecontent."\n</style>";

	$file = $mosConfig_absolute_path.'/components/com_mamboezine/mamboezine.css.html';
    $enable_write = mosGetParam($_POST,'enable_write',0);
	$oldperms = fileperms($file);
	if ($enable_write) @chmod($file, $oldperms | 0222);

	clearstatcache();
	if (is_writable( $file ) == false) {
	 	echo "<script> alert('"._FILE_NOT_WRITABLE."'); window.history.go(-1); </script>\n";
		exit();
	}

	if ($fp = fopen ($file, "w")) {
		fputs( $fp, stripslashes( $filecontent ) );
		fclose( $fp );
		if ($enable_write) {
			@chmod($file, $oldperms);
		} else {
			if (mosGetParam($_POST,'disable_write',0))
				@chmod($file, $oldperms & 0777555);
		} // if
		mosRedirect( 'index2.php?option=com_mamboezine&act=aboutcom', str_replace('%FILE_NAME%', 'mamboezine.css.html', _FILE_SAVED) );
	} else {
		if ($enable_write) @chmod($file, $oldperms);
	 	echo "<script> alert('"._FILE_NOT_OPEN."'); window.history.go(-1); </script>\n";
		exit();
	}
}

function editLang() {
	global $mosConfig_absolute_path, $mosConfig_lang;
	if(file_exists($mosConfig_absolute_path.'/components/com_mamboezine/language/'.$mosConfig_lang.'.php'))
		$file = $mosConfig_absolute_path.'/components/com_mamboezine/language/'.$mosConfig_lang.'.php';
	else
		if (!copy($mosConfig_absolute_path.'/components/com_mamboezine/language/english.php', $mosConfig_absolute_path.'/components/com_mamboezine/language/'.$mosConfig_lang.'.php'))
			$file = $mosConfig_absolute_path.'/components/com_mamboezine/language/english.php';
		else
			$file = $mosConfig_absolute_path.'/components/com_mamboezine/language/'.$mosConfig_lang.'.php';
	if ($fp = fopen( $file, "r" )) {
		$content = fread( $fp, filesize( $file ) );
		$content = htmlspecialchars( $content );
		HTML_mamboezine::editLang( $content );
	} else {
	 	echo "<script> alert('".str_replace('%FILE_NAME%', $mosConfig_lang.'.php', _UNABLE_OPEN_FILE)."'); window.history.go(-1); </script>\n";
		exit();
	}
}

function saveLang() {
	global $mosConfig_absolute_path, $mosConfig_lang;

	$filecontent = mosGetParam( $_POST, 'filecontent', '', _MOS_ALLOWHTML );
	if (!$filecontent) {
	 	echo "<script> alert('"._CONTENT_EMPTY."'); window.history.go(-1); </script>\n";
		exit();
	}

	$file = $mosConfig_absolute_path.'/components/com_mamboezine/language/'.$mosConfig_lang.'.php';
    $enable_write = mosGetParam($_POST,'enable_write',0);
	$oldperms = fileperms($file);
	if ($enable_write) @chmod($file, $oldperms | 0222);

	clearstatcache();
	if (is_writable( $file ) == false) {
	 	echo "<script> alert('"._FILE_NOT_WRITABLE."'); window.history.go(-1); </script>\n";
		exit();
	}

	if ($fp = fopen ($file, "w")) {
		fputs( $fp, stripslashes( $filecontent ) );
		fclose( $fp );
		if ($enable_write) {
			@chmod($file, $oldperms);
		} else {
			if (mosGetParam($_POST,'disable_write',0))
				@chmod($file, $oldperms & 0777555);
		} // if
		mosRedirect( 'index2.php?option=com_mamboezine&act=aboutcom', str_replace('%FILE_NAME%', $mosConfig_lang.'.php', _FILE_SAVED) );
	} else {
		if ($enable_write) @chmod($file, $oldperms);
	 	echo "<script> alert('"._FILE_NOT_OPEN."'); window.history.go(-1); </script>\n";
		exit();
	}
}

// About Us
function mamboezineCredit() {
	HTML_mamboezine::aboutUs();
}

?>
