<?php
// $Id: xoopscodes.php,v 1.12 2004/06/14 14:22:13 skalpa Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Kazumi Ono (AKA onokazu)                                          //
// URL: http://www.xoops.org/ http://jp.xoops.org/  http://www.myweb.ne.jp/  //
// Project: The XOOPS Project (http://www.xoops.org/)                        //
// ------------------------------------------------------------------------- //

/*
*  displayes xoopsCode buttons and target textarea to which xoopscodes are inserted
*  $textarea_id is a unique id of the target textarea
*/
function xoopsCodeTarea($textarea_id, $cols=60, $rows=15, $suffix=null, $isEcho=true)
{
	$hiddentext = isset($suffix) ? 'xoopsHiddenText'.trim($suffix) : 'xoopsHiddenText';

	$ret = xoopsCode_codeIcon($textarea_id)."<br />\n";
	$ret .= xoopsCode_fontArray($textarea_id,$hiddentext)."<br /><br />\n\n";
	$ret .= "<textarea id='".$textarea_id."' name='".$textarea_id."' cols='$cols' rows='$rows' onSelect='xoopsSavePosition(\"$textarea_id\");' onClick='xoopsSavePosition(\"$textarea_id\");' onKeyUp='xoopsSavePosition(\"$textarea_id\");' >".$GLOBALS[$textarea_id]."</textarea><br />\n";
	if($isEcho) echo $ret;
	else return($ret);
}

/*
*  Displays smilie image buttons used to insert smilie codes to a target textarea in a form
* $textarea_id is a unique of the target textarea
*/
function xoopsSmilies($textarea_id, $isEcho=true)
{
	$myts =& MyTextSanitizer::getInstance();
	$smiles =& $myts->getSmileys();
	$ret = "";
	$MAX_DIS=10;
	if (empty($smileys)) {
		$db =& Database::getInstance();
		if ($result = $db->query('SELECT * FROM '.$db->prefix('smiles').' WHERE display=1')) {
			$i_MAX_DIS=0;
			while ($smiles = $db->fetchArray($result)) {
				$ret .= "<img src='".XOOPS_UPLOAD_URL."/".htmlspecialchars($smiles['smile_url'])."' border='0' onmouseover='style.cursor=\"hand\"' alt='' onclick='xoopsCodeSmilie(\"".$textarea_id."\", \" ".$smiles['code']." \");' />";
				$i_MAX_DIS++;
				if($i_MAX_DIS==$MAX_DIS) break;
			}
		}
	} else {
		$count = count($smiles);
		$i_MAX_DIS=0;
		for ($i = 0; $i < $count; $i++) {
			if ($smiles[$i]['display'] == 1) {
				$ret .= "<img src='".XOOPS_UPLOAD_URL."/".$myts->oopsHtmlSpecialChars($smiles['smile_url'])."' border='0' alt='' onclick='xoopsCodeSmilie(\"".$textarea_id."\", \" ".$smiles[$i]['code']." \");' onmouseover='style.cursor=\"hand\"' />";
				$i_MAX_DIS++;
				if($i_MAX_DIS==$MAX_DIS) break;
			}
		}
	}
	$ret .= "&nbsp;[<a href='#moresmiley' onmouseover='style.cursor=\"hand\"' alt='' onclick='openWithSelfMain(\"".XOOPS_URL."/misc.php?action=showpopups&amp;type=smilies&amp;target=".$textarea_id."\",\"smilies\",300,475);'>"._MORE."</a>]";

	if($isEcho) echo $ret;
	else return($ret);
}

function xoopsCode_codeIcon($textarea_id)
{
	$code="<a name='moresmiley'></a>
		<img src='".XOOPS_URL."/images/url.gif' alt='"._ALTURL."' onclick='xoopsCodeUrl(\"$textarea_id\", \"".htmlspecialchars(_ENTERURL, ENT_QUOTES)."\", \"".htmlspecialchars(_ENTERWEBTITLE, ENT_QUOTES)."\");' onmouseover='style.cursor=\"hand\"'/>&nbsp;
		<img src='".XOOPS_URL."/images/email.gif' alt='"._ALTEMAIL."' onclick='xoopsCodeEmail(\"$textarea_id\", \"".htmlspecialchars(_ENTEREMAIL, ENT_QUOTES)."\");'  onmouseover='style.cursor=\"hand\"'/>&nbsp;
		<img src='".XOOPS_URL."/images/imgsrc.gif' alt='"._ALTIMG."' onclick='xoopsCodeImg(\"$textarea_id\", \"".htmlspecialchars(_ENTERIMGURL, ENT_QUOTES)."\", \"".htmlspecialchars(_ENTERIMGPOS, ENT_QUOTES)."\", \"".htmlspecialchars(_IMGPOSRORL, ENT_QUOTES)."\", \"".htmlspecialchars(_ERRORIMGPOS, ENT_QUOTES)."\", \"".htmlspecialchars(_ENTERWIDTH, ENT_QUOTES)."\");'  onmouseover='style.cursor=\"hand\"'/>&nbsp;
		<img src='".XOOPS_URL."/images/image.gif' alt='"._ALTIMAGE."' onclick='openWithSelfMain(\"".XOOPS_URL."/imagemanager.php?target=".$textarea_id."\",\"imgmanager\",400,430);'  onmouseover='style.cursor=\"hand\"'/>&nbsp;
		<img src='".XOOPS_URL."/images/wmp.gif' alt='"._ALTWMP."'  onclick='xoopsCodeWmp(\"$textarea_id\",\"".htmlspecialchars(_ENTERWMPURL, ENT_QUOTES)."\",\"".htmlspecialchars(_ENTERHEIGHT, ENT_QUOTES)."\",\"".htmlspecialchars(_ENTERWIDTH, ENT_QUOTES)."\");'  onmouseover='style.cursor=\"hand\"'/>&nbsp;
		<img src='".XOOPS_URL."/images/swf.gif' alt='"._ALTFLASH."'  onclick='xoopsCodeFlash(\"$textarea_id\",\"".htmlspecialchars(_ENTERFLASHURL, ENT_QUOTES)."\",\"".htmlspecialchars(_ENTERHEIGHT, ENT_QUOTES)."\",\"".htmlspecialchars(_ENTERWIDTH, ENT_QUOTES)."\");'  onmouseover='style.cursor=\"hand\"'/>&nbsp;
		<img src='".XOOPS_URL."/images/mmssrc.gif' alt='"._ALTMMS."' onclick='xoopsCodeMms(\"$textarea_id\",\"".htmlspecialchars(_ENTERMMSURL, ENT_QUOTES)."\",\"".htmlspecialchars(_ENTERHEIGHT, ENT_QUOTES)."\",\"".htmlspecialchars(_ENTERWIDTH, ENT_QUOTES)."\");'  onmouseover='style.cursor=\"hand\"'/>&nbsp;
		<img src='".XOOPS_URL."/images/rtspimg.gif' alt='"._ALTRTSP."' onclick='xoopsCodeRtsp(\"$textarea_id\",\"".htmlspecialchars(_ENTERRTSPURL, ENT_QUOTES)."\",\"".htmlspecialchars(_ENTERHEIGHT, ENT_QUOTES)."\",\"".htmlspecialchars(_ENTERWIDTH, ENT_QUOTES)."\");'  onmouseover='style.cursor=\"hand\"'/>&nbsp;
		<img src='".XOOPS_URL."/images/iframe.gif' alt='"._ALTIFRAME."' onclick='xoopsCodeIframe(\"$textarea_id\",\"".htmlspecialchars(_ENTERIFRAMEURL, ENT_QUOTES)."\",\"".htmlspecialchars(_ENTERHEIGHT, ENT_QUOTES)."\");'  onmouseover='style.cursor=\"hand\"'/>&nbsp;
		<img src='".XOOPS_URL."/images/code.gif' alt='"._ALTCODE."' onclick='xoopsCodeCode(\"$textarea_id\", \"".htmlspecialchars(_ENTERCODE, ENT_QUOTES)."\");'  onmouseover='style.cursor=\"hand\"'/>&nbsp;
		<img src='".XOOPS_URL."/images/quote.gif' alt='"._ALTQUOTE."' onclick='xoopsCodeQuote(\"$textarea_id\", \"".htmlspecialchars(_ENTERQUOTE, ENT_QUOTES)."\");' onmouseover='style.cursor=\"hand\"'/>
	";
	return($code);
}

function xoopsCode_fontArray($textarea_id, $hiddentext)
{
	$sizearray = array("xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large");
	$sizeStr = "<select id='".$textarea_id."Size' onchange='setVisible(\"xoopsHiddenText\");setElementSize(\"".$hiddentext."\",this.options[this.selectedIndex].value);'>\n";
	$sizeStr .= "<option value='SIZE'>"._SIZE."</option>\n";
	foreach ( $sizearray as $size ) {
		$sizeStr .= "<option value='$size'>$size</option>\n";
	}
	$sizeStr .= "</select>\n";

	$fontarray = array("Arial", "Courier", "Georgia", "Helvetica", "Impact", "Verdana", "Haettenschweiler");
	$faceStr = "<select id='".$textarea_id."Font' onchange='setVisible(\"xoopsHiddenText\");setElementFont(\"".$hiddentext."\",this.options[this.selectedIndex].value);'>\n";
	$faceStr .= "<option value='FONT'>"._FONT."</option>\n";
	foreach ( $fontarray as $font ) {
		$faceStr .= "<option value='$font'>$font</option>\n";
	}
	$faceStr .= "</select>\n";

	$colorarray = array("00", "33", "66", "99", "CC", "FF");
	$colorStr = "<select id='".$textarea_id."Color' onchange='setVisible(\"xoopsHiddenText\");setElementColor(\"".$hiddentext."\",this.options[this.selectedIndex].value);'>\n";
	$colorStr .= "<option value='COLOR'>"._COLOR."</option>\n";
	foreach ( $colorarray as $color1 ) {
		foreach ( $colorarray as $color2 ) {
			foreach ( $colorarray as $color3 ) {
				$colorStr .= "<option value='".$color1.$color2.$color3."' style='background-color:#".$color1.$color2.$color3.";color:#".$color1.$color2.$color3.";'>#".$color1.$color2.$color3."</option>\n";
			}
		}
	}
	$colorStr .= "</select>";

	$styleStr = "<img src='".XOOPS_URL."/images/bold.gif' alt='"._ALTBOLD."' onmouseover='style.cursor=\"hand\"' onclick='setVisible(\"".$hiddentext."\");makeBold(\"".$hiddentext."\");' />&nbsp;";
	$styleStr .= "<img src='".XOOPS_URL."/images/italic.gif' alt='"._ALTITALIC."' onmouseover='style.cursor=\"hand\"' onclick='setVisible(\"".$hiddentext."\");makeItalic(\"".$hiddentext."\");' />&nbsp;";
	$styleStr .= "<img src='".XOOPS_URL."/images/underline.gif' alt='"._ALTUNDERLINE."' onmouseover='style.cursor=\"hand\"' onclick='setVisible(\"".$hiddentext."\");makeUnderline(\"".$hiddentext."\");'/>&nbsp;";
	$styleStr .= "<img src='".XOOPS_URL."/images/linethrough.gif' alt='"._ALTLINETHROUGH."' onmouseover='style.cursor=\"hand\"' onclick='setVisible(\"".$hiddentext."\");makeLineThrough(\"".$hiddentext."\");' /></a>&nbsp;";
	$styleStr .= "<input type='text' id='".$textarea_id."Addtext' size='20' />&nbsp;<input type='button' onclick='xoopsCodeText(\"$textarea_id\", \"".$hiddentext."\", \"".htmlspecialchars(_ENTERTEXTBOX, ENT_QUOTES)."\")' value='"._ADD."' />";

	$fontStr = $sizeStr.$faceStr.$colorStr."<br />\n".$styleStr."&nbsp;&nbsp;<span id='".$hiddentext."'>"._EXAMPLE."</span>\n";
	return($fontStr);
}
?>