<?php
// $Id: module.textsanitizer.php,v 1.26 2004/12/26 19:11:48 onokazu Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Kazumi Ono (http://www.myweb.ne.jp/, http://jp.xoops.org/)        //
//         Goghs Cheng (http://www.eqiao.com, http://www.devbeez.com/)       //
// Project: The XOOPS Project (http://www.xoops.org/)                        //
// ------------------------------------------------------------------------- //

/**#@+
 * Xoops extended code preferences
 *
 * phppp http://xoops.org.cn
 **/
define('MULTILINGUAL', 1); // If you are using the multilingula hack, you should set this value 1.
define('ALLOW_IFRAME', 1);
define('ALLOW_WMP', 1);
define('ALLOW_MMS', 1);
define('ALLOW_FLASH', 1);
define('ALLOW_RTSP', 1);
define('ALLOW_IMAGE', 1);
define('ALLOW_IMAGE_CLICKABLE', 0);
define('ALLOW_CODE_PHPHIGHLIGHT', 1);
define('LANGUAGE_DEFAULT', "PHP");
/**#@-*/

/**
 * Class to "clean up" text for various uses
 *
 * <b>Singleton</b>
 *
 * @package		kernel
 * @subpackage	core
 *
 * @author		Kazumi Ono 	<onokazu@xoops.org>
 * @author      Goghs Cheng
 * @copyright	(c) 2000-2003 The Xoops Project - www.xoops.org
 */
class MyTextSanitizer
{
	/**
	 * @var	array
	 */
	var $smileys = array();

	/**
	 *
	 */
	var $censorConf;

	/*
	* Constructor of this class
    *
	* Gets allowed html tags from admin config settings
	* <br> should not be allowed since nl2br will be used
	* when storing data.
    *
    * @access	private
    *
    * @todo Sofar, this does nuttin' ;-)
	*/
	function MyTextSanitizer()
	{

	}

	/**
	 * Access the only instance of this class
     *
     * @return	object
     *
     * @static
     * @staticvar   object
	 */
	function &getInstance()
	{
		static $instance;
		if (!isset($instance)) {
			$instance = new MyTextSanitizer();
		}
		return $instance;
	}

	/**
	 * Get the smileys
     *
     * @return	array
	 */
	function getSmileys()
	{
		return $this->smileys;
	}

    /**
     * Replace emoticons in the message with smiley images
     *
     * @param	string  $message
     *
     * @return	string
     */
    function &smiley($message)
	{
		$db =& Database::getInstance();
		if (count($this->smileys) == 0) {
			if ($getsmiles = $db->query("SELECT * FROM ".$db->prefix("smiles"))){
				while ($smiles = $db->fetchArray($getsmiles)) {
					$message =& str_replace($smiles['code'], '<img src="'.XOOPS_UPLOAD_URL.'/'.htmlspecialchars($smiles['smile_url']).'" alt="" />', $message);
					array_push($this->smileys, $smiles);
				}
			}
		}
		elseif (is_array($this->smileys)) {
			foreach ($this->smileys as $smile) {
				$message =& str_replace($smile['code'], '<img src="'.XOOPS_UPLOAD_URL.'/'.htmlspecialchars($smile['smile_url']).'" alt="" />', $message);
			}
		}
		return $message;
	}

	/**
	 * Make links in the text clickable
	 *
	 * @param   string  $text
	 * @return  string
	 **/
	function &makeClickable(&$text)
	{
		$patterns = array("/(^|[^]_a-z0-9-=\"'\/])([a-z]+?):\/\/([^, \r\n\"\(\)'<>]+)/i", "/(^|[^]_a-z0-9-=\"'\/])www\.([a-z0-9\-]+)\.([^, \r\n\"\(\)'<>]+)/i", "/(^|[^]_a-z0-9-=\"'\/])ftp\.([a-z0-9\-]+)\.([^, \r\n\"\(\)'<>]+)/i", "/(^|[^]_a-z0-9-=\"'\/:\.])([a-z0-9\-_\.]+?)@([^, \r\n\"\(\)'<>\[\]]+)/i");
		$replacements = array("\\1<a href=\"\\2://\\3\" target=\"_blank\">\\2://\\3</a>", "\\1<a href=\"http://www.\\2.\\3\" target=\"_blank\">www.\\2.\\3</a>", "\\1<a href=\"ftp://ftp.\\2.\\3\" target=\"_blank\">ftp.\\2.\\3</a>", "\\1<a href=\"mailto:\\2@\\3\">\\2@\\3</a>");
		return preg_replace($patterns, $replacements, $text);
	}

	/**
	 * Replace XoopsCodes with their equivalent HTML formatting
	 *
	 * @param   string  $text
	 * @param   bool    $allowimage Allow images in the text?
     *                              On FALSE, uses links to images.
	 * @return  string
	 **/
	function &xoopsCodeDecode(&$text, $allowimage = 1)
	{
		$patterns = array();
		$replacements = array();
		//$patterns[] = "/\[code](.*)\[\/code\]/esU";
		//$replacements[] = "'<div class=\"xoopsCode\"><code><pre>'.wordwrap(MyTextSanitizer::htmlSpecialChars('\\1'), 100).'</pre></code></div>'";
		// RMV: added new markup for intrasite url (allows easier site moves)
		// TODO: automatically convert other URLs to this format if XOOPS_URL matches??
		$patterns[] = "/\[siteurl=(['\"]?)([^\"'<>]*)\\1](.*)\[\/siteurl\]/sU";
		$replacements[] = '<a href="'.XOOPS_URL.'/\\2" target="_blank">\\3</a>';
		$patterns[] = "/\[url=(['\"]?)(http[s]?:\/\/[^\"'<>]*)\\1](.*)\[\/url\]/sU";
		$replacements[] = '<a href="\\2" target="_blank">\\3</a>';
		$patterns[] = "/\[url=(['\"]?)(ftp?:\/\/[^\"'<>]*)\\1](.*)\[\/url\]/sU";
		$replacements[] = '<a href="\\2" target="_blank">\\3</a>';
		$patterns[] = "/\[url=(['\"]?)([^\"'<>]*)\\1](.*)\[\/url\]/sU";
		$replacements[] = '<a href="http://\\2" target="_blank">\\3</a>';
		$patterns[] = "/\[color=(['\"]?)([a-zA-Z0-9]*)\\1](.*)\[\/color\]/sU";
		$replacements[] = '<span style="color: #\\2;">\\3</span>';
		$patterns[] = "/\[size=(['\"]?)([a-z0-9-]*)\\1](.*)\[\/size\]/sU";
		$replacements[] = '<span style="font-size: \\2;">\\3</span>';
		$patterns[] = "/\[font=(['\"]?)([^;<>\*\(\)\"']*)\\1](.*)\[\/font\]/sU";
		$replacements[] = '<span style="font-family: \\2;">\\3</span>';
		$patterns[] = "/\[email]([^;<>\*\(\)\"']*)\[\/email\]/sU";
		$replacements[] = '<a href="mailto:\\1">\\1</a>';
		$patterns[] = "/\[b](.*)\[\/b\]/sU";
		$replacements[] = '<b>\\1</b>';
		$patterns[] = "/\[i](.*)\[\/i\]/sU";
		$replacements[] = '<i>\\1</i>';
		$patterns[] = "/\[u](.*)\[\/u\]/sU";
		$replacements[] = '<u>\\1</u>';
		$patterns[] = "/\[d](.*)\[\/d\]/sU";
		$replacements[] = '<del>\\1</del>';
		//$patterns[] = "/\[li](.*)\[\/li\]/sU";
		//$replacements[] = '<li>\\1</li>';
		/*
		// remove by the extended xoopscodes -- phppp
		$patterns[] = "/\[img align=(['\"]?)(left|center|right)\\1]([^\"\(\)\?\&'<>]*)\[\/img\]/sU";
		$patterns[] = "/\[img]([^\"\(\)\?\&'<>]*)\[\/img\]/sU";
		$patterns[] = "/\[img align=(['\"]?)(left|center|right)\\1 id=(['\"]?)([0-9]*)\\3]([^\"\(\)\?\&'<>]*)\[\/img\]/sU";
		$patterns[] = "/\[img id=(['\"]?)([0-9]*)\\1]([^\"\(\)\?\&'<>]*)\[\/img\]/sU";
		if ($allowimage != 1) {
			$replacements[] = '<a href="\\3" target="_blank">\\3</a>';
			$replacements[] = '<a href="\\1" target="_blank">\\1</a>';
			$replacements[] = '<a href="'.XOOPS_URL.'/image.php?id=\\4" target="_blank">\\4</a>';
			$replacements[] = '<a href="'.XOOPS_URL.'/image.php?id=\\2" target="_blank">\\3</a>';
		} else {
			$replacements[] = '<img src="\\3" align="\\2" alt="" />';
			$replacements[] = '<img src="\\1" alt="" />';
			$replacements[] = '<img src="'.XOOPS_URL.'/image.php?id=\\4" align="\\2" alt="\\4" />';
			$replacements[] = '<img src="'.XOOPS_URL.'/image.php?id=\\2" alt="\\3" />';
		}
		// remove by the extended xoopscodes -- phppp
		*/
		$patterns[] = "/\[quote]/sU";
		$replacements[] = _QUOTEC.'<div class="xoopsQuote"><blockquote>';
		//$replacements[] = 'Quote: <div class="xoopsQuote"><blockquote>';
		$patterns[] = "/\[\/quote]/sU";
		$replacements[] = '</blockquote></div>';
		$patterns[] = "/javascript:/si";
		$replacements[] = "java script:";
		$patterns[] = "/about:/si";
		$replacements[] = "about :";
		// add the extended xoopscodes -- phppp
		xoopsCodeDecode_extent($patterns,$replacements);
		// add the extended xoopscodes -- phppp

		return preg_replace($patterns, $replacements, $text);
	}

	/**
	 * Convert linebreaks to <br /> tags
     *
     * @param	string  $text
     *
     * @return	string
	 */
	function &nl2Br($text)
	{
		return preg_replace("/(\015\012)|(\015)|(\012)/","<br />",$text);
	}

	/**
	 * Add slashes to the text if magic_quotes_gpc is turned off.
	 *
	 * @param   string  $text
	 * @return  string
	 **/
	function &addSlashes($text)
	{
		if (!get_magic_quotes_gpc()) {
			$text =& addslashes($text);
		}
		return $text;
	}
	/*
	* if magic_quotes_gpc is on, stirip back slashes
    *
    * @param	string  $text
    *
    * @return	string
	*/
	function &stripSlashesGPC($text)
	{
		if (get_magic_quotes_gpc()) {
			$text =& stripslashes($text);
		}
		return $text;
	}

	/*
	*  for displaying data in html textbox forms
    *
    * @param	string  $text
    *
    * @return	string
	*/
	function &htmlSpecialChars($text)
	{
		//return preg_replace("/&amp;/i", '&', htmlspecialchars($text, ENT_QUOTES));
		return preg_replace(array("/&amp;/i", "/&nbsp;/i"), array('&', '&amp;nbsp;'), htmlspecialchars($text, ENT_QUOTES));
	}

	/**
	 * Reverses {@link htmlSpecialChars()}
	 *
	 * @param   string  $text
	 * @return  string
	 **/
	function &undoHtmlSpecialChars(&$text)
	{
		//return preg_replace(array("/&gt;/i", "/&lt;/i", "/&quot;/i", "/&#039;/i"), array(">", "<", "\"", "'"), $text);
		return preg_replace(array("/&gt;/i", "/&lt;/i", "/&quot;/i", "/&#039;/i", '/&amp;nbsp;/i'), array(">", "<", "\"", "'", "&nbsp;"), $text);
	}

	/**
	 * Filters textarea form data in DB for display
	 *
	 * @param   string  $text
	 * @param   bool    $html   allow html?
	 * @param   bool    $smiley allow smileys?
	 * @param   bool    $xcode  allow xoopscode?
	 * @param   bool    $image  allow inline images?
	 * @param   bool    $br     convert linebreaks?
	 * @return  string
	 **/
	function &displayTarea(&$text, $html = 0, $smiley = 1, $xcode = 1, $image = 1, $br = 1)
	{
		if ($html != 1) {
			// html not allowed
			$text =& $this->htmlSpecialChars($text);
		}
		$text =& $this->codePreConv($text, $xcode); // Ryuji_edit(2003-11-18)
		$text =& $this->makeClickable($text);
		if ($smiley != 0) {
			// process smiley
			$text =& $this->smiley($text);
		}
		if ($xcode != 0) {
			// decode xcode
			if ($image != 0) {
				// image allowed
				$text =& $this->xoopsCodeDecode($text);
            		} else {
                		// image not allowed
                		$text =& $this->xoopsCodeDecode($text, 0);
			}
		}
		if ($br != 0) {
			$text =& $this->nl2Br($text);
		}
		$text =& $this->codeConv($text, $xcode, $image);	// Ryuji_edit(2003-11-18)
		return $text;
	}

	/**
	 * Filters textarea form data submitted for preview
	 *
	 * @param   string  $text
	 * @param   bool    $html   allow html?
	 * @param   bool    $smiley allow smileys?
	 * @param   bool    $xcode  allow xoopscode?
	 * @param   bool    $image  allow inline images?
	 * @param   bool    $br     convert linebreaks?
	 * @return  string
	 **/
	function &previewTarea(&$text, $html = 0, $smiley = 1, $xcode = 1, $image = 1, $br = 1)
	{
		$text =& $this->stripSlashesGPC($text);
		if ($html != 1) {
			// html not allowed
			$text =& $this->htmlSpecialChars($text);
		}
		$text =& $this->codePreConv($text, $xcode); // Ryuji_edit(2003-11-18)
		$text =& $this->makeClickable($text);
		if ($smiley != 0) {
			// process smiley
			$text =& $this->smiley($text);
		}
		if ($xcode != 0) {
			// decode xcode
			if ($image != 0) {
				// image allowed
				$text =& $this->xoopsCodeDecode($text);
			} else {
				// image not allowed
				$text =& $this->xoopsCodeDecode($text, 0);
			}
		}
		if ($br != 0) {
			$text =& $this->nl2Br($text);
		}
		$text =& $this->codeConv($text, $xcode, $image);	// Ryuji_edit(2003-11-18)
		return $text;
	}

	/**
	 * Replaces banned words in a string with their replacements
	 *
	 * @param   string $text
	 * @return  string
     *
     * @deprecated
	 **/
	function &censorString(&$text)
	{
		if (!isset($this->censorConf)) {
			$config_handler =& xoops_gethandler('config');
			$this->censorConf =& $config_handler->getConfigsByCat(XOOPS_CONF_CENSOR);
		}
		if ($this->censorConf['censor_enable'] == 1) {
			$replacement = $this->censorConf['censor_replace'];
			foreach ($this->censorConf['censor_words'] as $bad) {
				if ( !empty($bad) ) {
	 				$bad = quotemeta($bad);
					$patterns[] = "/(\s)".$bad."/siU";
					$replacements[] = "\\1".$replacement;
					$patterns[] = "/^".$bad."/siU";
					$replacements[] = $replacement;
					$patterns[] = "/(\n)".$bad."/siU";
					$replacements[] = "\\1".$replacement;
					$patterns[] = "/]".$bad."/siU";
					$replacements[] = "]".$replacement;
					$text = preg_replace($patterns, $replacements, $text);
				}
   			}
		}
   		return $text;
	}


	/**#@+
	 * Sanitizing of [code] tag
	 */
	function codePreConv($text, $xcode = 1) {
		if($xcode != 0){
			//$patterns = "/\[code](.*)\[\/code\]/esU";
			//$replacements = "'[code]'.base64_encode('$1').'[/code]'";
			$patterns = "/\[code([^\]]*?)\](.*)\[\/code\]/esU";
			$replacements = "'[code\\1]'.base64_encode('\\2').'[/code]'";
			$text =  preg_replace($patterns, $replacements, $text);
		}
		return $text;
	}

	function codeConv($text, $xcode = 1, $image = 1){
		if($xcode != 0){
			$patterns[] = "/\[code([^\]]*?)\](.*)\[\/code\]/esU";
			if ($image != 0) {
				// image allowed
				$codeSanitizerParameter = "'$2'";
			} else {
				// image not allowed
				$codeSanitizerParameter = "'$2',0";
			}
			$replacements = "'<div class=\"xoopsCode\"><code>'.MyTextSanitizer::codeHighlight(MyTextSanitizer::codeSanitizer($codeSanitizerParameter), '$1').'</code></div>'";
			$text =  preg_replace($patterns, $replacements, $text);
		}
		return $text;
	}

	function codeSanitizer($str, $image = 1){
		if($image != 0){
			$str = $this->xoopsCodeDecode(
				$this->htmlSpecialChars(str_replace('\"', '"', base64_decode($str)))
				);
		}else{
			$str = $this->xoopsCodeDecode(
				$this->htmlSpecialChars(str_replace('\"', '"', base64_decode($str))),0
				);
		}
		return $str;
	}


	function codeHighlight( $source, $language )
	{
		$language = str_replace('=', '', $language);
		$language = ($language)?$language:LANGUAGE_DEFAULT;
	    $language = strtolower($language);
		$source = MyTextSanitizer::undoHtmlSpecialChars($source);
		$source = stripslashes($source);
		return (empty($language))?xoops_phpHighlight($source):geshi_highlight( $source, $language );
	}

	/**#@-*/


##################### Deprecated Methods ######################

	/**#@+
	 * @deprecated
	 */
	function sanitizeForDisplay($text, $allowhtml = 0, $smiley = 1, $bbcode = 1)
	{
		if ( $allowhtml == 0 ) {
			$text = $this->htmlSpecialChars($text);
		} else {
			//$config =& $GLOBALS['xoopsConfig'];
			//$allowed = $config['allowed_html'];
			//$text = strip_tags($text, $allowed);
			$text = $this->makeClickable($text);
		}
		if ( $smiley == 1 ) {
			$text = $this->smiley($text);
		}
		if ( $bbcode == 1 ) {
			$text = $this->xoopsCodeDecode($text);
		}
		$text = $this->nl2Br($text);
		return $text;
	}

	function sanitizeForPreview($text, $allowhtml = 0, $smiley = 1, $bbcode = 1)
	{
		$text = $this->oopsStripSlashesGPC($text);
		if ( $allowhtml == 0 ) {
			$text = $this->htmlSpecialChars($text);
		} else {
			//$config =& $GLOBALS['xoopsConfig'];
			//$allowed = $config['allowed_html'];
			//$text = strip_tags($text, $allowed);
			$text = $this->makeClickable($text);
		}
		if ( $smiley == 1 ) {
			$text = $this->smiley($text);
		}
		if ( $bbcode == 1 ) {
			$text = $this->xoopsCodeDecode($text);
		}
		$text = $this->nl2Br($text);
		return $text;
	}

	function makeTboxData4Save($text)
	{
		//$text = $this->undoHtmlSpecialChars($text);
		return $this->addSlashes($text);
	}

	function makeTboxData4Show($text, $smiley=0)
	{
		$text = $this->htmlSpecialChars($text);
		return $text;
	}

	function makeTboxData4Edit($text)
	{
		return $this->htmlSpecialChars($text);
	}

	function makeTboxData4Preview($text, $smiley=0)
	{
		$text = $this->stripSlashesGPC($text);
		$text = $this->htmlSpecialChars($text);
		return $text;
	}

	function makeTboxData4PreviewInForm($text)
	{
		$text = $this->stripSlashesGPC($text);
		return $this->htmlSpecialChars($text);
	}

	function makeTareaData4Save($text)
	{
		return $this->addSlashes($text);
	}

	function &makeTareaData4Show(&$text, $html=1, $smiley=1, $xcode=1)
	{
		return $this->displayTarea($text, $html, $smiley, $xcode);
	}

	function makeTareaData4Edit($text)
	{
		return $this->htmlSpecialChars($text);
	}

	function &makeTareaData4Preview(&$text, $html=1, $smiley=1, $xcode=1)
	{
		return $this->previewTarea($text, $html, $smiley, $xcode);
	}

	function makeTareaData4PreviewInForm($text)
	{
		//if magic_quotes_gpc is on, do stipslashes
		$text = $this->stripSlashesGPC($text);
		return $this->htmlSpecialChars($text);
	}

	function makeTareaData4InsideQuotes($text)
	{
		return $this->htmlSpecialChars($text);
	}

	function &oopsStripSlashesGPC($text)
	{
		return $this->stripSlashesGPC($text);
	}

	function &oopsStripSlashesRT($text)
	{
		if (get_magic_quotes_runtime()) {
			$text =& stripslashes($text);
		}
		return $text;
	}

	function &oopsAddSlashes($text)
	{
		return $this->addSlashes($text);
	}

	function &oopsHtmlSpecialChars($text)
	{
		return $this->htmlSpecialChars($text);
	}

	function &oopsNl2Br($text)
	{
		return $this->nl2br($text);
	}
    /**#@-*/
}

function xoopsCodeDecode_extent(&$patterns, &$replacements)
{
	if(defined("MULTILINGUAL") && MULTILINGUAL >0) xoopsCodeDecode_language($patterns,$replacements);
	xoopsCodeDecode_iframe($patterns,$replacements);
	xoopsCodeDecode_media($patterns,$replacements);
}

function xoopsCodeDecode_media(&$patterns,&$replacements)
{
	xoopsCodeDecode_wmp($patterns,$replacements);
	xoopsCodeDecode_flash($patterns,$replacements);
	xoopsCodeDecode_mms($patterns,$replacements);
	xoopsCodeDecode_rtsp($patterns,$replacements);
	xoopsCodeDecode_img($patterns,$replacements);
}

function xoopsCodeDecode_language(&$patterns,&$replacements)
{
	global $xoopsConfig;
	$language_array=array(
		array("english",	"en"), // English
		array("french",		"fr"), // French
		array("german",		"de"), // German
		array("schinese",	"cn"), // Simplified Chinese
		array("spanish",	"sp"), // Spanish
		array("tchinese",	"tw"), // Traditional Chinese
		// array("language",	"code") //TO ADD NEW LANGUAGE ARRAY HERE ...
	);

	foreach($language_array as $language){
		$patterns[] = "/\[".$language[1]."](.*)\[\/".$language[1]."\]/sU";
		if (strtolower($xoopsConfig['language']) == $language[0]) {
			$replacements[] = '\\1';
		} else {
			$replacements[] ="" ;
		}
	}
}

function xoopsCodeDecode_wmp(&$patterns,&$replacements)
{
	$patterns[] = "/\[wmp=(['\"]?)([^\"']*)\\1,(['\"]?)([^\"']*)\\1]([^\"]*)\[\/wmp\]/sU";
	if(!defined("ALLOW_WMP")||!ALLOW_WMP) {
		$replacements[] = '<a href="\\5" target="_blank">\\5</a>';
	} else {
	    $rp  ="<object classid=\"clsid:6BF52A52-394A-11D3-B153-00C04F79FAA6\" id=\"WindowsMediaPlayer\">\n";
	    $rp .="<param name=\"URL\" value=\"\\5\">\n";
	    $rp .="<param name=\"AutoStart\" value=\"0\">\n";
	    $rp .="</object>\n";
		$replacements[] =$rp;
	}
}

function xoopsCodeDecode_flash(&$patterns,&$replacements)
{
	$patterns[] = "/\[swf=(['\"]?)([^\"']*)\\1,(['\"]?)([^\"']*)\\1]([^\"]*)\[\/swf\]/sU";
	if(!defined("ALLOW_FLASH")||!ALLOW_FLASH) {
		$replacements[] = '<a href="\\5" target="_blank">\\5</a>';
	} else {
		$rp  = "<object classid='clsid:D27CDB6E-AE6D-11cf-96B8-444553540000' codebase='http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=5,0,0,0' width='\\2' height='\\4'>";
		$rp .= "<param name=movie value='\\5'>";
		$rp .= "<param name='QUALITY' value='high'>";
		$rp .= "<PARAM NAME='bgcolor' VALUE='#FFFFFF'>";
		$rp .= "<param name='wmode' value='transparent'>";
		$rp .= "<embed src='\\5' quality=high bgcolor='#FFFFFF' wmode='transparent'  pluginspage='http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash' type='application/x-shockwave-flash' width='\\2' height='\\4'></embed>";
		$rp .= "</object>";
		$replacements[] =$rp;
	}
}

function xoopsCodeDecode_mms(&$patterns,&$replacements)
{
	$patterns[] = "/\[mms=(['\"]?)([^\"']*)\\1,(['\"]?)([^\"']*)\\1]([^\"]*)\[\/mms\]/sU";
	if(!defined("ALLOW_IMAGE")||!ALLOW_IMAGE) {
		$replacements[] = '<a href="\\5" target="_blank">\\5</a>';
	} else {
		$rp = "<OBJECT id=videowindow1 height='\\4' width='\\2' classid=CLSID:6BF52A52-394A-11D3-B153-00C04F79FAA6>";
		$rp .= "<PARAM NAME=\"URL\" VALUE=\"\\5\">";
		$rp .= "<PARAM NAME=\"rate\" VALUE=\"1\">";
		$rp .= "<PARAM NAME=\"balance\" VALUE=\"0\">";
		$rp .= "<PARAM NAME=\"currentPosition\" VALUE=\"0\">";
		$rp .= "<PARAM NAME=\"defaultFrame\" VALUE=\"\">";
		$rp .= "<PARAM NAME=\"playCount\" VALUE=\"1\">";
		$rp .= "<PARAM NAME=\"autoStart\" VALUE=\"0\">";
		$rp .= "<PARAM NAME=\"currentMarker\" VALUE=\"0\">";
		$rp .= "<PARAM NAME=\"invokeURLs\" VALUE=\"-1\">";
		$rp .= "<PARAM NAME=\"baseURL\" VALUE=\"\">";
		$rp .= "<PARAM NAME=\"volume\" VALUE=\"50\">";
		$rp .= "<PARAM NAME=\"mute\" VALUE=\"0\">";
		$rp .= "<PARAM NAME=\"uiMode\" VALUE=\"full\">";
		$rp .= "<PARAM NAME=\"stretchToFit\" VALUE=\"0\">";
		$rp .= "<PARAM NAME=\"windowlessVideo\" VALUE=\"0\">";
		$rp .= "<PARAM NAME=\"enabled\" VALUE=\"-1\">";
		$rp .= "<PARAM NAME=\"enableContextMenu\" VALUE=\"-1\">";
		$rp .= "<PARAM NAME=\"fullScreen\" VALUE=\"0\">";
		$rp .= "<PARAM NAME=\"SAMIStyle\" VALUE=\"\">";
		$rp .= "<PARAM NAME=\"SAMILang\" VALUE=\"\">";
		$rp .= "<PARAM NAME=\"SAMIFilename\" VALUE=\"\">";
		$rp .= "<PARAM NAME=\"captioningID\" VALUE=\"\">";
		$rp .= "<PARAM NAME=\"enableErrorDialogs\" VALUE=\"0\">";
		$rp .= "<PARAM NAME=\"_cx\" VALUE=\"12700\">";
		$rp .= "<PARAM NAME=\"_cy\" VALUE=\"8731\">";
		$rp .= "</OBJECT>";
		$replacements[] = $rp;
	}
}

function xoopsCodeDecode_rtsp(&$patterns,&$replacements)
{
	$patterns[] = "/\[rtsp=(['\"]?)([^\"']*)\\1,(['\"]?)([^\"']*)\\1]([^\"]*)\[\/rtsp\]/sU";
	if(!defined("ALLOW_RTSP")||!ALLOW_RTSP) {
		$replacements[] = '<a href="\\5" target="_blank">\\5</a>';
	} else {
		$rp = "<object classid=\"clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA\" HEIGHT='\\4' ID=Player WIDTH='\\2' VIEWASTEXT>";
		$rp .= "<param NAME=\"_ExtentX\" VALUE=\"12726\">";
		$rp .= "<param NAME=\"_ExtentY\" VALUE=\"8520\">";
		$rp .= "<param NAME=\"AUTOSTART\" VALUE=\"0\">";
		$rp .= "<param NAME=\"SHUFFLE\" VALUE=\"0\">";
		$rp .= "<param NAME=\"PREFETCH\" VALUE=\"0\">";
		$rp .= "<param NAME=\"NOLABELS\" VALUE=\"0\">";
		$rp .= "<param NAME=\"CONTROLS\" VALUE=\"ImageWindow\">";
		$rp .= "<param NAME=\"CONSOLE\" VALUE=\"_master\">";
		$rp .= "<param NAME=\"LOOP\" VALUE=\"0\">";
		$rp .= "<param NAME=\"NUMLOOP\" VALUE=\"0\">";
		$rp .= "<param NAME=\"CENTER\" VALUE=\"0\">";
		$rp .= "<param NAME=\"MAINTAINASPECT\" VALUE=\"\\1\">";
		$rp .= "<param NAME=\"BACKGROUNDCOLOR\" VALUE=\"#000000\">";
		$rp .= "</object>";
		$rp .= "<br><object CLASSID=clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA HEIGHT=32 ID=Player WIDTH='\\2' VIEWASTEXT>";
		$rp .= "<param NAME=\"_ExtentX\" VALUE=\"18256\">";
		$rp .= "<param NAME=\"_ExtentY\" VALUE=\"794\">";
		$rp .= "<param NAME=\"AUTOSTART\" VALUE=\"0\">";
		$rp .= "<param NAME=\"SHUFFLE\" VALUE=\"0\">";
		$rp .= "<param NAME=\"PREFETCH\" VALUE=\"0\">";
		$rp .= "<param NAME=\"NOLABELS\" VALUE=\"0\">";
		$rp .= "<param NAME=\"CONTROLS\" VALUE=\"controlpanel\">";
		$rp .= "<param NAME=\"CONSOLE\" VALUE=\"_master\">";
		$rp .= "<param NAME=\"LOOP\" VALUE=\"0\">";
		$rp .= "<param NAME=\"NUMLOOP\" VALUE=\"0\">";
		$rp .= "<param NAME=\"CENTER\" VALUE=\"0\">";
		$rp .= "<param NAME=\"MAINTAINASPECT\" VALUE=\"0\">";
		$rp .= "<param NAME=\"BACKGROUNDCOLOR\" VALUE=\"#000000\">";
		$rp .= "<param NAME=\"SRC\" VALUE=\"\\5\">";
		$rp .= "</object>";

		$replacements[] = $rp;
	}
}

function xoopsCodeDecode_img(&$patterns,&$replacements)
{
	$patterns[] = "/\[img align=(['\"]?)(left|center|right)\\1 width=(['\"]?)([0-9]*)\\1]([^\"\(\)\?\&'<>]*)\[\/img\]/sU";
	$patterns[] = "/\[img align=(['\"]?)(left|center|right)\\1]([^\"\(\)\?\&'<>]*)\[\/img\]/sU";
	$patterns[] = "/\[img width=(['\"]?)([0-9]*)\\1]([^\"\(\)\?\&'<>]*)\[\/img\]/sU";
	$patterns[] = "/\[img]([^\"\(\)\?\&'<>]*)\[\/img\]/sU";
	$patterns[] = "/\[img align=(['\"]?)(left|center|right)\\1 id=(['\"]?)([0-9]*)\\3]([^\"\(\)\?\&'<>]*)\[\/img\]/sU";
	$patterns[] = "/\[img id=(['\"]?)([0-9]*)\\1]([^\"\(\)\?\&'<>]*)\[\/img\]/sU";
	if(!defined("ALLOW_IMAGE")||!ALLOW_IMAGE) {
		$replacements[] = '<a href="\\5" target="_blank">\\5</a>';
		$replacements[] = '<a href="\\3" target="_blank">\\3</a>';
		$replacements[] = '<a href="\\3" target="_blank">\\3</a>';
		$replacements[] = '<a href="\\1" target="_blank">\\1</a>';
		$replacements[] = '<a href="'.XOOPS_URL.'/image.php?id=\\4" target="_blank">\\4</a>';
		$replacements[] = '<a href="'.XOOPS_URL.'/image.php?id=\\2" target="_blank">\\3</a>';
	} else {
		if(defined("ALLOW_IMAGE_CLICKABLE")&&ALLOW_IMAGE_CLICKABLE){
			$replacements[] = "<a href='javascript:CaricaFoto(\"\\5\");'><img src='\\5' align='\\2' alt='Open in new window' border=0 onload=\"JavaScript:if(this.width>\\4)this.width=\\4\" /></a><br>";
			$replacements[] = "<a href='javascript:CaricaFoto(\"\\3\");'><img src='\\3' align='\\2' alt='Open in new window' border=0 onload=\"JavaScript:if(this.width>screen.width-540)this.width=screen.width-500\" /></a><br>";
			$replacements[] = "<a href='javascript:CaricaFoto(\"\\3\");'><img src='\\3' alt='Open in new window' border=0 onload=\"JavaScript:if(this.width>\\2)this.width=\\2\" /></a><br>";
			$replacements[] = "<a href='javascript:CaricaFoto(\"\\1\");'><img src='\\1' alt='Open in new window' border=0 onload=\"JavaScript:if(this.width>screen.width-540)this.width=540\" /></a><br>";
		}else{
			$replacements[] = "<img src='\\5' onload=\"JavaScript:if(this.width>\\4)this.width=\\4\" align='\\2' border='0' alt='' /><br />";
			$replacements[] = "<img src='\\3' onload=\"JavaScript:if(this.width>screen.width-540)this.width=screen.width-500\" align='\\2' border='0' alt='' /><br />";
			$replacements[] = "<img src='\\3' onload=\"JavaScript:if(this.width>\\2)this.width=\\2\" border='0' alt='' /><br />";
			$replacements[] = "<img src='\\1' onload=\"JavaScript:if(this.width>screen.width-540)this.width=540\" border='0' alt='' /><br />";
		}
		$replacements[] = '<img src="'.XOOPS_URL.'/image.php?id=\\4" align="\\2" alt="\\4" />';
		$replacements[] = '<img src="'.XOOPS_URL.'/image.php?id=\\2" alt="\\3" />';
	}
}

function xoopsCodeDecode_iframe(&$patterns,&$replacements)
{
	$patterns[] = "/\[iframe=(['\"]?)([^\"']*)\\1]([^\"]*)\[\/iframe\]/sU";
	if(defined("ALLOW_IFRAME")&&ALLOW_IFRAME)
		$replacements[] = "<iframe src='\\3' width='100%' height='\\2' scrolling='auto' frameborder='yes' marginwidth='0' marginheight='0' noresize></iframe>";
	else
		$replacements[] = '<a href="\\3" target="_blank">\\3</a>';
}

function xoops_phpHighlight($text)
{
	if(!defined("ALLOW_CODE_PHPHIGHLIGHT")||!ALLOW_CODE_PHPHIGHLIGHT||floor(phpversion())<4) return $text;
	$addedtags = 0;
	if (!strpos($text,"<?") and (substr($text,0,2)!="<?")) {
		$text="<?\n".trim($text)."\n?>";
		$addedtags=1;
	}
	ob_start();
	$oldlevel=error_reporting(0);
	highlight_string($text);
	error_reporting($oldlevel);
	$buffer = ob_get_contents();
	ob_end_clean();
	if ($addedtags) {
		$openingpos = strpos($buffer,'&lt;?');
		$closingpos = strrpos($buffer, '?');
		$buffer=substr($buffer, 0, $openingpos).substr($buffer, $openingpos+5, $closingpos-($openingpos+5)).substr($buffer, $closingpos+5);
	}
	return $buffer;
}

function geshi_highlight( $source, $language )
{
	if(!is_readable(XOOPS_ROOT_PATH . '/class/geshi/geshi.php')) return $source;
    include_once(XOOPS_ROOT_PATH . '/class/geshi/geshi.php');

    // Create the new GeSHi object, passing relevant stuff
    $geshi = new GeSHi($source, $language, XOOPS_ROOT_PATH . '/class/geshi/');
    // Enclose the code in a <div>
    $geshi->set_header_type(GESHI_HEADER_PRE);

    // Turn CSS classes on to reduce output code size
    $geshi->enable_classes();

    // Parse the code
    $code = $geshi->parse_code();
    //$code = str_replace('<br />', '', $code);

    return $code;
}
?>