<?php
# $Author: zx $ 
# $Date: 2003/08/15 01:35:29 $

/************************************************************************/
/* PHP-Nuke/phpBB2 Portal Checker: analyze.php				*/
/* ===========================================				*/
/*                     							*/
/* Copyright (c) 2003 by Paul Laudanski (Zhen-Xjell)			*/
/* http://nukecops.com | http://computercops.biz   			*/
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
/* Use signifies your acceptance of the AUP at NukeCops.com.            */
/************************************************************************/

function head() {
	global $appname, $PHP_SELF, $start_time;

	$mtime = microtime();
	$mtime = explode(" ",$mtime);
	$mtime = $mtime[1] + $mtime[0];
	$start_time = $mtime;

	$appname = $_SERVER['PHP_SELF'];

	if (!$appname) {
		$appname = $PHP_SELF;
	}

	?>
	<HTML>
	<HEAD>
	<TITLE>PHP-Nuke phpBB2 Analyzer by NukeCops.com</TITLE>
	</HEAD>
	<BODY bgcolor="#FFFFCC" text="#000000" link="#363636" vlink="#363636" alink="#d5ae83" LEFTMARGIN=10 TOPMARGIN=8 MARGINWIDTH=0 MARGINHEIGHT=0>
	<SPAN style="FONT-SIZE: 10pt; FONT-FAMILY: Arial">
	<?php
}

function DirectoryListing() {

	$SERVER_NAME = getenv("SERVER_NAME");

	if ($SERVER_NAME != "www.nukecops.com" && $SERVER_NAME != "beta.nukecops.com" && $SERVER_NAME != "www.computercops.biz") {

		# DirectoryListing adopted from http://www.php.net/manual/en/function.readdir.php.
		$DirectoriesToScan = array(realpath('.'));
		$DirectoriesScanned = array();
		while (count($DirectoriesToScan) > 0) {
		 foreach ($DirectoriesToScan as $DirectoryKey => $startingdir) {
		   if ($dir = @opendir($startingdir)) {
		     while (($file = readdir($dir)) !== false) {
		       if (($file != '.') && ($file != '..')) {
		        $RealPathName = realpath($startingdir.'/'.$file);
			$DirInDir[] = dirname($RealPathName);
	        	 if (is_dir($RealPathName)) {
		           if (!in_array($RealPathName, $DirectoriesScanned) && !in_array($RealPathName, $DirectoriesToScan)) {
		             $DirectoriesToScan[] = $RealPathName;
	        	   }
		         } elseif (is_file($RealPathName)) {
		           $FilesInDir[] = $RealPathName;
                         }
		       }
		     }
		    closedir($dir);
		   }
		   $DirectoriesScanned[] = $startingdir;
		 unset($DirectoriesToScan[$DirectoryKey]);
		 }
		}
	
		$FilesInDir = array_unique($FilesInDir);
		sort($FilesInDir);
		$DirInDir = array_unique($DirInDir);
		sort($DirInDir);

                echo "<B>Permissions Key</B>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
                . "<TR bgcolor=#FFCC66><TD>Value</TD><TD>Definition</TD></TR>"
                . "<TR bgcolor=#FFFF99>"
                . "<TD>0</TD><TD>No Access</TD>"
                . "</TR>"
                . "<TR bgcolor=#FFFF99>"
                . "<TD>1</TD><TD>Execute Access</TD>"
                . "</TR>"
                . "<TR bgcolor=#FFFF99>"
                . "<TD>2</TD><TD>Write Access</TD>"
                . "</TR>"
                . "<TR bgcolor=#FFFF99>"
                . "<TD>3</TD><TD>Execute & Write Access</TD>"
                . "</TR>"
                . "<TR bgcolor=#FFFF99>"
                . "<TD>4</TD><TD>Read Access</TD>"
                . "</TR>"
                . "<TR bgcolor=#FFFF99>"
                . "<TD>5</TD><TD>Execute & Read Access</TD>"
                . "</TR>"
                . "<TR bgcolor=#FFFF99>"
                . "<TD>6</TD><TD>Write & Read Access</TD>"
                . "</TR>"
                . "<TR bgcolor=#FFFF99>"
                . "<TD>7</TD><TD>Execute, Write, & Read Access</TD>"
                . "</TR>"
                . "</TABLE>"
                . "<BR>";

		echo "<B>Owner, Group, All</B>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
                . "<TR bgcolor=#FFCC66><TD>Explanation</TD></TR>"
                . "<TR bgcolor=#FFFF99>"
                . "<TD>A bold three digit number will be displayed below after each directory and file listing (resource).  <BR>The leftmost digit signifies the Owner of the resource. <BR> The middle digit signifies the Group the resource belongs to. <BR> Lastly, the rightmost digit signifies the rest of the world, or All.</TD>"
                . "</TR>"
                . "<TR bgcolor=#FFFF99>"
                . "<TD>Example: <B>777</B> = Owner, Group, and All have full Execute, Write, & Read Access.<BR> Example: <B>541</B> = Owner has Execute & Read Access, Group has Read Access, and All others have only Execute Access.<BR>Example: <B>644</B> = Owner has Write & Read Access, both Group and All others have only Read Access.</TD>"
                . "</TR>"
                . "</TABLE>"
                . "<BR>";


		echo "<H2>Non-Empty Directories Listing Section...</H2>";

		foreach ($DirInDir as $dirname) {
		 $perms = decoct(fileperms($dirname)) % 1000;
                 echo $dirname." | <B>".$perms."</B><BR>";
                }
		
		echo "<BR><H2>Files Listing Section...</H2>";
	
		foreach ($FilesInDir as $filename) {
		 $perms = decoct(fileperms($filename)) % 1000;
		 echo $filename." | <B>".$perms."</B><BR>";
		}
	} else {
		echo "<B>Feature disabled for $SERVER_NAME</B><BR>";
	}
}

function analyzerImage() {

        $img_width = $str_width + 381;
        $img_height = $str_height + 201;

        $im = ImageCreate($img_width,$img_height);

        $black = ImageColorAllocate($im, 0, 0, 0);
        $white = ImageColorAllocate($im, 255, 255, 255);
        $grey = ImageColorAllocate($im, 204, 204, 204);
	$red = ImageColorAllocate($im, 225, 0, 0);
	$blue = ImageColorAllocate($im, 0, 0, 155);

        ImageFill($im, 0,0,$white);

	$y = 0;
	for ($j = 2; $j < 32; $j++) {
		if (($j%2) == 0) {
			ImageFilledRectangle($im, 0, $y, 380, $y + 15.384615384615384615384615384615, $red);
		}
		$y = $y + 15.384615384615384615384615384615;
	}

	ImageFilledRectangle($im, 0, 0, 152, 107.69230769230769230769230769231, $blue);

  	$corners = 10;
  	$dphi = 6.265/$corners;
  	$r[0] = 6.265;
  	$r[1] = 2;
	for ($up = 15; $up < 152; $up++) {
		$j = 0;
		$ir = 0;
		if (($up%25) == 15) {
		  	for ($i = 0, $phi = 0; $i < $corners; $i++, $phi += $dphi) {
    				$points[$j] = $up+$r[$ir]*sin($phi);
    				$j++;
				$points[$j] = 15-$r[$ir]*cos($phi);
	    			$j++;
    				$ir = 1-$ir;
			}
			ImageFilledPolygon($im, $points, $corners, $white);
		  	ImagePolygon($im, $points, $corners, $white);
		}
	}

        for ($up = 15; $up < 152; $up++) {
                $j = 0;
                $ir = 0;
                if (($up%25) == 15) {
                        for ($i = 0, $phi = 0; $i < $corners; $i++, $phi += $dphi) {
                                $points[$j] = $up+$r[$ir]*sin($phi);
                                $j++;
                                $points[$j] = 34.423076923076923076923076923075-$r[$ir]*cos($phi);
                                $j++;
                                $ir = 1-$ir;
                        }
                        ImageFilledPolygon($im, $points, $corners, $white);
                        ImagePolygon($im, $points, $corners, $white);
                }
        }

        for ($up = 15; $up < 152; $up++) {
                $j = 0;
                $ir = 0;
                if (($up%25) == 15) {
                        for ($i = 0, $phi = 0; $i < $corners; $i++, $phi += $dphi) {
                                $points[$j] = $up+$r[$ir]*sin($phi);
                                $j++;
                                $points[$j] = 53.84615384615384615384615384615-$r[$ir]*cos($phi);
                                $j++;
                                $ir = 1-$ir;
                        }
                        ImageFilledPolygon($im, $points, $corners, $white);
                        ImagePolygon($im, $points, $corners, $white);
                }
        }

        for ($up = 15; $up < 152; $up++) {
                $j = 0;
                $ir = 0;
                if (($up%25) == 15) {
                        for ($i = 0, $phi = 0; $i < $corners; $i++, $phi += $dphi) {
                                $points[$j] = $up+$r[$ir]*sin($phi);
                                $j++;
                                $points[$j] = 73.269230769230769230769230769225-$r[$ir]*cos($phi);
                                $j++;
                                $ir = 1-$ir;
                        }
                        ImageFilledPolygon($im, $points, $corners, $white);
                        ImagePolygon($im, $points, $corners, $white);
                }
        }

        for ($up = 15; $up < 152; $up++) {
                $j = 0;
                $ir = 0;
                if (($up%25) == 15) {
                        for ($i = 0, $phi = 0; $i < $corners; $i++, $phi += $dphi) {
                                $points[$j] = $up+$r[$ir]*sin($phi);
                                $j++;
                                $points[$j] = 92.6923076923076923076923076923-$r[$ir]*cos($phi);
                                $j++;
                                $ir = 1-$ir;
                        }
                        ImageFilledPolygon($im, $points, $corners, $white);
                        ImagePolygon($im, $points, $corners, $white);
                }
        }

        for ($up = 27; $up < 152; $up++) {
                $j = 0;
                $ir = 0;
                if (($up%25) == 2) {
                        for ($i = 0, $phi = 0; $i < $corners; $i++, $phi += $dphi) {
                                $points[$j] = $up+$r[$ir]*sin($phi);
                                $j++;
                                $points[$j] = 24.711538461538461538461538461535-$r[$ir]*cos($phi);
                                $j++;
                                $ir = 1-$ir;
                        }
                        ImageFilledPolygon($im, $points, $corners, $white);
                        ImagePolygon($im, $points, $corners, $white);
                }
        }

        for ($up = 27; $up < 152; $up++) {
                $j = 0;
                $ir = 0;
                if (($up%25) == 2) {
                        for ($i = 0, $phi = 0; $i < $corners; $i++, $phi += $dphi) {
                                $points[$j] = $up+$r[$ir]*sin($phi);
                                $j++;
                                $points[$j] = 44.13461538461538461538461538461-$r[$ir]*cos($phi);
                                $j++;
                                $ir = 1-$ir;
                        }
                        ImageFilledPolygon($im, $points, $corners, $white);
                        ImagePolygon($im, $points, $corners, $white);
                }
        }

        for ($up = 27; $up < 152; $up++) {
                $j = 0;
                $ir = 0;
                if (($up%25) == 2) {
                        for ($i = 0, $phi = 0; $i < $corners; $i++, $phi += $dphi) {
                                $points[$j] = $up+$r[$ir]*sin($phi);
                                $j++;
                                $points[$j] = 63.557692307692307692307692307685-$r[$ir]*cos($phi);
                                $j++;
                                $ir = 1-$ir;
                        }
                        ImageFilledPolygon($im, $points, $corners, $white);
                        ImagePolygon($im, $points, $corners, $white);
                }
        }

        for ($up = 27; $up < 152; $up++) {
                $j = 0;
                $ir = 0;
                if (($up%25) == 2) {
                        for ($i = 0, $phi = 0; $i < $corners; $i++, $phi += $dphi) {
                                $points[$j] = $up+$r[$ir]*sin($phi);
                                $j++;
                                $points[$j] = 82.98076923076923076923076923076-$r[$ir]*cos($phi);
                                $j++;
                                $ir = 1-$ir;
                        }
                        ImageFilledPolygon($im, $points, $corners, $white);
                        ImagePolygon($im, $points, $corners, $white);
                }
        }


        Header("Content-type: image/jpeg");
        $text_color = imagecolorallocate ($im, 70, 70, 70);
        imagejpeg($im, '', 100);
        imagedestroy($im);

	# Proportions obtained from http://www.math.grin.edu/~stone/courses/scheme/exercises/American-flag.xhtml
	# - The ratio between the long dimension of the flag (its ``fly'') and its short dimension (its ``hoist'') is 19/10. 
	# - The ratio between the hoist of any of the red or white stripes and the hoist of the whole flag is 1/13. 
	# - The ratio between the hoist of the Union (the blue rectangle in the upper left-hand corner) and the hoist of the whole flag is 7/13. 
	# - The ratio between the fly of the Union and the hoist of the whole flag is 76/100. 
	# - The ratio between the diameter of a circle circumscribing any of the white stars and the hoist of the whole flag is 616/10000. 


}

function main() {
	global $prefix, $user_prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $Default_Theme, $language, $locale, $Version_Num, $sitekey;
	global $NCsitename, $NCVersion_Num, $SERVER_NAME, $NClanguage, $NClocale, $NCsitekey, $dbi, $NCDefault_Theme, $appname;
	$sitekey = 0;
	require("config.php");

	$NClocale = $locale;
	$NClanguage = $language;
	$NCDefault_Theme = $Default_Theme;
	$NCVersion_Num = $Version_Num;
	$SERVER_NAME = getenv("SERVER_NAME");
	$NCsitekey = $sitekey;

	echo "Click <a href=\"$appname?zx=ls\">here</a> for a recursive listing of your current working directory: ". getcwd() ."<BR><BR>";

	$dbi = @mysql_connect("$dbhost", "$dbuname", "$dbpass") or die("
                <B>Your config.php values</B>
                <TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">
                <TR bgcolor=#FFCC66><TD>Type</TD><TD>Value</TD></TR>
                <TR bgcolor=#FFFF99>
                <TD>dbhost</TD><TD>$dbhost</TD>
                </TR>
                <TR bgcolor=#FFFF99>
                <TD>dbname</TD><TD>$dbname</TD>
                </TR>
                <TR bgcolor=#FFFF99>
                <TD>dbuname</TD><TD>$dbuname</TD>
                </TR>
                <TR bgcolor=#FFFF99>
                <TD>prefix</TD><TD>$prefix</TD>
                </TR>
                <TR bgcolor=#FFFF99>
                <TD>user_prefix</TD><TD>$user_prefix</TD>
                </TR>
                <TR bgcolor=#FFFF99>
                <TD>dbtype</TD><TD>$dbtype</TD>
                </TR>
                </TABLE>
                <BR><BR><B>Could not connect to your MySQL Database, visit <a href=\"http://nukecops.com\">Nuke Cops</a> for support..</B><BR><BR><STRONG>MySQL Error:</STRONG><i> ".mysql_error()."</i>");
	
	mysql_select_db("$dbname") or die("
                <B>Your config.php values</B>
                <TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">
                <TR bgcolor=#FFCC66><TD>Type</TD><TD>Value</TD></TR>
                <TR bgcolor=#FFFF99>
                <TD>dbhost</TD><TD>$dbhost</TD>
                </TR>
                <TR bgcolor=#FFFF99>
                <TD>dbname</TD><TD>$dbname</TD>
                </TR>
                <TR bgcolor=#FFFF99>
                <TD>dbuname</TD><TD>$dbuname</TD>
                </TR>
                <TR bgcolor=#FFFF99>
                <TD>prefix</TD><TD>$prefix</TD>
                </TR>
                <TR bgcolor=#FFFF99>
                <TD>user_prefix</TD><TD>$user_prefix</TD>
                </TR>
                <TR bgcolor=#FFFF99>
                <TD>dbtype</TD><TD>$dbtype</TD>
                </TR>
                </TABLE><BR><BR><B>Could not select your database. Visit <a href=\"http://nukecops.com\">Nuke Cops</a> for support..</B><BR><BR><STRONG>MySQL Error:</STRONG><i> ".mysql_error()."</i>");
}

function secchk() {
	global $prefix, $user_prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $Default_Theme, $language, $locale, $Version_Num, $sitekey;
        global $NCsitename, $NCVersion_Num, $SERVER_NAME, $NClanguage, $NClocale, $NCsitekey, $dbi, $NCFver;
	if (phpversion() < "4.3.2") {
                echo "<H2>WARNING! WARNING! WARNING! Vulnerable PHP On Your Server!</H2>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\" bgcolor=#660000>"
                . "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>PHP Version</FONT></TD><TD><FONT COLOR=#FFCC00>Reason For Vulnerability</FONT></TD></TR>"
                . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>". phpversion() ."</FONT></TD><TD><FONT COLOR=#FFFFFF>Your Server may be vulnerable to Cross-site Scripting in PHP's Transparent Session ID Support.  Versions prior to 4.3.2 are affected.  Tell your host to read the SecurityFocus report by clicking --> <a href=\"http://www.securityfocus.com/bid/7761/credit/\"><FONT COLOR=#FFCC00>here</FONT></a>. Until that is resolved, PHP-Nuke should be the least of your worries.</FONT></TD></TR>"
                . "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>AFFECTED VERSIONS:</FONT></TD>"
                . "<TD><FONT COLOR=#FFCC00>Constraints</FONT></TD></TR>"
                . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>4.3.0 and 4.3.1</FONT></TD>"
                . "<TD><FONT COLOR=#FFFFFF>with php.ini containing session.use_trans_sid=1</FONT></TD></TR>"
                . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>4.2.0 to 4.2.3</FONT></TD>"
                . "<TD><FONT COLOR=#FFFFFF>without php.ini, or with php.ini containing session.use_trans_sid=1"
                . "(php.ini-dist and php.ini-recommended from the PHP source distribution had use_trans_sid=1 "
                . "from 4.2.0 to 4.2.2, and use_trans_sid=0 for 4.2.3 and later versions.)</FONT></TD></TR>"
                . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>prior to 4.2.0</FONT></TD>"
                . "<TD><FONT COLOR=#FFFFFF>compiled with --enable-trans-sid and with session.use_trans_sid=1"
                . "</FONT></TD></TR>"
		. "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>FIXED VERSIONS:</FONT></TD>"
                . "<TD><FONT COLOR=#FFCC00>Suggestion</FONT></TD></TR>"
		. "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>4.3.2 or later</FONT></TD>"
                . "<TD><FONT COLOR=#FFFFFF>Backup your system and upgrade PHP, also read the article at SecurityFocus.  "
		. "Solution 1 from Security Focus: <a href=\"http://www.securityfocus.com/bid/7761/solution/\"><FONT COLOR=#FFCC00>"
		. "Click</FONT></a>, "
		. " Solution 2 from thathost: <a href=\"http://shh.thathost.com/secadv/2003-05-11-php.txt\"><FONT COLOR=#FFCC00>"
		. "Click</FONT></a>."
		. "  Solution 1 suggests the use of mod_security, which is an Apache module discussed at Nuke Cops: "
		. "<a href=\"http://nukecops.com/article39.html\"><FONT COLOR=#FFCC00>Here</FONT></a>"
		. "</FONT></TD></TR>"
                . "</TABLE><BR><BR>";
	} elseif (phpversion() == "3.0" || phpversion() == "4.06" || phpversion() == "4.10" || phpversion() == "4.11") {
                echo "<H2>WARNING! WARNING! WARNING! Vulnerable PHP On Your Server!</H2>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\" bgcolor=#660000>"
                . "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>PHP Version</FONT></TD><TD><FONT COLOR=#FFCC00>Reason For Vulnerability</FONT></TD></TR>"
                . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>". phpversion() ."</FONT></TD><TD><FONT COLOR=#FFFFFF>This PHP version contains a vulnerability in \"php_mime_split\" function allowing arbitrary code execution.  Tell your host to read the CERT/CC Vulnerability Note VU#297363 by clicking --> <a href=\"http://www.kb.cert.org/vuls/id/297363\"><FONT COLOR=#FFCC00>here</FONT></a>. Until that is resolved, PHP-Nuke should be the least of your worries.</FONT></TD></TR>"
                . "</TABLE><BR><BR>";
        } elseif (preg_match ("/3.0.1/", phpversion()) || preg_match ("/4.0./", phpversion()) || phpversion() == "4.1.0"  || phpversion() == "4.1.1") {
                echo "<H2>WARNING! WARNING! WARNING! Vulnerable PHP On Your Server!</H2>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\" bgcolor=#660000>"
                . "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>PHP Version</FONT></TD><TD><FONT COLOR=#FFCC00>Reason For Vulnerability</FONT></TD></TR>"
                . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>". phpversion() ."</FONT></TD><TD><FONT COLOR=#FFFFFF>This PHP version contains a file uploads vulnerability.  Tell your host to read the e-matters Advisory 01/2002 by clicking --> <a href=\"http://security.e-matters.de/advisories/012002.html\"><FONT COLOR=#FFCC00>here</FONT></a>. Until that is resolved, PHP-Nuke should be the least of your worries.</FONT></TD></TR>"
                . "</TABLE><BR><BR>";
        } elseif (phpversion() == "4.2.0" || phpversion() == "4.2.1") {
                echo "<H2>WARNING! WARNING! WARNING! Vulnerable PHP On Your Server!</H2>"
		. "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\" bgcolor=#660000>"
                . "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>PHP Version</FONT></TD><TD><FONT COLOR=#FFCC00>Reason For Vulnerability</FONT></TD></TR>"
                . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>". phpversion() ."</FONT></TD><TD><FONT COLOR=#FFFFFF>This PHP version fails to properly parse the headers of HTTP POST requests.  Tell your host to read the CERT/CC Vulnerability Note VU#929115 by clicking --> <a href=\"http://www.kb.cert.org/vuls/id/929115\"><FONT COLOR=#FFCC00>here</FONT></a>. Until that is resolved, PHP-Nuke should be the least of your worries. Please reference PHP.net directly for a full review of this serious vulnerability: --> <a href=\"http://www.php.net/release_4_2_2.php\"><FONT COLOR=#FFCC00>click here</FONT></a></FONT>.</TD></TR>"
                . "</TABLE></FONT><BR><BR>";
        } elseif (phpversion() == "4.3.0") {
                echo "<H2>WARNING! WARNING! WARNING! Vulnerable PHP On Your Server!</H2>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\" bgcolor=#660000>"
                . "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>PHP Version</FONT></TD><TD><FONT COLOR=#FFCC00>Reason For Vulnerability</FONT></TD></TR>"
                . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>". phpversion() ."</FONT></TD><TD><FONT COLOR=#FFFFFF>PHP Security Advisory: CGI vulnerability in PHP version 4.3.0.  <BR><BR>PHP contains code for preventing direct access to the CGI binary with configure option \"--enable-force-cgi-redirect\" and php.ini option \"cgi.force_redirect\". In PHP 4.3.0 there is a bug which renders these options useless.  For a full report go here --> <a href=\"http://www.php.net/release_4_3_1.php\"><FONT COLOR=#FFCC00>here</FONT></a>. <BR><BR>Solution is to <a href=\"http://www.php.net/downloads.php\">upgrade</a> to PHP 4.3.1 as there are no other workarounds. <BR><BR>The impact: \"Anyone with access to websites hosted on a web server which employs the CGI module may exploit this vulnerability to gain access to any file readable by the user under which the webserver runs. A remote attacker could also trick PHP into executing arbitrary PHP code if attacker is able to inject the code into files accessible by the CGI. This could be for example the web server access-logs.\" <BR><BR>Until that is resolved, PHP-Nuke should be the least of your worries. </FONT>.</TD></TR>"
                . "</TABLE></FONT><BR><BR>";
	}

        if (mysql_get_server_info() < "3.23.55") {
                echo "<H2>WARNING! WARNING! WARNING! Vulnerable MySQL Server On Your Server!</H2>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\" bgcolor=#660000>"
                . "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>MySQL Server Version</FONT></TD><TD><FONT COLOR=#FFCC00>Reason For Vulnerability</FONT></TD></TR>"
                . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>". mysql_get_server_info() ."</FONT></TD><TD><FONT COLOR=#FFFFFF>A vulnerability has been discovered in MySQL that may cause a denial of service. It has been reported that, under certain circumstances, a malicious MySQL client may be able to trigger a condition in which MySQL attempts to free the same memory twice.  MySQL Daemon can be crashed unless upgraded. Details can be found by clicking --> <a href=\"http://www.mysql.com/doc/en/News-3.23.55.html\"><FONT COLOR=#FFCC00>here</FONT></a>. Until that is resolved, PHP-Nuke should be the least of your worries.</FONT></TD></TR>"
                . "</TABLE><BR>";
        }


        if (mysql_get_server_info() < "3.23.33") {
                echo "<H2>WARNING! WARNING! WARNING! Vulnerable MySQL Server On Your Server!</H2>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\" bgcolor=#660000>"
                . "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>MySQL Server Version</FONT></TD><TD><FONT COLOR=#FFCC00>Reason For Vulnerability</FONT></TD></TR>"
                . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>". mysql_get_server_info() ."</FONT></TD><TD><FONT COLOR=#FFFFFF>This MySQL Server version monitor drop database command contains buffer overflow.  Tell your host to read the CERT/CC Vulnerability Note VU#367320 by clicking --> <a href=\"http://www.kb.cert.org/vuls/id/367320\"><FONT COLOR=#FFCC00>here</FONT></a>. Until that is resolved, PHP-Nuke should be the least of your worries.</FONT></TD></TR>"
                . "</TABLE><BR>";
        }


	if ( $NCsitekey ) {
		if ($NCsitekey == "SdFk*fa28367-dm56w69.3a2fDS+e9") {
			echo "<H2>WARNING! WARNING! WARNING! Your config.php \$sitekey has the default value!</H2>"
	                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\" bgcolor=#660000>"
        	        . "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>\$sitekey value</FONT></TD><TD><FONT COLOR=#FFCC00>Reason For Vulnerability</FONT></TD></TR>"
                	. "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>". $sitekey ."</FONT></TD><TD><FONT COLOR=#FFFFFF>PHP-Nuke has a default \$sitekey value as distributed in config.php.  You should change this immediately to a unique value only you know.</FONT></TD></TR>"
	                . "</TABLE><BR>";
		}
	}

	if (get_cfg_var('magic_quotes_gpc') == "0") {
		echo "<H2>WARNING! WARNING! WARNING! Your PHP-Nuke Site is open to SQL Injection Attack!</H2>"
                        . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\" bgcolor=#660000>"
                        . "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>php.ini magic_quotes.gpc value</FONT></TD><TD><FONT COLOR=#FFCC00>Reason For Vulnerability</FONT></TD></TR>"
                        . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>Not Enabled (Not \"On\")</FONT></TD><TD><FONT COLOR=#FFFFFF>If your <b>magic_quotes_gpc</b> is not <b>On</b>, as it currently isn't, you  should change this immediately to the <b>On</b> value. If left disabled then your site is susceptible to member password retrieval and member admin escalation.  For full details and exploits for testing go <a href=\"http://www.securityfocus.com/archive/1/314104/2003-03-03/2003-03-09/0\">here</a>. For details on exactly what code to insert if you cannot enable magic_quotes_gpc read <a href=\"http://www.computercops.biz/postlite2543-.html\">here</a>.</FONT></TD></TR>"
                        . "</TABLE><BR>";
	}

	if (file_exists("modules/WebMail/mailattach.php")) {
		echo "<H2>WARNING! WARNING! WARNING! Your PHP-Nuke Site is open to a WebMail Attack!</H2>"
                        . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\" bgcolor=#660000>"
                        . "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>path/filename</FONT></TD><TD><FONT COLOR=#FFCC00>Reason For Vulnerability</FONT></TD></TR>"
                        . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>modules/WebMail/mailattach.php</FONT></TD><TD><FONT COLOR=#FFFFFF>Highly advised by Francisco Burzi (nukelite) and Nuke Cops, this file should be removed completely from your system regardless of WebMail activation.  This file can be used to copy any file on your system and make it available for download.  You don't want your config.php file downloaded do you? Remove this file immediately!</FONT></TD></TR>"
                        . "</TABLE><BR>";
	}

	// nukesql.php check added by recommendation from chatserv
        if (file_exists("nukesql.php")) {
                echo "<H2>WARNING! WARNING! WARNING! Your PHP-Nuke Database Tables are at Risk!</H2>"
                        . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\" bgcolor=#660000>"
                        . "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>path/filename</FONT></TD><TD><FONT COLOR=#FFCC00>Reason For Vulnerability</FONT></TD></TR>"
                        . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>nukesql.php</FONT></TD><TD><FONT COLOR=#FFFFFF>This Web Browser based tables installer should have been deleted after it was used. This file can be used to run a Replace Tables which will empty your site's database tables, thus allowing anyone to restart your site and become a Superuser. You wouldn't want to have to start all over again do you? Remove this file immediately!</FONT></TD></TR>"
                        . "</TABLE><BR>";
        }

        if ($NCVersion_Num < "6.5") {
                echo "<H2>WARNING! WARNING! WARNING! Your PHP-Nuke CMS Is Old!</H2>"
                        . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\" bgcolor=#660000>"
                        . "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>Your Version</FONT></TD><TD><FONT COLOR=#FFCC00>Reason For Vulnerability</FONT></TD></TR>"
                        . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>$NCVersion_Num</FONT></TD><TD><FONT COLOR=#FFFFFF>PHP-Nuke, with each new release (currently at 6.5), fixes vulnerabilities and exploits that older versions are susceptible to.  This is a general alert for you to be aware that running older PHP-Nuke versions may leave it open to such attacks.  It is your choice whether to upgrade or not to the newest version (regardless of status: gold, release candidate, or beta).  But if you do decide to upgrade, for your sake make sure you backup 100% your MySQL database and all of your filesystem files.</FONT></TD></TR>"
                        . "</TABLE><BR>";
        }

        if ($NCFver < ".0.4") {
                echo "<H2>WARNING! WARNING! WARNING! Your phpbb2 forums are at Risk!</H2>"
                        . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\" bgcolor=#660000>"
                        . "<TR bgcolor=#990000><TD><FONT COLOR=#FFCC00>Version</FONT></TD><TD><FONT COLOR=#FFCC00>Reason For Vulnerability</FONT></TD></TR>"
                        . "<TR bgcolor=#CC0000><TD><FONT COLOR=#FFFFFF>2$NCFver</FONT></TD><TD><FONT COLOR=#FFFFFF>The phpBB group at <a href=\"http://phpbb.com\">phpBB.com</a> frequently update their forums software to eliminate known vulnerabilities and exploits.  Analyzer has found that your forums port is not the newest release: 2.0.4.  Please visit http://nukecops.com in order to obtain an upgrade package to 2.0.4.  By not staying current in phpBB upgrades you leave your forums open to attack.  The choice to upgrade, backup, or stay at current version is 100% completely yours, all we have done is alerted you to it.</FONT></TD></TR>"
                        . "</TABLE><BR>";
        }


}

function configconn() {
	global $prefix, $user_prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $Default_Theme, $language, $locale, $Version_Num, $sitekey;
        global $NCsitename, $NCVersion_Num, $SERVER_NAME, $NClanguage, $NClocale, $NCsitekey, $dbi;

	if ($SERVER_NAME != "www.nukecops.com" && $SERVER_NAME != "beta.nukecops.com" && $SERVER_NAME != "www.computercops.biz") {
        	echo "<B>Your config.php values</B>"
	        . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
        	. "<TR bgcolor=#FFCC66><TD>Type</TD><TD>Value</TD></TR>"
	        . "<TR bgcolor=#FFFF99>"
        	. "<TD>dbhost</TD><TD>$dbhost</TD>"
	        . "</TR>"
        	. "<TR bgcolor=#FFFF99>"
	        . "<TD>dbname</TD><TD>$dbname</TD>"
        	. "</TR>"
		. "<TR bgcolor=#FFFF99>"
        	. "<TD>dbuname</TD><TD>$dbuname</TD>"
	        . "</TR>"
        	. "<TR bgcolor=#FFFF99>"
	        . "<TD>prefix</TD><TD>$prefix</TD>"
        	. "</TR>"
	        . "<TR bgcolor=#FFFF99>"
        	. "<TD>user_prefix</TD><TD>$user_prefix</TD>"
	        . "</TR>"
        	. "<TR bgcolor=#FFFF99>"
	        . "<TD>dbtype</TD><TD>$dbtype</TD>"
        	. "</TR>"
	        . "</TABLE>"
        	. "<BR>";
	}
}

// Begin Raven's code block contribution from Nuke Cops

function my_gd_info() { 
      $array = Array( 
                      "GD Version" => "", 
                      "FreeType Support"=> 0, 
                      "FreeType Support" => 0, 
                      "FreeType Linkage" => "", 
                      "T1Lib Support" => 0, 
                      "GIF Read Support" => 0, 
                      "GIF Create Support" => 0, 
                      "JPG Support" => 0, 
                      "PNG Support" => 0, 
                      "WBMP Support" => 0, 
                      "XBM Support" => 0 
      ); 
      $gif_support = 0; 

      ob_start(); 
      eval("phpinfo();"); 
      $info = ob_get_contents(); 
      ob_end_clean(); 

      foreach(explode("\n", $info) as $line) { 
          if(strpos($line, "GD Version")!==false) 
              $array["GD Version"] = trim(str_replace("GD Version", "", strip_tags($line))); 
          if(strpos($line, "FreeType Support")!==false) 
              $array["FreeType Support"] = trim(str_replace("FreeType Support", "", strip_tags($line))); 
          if(strpos($line, "FreeType Linkage")!==false) 
              $array["FreeType Linkage"] = trim(str_replace("FreeType Linkage", "", strip_tags($line))); 
          if(strpos($line, "T1Lib Support")!==false) 
              $array["T1Lib Support"] = trim(str_replace("T1Lib Support", "", strip_tags($line))); 
          if(strpos($line, "GIF Read Support")!==false) 
              $array["GIF Read Support"] = trim(str_replace("GIF Read Support", "", strip_tags($line))); 
          if(strpos($line, "GIF Create Support")!==false) 
              $array["GIF Create Support"] = trim(str_replace("GIF Create Support", "", strip_tags($line))); 
          if(strpos($line, "GIF Support")!==false) 
              $gif_support = trim(str_replace("GIF Support", "", strip_tags($line))); 
          if(strpos($line, "JPG Support")!==false) 
              $array["JPG Support"] = trim(str_replace("JPG Support", "", strip_tags($line))); 
          if(strpos($line, "PNG Support")!==false) 
              $array["PNG Support"] = trim(str_replace("PNG Support", "", strip_tags($line))); 
          if(strpos($line, "WBMP Support")!==false) 
              $array["WBMP Support"] = trim(str_replace("WBMP Support", "", strip_tags($line))); 
          if(strpos($line, "XBM Support")!==false) 
              $array["XBM Support"] = trim(str_replace("XBM Support", "", strip_tags($line))); 
      } 

      if($gif_support==="enabled") { 
          $array["GIF Read Support"]   = 1; 
          $array["GIF Create Support"] = 1; 
      } 

      if($array["FreeType Support"]==="enabled"){ 
          $array["FreeType Support"] = 1;    } 

      if($array["T1Lib Support"]==="enabled") 
          $array["T1Lib Support"] = 1; 

      if($array["GIF Read Support"]==="enabled"){ 
          $array["GIF Read Support"] = 1;    } 

      if($array["GIF Create Support"]==="enabled") 
          $array["GIF Create Support"] = 1; 

      if($array["JPG Support"]==="enabled") 
          $array["JPG Support"] = 1; 

      if($array["PNG Support"]==="enabled") 
          $array["PNG Support"] = 1; 

      if($array["WBMP Support"]==="enabled") 
          $array["WBMP Support"] = 1; 

      if($array["XBM Support"]==="enabled") 
          $array["XBM Support"] = 1; 

      return $array; 
} 

// End Raven's Contribution

function gdchk() {
	global $prefix, $user_prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $Default_Theme, $language, $locale, $Version_Num, $sitekey;
        global $NCsitename, $NCVersion_Num, $SERVER_NAME, $NClanguage, $NClocale, $NCsitekey, $dbi;

        if (extension_loaded("gd")) {
                if (phpversion() >= "4.3.0") {
                        $gi = gd_info();
                        $gi1 = $gi['GD Version'];
                        $gi2 = $gi['FreeType Support'];
                        if ($gi2) { $gi2 = "Yes"; } else { $gi2 = "No"; }
                        $gi3 = $gi['T1Lib Support'];
                        if ($gi3) { $gi3 = "Yes"; } else { $gi3 = "No"; }
                        $gi4 = $gi['GIF Read Support'];
                        if ($gi4) { $gi4 = "Yes"; } else { $gi4 = "No"; }
                        $gi5 = $gi['GIF Create Support'];
                        if ($gi5) { $gi5 = "Yes"; } else { $gi5 = "No"; }
                        $gi6 = $gi['JPG Support'];
                        if ($gi6) { $gi6 = "Yes"; } else { $gi6 = "No"; }
                        $gi7 = $gi['PNG Support'];
                        if ($gi7) { $gi7 = "Yes"; } else { $gi7 = "No"; }
                        $gi8 = $gi['WBMP Support'];
                        if ($gi8) { $gi8 = "Yes"; } else { $gi8 = "No"; }
                        $gi9 = $gi['XBM Support'];
                        if ($gi9) { $gi9 = "Yes"; } else { $gi9 = "No"; }

// Begin Raven's code block contribution

		} else { 
                  $gi = my_gd_info(); 
                        $gi1 = $gi['GD Version']; 
                        $gi2 = $gi['FreeType Support']; 
                        if ($gi2) { $gi2 = "Yes"; } else { $gi2 = "No"; } 
                        $gi3 = $gi['T1Lib Support']; 
                        if ($gi3) { $gi3 = "Yes"; } else { $gi3 = "No"; } 
                        $gi4 = $gi['GIF Read Support']; 
                        if ($gi4) { $gi4 = "Yes"; } else { $gi4 = "No"; } 
                        $gi5 = $gi['GIF Create Support']; 
                        if ($gi5) { $gi5 = "Yes"; } else { $gi5 = "No"; } 
                        $gi6 = $gi['JPG Support']; 
                        if ($gi6) { $gi6 = "Yes"; } else { $gi6 = "No"; } 
                        $gi7 = $gi['PNG Support']; 
                        if ($gi7) { $gi7 = "Yes"; } else { $gi7 = "No"; } 
                        $gi8 = $gi['WBMP Support']; 
                        if ($gi8) { $gi8 = "Yes"; } else { $gi8 = "No"; } 
                        $gi9 = $gi['XBM Support']; 
                        if ($gi9) { $gi9 = "Yes"; } else { $gi9 = "No"; } 
                } 

// End Raven's code block contribution

                        ?>
                        <B>GD Library Information</B>
                        <TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">
                        <TR bgcolor=#FFCC66><TD>Type</TD><TD>Value</TD></TR>
                        <TR bgcolor=#FFFF99>
                        <TD>GD Version</TD><TD><?php echo $gi1; ?></TD>
                        </TR>
                        <TR bgcolor=#FFFF99>
                        <TD>FreeType Support</TD><TD><?php echo $gi2; ?></TD>
                        </TR>
                        <TR bgcolor=#FFFF99>
                        <TD>T1Lib Support</TD><TD><?php echo $gi3; ?></TD>
                        </TR>
                        <TR bgcolor=#FFFF99>
                        <TD>GIF Read Support</TD><TD><?php echo $gi4; ?></TD>
                        </TR>
                        <TR bgcolor=#FFFF99>
                        <TD>GIF Create Support</TD><TD><?php echo $gi5; ?></TD>
                        </TR>
                        <TR bgcolor=#FFFF99>
                        <TD>JPG Support</TD><TD><?php echo $gi6; ?></TD>
                        </TR>
                        <TR bgcolor=#FFFF99>
                        <TD>PNG Support</TD><TD><?php echo $gi7; ?></TD>
                        </TR>
                        <TR bgcolor=#FFFF99>
                        <TD>WBMP Support</TD><TD><?php echo $gi8; ?></TD>
                        </TR>
                        <TR bgcolor=#FFFF99>
                        <TD>XBM Support</TD><TD><?php echo $gi9; ?></TD>
                        </TR>
                        </TABLE><BR>
                        <?php
	        } else {
        	        ?>
                	<B>GD Library Information</B>
	                <TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">
        	        <TR bgcolor=#FFCC66><TD>Extension Status</TD></TR>
                	<TR bgcolor=#FFFF99>
	                <TD>Not-Loaded</TD>
        	        </TR>
                	</TABLE><BR>
	                <?php
	        }
}

function verchk() {
	global $prefix, $user_prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $Default_Theme, $language, $locale, $Version_Num, $sitekey;
        global $NCsitename, $NCVersion_Num, $SERVER_NAME, $NClanguage, $NClocale, $NCsitekey, $dbi, $NCDefault_Theme, $NCFver;

	$sql = "DESCRIBE ".$prefix."_config";
	$NCresult = mysql_num_rows(mysql_query($sql));

	if ($NCresult > 2) {
		$sql = "select sitename, Default_Theme, Version_Num, locale, language from ".$prefix."_config";
		$result = mysql_query($sql);
			if (mysql_num_rows($result)) {
				while (list($sitename, $Default_Theme, $Version_Num, $locale, $language) = mysql_fetch_row($result)) {
				$NCsitename = $sitename;
				$NCDefault_Theme = $Default_Theme;
				$NCVersion_Num = $Version_Num;
				$NClocale = $locale;
				$NClanguage = $language;
				}
			} 
		mysql_free_result($result);
	} elseif ($NCresult = 2) { 
		$sql = "select config_value from ".$prefix."_config where config_name='sitename'";
		$result = mysql_query($sql);
		if (mysql_num_rows($result)) {
		        while (list($config_value) = mysql_fetch_row($result)) {
                	        $NCsitename = $config_value;
			}
                }
		mysql_free_result($result);
		$sql = "select config_value from ".$prefix."_config where config_name='default_lang'";
		$result = mysql_query($sql);
		if (mysql_num_rows($result)) {
			while (list($config_value) = mysql_fetch_row($result)) {
				$NClanguage = $config_value;
			}
		}
		mysql_free_result($result);
	}

	$sqlNew = "select config_value from ".$prefix."_config where config_name='version'";
	$resultNew = mysql_query($sqlNew);
	if ($resultNew) {
		while (list($config_value) = mysql_fetch_row(mysql_query($sqlNew))) {
			$NCFver = $config_value;
		}
	} else {
		$sqlToo = "select config_value from ".$prefix."_bbconfig where config_name='version'";
		$resultToo = mysql_query($sqlToo);
		if ($resultToo) {
			list($config_value) = mysql_fetch_row(mysql_query($sqlToo));
			$NCFver = $config_value;
		}
	}
}

function bulk() {
	global $prefix, $user_prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $Default_Theme, $language, $locale, $Version_Num, $sitekey;
        global $NCsitename, $NCVersion_Num, $SERVER_NAME, $NClanguage, $NClocale, $NCsitekey, $dbi, $NCDefault_Theme, $NCFver; 

	$sql = "select bc.config_value, bt.style_name, bt.template_name from ".$prefix."_bbthemes bt, ".$prefix."_bbconfig bc where bc.config_name='default_style' and bc.config_value=bt.themes_id";
	$result = mysql_query($sql);

        echo "<B>MySQL Connection Transcript for $NCsitename</B>"
        . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
        . "<TR bgcolor=#FFCC66><TD>Destination</TD><TD>Result</TD></TR>"
	. "<TR bgcolor=#FFFF99>"
        . "<TD>MySQL Health Check</TD><TD>Successful</TD>"
        . "</TR>";

	if ($SERVER_NAME != "www.nukecops.com" && $SERVER_NAME != "beta.nukecops.com" && $SERVER_NAME != "www.computercops.biz") {
		echo "<TR bgcolor=#FFFF99>"
	        . "<TD>MySQL Server: <I>$dbhost</I></TD><TD>Successful</TD>"
        	. "</TR>"
		. "<TR bgcolor=#FFFF99>"
		. "<TD>MySQL Datbase: <I>$dbname</I></TD><TD>Successful</TD>"
		. "</TR>"
        	. "<TR bgcolor=#FFFF99>"
	        . "<TD>MySQL Username: <I>$dbuname</I></TD><TD>Successful</TD>"
        	. "</TR>"
	        . "</TABLE>"
        	. "<BR>";
	} else {
		echo "</TABLE><BR>";
	}

        if ($SERVER_NAME != "www.nukecops.com" && $SERVER_NAME != "beta.nukecops.com" && $SERVER_NAME != "www.computercops.biz") {
	        echo "<B>PHP Specific Values for $NCsitename</B>"
        	. "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
	        . "<TR bgcolor=#FFCC66><TD>Category</TD><TD>Value</TD></TR>"
        	. "<TR bgcolor=#FFFF99><TD>PHP Version</TD><TD>". phpversion() ."</TD></TR>"
		. "</TABLE><BR>";
	}

	if ($SERVER_NAME != "www.nukecops.com" && $SERVER_NAME != "beta.nukecops.com" && $SERVER_NAME != "www.computercops.biz") {
        	if (phpversion() >= "4.0.2") {
                	echo "<B>Operating System Data for $NCsitename</B>"
	                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
        	        . "<TR bgcolor=#FFCC66><TD>Type</TD><TD>Value</TD></TR>"
                	. "<TR bgcolor=#FFFF99>"
	                . "<TD>OS Type</TD><TD>".php_uname()."</TD>"
        	        . "</TR>"
	                . "</TABLE>"
                	. "<BR>";
        	} elseif (phpversion() >= "3.0.10") {
			$pu = posix_uname();
			echo "<B>Operating System Data for $NCsitename (Values may be blank)</B>"
                        . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
                        . "<TR bgcolor=#FFCC66><TD>Type</TD><TD>Value</TD></TR>"
                        . "<TR bgcolor=#FFFF99>"
                        . "<TD>OS</TD><TD>".$pu['sysname']."</TD>"
                        . "</TR>"
                        . "<TR bgcolor=#FFFF99>"
                        . "<TD>Node Name</TD><TD>".$pu['nodename']."</TD>"
                        . "</TR>"
                        . "<TR bgcolor=#FFFF99>"
                        . "<TD>Build Release</TD><TD>".$pu['release']."</TD>"
                        . "</TR>"
                        . "<TR bgcolor=#FFFF99>"
                        . "<TD>Version</TD><TD>".$pu['version']."</TD>"
                        . "</TR>"
                        . "<TR bgcolor=#FFFF99>"
                        . "<TD>Machine Platform</TD><TD>".$pu['machine']."</TD>"
                        . "</TR>"
                        . "<TR bgcolor=#FFFF99>"
                        . "<TD>Domain Name</TD><TD>".$pu['domainname']."</TD>"
                        . "</TR>"
                        . "</TABLE>"
                        . "<BR>";
                }
	}

	if ($SERVER_NAME != "www.nukecops.com" && $SERVER_NAME != "beta.nukecops.com" && $SERVER_NAME != "www.computercops.biz") {
		if (phpversion() >= "4.0.5") {
	        	echo "<B>MySQL Specific Values for $NCsitename</B>"
	        	. "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
			. "<TR bgcolor=#FFCC66><TD>Category</TD><TD>Value</TD></TR>"
	        	. "<tr bgcolor=#FFFF99><td>"
	        	. "Server Version</TD><TD>". mysql_get_server_info() .""
		        . "</td></tr>"
                	. "<tr bgcolor=#FFFF99><td>"
	                . "Client Version</TD><TD>". mysql_get_client_info() .""
        	        . "</td></tr>"
                	. "<tr bgcolor=#FFFF99><td>"
	                . "Host Information</TD><TD>". mysql_get_host_info() .""
        	        . "</td></tr>"
                	. "<tr bgcolor=#FFFF99><td>"
	                . "Protocol Information</TD><TD>". mysql_get_proto_info() .""
        	        . "</td></tr>"
        		. "</table><BR>";
		}	
	}

        if ($result) {
                echo "<B>phpBB2 Port Values for $NCsitename</B>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
                . "<TR bgcolor=#FFCC66><TD>Theme ID</TD><TD>Style Name</TD><TD>Template Name</TD><TD>Version</TD></TR>";

                while (list($config_value, $style_name, $template_name) = mysql_fetch_row($result)) {
                        $NCconfig_value =  $config_value;
                        $NCstyle_name = $style_name;
                        $NCtemplate_name =$template_name;
                }
                mysql_free_result($result);

                echo "<TR bgcolor=#FFFF99>"
                . "<TD>$NCconfig_value</TD><TD>$NCstyle_name</TD><TD>$NCtemplate_name</TD><TD>2$NCFver</TD>"
                . "</TR>"
                . "</TABLE>"
                . "<BR>";
        }

        echo "<B>PHP-Nuke Values for $NCsitename</B>"
        . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
        . "<TR bgcolor=#FFCC66><TD>Default_Theme</TD><TD>Version</TD><TD>Locale</TD><TD>Language</TD></TR>"
        . "<TR bgcolor=#FFFF99>"
        . "<TD>$NCDefault_Theme</TD><TD>$NCVersion_Num</TD><TD>$NClocale</TD><TD>$NClanguage</TD>"
        . "</TR>"
        . "</TABLE>"
        . "<BR>";

}


function listdbs() {
        global $prefix, $user_prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $Default_Theme, $language, $locale, $Version_Num, $sitekey;
        global $NCsitename, $NCVersion_Num, $SERVER_NAME, $NClanguage, $NClocale, $NCsitekey, $dbi;

	if ($SERVER_NAME != "www.nukecops.com" && $SERVER_NAME != "beta.nukecops.com" && $SERVER_NAME != "www.computercops.biz") {
	        $db_list = mysql_list_dbs($dbi);
	        echo "<B>All Available MySQL Databases</B>"
	        . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
        	. "<TR bgcolor=#FFCC66><TD>Database Name</TD></TR>"
	        . "</TR>";
        	while ($row = mysql_fetch_object($db_list)) {
			if ($row->Database == $dbname) {
				echo "<TR bgcolor=#FFFF99>"
        			. "<TD><I>" . $row->Database . "</I></TD>"
				. "</TR>";
			} else {
				echo "<TR bgcolor=#FFFF99>"
                                . "<TD>" . $row->Database . "</TD>"
                                . "</TR>";
			}
        	}
		echo "</TABLE><BR>";
	}
}


function modchk() {
        global $prefix, $user_prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $Default_Theme, $language, $locale, $Version_Num, $sitekey;
        global $NCsitename, $NCVersion_Num, $SERVER_NAME, $NClanguage, $NClocale, $NCsitekey, $dbi;

	$sql = "select main_module from ".$prefix."_main";
	$result = mysql_query($sql);
	while (list($main_module) = mysql_fetch_row($result)) {
		$NCmain_module = $main_module;
	}
	mysql_free_result($result);

	$sql = "select title, active, view from ".$prefix."_modules group by title asc";
	$result = mysql_query($sql);
        if ($result) {
                echo "<B>Module Data for $NCsitename</B>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
                . "<TR bgcolor=#FFCC66><TD>Module</TD><TD>Active Code</TD><TD>View Code</TD></TR>";

                while (list($title, $active, $view) = mysql_fetch_row($result)) {
                        $NCtitle = $title;
                        $NCactive = $active;
                        $NCview = $view;
			if ($view > '2') {
	            		$NCview = $NCview - 2;
				$sql2 = "select groupName from ".$prefix."_users_groups where groupID = $NCview";
		                $result2 = mysql_query($sql2);
                		if ($result2) {
		                        while (list($groupName) = mysql_fetch_row($result2)) {
                	                	$NCview = "$groupName";
                        		}
		                        mysql_free_result($result2);
                		}
			} elseif ($view) { 
				$NCview = "Registered Users"; 
			} elseif ($view == '2') { 
				$NCview = "Administrators"; 
			} else { 
				$NCview = "All Visitors"; 
			}
			if ($NCactive) { $NCactive = "active"; } else { $NCactive = "<font color=\"maroon\"><strong>disabled</strong></color>"; }
			if ($NCmain_module == $NCtitle) {$NCtitle = "<B>$NCtitle</B>";}
                        echo "<TR bgcolor=#FFFF99><TD>$NCtitle</TD><TD>$NCactive</TD><TD>$NCview</TD></TR>";
                }
		mysql_free_result($result);
                echo "</TABLE>"
                . "<BR>";

        }
}

function blkchk() {
        global $prefix, $user_prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $Default_Theme, $language, $locale, $Version_Num, $sitekey;
        global $NCsitename, $NCVersion_Num, $SERVER_NAME, $NClanguage, $NClocale, $NCsitekey, $dbi;

	// Following code for Block Data was supplied by chatserv but I adapted it to work with NSN_Groups permissions if exist.
        $sql = "select title, active, view from ".$prefix."_blocks group by title asc";
        $result = mysql_query($sql);
        if ($result) {
                echo "<B>Block Data for $NCsitename</B>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
                . "<TR bgcolor=#FFCC66><TD>Block</TD><TD>Active Code</TD><TD>View Code</TD></TR>";
                 while (list($title, $active, $view) = mysql_fetch_row($result)) {
                        $NCTitle = $title;
                        $NCActive = $active;
                        $NCView = $view;
			if ($view > '3') {
                                $NCView = $NCView - 3;
                                $sql2 = "select groupName from ".$prefix."_users_groups where groupID = $NCView";
                                $result2 = mysql_query($sql2);
                                if ($result2) {
                                        while (list($groupName) = mysql_fetch_row($result2)) {
                                                $NCView = "$groupName";
                                        }
                                        mysql_free_result($result2);
                                }
			} elseif ($view == '1') {
                                $NCView = "Registered Users";
                        } elseif ($view == '2') {
                                $NCView = "Administrators";
			} elseif ($view == '3') {
				$NCView = "Anonymous";
                        } else {
                                $NCView = "All Visitors";
                        }
                        if ($NCActive) { $NCActive = "active"; } else { $NCActive = "<font color=\"maroon\"><strong>disabled</strong></color>"; }
                        echo "<TR bgcolor=#FFFF99><TD>$NCTitle</TD><TD>$NCActive</TD><TD>$NCView</TD></TR>";
                }
                mysql_free_result($result);
                echo "</TABLE>"
                . "<BR>";
        }
}

function ranks() {
        global $prefix, $user_prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $Default_Theme, $language, $locale, $Version_Num, $sitekey;
        global $NCsitename, $NCVersion_Num, $SERVER_NAME, $NClanguage, $NClocale, $NCsitekey, $dbi;

        $sql = "select u.username, u.user_id, r.rank_title, u.user_level from ".$prefix."_users u, ".$prefix."_bbranks r where r.rank_id=u.user_rank";
        $result = mysql_query($sql);
        if ($result) {
                echo "<B>Member Special Ranks for $NCsitename</B>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
                . "<TR bgcolor=#FFCC66><TD>phpBB2 Rank Title</TD><TD>PHP-Nuke Rank Level</TD><TD>Member Name</TD><TD>Member UID</TD></TR>";

                while (list($username, $user_id, $rank_title, $user_level) = mysql_fetch_row($result)) {
                        $NCuname = $username;
                        $NCuid = $user_id;
                        $NCrank_title = $rank_title;
                        $NCuser_level = $user_level;
                        if ($NCuser_level == '2') {$NCuser_level="2: Admin/Author";} elseif ($NCuser_level == '3') {$NCuser_level="3: Forum Moderator";} else {$NCuser_level="1: Regular Member";}
                        echo "<TR bgcolor=#FFFF99><TD>$NCrank_title</TD><TD>$NCuser_level</TD><TD>$NCuname</TD><TD>$NCuid</TD></TR>";
                }
                mysql_free_result($result);
                echo "</TABLE>"
                . "<BR>";

        }

	$sql = "select u.uname, u.uid, r.rank_title, u.user_level from ".$prefix."_users u, ".$prefix."_bbranks r where r.rank_id=u.user_rank";
	$result = mysql_query($sql);
	if ($result) {
	        echo "<B>Member Special Ranks for $NCsitename</B>"
	        . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
        	. "<TR bgcolor=#FFCC66><TD>phpBB2 Rank Title</TD><TD>PHP-Nuke Rank Level</TD><TD>Member Name</TD><TD>Member UID</TD></TR>";

		while (list($uname, $uid, $rank_title, $user_level) = mysql_fetch_row($result)) {
        		$NCuname = $uname;
	        	$NCuid = $uid;
        		$NCrank_title = $rank_title;
			$NCuser_level = $user_level;
			if ($NCuser_level == '2') {$NCuser_level="2: Admin/Author";} elseif ($NCuser_level == '3') {$NCuser_level="3: Forum Moderator";} else {$NCuser_level="1: Regular Member";}
	        	echo "<TR bgcolor=#FFFF99><TD>$NCrank_title</TD><TD>$NCuser_level</TD><TD>$NCuname</TD><TD>$NCuid</TD></TR>";
		}
		mysql_free_result($result);
	        echo "</TABLE>"
        	. "<BR>";

	}
}

function admins() {
        global $prefix, $user_prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $Default_Theme, $language, $locale, $Version_Num, $sitekey;
        global $NCsitename, $NCVersion_Num, $SERVER_NAME, $NClanguage, $NClocale, $NCsitekey, $dbi;

	$sql = "select uname, uid, user_level from ".$prefix."_users where user_level = '2'";
	$result = mysql_query($sql);
        if ($result) {
                echo "<B>Catch-All Administrators for $NCsitename</B>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
                . "<TR bgcolor=#FFCC66><TD>PHP-Nuke Rank Level</TD><TD>Member Name</TD><TD>Member UID</TD></TR>";

                while (list($uname, $uid, $user_level) = mysql_fetch_row($result)) {
                        $NCuname = $uname;
                        $NCuid = $uid;
                        $NCuser_level = $user_level;
                        if ($NCuser_level == '2') {$NCuser_level="2: Admin/Author";}
                        echo "<TR bgcolor=#FFFF99><TD>$NCuser_level</TD><TD>$NCuname</TD><TD>$NCuid</TD></TR>";
                }
                mysql_free_result($result);
                echo "</TABLE>"
                . "<BR>";

        }

        $sql = "select username, user_id, user_level from ".$prefix."_users where user_level = '2'";
        $result = mysql_query($sql);
        if ($result) {
                echo "<B>Catch-All Administrators for $NCsitename</B>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
                . "<TR bgcolor=#FFCC66><TD>PHP-Nuke Rank Level</TD><TD>Member Name</TD><TD>Member UID</TD></TR>";

                while (list($username, $user_id, $user_level) = mysql_fetch_row($result)) {
                        $NCuname = $username;
                        $NCuid = $user_id;
                        $NCuser_level = $user_level;
                        if ($NCuser_level == '2') {$NCuser_level="2: Admin/Author";}
                        echo "<TR bgcolor=#FFFF99><TD>$NCuser_level</TD><TD>$NCuname</TD><TD>$NCuid</TD></TR>";
                }
                mysql_free_result($result);
                echo "</TABLE>"
                . "<BR>";

        }
}

function mods() {
        global $prefix, $user_prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $Default_Theme, $language, $locale, $Version_Num, $sitekey;
        global $NCsitename, $NCVersion_Num, $SERVER_NAME, $NClanguage, $NClocale, $NCsitekey, $dbi;

        $sql = "select uname, uid, user_level from ".$prefix."_users where user_level = '3'";
        $result = mysql_query($sql);
        if ($result) {
                echo "<B>Catch-All Moderators for $NCsitename</B>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
                . "<TR bgcolor=#FFCC66><TD>PHP-Nuke Rank Level</TD><TD>Member Name</TD><TD>Member UID</TD></TR>";

                while (list($uname, $uid, $user_level) = mysql_fetch_row($result)) {
                        $NCuname = $uname;
                        $NCuid = $uid;
                        $NCuser_level = $user_level;
                        if ($NCuser_level == '3') {$NCuser_level="3: Forum Moderator";}
                        echo "<TR bgcolor=#FFFF99><TD>$NCuser_level</TD><TD>$NCuname</TD><TD>$NCuid</TD></TR>";
                }
                mysql_free_result($result);
                echo "</TABLE>"
                . "<BR>";

        }

        $sql = "select username, user_id, user_level from ".$prefix."_users where user_level = '3'";
        $result = mysql_query($sql);
        if ($result) {
                echo "<B>Catch-All Moderators for $NCsitename</B>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
                . "<TR bgcolor=#FFCC66><TD>PHP-Nuke Rank Level</TD><TD>Member Name</TD><TD>Member UID</TD></TR>";

                while (list($username, $user_id, $user_level) = mysql_fetch_row($result)) {
                        $NCuname = $username;
                        $NCuid = $user_id;
                        $NCuser_level = $user_level;
                        if ($NCuser_level == '3') {$NCuser_level="3: Forum Moderator";}
                        echo "<TR bgcolor=#FFFF99><TD>$NCuser_level</TD><TD>$NCuname</TD><TD>$NCuid</TD></TR>";
                }
                mysql_free_result($result);
                echo "</TABLE>"
                . "<BR>";

        }
}

function tables() {
        global $prefix, $user_prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $Default_Theme, $language, $locale, $Version_Num, $sitekey;
        global $NCsitename, $NCVersion_Num, $SERVER_NAME, $NClanguage, $NClocale, $NCsitekey, $dbi;

	$result = mysql_list_tables($dbname);
	if (!$result) {
        	print "DB Error, could not list tables\n";
	        print 'MySQL Error: ' . mysql_error();
	}
	if ($result) {
                echo "<B>PHP-Nuke Show Tables for $NCsitename</B>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
                . "<TR bgcolor=#FFCC66><TD>Number</TD><TD>Table Name</TD><TD>Fields</TD><TD>Records</TD></TR>";
		$i=1;
	        while ($row = mysql_fetch_row($result)) {
			echo "<TR bgcolor=#FFFF99><TD align=center>$i</TD><TD>$row[0]</TD>";
			$sql2 = "DESCRIBE $row[0]";
			$result2 = mysql_num_rows(mysql_query($sql2));
			if ($result2) { 
				echo "<TD align=right>$result2</TD>"; 
			} else { 
				$result2 = "0"; 
			}
			$sql3 = "SELECT COUNT(*) as nccount FROM ".$row[0];
			$result3 = mysql_query($sql3);
			while (list($nccount) = mysql_fetch_row($result3)) {
				if ($nccount) {
					echo "<TD align=right>$nccount</TD>";
				} else {
					$nccount = 0;
					echo "<TD align=right>$nccount</TD>";
				}
			}
                        $i++;
		}
        	echo "</TR></TABLE>"
	        . "<BR>";
	}
}

function phpini() {
        global $prefix, $user_prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $Default_Theme, $language, $locale, $Version_Num, $sitekey;
        global $NCsitename, $NCVersion_Num, $SERVER_NAME, $NClanguage, $NClocale, $NCsitekey, $dbi;

	if ($SERVER_NAME != "www.nukecops.com" && $SERVER_NAME != "beta.nukecops.com" && $SERVER_NAME != "www.computercops.biz") {
		if (phpversion() < "4.2.0") {
			echo "<B>php.ini Configuration for $NCsitename</B>"
	                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
			. "<tr bgcolor=#FFFF99><td><pre>";
			print_r(parse_ini_file(get_cfg_var('cfg_file_path')));
			echo "</pre></td></tr>"
        	        . "</table><BR>";
		} else {
			$cfgOut = ini_get_all();
			echo "<B>php.ini Configuration for $NCsitename</B>"
		        . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
        		. "<TR bgcolor=#FFCC66><TD COLSPAN=3>Global / Local / Access : php.ini data</TD></TR>"
			. "<TR bgcolor=silver><TD ALIGN=CENTER COLSPAN=3><B>The Key for [access]</B></TD></TR>"
			. "<TR bgcolor=silver><TD>Constant</TD><TD>Value</TD><TD>Meaning</TD></TR>"
			. "<TR bgcolor=silver><TD>PHP_INI_USER</TD><TD>1</TD><TD>Entry can be set in user scripts</TD></TR>"
			. "<TR bgcolor=silver><TD>PHP_INI_PERDIR</TD><TD>2</TD><TD>Entry can be set in php.ini, .htaccess, or httpd.conf</TD></TR>"
			. "<TR bgcolor=silver><TD>PHP_INI_SYSTEM</TD><TD>4</TD><TD>Entry can be set in php.ini, or httpd.conf</TD></TR>"
			. "<TR bgcolor=silver><TD>PHP_INI_ALL</TD><TD>7</TD><TD>Entry can be set anywhere</TD></TR>"
			. "<tr bgcolor=#FFFF99><td COLSPAN=3><pre>";
			print_r($cfgOut);
			echo "</pre></td></tr>"
			. "</table><BR>";
		}
	}

	if (phpversion() >= "4.3.0") {
        	 echo "<B>MySQL Status for $NCsitename</B>"
	         . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
        	 . "<tr bgcolor=#FFFF99><td><pre>";
	         print_r(mysql_stat($dbi));
        	 echo "</pre></td></tr>"
	         . "</table><BR>";
	}

}

function ncimg() {
?>
<style type="text/css">.asciiimage{
        color           : #000000;
        background-color: #FFFFFF;
        font-size       : 6px;
        font-family     : "Courier New", Courier, mono;
        line-height     : 4px;
        letter-spacing  : 0px;
    }</style><span class="asciiimage"><font color="#000000">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@<br>
@</font><font color="#DC5151">@</font><font color="#D86565">@</font><font color="#DA5B5B">@</font><font color="#DC5151">@</font><font color="#DA4444">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#CA3A3A">@</font><font color="#D22424">@</font><font color="#000000">@<br>
@</font><font color="#DA5B5B">@</font><font color="#D86565">@</font><font color="#CF5151">@@</font><font color="#C54141">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#BB2222">@</font><font color="#000000">@<br>
@</font><font color="#D22424">@</font><font color="#BB2222">@@</font><font color="#A51717">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#9B0B0B">@</font><font color="#000000">@<br>
@</font><font color="#FFFAEF">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#000000">@<br>
@</font><font color="#FFF8E7">@@@@</font><font color="#FFFAEF">@@@</font><font color="#FFF8E7">@@@@</font><font color="#FFFDF4">@@</font><font color="#FFF8E7">@@@@</font><font color="#FFFAEF">@@</font><font color="#FFF8E7">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#000000">@<br>
@</font><font color="#FFF6DF">@@@</font><font color="#FFF8E7">@</font><font color="#FFFDF4">@</font><font color="#FFF0BD">@</font><font color="#FFF8E7">@</font><font color="#FFFDF4">@@@@</font><font color="#FFF5D4">@</font><font color="#FFF8E7">@</font><font color="#FFFDF4">@@@@</font><font color="#FFF8E7">@</font><font color="#FFE7AF">@</font><font color="#FFF8E7">@</font><font color="#FFF6DF">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#000000">@<br>
@</font><font color="#FFF5D4">@@@</font><font color="#FFFDF4">@</font><font color="#FFE5A7">@</font><font color="#FFCC00">@@</font><font color="#FFE583">@</font><font color="#FFE7AF">@</font><font color="#FFEA9B">@</font><font color="#FAD43C">@</font><font color="#FFCC00">@@</font><font color="#FFD46F">@</font><font color="#FFE5A7">@</font><font color="#FFEA9B">@</font><font color="#FFE583">@</font><font color="#FFD014">@</font><font color="#FFCC00">@</font><font color="#F2DDAF">@</font><font color="#E7DBBF">@</font><font color="#FFF1CF">@</font><font color="#FFF5D4">@@@@@@@@@@@@@@@@@</font><font color="#E7DBBF">@@</font><font color="#FFF1CF">@</font><font color="#FFF5D4">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#000000">@<br>
@</font><font color="#FFF1CF">@@</font><font color="#FFF6DF">@</font><font color="#FFF8E7">@</font><font color="#FFD014">@</font><font color="#D4CFC3">@</font><font color="#C4C2B6">@</font><font color="#FFCC00">@@@@@@@@@@</font><font color="#D4CFC3">@</font><font color="#C4C2B6">@</font><font color="#FFD014">@</font><font color="#D4CFC3">@</font><font color="#E7DBBF">@</font><font color="#FFF1CF">@@@@@@@@@@@@@@@@@</font><font color="#666699">@</font><font color="#3D3D81">@</font><font color="#CDBDA9">@</font><font color="#FFF1CF">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#000000">@<br>
@</font><font color="#FFEFC7">@@</font><font color="#FFF8E7">@</font><font color="#FFF0BD">@</font><font color="#FFCC00">@</font><font color="#D4CFC3">@</font><font color="#C4C2B6">@</font><font color="#D7AC00">@@@</font><font color="#E1B506">@@@@@@</font><font color="#EABB00">@</font><font color="#D4CFC3">@</font><font color="#C4C2B6">@</font><font color="#FFCC00">@</font><font color="#CABE97">@</font><font color="#DCCAAD">@</font><font color="#FFEFC7">@@@@@@@@@@@@@@@@@</font><font color="#595998">@</font><font color="#2C2C78">@</font><font color="#B7B1A1">@</font><font color="#FFEFC7">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#000000">@<br>
@</font><font color="#FFF0BD">@@</font><font color="#FFFAEF">@</font><font color="#FFE583">@</font><font color="#EABB00">@</font><font color="#CEA500">@</font><font color="#BE9801">@@@@</font><font color="#CEA500">@@@@@@</font><font color="#D7AC00">@</font><font color="#EABB00">@</font><font color="#F5C506">@@</font><font color="#BFA56D">@</font><font color="#CDBDA9">@</font><font color="#FFF0BD">@@@@@@@@@@@@@@@@@</font><font color="#595998">@</font><font color="#333366">@</font><font color="#B7B1A1">@</font><font color="#FFF0BD">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#000000">@<br>
@</font><font color="#FEE7B3">@@</font><font color="#FFFAEF">@</font><font color="#FAD540">@</font><font color="#D7AC00">@</font><font color="#BE9801">@@@@</font><font color="#CEA500">@@@@@@@</font><font color="#E1B506">@</font><font color="#E6BB11">@</font><font color="#F5C506">@@</font><font color="#BF9A48">@</font><font color="#B7B1A1">@</font><font color="#FEE7B3">@@@@@@@@@@@@@@@@@</font><font color="#666699">@</font><font color="#333366">@</font><font color="#B9A896">@</font><font color="#FEE7B3">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#000000">@<br>
@</font><font color="#FFE7AF">@@</font><font color="#FFFAEF">@</font><font color="#FAD540">@</font><font color="#D7AC00">@</font><font color="#CEA500">@</font><font color="#000000">@@@@@@@@@@@@</font><font color="#F8CE25">@</font><font color="#FFD014">@</font><font color="#BF9A48">@</font><font color="#B9A896">@</font><font color="#FFE7AF">@@</font><font color="#F1DDB5">@</font><font color="#DCCAAD">@</font><font color="#FFE7AF">@@@@</font><font color="#E9D6AF">@</font><font color="#FEE7B3">@</font><font color="#DCCAAD">@</font><font color="#CDBDA9">@</font><font color="#FFE7AF">@@@</font><font color="#E9D6AF">@</font><font color="#FEE7B3">@</font><font color="#6A6AA2">@</font><font color="#333366">@</font><font color="#C0AD8A">@</font><font color="#FFE7AF">@@</font><font color="#F1DDB5">@@</font><font color="#FFE7AF">@</font><font color="#E9D6AF">@</font><font color="#DCCAAD">@</font><font color="#DBC8A7">@@@</font><font color="#F2DDAF">@</font><font color="#FFE7AF">@@@</font><font color="#DCCAAD">@@</font><font color="#FEE7B3">@</font><font color="#FFE7AF">@@@@@</font><font color="#DCCAAD">@@</font><font color="#F2DDAF">@</font><font color="#FFE7AF">@@@</font><font color="#E9D6AF">@@</font><font color="#DBC8A7">@@</font><font color="#E9D6AF">@</font><font color="#FFE7AF">@@@@@</font><font color="#DCCAAD">@</font><font color="#DBC8A7">@@</font><font color="#FFE7AF">@@@</font><font color="#000000">@<br>
@</font><font color="#FFE5A7">@@</font><font color="#FFF8E7">@</font><font color="#FFCD57">@</font><font color="#EABB00">@</font><font color="#E1B506">@</font><font color="#E6BB11">@</font><font color="#E5BE20">@</font><font color="#F8CE25">@@</font><font color="#FAD43C">@@@@@@@@@</font><font color="#FFD014">@</font><font color="#BF9A48">@</font><font color="#B9A896">@</font><font color="#FFE5A7">@@</font><font color="#6A6AA2">@</font><font color="#4A4A8C">@</font><font color="#534E86">@</font><font color="#FFE5A7">@@</font><font color="#F1DDB5">@</font><font color="#9292BC">@</font><font color="#E9D6AF">@</font><font color="#2C2C78">@</font><font color="#0F0F60">@</font><font color="#FFE5A7">@@@</font><font color="#6A6AA2">@</font><font color="#F1DDB5">@</font><font color="#6A6AA2">@</font><font color="#2C2C78">@</font><font color="#C0AD8A">@</font><font color="#FFE5A7">@</font><font color="#CDBDA9">@</font><font color="#54548D">@</font><font color="#CDBDA9">@</font><font color="#B7B1A1">@</font><font color="#595998">@</font><font color="#595473">@</font><font color="#8F8279">@@@</font><font color="#EDD4A0">@</font><font color="#FFE5A7">@</font><font color="#999999">@</font><font color="#4A487E">@</font><font color="#837A83">@@</font><font color="#3D3D81">@</font><font color="#B9A896">@</font><font color="#FFE5A7">@@</font><font color="#999999">@</font><font color="#534E86">@</font><font color="#837A83">@</font><font color="#8F8279">@</font><font color="#4A4A8C">@</font><font color="#666699">@</font><font color="#FFE5A7">@@</font><font color="#666699">@</font><font color="#4A4A8C">@</font><font color="#7D7075">@@</font><font color="#333366">@</font><font color="#4A487E">@</font><font color="#DBC8A7">@</font><font color="#FFE5A7">@</font><font color="#DCCAAD">@</font><font color="#54548D">@</font><font color="#45426D">@</font><font color="#8F8279">@</font><font color="#534C6B">@</font><font color="#CABE97">@</font><font color="#FFE5A7">@@</font><font color="#000000">@<br>
@</font><font color="#FFEA9B">@@</font><font color="#FFF6DF">@</font><font color="#FFE583">@</font><font color="#F5C506">@@@</font><font color="#E5BE20">@</font><font color="#D8B31C">@</font><font color="#DFBC2F">@@@@@@</font><font color="#FAD43C">@@@</font><font color="#FFD428">@</font><font color="#FFD014">@</font><font color="#A3946B">@</font><font color="#C0AD8A">@</font><font color="#FFEA9B">@</font><font color="#E9D6AF">@</font><font color="#4A4A8C">@</font><font color="#2C2C78">@@</font><font color="#A39597">@</font><font color="#FFEA9B">@</font><font color="#F2DDAF">@</font><font color="#9292BC">@</font><font color="#DBC8A7">@</font><font color="#0F0F60">@</font><font color="#06064F">@</font><font color="#FFEA9B">@@@</font><font color="#666699">@</font><font color="#F2DDAF">@</font><font color="#6A6AA2">@</font><font color="#212165">@</font><font color="#C0AD8A">@</font><font color="#E6CC94">@</font><font color="#3D3D81">@</font><font color="#A39597">@</font><font color="#FFEA9B">@</font><font color="#8B839C">@</font><font color="#3D3D78">@</font><font color="#7D7075">@</font><font color="#FFEA9B">@@@@</font><font color="#8B839C">@</font><font color="#3D3D78">@</font><font color="#8F8279">@</font><font color="#FFEA9B">@@</font><font color="#B9A896">@</font><font color="#2C2C78">@</font><font color="#F4DCA4">@</font><font color="#666699">@</font><font color="#333366">@</font><font color="#A39597">@</font><font color="#FFEA9B">@@</font><font color="#F4DCA4">@</font><font color="#54548D">@</font><font color="#666699">@</font><font color="#FFE5A7">@</font><font color="#6A6AA2">@</font><font color="#2C2C78">@</font><font color="#C0AD8A">@</font><font color="#FFEA9B">@</font><font color="#EDD4A0">@</font><font color="#54548D">@@</font><font color="#F2DDAF">@</font><font color="#6A6AA2">@</font><font color="#3D3D78">@</font><font color="#C0AD8A">@</font><font color="#FFEA9B">@@@@@</font><font color="#000000">@<br>
@</font><font color="#FFE097">@@</font><font color="#FFF5D4">@</font><font color="#FFE097">@</font><font color="#FFCC00">@@</font><font color="#E1B506">@</font><font color="#CAA619">@</font><font color="#B99815">@@@</font><font color="#CAA619">@@@</font><font color="#D8B31C">@</font><font color="#E5BE20">@</font><font color="#F8CE25">@@</font><font color="#FFD014">@</font><font color="#FFCC00">@</font><font color="#A3946B">@</font><font color="#C0AD8A">@</font><font color="#FFE097">@</font><font color="#DFCC92">@</font><font color="#212165">@</font><font color="#7D7075">@</font><font color="#2C2C78">@</font><font color="#42428C">@</font><font color="#F4DCA4">@@</font><font color="#9292BC">@</font><font color="#D3B98C">@</font><font color="#020241">@@</font><font color="#FFE097">@@@</font><font color="#595998">@</font><font color="#F4DCA4">@</font><font color="#595998">@</font><font color="#212165">@</font><font color="#BFA675">@</font><font color="#333366">@</font><font color="#5F566C">@</font><font color="#FFE097">@@</font><font color="#8B839C">@</font><font color="#3D3D78">@</font><font color="#8E846C">@</font><font color="#FFE097">@@@</font><font color="#F4DCA4">@</font><font color="#595998">@</font><font color="#333366">@</font><font color="#FFE097">@@@@@</font><font color="#DBC8A7">@</font><font color="#333366">@</font><font color="#121250">@</font><font color="#FFE097">@@@@</font><font color="#A39597">@</font><font color="#666699">@</font><font color="#CDBDA9">@</font><font color="#54548D">@</font><font color="#212165">@</font><font color="#BFA675">@</font><font color="#FFE097">@@</font><font color="#B7B1A1">@</font><font color="#6A6AA2">@</font><font color="#8B839C">@</font><font color="#54548D">@</font><font color="#212165">@</font><font color="#333366">@</font><font color="#D3B98C">@</font><font color="#FFE097">@@@@</font><font color="#000000">@<br>
@</font><font color="#FFDE8F">@@</font><font color="#FFF0BD">@@</font><font color="#FFCC00">@</font><font color="#F5C506">@</font><font color="#D7AC00">@</font><font color="#BE9801">@@@@</font><font color="#CEA500">@@@</font><font color="#E1B506">@</font><font color="#E6BB11">@</font><font color="#F5C506">@@</font><font color="#FFCC00">@</font><font color="#EABB00">@</font><font color="#8E846C">@</font><font color="#DBBD7C">@</font><font color="#FFDE8F">@</font><font color="#D3B98C">@</font><font color="#121250">@</font><font color="#FFDE8F">@</font><font color="#534E86">@</font><font color="#42428C">@</font><font color="#8B839C">@</font><font color="#EDD4A0">@</font><font color="#666699">@</font><font color="#D1B070">@</font><font color="#000033">@</font><font color="#020241">@</font><font color="#FFDE8F">@@@</font><font color="#4A4A8C">@</font><font color="#EDD4A0">@</font><font color="#4A4A8C">@</font><font color="#1B1B62">@</font><font color="#121250">@</font><font color="#06064F">@</font><font color="#D1B070">@</font><font color="#FFDE8F">@@</font><font color="#8B839C">@</font><font color="#4A487E">@</font><font color="#333366">@</font><font color="#45426D">@@</font><font color="#C0AD8A">@</font><font color="#B7B1A1">@</font><font color="#3D3D78">@</font><font color="#493E5B">@</font><font color="#FFDE8F">@@@@@</font><font color="#B9A896">@</font><font color="#212165">@</font><font color="#493E5B">@</font><font color="#FFDE8F">@@@@</font><font color="#B9A896">@</font><font color="#666699">@</font><font color="#837A83">@</font><font color="#212165">@</font><font color="#06064F">@</font><font color="#BFA675">@</font><font color="#FFDE8F">@@</font><font color="#EDD4A0">@</font><font color="#666699">@</font><font color="#3D3D78">@</font><font color="#756967">@</font><font color="#121250">@@</font><font color="#0F0F60">@</font><font color="#7D7075">@</font><font color="#FFDE8F">@@@</font><font color="#000000">@<br>
@</font><font color="#FFDC86">@@</font><font color="#FFE097">@</font><font color="#FFF6DF">@</font><font color="#FFCC00">@</font><font color="#EABB00">@</font><font color="#D7AC00">@</font><font color="#CEA500">@</font><font color="#000000">@@@@@@@@</font><font color="#F8CE25">@</font><font color="#FFD014">@@</font><font color="#A1872A">@</font><font color="#8E846C">@</font><font color="#F5D381">@</font><font color="#FFDC86">@</font><font color="#D3B98C">@</font><font color="#121250">@</font><font color="#FFDC86">@</font><font color="#DFCC92">@</font><font color="#2C2C78">@@</font><font color="#6B637A">@</font><font color="#212165">@</font><font color="#BFA56D">@</font><font color="#000033">@@</font><font color="#FFDC86">@@@</font><font color="#3D3D81">@</font><font color="#E6CC94">@</font><font color="#2C2C78">@</font><font color="#121250">@</font><font color="#000033">@@</font><font color="#362F43">@</font><font color="#F5D381">@</font><font color="#FFDC86">@</font><font color="#837A83">@</font><font color="#2C2C78">@</font><font color="#937D62">@</font><font color="#FFDC86">@@@</font><font color="#B9A896">@</font><font color="#333366">@</font><font color="#493E5B">@</font><font color="#FFDC86">@@@@@</font><font color="#B9A896">@</font><font color="#212165">@</font><font color="#493E5B">@</font><font color="#FFDC86">@@@@</font><font color="#B9A896">@</font><font color="#54548D">@</font><font color="#5F566C">@</font><font color="#020241">@@</font><font color="#BFA56D">@</font><font color="#FFDC86">@@</font><font color="#E6CC94">@</font><font color="#4A487E">@</font><font color="#121250">@</font><font color="#F5D381">@</font><font color="#756967">@</font><font color="#06064F">@@@</font><font color="#A3946B">@</font><font color="#FFDC86">@@</font><font color="#000000">@<br>
@</font><font color="#FFDC86">@@@</font><font color="#FFEFC7">@</font><font color="#FFD777">@</font><font color="#F5C506">@</font><font color="#EABB00">@</font><font color="#E1B506">@</font><font color="#E6BB11">@</font><font color="#E5BE20">@</font><font color="#F8CE25">@</font><font color="#FAD43C">@@@@@@</font><font color="#FFD014">@</font><font color="#F5C506">@</font><font color="#957B51">@</font><font color="#BFA56D">@</font><font color="#FFDC86">@@</font><font color="#DBBD7C">@</font><font color="#121250">@</font><font color="#FFDC86">@@</font><font color="#8F8279">@</font><font color="#212165">@</font><font color="#1B1B62">@</font><font color="#020241">@</font><font color="#C3A15D">@</font><font color="#000033">@@</font><font color="#FFDC86">@@@</font><font color="#42428C">@</font><font color="#DBBD7C">@</font><font color="#1B1B62">@</font><font color="#020241">@</font><font color="#705F49">@</font><font color="#000033">@@</font><font color="#5F566C">@</font><font color="#FFDC86">@</font><font color="#71667C">@</font><font color="#1B1B62">@</font><font color="#816B58">@</font><font color="#FFDC86">@@@</font><font color="#D3B98C">@</font><font color="#2C2C78">@</font><font color="#0F0F60">@</font><font color="#FFDC86">@@@@</font><font color="#D3B98C">@</font><font color="#C0AD8A">@</font><font color="#212165">@</font><font color="#121250">@</font><font color="#FFDC86">@@@@</font><font color="#999999">@</font><font color="#3D3D81">@</font><font color="#756967">@</font><font color="#020241">@@</font><font color="#BFA56D">@</font><font color="#FFDC86">@@</font><font color="#D3B98C">@</font><font color="#333366">@</font><font color="#362F43">@</font><font color="#FFDC86">@@</font><font color="#BFA675">@</font><font color="#1B1B62">@</font><font color="#06064F">@</font><font color="#493E5B">@</font><font color="#FFDC86">@@</font><font color="#000000">@<br>
@</font><font color="#FFD777">@@@</font><font color="#F1DA95">@</font><font color="#E7DBBF">@</font><font color="#FFD014">@</font><font color="#F5C506">@@@</font><font color="#F8CE25">@</font><font color="#FFD428">@@</font><font color="#FAD43C">@@@@</font><font color="#FFD428">@</font><font color="#FFD014">@</font><font color="#A1872A">@</font><font color="#937D62">@</font><font color="#E6C06D">@</font><font color="#FFD777">@@</font><font color="#DBBD7C">@</font><font color="#121250">@</font><font color="#FFD777">@@@</font><font color="#595473">@</font><font color="#1B1B62">@</font><font color="#020241">@</font><font color="#F0CC75">@</font><font color="#020241">@@</font><font color="#937D62">@</font><font color="#FFD777">@</font><font color="#DFCC92">@</font><font color="#54548D">@</font><font color="#F0CC75">@</font><font color="#0F0F60">@</font><font color="#121250">@</font><font color="#C3A15D">@</font><font color="#816B58">@</font><font color="#06064F">@@</font><font color="#BFA675">@</font><font color="#71667C">@</font><font color="#1B1B62">@</font><font color="#816B58">@</font><font color="#FFD777">@@@@</font><font color="#534C6B">@</font><font color="#0F0F60">@</font><font color="#937D62">@</font><font color="#FFD777">@@</font><font color="#DBBD7C">@</font><font color="#54548D">@</font><font color="#DBBD7C">@</font><font color="#534C6B">@</font><font color="#121250">@</font><font color="#937D62">@</font><font color="#FFD777">@@</font><font color="#F5D381">@</font><font color="#595998">@</font><font color="#333366">@</font><font color="#F0CC75">@</font><font color="#06064F">@@</font><font color="#C3A15D">@</font><font color="#FFD777">@@</font><font color="#6B637A">@</font><font color="#121250">@</font><font color="#A3946B">@</font><font color="#FFD777">@@@</font><font color="#A3946B">@</font><font color="#1B1B62">@</font><font color="#493E5B">@</font><font color="#FFD777">@@</font><font color="#000000">@<br>
@</font><font color="#FFD46F">@@@@</font><font color="#E9D6AF">@</font><font color="#F1DA95">@</font><font color="#FFCC00">@@@</font><font color="#FFD014">@@@</font><font color="#FFD428">@@@@</font><font color="#FFD014">@</font><font color="#EABB00">@</font><font color="#816B58">@</font><font color="#C3A15D">@</font><font color="#FFD46F">@@@</font><font color="#D1B070">@</font><font color="#121250">@</font><font color="#FFD46F">@@@</font><font color="#E6C06D">@</font><font color="#1B1B62">@</font><font color="#020241">@</font><font color="#FFD46F">@</font><font color="#A3946B">@</font><font color="#121250">@@</font><font color="#71667C">@</font><font color="#54548D">@</font><font color="#BFA675">@</font><font color="#FFD46F">@</font><font color="#0F0F60">@</font><font color="#121250">@</font><font color="#C3A15D">@</font><font color="#FFD46F">@</font><font color="#493E5B">@</font><font color="#0F0F60">@</font><font color="#212165">@</font><font color="#493E5B">@</font><font color="#020241">@</font><font color="#362F43">@</font><font color="#816B58">@@@</font><font color="#CEAC65">@</font><font color="#F3C966">@</font><font color="#534C6B">@</font><font color="#0F0F60">@</font><font color="#756967">@</font><font color="#7D7075">@</font><font color="#333366">@</font><font color="#BFA56D">@</font><font color="#FFD46F">@@</font><font color="#756967">@</font><font color="#0F0F60">@</font><font color="#7D7075">@</font><font color="#A39597">@</font><font color="#666699">@</font><font color="#6B637A">@</font><font color="#E6C06D">@</font><font color="#FFD46F">@</font><font color="#0F0F60">@@</font><font color="#705F49">@</font><font color="#816B58">@</font><font color="#595473">@</font><font color="#333366">@</font><font color="#A68D43">@</font><font color="#FFD46F">@</font><font color="#0F0F60">@</font><font color="#5F566C">@</font><font color="#8F8279">@</font><font color="#4A487E">@</font><font color="#333366">@</font><font color="#CEAC65">@</font><font color="#FFD46F">@@</font><font color="#000000">@<br>
@</font><font color="#FFCC66">@@@@</font><font color="#F0CC75">@</font><font color="#E7DBBF">@</font><font color="#F3C966">@</font><font color="#FFCC00">@@@@@@@@@</font><font color="#EABB00">@</font><font color="#957B51">@@</font><font color="#F3C966">@</font><font color="#FFCC66">@@@</font><font color="#F3C966">@</font><font color="#C3A15D">@</font><font color="#FFCC66">@@@@</font><font color="#E0B95D">@</font><font color="#CEAC65">@</font><font color="#FFCC66">@@</font><font color="#F3C966">@</font><font color="#C3A15D">@</font><font color="#CEAC65">@</font><font color="#F3C966">@</font><font color="#FFCC66">@@</font><font color="#C3A15D">@@</font><font color="#F3C966">@</font><font color="#FFCC66">@</font><font color="#F3C966">@</font><font color="#C3A15D">@@</font><font color="#E0B95D">@</font><font color="#C3A15D">@@@@@</font><font color="#E0B95D">@</font><font color="#FFCC66">@@</font><font color="#E6C06D">@</font><font color="#CEAC65">@</font><font color="#C3A15D">@</font><font color="#FFCC66">@@@@@@</font><font color="#CEAC65">@@</font><font color="#E6C06D">@</font><font color="#FFCC66">@@@</font><font color="#1B1B62">@@</font><font color="#957B51">@</font><font color="#C3A15D">@</font><font color="#CEAC65">@</font><font color="#FFCC66">@@@@</font><font color="#CEAC65">@@@</font><font color="#FFCC66">@@@@</font><font color="#000000">@<br>
@</font><font color="#FFCD57">@@@@@</font><font color="#F0CC75">@</font><font color="#E9D6AF">@</font><font color="#E6C06D">@</font><font color="#FFCC00">@@@@@@@</font><font color="#E6BB11">@</font><font color="#957B51">@@</font><font color="#E0B95D">@</font><font color="#FFCD57">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#212165">@</font><font color="#121250">@</font><font color="#BF9A48">@</font><font color="#FFCD57">@@@@@@@@@@@@@</font><font color="#000000">@<br>
@</font><font color="#FFCD57">@@@@@@</font><font color="#F3C966">@</font><font color="#DBC8A7">@</font><font color="#DFCC92">@</font><font color="#F8CE25">@</font><font color="#FFCC00">@@@</font><font color="#EABB00">@</font><font color="#A1872A">@</font><font color="#705F49">@</font><font color="#957B51">@</font><font color="#E0B95D">@</font><font color="#FFCD57">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#1B1B62">@</font><font color="#06064F">@</font><font color="#BF9A48">@</font><font color="#FFCD57">@@@@@@@@@@@@@</font><font color="#000000">@<br>
@</font><font color="#FFCB4F">@@@@@@@@</font><font color="#DBBD7C">@</font><font color="#CABE97">@</font><font color="#D1B070">@</font><font color="#BF9A48">@</font><font color="#A68D43">@</font><font color="#957B51">@@</font><font color="#BF9A48">@</font><font color="#FFC946">@</font><font color="#FFCB4F">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#493E5B">@</font><font color="#362F43">@</font><font color="#CFA545">@</font><font color="#FFCB4F">@@@@@@@@@@@@@</font><font color="#000000">@<br>
@</font><font color="#FFC946">@@@@@@@@@@</font><font color="#E0B95D">@</font><font color="#BFA56D">@</font><font color="#C3A15D">@</font><font color="#CFA545">@</font><font color="#FFC63F">@</font><font color="#FFC946">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#000000">@<br>
@</font><font color="#FFC63F">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#000000">@<br>
@</font><font color="#DC5151">@</font><font color="#D86565">@</font><font color="#DA5B5B">@</font><font color="#DC5151">@</font><font color="#DA4444">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#CA3A3A">@</font><font color="#D22424">@</font><font color="#000000">@<br>
@</font><font color="#DA5B5B">@</font><font color="#D86565">@</font><font color="#CF5151">@@</font><font color="#C54141">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#BB2222">@</font><font color="#000000">@<br>
@</font><font color="#D22424">@</font><font color="#BB2222">@@</font><font color="#A51717">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#9B0B0B">@</font><font color="#000000">@<br>
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@<br>
</font>
</span>
<BR>
<?php
}

function enimg() {
?>
<style type="text/css">.asciiimage{
        color           : #000000;
        background-color: #FFFFFF;
        font-size       : 6px;
        font-family     : "Courier New", Courier, mono;
        line-height     : 4px;
        letter-spacing  : 0px;
    }</style><span class="asciiimage"><font color="#3F9C1E">@</font><font color="#4CA42B">@</font><font color="#56A932">@</font><font color="#5BAB3E">@@@@</font><font color="#56A932">@</font><font color="#4CA42B">@</font><font color="#3F9C1E">@@@</font><font color="#3A9710">@</font><font color="#32940F">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#2C8E08">@@@@@</font><font color="#298300">@@@@</font><font color="#207800">@@@@@<br>
</font><font color="#4CA42B">@</font><font color="#A1C991">@@</font><font color="#71B64A">@</font><font color="#ADCF9C">@@</font><font color="#71B64A">@</font><font color="#A1C991">@@</font><font color="#4CA42B">@</font><font color="#96BD7D">@@</font><font color="#3F9C1E">@</font><font color="#8AB976">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#7EAF6B">@@</font><font color="#2C8E08">@</font><font color="#7EAF6B">@@</font><font color="#298300">@</font><font color="#729F5E">@@</font><font color="#298300">@</font><font color="#729F5E">@</font><font color="#6E925B">@</font><font color="#207800">@</font><font color="#6E925B">@@<br>
</font><font color="#56A932">@</font><font color="#A1C991">@</font><font color="#ADCF9C">@</font><font color="#80BF64">@</font><font color="#B3D29F">@</font><font color="#425A38">@</font><font color="#27311C">@</font><font color="#ADCF9C">@</font><font color="#A1C991">@</font><font color="#56A932">@</font><font color="#6E925B">@</font><font color="#000000">@</font><font color="#204B07">@</font><font color="#8AB976">@@</font><font color="#3A9710">@</font><font color="#4C653F">@</font><font color="#10160E">@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#425A38">@</font><font color="#202817">@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#112200">@</font><font color="#425A38">@</font><font color="#85B571">@</font><font color="#2C8E08">@</font><font color="#4C653F">@</font><font color="#85B571">@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#112200">@</font><font color="#000000">@@@@</font><font color="#182013">@</font><font color="#327A0B">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#32940F">@</font><font color="#85B571">@@</font><font color="#2E6E07">@</font><font color="#000000">@</font><font color="#85B571">@</font><font color="#2E6E07">@</font><font color="#000000">@</font><font color="#7EAF6B">@</font><font color="#2C8E08">@</font><font color="#7EAF6B">@</font><font color="#7CA561">@</font><font color="#298300">@</font><font color="#729F5E">@@</font><font color="#298300">@</font><font color="#6E925B">@@</font><font color="#207800">@</font><font color="#6A8C51">@@<br>
</font><font color="#60AD3D">@</font><font color="#71B64A">@</font><font color="#80BF64">@</font><font color="#96BB73">@@</font><font color="#658B52">@</font><font color="#080A06">@</font><font color="#7FBE5B">@</font><font color="#71B64A">@</font><font color="#60AD3D">@</font><font color="#1F3E11">@@</font><font color="#081100">@</font><font color="#3F9C1E">@</font><font color="#3A9710">@@</font><font color="#122B00">@</font><font color="#194106">@</font><font color="#3A9710">@@@@@@@</font><font color="#204B07">@</font><font color="#112200">@</font><font color="#3A9710">@@@@@@@@@@@@@@@</font><font color="#204B07">@</font><font color="#112200">@</font><font color="#3A9710">@@@@@@@@@@@@@</font><font color="#112200">@</font><font color="#204B07">@</font><font color="#3A9710">@@@</font><font color="#194106">@</font><font color="#081100">@</font><font color="#3A9710">@@@@@@@@@@@@@@@@@@@@</font><font color="#2E6E07">@</font><font color="#000000">@</font><font color="#3A9710">@</font><font color="#2E6E07">@</font><font color="#000000">@</font><font color="#2C8E08">@</font><font color="#2D8B03">@@@</font><font color="#298300">@@@</font><font color="#297B00">@@@</font><font color="#207800">@@@<br>
</font><font color="#60AD3D">@</font><font color="#ADCF9C">@</font><font color="#BFCEAA">@</font><font color="#9BC27F">@</font><font color="#C5DEB7">@@</font><font color="#000000">@</font><font color="#99A481">@</font><font color="#ADCF9C">@</font><font color="#60AD3D">@</font><font color="#080A06">@</font><font color="#8AB976">@</font><font color="#0B1A01">@</font><font color="#6A8C51">@</font><font color="#8AB976">@</font><font color="#3A9710">@</font><font color="#080A06">@</font><font color="#658B52">@</font><font color="#327A0B">@</font><font color="#2B3823">@</font><font color="#000000">@@</font><font color="#324329">@</font><font color="#7EAF6B">@</font><font color="#3A9710">@</font><font color="#425A38">@</font><font color="#182013">@</font><font color="#112200">@</font><font color="#000000">@</font><font color="#10160E">@</font><font color="#327A0B">@</font><font color="#85B571">@@</font><font color="#194106">@</font><font color="#080A06">@</font><font color="#000000">@</font><font color="#0B1A01">@</font><font color="#6E925B">@</font><font color="#85B571">@</font><font color="#194106">@</font><font color="#5B7543">@</font><font color="#6E925B">@</font><font color="#081100">@</font><font color="#080A06">@</font><font color="#3A4D2F">@</font><font color="#3A9710">@</font><font color="#6E925B">@</font><font color="#2B3823">@</font><font color="#000000">@@</font><font color="#324329">@</font><font color="#3B9309">@</font><font color="#85B571">@@</font><font color="#3A9710">@</font><font color="#85B571">@@</font><font color="#112200">@</font><font color="#425A38">@</font><font color="#85B571">@</font><font color="#3A9710">@</font><font color="#85B571">@</font><font color="#597A48">@</font><font color="#030800">@</font><font color="#85B571">@</font><font color="#6E925B">@</font><font color="#112200">@</font><font color="#85B571">@@</font><font color="#3A9710">@</font><font color="#202817">@</font><font color="#6E925B">@</font><font color="#3A9710">@</font><font color="#202817">@</font><font color="#4C653F">@</font><font color="#081100">@</font><font color="#000000">@</font><font color="#202817">@</font><font color="#3B9309">@</font><font color="#85B571">@@</font><font color="#194106">@</font><font color="#000000">@</font><font color="#080A06">@</font><font color="#194106">@</font><font color="#000000">@</font><font color="#85B26D">@</font><font color="#2E6E07">@</font><font color="#000000">@</font><font color="#7EAF6B">@</font><font color="#2D8B03">@</font><font color="#5B7543">@</font><font color="#182013">@</font><font color="#000000">@</font><font color="#080A06">@</font><font color="#3A4D2F">@</font><font color="#297B00">@</font><font color="#6E925B">@@</font><font color="#207800">@</font><font color="#658B52">@@<br>
</font><font color="#60AD3D">@</font><font color="#ADCF9C">@</font><font color="#B3D29F">@</font><font color="#9BC27F">@</font><font color="#C5DEB7">@@</font><font color="#324329">@</font><font color="#6B7259">@</font><font color="#B3D29F">@</font><font color="#417524">@</font><font color="#324329">@</font><font color="#9BC27F">@</font><font color="#265D07">@</font><font color="#324329">@</font><font color="#8AB976">@</font><font color="#327A0B">@</font><font color="#080A06">@</font><font color="#85B571">@</font><font color="#081100">@</font><font color="#4C653F">@</font><font color="#85B571">@</font><font color="#3B9309">@</font><font color="#324329">@@</font><font color="#3A9710">@</font><font color="#425A38">@</font><font color="#000000">@</font><font color="#265D07">@</font><font color="#85B571">@</font><font color="#425A38">@</font><font color="#030800">@</font><font color="#85B571">@</font><font color="#658B52">@</font><font color="#000000">@</font><font color="#729F5E">@</font><font color="#85B571">@</font><font color="#194106">@</font><font color="#4C653F">@</font><font color="#85B571">@</font><font color="#112200">@</font><font color="#425A38">@</font><font color="#84AB65">@</font><font color="#194106">@</font><font color="#182013">@</font><font color="#6E925B">@</font><font color="#3A9710">@</font><font color="#10160E">@</font><font color="#4C653F">@</font><font color="#3A9710">@</font><font color="#84AB65">@</font><font color="#324329">@</font><font color="#194106">@</font><font color="#85B571">@@</font><font color="#3A9710">@</font><font color="#85B571">@@</font><font color="#112200">@</font><font color="#10160E">@</font><font color="#202817">@</font><font color="#112200">@</font><font color="#202817">@</font><font color="#000000">@</font><font color="#327A0B">@</font><font color="#85B571">@</font><font color="#658B52">@</font><font color="#000000">@</font><font color="#85B571">@@</font><font color="#3A9710">@</font><font color="#000000">@</font><font color="#658B52">@</font><font color="#3A9710">@</font><font color="#000000">@</font><font color="#2B3823">@</font><font color="#3B9309">@</font><font color="#729F5E">@</font><font color="#080A06">@</font><font color="#204B07">@</font><font color="#85B571">@</font><font color="#4C653F">@</font><font color="#081100">@</font><font color="#729F5E">@</font><font color="#84AB65">@</font><font color="#122B00">@</font><font color="#000000">@</font><font color="#85B26D">@</font><font color="#2E6E07">@</font><font color="#000000">@</font><font color="#83AE69">@</font><font color="#297B00">@</font><font color="#080A06">@</font><font color="#597A48">@</font><font color="#298300">@</font><font color="#658B52">@</font><font color="#182013">@</font><font color="#204B07">@</font><font color="#6A8C51">@@</font><font color="#2A6B00">@</font><font color="#658B52">@@<br>
</font><font color="#60AD3D">@</font><font color="#71B64A">@</font><font color="#7FBE5B">@</font><font color="#80BF64">@</font><font color="#9BC27F">@@</font><font color="#597A48">@</font><font color="#27311C">@</font><font color="#7FBE5B">@</font><font color="#1B2C11">@</font><font color="#417524">@</font><font color="#57A61E">@</font><font color="#4A9C15">@</font><font color="#030800">@</font><font color="#3B9309">@</font><font color="#204B07">@</font><font color="#194000">@</font><font color="#2E6E07">@</font><font color="#000000">@</font><font color="#112200">@@@</font><font color="#0B1A01">@</font><font color="#000000">@</font><font color="#3B9309">@</font><font color="#204B07">@</font><font color="#112200">@</font><font color="#3B9309">@@@</font><font color="#000000">@</font><font color="#2E6E07">@</font><font color="#3B9309">@</font><font color="#0B1A01">@</font><font color="#081100">@</font><font color="#122B00">@</font><font color="#265D07">@</font><font color="#3B9309">@@</font><font color="#112200">@</font><font color="#204B07">@</font><font color="#3B9309">@</font><font color="#204B07">@</font><font color="#112200">@</font><font color="#3B9309">@</font><font color="#2E6E07">@</font><font color="#000000">@</font><font color="#112200">@@@</font><font color="#0B1A01">@</font><font color="#000000">@</font><font color="#3B9309">@@@@@</font><font color="#112200">@</font><font color="#194000">@</font><font color="#2E6E07">@@@</font><font color="#122B00">@</font><font color="#0B1A01">@</font><font color="#3B9309">@</font><font color="#2E6E07">@</font><font color="#000000">@</font><font color="#3B9309">@@@</font><font color="#000000">@</font><font color="#2E6E07">@</font><font color="#3B9309">@</font><font color="#000000">@</font><font color="#2E6E07">@</font><font color="#3B9309">@@</font><font color="#112200">@</font><font color="#204B07">@</font><font color="#3B9309">@</font><font color="#112200">@</font><font color="#204B07">@</font><font color="#3B9309">@@</font><font color="#2E6E07">@</font><font color="#000000">@</font><font color="#3B9309">@</font><font color="#2E6E07">@</font><font color="#000000">@</font><font color="#388801">@</font><font color="#194000">@</font><font color="#030800">@</font><font color="#112200">@@@</font><font color="#081100">@</font><font color="#0B1A01">@</font><font color="#2F7601">@</font><font color="#2A6B00">@@@@<br>
</font><font color="#65AF32">@</font><font color="#A1C991">@</font><font color="#ADCF9C">@</font><font color="#7FBE5B">@</font><font color="#BFCEAA">@@</font><font color="#7CA561">@</font><font color="#000000">@</font><font color="#A0B580">@</font><font color="#080A06">@</font><font color="#9BC27F">@</font><font color="#96BD7D">@</font><font color="#4A9C15">@</font><font color="#2B3823">@</font><font color="#5B7543">@</font><font color="#112200">@</font><font color="#5B7543">@</font><font color="#648450">@</font><font color="#000000">@</font><font color="#597A48">@</font><font color="#648450">@</font><font color="#2E6E07">@</font><font color="#648450">@@</font><font color="#3B9309">@</font><font color="#415732">@</font><font color="#202817">@</font><font color="#3B9309">@</font><font color="#85B26D">@@</font><font color="#000000">@</font><font color="#648450">@</font><font color="#85B26D">@</font><font color="#3B9309">@</font><font color="#597A48">@</font><font color="#3A4D2F">@</font><font color="#081100">@</font><font color="#182013">@</font><font color="#85B26D">@</font><font color="#112200">@</font><font color="#415732">@</font><font color="#85B26D">@</font><font color="#204B07">@</font><font color="#202817">@</font><font color="#85B26D">@</font><font color="#2E6E07">@</font><font color="#000000">@</font><font color="#597A48">@</font><font color="#2E6E07">@</font><font color="#648450">@@</font><font color="#2E6E07">@</font><font color="#85B26D">@@</font><font color="#3B9309">@</font><font color="#85B26D">@@</font><font color="#112200">@</font><font color="#415732">@</font><font color="#85B26D">@</font><font color="#3B9309">@</font><font color="#85B26D">@@</font><font color="#000000">@</font><font color="#648450">@@</font><font color="#000000">@</font><font color="#85B26D">@@</font><font color="#3B9309">@</font><font color="#000000">@</font><font color="#648450">@</font><font color="#3B9309">@</font><font color="#000000">@</font><font color="#648450">@</font><font color="#3B9309">@</font><font color="#85B26D">@</font><font color="#202817">@</font><font color="#204B07">@</font><font color="#85B26D">@</font><font color="#202817">@</font><font color="#204B07">@</font><font color="#85B26D">@@</font><font color="#2E6E07">@</font><font color="#000000">@</font><font color="#83AE69">@</font><font color="#2A6B00">@</font><font color="#000000">@</font><font color="#7CA561">@</font><font color="#194000">@</font><font color="#10130B">@</font><font color="#5B7543">@</font><font color="#245F00">@</font><font color="#5B7543">@</font><font color="#4C653F">@</font><font color="#245F00">@</font><font color="#658B52">@</font><font color="#648450">@</font><font color="#2A6B00">@</font><font color="#64824A">@@<br>
</font><font color="#61AA27">@</font><font color="#A1C991">@@</font><font color="#71B64A">@</font><font color="#B3D29F">@@</font><font color="#7FBE5B">@</font><font color="#202817">@</font><font color="#324329">@</font><font color="#2B4B17">@</font><font color="#9BC27F">@</font><font color="#96BD7D">@</font><font color="#4A9C15">@</font><font color="#597A48">@</font><font color="#2B3823">@</font><font color="#000000">@</font><font color="#7CA561">@</font><font color="#83AE69">@</font><font color="#081100">@</font><font color="#324329">@</font><font color="#7CA561">@</font><font color="#388801">@</font><font color="#324329">@</font><font color="#2B3823">@</font><font color="#3B9309">@</font><font color="#415732">@</font><font color="#000000">@</font><font color="#2E6E07">@</font><font color="#83AE69">@</font><font color="#324329">@</font><font color="#081100">@</font><font color="#83AE69">@</font><font color="#597A48">@</font><font color="#030800">@</font><font color="#6E925B">@</font><font color="#83AE69">@</font><font color="#204B07">@</font><font color="#080A06">@</font><font color="#83AE69">@</font><font color="#112200">@</font><font color="#415732">@</font><font color="#83AE69">@</font><font color="#204B07">@</font><font color="#182013">@</font><font color="#83AE69">@</font><font color="#3B9309">@</font><font color="#10160E">@</font><font color="#324329">@</font><font color="#388801">@</font><font color="#7CA561">@</font><font color="#324329">@</font><font color="#122B00">@</font><font color="#83AE69">@@</font><font color="#3B9309">@</font><font color="#83AE69">@@</font><font color="#112200">@</font><font color="#415732">@</font><font color="#83AE69">@</font><font color="#3B9309">@</font><font color="#83AE69">@</font><font color="#4C653F">@</font><font color="#000000">@</font><font color="#6E925B">@</font><font color="#6A8C51">@</font><font color="#000000">@</font><font color="#648450">@</font><font color="#83AE69">@</font><font color="#204B07">@</font><font color="#000000">@</font><font color="#648450">@</font><font color="#3B9309">@</font><font color="#000000">@</font><font color="#648450">@</font><font color="#3B9309">@</font><font color="#83AE69">@</font><font color="#202817">@</font><font color="#204B07">@</font><font color="#83AE69">@</font><font color="#4C653F">@</font><font color="#030800">@</font><font color="#6E925B">@</font><font color="#7CA561">@</font><font color="#122B00">@</font><font color="#000000">@</font><font color="#84AB65">@</font><font color="#2A6B00">@</font><font color="#000000">@</font><font color="#7CA561">@</font><font color="#2F7601">@</font><font color="#000000">@</font><font color="#415732">@</font><font color="#2F7601">@</font><font color="#64824A">@</font><font color="#10160E">@</font><font color="#194000">@</font><font color="#648450">@@</font><font color="#2A6B00">@</font><font color="#64824A">@@<br>
</font><font color="#57A61E">@</font><font color="#61AA27">@</font><font color="#65AF32">@</font><font color="#70B541">@@@@</font><font color="#3E4D2B">@</font><font color="#000000">@</font><font color="#4A9425">@</font><font color="#57A61E">@</font><font color="#4A9C15">@</font><font color="#48990F">@@</font><font color="#030800">@</font><font color="#112200">@</font><font color="#3F8F04">@@</font><font color="#2F7601">@</font><font color="#122B00">@</font><font color="#000000">@@</font><font color="#122B00">@</font><font color="#2F7601">@</font><font color="#3F8F04">@</font><font color="#234600">@</font><font color="#0B1A01">@</font><font color="#112200">@</font><font color="#000000">@</font><font color="#0B1A01">@</font><font color="#2F7601">@</font><font color="#3F8F04">@@</font><font color="#182B00">@</font><font color="#030800">@</font><font color="#000000">@</font><font color="#0B1A01">@</font><font color="#265D07">@</font><font color="#3F8F04">@</font><font color="#112200">@</font><font color="#234600">@</font><font color="#3F8F04">@</font><font color="#265D07">@</font><font color="#030800">@</font><font color="#081100">@</font><font color="#3F8F04">@</font><font color="#2F7601">@</font><font color="#122B00">@</font><font color="#000000">@@</font><font color="#122B00">@</font><font color="#2F7601">@</font><font color="#3F8F04">@@@@@</font><font color="#112200">@</font><font color="#000000">@@@@</font><font color="#0B1A01">@</font><font color="#265D07">@</font><font color="#3F8F04">@@</font><font color="#194000">@</font><font color="#000000">@</font><font color="#030800">@</font><font color="#265D07">@</font><font color="#000000">@</font><font color="#2E6E07">@</font><font color="#3F8F04">@</font><font color="#000000">@</font><font color="#2E6E07">@</font><font color="#3F8F04">@@</font><font color="#112200">@</font><font color="#234600">@</font><font color="#3F8F04">@@</font><font color="#194000">@</font><font color="#030800">@@</font><font color="#182B00">@</font><font color="#000000">@</font><font color="#3F8F04">@</font><font color="#2A6B00">@</font><font color="#000000">@</font><font color="#388801">@@</font><font color="#245F00">@</font><font color="#0B1A01">@</font><font color="#000000">@</font><font color="#030800">@</font><font color="#122B00">@</font><font color="#2A6B00">@@@@@@<br>
</font><font color="#57A61E">@</font><font color="#9BC27F">@@</font><font color="#65AF32">@</font><font color="#A1C991">@@</font><font color="#65AF32">@</font><font color="#9BC27F">@@</font><font color="#57A61E">@</font><font color="#8AB976">@@</font><font color="#459407">@</font><font color="#84AB65">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#388801">@</font><font color="#7CA15C">@@</font><font color="#388801">@</font><font color="#729F5E">@</font><font color="#6E925B">@</font><font color="#2F7601">@</font><font color="#6A8C51">@@</font><font color="#2A6B00">@</font><font color="#64824A">@@</font><font color="#2A6B00">@</font><font color="#597A48">@@<br>
</font><font color="#5AA619">@</font><font color="#9BC27F">@@</font><font color="#61AA27">@</font><font color="#9BC27F">@@</font><font color="#61AA27">@</font><font color="#9BC27F">@</font><font color="#96BD7D">@</font><font color="#529F16">@</font><font color="#85B571">@@</font><font color="#459407">@</font><font color="#84AB65">@@</font><font color="#3F8F04">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#80A661">@@</font><font color="#428B01">@</font><font color="#7CA561">@@</font><font color="#388801">@</font><font color="#7CA15C">@@</font><font color="#388801">@</font><font color="#6E925B">@@</font><font color="#2F7601">@</font><font color="#6A8C51">@@</font><font color="#2A6B00">@</font><font color="#64824A">@</font><font color="#597A48">@</font><font color="#2A6B00">@</font><font color="#597A48">@@<br>
</font><font color="#59A410">@</font><font color="#5AA619">@@@@@@@</font><font color="#529F16">@@</font><font color="#48990F">@</font><font color="#459407">@@@</font><font color="#428B01">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#3E7C00">@@@</font><font color="#2F7601">@@@</font><font color="#336600">@@@@@@<br>
</font><font color="#59A410">@</font><font color="#96BB73">@@</font><font color="#5AA619">@</font><font color="#96BB73">@@</font><font color="#59A410">@</font><font color="#96BB73">@@</font><font color="#48990F">@</font><font color="#8DAD63">@@</font><font color="#459407">@</font><font color="#415732">@</font><font color="#202817">@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#336600">@</font><font color="#000000">@</font><font color="#7CA15C">@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#000000">@</font><font color="#597A48">@</font><font color="#7CA15C">@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#336600">@</font><font color="#000000">@</font><font color="#7CA15C">@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7C9D59">@@</font><font color="#3E7C00">@</font><font color="#739052">@@</font><font color="#3E7300">@</font><font color="#6A844B">@</font><font color="#64824A">@</font><font color="#336600">@</font><font color="#597A48">@@</font><font color="#336600">@</font><font color="#5B7543">@@<br>
</font><font color="#59A410">@</font><font color="#96BB73">@@</font><font color="#59A410">@</font><font color="#96BB73">@@</font><font color="#59A410">@</font><font color="#96B66B">@@</font><font color="#529603">@</font><font color="#84AB65">@@</font><font color="#4B8C00">@</font><font color="#415732">@</font><font color="#202817">@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#336600">@</font><font color="#000000">@</font><font color="#7CA15C">@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#000000">@</font><font color="#5B7543">@</font><font color="#7CA15C">@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#336600">@</font><font color="#000000">@</font><font color="#7CA15C">@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#428B01">@</font><font color="#7CA15C">@@</font><font color="#418200">@</font><font color="#7C9D59">@@</font><font color="#418200">@</font><font color="#739052">@@</font><font color="#3E7300">@</font><font color="#6A844B">@</font><font color="#64824A">@</font><font color="#336600">@</font><font color="#5B7543">@@</font><font color="#336600">@</font><font color="#5B7543">@@<br>
</font><font color="#59A410">@@@@@@@@</font><font color="#529603">@@@@</font><font color="#4B8C00">@</font><font color="#234600">@</font><font color="#0B1A01">@</font><font color="#182B00">@</font><font color="#000000">@</font><font color="#030800">@</font><font color="#2A5500">@</font><font color="#428B01">@@</font><font color="#2A5500">@</font><font color="#081100">@</font><font color="#000000">@@</font><font color="#122B00">@</font><font color="#418200">@@</font><font color="#112200">@</font><font color="#1F3C00">@</font><font color="#000000">@</font><font color="#1F3C00">@</font><font color="#428B01">@</font><font color="#1F3C00">@</font><font color="#000000">@</font><font color="#030800">@</font><font color="#182B00">@</font><font color="#000000">@</font><font color="#428B01">@@</font><font color="#305700">@</font><font color="#0B1A01">@</font><font color="#000000">@</font><font color="#030800">@</font><font color="#224400">@</font><font color="#428B01">@@</font><font color="#1F3C00">@</font><font color="#224400">@</font><font color="#112200">@</font><font color="#000000">@</font><font color="#081100">@</font><font color="#3A6B00">@</font><font color="#428B01">@@</font><font color="#224400">@</font><font color="#081100">@</font><font color="#000000">@</font><font color="#081100">@</font><font color="#305700">@</font><font color="#428B01">@@</font><font color="#2A5500">@</font><font color="#030800">@</font><font color="#000000">@</font><font color="#1F3C00">@</font><font color="#000000">@</font><font color="#336600">@</font><font color="#428B01">@@@@</font><font color="#336600">@</font><font color="#000000">@</font><font color="#1F3C00">@</font><font color="#000000">@</font><font color="#030800">@</font><font color="#2A5500">@</font><font color="#428B01">@</font><font color="#336600">@</font><font color="#112200">@</font><font color="#428B01">@@@</font><font color="#224400">@@</font><font color="#428B01">@</font><font color="#1F3C00">@</font><font color="#2A5500">@</font><font color="#418200">@</font><font color="#3E7C00">@@@@</font><font color="#3E7300">@@</font><font color="#336600">@@@@@@<br>
</font><font color="#59A410">@</font><font color="#96BB73">@@</font><font color="#59A410">@</font><font color="#96BB73">@@</font><font color="#5A9F09">@</font><font color="#96B66B">@@</font><font color="#529603">@</font><font color="#84AB65">@@</font><font color="#4B8C00">@</font><font color="#415732">@</font><font color="#000000">@</font><font color="#336600">@</font><font color="#7CA15C">@</font><font color="#324329">@</font><font color="#030800">@</font><font color="#7C9D59">@</font><font color="#739052">@</font><font color="#030800">@</font><font color="#5B693A">@</font><font color="#7C9D59">@</font><font color="#3E7C00">@</font><font color="#10130B">@</font><font color="#3E4D2B">@</font><font color="#428B01">@</font><font color="#000000">@</font><font color="#27311C">@</font><font color="#428B01">@</font><font color="#6A8C51">@</font><font color="#415732">@</font><font color="#081100">@</font><font color="#6A8C51">@</font><font color="#739052">@</font><font color="#182B00">@</font><font color="#000000">@</font><font color="#7C9D59">@</font><font color="#3E7C00">@</font><font color="#080A06">@</font><font color="#5B7543">@</font><font color="#428B01">@</font><font color="#6A8C51">@</font><font color="#182013">@</font><font color="#2A5500">@</font><font color="#7C9D59">@</font><font color="#202817">@</font><font color="#081100">@</font><font color="#6A8C51">@</font><font color="#739052">@</font><font color="#112200">@</font><font color="#27311C">@</font><font color="#7C9D59">@</font><font color="#2A5500">@</font><font color="#182013">@</font><font color="#6A8C51">@</font><font color="#428B01">@</font><font color="#5B7543">@</font><font color="#080A06">@</font><font color="#3E7C00">@</font><font color="#64824A">@</font><font color="#000000">@</font><font color="#336600">@</font><font color="#7C9D59">@</font><font color="#3E4D2B">@</font><font color="#000000">@</font><font color="#5B7543">@</font><font color="#7C9D59">@</font><font color="#428B01">@</font><font color="#7C9D59">@@</font><font color="#336600">@</font><font color="#000000">@</font><font color="#2B3823">@</font><font color="#428B01">@</font><font color="#5B7543">@</font><font color="#000000">@</font><font color="#3A6B00">@</font><font color="#7C9D59">@</font><font color="#080A06">@</font><font color="#2A5500">@</font><font color="#7C9D59">@</font><font color="#739052">@</font><font color="#000000">@</font><font color="#5B693A">@</font><font color="#7C9D59">@</font><font color="#3A6B00">@</font><font color="#6A844B">@</font><font color="#7A9352">@</font><font color="#418200">@</font><font color="#739052">@@</font><font color="#3E7300">@</font><font color="#6A844B">@@</font><font color="#3A6B00">@</font><font color="#5B7543">@@</font><font color="#336600">@</font><font color="#5B7543">@@<br>
</font><font color="#59A410">@</font><font color="#9BBD71">@@</font><font color="#59A410">@</font><font color="#9BBD71">@@</font><font color="#5A9F09">@</font><font color="#96B66B">@@</font><font color="#529603">@</font><font color="#8DAD63">@@</font><font color="#4B8C00">@</font><font color="#46502B">@</font><font color="#202817">@</font><font color="#4B8C00">@</font><font color="#7CA15C">@</font><font color="#5B7543">@</font><font color="#000000">@</font><font color="#7C9D59">@@</font><font color="#418200">@</font><font color="#5B693A">@</font><font color="#3E4D2B">@</font><font color="#1F3C00">@</font><font color="#080A06">@</font><font color="#3E4D2B">@</font><font color="#4B8C00">@</font><font color="#000000">@</font><font color="#5B7543">@</font><font color="#4B8C00">@</font><font color="#7C9D59">@</font><font color="#202817">@</font><font color="#234600">@</font><font color="#7C9D59">@@</font><font color="#336600">@</font><font color="#000000">@</font><font color="#7C9D59">@</font><font color="#234600">@</font><font color="#080A06">@</font><font color="#202817">@</font><font color="#112200">@</font><font color="#202817">@</font><font color="#10130B">@</font><font color="#112200">@</font><font color="#7C9D59">@</font><font color="#202817">@</font><font color="#234600">@</font><font color="#7C9D59">@@</font><font color="#234600">@</font><font color="#202817">@</font><font color="#7C9D59">@</font><font color="#112200">@</font><font color="#10130B">@</font><font color="#202817">@</font><font color="#112200">@</font><font color="#202817">@</font><font color="#080A06">@</font><font color="#234600">@</font><font color="#3E4D2B">@</font><font color="#202817">@</font><font color="#4B8C00">@</font><font color="#7C9D59">@</font><font color="#7A9352">@</font><font color="#000000">@</font><font color="#5B7543">@</font><font color="#7C9D59">@</font><font color="#4B8C00">@</font><font color="#7C9D59">@@</font><font color="#336600">@</font><font color="#000000">@</font><font color="#7C9D59">@</font><font color="#4B8C00">@</font><font color="#7C9D59">@</font><font color="#202817">@</font><font color="#234600">@</font><font color="#7C9D59">@</font><font color="#3E4D2B">@</font><font color="#081100">@</font><font color="#7C9D59">@</font><font color="#3E4D2B">@</font><font color="#081100">@</font><font color="#7C9D59">@@</font><font color="#4A8300">@</font><font color="#7C9D59">@@</font><font color="#418200">@</font><font color="#739052">@@</font><font color="#3E7300">@</font><font color="#6A844B">@@</font><font color="#3A6B00">@</font><font color="#647A44">@@</font><font color="#336600">@</font><font color="#5B7543">@@<br>
</font><font color="#62A60E">@@@@@@</font><font color="#5A9F09">@@@</font><font color="#529603">@@@@</font><font color="#234600">@</font><font color="#112200">@</font><font color="#4B8C00">@@</font><font color="#3A6B00">@</font><font color="#000000">@</font><font color="#4B8C00">@</font><font color="#3E7300">@</font><font color="#030800">@</font><font color="#182B00">@</font><font color="#234600">@@</font><font color="#0B1A01">@</font><font color="#234600">@</font><font color="#4B8C00">@</font><font color="#000000">@</font><font color="#336600">@</font><font color="#4B8C00">@@</font><font color="#112200">@</font><font color="#234600">@</font><font color="#4B8C00">@@</font><font color="#336600">@</font><font color="#000000">@</font><font color="#4B8C00">@</font><font color="#234600">@</font><font color="#081100">@</font><font color="#336600">@@@@</font><font color="#3E7300">@</font><font color="#4B8C00">@</font><font color="#112200">@</font><font color="#234600">@</font><font color="#4B8C00">@@</font><font color="#234600">@</font><font color="#112200">@</font><font color="#4B8C00">@</font><font color="#112200">@</font><font color="#182B00">@</font><font color="#336600">@@@@</font><font color="#3E7C00">@</font><font color="#234600">@</font><font color="#112200">@</font><font color="#4B8C00">@@@</font><font color="#000000">@</font><font color="#336600">@</font><font color="#4B8C00">@@@@</font><font color="#336600">@</font><font color="#000000">@</font><font color="#4B8C00">@@@</font><font color="#112200">@</font><font color="#234600">@</font><font color="#4B8C00">@</font><font color="#418200">@</font><font color="#000000">@</font><font color="#336600">@</font><font color="#081100">@</font><font color="#305700">@</font><font color="#4B8C00">@@</font><font color="#4A8300">@@@@@</font><font color="#3E7C00">@</font><font color="#3E7300">@@@</font><font color="#3A6B00">@@</font><font color="#336600">@@@@<br>
</font><font color="#62A60E">@</font><font color="#9BBD71">@@</font><font color="#62A60E">@</font><font color="#9BBD71">@@</font><font color="#61A209">@</font><font color="#96B66B">@@</font><font color="#589602">@</font><font color="#8DAD63">@@</font><font color="#529603">@</font><font color="#46502B">@</font><font color="#202817">@</font><font color="#4B8C00">@</font><font color="#84A25B">@</font><font color="#647A44">@</font><font color="#000000">@</font><font color="#7C9D59">@</font><font color="#3E4D2B">@</font><font color="#081100">@</font><font color="#7A9352">@</font><font color="#7C9D59">@</font><font color="#305700">@</font><font color="#080A06">@</font><font color="#3E4D2B">@</font><font color="#4B8C00">@</font><font color="#000000">@</font><font color="#647A44">@</font><font color="#4B8C00">@</font><font color="#7C9D59">@</font><font color="#546134">@</font><font color="#030800">@</font><font color="#6A8C51">@</font><font color="#7A9352">@</font><font color="#182B00">@</font><font color="#000000">@</font><font color="#7C9D59">@</font><font color="#3E7C00">@</font><font color="#000000">@</font><font color="#4D5930">@</font><font color="#4B8C00">@</font><font color="#6A8C51">@</font><font color="#182013">@</font><font color="#2A5500">@</font><font color="#7C9D59">@</font><font color="#202817">@</font><font color="#234600">@</font><font color="#7C9D59">@@</font><font color="#234600">@</font><font color="#202817">@</font><font color="#7C9D59">@</font><font color="#305700">@</font><font color="#080A06">@</font><font color="#647A44">@</font><font color="#4B8C00">@</font><font color="#647A44">@</font><font color="#10130B">@</font><font color="#3A6B00">@</font><font color="#6A8C51">@</font><font color="#000000">@</font><font color="#336600">@</font><font color="#7C9D59">@</font><font color="#3E4D2B">@</font><font color="#000000">@</font><font color="#647A44">@</font><font color="#7C9D59">@</font><font color="#4B8C00">@</font><font color="#7C9D59">@@</font><font color="#3A6B00">@</font><font color="#000000">@</font><font color="#3E4D2B">@</font><font color="#4B8C00">@</font><font color="#546134">@</font><font color="#000000">@</font><font color="#3E7C00">@</font><font color="#7C9D59">@@</font><font color="#1F3C00">@</font><font color="#080A06">@@</font><font color="#4A8300">@</font><font color="#7C9D59">@@</font><font color="#4B8C00">@</font><font color="#7C9D59">@@</font><font color="#4A8300">@</font><font color="#739052">@@</font><font color="#3E7300">@</font><font color="#6A844B">@@</font><font color="#3A6B00">@</font><font color="#647A44">@@</font><font color="#336600">@</font><font color="#5B7543">@@<br>
</font><font color="#62A60E">@</font><font color="#9BBD71">@@</font><font color="#62A60E">@</font><font color="#9BBD71">@@</font><font color="#61A209">@</font><font color="#96B66B">@@</font><font color="#5A9F09">@</font><font color="#8DAD63">@@</font><font color="#529603">@</font><font color="#46502B">@</font><font color="#202817">@</font><font color="#528B00">@</font><font color="#84A25B">@</font><font color="#647A44">@</font><font color="#000000">@</font><font color="#84A25B">@</font><font color="#7A9352">@</font><font color="#112200">@</font><font color="#000000">@@</font><font color="#182B00">@</font><font color="#202817">@</font><font color="#2B3823">@</font><font color="#528B00">@</font><font color="#000000">@</font><font color="#647A44">@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#1F3C00">@</font><font color="#080A06">@@</font><font color="#1F3C00">@</font><font color="#000000">@</font><font color="#84A25B">@</font><font color="#528B00">@</font><font color="#5B693A">@</font><font color="#182013">@</font><font color="#000000">@</font><font color="#080A06">@</font><font color="#2B3823">@</font><font color="#4A8300">@</font><font color="#84A25B">@</font><font color="#202817">@</font><font color="#234600">@</font><font color="#84A25B">@@</font><font color="#234600">@</font><font color="#202817">@</font><font color="#84A25B">@</font><font color="#528B00">@</font><font color="#3E4D2B">@</font><font color="#10130B">@</font><font color="#000000">@</font><font color="#10130B">@</font><font color="#3E4D2B">@</font><font color="#528B00">@</font><font color="#84A25B">@</font><font color="#546134">@</font><font color="#081100">@</font><font color="#000000">@</font><font color="#324329">@</font><font color="#000000">@</font><font color="#647A44">@</font><font color="#84A25B">@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#3A6B00">@</font><font color="#000000">@</font><font color="#324329">@</font><font color="#000000">@</font><font color="#10130B">@</font><font color="#546134">@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#497700">@</font><font color="#000000">@</font><font color="#324329">@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#112200">@</font><font color="#3E4D2B">@</font><font color="#7A9352">@</font><font color="#4A8300">@</font><font color="#739052">@@</font><font color="#497700">@</font><font color="#6A844B">@@</font><font color="#3A6B00">@</font><font color="#647A44">@@</font><font color="#3A6B00">@</font><font color="#5B7543">@@<br>
</font><font color="#62A60E">@@@@@@</font><font color="#61A209">@@@@</font><font color="#589602">@@@@</font><font color="#528B00">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#3A6B00">@</font><font color="#000000">@</font><font color="#497700">@</font><font color="#528B00">@@@@@</font><font color="#4A8300">@@@</font><font color="#497700">@@@</font><font color="#3E7300">@@</font><font color="#3A6B00">@@@@@<br>
</font><font color="#6FAC0E">@</font><font color="#9BBD71">@@</font><font color="#6FAC0E">@</font><font color="#9BBD71">@</font><font color="#BED0A0">@</font><font color="#ACC880">@</font><font color="#CED8BB">@@</font><font color="#ACC880">@</font><font color="#C4CEB3">@@</font><font color="#ACC880">@</font><font color="#B3C497">@</font><font color="#84A25B">@</font><font color="#528B00">@</font><font color="#BFCEAA">@@</font><font color="#61871A">@</font><font color="#84A25B">@</font><font color="#B3C497">@</font><font color="#ACC880">@</font><font color="#A0B580">@</font><font color="#84A25B">@</font><font color="#528B00">@</font><font color="#84A25B">@</font><font color="#8DA462">@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#A0B580">@</font><font color="#BFCEAA">@</font><font color="#A4BA7D">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#84A25B">@</font><font color="#B3C497">@</font><font color="#A4BA7D">@</font><font color="#9AAE79">@</font><font color="#84A25B">@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#93AC6E">@</font><font color="#BCC5A8">@</font><font color="#9BBD71">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#84A25B">@</font><font color="#27311C">@</font><font color="#030800">@</font><font color="#324329">@</font><font color="#84A25B">@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#7C9D59">@@</font><font color="#528400">@</font><font color="#7A9352">@@</font><font color="#497700">@</font><font color="#6A844B">@@</font><font color="#426B00">@</font><font color="#647A44">@@</font><font color="#3A6B00">@</font><font color="#647A44">@@<br>
</font><font color="#6FAC0E">@</font><font color="#A4C171">@@</font><font color="#6FAC0E">@</font><font color="#9BBD71">@</font><font color="#E6E6E6">@</font><font color="#F7F7F7">@@</font><font color="#EFEFEF">@</font><font color="#E6E6E6">@@@@</font><font color="#C5C9BC">@</font><font color="#859C5A">@</font><font color="#528B00">@</font><font color="#FFFFFF">@</font><font color="#EFEFEF">@</font><font color="#6E912B">@</font><font color="#859C5A">@</font><font color="#DEE2D6">@</font><font color="#EFEFEF">@</font><font color="#B3C497">@</font><font color="#859C5A">@</font><font color="#528B00">@</font><font color="#B3C497">@</font><font color="#EFEFEF">@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#5A8D00">@</font><font color="#84A25B">@@</font><font color="#5A8D00">@</font><font color="#84A25B">@@</font><font color="#5A8D00">@</font><font color="#84A25B">@@</font><font color="#5A8D00">@</font><font color="#C3CEAE">@</font><font color="#F7F7F7">@</font><font color="#EFEFEF">@</font><font color="#A9B491">@</font><font color="#859C5A">@</font><font color="#528B00">@</font><font color="#859C5A">@</font><font color="#DEE2D6">@</font><font color="#E6E6E6">@</font><font color="#A7AE94">@</font><font color="#859C5A">@</font><font color="#528B00">@</font><font color="#859C5A">@@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#5A8D00">@</font><font color="#84A25B">@@</font><font color="#5A8D00">@</font><font color="#A0B580">@</font><font color="#E6E6E6">@</font><font color="#DEDEDE">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#859C5A">@@</font><font color="#528B00">@</font><font color="#84A25B">@@</font><font color="#5A8D00">@</font><font color="#84A25B">@@</font><font color="#5A8D00">@</font><font color="#84A25B">@</font><font color="#6A844B">@</font><font color="#497700">@</font><font color="#84A25B">@@</font><font color="#5A8D00">@</font><font color="#84A25B">@@</font><font color="#528B00">@</font><font color="#839955">@@</font><font color="#528400">@</font><font color="#7A9352">@@</font><font color="#497700">@</font><font color="#738649">@@</font><font color="#426B00">@</font><font color="#647A44">@@</font><font color="#426B00">@</font><font color="#647A44">@@<br>
</font><font color="#6FAC0E">@@@@@</font><font color="#D8E6BF">@</font><font color="#EFEFEF">@</font><font color="#B3C497">@</font><font color="#84A25B">@</font><font color="#839955">@</font><font color="#758F4B">@</font><font color="#7A9352">@</font><font color="#758F4B">@</font><font color="#6C853D">@</font><font color="#528400">@@</font><font color="#F7F7F7">@</font><font color="#D6D6D6">@</font><font color="#5D841F">@</font><font color="#528B00">@</font><font color="#96B65F">@</font><font color="#9BBD71">@</font><font color="#6E912B">@</font><font color="#528B00">@</font><font color="#7EA83C">@</font><font color="#F7F7F7">@@</font><font color="#528B00">@@@</font><font color="#5A8D00">@@@@@@@@@@@@@</font><font color="#ACC880">@</font><font color="#F7F7F7">@</font><font color="#DEDEDE">@</font><font color="#CCD0C3">@</font><font color="#528400">@@@</font><font color="#CED8BB">@</font><font color="#D6D6D6">@</font><font color="#7A9352">@</font><font color="#528B00">@@@@</font><font color="#5A8D00">@@@@@@@</font><font color="#7EA83C">@</font><font color="#D6D6D6">@</font><font color="#C5C5C5">@</font><font color="#5A8D00">@</font><font color="#528B00">@@@@</font><font color="#5A8D00">@@@@@@@@@@@@@@@@@@</font><font color="#528400">@@@</font><font color="#497700">@@@</font><font color="#426B00">@@@@@@<br>
</font><font color="#6FAC0E">@</font><font color="#A4C171">@@</font><font color="#6FAC0E">@</font><font color="#A4C171">@</font><font color="#DEE2D6">@</font><font color="#D6D6D6">@</font><font color="#99A481">@</font><font color="#8DAD63">@</font><font color="#5A8D00">@</font><font color="#839955">@</font><font color="#7A9352">@</font><font color="#517B00">@</font><font color="#758F4B">@@</font><font color="#517B00">@</font><font color="#EFEFEF">@</font><font color="#C5C5C5">@</font><font color="#5C7C1E">@</font><font color="#7A9352">@</font><font color="#A9B491">@</font><font color="#A4BA7D">@</font><font color="#94A46F">@</font><font color="#8DA462">@</font><font color="#BED0A0">@</font><font color="#FFFFFF">@@</font><font color="#A4BA7D">@</font><font color="#9AAE79">@</font><font color="#839955">@</font><font color="#5A8600">@</font><font color="#9AAE79">@</font><font color="#C3CEAE">@@@</font><font color="#9AAE79">@</font><font color="#5A8D00">@</font><font color="#84A25B">@@</font><font color="#5A8D00">@</font><font color="#84A25B">@@</font><font color="#5A8D00">@</font><font color="#C3CEAE">@</font><font color="#F7F7F7">@</font><font color="#DEDEDE">@</font><font color="#C5C5C5">@</font><font color="#9EA48E">@</font><font color="#528400">@</font><font color="#7A9352">@</font><font color="#D5D9CC">@</font><font color="#CCCCCC">@</font><font color="#8C9574">@</font><font color="#7A9352">@</font><font color="#528400">@</font><font color="#BCC5A8">@@</font><font color="#61871A">@</font><font color="#839955">@@</font><font color="#96B65F">@</font><font color="#BFCEAA">@</font><font color="#9AAE79">@</font><font color="#5A8D00">@</font><font color="#A0B580">@</font><font color="#CCCCCC">@</font><font color="#C5C5C5">@</font><font color="#839955">@@</font><font color="#83A147">@</font><font color="#B0B5A2">@</font><font color="#A9B491">@</font><font color="#5A8600">@</font><font color="#859C5A">@</font><font color="#8DA462">@</font><font color="#A4C171">@</font><font color="#DEE2D6">@@</font><font color="#A4C171">@</font><font color="#8DA462">@</font><font color="#84A25B">@</font><font color="#5A8D00">@</font><font color="#A4BA7D">@</font><font color="#C3CEAE">@</font><font color="#96B65F">@</font><font color="#B3C497">@</font><font color="#DEE2D6">@</font><font color="#96B65F">@</font><font color="#839955">@</font><font color="#A9B491">@</font><font color="#B3C497">@</font><font color="#C5C9BC">@</font><font color="#D5D9CC">@</font><font color="#93AC6E">@</font><font color="#739052">@</font><font color="#6A844B">@</font><font color="#4A6B00">@</font><font color="#647A44">@@</font><font color="#426B00">@</font><font color="#647A44">@@<br>
</font><font color="#6FAC0E">@</font><font color="#A4C171">@@</font><font color="#6FAC0E">@</font><font color="#A4C171">@</font><font color="#DEE2D6">@</font><font color="#D6D6D6">@</font><font color="#9EA48E">@</font><font color="#8DA462">@</font><font color="#5A8600">@</font><font color="#739052">@</font><font color="#738649">@</font><font color="#497700">@</font><font color="#6A844B">@@</font><font color="#517B00">@</font><font color="#EFEFEF">@</font><font color="#BCBCBC">@</font><font color="#537517">@</font><font color="#758F4B">@</font><font color="#DEE2D6">@</font><font color="#F7F7F7">@</font><font color="#A9B491">@</font><font color="#94A46F">@</font><font color="#F7F7F7">@</font><font color="#EFEFEF">@</font><font color="#E6E6E6">@</font><font color="#DEDEDE">@</font><font color="#99A481">@</font><font color="#758F4B">@</font><font color="#8CA955">@</font><font color="#DEDEDE">@</font><font color="#BCBCBC">@</font><font color="#CCCCCC">@</font><font color="#E6E6E6">@@</font><font color="#83A147">@</font><font color="#839955">@@</font><font color="#5A8D00">@</font><font color="#84A25B">@@</font><font color="#5A8D00">@</font><font color="#C3CEAE">@</font><font color="#F7F7F7">@</font><font color="#DEDEDE">@</font><font color="#BCBCBC">@@</font><font color="#5D841F">@</font><font color="#738649">@</font><font color="#CCD0C3">@</font><font color="#C5C5C5">@</font><font color="#87926E">@</font><font color="#758F4B">@</font><font color="#517B00">@</font><font color="#F7F7F7">@</font><font color="#E6E6E6">@</font><font color="#6E912B">@</font><font color="#839955">@@</font><font color="#D8E6BF">@</font><font color="#EFEFEF">@</font><font color="#A9B491">@</font><font color="#5A8D00">@</font><font color="#A0B580">@</font><font color="#DEDEDE">@</font><font color="#CCCCCC">@</font><font color="#7A9352">@</font><font color="#9AAE79">@</font><font color="#E6E6E6">@</font><font color="#C5C5C5">@</font><font color="#7C8760">@</font><font color="#528400">@</font><font color="#8DA462">@</font><font color="#DEE2D6">@</font><font color="#EFEFEF">@@@@</font><font color="#D5D9CC">@</font><font color="#859C5A">@</font><font color="#5A8D00">@</font><font color="#BFCEAA">@</font><font color="#F7F7F7">@</font><font color="#DEE2D6">@</font><font color="#EFEFEF">@</font><font color="#E6E6E6">@</font><font color="#A4BA7D">@</font><font color="#BCC5A8">@</font><font color="#E6E6E6">@</font><font color="#C5C5C5">@</font><font color="#CCCCCC">@</font><font color="#E6E6E6">@@</font><font color="#BCBCBC">@</font><font color="#647A44">@</font><font color="#4A6B00">@</font><font color="#647241">@@</font><font color="#426B00">@</font><font color="#647A44">@@<br>
</font><font color="#7CB10E">@@@@@</font><font color="#D8E6BF">@</font><font color="#DEDEDE">@</font><font color="#C5C5C5">@</font><font color="#CCCCCC">@@@</font><font color="#DEDEDE">@@</font><font color="#5C7225">@</font><font color="#4A6B00">@@</font><font color="#E6E6E6">@</font><font color="#B5B5B5">@</font><font color="#506B14">@</font><font color="#497700">@</font><font color="#CED8BB">@</font><font color="#E6E6E6">@</font><font color="#7C8F53">@</font><font color="#537400">@</font><font color="#8DA462">@</font><font color="#D6D6D6">@</font><font color="#B5B5B5">@</font><font color="#537517">@@@</font><font color="#DEE2D6">@</font><font color="#BCBCBC">@</font><font color="#6C853D">@</font><font color="#5A8600">@</font><font color="#8CA955">@</font><font color="#EFEFEF">@</font><font color="#D9DDCF">@</font><font color="#5A8600">@@@</font><font color="#5A8D00">@@@</font><font color="#ACC880">@</font><font color="#E6E6E6">@</font><font color="#99A481">@@</font><font color="#B5B5B5">@</font><font color="#A7AE94">@</font><font color="#4A6B00">@</font><font color="#C3CEAE">@</font><font color="#BCBCBC">@</font><font color="#738245">@</font><font color="#497700">@@</font><font color="#F7F7F7">@</font><font color="#D6D6D6">@</font><font color="#5C7C1E">@</font><font color="#528400">@@</font><font color="#CED8BB">@</font><font color="#D6D6D6">@</font><font color="#80934E">@</font><font color="#5A8D00">@</font><font color="#7EA83C">@</font><font color="#EFEFEF">@</font><font color="#E6E6E6">@</font><font color="#6E912B">@</font><font color="#DEE2D6">@</font><font color="#C5C5C5">@</font><font color="#617B31">@</font><font color="#517B00">@@</font><font color="#ACC880">@</font><font color="#EFEFEF">@</font><font color="#B5BBA6">@</font><font color="#61871A">@</font><font color="#5A8600">@</font><font color="#C3CEAE">@</font><font color="#DEDEDE">@</font><font color="#8DA462">@</font><font color="#5A8600">@</font><font color="#ACC880">@</font><font color="#EFEFEF">@</font><font color="#CCCCCC">@</font><font color="#99A481">@</font><font color="#859C5A">@</font><font color="#61871A">@</font><font color="#E6E6E6">@</font><font color="#DEDEDE">@</font><font color="#728D3A">@</font><font color="#517B00">@</font><font color="#5C7C1E">@</font><font color="#BCBCBC">@</font><font color="#9EA48E">@</font><font color="#5C7225">@</font><font color="#426B00">@@@@@@<br>
</font><font color="#7CB10E">@</font><font color="#A4C171">@@</font><font color="#7CB10E">@</font><font color="#A4C171">@</font><font color="#DEE2D6">@</font><font color="#DEDEDE">@</font><font color="#B5B5B5">@</font><font color="#A5A5A5">@@</font><font color="#ADADAD">@</font><font color="#BCBCBC">@@</font><font color="#6B7550">@</font><font color="#647A44">@</font><font color="#4A6B00">@</font><font color="#E6E6E6">@</font><font color="#ADADAD">@</font><font color="#506B14">@</font><font color="#738245">@</font><font color="#CCD0C3">@</font><font color="#C5C5C5">@</font><font color="#7C8760">@</font><font color="#6C7B42">@</font><font color="#728D3A">@</font><font color="#D6D6D6">@</font><font color="#B5B5B5">@</font><font color="#4A6B00">@</font><font color="#647A44">@</font><font color="#99A481">@</font><font color="#DEDEDE">@</font><font color="#B5B5B5">@</font><font color="#738649">@</font><font color="#517B00">@</font><font color="#7C8F53">@</font><font color="#DEE2D6">@</font><font color="#E6E6E6">@</font><font color="#87926E">@</font><font color="#758F4B">@</font><font color="#528400">@</font><font color="#7A9352">@</font><font color="#839955">@</font><font color="#5A8D00">@</font><font color="#BFCEAA">@</font><font color="#D6D6D6">@</font><font color="#87926E">@</font><font color="#748254">@</font><font color="#D6D6D6">@@</font><font color="#99A481">@</font><font color="#C5C9BC">@</font><font color="#BCBCBC">@</font><font color="#7C8760">@</font><font color="#6C7B42">@</font><font color="#4A6B00">@</font><font color="#EFEFEF">@</font><font color="#C5C5C5">@</font><font color="#537517">@</font><font color="#758F4B">@@</font><font color="#C4CEB3">@</font><font color="#C5C5C5">@</font><font color="#87926E">@</font><font color="#5A8600">@</font><font color="#9AAE79">@</font><font color="#F7F7F7">@@</font><font color="#E6E6E6">@</font><font color="#CCCCCC">@</font><font color="#69753F">@@</font><font color="#738245">@</font><font color="#517B00">@</font><font color="#E6E6E6">@@</font><font color="#758F4B">@</font><font color="#7A9352">@@</font><font color="#83A147">@</font><font color="#DEDEDE">@</font><font color="#BCBCBC">@</font><font color="#517B00">@</font><font color="#B5BBA6">@</font><font color="#D6D6D6">@</font><font color="#BCBCBC">@</font><font color="#7A9352">@@</font><font color="#517B00">@</font><font color="#E6E6E6">@</font><font color="#EFEFEF">@</font><font color="#D9DDCF">@</font><font color="#B5BBA6">@</font><font color="#8C9574">@</font><font color="#4A6B00">@</font><font color="#647241">@</font><font color="#616D3B">@</font><font color="#436300">@</font><font color="#5B693A">@@</font><font color="#436300">@</font><font color="#647241">@@<br>
</font><font color="#7CB10E">@</font><font color="#A4C171">@@</font><font color="#7CB10E">@</font><font color="#A4C171">@</font><font color="#D9DDCF">@</font><font color="#C5C5C5">@</font><font color="#87926E">@</font><font color="#839955">@</font><font color="#517B00">@</font><font color="#69753F">@</font><font color="#63713C">@</font><font color="#436300">@</font><font color="#647241">@@</font><font color="#537400">@</font><font color="#E6E6E6">@</font><font color="#ADADAD">@</font><font color="#506B14">@</font><font color="#6C7B42">@</font><font color="#C5C9BC">@</font><font color="#B5B5B5">@</font><font color="#737B61">@</font><font color="#647241">@</font><font color="#6C853D">@</font><font color="#C5C5C5">@</font><font color="#B5B5B5">@</font><font color="#4A6B00">@</font><font color="#63713C">@</font><font color="#ABB09F">@</font><font color="#EFEFEF">@</font><font color="#CCCCCC">@</font><font color="#BCC5A8">@</font><font color="#C3CEAE">@</font><font color="#D5D9CC">@</font><font color="#E6E6E6">@</font><font color="#CCCCCC">@</font><font color="#87926E">@</font><font color="#738245">@</font><font color="#517B00">@</font><font color="#758F4B">@</font><font color="#80934E">@</font><font color="#5A8D00">@</font><font color="#B3C497">@</font><font color="#ADADAD">@</font><font color="#7C8760">@</font><font color="#738649">@</font><font color="#B5BBA6">@</font><font color="#E6E6E6">@@</font><font color="#C5C9BC">@</font><font color="#BCBCBC">@</font><font color="#737B61">@</font><font color="#647241">@</font><font color="#4A6B00">@</font><font color="#EFEFEF">@</font><font color="#BCBCBC">@</font><font color="#506B14">@</font><font color="#738649">@@</font><font color="#C3CEAE">@</font><font color="#BCBCBC">@</font><font color="#81896E">@</font><font color="#528400">@</font><font color="#9AAE79">@</font><font color="#F7F7F7">@</font><font color="#E6E6E6">@</font><font color="#DEDEDE">@</font><font color="#BCBCBC">@</font><font color="#8C9574">@</font><font color="#647241">@@</font><font color="#4A6B00">@</font><font color="#FFFFFF">@</font><font color="#EFEFEF">@</font><font color="#BCC5A8">@</font><font color="#C5C9BC">@</font><font color="#CCD0C3">@@</font><font color="#CCCCCC">@</font><font color="#BCBCBC">@</font><font color="#537400">@</font><font color="#A7AE94">@</font><font color="#BCBCBC">@</font><font color="#8C9574">@</font><font color="#738649">@@</font><font color="#537400">@</font><font color="#99A481">@</font><font color="#DEDEDE">@@@</font><font color="#CCCCCC">@@</font><font color="#ABB09F">@</font><font color="#596537">@</font><font color="#445A00">@</font><font color="#596537">@@</font><font color="#436300">@</font><font color="#63713C">@</font><font color="#69753F">@<br>
</font><font color="#7CB10E">@@@@@</font><font color="#C3CEAE">@</font><font color="#ADADAD">@</font><font color="#738245">@</font><font color="#5A8600">@</font><font color="#537400">@</font><font color="#4A6B00">@</font><font color="#436300">@@@</font><font color="#4A6B00">@</font><font color="#537400">@</font><font color="#E6E6E6">@</font><font color="#ADADAD">@</font><font color="#506B14">@</font><font color="#537400">@</font><font color="#BCC5A8">@</font><font color="#ADADAD">@</font><font color="#63713C">@</font><font color="#4A6300">@</font><font color="#617B31">@</font><font color="#ADADAD">@@</font><font color="#436300">@@</font><font color="#A0B580">@</font><font color="#EFEFEF">@</font><font color="#BCBCBC">@</font><font color="#738649">@</font><font color="#859C5A">@</font><font color="#9AAE79">@@</font><font color="#738649">@</font><font color="#4C6018">@</font><font color="#4A6B00">@@</font><font color="#517B00">@@</font><font color="#5A8600">@</font><font color="#93AC6E">@</font><font color="#999999">@</font><font color="#737B61">@</font><font color="#517B00">@</font><font color="#506B14">@</font><font color="#DEDEDE">@</font><font color="#E6E6E6">@</font><font color="#DEDEDE">@</font><font color="#ADADAD">@</font><font color="#647241">@</font><font color="#436300">@@</font><font color="#E6E6E6">@</font><font color="#B5B5B5">@</font><font color="#506B14">@</font><font color="#537400">@@</font><font color="#BCC5A8">@</font><font color="#ADADAD">@</font><font color="#69753F">@</font><font color="#517B00">@</font><font color="#83A147">@</font><font color="#E6E6E6">@</font><font color="#BCBCBC">@</font><font color="#7C8760">@</font><font color="#999999">@</font><font color="#B5B5B5">@</font><font color="#617B31">@</font><font color="#436300">@@</font><font color="#F7F7F7">@</font><font color="#DEDEDE">@</font><font color="#87926E">@</font><font color="#7C8F53">@</font><font color="#859C5A">@@</font><font color="#748254">@</font><font color="#6C7B42">@</font><font color="#4A6B00">@</font><font color="#94A46F">@</font><font color="#ADADAD">@</font><font color="#81896E">@</font><font color="#537400">@</font><font color="#4A6B00">@@@@</font><font color="#69753F">@</font><font color="#8C9574">@</font><font color="#ABB09F">@</font><font color="#D6D6D6">@</font><font color="#DEDEDE">@</font><font color="#8C9574">@</font><font color="#354B00">@@</font><font color="#445A00">@@</font><font color="#436300">@</font><font color="#4A6B00">@<br>
</font><font color="#7CB10E">@</font><font color="#AAC06B">@@</font><font color="#7CB10E">@</font><font color="#AAC06B">@</font><font color="#CCD0C3">@</font><font color="#ADADAD">@</font><font color="#87926E">@</font><font color="#80934E">@</font><font color="#537400">@</font><font color="#647241">@</font><font color="#616D3B">@</font><font color="#436300">@</font><font color="#63713C">@</font><font color="#69753F">@</font><font color="#537400">@</font><font color="#E6E6E6">@</font><font color="#A5A5A5">@</font><font color="#506B14">@</font><font color="#6C7B42">@</font><font color="#BCBCBC">@</font><font color="#A5A5A5">@</font><font color="#6B7259">@</font><font color="#63713C">@</font><font color="#617B31">@</font><font color="#B5B5B5">@</font><font color="#ADADAD">@</font><font color="#436300">@</font><font color="#5B693A">@</font><font color="#81896E">@</font><font color="#EFEFEF">@</font><font color="#C5C5C5">@</font><font color="#63713C">@</font><font color="#4A6B00">@</font><font color="#748254">@</font><font color="#BCBCBC">@</font><font color="#6B7550">@</font><font color="#5B693A">@</font><font color="#63713C">@</font><font color="#4A6B00">@</font><font color="#6C7B42">@</font><font color="#738649">@</font><font color="#5A8600">@</font><font color="#A9B491">@</font><font color="#A5A5A5">@</font><font color="#7C8760">@</font><font color="#738649">@</font><font color="#69753F">@</font><font color="#859C5A">@</font><font color="#EFEFEF">@</font><font color="#D6D6D6">@</font><font color="#999999">@</font><font color="#636A54">@</font><font color="#596537">@</font><font color="#445A00">@</font><font color="#EFEFEF">@</font><font color="#BCBCBC">@</font><font color="#556B22">@</font><font color="#69753F">@</font><font color="#6A844B">@</font><font color="#C5C9BC">@</font><font color="#999999">@</font><font color="#6B7259">@</font><font color="#537400">@</font><font color="#8C9574">@</font><font color="#CCCCCC">@</font><font color="#999999">@</font><font color="#616D3B">@</font><font color="#6B7259">@</font><font color="#B5B5B5">@@</font><font color="#596537">@</font><font color="#436300">@</font><font color="#CCD0C3">@</font><font color="#CCCCCC">@</font><font color="#738649">@</font><font color="#6C7B42">@@</font><font color="#94A46F">@</font><font color="#9EA48E">@</font><font color="#606A49">@</font><font color="#4A6300">@</font><font color="#9EA48E">@</font><font color="#A5A5A5">@</font><font color="#81896E">@</font><font color="#647241">@@</font><font color="#5C7C1E">@</font><font color="#B5BBA6">@</font><font color="#C5C9BC">@</font><font color="#506B14">@</font><font color="#5B693A">@</font><font color="#596537">@</font><font color="#99A481">@</font><font color="#D6D6D6">@</font><font color="#999999">@</font><font color="#354B00">@</font><font color="#4D5930">@</font><font color="#546134">@</font><font color="#445A00">@</font><font color="#616D3B">@</font><font color="#647241">@<br>
</font><font color="#85B208">@</font><font color="#AAC06B">@@</font><font color="#85B208">@</font><font color="#AAC06B">@</font><font color="#CED8BB">@</font><font color="#B5B5B5">@</font><font color="#A5A5A5">@</font><font color="#B5B5B5">@</font><font color="#C5C5C5">@</font><font color="#D6D6D6">@</font><font color="#DEDEDE">@@@</font><font color="#69753F">@</font><font color="#537400">@</font><font color="#D6D6D6">@</font><font color="#999999">@</font><font color="#506B14">@</font><font color="#6C7B42">@</font><font color="#B0B5A2">@</font><font color="#999999">@</font><font color="#636A54">@</font><font color="#616D3B">@</font><font color="#617B31">@</font><font color="#CCCCCC">@</font><font color="#C5C5C5">@</font><font color="#87926E">@</font><font color="#ABB09F">@</font><font color="#5B693A">@</font><font color="#CCD0C3">@</font><font color="#DEDEDE">@</font><font color="#CCCCCC">@</font><font color="#94A46F">@</font><font color="#C5C9BC">@</font><font color="#ADADAD">@</font><font color="#7E8372">@</font><font color="#5B693A">@@</font><font color="#4A6300">@</font><font color="#6C7B42">@</font><font color="#738245">@</font><font color="#5A8600">@</font><font color="#A7AE94">@</font><font color="#999999">@</font><font color="#7C8760">@</font><font color="#738649">@</font><font color="#69753F">@</font><font color="#436300">@</font><font color="#CCCCCC">@@</font><font color="#8B8B8B">@</font><font color="#606A49">@</font><font color="#546134">@</font><font color="#445A00">@</font><font color="#D5D9CC">@@</font><font color="#ADADAD">@</font><font color="#8C9574">@</font><font color="#ADADAD">@</font><font color="#999999">@</font><font color="#6B7259">@</font><font color="#606A49">@</font><font color="#4A6B00">@</font><font color="#7C8760">@</font><font color="#A5A5A5">@</font><font color="#8B8B8B">@</font><font color="#616D3B">@</font><font color="#5B693A">@</font><font color="#9EA48E">@</font><font color="#B5B5B5">@</font><font color="#737B61">@</font><font color="#445A00">@</font><font color="#87926E">@</font><font color="#D6D6D6">@@</font><font color="#B5BBA6">@@</font><font color="#DEDEDE">@</font><font color="#ADADAD">@</font><font color="#606A49">@</font><font color="#436300">@</font><font color="#8C9574">@</font><font color="#999999">@</font><font color="#737B61">@</font><font color="#616D3B">@@</font><font color="#436300">@</font><font color="#CCD0C3">@</font><font color="#DEDEDE">@</font><font color="#CCD0C3">@</font><font color="#A7AE94">@</font><font color="#B0B5A2">@</font><font color="#D5D9CC">@</font><font color="#B5B5B5">@</font><font color="#6B7259">@</font><font color="#354B00">@</font><font color="#4D5930">@@</font><font color="#445A00">@</font><font color="#5B693A">@</font><font color="#647241">@<br>
</font><font color="#85B208">@@@@@</font><font color="#BED0A0">@</font><font color="#BCBCBC">@</font><font color="#A5A5A5">@</font><font color="#ADADAD">@@</font><font color="#B5B5B5">@</font><font color="#C5C5C5">@</font><font color="#BCBCBC">@</font><font color="#C5C5C5">@</font><font color="#536C00">@</font><font color="#537400">@</font><font color="#D6D6D6">@</font><font color="#A5A5A5">@</font><font color="#506B14">@</font><font color="#537400">@</font><font color="#A7AE94">@</font><font color="#A5A5A5">@</font><font color="#647241">@</font><font color="#4A6300">@@</font><font color="#C5C9BC">@</font><font color="#D6D6D6">@</font><font color="#BCBCBC">@</font><font color="#9EA48E">@</font><font color="#436300">@</font><font color="#5C7225">@</font><font color="#B5BBA6">@</font><font color="#E6E6E6">@</font><font color="#D6D6D6">@</font><font color="#ADADAD">@</font><font color="#6B7259">@</font><font color="#445A00">@@@</font><font color="#4A6300">@</font><font color="#4A6B00">@</font><font color="#537400">@</font><font color="#5A8600">@</font><font color="#8DA462">@</font><font color="#A5A5A5">@</font><font color="#8C9574">@</font><font color="#5B7900">@</font><font color="#536C00">@</font><font color="#4A6300">@</font><font color="#617B31">@</font><font color="#CCCCCC">@</font><font color="#A5A5A5">@</font><font color="#616D3B">@</font><font color="#445A00">@@</font><font color="#738245">@</font><font color="#CCCCCC">@</font><font color="#A5A5A5">@</font><font color="#999999">@</font><font color="#6B7550">@@</font><font color="#7E8372">@</font><font color="#616D3B">@</font><font color="#4A6300">@</font><font color="#5C7225">@</font><font color="#A5A5A5">@@</font><font color="#4A6300">@</font><font color="#445A00">@</font><font color="#4C6018">@</font><font color="#BCBCBC">@</font><font color="#ADADAD">@</font><font color="#556B22">@</font><font color="#436300">@</font><font color="#94A46F">@</font><font color="#D5D9CC">@</font><font color="#E6E6E6">@</font><font color="#D6D6D6">@</font><font color="#A5A5A5">@</font><font color="#546134">@</font><font color="#445A00">@@</font><font color="#7C8760">@</font><font color="#A5A5A5">@</font><font color="#87926E">@</font><font color="#4A6300">@@@@</font><font color="#A7AE94">@</font><font color="#DEDEDE">@</font><font color="#EFEFEF">@</font><font color="#DEDEDE">@</font><font color="#B5B5B5">@</font><font color="#6B7550">@</font><font color="#354B00">@@@@</font><font color="#445A00">@@</font><font color="#4A6B00">@<br>
</font><font color="#85B208">@</font><font color="#AAC06B">@@</font><font color="#85B208">@</font><font color="#AAC06B">@</font><font color="#A4B863">@</font><font color="#749400">@</font><font color="#8E9B51">@</font><font color="#80934E">@</font><font color="#537400">@</font><font color="#647241">@</font><font color="#616D3B">@</font><font color="#4A6300">@</font><font color="#63713C">@</font><font color="#69753F">@</font><font color="#537400">@</font><font color="#738245">@@</font><font color="#537400">@</font><font color="#6C7B42">@</font><font color="#63713C">@</font><font color="#4A6300">@</font><font color="#616D3B">@@</font><font color="#4A6300">@</font><font color="#616D3B">@</font><font color="#748254">@</font><font color="#556B22">@</font><font color="#596537">@@</font><font color="#4A6300">@</font><font color="#616D3B">@</font><font color="#6B7550">@</font><font color="#556B22">@</font><font color="#5B693A">@</font><font color="#596537">@</font><font color="#445A00">@</font><font color="#596537">@@</font><font color="#4A6300">@</font><font color="#69753F">@</font><font color="#738245">@</font><font color="#5A8600">@</font><font color="#80934E">@@</font><font color="#648500">@</font><font color="#738649">@</font><font color="#6C7B42">@</font><font color="#4A6B00">@</font><font color="#616D3B">@@</font><font color="#445A00">@</font><font color="#546134">@@</font><font color="#445A00">@</font><font color="#596537">@</font><font color="#5B693A">@</font><font color="#4C6018">@</font><font color="#5B693A">@</font><font color="#616D3B">@</font><font color="#4A6300">@</font><font color="#616D3B">@@</font><font color="#4A6300">@</font><font color="#616D3B">@@</font><font color="#4A6300">@</font><font color="#5B693A">@@</font><font color="#445A00">@</font><font color="#546134">@@</font><font color="#445A00">@</font><font color="#596537">@</font><font color="#616D3B">@</font><font color="#4A6B00">@</font><font color="#7C8760">@</font><font color="#6B7550">@</font><font color="#445A00">@</font><font color="#596537">@@</font><font color="#445A00">@</font><font color="#596537">@@</font><font color="#4A6300">@</font><font color="#5B693A">@@</font><font color="#4A6300">@</font><font color="#616D3B">@@</font><font color="#537517">@</font><font color="#748254">@</font><font color="#606A49">@</font><font color="#445A00">@</font><font color="#4D5930">@</font><font color="#46502B">@</font><font color="#354B00">@</font><font color="#46502B">@@</font><font color="#445A00">@</font><font color="#5B693A">@</font><font color="#63713C">@<br>
</font><font color="#85B208">@</font><font color="#AAC06B">@@</font><font color="#85B208">@</font><font color="#A4B863">@@</font><font color="#749400">@</font><font color="#8E9B51">@</font><font color="#80934E">@</font><font color="#597300">@</font><font color="#69753F">@</font><font color="#63713C">@</font><font color="#4F6400">@</font><font color="#63713C">@@</font><font color="#537400">@</font><font color="#6C7B42">@@</font><font color="#537400">@</font><font color="#69753F">@@</font><font color="#4F6400">@</font><font color="#616D3B">@@</font><font color="#4A6300">@</font><font color="#616D3B">@@</font><font color="#4F6400">@</font><font color="#616D3B">@@</font><font color="#4A6300">@</font><font color="#616D3B">@@</font><font color="#4A6300">@</font><font color="#5B693A">@@</font><font color="#445A00">@</font><font color="#596537">@@</font><font color="#4F6400">@</font><font color="#69753F">@</font><font color="#738245">@</font><font color="#648500">@</font><font color="#80934E">@@</font><font color="#648500">@</font><font color="#738245">@</font><font color="#6C7B42">@</font><font color="#536C00">@</font><font color="#63713C">@@</font><font color="#4A6300">@</font><font color="#5B693A">@@</font><font color="#445A00">@</font><font color="#596537">@@</font><font color="#4F6400">@</font><font color="#63713C">@@</font><font color="#4F6400">@</font><font color="#616D3B">@@</font><font color="#4A6300">@</font><font color="#616D3B">@@</font><font color="#4A6300">@</font><font color="#616D3B">@@</font><font color="#4A6300">@</font><font color="#596537">@@</font><font color="#4A6300">@</font><font color="#5B693A">@</font><font color="#63713C">@</font><font color="#4A6B00">@</font><font color="#63713C">@@</font><font color="#4A6300">@</font><font color="#596537">@@</font><font color="#4A6300">@</font><font color="#5B693A">@@</font><font color="#4A6300">@</font><font color="#63713C">@@</font><font color="#4F6400">@</font><font color="#647241">@</font><font color="#69753F">@</font><font color="#536C00">@</font><font color="#63713C">@@</font><font color="#445A00">@</font><font color="#4D5930">@@</font><font color="#354B00">@</font><font color="#46502B">@</font><font color="#4D5930">@</font><font color="#445A00">@</font><font color="#5B693A">@</font><font color="#63713C">@<br>
</font><font color="#85B208">@@</font><font color="#86AB01">@@@@</font><font color="#819B00">@</font><font color="#6F8E00">@</font><font color="#648500">@</font><font color="#5B7900">@</font><font color="#536C00">@</font><font color="#4F6400">@@@@</font><font color="#536C00">@</font><font color="#537400">@@@@</font><font color="#536C00">@</font><font color="#4F6400">@@@@</font><font color="#536C00">@@@</font><font color="#4F6400">@@@@@@</font><font color="#4A6300">@@@@@@</font><font color="#537400">@</font><font color="#5B7900">@</font><font color="#648500">@@@@</font><font color="#5B7900">@@</font><font color="#537400">@</font><font color="#536C00">@@@@</font><font color="#4A6300">@@@@</font><font color="#536C00">@@@@</font><font color="#4A6300">@@@@@</font><font color="#4F6400">@@@@@@@@</font><font color="#536C00">@@@@</font><font color="#4A6300">@@@@@</font><font color="#D76900">@</font><font color="#FF6600">@</font><font color="#BA6D00">@</font><font color="#536C00">@@@</font><font color="#7F6D00">@</font><font color="#BA6D00">@</font><font color="#536C00">@</font><font color="#737400">@</font><font color="#F46600">@</font><font color="#D76900">@</font><font color="#CC6600">@@@@</font><font color="#445A00">@</font><font color="#4A6300">@</font><font color="#536C00">@<br>
</font><font color="#85B208">@</font><font color="#A4B863">@@</font><font color="#86AB01">@</font><font color="#A4B863">@</font><font color="#A1B25E">@</font><font color="#819B00">@</font><font color="#8E9B51">@</font><font color="#80934E">@</font><font color="#637B00">@</font><font color="#727B41">@</font><font color="#69753F">@</font><font color="#536C00">@</font><font color="#63713C">@@</font><font color="#536C00">@</font><font color="#6C7B42">@@</font><font color="#597300">@</font><font color="#6C7B42">@@</font><font color="#536C00">@</font><font color="#69753F">@@</font><font color="#536C00">@</font><font color="#69753F">@@</font><font color="#536C00">@</font><font color="#69753F">@@</font><font color="#536C00">@</font><font color="#69753F">@@</font><font color="#536C00">@</font><font color="#63713C">@@</font><font color="#4F6400">@</font><font color="#616D3B">@@</font><font color="#536C00">@</font><font color="#727B41">@</font><font color="#738649">@</font><font color="#648500">@</font><font color="#808D4B">@@</font><font color="#648500">@</font><font color="#7B8748">@</font><font color="#738245">@</font><font color="#597300">@</font><font color="#6C7B42">@@</font><font color="#597300">@</font><font color="#6C7B42">@</font><font color="#69753F">@</font><font color="#536C00">@</font><font color="#69753F">@@</font><font color="#536C00">@</font><font color="#6C7B42">@@</font><font color="#536C00">@</font><font color="#63713C">@@</font><font color="#4F6400">@</font><font color="#63713C">@@</font><font color="#536C00">@</font><font color="#69753F">@@</font><font color="#536C00">@</font><font color="#69753F">@@</font><font color="#536C00">@</font><font color="#69753F">@@</font><font color="#597300">@</font><font color="#6C7B42">@</font><font color="#69753F">@</font><font color="#536C00">@</font><font color="#63713C">@@</font><font color="#4F6400">@</font><font color="#69753F">@</font><font color="#DC6C11">@</font><font color="#FF6600">@@</font><font color="#6C7B42">@</font><font color="#597300">@</font><font color="#6C7B42">@</font><font color="#C3721E">@</font><font color="#737400">@</font><font color="#69753F">@</font><font color="#E56A0C">@</font><font color="#F46600">@</font><font color="#546134">@@</font><font color="#445A00">@</font><font color="#4D5930">@</font><font color="#546134">@</font><font color="#4A6300">@</font><font color="#616D3B">@</font><font color="#69753F">@<br>
</font><font color="#86AB01">@</font><font color="#A4B863">@@</font><font color="#86AB01">@</font><font color="#A1B25E">@@</font><font color="#819B00">@</font><font color="#8E9B51">@@</font><font color="#648500">@</font><font color="#738245">@@</font><font color="#597300">@</font><font color="#6C7B42">@@</font><font color="#597300">@</font><font color="#6C7B42">@@</font><font color="#5B7900">@</font><font color="#738245">@@</font><font color="#597300">@</font><font color="#727B41">@@</font><font color="#597300">@</font><font color="#727B41">@@</font><font color="#597300">@</font><font color="#6C7B42">@@</font><font color="#597300">@</font><font color="#6C7B42">@@</font><font color="#597300">@</font><font color="#6C7B42">@@</font><font color="#536C00">@</font><font color="#69753F">@@</font><font color="#597300">@</font><font color="#738245">@</font><font color="#7B8748">@</font><font color="#648500">@</font><font color="#808D4B">@@</font><font color="#648500">@</font><font color="#7B8748">@@</font><font color="#5B7900">@</font><font color="#738245">@@</font><font color="#5B7900">@</font><font color="#738245">@@</font><font color="#597300">@</font><font color="#6C7B42">@@</font><font color="#5B7900">@</font><font color="#727B41">@@</font><font color="#597300">@</font><font color="#69753F">@@</font><font color="#536C00">@</font><font color="#6C7B42">@@</font><font color="#597300">@</font><font color="#6C7B42">@@</font><font color="#597300">@</font><font color="#727B41">@@</font><font color="#5B7900">@</font><font color="#727B41">@@</font><font color="#5B7900">@</font><font color="#727B41">@@</font><font color="#597300">@</font><font color="#69753F">@@</font><font color="#536C00">@</font><font color="#A57429">@@</font><font color="#CC6600">@</font><font color="#FF6600">@</font><font color="#A57429">@</font><font color="#5B7900">@</font><font color="#738245">@</font><font color="#DC6C11">@</font><font color="#597300">@</font><font color="#867C3B">@</font><font color="#FF6600">@</font><font color="#BA6D00">@</font><font color="#5B693A">@@</font><font color="#445A00">@</font><font color="#596537">@@</font><font color="#4F6400">@</font><font color="#63713C">@</font><font color="#69753F">@<br>
</font><font color="#86AB01">@@@@@</font><font color="#819B00">@@</font><font color="#749400">@</font><font color="#6F8E00">@@</font><font color="#648500">@</font><font color="#637B00">@@</font><font color="#597300">@@@</font><font color="#5B7900">@@@@@@@@@@@@@@@@@@@</font><font color="#597300">@@@@@</font><font color="#637B00">@@</font><font color="#648500">@@@@</font><font color="#637B00">@@@@@@@@</font><font color="#5B7900">@@@@@@@</font><font color="#597300">@@@@</font><font color="#5B7900">@@@@@@@@@@@@@@</font><font color="#597300">@@@</font><font color="#CC6600">@</font><font color="#627500">@</font><font color="#9D7200">@</font><font color="#FF6600">@</font><font color="#BA6D00">@</font><font color="#5B7900">@</font><font color="#7F6D00">@</font><font color="#BA6D00">@</font><font color="#5B7900">@</font><font color="#A66F00">@</font><font color="#FF6600">@</font><font color="#917000">@</font><font color="#4F6400">@@@@@@</font><font color="#536C00">@</font><font color="#597300">@<br>
</font><font color="#86AB01">@</font><font color="#A1B25E">@@</font><font color="#86A500">@</font><font color="#9BAC5B">@@</font><font color="#749400">@</font><font color="#8E9B51">@@</font><font color="#6F8E00">@</font><font color="#808D4B">@</font><font color="#7B8748">@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#627500">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#627500">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7B8748">@@</font><font color="#637B00">@</font><font color="#7B8748">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#627500">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#6A7C00">@</font><font color="#DC6C11">@</font><font color="#738245">@</font><font color="#6A7C00">@</font><font color="#FF6600">@</font><font color="#E56A0C">@</font><font color="#637B00">@</font><font color="#C3721E">@</font><font color="#867C3B">@</font><font color="#627500">@</font><font color="#E56A0C">@</font><font color="#F46600">@</font><font color="#597300">@</font><font color="#69753F">@@</font><font color="#536C00">@</font><font color="#63713C">@@</font><font color="#536C00">@</font><font color="#6C7B42">@@<br>
</font><font color="#86AB01">@</font><font color="#A1B25E">@@</font><font color="#86A500">@</font><font color="#95A457">@@</font><font color="#7B9200">@</font><font color="#8E9B51">@@</font><font color="#6F8E00">@</font><font color="#808D4B">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#9D7200">@</font><font color="#A57429">@</font><font color="#738245">@</font><font color="#637B00">@</font><font color="#DC6C11">@</font><font color="#FF6600">@</font><font color="#7F6D00">@</font><font color="#DC6C11">@</font><font color="#738245">@</font><font color="#737400">@</font><font color="#FF6600">@</font><font color="#C3721E">@</font><font color="#597300">@</font><font color="#69753F">@@</font><font color="#536C00">@</font><font color="#69753F">@@</font><font color="#597300">@</font><font color="#727B41">@@<br>
</font><font color="#86A500">@@@@</font><font color="#819B00">@@</font><font color="#7B9200">@@</font><font color="#6F8E00">@</font><font color="#6C8400">@@@@</font><font color="#637B00">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#CC6600">@</font><font color="#6A7C00">@</font><font color="#637B00">@@</font><font color="#A66F00">@</font><font color="#FF6600">@</font><font color="#D76900">@</font><font color="#BA6D00">@</font><font color="#627500">@</font><font color="#A66F00">@</font><font color="#FF6600">@</font><font color="#917000">@</font><font color="#597300">@@@@@@@@</font><font color="#637B00">@<br>
</font><font color="#86A500">@</font><font color="#9BAC5B">@@</font><font color="#819B00">@</font><font color="#95A457">@</font><font color="#8E9B51">@</font><font color="#7B9200">@</font><font color="#8E9B51">@</font><font color="#80934E">@</font><font color="#6C8400">@</font><font color="#808D4B">@</font><font color="#7B8748">@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#738245">@</font><font color="#867C3B">@</font><font color="#D76900">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#867C3B">@</font><font color="#FF6600">@@</font><font color="#867C3B">@</font><font color="#727B41">@</font><font color="#BA6D00">@</font><font color="#FF6600">@</font><font color="#E56A0C">@</font><font color="#D76900">@</font><font color="#DC6C11">@@</font><font color="#9D7200">@</font><font color="#727B41">@@</font><font color="#627500">@</font><font color="#738245">@@<br>
</font><font color="#86A500">@</font><font color="#9BAC5B">@@</font><font color="#819B00">@</font><font color="#8E9B51">@@</font><font color="#7B9200">@</font><font color="#80934E">@@</font><font color="#6C8400">@</font><font color="#7B8748">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#637B00">@</font><font color="#738245">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#727B41">@@</font><font color="#627500">@</font><font color="#727B41">@@</font><font color="#627500">@</font><font color="#727B41">@@</font><font color="#627500">@</font><font color="#727B41">@@</font><font color="#627500">@</font><font color="#727B41">@@</font><font color="#637B00">@</font><font color="#7A8344">@@<br>
</font><font color="#86A500">@@@</font><font color="#819B00">@</font><font color="#7B9200">@@@@</font><font color="#6C8400">@@@</font><font color="#6A7C00">@@@@</font><font color="#637B00">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#627500">@@@@@@@@@</font><font color="#6A7C00">@@@@<br>
</font><font color="#86A500">@</font><font color="#9BAC5B">@</font><font color="#95A457">@</font><font color="#819B00">@</font><font color="#8E9B51">@@</font><font color="#7B9200">@</font><font color="#80934E">@@</font><font color="#6C8400">@</font><font color="#7B8748">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#738245">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6A7C00">@</font><font color="#7A8344">@@</font><font color="#6C8400">@</font><font color="#808D4B">@@<br>
</font>
</span>
<BR>
<style type="text/css">.asciiimage{
        color           : #000000;
        background-color: #FFFFFF;
        font-size       : 6px;
        font-family     : "Courier New", Courier, mono;
        line-height     : 4px;
        letter-spacing  : 0px;
    }</style><span class="asciiimage"><font color="#609DB2">##</font><font color="#73A9C2">#######</font><font color="#609DB2">####</font><font color="#5897AD">#</font><font color="#5293AD">###########################################################################</font><font color="#4C8EA8">####</font><font color="#44829F">#####</font><font color="#447F93">####<br>
</font><font color="#609DB2">#</font><font color="#ACC5CA">##</font><font color="#88B6C4">#</font><font color="#B5CDD6">##</font><font color="#88B6C4">#</font><font color="#ACC5CA">##</font><font color="#73A9C2">#</font><font color="#A0C5D1">#</font><font color="#9CBAC1">#</font><font color="#609DB2">#</font><font color="#9CBAC1">##</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#4C8EA8">#</font><font color="#8AA9AF">##</font><font color="#44829F">#</font><font color="#8AA9AF">##</font><font color="#447F93">#</font><font color="#7D9BA7">##</font><font color="#447F93">#</font><font color="#7A9296">##<br>
</font><font color="#73A9C2">#</font><font color="#B5CDD6">##</font><font color="#90BCC9">#</font><font color="#C3D7D8">##</font><font color="#90BCC9">#</font><font color="#B5CDD6">##</font><font color="#73A9C2">#</font><font color="#A0C5D1">##</font><font color="#609DB2">#</font><font color="#9CBAC1">##</font><font color="#5897AD">#</font><font color="#748C91">#</font><font color="#000000">####</font><font color="#162529">#</font><font color="#8AA9AF">#</font><font color="#95B5BC">#</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#95B5BC">#</font><font color="#8AA9AF">#</font><font color="#385E68">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#4C8EA8">#</font><font color="#617373">#</font><font color="#95B5BC">#</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#4B5A5C">#</font><font color="#000000">#</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#4B5A5C">#</font><font color="#000000">#</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5897AD">#</font><font color="#95B5BC">##</font><font color="#5293AD">#</font><font color="#95B5BC">##</font><font color="#4C8EA8">#</font><font color="#8AA9AF">##</font><font color="#44829F">#</font><font color="#8AA9AF">#</font><font color="#839EA4">#</font><font color="#447F93">#</font><font color="#7D9BA7">##</font><font color="#457C89">#</font><font color="#7A9296">##<br>
</font><font color="#73A9C2">#</font><font color="#88B6C4">#</font><font color="#90BCC9">#</font><font color="#A0C5D1">####</font><font color="#90BCC9">#</font><font color="#88B6C4">#</font><font color="#73A9C2">##</font><font color="#609DB2">####</font><font color="#5897AD">#</font><font color="#43747A">#</font><font color="#000000">#</font><font color="#335458">#</font><font color="#43747A">#</font><font color="#385E68">#</font><font color="#000000">#</font><font color="#22383C">#</font><font color="#5997A5">############</font><font color="#1D3030">#</font><font color="#162529">#</font><font color="#5997A5">##############</font><font color="#1D3030">#</font><font color="#162529">#</font><font color="#5997A5">###########</font><font color="#2C4B54">#</font><font color="#000000">#</font><font color="#5997A5">####</font><font color="#2C4B54">#</font><font color="#000000">#</font><font color="#5997A5">##################</font><font color="#4C8EA8">#</font><font color="#508C97">###</font><font color="#447F93">##</font><font color="#457C89">###</font><font color="#407484">###<br>
</font><font color="#79ABB2">#</font><font color="#B5CDD6">#</font><font color="#C3D7D8">#</font><font color="#A0C5D1">#</font><font color="#D6DCDC">##</font><font color="#A0C5D1">#</font><font color="#C3D7D8">#</font><font color="#B5CDD6">#</font><font color="#88B6C4">#</font><font color="#ACC5CA">##</font><font color="#609DB2">#</font><font color="#9CBAC1">##</font><font color="#5997A5">#</font><font color="#748C91">#</font><font color="#000000">#</font><font color="#43747A">#</font><font color="#95B5BC">##</font><font color="#162529">#</font><font color="#1D3030">#</font><font color="#95B5BC">#</font><font color="#162529">#</font><font color="#4B5A5C">#</font><font color="#070806">#</font><font color="#284144">#</font><font color="#8AA9AF">#</font><font color="#384345">#</font><font color="#000000">#</font><font color="#070806">#</font><font color="#4B5A5C">#</font><font color="#5997A5">#</font><font color="#617373">#</font><font color="#070806">##</font><font color="#414E51">#</font><font color="#95B5BC">#</font><font color="#284144">#</font><font color="#000000">#</font><font color="#070806">#</font><font color="#385E68">#</font><font color="#95B5BC">##</font><font color="#335458">#</font><font color="#070806">#</font><font color="#000000">#</font><font color="#284144">#</font><font color="#95B5BC">#</font><font color="#617373">#</font><font color="#070806">##</font><font color="#414E51">#</font><font color="#5997A5">#</font><font color="#414E51">#</font><font color="#000000">#</font><font color="#070806">#</font><font color="#617373">#</font><font color="#95B5BC">#</font><font color="#5997A5">#</font><font color="#414E51">#</font><font color="#000000">#</font><font color="#0B1212">#</font><font color="#2B3642">#</font><font color="#000000">#</font><font color="#5997A5">#</font><font color="#95B5BC">##</font><font color="#5997A5">#</font><font color="#4B5A5C">#</font><font color="#000000">#</font><font color="#284144">#</font><font color="#000000">#</font><font color="#111A1A">#</font><font color="#457C89">#</font><font color="#839EA4">#</font><font color="#1D3030">#</font><font color="#43747A">#</font><font color="#95B5BC">#</font><font color="#8AA9AF">#</font><font color="#162529">#</font><font color="#6C827E">#</font><font color="#95B5BC">#</font><font color="#5997A5">#</font><font color="#95B5BC">##</font><font color="#5997A5">#</font><font color="#93B0B2">##</font><font color="#508C97">#</font><font color="#8AA9AF">##</font><font color="#447F93">#</font><font color="#839EA4">##</font><font color="#457C89">#</font><font color="#7A9296">##</font><font color="#407484">#</font><font color="#748C91">##<br>
</font><font color="#79ABB2">#</font><font color="#B5CDD6">#</font><font color="#C3D7D8">#</font><font color="#A0C5D1">#</font><font color="#D6DCDC">##</font><font color="#A0C5D1">#</font><font color="#C3D7D8">##</font><font color="#88B6C4">#</font><font color="#ACC5CA">##</font><font color="#609DB2">#</font><font color="#9CBAC1">##</font><font color="#5997A5">#</font><font color="#73828C">#</font><font color="#000000">#</font><font color="#335458">#</font><font color="#73828C">#</font><font color="#617373">#</font><font color="#000000">#</font><font color="#414E51">#</font><font color="#95B5BC">#</font><font color="#000000">#</font><font color="#070806">#</font><font color="#4B5A5C">#</font><font color="#43747A">#</font><font color="#384345">#</font><font color="#070806">#</font><font color="#406B6B">#</font><font color="#546568">#</font><font color="#000000">#</font><font color="#385E68">#</font><font color="#73828C">#</font><font color="#111A1A">#</font><font color="#0B1212">#</font><font color="#617373">#</font><font color="#546568">#</font><font color="#000000">#</font><font color="#697D78">#</font><font color="#546568">#</font><font color="#000000">#</font><font color="#7A9296">##</font><font color="#000000">#</font><font color="#4B5A5C">#</font><font color="#546568">#</font><font color="#000000">#</font><font color="#617373">#</font><font color="#73828C">#</font><font color="#0B1212">##</font><font color="#617373">#</font><font color="#335458">#</font><font color="#000000">#</font><font color="#697D78">#</font><font color="#335458">#</font><font color="#000000">#</font><font color="#7A9296">#</font><font color="#43747A">#</font><font color="#000000">#</font><font color="#384345">#</font><font color="#406B6B">#</font><font color="#070806">#</font><font color="#000000">#</font><font color="#5997A5">#</font><font color="#95B5BC">##</font><font color="#5997A5">#</font><font color="#4B5A5C">#</font><font color="#000000">#</font><font color="#22383C">#</font><font color="#697D78">#</font><font color="#070806">#</font><font color="#162529">#</font><font color="#95B5BC">#</font><font color="#111A1A">#</font><font color="#22383C">#</font><font color="#95B5BC">#</font><font color="#617373">#</font><font color="#000000">#</font><font color="#839EA4">#</font><font color="#95B5BC">#</font><font color="#5997A5">#</font><font color="#95B5BC">##</font><font color="#59939B">#</font><font color="#93B0B2">##</font><font color="#508C97">#</font><font color="#8AA9AF">##</font><font color="#447F93">#</font><font color="#839EA4">##</font><font color="#457C89">#</font><font color="#7A9296">#</font><font color="#748C91">#</font><font color="#43747A">#</font><font color="#73828C">##<br>
</font><font color="#79ABB2">#</font><font color="#88B6C4">#</font><font color="#90BCC9">#</font><font color="#A0C5D1">#####</font><font color="#90BCC9">#</font><font color="#88B5B3">#</font><font color="#79ABB2">##</font><font color="#609DB2">##</font><font color="#5997A5">##</font><font color="#43747A">#</font><font color="#000000">####</font><font color="#22383C">#</font><font color="#508C97">#</font><font color="#59939B">#</font><font color="#000000">#</font><font color="#284144">#</font><font color="#59939B">##</font><font color="#000000">#</font><font color="#284144">#</font><font color="#59939B">##</font><font color="#111A1A">#</font><font color="#162529">#</font><font color="#59939B">#</font><font color="#162529">##</font><font color="#59939B">#</font><font color="#162529">#</font><font color="#0B1212">#</font><font color="#2D4A4C">##</font><font color="#000000">#</font><font color="#2D4A4C">##</font><font color="#000000">#</font><font color="#59939B">##</font><font color="#4F7D7A">#</font><font color="#59939B">##</font><font color="#162529">##</font><font color="#59939B">#</font><font color="#162529">#</font><font color="#0B1212">#</font><font color="#2D4A4C">##</font><font color="#000000">#</font><font color="#2D4A4C">##</font><font color="#000000">#</font><font color="#59939B">##</font><font color="#2D4A4C">#</font><font color="#000000">#</font><font color="#59939B">####</font><font color="#2D4A4C">#</font><font color="#000000">#</font><font color="#59939B">##</font><font color="#2D4A4C">#</font><font color="#000000">#</font><font color="#59939B">#</font><font color="#335458">#</font><font color="#070806">#</font><font color="#59939B">#</font><font color="#1D3030">##</font><font color="#59939B">######</font><font color="#508C97">#####</font><font color="#457C89">###</font><font color="#43747A">######<br>
</font><font color="#79ABB2">#</font><font color="#ACC5CA">#</font><font color="#B5CDD6">#</font><font color="#9CBAC1">#</font><font color="#C3D7D8">##</font><font color="#A0C5D1">#</font><font color="#C3D7D8">#</font><font color="#B5CDD6">#</font><font color="#88B5B3">#</font><font color="#ACC5CA">#</font><font color="#9CBAC1">#</font><font color="#669999">#</font><font color="#95B5BC">##</font><font color="#59939B">#</font><font color="#738A86">#</font><font color="#000000">#</font><font color="#406B6B">#</font><font color="#93B0B2">##</font><font color="#59939B">#</font><font color="#93B0B2">##</font><font color="#000000">#</font><font color="#4B5A5C">#</font><font color="#93B0B2">#</font><font color="#59939B">#</font><font color="#000000">#</font><font color="#414E51">#</font><font color="#59939B">#</font><font color="#93B0B2">#</font><font color="#1E201A">#</font><font color="#162529">#</font><font color="#93B0B2">#</font><font color="#1D3030">#</font><font color="#162529">#</font><font color="#93B0B2">#</font><font color="#1D3030">#</font><font color="#0B1212">#</font><font color="#4B5A5C">##</font><font color="#2D4A4C">#</font><font color="#6C827E">#</font><font color="#4B5A5C">#</font><font color="#000000">#</font><font color="#93B0B2">##</font><font color="#43747A">#</font><font color="#93B0B2">##</font><font color="#162529">##</font><font color="#93B0B2">#</font><font color="#162529">#</font><font color="#101212">#</font><font color="#4B5A5C">#</font><font color="#2D4A4C">#</font><font color="#4B5A5C">#</font><font color="#6C827E">#</font><font color="#2D4A4C">#</font><font color="#000000">#</font><font color="#93B0B2">#</font><font color="#59939B">#</font><font color="#4B5A5C">#</font><font color="#000000">#</font><font color="#59939B">#</font><font color="#93B0B2">##</font><font color="#59939B">#</font><font color="#4B5A5C">#</font><font color="#000000">#</font><font color="#598E87">#</font><font color="#93B0B2">#</font><font color="#4B5A5C">#</font><font color="#000000">#</font><font color="#93B0B2">#</font><font color="#839EA4">#</font><font color="#000000">#</font><font color="#5C6E6F">#</font><font color="#000000">#</font><font color="#385B5B">#</font><font color="#93B0B2">##</font><font color="#59939B">#</font><font color="#93B0B2">##</font><font color="#59939B">#</font><font color="#8AA9AF">##</font><font color="#508C97">#</font><font color="#839EA4">##</font><font color="#457C89">#</font><font color="#7A9296">##</font><font color="#43747A">#</font><font color="#738A86">##</font><font color="#406B6B">#</font><font color="#6C827E">##<br>
</font><font color="#79ABB2">#</font><font color="#ACC5CA">##</font><font color="#88B5B3">#</font><font color="#B5CDD6">##</font><font color="#95B5BC">#</font><font color="#ACC5CA">#</font><font color="#9CBAC1">#</font><font color="#669999">#</font><font color="#8BA59F">##</font><font color="#598E87">#</font><font color="#8BA59F">##</font><font color="#598E87">#</font><font color="#6C827E">#</font><font color="#000000">#</font><font color="#406B6B">#</font><font color="#93B0B2">##</font><font color="#59939B">#</font><font color="#93B0B2">##</font><font color="#000000">#</font><font color="#4B5A5C">#</font><font color="#93B0B2">#</font><font color="#59939B">#</font><font color="#384345">#</font><font color="#070806">#</font><font color="#416762">#</font><font color="#566662">#</font><font color="#000000">#</font><font color="#385B5B">#</font><font color="#93B0B2">#</font><font color="#1D3030">#</font><font color="#111A1A">#</font><font color="#6C827E">#</font><font color="#566662">#</font><font color="#000000">#</font><font color="#5C6E6F">#</font><font color="#617373">#</font><font color="#192929">#</font><font color="#697D78">##</font><font color="#000000">#</font><font color="#414E51">#</font><font color="#4B5A5C">#</font><font color="#000000">#</font><font color="#546568">#</font><font color="#8AA9AF">#</font><font color="#162529">#</font><font color="#1E201A">#</font><font color="#617373">#</font><font color="#2D4A4C">#</font><font color="#000000">#</font><font color="#4B5A5C">#</font><font color="#335458">#</font><font color="#1D3030">#</font><font color="#697D78">#</font><font color="#406B6B">#</font><font color="#000000">#</font><font color="#333333">#</font><font color="#385B5B">#</font><font color="#070806">#</font><font color="#000000">#</font><font color="#4F7D7A">#</font><font color="#859A93">##</font><font color="#4F7D7A">#</font><font color="#414E51">#</font><font color="#000000">#</font><font color="#1D3030">#</font><font color="#546568">#</font><font color="#070806">#</font><font color="#192929">#</font><font color="#859A93">##</font><font color="#192929">#</font><font color="#101212">#</font><font color="#070806">#</font><font color="#4F7D7A">#</font><font color="#859A93">##</font><font color="#4F7D7A">#</font><font color="#7A9296">##</font><font color="#4F7D7A">#</font><font color="#7A9296">##</font><font color="#43747A">#</font><font color="#748C91">##</font><font color="#4F7D7A">#</font><font color="#7A9296">#</font><font color="#748C91">#</font><font color="#43747A">#</font><font color="#738A86">#</font><font color="#6C827E">#</font><font color="#406B6B">#</font><font color="#6C827E">##<br>
</font><font color="#7FA8A6">###</font><font color="#88B5B3">###</font><font color="#7FA8A6">#</font><font color="#748C91">#</font><font color="#598B7D">#</font><font color="#4D7270">#####</font><font color="#4F7D7A">##</font><font color="#416762">#</font><font color="#000000">#</font><font color="#406B6B">#</font><font color="#598E87">#####</font><font color="#000000">#</font><font color="#2D4A4C">#</font><font color="#598E87">##</font><font color="#548683">#</font><font color="#1D3030">#</font><font color="#000000">#</font><font color="#070806">#</font><font color="#2D4A4C">#</font><font color="#598E87">##</font><font color="#2D4A4C">#</font><font color="#000000">#</font><font color="#192929">#</font><font color="#598E87">#</font><font color="#284144">#</font><font color="#000000">##</font><font color="#192929">#</font><font color="#385B5B">#</font><font color="#416762">#</font><font color="#22383C">#</font><font color="#070806">#</font><font color="#000000">#</font><font color="#1D3030">#</font><font color="#4F7D7A">##</font><font color="#284144">#</font><font color="#000000">#</font><font color="#162529">#</font><font color="#416762">#</font><font color="#1D3030">#</font><font color="#000000">##</font><font color="#192929">#</font><font color="#416762">##</font><font color="#284144">#</font><font color="#070806">##</font><font color="#192929">#</font><font color="#000000">#</font><font color="#406B6B">####</font><font color="#1D3030">#</font><font color="#0B1212">#</font><font color="#111A1A">#</font><font color="#000000">#</font><font color="#111A1A">#</font><font color="#385B5B">#</font><font color="#406B6B">##</font><font color="#284144">#</font><font color="#000000">#</font><font color="#192929">#</font><font color="#406B6B">######</font><font color="#416762">#####</font><font color="#406B6B">#</font><font color="#4D7270">####</font><font color="#406B6B">#####<br>
</font><font color="#74A699">#</font><font color="#B3C3B8">#</font><font color="#ACC5CA">#</font><font color="#7FA8A6">#</font><font color="#ACC5CA">#</font><font color="#A4BDAE">#</font><font color="#598B7D">#</font><font color="#6C827E">#</font><font color="#62736C">#</font><font color="#426456">#</font><font color="#617373">##</font><font color="#406B6B">#</font><font color="#6C827E">#</font><font color="#738A86">#</font><font color="#4F7D7A">#</font><font color="#859A93">#</font><font color="#8BA59F">#</font><font color="#598E87">#</font><font color="#8BA59F">##</font><font color="#598E87">#</font><font color="#8BA59F">##</font><font color="#598E87">#</font><font color="#8BA59F">##</font><font color="#598E87">#</font><font color="#8BA59F">##</font><font color="#598E87">#</font><font color="#8BA59F">##</font><font color="#598E87">#</font><font color="#8BA59F">##</font><font color="#598E87">#</font><font color="#8BA59F">##</font><font color="#548683">#</font><font color="#738A86">#</font><font color="#617373">#</font><font color="#335458">#</font><font color="#4B5A5C">#</font><font color="#546568">#</font><font color="#385B5B">#</font><font color="#617373">#</font><font color="#697D78">#</font><font color="#406B6B">#</font><font color="#738A86">#</font><font color="#6C827E">#</font><font color="#416762">#</font><font color="#617373">#</font><font color="#5C6E6F">#</font><font color="#385B5B">#</font><font color="#5C6E6F">#</font><font color="#617373">#</font><font color="#416762">#</font><font color="#617373">##</font><font color="#416762">#</font><font color="#617373">##</font><font color="#416762">#</font><font color="#617373">##</font><font color="#416762">#</font><font color="#617373">##</font><font color="#416762">#</font><font color="#617373">##</font><font color="#416762">#</font><font color="#617373">##</font><font color="#416762">#</font><font color="#617373">##</font><font color="#22383C">#</font><font color="#000000">#</font><font color="#4B5A5C">#</font><font color="#416762">#</font><font color="#617373">##</font><font color="#416762">#</font><font color="#617373">##</font><font color="#385B5B">#</font><font color="#617373">##</font><font color="#385B5B">#</font><font color="#617373">#</font><font color="#697D78">#</font><font color="#406B6B">#</font><font color="#738A86">##</font><font color="#406B6B">#</font><font color="#6C827E">#</font><font color="#697D78">#</font><font color="#416762">#</font><font color="#697D78">##<br>
</font><font color="#74A699">#</font><font color="#B3C3B8">##</font><font color="#74A699">#</font><font color="#A4BDAE">#</font><font color="#8BA59F">#</font><font color="#4D7270">#</font><font color="#5B6B64">#</font><font color="#697D78">#</font><font color="#C4CDCB">#</font><font color="#D6D6D6">##</font><font color="#CCD8D6">##</font><font color="#8BA59F">#</font><font color="#4D7270">#</font><font color="#7A9296">#</font><font color="#859A93">#</font><font color="#598B7D">#</font><font color="#8BA59F">##</font><font color="#598B7D">#</font><font color="#8BA59F">##</font><font color="#598B7D">#</font><font color="#8BA59F">##</font><font color="#598B7D">#</font><font color="#8BA59F">##</font><font color="#598B7D">#</font><font color="#8BA59F">##</font><font color="#598B7D">#</font><font color="#8BA59F">##</font><font color="#598B7D">#</font><font color="#8BA59F">##</font><font color="#4F7D7A">#</font><font color="#697D78">#</font><font color="#566662">#</font><font color="#6C827E">#</font><font color="#CCCCCC">#</font><font color="#CCD8D6">##</font><font color="#D6DCDC">##</font><font color="#CCD8D6">#</font><font color="#6C827E">#</font><font color="#617373">#</font><font color="#385B5B">#</font><font color="#566662">#</font><font color="#A6B5A6">#</font><font color="#C4CDCB">#</font><font color="#D6D6D6">##</font><font color="#CCD8D6">#</font><font color="#D6DCDC">##</font><font color="#CCD8D6">#</font><font color="#D6DCDC">##</font><font color="#CCD8D6">#</font><font color="#D6DCDC">##</font><font color="#CCD8D6">#</font><font color="#D6DCDC">##</font><font color="#CCD8D6">#</font><font color="#D6DCDC">##</font><font color="#CCD8D6">#</font><font color="#D6DCDC">##</font><font color="#CCD8D6">#</font><font color="#D6DCDC">#</font><font color="#333333">#</font><font color="#000000">#</font><font color="#333333">#</font><font color="#D6DCDC">#</font><font color="#CCD8D6">#</font><font color="#D6DCDC">##</font><font color="#CCD8D6">#</font><font color="#D6DCDC">##</font><font color="#CCD8D6">####</font><font color="#D6DCDC">#</font><font color="#C4CDCB">#</font><font color="#4D7270">#</font><font color="#738A86">##</font><font color="#406B6B">#</font><font color="#697D78">##</font><font color="#416762">#</font><font color="#697D78">##<br>
</font><font color="#74A699">####</font><font color="#6D9B8E">#</font><font color="#598874">#</font><font color="#48685B">#</font><font color="#414E51">#</font><font color="#E6E6E6">#</font><font color="#FFFFFF">######</font><font color="#B6C9BC">#</font><font color="#598B7D">#</font><font color="#598874">###</font><font color="#598B7D">###################</font><font color="#4D7270">#</font><font color="#426456">#</font><font color="#2D4A4C">#</font><font color="#859A93">#</font><font color="#FFFFFF">######</font><font color="#4D7270">#</font><font color="#416762">#</font><font color="#385B5B">#</font><font color="#738A86">#</font><font color="#FFFFFF">########################</font><font color="#CCCCCC">#</font><font color="#BDBDBD">#</font><font color="#FFFFFF">##############</font><font color="#93B0B2">#</font><font color="#5A7A6A">##</font><font color="#4D7270">#</font><font color="#416762">#####<br>
</font><font color="#74A699">#</font><font color="#A4BDAE">##</font><font color="#74A699">#</font><font color="#8BA59F">#</font><font color="#738A86">#</font><font color="#426456">#</font><font color="#62736C">#</font><font color="#FFFFFF">########</font><font color="#EFEFEF">#</font><font color="#A6B5A6">#</font><font color="#598874">#</font><font color="#859A93">##</font><font color="#598874">#</font><font color="#859A93">##</font><font color="#598B7D">#</font><font color="#8BA59F">##</font><font color="#598B7D">#</font><font color="#8BA59F">##</font><font color="#598B7D">#</font><font color="#8BA59F">##</font><font color="#598B7D">#</font><font color="#8BA59F">##</font><font color="#598B7D">#</font><font color="#8BA59F">##</font><font color="#4D7270">#</font><font color="#62736C">#</font><font color="#566662">#</font><font color="#8BA59F">#</font><font color="#FFFFFF">######</font><font color="#859A93">#</font><font color="#738A86">#</font><font color="#426456">#</font><font color="#A6B5A6">#</font><font color="#FFFFFF">########################################</font><font color="#B3C3B8">#</font><font color="#8B9A93">#</font><font color="#84998C">#</font><font color="#5A7A6A">#</font><font color="#697D78">##</font><font color="#426456">#</font><font color="#617373">##<br>
</font><font color="#74A588">#</font><font color="#A4BDAE">##</font><font color="#74A588">#</font><font color="#8BA59F">#</font><font color="#7C8683">#</font><font color="#48685B">#</font><font color="#697D78">#</font><font color="#FFFFFF">##########</font><font color="#C4CDCB">#</font><font color="#8B9A93">#</font><font color="#84998C">#</font><font color="#598874">#</font><font color="#859A93">##</font><font color="#598874">#</font><font color="#8B9A93">##</font><font color="#598874">#</font><font color="#8B9A93">##</font><font color="#598874">#</font><font color="#8B9A93">##</font><font color="#598874">#</font><font color="#8B9A93">##</font><font color="#598874">#</font><font color="#8B9A93">##</font><font color="#4D7270">#</font><font color="#62736C">#</font><font color="#5B6B64">#</font><font color="#9CADA3">#</font><font color="#FFFFFF">######</font><font color="#94A797">#</font><font color="#84998C">#</font><font color="#566662">#</font><font color="#ACBBAE">#</font><font color="#FFFFFF">########################################</font><font color="#B3C3B8">#</font><font color="#94A797">#</font><font color="#8B9A93">#</font><font color="#5A7A6A">#</font><font color="#6A746F">##</font><font color="#426456">#</font><font color="#62736C">##<br>
</font><font color="#74A588">####</font><font color="#699171">#</font><font color="#597B61">#</font><font color="#48685B">#</font><font color="#597B61">#</font><font color="#FFFFFF">###########</font><font color="#F7F7F7">#</font><font color="#8BA59F">#</font><font color="#5C8769">###</font><font color="#598874">###############</font><font color="#597B61">#</font><font color="#426456">##</font><font color="#9CADA3">#</font><font color="#FFFFFF">######</font><font color="#7C9789">#</font><font color="#738A86">#</font><font color="#5A7A6A">#</font><font color="#9CADA3">#</font><font color="#FFFFFF">########################################</font><font color="#B3C3B8">#</font><font color="#7C9789">#</font><font color="#77957D">#</font><font color="#5A7A6A">#</font><font color="#426456">#####<br>
</font><font color="#74A588">#</font><font color="#A4BDAE">##</font><font color="#74A588">#</font><font color="#94A797">#</font><font color="#7C8683">#</font><font color="#577359">#</font><font color="#7C8683">#</font><font color="#FFFFFF">#############</font><font color="#CCD8D6">#</font><font color="#8B9A93">#</font><font color="#84998C">#</font><font color="#5C8769">#</font><font color="#84998C">##</font><font color="#5C8769">#</font><font color="#859A93">#</font><font color="#7C7E9D">#</font><font color="#5F6385">##</font><font color="#859A93">#</font><font color="#5C8769">#</font><font color="#859A93">##</font><font color="#5C8769">#</font><font color="#859A93">##</font><font color="#597B61">#</font><font color="#6A746F">#</font><font color="#62736C">#</font><font color="#9CADA3">#</font><font color="#FFFFFF">######</font><font color="#9CADA3">#</font><font color="#94A797">#</font><font color="#5A7A6A">#</font><font color="#B3C3B8">#</font><font color="#FFFFFF">########################################</font><font color="#B3C3B8">#</font><font color="#9CADA3">#</font><font color="#94A797">#</font><font color="#5A7A6A">#</font><font color="#6C7A6C">##</font><font color="#426456">#</font><font color="#62736C">##<br>
</font><font color="#74A588">#</font><font color="#A4BDAE">##</font><font color="#74A588">#</font><font color="#94A797">#</font><font color="#7C8683">#</font><font color="#577359">#</font><font color="#7C8683">#</font><font color="#FFFFFF">##############</font><font color="#F7F7F7">#</font><font color="#B6C9BC">#</font><font color="#5C8769">#</font><font color="#84998C">##</font><font color="#5C8769">#</font><font color="#84998C">#</font><font color="#666699">#</font><font color="#3A3A84">#</font><font color="#333366">#</font><font color="#84998C">#</font><font color="#5C8769">#</font><font color="#84998C">##</font><font color="#5C8769">#</font><font color="#84998C">##</font><font color="#597B61">#</font><font color="#6C7A6C">#</font><font color="#62736C">#</font><font color="#9CADA3">#</font><font color="#FFFFFF">######</font><font color="#9CADA3">#</font><font color="#94A797">#</font><font color="#5C8769">#</font><font color="#B3C3B8">#</font><font color="#FFFFFF">#####</font><font color="#EFEFEF">#</font><font color="#CCD8D6">#</font><font color="#C4CDCB">#</font><font color="#CCD8D6">##</font><font color="#B6C9BC">#</font><font color="#CCD8D6">##</font><font color="#B6C9BC">#</font><font color="#CCD8D6">##</font><font color="#B6C9BC">#</font><font color="#CCD8D6">##</font><font color="#B6C9BC">#</font><font color="#CCD8D6">##</font><font color="#B6C9BC">#</font><font color="#CCD8D6">##</font><font color="#B6C9BC">#</font><font color="#CCD8D6">##</font><font color="#B6C9BC">#</font><font color="#CCCCCC">##</font><font color="#B6C9BC">#</font><font color="#C4CDCB">##</font><font color="#EFEFEF">#</font><font color="#FFFFFF">#####</font><font color="#B3C3B8">#</font><font color="#9CADA3">#</font><font color="#94A797">#</font><font color="#5A7A6A">#</font><font color="#6C7A6C">##</font><font color="#426456">#</font><font color="#62736C">##<br>
</font><font color="#7BA87C">####</font><font color="#699171">#</font><font color="#597B61">#</font><font color="#577359">##</font><font color="#FFFFFF">################</font><font color="#D6DCDC">#</font><font color="#699171">#</font><font color="#5C8261">###</font><font color="#5A5A95">#</font><font color="#2A2A6C">#</font><font color="#1E1F4C">#</font><font color="#5C8769">#</font><font color="#5C8261">###</font><font color="#5C8769">###</font><font color="#597B61">#</font><font color="#426456">##</font><font color="#9EAE9E">#</font><font color="#FFFFFF">######</font><font color="#7C9789">#</font><font color="#77957D">#</font><font color="#5C8769">#</font><font color="#A6B5A6">#</font><font color="#FFFFFF">#####</font><font color="#DEDEDE">#</font><font color="#B3C3B8">###</font><font color="#A4BDAE">#</font><font color="#9EAE9E">#</font><font color="#8EAC95">##################</font><font color="#8AA98E">##</font><font color="#74A588">#</font><font color="#77957D">##</font><font color="#D6DCDC">#</font><font color="#FFFFFF">#####</font><font color="#B3C3B8">#</font><font color="#84998C">#</font><font color="#77957D">#</font><font color="#5A7A6A">#</font><font color="#426456">#####<br>
</font><font color="#7BA87C">#</font><font color="#A4BDAE">##</font><font color="#7BA87C">#</font><font color="#94A797">#</font><font color="#7D8D78">#</font><font color="#577359">#</font><font color="#7D8D78">#</font><font color="#FFFFFF">#################</font><font color="#F7F7F7">#</font><font color="#B3C3B8">#</font><font color="#5C8261">#</font><font color="#849680">#</font><font color="#4F4F8C">#</font><font color="#212168">#</font><font color="#212158">#</font><font color="#849680">#</font><font color="#597B61">#</font><font color="#77957D">##</font><font color="#5C8261">#</font><font color="#84998C">##</font><font color="#577359">#</font><font color="#6C7A6C">#</font><font color="#697564">#</font><font color="#9EAE9E">#</font><font color="#FFFFFF">######</font><font color="#9EAE9E">#</font><font color="#94A797">#</font><font color="#5C8769">#</font><font color="#B3C3B8">#</font><font color="#FFFFFF">#####</font><font color="#E6E6E6">#</font><font color="#C4CDCB">#</font><font color="#B6C9BC">#</font><font color="#C4CDCB">#</font><font color="#B6C9BC">#</font><font color="#8EAC95">#</font><font color="#ACBBAE">##</font><font color="#8AA98E">#</font><font color="#ACBBAE">##</font><font color="#8AA98E">#</font><font color="#ACBBAE">##</font><font color="#8AA98E">#</font><font color="#ACBBAE">##</font><font color="#8AA98E">#</font><font color="#ACBBAE">##</font><font color="#8AA98E">#</font><font color="#A6B5A6">##</font><font color="#8AA98E">#</font><font color="#A6B5A6">##</font><font color="#77957D">#</font><font color="#9EAE9E">#</font><font color="#94A797">#</font><font color="#D6DCDC">#</font><font color="#FFFFFF">#####</font><font color="#B6C9BC">#</font><font color="#A6B5A6">#</font><font color="#94A797">#</font><font color="#6A7F60">#</font><font color="#6C7A6C">##</font><font color="#4F6546">#</font><font color="#62736C">##<br>
</font><font color="#7BA87C">#</font><font color="#A4BDAE">##</font><font color="#7BA87C">#</font><font color="#9CADA3">#</font><font color="#9596A3">#</font><font color="#748C91">#</font><font color="#849680">#</font><font color="#EFEFEF">#</font><font color="#9B9BC3">#</font><font color="#6B6BA4">#</font><font color="#8888B3">#</font><font color="#EFEFEF">#</font><font color="#FFFFFF">#</font><font color="#DEDEDE">#</font><font color="#FFFFFF">#</font><font color="#F7F7F7">#</font><font color="#B5CDD6">#</font><font color="#B9B9C6">#</font><font color="#CCD8D6">#</font><font color="#FFFFFF">###</font><font color="#CCD8D6">#</font><font color="#B9B9C6">#</font><font color="#8888B3">#</font><font color="#FFFFFF">#</font><font color="#E2E5DA">#</font><font color="#94A797">#</font><font color="#434385">#</font><font color="#212158">##</font><font color="#7D8D78">#</font><font color="#577359">#</font><font color="#7D8D78">#</font><font color="#878798">#</font><font color="#697D78">#</font><font color="#73828C">#</font><font color="#8C998A">#</font><font color="#577359">#</font><font color="#6C7A6C">##</font><font color="#9BA5AD">#</font><font color="#8888B3">##</font><font color="#9B9BC3">#</font><font color="#EFEFEF">#</font><font color="#FFFFFF">##</font><font color="#9EAE9E">#</font><font color="#94A797">#</font><font color="#6A7F60">#</font><font color="#B3C3B8">#</font><font color="#DEDEDE">#</font><font color="#9B9BC3">#</font><font color="#8888B3">##</font><font color="#B9B9C6">#</font><font color="#DEDEDE">#</font><font color="#C5C5C5">#</font><font color="#A4BDAE">##</font><font color="#A6B5A6">#</font><font color="#849680">#</font><font color="#A6B5A6">#</font><font color="#8E93AC">#</font><font color="#687197">#</font><font color="#666699">#</font><font color="#687197">#</font><font color="#77957D">#</font><font color="#94A797">##</font><font color="#789275">#</font><font color="#94A797">#</font><font color="#9CADA3">#</font><font color="#8BA59F">#</font><font color="#9BA5AD">#</font><font color="#9CADA3">#</font><font color="#84998C">#</font><font color="#7474A3">#</font><font color="#5A5A95">#</font><font color="#5F6385">#</font><font color="#94A797">##</font><font color="#699171">#</font><font color="#94A797">##</font><font color="#C5C5C5">#</font><font color="#9B9BC3">#</font><font color="#8888B3">#</font><font color="#7E7EAC">#</font><font color="#8888B3">#</font><font color="#B9B9C6">#</font><font color="#B6C9BC">#</font><font color="#A6B5A6">#</font><font color="#94A797">#</font><font color="#6A7F60">#</font><font color="#6C7A6C">##</font><font color="#4F6546">#</font><font color="#697564">##<br>
</font><font color="#7BA87C">####</font><font color="#8BA59F">#</font><font color="#9B9BC3">#</font><font color="#7E7EAC">#</font><font color="#73828C">#</font><font color="#4F4F8C">#</font><font color="#434385">#</font><font color="#30307B">#</font><font color="#2A2A75">##</font><font color="#D6DCDC">#</font><font color="#9EAE9E">#</font><font color="#8EAC95">#</font><font color="#D6DCDC">#</font><font color="#7474A3">#</font><font color="#30307B">#</font><font color="#8589A4">#</font><font color="#F7F7F7">###</font><font color="#8888B3">#</font><font color="#3A3A84">#</font><font color="#080858">#</font><font color="#F7F7F7">###</font><font color="#3A3A84">#</font><font color="#191958">#</font><font color="#1E1F4C">#</font><font color="#577359">##</font><font color="#8E93AC">#</font><font color="#666699">#</font><font color="#333366">#</font><font color="#48685B">#</font><font color="#5C8261">#</font><font color="#577359">#</font><font color="#697564">#</font><font color="#8888B3">#</font><font color="#7474A3">#</font><font color="#5A5A95">#</font><font color="#434385">#</font><font color="#3A3A84">#</font><font color="#2A2A75">#</font><font color="#9B9BC3">#</font><font color="#F7F7F7">#</font><font color="#77957D">#</font><font color="#789275">#</font><font color="#738069">#</font><font color="#9B9BC3">#</font><font color="#7474A3">#</font><font color="#5A5A95">#</font><font color="#4F4F8C">#</font><font color="#434385">#</font><font color="#30307B">#</font><font color="#4A4D7E">#</font><font color="#94A797">##</font><font color="#7BA87C">#</font><font color="#5C8261">#</font><font color="#748C91">#</font><font color="#7474A3">#</font><font color="#666699">#</font><font color="#4F4F8C">#</font><font color="#434385">#</font><font color="#30307B">#</font><font color="#2A2A75">#</font><font color="#546568">#</font><font color="#5C8261">###</font><font color="#859A93">#</font><font color="#9B9BC3">#</font><font color="#7E7EAC">#</font><font color="#73828C">#</font><font color="#5A5A8C">#</font><font color="#434385">#</font><font color="#3A3A84">##</font><font color="#30307B">#</font><font color="#597B61">#</font><font color="#5C8769">#</font><font color="#699171">#</font><font color="#8589A4">#</font><font color="#7474A3">#</font><font color="#5A5A95">#</font><font color="#4F4F8C">#</font><font color="#3A3A84">#</font><font color="#30307B">###</font><font color="#8C998A">#</font><font color="#788C6E">#</font><font color="#577359">#</font><font color="#4D6944">#####<br>
</font><font color="#7BA87C">#</font><font color="#A4BDAE">##</font><font color="#7BA87C">#</font><font color="#9BA5AD">#</font><font color="#8888B3">#</font><font color="#434377">#</font><font color="#212158">#</font><font color="#8589A4">#</font><font color="#C5C5C5">#</font><font color="#5A5A8C">#</font><font color="#191967">#</font><font color="#080858">#</font><font color="#666699">#</font><font color="#A6B5A6">#</font><font color="#8C998A">#</font><font color="#9CADA3">#</font><font color="#666699">#</font><font color="#212168">#</font><font color="#7C7E9D">#</font><font color="#EFEFEF">###</font><font color="#8888B3">#</font><font color="#2A2A6C">#</font><font color="#02024B">#</font><font color="#EFEFEF">###</font><font color="#3A3A84">#</font><font color="#2A2A6C">#</font><font color="#333366">#</font><font color="#6C7A6C">#</font><font color="#748C91">#</font><font color="#7474A3">#</font><font color="#333366">#</font><font color="#2B3642">#</font><font color="#7D8D78">##</font><font color="#5E7D4F">#</font><font color="#9B9BC3">#</font><font color="#6B6BA4">#</font><font color="#434377">#</font><font color="#B4B4B4">#</font><font color="#B9B9C6">#</font><font color="#5A5A95">#</font><font color="#3A3A84">#</font><font color="#191967">#</font><font color="#B9B9C6">#</font><font color="#94A797">#</font><font color="#8C998A">#</font><font color="#8589A4">#</font><font color="#7474A3">#</font><font color="#3A3A75">#</font><font color="#8E93AC">#</font><font color="#C5C5C5">#</font><font color="#8589A4">#</font><font color="#212168">#</font><font color="#191958">#</font><font color="#434377">#</font><font color="#8C998A">#</font><font color="#94A797">#</font><font color="#8D959E">#</font><font color="#7474A3">#</font><font color="#434377">##</font><font color="#577359">#</font><font color="#697D78">#</font><font color="#434377">#</font><font color="#212168">#</font><font color="#191967">#</font><font color="#5C6E6F">#</font><font color="#5E7D4F">#</font><font color="#849680">#</font><font color="#9596A3">#</font><font color="#8888B3">#</font><font color="#4A4D7E">#</font><font color="#212158">#</font><font color="#4B5A5C">#</font><font color="#6C7A6C">#</font><font color="#546568">#</font><font color="#30307B">##</font><font color="#353974">#</font><font color="#5E7D4F">#</font><font color="#8E93AC">#</font><font color="#7E7EAC">#</font><font color="#434377">#</font><font color="#5C6E6F">#</font><font color="#7C8683">#</font><font color="#697D78">#</font><font color="#5B5B83">#</font><font color="#2A2A6C">#</font><font color="#191967">#</font><font color="#4A4D7E">#</font><font color="#7D8D78">#</font><font color="#4D6944">#</font><font color="#697564">##</font><font color="#4D6944">#</font><font color="#697564">##<br>
</font><font color="#84AC72">#</font><font color="#B2C39D">##</font><font color="#84AC72">#</font><font color="#9596A3">#</font><font color="#6B6BA4">#</font><font color="#212168">#</font><font color="#313157">#</font><font color="#E6E6E6">#</font><font color="#DEDEDE">#</font><font color="#D6D6D6">#</font><font color="#2A2A75">#</font><font color="#101058">#</font><font color="#3A3A75">#</font><font color="#9EAE9E">#</font><font color="#849680">#</font><font color="#9CADA3">#</font><font color="#5A5A95">#</font><font color="#212158">#</font><font color="#6A6E85">#</font><font color="#E6E6E6">###</font><font color="#7E7EAC">#</font><font color="#212168">#</font><font color="#02024B">#</font><font color="#E6E6E6">###</font><font color="#4D4D94">#</font><font color="#434385">#</font><font color="#5A5A8C">#</font><font color="#7C7E9D">#</font><font color="#666699">#</font><font color="#353974">#</font><font color="#313157">#</font><font color="#4D6944">#</font><font color="#738069">##</font><font color="#787F7A">#</font><font color="#8888B3">#</font><font color="#434385">#</font><font color="#6C827E">#</font><font color="#E6E6E6">##</font><font color="#DEDEDE">#</font><font color="#6B6BA4">#</font><font color="#212168">#</font><font color="#4A4D7E">#</font><font color="#8C998A">##</font><font color="#6B6BA4">#</font><font color="#434377">#</font><font color="#616187">#</font><font color="#EFEFEF">#</font><font color="#E6E6E6">##</font><font color="#687197">#</font><font color="#4A4D7E">#</font><font color="#535A67">#</font><font color="#789275">#</font><font color="#8B9A93">#</font><font color="#7E7EAC">#</font><font color="#434377">#</font><font color="#2B2B57">#</font><font color="#849680">#</font><font color="#5E7D4F">#</font><font color="#7D8D78">##</font><font color="#3A3A75">#</font><font color="#191967">#</font><font color="#212168">#</font><font color="#5E7D4F">#</font><font color="#7D8D78">#</font><font color="#8D959E">#</font><font color="#7474A3">#</font><font color="#212168">#</font><font color="#313157">#</font><font color="#5E7D4F">#</font><font color="#7D8D78">##</font><font color="#6A6E85">#</font><font color="#5A5A95">#</font><font color="#3A3A84">#</font><font color="#6A7F60">#</font><font color="#8589A4">#</font><font color="#5A5A95">#</font><font color="#212168">#</font><font color="#6A746F">#</font><font color="#8C998A">#</font><font color="#788C6E">#</font><font color="#8C998A">#</font><font color="#62677A">#</font><font color="#4B5A5C">#</font><font color="#646B5C">#</font><font color="#697564">#</font><font color="#4F6546">#</font><font color="#646B5C">##</font><font color="#4D6944">#</font><font color="#697564">##<br>
</font><font color="#84AC72">####</font><font color="#748C91">#</font><font color="#5A5A95">#</font><font color="#212158">#</font><font color="#415143">#</font><font color="#D6DCDC">#</font><font color="#CCCCCC">##</font><font color="#30307B">#</font><font color="#212168">#</font><font color="#3A3A75">#</font><font color="#7D8D78">#</font><font color="#788C6E">#</font><font color="#849680">#</font><font color="#4F4F8C">#</font><font color="#191958">#</font><font color="#384345">#</font><font color="#94A797">#</font><font color="#CCCCCC">#</font><font color="#D6D6D6">#</font><font color="#6B6BA4">#</font><font color="#212158">#</font><font color="#02024B">#</font><font color="#DEDEDE">##</font><font color="#D6D6D6">#</font><font color="#4D4D94">#</font><font color="#5A5A95">#</font><font color="#4D4D94">#</font><font color="#5A5A95">#</font><font color="#3A3A75">#</font><font color="#191958">#</font><font color="#4B5837">##</font><font color="#4D6944">##</font><font color="#73828C">#</font><font color="#6B6BA4">#</font><font color="#2A2A75">#</font><font color="#7C8683">#</font><font color="#C4CDCB">###</font><font color="#7474A3">#</font><font color="#212168">#</font><font color="#191958">#</font><font color="#6A7F60">#</font><font color="#73828C">#</font><font color="#5A5A95">#</font><font color="#212168">#</font><font color="#9596A3">#</font><font color="#DEDEDE">##</font><font color="#D6D6D6">#</font><font color="#CCCCCC">#</font><font color="#A6B5A6">#</font><font color="#788C6E">##</font><font color="#7C8683">#</font><font color="#6B6BA4">#</font><font color="#212158">#</font><font color="#415143">#</font><font color="#5E7D4F">####</font><font color="#5B5B83">#</font><font color="#3A3A84">#</font><font color="#2A2A6C">#</font><font color="#577359">##</font><font color="#6C827E">#</font><font color="#5A5A95">#</font><font color="#212168">#</font><font color="#415143">#</font><font color="#5E7D4F">##</font><font color="#5D6C48">#</font><font color="#6C7A6C">#</font><font color="#5A5A95">#</font><font color="#434385">#</font><font color="#5B6B64">#</font><font color="#4B5A5C">#</font><font color="#212158">#</font><font color="#101058">#</font><font color="#191967">#</font><font color="#3A3A84">#</font><font color="#5B5B83">#</font><font color="#617373">#</font><font color="#577359">#</font><font color="#4F6546">##</font><font color="#415634">#</font><font color="#4B5837">###</font><font color="#4D6944">###<br>
</font><font color="#84AC72">#</font><font color="#B2C39D">##</font><font color="#84AC72">#</font><font color="#878798">#</font><font color="#4F4F8C">#</font><font color="#191958">#</font><font color="#515B4E">#</font><font color="#CCCCCC">#</font><font color="#BDBDBD">##</font><font color="#2A2A75">#</font><font color="#191958">#</font><font color="#333366">#</font><font color="#849680">#</font><font color="#738069">#</font><font color="#898A89">#</font><font color="#434385">#</font><font color="#191958">#</font><font color="#414E51">#</font><font color="#7D8D78">#</font><font color="#6A7F60">#</font><font color="#B4B4B4">#</font><font color="#666699">#</font><font color="#191958">#</font><font color="#02024B">#</font><font color="#D6D6D6">#</font><font color="#CCCCCC">##</font><font color="#4D4D94">#</font><font color="#5A5A95">#</font><font color="#4F4F8C">#</font><font color="#434385">#</font><font color="#191967">#</font><font color="#02024B">#</font><font color="#535A67">#</font><font color="#4B5837">#</font><font color="#636754">##</font><font color="#5F6385">#</font><font color="#5A5A95">#</font><font color="#212168">#</font><font color="#191967">#</font><font color="#30307B">#</font><font color="#2A2A6C">#</font><font color="#212168">##</font><font color="#09093D">##</font><font color="#738069">#</font><font color="#73828C">#</font><font color="#4F4F8C">#</font><font color="#191958">#</font><font color="#9596A3">#</font><font color="#CCCCCC">##</font><font color="#C5C5C5">#</font><font color="#BDBDBD">#</font><font color="#A4A4A4">#</font><font color="#7D8D78">#</font><font color="#6A7F60">#</font><font color="#878798">#</font><font color="#5A5A95">#</font><font color="#212158">#</font><font color="#586259">#</font><font color="#788C6E">#</font><font color="#5D6C48">#</font><font color="#738069">#</font><font color="#697564">#</font><font color="#5C6E6F">#</font><font color="#434385">#</font><font color="#212168">#</font><font color="#4B5342">#</font><font color="#6A7F60">#</font><font color="#73828C">#</font><font color="#4F4F8C">#</font><font color="#191958">#</font><font color="#586259">#</font><font color="#5D6C48">#</font><font color="#697564">###</font><font color="#4F4F8C">#</font><font color="#212168">#</font><font color="#384345">#</font><font color="#646B5C">#</font><font color="#121244">#</font><font color="#080858">#</font><font color="#191958">#</font><font color="#30307B">#</font><font color="#3A3A84">##</font><font color="#30307B">#</font><font color="#333366">#</font><font color="#515B4E">##</font><font color="#415634">#</font><font color="#586259">##</font><font color="#4D6944">#</font><font color="#69735B">#</font><font color="#697564">#<br>
</font><font color="#8BAF6B">#</font><font color="#B2C39D">##</font><font color="#8BAF6B">#</font><font color="#878798">#</font><font color="#434385">#</font><font color="#191958">#</font><font color="#515B4E">#</font><font color="#C5C5C5">#</font><font color="#B4B4B4">#</font><font color="#ADADAD">#</font><font color="#212168">#</font><font color="#101058">#</font><font color="#2B2B57">#</font><font color="#7D8D78">#</font><font color="#6A7F60">#</font><font color="#7C8683">#</font><font color="#434385">#</font><font color="#101058">#</font><font color="#384345">#</font><font color="#738069">#</font><font color="#5D6C48">#</font><font color="#738069">#</font><font color="#5A5A8C">#</font><font color="#191958">#</font><font color="#02024B">#</font><font color="#CCCCCC">#</font><font color="#C5C5C5">#</font><font color="#BDBDBD">#</font><font color="#4D4D94">#</font><font color="#4F4F8C">#</font><font color="#333366">##</font><font color="#101058">#</font><font color="#02024B">#</font><font color="#101058">#</font><font color="#898A89">#</font><font color="#697564">#</font><font color="#586259">#</font><font color="#5B5B83">#</font><font color="#434385">#</font><font color="#191958">#</font><font color="#414E51">#</font><font color="#6A6E85">#</font><font color="#62677A">###</font><font color="#535A67">##</font><font color="#697564">#</font><font color="#6A6E85">#</font><font color="#434385">#</font><font color="#191958">#</font><font color="#8D959E">#</font><font color="#BDBDBD">##</font><font color="#B4B4B4">##</font><font color="#A4A4A4">#</font><font color="#7D8D78">#</font><font color="#6A7F60">#</font><font color="#73828C">#</font><font color="#434385">#</font><font color="#191958">#</font><font color="#586259">#</font><font color="#738069">#</font><font color="#4D6944">#</font><font color="#697564">##</font><font color="#5C6E6F">#</font><font color="#3A3A84">#</font><font color="#121244">#</font><font color="#3C4736">#</font><font color="#697564">#</font><font color="#6A6E85">#</font><font color="#4F4F8C">#</font><font color="#191958">#</font><font color="#515B4E">#</font><font color="#4D6944">#</font><font color="#69735B">###</font><font color="#5A5A95">#</font><font color="#191958">#</font><font color="#1D3030">#</font><font color="#69735B">##</font><font color="#415143">#</font><font color="#313157">#</font><font color="#212168">###</font><font color="#2A2A75">#</font><font color="#212168">#</font><font color="#212158">#</font><font color="#515B4E">#</font><font color="#415634">#</font><font color="#515B4E">#</font><font color="#586259">#</font><font color="#4F6333">#</font><font color="#69735B">##<br>
</font><font color="#8BAF6B">####</font><font color="#6C827E">#</font><font color="#3A3A84">#</font><font color="#101058">#</font><font color="#3C4736">#</font><font color="#BDBDBD">#</font><font color="#ADADAD">##</font><font color="#2A2A75">#</font><font color="#101058">#</font><font color="#2B2B57">#</font><font color="#738069">#</font><font color="#69735B">#</font><font color="#6C7A6C">#</font><font color="#3A3A84">#</font><font color="#101058">#</font><font color="#2B3642">#</font><font color="#5D6C48">###</font><font color="#4A4D7E">#</font><font color="#212158">#</font><font color="#02024B">#</font><font color="#C5C5C5">#</font><font color="#BDBDBD">#</font><font color="#B4B4B4">#</font><font color="#434385">#</font><font color="#3A3A75">#</font><font color="#2B2B57">#</font><font color="#A4A4A4">#</font><font color="#6A6E85">#</font><font color="#02024B">##</font><font color="#434377">#</font><font color="#8B9A93">#</font><font color="#7D8D78">#</font><font color="#535A67">#</font><font color="#3A3A84">#</font><font color="#101058">#</font><font color="#697564">#</font><font color="#BDBDBD">#</font><font color="#ADADAD">#</font><font color="#A4A4A4">#</font><font color="#8D959E">##</font><font color="#A4A4A4">#</font><font color="#5D6C48">#</font><font color="#5B6B64">#</font><font color="#30307B">#</font><font color="#101058">#</font><font color="#62677A">#</font><font color="#B4B4B4">###</font><font color="#9B9BC3">#</font><font color="#7474A3">#</font><font color="#73828C">#</font><font color="#788C6E">#</font><font color="#6A7F60">#</font><font color="#2A2A75">#</font><font color="#191958">#</font><font color="#2B3642">#</font><font color="#556A37">####</font><font color="#5B5B83">#</font><font color="#2A2A6C">#</font><font color="#09093D">#</font><font color="#556A37">##</font><font color="#5C6E6F">#</font><font color="#434385">#</font><font color="#191958">#</font><font color="#2B3642">#</font><font color="#4F6333">###</font><font color="#697D78">#</font><font color="#666699">#</font><font color="#212158">#</font><font color="#3C4736">#</font><font color="#4F6333">#</font><font color="#5D6C48">#</font><font color="#4F6546">#</font><font color="#415634">###</font><font color="#4B4F4A">#</font><font color="#30307B">#</font><font color="#191967">#</font><font color="#02024B">#</font><font color="#3E4E28">##</font><font color="#415634">##</font><font color="#4F6333">##</font><font color="#556A37">#<br>
</font><font color="#8BAF6B">#</font><font color="#B2C39D">##</font><font color="#8BAF6B">#</font><font color="#73828C">#</font><font color="#30307B">#</font><font color="#121244">#</font><font color="#515B4E">#</font><font color="#BDBDBD">#</font><font color="#ADADAD">##</font><font color="#212168">#</font><font color="#121244">#</font><font color="#2B2B57">#</font><font color="#7D8D78">#</font><font color="#69735B">#</font><font color="#787F7A">#</font><font color="#30307B">#</font><font color="#191958">##</font><font color="#69735B">#</font><font color="#556A37">#</font><font color="#617373">#</font><font color="#4A4D7E">#</font><font color="#1E1F4C">#</font><font color="#000033">#</font><font color="#8C998A">#</font><font color="#ADADAD">##</font><font color="#2A2A75">#</font><font color="#212158">#</font><font color="#313157">#</font><font color="#ADADAD">#</font><font color="#A4A4A4">#</font><font color="#212158">#</font><font color="#02024B">#</font><font color="#101058">#</font><font color="#898A89">#</font><font color="#999999">#</font><font color="#9596A3">#</font><font color="#2A2A75">#</font><font color="#191958">#</font><font color="#313157">#</font><font color="#B4B4B4">#</font><font color="#A4A4A4">#</font><font color="#9596A3">#</font><font color="#4F4F8C">#</font><font color="#191958">#</font><font color="#434377">#</font><font color="#697564">##</font><font color="#212168">#</font><font color="#101058">#</font><font color="#191958">#</font><font color="#A4A4A4">##</font><font color="#ADADAD">#</font><font color="#666699">#</font><font color="#4A4D7E">#</font><font color="#353974">#</font><font color="#797F5B">#</font><font color="#7D8D78">#</font><font color="#2A2A75">#</font><font color="#191967">#</font><font color="#191958">#</font><font color="#646B5C">#</font><font color="#556A37">#</font><font color="#69735B">#</font><font color="#787F7A">#</font><font color="#5A5A8C">#</font><font color="#1E1F4C">#</font><font color="#2B3642">#</font><font color="#556A37">#</font><font color="#69735B">#</font><font color="#6A6E85">#</font><font color="#434385">#</font><font color="#191958">#</font><font color="#101058">#</font><font color="#4B5342">#</font><font color="#636754">#</font><font color="#69735B">#</font><font color="#8589A4">#</font><font color="#5A5A8C">#</font><font color="#1E1F4C">#</font><font color="#556A37">#</font><font color="#5A5A8C">#</font><font color="#666699">#</font><font color="#434385">#</font><font color="#646B5C">#</font><font color="#515B4E">#</font><font color="#3E4E28">#</font><font color="#515B4E">#</font><font color="#434377">#</font><font color="#101058">#</font><font color="#09093D">#</font><font color="#4B5342">#</font><font color="#3E4E28">#</font><font color="#515B4E">##</font><font color="#4F6333">#</font><font color="#69735B">##<br>
</font><font color="#90B262">#</font><font color="#B2C39D">##</font><font color="#90B262">#</font><font color="#6A6E85">#</font><font color="#212168">#</font><font color="#09093D">#</font><font color="#515B4E">#</font><font color="#BDBDBD">#</font><font color="#ADADAD">##</font><font color="#191967">#</font><font color="#121244">#</font><font color="#2B2B57">#</font><font color="#849680">#</font><font color="#6A7F60">#</font><font color="#738069">#</font><font color="#30307B">#</font><font color="#191967">#</font><font color="#101058">#</font><font color="#212158">#</font><font color="#333366">#</font><font color="#3A3A75">#</font><font color="#313157">#</font><font color="#09093D">#</font><font color="#000033">#</font><font color="#738069">#</font><font color="#5D6C48">#</font><font color="#999999">#</font><font color="#191967">#</font><font color="#09093D">#</font><font color="#2B2B57">#</font><font color="#ADADAD">#</font><font color="#A4A4A4">#</font><font color="#7C8683">#</font><font color="#080858">##</font><font color="#333366">#</font><font color="#999999">#</font><font color="#ADADAD">#</font><font color="#5A5A8C">#</font><font color="#191967">##</font><font color="#434385">#</font><font color="#687197">#</font><font color="#4F4F8C">#</font><font color="#333366">#</font><font color="#121244">#</font><font color="#999999">#</font><font color="#69735B">#</font><font color="#646B5C">#</font><font color="#414E51">#</font><font color="#101058">#</font><font color="#080858">#</font><font color="#191967">#</font><font color="#5A5A8C">#</font><font color="#4A4D7E">#</font><font color="#333366">#</font><font color="#121244">#</font><font color="#586259">#</font><font color="#787E53">#</font><font color="#7D8D78">#</font><font color="#62736C">#</font><font color="#191967">#</font><font color="#080858">#</font><font color="#191967">#</font><font color="#434377">#</font><font color="#5A5A8C">#</font><font color="#4F4F8C">#</font><font color="#313157">#</font><font color="#162529">#</font><font color="#636754">#</font><font color="#4F6333">#</font><font color="#636754">#</font><font color="#62677A">#</font><font color="#434385">#</font><font color="#191958">#</font><font color="#09093D">#</font><font color="#080858">#</font><font color="#333366">#</font><font color="#5A5A8C">#</font><font color="#666699">#</font><font color="#333366">#</font><font color="#384345">#</font><font color="#4F6333">#</font><font color="#646B5C">#</font><font color="#3A3A84">#</font><font color="#2A2A75">#</font><font color="#434385">#</font><font color="#5B5B83">#</font><font color="#5F6385">#</font><font color="#5A5A8C">#</font><font color="#333366">#</font><font color="#09093D">#</font><font color="#333333">#</font><font color="#4B5342">#</font><font color="#3E4E28">#</font><font color="#4B5342">#</font><font color="#515B4E">#</font><font color="#4B5837">#</font><font color="#646B5C">#</font><font color="#69735B">#<br>
</font><font color="#90B262">####</font><font color="#4B5A5C">#</font><font color="#101058">#</font><font color="#09093D">#</font><font color="#415634">#</font><font color="#BDBDBD">#</font><font color="#B4B4B4">##</font><font color="#101058">#</font><font color="#02024B">#</font><font color="#313157">#</font><font color="#848D6C">#</font><font color="#6A7F60">#</font><font color="#6B7453">#</font><font color="#5D6C48">#</font><font color="#212158">#</font><font color="#101058">##</font><font color="#1E1F4C">#</font><font color="#415634">#</font><font color="#162529">#</font><font color="#000033">##</font><font color="#556A37">###</font><font color="#080858">#</font><font color="#09093D">#</font><font color="#2B2B57">#</font><font color="#ADADAD">#</font><font color="#A4A4A4">#</font><font color="#999999">#</font><font color="#535A67">#</font><font color="#02024B">#</font><font color="#191958">#</font><font color="#878798">#</font><font color="#ADADAD">##</font><font color="#5B5B83">#</font><font color="#101058">#</font><font color="#2A2A75">#</font><font color="#3A3A75">#</font><font color="#212158">#</font><font color="#313157">#</font><font color="#787F7A">#</font><font color="#A4A4A4">#</font><font color="#5D6C48">##</font><font color="#4B5837">#</font><font color="#535A67">#</font><font color="#212168">#</font><font color="#191967">#</font><font color="#2A2A6C">#</font><font color="#212158">#</font><font color="#121244">#</font><font color="#6A746F">#</font><font color="#697E4C">##</font><font color="#687C3F">#</font><font color="#556A37">#</font><font color="#415634">#</font><font color="#1E1F4C">#</font><font color="#212168">#</font><font color="#3A3A84">##</font><font color="#212158">#</font><font color="#192929">#</font><font color="#3E4E28">####</font><font color="#535A67">#</font><font color="#434385">#</font><font color="#191958">#</font><font color="#2F3323">#</font><font color="#121244">#</font><font color="#191958">#</font><font color="#2B2B57">#</font><font color="#1E1F4C">#</font><font color="#1D3030">#</font><font color="#3E4E28">###</font><font color="#3C4736">#</font><font color="#212158">#</font><font color="#30307B">#</font><font color="#4F4F8C">##</font><font color="#2A2A6C">#</font><font color="#121244">#</font><font color="#192929">#</font><font color="#3E451F">##</font><font color="#3E4E28">###</font><font color="#485828">#</font><font color="#4F6333">#</font><font color="#556A37">#<br>
</font><font color="#90B262">#</font><font color="#B2C39D">##</font><font color="#90B262">#</font><font color="#99A781">#</font><font color="#788C6E">#</font><font color="#5B6E34">#</font><font color="#69735B">#</font><font color="#BDBDBD">#</font><font color="#B4B4B4">##</font><font color="#BDBDBD">#</font><font color="#C5C5C5">##</font><font color="#919981">#</font><font color="#797F5B">#</font><font color="#7B8567">#</font><font color="#738069">#</font><font color="#556A37">#</font><font color="#586259">#</font><font color="#515B4E">#</font><font color="#4F6333">#</font><font color="#646B5C">##</font><font color="#4F6333">#</font><font color="#69735B">##</font><font color="#556A37">#</font><font color="#69735B">##</font><font color="#5D6C48">#</font><font color="#999999">#</font><font color="#B4B4B4">#</font><font color="#A4A4A4">##</font><font color="#999999">###</font><font color="#A4A4A4">#</font><font color="#ADADAD">#</font><font color="#B4B4B4">###</font><font color="#9596A3">#</font><font color="#898A89">##</font><font color="#A4A4A4">###</font><font color="#697564">##</font><font color="#4F6333">#</font><font color="#7D8D78">#</font><font color="#B4B4B4">#</font><font color="#A4A4A4">#</font><font color="#8D959E">##</font><font color="#B4B4B4">#</font><font color="#A4A4A4">#</font><font color="#738069">#</font><font color="#5F7334">#</font><font color="#6A7F60">#</font><font color="#646B5C">#</font><font color="#485828">#</font><font color="#575C44">##</font><font color="#3C4736">###</font><font color="#3E4E28">#</font><font color="#4B5342">##</font><font color="#3E4E28">#</font><font color="#4B5342">#</font><font color="#535A67">#</font><font color="#3A3A84">#</font><font color="#101058">#</font><font color="#333333">#</font><font color="#3E451F">#</font><font color="#415143">#</font><font color="#333333">#</font><font color="#3E451F">#</font><font color="#4B5342">##</font><font color="#3E4E28">#</font><font color="#4B5342">##</font><font color="#3E451F">#</font><font color="#4B5342">#</font><font color="#4B4F4A">#</font><font color="#3C3F29">#</font><font color="#3C4736">#</font><font color="#4B5342">#</font><font color="#3E4E28">#</font><font color="#4B5342">##</font><font color="#3E4E28">#</font><font color="#4B5342">#</font><font color="#575C44">#</font><font color="#485828">#</font><font color="#636754">#</font><font color="#69735B">#<br>
</font><font color="#94B257">#</font><font color="#B2C39D">##</font><font color="#94B257">#</font><font color="#99A781">#</font><font color="#848D6C">#</font><font color="#5B6E34">#</font><font color="#69735B">#</font><font color="#C5C5C5">#</font><font color="#BDBDBD">##</font><font color="#C5C5C5">###</font><font color="#8C998A">#</font><font color="#797F5B">#</font><font color="#7D8D78">#</font><font color="#738069">#</font><font color="#5B6E34">#</font><font color="#69735B">##</font><font color="#556A37">#</font><font color="#69735B">#</font><font color="#636754">#</font><font color="#4F6333">#</font><font color="#636754">##</font><font color="#4F6333">#</font><font color="#69735B">##</font><font color="#5F7334">#</font><font color="#738069">#</font><font color="#849680">#</font><font color="#A4A4A4">#</font><font color="#ADADAD">#</font><font color="#A4A4A4">##</font><font color="#ADADAD">##</font><font color="#B4B4B4">#</font><font color="#BDBDBD">###</font><font color="#B4B4B4">#</font><font color="#ADADAD">#</font><font color="#A4A4A4">####</font><font color="#697564">##</font><font color="#556A37">#</font><font color="#898A89">#</font><font color="#BDBDBD">##</font><font color="#B4B4B4">###</font><font color="#A4A4A4">#</font><font color="#7D8D78">#</font><font color="#787E53">#</font><font color="#7B8567">##</font><font color="#6B7453">#</font><font color="#697564">##</font><font color="#5E6343">#</font><font color="#646B5C">##</font><font color="#5E6343">#</font><font color="#646B5C">##</font><font color="#5E6343">#</font><font color="#646B5C">#</font><font color="#62677A">#</font><font color="#30307B">#</font><font color="#121244">#</font><font color="#4B4F4A">#</font><font color="#575C44">####</font><font color="#636754">##</font><font color="#5E6343">#</font><font color="#636754">##</font><font color="#575C44">#</font><font color="#636754">##</font><font color="#575C44">#</font><font color="#636754">##</font><font color="#4B5837">#</font><font color="#4B5342">##</font><font color="#3E4E28">#</font><font color="#4B5342">#</font><font color="#575C44">#</font><font color="#485828">#</font><font color="#636754">#</font><font color="#69735B">#<br>
</font><font color="#94B257">####</font><font color="#7B9842">#</font><font color="#687C3F">#</font><font color="#5B6E34">##</font><font color="#CCCCCC">#</font><font color="#C5C5C5">##</font><font color="#CCCCCC">###</font><font color="#8B946C">#</font><font color="#818960">#</font><font color="#797F5B">#</font><font color="#697E4C">#</font><font color="#5F7334">###</font><font color="#5B6E34">##</font><font color="#4F6333">######</font><font color="#5B6E34">#</font><font color="#5F7334">#</font><font color="#687C3F">###</font><font color="#919981">#</font><font color="#BDBDBD">#####</font><font color="#C5C5C5">###</font><font color="#BDBDBD">##</font><font color="#B4B4B4">#</font><font color="#ADADAD">###</font><font color="#666D48">##</font><font color="#556A37">#</font><font color="#8B946C">#</font><font color="#CCCCCC">##</font><font color="#C5C5C5">#</font><font color="#BDBDBD">#</font><font color="#B4B4B4">###</font><font color="#BDBDBD">##</font><font color="#C5C5C5">#</font><font color="#CCCCCC">###</font><font color="#C5C5C5">#</font><font color="#BDBDBD">##</font><font color="#B4B4B4">####</font><font color="#BDBDBD">#</font><font color="#7C7E9D">#</font><font color="#212168">#</font><font color="#09093D">#</font><font color="#898A89">#</font><font color="#ADADAD">#</font><font color="#A4A4A4">####</font><font color="#ADADAD">#</font><font color="#B4B4B4">###</font><font color="#BDBDBD">#####</font><font color="#B4B4B4">#</font><font color="#7B8567">#</font><font color="#4B5837">##</font><font color="#485828">####</font><font color="#58682A">#</font><font color="#5B6E34">#<br>
</font><font color="#94B257">#</font><font color="#B5BE95">##</font><font color="#92AF4D">#</font><font color="#99A781">#</font><font color="#848D6C">#</font><font color="#5F7334">#</font><font color="#797F5B">#</font><font color="#D6D6D6">######</font><font color="#9EAE9E">#</font><font color="#8C9562">#</font><font color="#919981">#</font><font color="#848D6C">#</font><font color="#6A7F33">#</font><font color="#7B8567">##</font><font color="#5F7334">#</font><font color="#6A7F60">#</font><font color="#69735B">#</font><font color="#58682A">#</font><font color="#6B7453">##</font><font color="#5B6E34">#</font><font color="#69735B">#</font><font color="#797F5B">#</font><font color="#687C3F">#</font><font color="#7B8567">##</font><font color="#687C3F">#</font><font color="#7B8567">#</font><font color="#919981">#</font><font color="#BDBDBD">#</font><font color="#CCCCCC">########</font><font color="#C5C5C5">#</font><font color="#BDBDBD">###</font><font color="#7B8567">##</font><font color="#666D48">#</font><font color="#94A797">#</font><font color="#DEDEDE">##</font><font color="#D6D6D6">#</font><font color="#CCCCCC">#</font><font color="#C5C5C5">#</font><font color="#BDBDBD">###</font><font color="#C5C5C5">#</font><font color="#CCCCCC">#</font><font color="#D6D6D6">####</font><font color="#CCCCCC">#</font><font color="#C5C5C5">#</font><font color="#BDBDBD">####</font><font color="#C5C5C5">#</font><font color="#7474A3">#</font><font color="#080858">#</font><font color="#000033">#</font><font color="#8D959E">#</font><font color="#B4B4B4">#</font><font color="#A4A4A4">####</font><font color="#ADADAD">#</font><font color="#BDBDBD">##</font><font color="#C5C5C5">#</font><font color="#CCCCCC">####</font><font color="#C5C5C5">##</font><font color="#848D6C">#</font><font color="#69735B">#</font><font color="#646B5C">#</font><font color="#4F6333">#</font><font color="#575C44">#</font><font color="#5D6C48">#</font><font color="#4F6333">#</font><font color="#6B7453">##<br>
</font><font color="#92AF4D">#</font><font color="#B5BE95">##</font><font color="#92AF4D">#</font><font color="#99A781">#</font><font color="#848D6C">#</font><font color="#5F7334">#</font><font color="#797F5B">#</font><font color="#E6E6E6">######</font><font color="#B1B7A1">#</font><font color="#959C6F">#</font><font color="#99A781">#</font><font color="#8B946C">#</font><font color="#6A7F33">#</font><font color="#848D6C">##</font><font color="#6A7F33">#</font><font color="#797F5B">##</font><font color="#5F7334">#</font><font color="#797F5B">##</font><font color="#5F7334">#</font><font color="#797F5B">#</font><font color="#7B8567">#</font><font color="#6A7F33">#</font><font color="#7B8567">#</font><font color="#848D6C">#</font><font color="#687C3F">#</font><font color="#848D6C">##</font><font color="#7D8353">#</font><font color="#B4B4B4">#</font><font color="#DEDEDE">#######</font><font color="#D6D6D6">##</font><font color="#CCCCCC">##</font><font color="#919981">##</font><font color="#697E4C">#</font><font color="#9EAE9E">#</font><font color="#E6E6E6">###</font><font color="#D6DCDC">#</font><font color="#D6D6D6">#</font><font color="#CCCCCC">###</font><font color="#D6D6D6">#</font><font color="#D6DCDC">#</font><font color="#E6E6E6">####</font><font color="#DEDEDE">#</font><font color="#D6D6D6">#</font><font color="#CCCCCC">####</font><font color="#D6D6D6">#</font><font color="#DEDEDE">##</font><font color="#D6D6D6">#</font><font color="#CCCCCC">#</font><font color="#BDBDBD">#</font><font color="#ADADAD">###</font><font color="#B4B4B4">#</font><font color="#BDBDBD">#</font><font color="#CCCCCC">##</font><font color="#D6D6D6">#</font><font color="#D6DCDC">#</font><font color="#DEDEDE">###</font><font color="#D6D6D6">##</font><font color="#919981">#</font><font color="#7B8567">##</font><font color="#5B6E34">#</font><font color="#5D6C48">##</font><font color="#58682A">#</font><font color="#6B7453">##<br>
</font><font color="#92AF4D">####</font><font color="#829B41">#</font><font color="#728230">#</font><font color="#6A7F33">##</font><font color="#EFEFEF">######</font><font color="#ACB786">#</font><font color="#A0A970">#</font><font color="#95A363">#</font><font color="#7B9842">#</font><font color="#728230">##</font><font color="#6A7F33">##############</font><font color="#79853F">#</font><font color="#788B3E">###</font><font color="#95A363">#</font><font color="#D6D6D6">#</font><font color="#EFEFEF">####</font><font color="#E6E6E6">###</font><font color="#DEDEDE">##</font><font color="#959C6F">##</font><font color="#7D8353">#</font><font color="#A4AC87">#</font><font color="#EFEFEF">####</font><font color="#E6E6E6">#</font><font color="#DEDEDE">####</font><font color="#E6E6E6">#</font><font color="#EFEFEF">#####</font><font color="#E6E6E6">#</font><font color="#DEDEDE">###</font><font color="#E6E6E6">####</font><font color="#DEDEDE">#</font><font color="#D6D6D6">#</font><font color="#C5C5C5">#</font><font color="#B4B4B4">###</font><font color="#C5C5C5">#</font><font color="#CCCCCC">#</font><font color="#D6D6D6">#</font><font color="#E6E6E6">###</font><font color="#EFEFEF">##</font><font color="#E6E6E6">##</font><font color="#DEDEDE">#</font><font color="#A4AC87">#</font><font color="#818960">#</font><font color="#7D8353">#</font><font color="#687C3F">#</font><font color="#58682A">####</font><font color="#5F7334">#<br>
</font><font color="#92AF4D">#</font><font color="#ACB786">##</font><font color="#93AB3D">#</font><font color="#99A781">#</font><font color="#959C6F">#</font><font color="#728230">#</font><font color="#8B946C">#</font><font color="#F7F7F7">######</font><font color="#B3C3B8">#</font><font color="#A4AC87">##</font><font color="#919981">#</font><font color="#728230">#</font><font color="#848D6C">##</font><font color="#728230">#</font><font color="#818960">##</font><font color="#6A7F33">#</font><font color="#818960">##</font><font color="#6A7F33">#</font><font color="#818960">##</font><font color="#728230">#</font><font color="#848D6C">##</font><font color="#728230">#</font><font color="#848D6C">#</font><font color="#8B946C">#</font><font color="#788B3E">#</font><font color="#8B946C">##</font><font color="#788B3E">#</font><font color="#BDBDBD">#</font><font color="#F7F7F7">####</font><font color="#EFEFEF">###</font><font color="#E2E5DA">#</font><font color="#B1B7A1">##</font><font color="#899458">#</font><font color="#B1B7A1">#</font><font color="#F7F7F7">####</font><font color="#EFEFEF">#####</font><font color="#F7F7F7">######</font><font color="#EFEFEF">########</font><font color="#E6E6E6">#</font><font color="#D6D6D6">#</font><font color="#CCCCCC">#</font><font color="#C5C5C5">###</font><font color="#D6D6D6">#</font><font color="#DEDEDE">#</font><font color="#E6E6E6">#</font><font color="#EFEFEF">##</font><font color="#F7F7F7">####</font><font color="#EFEFEF">##</font><font color="#B1B7A1">#</font><font color="#99A781">#</font><font color="#919981">#</font><font color="#687C3F">#</font><font color="#6B7453">##</font><font color="#58682A">#</font><font color="#6B7453">#</font><font color="#797F5B">#<br>
</font><font color="#93AB3D">#</font><font color="#ACB786">##</font><font color="#93AB3D">#</font><font color="#A4AC87">#</font><font color="#959C6F">#</font><font color="#788B3E">#</font><font color="#959C6F">#</font><font color="#E2E5DA">####</font><font color="#9EAE9E">#</font><font color="#000000">#####</font><font color="#3E451F">#</font><font color="#848D6C">##</font><font color="#728230">#</font><font color="#848D6C">##</font><font color="#728230">#</font><font color="#848D6C">#</font><font color="#666D48">#</font><font color="#000000">#</font><font color="#666D48">#</font><font color="#848D6C">#</font><font color="#728230">#</font><font color="#848D6C">##</font><font color="#728230">#</font><font color="#848D6C">##</font><font color="#728230">#</font><font color="#8B946C">##</font><font color="#788B3E">#</font><font color="#959C6F">#</font><font color="#A4AC87">#</font><font color="#E2E5DA">#</font><font color="#FFFFFF">####</font><font color="#E6E6E6">#</font><font color="#B5BE95">##</font><font color="#B1B7A1">#</font><font color="#95A363">#</font><font color="#99A781">#</font><font color="#E2E5DA">#</font><font color="#FFFFFF">###</font><font color="#F7F7F7">#####</font><font color="#FFFFFF">######</font><font color="#F7F7F7">########</font><font color="#EFEFEF">#</font><font color="#E6E6E6">#</font><font color="#D6D6D6">####</font><font color="#787F7A">#</font><font color="#EFEFEF">##</font><font color="#F7F7F7">#</font><font color="#FFFFFF">######</font><font color="#F7F7F7">#</font><font color="#B2C39D">#</font><font color="#9EAE9E">#</font><font color="#919981">#</font><font color="#79853F">#</font><font color="#6B7453">##</font><font color="#647223">#</font><font color="#747B51">##<br>
</font><font color="#93AB3D">#####</font><font color="#829B41">####</font><font color="#95A363">##</font><font color="#A0A970">#</font><font color="#797F5B">#</font><font color="#000000">#</font><font color="#5E6343">#</font><font color="#787E53">#</font><font color="#687C3F">#</font><font color="#58682A">#</font><font color="#647223">#</font><font color="#728230">#######</font><font color="#57611B">#</font><font color="#000000">#</font><font color="#57611B">#</font><font color="#728230">#########</font><font color="#788B3E">####</font><font color="#899458">##</font><font color="#8D9C59">#</font><font color="#95A363">#</font><font color="#A0A970">#</font><font color="#ACB786">###</font><font color="#95A363">#</font><font color="#8D9C59">#</font><font color="#899458">####</font><font color="#8D9C59">#</font><font color="#95A363">###################</font><font color="#8D9C59">#</font><font color="#899458">####</font><font color="#4B5837">#</font><font color="#000000">#</font><font color="#8D9C59">#</font><font color="#95A363">#######</font><font color="#A0A970">#</font><font color="#A4AC87">##</font><font color="#99A781">#</font><font color="#899458">#</font><font color="#6A7F33">#</font><font color="#647223">#####<br>
</font><font color="#93AB3D">#</font><font color="#ACB786">##</font><font color="#93AB3D">#</font><font color="#A0A970">##</font><font color="#8A9B2A">#</font><font color="#959C6F">#</font><font color="#99A781">#</font><font color="#8D9C59">#</font><font color="#A4AC87">##</font><font color="#747B51">#</font><font color="#000000">#</font><font color="#738069">#</font><font color="#899458">#</font><font color="#848D6C">#</font><font color="#818960">#</font><font color="#728227">#</font><font color="#818960">#</font><font color="#1E201A">#</font><font color="#3E451F">#</font><font color="#0F1108">#</font><font color="#000000">#</font><font color="#303813">#</font><font color="#818960">#</font><font color="#5E6343">#</font><font color="#000000">#</font><font color="#2F3323">#</font><font color="#070806">##</font><font color="#4F553B">#</font><font color="#818960">#</font><font color="#58682A">#</font><font color="#0F1108">#</font><font color="#000000">#</font><font color="#0F1108">#</font><font color="#575C44">#</font><font color="#818960">#</font><font color="#58682A">#</font><font color="#1E201A">#</font><font color="#575C44">#</font><font color="#070806">##</font><font color="#636754">#</font><font color="#A0A970">#</font><font color="#919981">#</font><font color="#2F3323">#</font><font color="#000000">#</font><font color="#101212">#</font><font color="#797F5B">#</font><font color="#7B9842">#</font><font color="#8B946C">#</font><font color="#26291A">#</font><font color="#000000">#</font><font color="#101212">#</font><font color="#848D6C">#</font><font color="#95A363">#</font><font color="#646B5C">#</font><font color="#3C4736">#</font><font color="#3C3F29">#</font><font color="#000000">#</font><font color="#1E201A">#</font><font color="#747B51">#</font><font color="#101212">#</font><font color="#000000">#</font><font color="#5E6343">#</font><font color="#A4AC87">#</font><font color="#99A781">#</font><font color="#26291A">#</font><font color="#000000">#</font><font color="#101212">#</font><font color="#7D8353">#</font><font color="#A4AC87">#</font><font color="#646B5C">#</font><font color="#3C4736">##</font><font color="#000000">#</font><font color="#0F1108">#</font><font color="#7B8567">##</font><font color="#0F1108">#</font><font color="#000000">#</font><font color="#26291A">#</font><font color="#7D8353">#</font><font color="#101212">#</font><font color="#000000">#</font><font color="#070806">#</font><font color="#646B5C">#</font><font color="#A4AC87">#</font><font color="#A0A970">#</font><font color="#A4AC87">#</font><font color="#B1B7A1">#</font><font color="#99A781">##</font><font color="#848D6C">#</font><font color="#647223">#</font><font color="#6B7453">##</font><font color="#647223">#</font><font color="#747B51">##<br>
</font><font color="#93AB3D">#</font><font color="#A0A970">##</font><font color="#92A42D">#</font><font color="#A0A970">##</font><font color="#8A9B2A">#</font><font color="#959C6F">##</font><font color="#829B41">#</font><font color="#959C6F">##</font><font color="#5F7334">#</font><font color="#000000">#####</font><font color="#515B19">#</font><font color="#797F5B">#</font><font color="#000000">#</font><font color="#0F1108">#</font><font color="#575C44">#</font><font color="#2F3323">#</font><font color="#000000">#</font><font color="#666D48">#</font><font color="#5E6343">#</font><font color="#000000">#</font><font color="#1E201A">#</font><font color="#5E6343">#</font><font color="#0F1108">#</font><font color="#070806">#</font><font color="#797F5B">#</font><font color="#303813">#</font><font color="#1E201A">#</font><font color="#5E6343">#</font><font color="#0F1108">#</font><font color="#1E201A">#</font><font color="#797F5B">#</font><font color="#515B19">#</font><font color="#000000">#</font><font color="#1E201A">#</font><font color="#58682A">#</font><font color="#1E201A">#</font><font color="#070806">#</font><font color="#8D9C59">#</font><font color="#2F3323">#</font><font color="#101212">#</font><font color="#5F7334">#</font><font color="#1C1F0B">#</font><font color="#0F1108">#</font><font color="#728230">#</font><font color="#26291A">#</font><font color="#101212">#</font><font color="#5B6E34">#</font><font color="#3C3F29">#</font><font color="#070806">#</font><font color="#8D9C59">#</font><font color="#4B5342">#</font><font color="#000000">#</font><font color="#3C3F29">#</font><font color="#636754">#</font><font color="#000000">#</font><font color="#0F1108">#</font><font color="#69735B">#</font><font color="#26291A">#</font><font color="#070806">#</font><font color="#99A781">#</font><font color="#2F3323">#</font><font color="#0F1108">#</font><font color="#738069">#</font><font color="#3C3F29">#</font><font color="#070806">#</font><font color="#99A781">#</font><font color="#4B5342">#</font><font color="#000000">#</font><font color="#3C4736">#</font><font color="#69735B">#</font><font color="#070806">#</font><font color="#2F3323">#</font><font color="#848D6C">#</font><font color="#26291A">#</font><font color="#000000">#</font><font color="#4B5342">#</font><font color="#26291A">#</font><font color="#101212">#</font><font color="#738069">#</font><font color="#3C3F29">#</font><font color="#4B5342">#</font><font color="#99A781">#</font><font color="#95A363">#</font><font color="#99A781">##</font><font color="#899458">#</font><font color="#8B946C">#</font><font color="#797F5B">#</font><font color="#647223">#</font><font color="#747B51">##</font><font color="#647223">#</font><font color="#747B51">##<br>
</font><font color="#92A42D">###</font><font color="#8A9B2A">####</font><font color="#7C8A23">##</font><font color="#728227">###</font><font color="#57611B">#</font><font color="#000000">#</font><font color="#3E451F">#</font><font color="#515B19">###</font><font color="#647223">#</font><font color="#6C7921">#</font><font color="#000000">#</font><font color="#363C0F">#</font><font color="#6C7921">#</font><font color="#515B19">#</font><font color="#000000">#</font><font color="#515B19">##</font><font color="#000000">#</font><font color="#515B19">#</font><font color="#6C7921">#</font><font color="#363C0F">#</font><font color="#000000">#</font><font color="#6C7921">##</font><font color="#515B19">#</font><font color="#363C0F">#</font><font color="#070806">#</font><font color="#1C1F0B">#</font><font color="#6C7921">#</font><font color="#515B19">#</font><font color="#000000">#</font><font color="#515B19">#</font><font color="#728230">#</font><font color="#3E451F">#</font><font color="#000000">#</font><font color="#788B3E">#</font><font color="#000000">#</font><font color="#3E451F">#</font><font color="#728227">#</font><font color="#647223">##</font><font color="#6C7921">#</font><font color="#000000">#</font><font color="#1C1F0B">#</font><font color="#3E451F">#</font><font color="#303813">#</font><font color="#000000">#</font><font color="#58682A">#</font><font color="#3E451F">#</font><font color="#000000">#</font><font color="#788B3E">##</font><font color="#000000">#</font><font color="#3E451F">#</font><font color="#788B3E">#</font><font color="#3E451F">#</font><font color="#000000">#</font><font color="#788B3E">#</font><font color="#000000">#</font><font color="#1C1F0B">#</font><font color="#3E451F">#</font><font color="#303813">#</font><font color="#000000">#</font><font color="#5B6E34">#</font><font color="#3E451F">#</font><font color="#000000">#</font><font color="#788B3E">##</font><font color="#1C1F0B">##</font><font color="#788B3E">#</font><font color="#3E451F">#</font><font color="#000000">#</font><font color="#788B3E">#</font><font color="#3E451F">#</font><font color="#000000">#</font><font color="#0F1108">#</font><font color="#303813">#</font><font color="#58682A">#</font><font color="#788B3E">#</font><font color="#79853F">###</font><font color="#728230">#</font><font color="#647223">#######</font><font color="#6C7921">#<br>
</font><font color="#92A42D">#</font><font color="#A0A970">##</font><font color="#8A9B2A">#</font><font color="#959C6F">##</font><font color="#7C8A23">#</font><font color="#8C9562">##</font><font color="#728227">#</font><font color="#818960">##</font><font color="#515B19">#</font><font color="#000000">#</font><font color="#5E6343">#</font><font color="#6C7921">#</font><font color="#787E53">##</font><font color="#6C7921">#</font><font color="#787E53">#</font><font color="#000000">#</font><font color="#363C0F">#</font><font color="#787E53">#</font><font color="#575C44">#</font><font color="#000000">#</font><font color="#575C44">##</font><font color="#000000">#</font><font color="#575C44">#</font><font color="#787E53">#</font><font color="#363C0F">#</font><font color="#000000">#</font><font color="#787E53">#</font><font color="#1C1F0B">##</font><font color="#3C4736">#</font><font color="#0F1108">#</font><font color="#1E201A">#</font><font color="#787E53">#</font><font color="#515B19">#</font><font color="#000000">#</font><font color="#575C44">#</font><font color="#6C7921">#</font><font color="#3C3F29">#</font><font color="#000000">#</font><font color="#6C7921">#</font><font color="#000000">#</font><font color="#3C3F29">#</font><font color="#6C7921">#</font><font color="#666D48">#</font><font color="#747B51">#</font><font color="#6C7921">#</font><font color="#000000">#</font><font color="#1E201A">#</font><font color="#363C0F">#</font><font color="#3C3F29">##</font><font color="#647223">#</font><font color="#3C3F29">#</font><font color="#000000">#</font><font color="#6C7921">#</font><font color="#787E53">#</font><font color="#000000">#</font><font color="#363C0F">#</font><font color="#787E53">#</font><font color="#3C3F29">#</font><font color="#000000">#</font><font color="#787E53">#</font><font color="#000000">#</font><font color="#1C1F0B">#</font><font color="#3C3F29">##</font><font color="#363C0F">#</font><font color="#666D48">#</font><font color="#3C3F29">#</font><font color="#000000">#</font><font color="#787E53">##</font><font color="#1C1F0B">##</font><font color="#787E53">#</font><font color="#363C0F">#</font><font color="#000000">#</font><font color="#787E53">#</font><font color="#6C7921">#</font><font color="#4F553B">#</font><font color="#2F3323">#</font><font color="#0F1108">#</font><font color="#000000">#</font><font color="#666D48">#</font><font color="#687420">#</font><font color="#747B51">##</font><font color="#647223">#</font><font color="#747B51">##</font><font color="#647223">#</font><font color="#747B51">##</font><font color="#687420">#</font><font color="#787E53">#</font><font color="#7D8353">#<br>
</font><font color="#92A42D">#</font><font color="#A0A970">##</font><font color="#8A9B2A">#</font><font color="#999966">##</font><font color="#7C8A23">#</font><font color="#8C9562">##</font><font color="#728227">#</font><font color="#818960">##</font><font color="#515B19">#</font><font color="#000000">#</font><font color="#3C4736">#</font><font color="#515B19">#</font><font color="#575C44">##</font><font color="#57611B">#</font><font color="#787E53">#</font><font color="#000000">#</font><font color="#363C0F">#</font><font color="#787E53">#</font><font color="#575C44">#</font><font color="#000000">#</font><font color="#575C44">##</font><font color="#000000">#</font><font color="#575C44">#</font><font color="#787E53">#</font><font color="#363C0F">#</font><font color="#000000">#</font><font color="#787E53">#</font><font color="#000000">#</font><font color="#26291A">#</font><font color="#4F553B">#</font><font color="#070806">#</font><font color="#1E201A">#</font><font color="#787E53">#</font><font color="#515B19">#</font><font color="#000000">#</font><font color="#575C44">#</font><font color="#6C7921">#</font><font color="#3C3F29">#</font><font color="#000000">#</font><font color="#6C7921">#</font><font color="#26291A">#</font><font color="#0F1108">#</font><font color="#515B19">#</font><font color="#101212">#</font><font color="#0F1108">#</font><font color="#6C7921">#</font><font color="#26291A">#</font><font color="#0F1108">#</font><font color="#515B19">#</font><font color="#3C4736">#</font><font color="#2F3323">#</font><font color="#647223">#</font><font color="#3C3F29">#</font><font color="#000000">#</font><font color="#6C7921">#</font><font color="#787E53">#</font><font color="#000000">#</font><font color="#363C0F">#</font><font color="#787E53">#</font><font color="#3C3F29">#</font><font color="#000000">#</font><font color="#787E53">#</font><font color="#26291A">#</font><font color="#0F1108">#</font><font color="#4F553B">#</font><font color="#3C4736">#</font><font color="#26291A">#</font><font color="#747B51">#</font><font color="#3C3F29">#</font><font color="#000000">#</font><font color="#787E53">##</font><font color="#1C1F0B">##</font><font color="#787E53">#</font><font color="#363C0F">#</font><font color="#000000">#</font><font color="#4F553B">#</font><font color="#1C1F0B">##</font><font color="#575C44">#</font><font color="#363C0F">#</font><font color="#000000">#</font><font color="#5E6343">#</font><font color="#687420">#</font><font color="#747B51">##</font><font color="#687420">#</font><font color="#747B51">##</font><font color="#687420">#</font><font color="#747B51">##</font><font color="#6C7921">#</font><font color="#7D8353">##<br>
</font><font color="#92A42D">##</font><font color="#8A9B2A">###</font><font color="#7C8A23">####</font><font color="#728227">###</font><font color="#515B19">#</font><font color="#000000">#####</font><font color="#1C1F0B">#</font><font color="#6C7921">#</font><font color="#000000">#</font><font color="#363C0F">#</font><font color="#6C7921">#</font><font color="#515B19">#</font><font color="#000000">#</font><font color="#515B19">##</font><font color="#000000">#</font><font color="#515B19">#</font><font color="#6C7921">#</font><font color="#363C0F">#</font><font color="#000000">#</font><font color="#6C7921">#</font><font color="#363C0F">#</font><font color="#000000">#</font><font color="#0F1108">#</font><font color="#303813">#</font><font color="#070806">#</font><font color="#687420">#</font><font color="#515B19">#</font><font color="#000000">#</font><font color="#515B19">#</font><font color="#6C7921">#</font><font color="#363C0F">#</font><font color="#000000">#</font><font color="#6C7921">#</font><font color="#57611B">#</font><font color="#1C1F0B">#</font><font color="#000000">#</font><font color="#0F1108">#</font><font color="#57611B">#</font><font color="#6C7921">#</font><font color="#687420">#</font><font color="#1C1F0B">#</font><font color="#000000">#</font><font color="#070806">#</font><font color="#363C0F">#</font><font color="#6C7921">#</font><font color="#363C0F">#</font><font color="#000000">#</font><font color="#6C7921">##</font><font color="#000000">#</font><font color="#363C0F">#</font><font color="#6C7921">#</font><font color="#363C0F">#</font><font color="#000000">#</font><font color="#6C7921">#</font><font color="#687420">#</font><font color="#1C1F0B">#</font><font color="#000000">#</font><font color="#070806">#</font><font color="#363C0F">#</font><font color="#6C7921">#</font><font color="#363C0F">#</font><font color="#000000">#</font><font color="#6C7921">##</font><font color="#1C1F0B">##</font><font color="#6C7921">#</font><font color="#515B19">#</font><font color="#070806">##</font><font color="#57611B">#</font><font color="#0F1108">#</font><font color="#000000">#</font><font color="#070806">#</font><font color="#363C0F">#</font><font color="#6C7921">##</font><font color="#687420">#####</font><font color="#6C7921">#####</font><font color="#728227">#<br>
</font><font color="#92A42D">#</font><font color="#A0A970">##</font><font color="#8A9B2A">#</font><font color="#999966">##</font><font color="#7C8A23">#</font><font color="#899458">##</font><font color="#7C8A23">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#6C7921">#</font><font color="#787E53">##</font><font color="#6C7921">#</font><font color="#787E53">##</font><font color="#6C7921">#</font><font color="#787E53">##</font><font color="#6C7921">#</font><font color="#7D8353">##</font><font color="#728227">#</font><font color="#818960">##<br>
</font>
</span>
<BR>

<style type="text/css">.asciiimage{
        color           : #000000;
        background-color: #FFFFFF;
        font-size       : 6px;
        font-family     : "Courier New", Courier, mono;
        line-height     : 4px;
        letter-spacing  : 0px;
    }</style><span class="asciiimage"><font color="#202069">$</font><font color="#2B2B71">$</font><font color="#323278">$</font><font color="#39397C">$</font><font color="#414182">$$</font><font color="#39397C">$</font><font color="#323278">$</font><font color="#2B2B71">$$</font><font color="#202069">$</font><font color="#1C1C68">$</font><font color="#181861">$</font><font color="#121261">$$</font><font color="#10105A">$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$</font><font color="#080858">$$$$</font><font color="#020251">$$$$</font><font color="#00004A">$$$$$$<br>
</font><font color="#2B2B71">$</font><font color="#8C8CAD">$</font><font color="#9494B3">$</font><font color="#51518C">$</font><font color="#9C9CBA">$$</font><font color="#4A4A88">$</font><font color="#9090AD">$</font><font color="#8C8CAD">$</font><font color="#2B2B71">$</font><font color="#8282A6">$</font><font color="#7D7D9F">$</font><font color="#181861">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#080858">$</font><font color="#717194">$$</font><font color="#070753">$</font><font color="#6A6A8A">$$</font><font color="#020251">$</font><font color="#64648B">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5A5A7B">$$<br>
</font><font color="#323278">$</font><font color="#9494B3">$</font><font color="#9C9CBA">$</font><font color="#666699">$</font><font color="#A7A7C1">$$</font><font color="#5B5B93">$</font><font color="#9999B8">$</font><font color="#9090AD">$</font><font color="#323278">$</font><font color="#8282A6">$</font><font color="#7D7D9F">$</font><font color="#1C1C68">$</font><font color="#73739B">$$</font><font color="#121261">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#080858">$</font><font color="#717194">$$</font><font color="#070753">$</font><font color="#64648B">$$</font><font color="#020251">$</font><font color="#636382">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#555578">$$<br>
</font><font color="#39397C">$</font><font color="#51518C">$</font><font color="#666699">$</font><font color="#7272A3">$</font><font color="#7B7BA9">$$</font><font color="#666699">$</font><font color="#5B5B93">$</font><font color="#4A4A88">$</font><font color="#39397C">$</font><font color="#2B2B71">$</font><font color="#202069">$</font><font color="#1C1C68">$</font><font color="#181861">$</font><font color="#121261">$$</font><font color="#10105A">$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$</font><font color="#080858">$$</font><font color="#020251">$$$$</font><font color="#00004A">$$$$$</font><font color="#000042">$$$<br>
</font><font color="#414182">$</font><font color="#9C9CBA">$</font><font color="#A7A7C1">$</font><font color="#7B7BA9">$</font><font color="#B4B4CA">$$</font><font color="#7B7BA9">$</font><font color="#A7A7C1">$</font><font color="#9C9CBA">$</font><font color="#414182">$</font><font color="#8C8CAD">$</font><font color="#8282A6">$</font><font color="#1C1C68">$</font><font color="#73739B">$$</font><font color="#121261">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#080858">$</font><font color="#717194">$</font><font color="#6A6A8A">$</font><font color="#020251">$</font><font color="#64648B">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#555578">$$</font><font color="#000042">$</font><font color="#525273">$$<br>
</font><font color="#414182">$</font><font color="#9C9CBA">$</font><font color="#A7A7C1">$</font><font color="#7272A3">$</font><font color="#B4B4CA">$$</font><font color="#7B7BA9">$</font><font color="#AEAEC0">$</font><font color="#9C9CBA">$</font><font color="#414182">$</font><font color="#8C8CAD">$</font><font color="#8282A6">$</font><font color="#202069">$</font><font color="#73739B">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#080858">$</font><font color="#6A6A8A">$$</font><font color="#020251">$</font><font color="#64648B">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#555578">$$</font><font color="#000042">$</font><font color="#525273">$$<br>
</font><font color="#39397C">$</font><font color="#4A4A88">$</font><font color="#5B5B93">$</font><font color="#666699">$</font><font color="#7B7BA9">$$$</font><font color="#666699">$</font><font color="#5B5B93">$</font><font color="#414182">$</font><font color="#323278">$</font><font color="#2B2B71">$</font><font color="#1C1C68">$</font><font color="#181861">$</font><font color="#121261">$</font><font color="#10105A">$$$</font><font color="#080858">$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$</font><font color="#020251">$$$</font><font color="#00004A">$$$$</font><font color="#000042">$$$$$$<br>
</font><font color="#323278">$</font><font color="#9090AD">$</font><font color="#9999B8">$</font><font color="#5B5B93">$</font><font color="#A7A7C1">$</font><font color="#BFBFCE">$</font><font color="#9494B3">$</font><font color="#BFBFCE">$</font><font color="#B4B4CA">$</font><font color="#7272A3">$</font><font color="#A7A7C1">$</font><font color="#9C9CBA">$</font><font color="#51518C">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#6A6A8A">$$</font><font color="#2B2B71">$</font><font color="#9090AD">$$</font><font color="#4A4A88">$</font><font color="#6A6A8A">$$</font><font color="#080858">$</font><font color="#6A6A8A">$$</font><font color="#080858">$</font><font color="#9090AD">$$</font><font color="#4A4A88">$</font><font color="#7D7D9F">$</font><font color="#6A6A8A">$</font><font color="#181861">$</font><font color="#9090AD">$$</font><font color="#4A4A88">$</font><font color="#9090AD">$$</font><font color="#4A4A88">$</font><font color="#9090AD">$</font><font color="#7D7D9F">$</font><font color="#080858">$</font><font color="#6A6A8A">$</font><font color="#999999">$</font><font color="#8A8A5D">$</font><font color="#C5C55C">$</font><font color="#D4D433">$</font><font color="#E4E42F">$$$</font><font color="#F1F132">$</font><font color="#DFDF46">$</font><font color="#D7D75D">$</font><font color="#848463">$</font><font color="#838392">$</font><font color="#6A6A8A">$</font><font color="#080858">$</font><font color="#6A6A8A">$$</font><font color="#080858">$</font><font color="#6A6A8A">$$</font><font color="#080858">$</font><font color="#6A6A8A">$$</font><font color="#080858">$</font><font color="#6A6A8A">$$</font><font color="#080858">$</font><font color="#6A6A8A">$$</font><font color="#080858">$</font><font color="#6A6A8A">$$</font><font color="#080858">$</font><font color="#6A6A8A">$$</font><font color="#080858">$</font><font color="#6A6A8A">$$</font><font color="#080858">$</font><font color="#6A6A8A">$$</font><font color="#080858">$</font><font color="#6A6A8A">$$</font><font color="#070753">$</font><font color="#64648B">$$</font><font color="#020251">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#555578">$$</font><font color="#000042">$</font><font color="#525273">$</font><font color="#4C4C6B">$</font><font color="#00003A">$</font><font color="#4C4C6B">$$<br>
</font><font color="#2B2B71">$</font><font color="#8C8CAD">$</font><font color="#9090AD">$</font><font color="#4A4A88">$</font><font color="#9C9CBA">$</font><font color="#E8E8EB">$</font><font color="#FFFFFF">$$$$$$$$</font><font color="#C4C4D4">$</font><font color="#181861">$</font><font color="#64648B">$$</font><font color="#8282A6">$</font><font color="#FFFFFF">$$$</font><font color="#64648B">$$</font><font color="#070753">$</font><font color="#64648B">$$</font><font color="#070753">$</font><font color="#FFFFFF">$$$</font><font color="#B4B4CA">$</font><font color="#64648B">$</font><font color="#43437A">$</font><font color="#FFFFFF">$$$$$$$$</font><font color="#EEEEED">$</font><font color="#DDDD8E">$</font><font color="#D7D75D">$</font><font color="#D0D047">$</font><font color="#B5B528">$$</font><font color="#939326">$</font><font color="#A8A834">$</font><font color="#ADAD3A">$</font><font color="#BEBE33">$</font><font color="#E2E238">$</font><font color="#EDED43">$$</font><font color="#F7F735">$</font><font color="#DFDF46">$</font><font color="#616156">$</font><font color="#6A6A8A">$$</font><font color="#070753">$</font><font color="#6A6A8A">$$</font><font color="#070753">$</font><font color="#6A6A8A">$$</font><font color="#070753">$</font><font color="#6A6A8A">$$</font><font color="#070753">$</font><font color="#6A6A8A">$$</font><font color="#070753">$</font><font color="#6A6A8A">$$</font><font color="#070753">$</font><font color="#6A6A8A">$$</font><font color="#070753">$</font><font color="#6A6A8A">$$</font><font color="#070753">$</font><font color="#6A6A8A">$$</font><font color="#070753">$</font><font color="#64648B">$$</font><font color="#020251">$</font><font color="#64648B">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#555578">$$</font><font color="#000042">$</font><font color="#4C4C6B">$$</font><font color="#00003A">$</font><font color="#4C4C6B">$$<br>
</font><font color="#202069">$</font><font color="#2B2B71">$</font><font color="#323278">$</font><font color="#39397C">$</font><font color="#414182">$</font><font color="#D6D6DE">$</font><font color="#FFFFFF">$$</font><font color="#CFCFD7">$</font><font color="#202069">$</font><font color="#181861">$</font><font color="#43437A">$</font><font color="#B4B4CA">$</font><font color="#FFFFFF">$$</font><font color="#EFEFF4">$</font><font color="#34346F">$</font><font color="#09094C">$</font><font color="#8282A6">$</font><font color="#FFFFFF">$$$</font><font color="#020251">$$$$$$</font><font color="#FFFFFF">$$$</font><font color="#8282A6">$</font><font color="#020251">$</font><font color="#43437A">$</font><font color="#FFFFFF">$$$</font><font color="#43437A">$</font><font color="#09094C">$</font><font color="#10105A">$</font><font color="#83839C">$</font><font color="#F5F5F6">$</font><font color="#FFFFFF">$$</font><font color="#D7D7AC">$</font><font color="#4A4A37">$</font><font color="#202040">$</font><font color="#020251">$</font><font color="#070753">$$$$</font><font color="#10105A">$</font><font color="#424252">$</font><font color="#8A8A34">$</font><font color="#F1F132">$$</font><font color="#F1F128">$</font><font color="#B9B936">$</font><font color="#202050">$</font><font color="#070753">$$$$$$$$$$$$$$$$$$$$$$$$</font><font color="#020251">$$$$$</font><font color="#00004A">$$$$</font><font color="#000042">$$$$</font><font color="#00003A">$$$$$<br>
</font><font color="#202069">$</font><font color="#8282A6">$$</font><font color="#2B2B71">$</font><font color="#8C8CAD">$</font><font color="#E8E8EB">$</font><font color="#FFFFFF">$$</font><font color="#DDDDE5">$</font><font color="#181861">$</font><font color="#64648B">$</font><font color="#636382">$</font><font color="#09094C">$</font><font color="#D6D6DE">$</font><font color="#FFFFFF">$$</font><font color="#D6D6DE">$</font><font color="#5A5A7B">$</font><font color="#8282A6">$</font><font color="#FFFFFF">$$$</font><font color="#5A5A7B">$$</font><font color="#00004A">$</font><font color="#5A5A7B">$</font><font color="#5C5C81">$</font><font color="#020251">$</font><font color="#FFFFFF">$$$</font><font color="#AEAEC0">$</font><font color="#5A5A7B">$</font><font color="#424275">$</font><font color="#FFFFFF">$$$</font><font color="#83839C">$</font><font color="#555578">$</font><font color="#666666">$</font><font color="#C5C55C">$</font><font color="#AFAF69">$</font><font color="#FFFFFF">$$$</font><font color="#424275">$</font><font color="#5A5A7B">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#020251">$</font><font color="#64648B">$$</font><font color="#020251">$</font><font color="#6A6A8A">$</font><font color="#B4B45C">$</font><font color="#EEEE20">$</font><font color="#F1F128">$</font><font color="#E5E528">$</font><font color="#41414D">$</font><font color="#64648B">$$</font><font color="#020251">$</font><font color="#64648B">$$</font><font color="#020251">$</font><font color="#64648B">$$</font><font color="#020251">$</font><font color="#64648B">$$</font><font color="#020251">$</font><font color="#64648B">$$</font><font color="#020251">$</font><font color="#64648B">$$</font><font color="#020251">$</font><font color="#64648B">$$</font><font color="#020251">$</font><font color="#64648B">$$</font><font color="#020251">$</font><font color="#64648B">$$</font><font color="#020251">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5A5A7B">$$</font><font color="#000042">$</font><font color="#525273">$$</font><font color="#00003A">$</font><font color="#4C4C6B">$$</font><font color="#00003A">$</font><font color="#4A4A62">$$<br>
</font><font color="#1C1C68">$</font><font color="#7D7D9F">$$</font><font color="#202069">$</font><font color="#8282A6">$</font><font color="#DDDDE5">$</font><font color="#FFFFFF">$$</font><font color="#DDDDE5">$</font><font color="#101051">$</font><font color="#5A5A7B">$</font><font color="#525273">$</font><font color="#080842">$</font><font color="#9494A1">$</font><font color="#FFFFFF">$$$</font><font color="#636382">$</font><font color="#83839C">$</font><font color="#FFFFFF">$$$</font><font color="#525273">$$</font><font color="#000042">$</font><font color="#525273">$</font><font color="#555578">$</font><font color="#00004A">$</font><font color="#FFFFFF">$$$</font><font color="#ADADB6">$</font><font color="#525273">$</font><font color="#424275">$</font><font color="#FFFFFF">$$$</font><font color="#7B7B8E">$</font><font color="#9B9B71">$</font><font color="#B4B45C">$</font><font color="#858527">$</font><font color="#565622">$</font><font color="#DDDDE5">$</font><font color="#FFFFFF">$$</font><font color="#9C9CBA">$</font><font color="#525273">$</font><font color="#9B9B71">$</font><font color="#AFAF69">$</font><font color="#C7C770">$</font><font color="#CCCC66">$</font><font color="#B9B948">$</font><font color="#999966">$</font><font color="#636382">$</font><font color="#020251">$</font><font color="#636382">$$</font><font color="#2C2C55">$</font><font color="#E2E238">$</font><font color="#EEEE20">$</font><font color="#E5E517">$</font><font color="#8A8A5D">$</font><font color="#636382">$</font><font color="#020251">$</font><font color="#636382">$$</font><font color="#020251">$</font><font color="#636382">$$</font><font color="#020251">$</font><font color="#636382">$$</font><font color="#020251">$</font><font color="#636382">$$</font><font color="#020251">$</font><font color="#636382">$$</font><font color="#020251">$</font><font color="#636382">$$</font><font color="#020251">$</font><font color="#636382">$$</font><font color="#020251">$</font><font color="#636382">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#555578">$$</font><font color="#000042">$</font><font color="#525273">$</font><font color="#4C4C6B">$</font><font color="#00003A">$</font><font color="#4A4A62">$$</font><font color="#00003A">$</font><font color="#4A4A62">$$<br>
</font><font color="#181861">$$</font><font color="#1C1C68">$$$</font><font color="#C4C4D4">$</font><font color="#FFFFFF">$$</font><font color="#C4C4D4">$</font><font color="#0E0E4A">$</font><font color="#080842">$$$</font><font color="#41416C">$</font><font color="#FFFFFF">$$$</font><font color="#41416C">$</font><font color="#83839C">$</font><font color="#FFFFFF">$$$</font><font color="#00003A">$$$$$</font><font color="#000042">$</font><font color="#FFFFFF">$$$</font><font color="#7D7D9F">$</font><font color="#00003A">$</font><font color="#41416C">$</font><font color="#FFFFFF">$$$</font><font color="#8E8E81">$</font><font color="#A5A554">$</font><font color="#767626">$</font><font color="#39391B">$</font><font color="#00003A">$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$$</font><font color="#BFBFCE">$</font><font color="#00003A">$</font><font color="#999966">$</font><font color="#D4D480">$</font><font color="#E3E374">$</font><font color="#E6E656">$</font><font color="#DFDF23">$</font><font color="#666633">$</font><font color="#00004A">$$$$$</font><font color="#101051">$</font><font color="#BEBE33">$</font><font color="#E5E517">$</font><font color="#DEDE14">$</font><font color="#3B3B38">$</font><font color="#00004A">$$$$$$$$$$$$$$$$$$$$$$$$$$$$</font><font color="#000042">$$$$</font><font color="#00003A">$$$$$$$<br>
</font><font color="#121261">$</font><font color="#73739B">$$</font><font color="#181861">$</font><font color="#73739B">$</font><font color="#DDDDE5">$</font><font color="#FFFFFF">$$</font><font color="#D6D6DE">$</font><font color="#080842">$</font><font color="#4A4A62">$</font><font color="#42425A">$</font><font color="#000033">$</font><font color="#838392">$</font><font color="#FFFFFF">$$$</font><font color="#737384">$</font><font color="#83839C">$</font><font color="#FFFFFF">$$$</font><font color="#42425A">$$</font><font color="#000033">$</font><font color="#42425A">$</font><font color="#4C4C6B">$</font><font color="#000042">$</font><font color="#FFFFFF">$$$</font><font color="#A5A5B4">$</font><font color="#42425A">$</font><font color="#404063">$</font><font color="#FFFFFF">$$$</font><font color="#B6B67A">$</font><font color="#767626">$</font><font color="#39391B">$</font><font color="#42425A">$$</font><font color="#CFCFD7">$</font><font color="#FFFFFF">$$</font><font color="#BFBFCE">$</font><font color="#42425A">$</font><font color="#9C9C5B">$</font><font color="#C7C770">$</font><font color="#CCCC66">$</font><font color="#CCCC33">$</font><font color="#BEBE08">$</font><font color="#82823C">$</font><font color="#5C5C81">$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5C5C81">$</font><font color="#636382">$</font><font color="#BEBE22">$</font><font color="#DEDE14">$</font><font color="#CFCF10">$</font><font color="#111140">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5A5A7B">$$</font><font color="#000042">$</font><font color="#555578">$</font><font color="#525273">$</font><font color="#000042">$</font><font color="#4C4C6B">$$</font><font color="#00003A">$</font><font color="#4A4A62">$$</font><font color="#000033">$</font><font color="#42425A">$$<br>
</font><font color="#10105A">$</font><font color="#73739B">$$</font><font color="#121261">$</font><font color="#73739B">$</font><font color="#DDDDE5">$</font><font color="#FFFFFF">$$</font><font color="#D5D5D9">$</font><font color="#08083A">$</font><font color="#42425A">$$</font><font color="#000033">$</font><font color="#CFCFD7">$</font><font color="#FFFFFF">$$</font><font color="#F5F5F6">$</font><font color="#42425A">$</font><font color="#83839C">$</font><font color="#FFFFFF">$$$</font><font color="#3A3A50">$$</font><font color="#000033">$</font><font color="#42425A">$</font><font color="#4A4A62">$</font><font color="#00003A">$</font><font color="#FFFFFF">$$$</font><font color="#A5A5B4">$</font><font color="#42425A">$</font><font color="#404063">$</font><font color="#FFFFFF">$$$</font><font color="#9C9C5B">$</font><font color="#444412">$</font><font color="#000029">$</font><font color="#3A3A50">$</font><font color="#737384">$</font><font color="#FFFFFF">$$$</font><font color="#71718E">$</font><font color="#42425A">$</font><font color="#95954F">$</font><font color="#B4B45C">$</font><font color="#BEBE52">$</font><font color="#ABAB25">$</font><font color="#999900">$</font><font color="#74743D">$</font><font color="#5C5C81">$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#0E0E4A">$</font><font color="#DFDF23">$</font><font color="#DEDE14">$</font><font color="#9B9B17">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#B4B4CA">$</font><font color="#D6D6DE">$</font><font color="#BFBFCE">$</font><font color="#5C5C81">$$</font><font color="#00004A">$</font><font color="#5A5A7B">$$</font><font color="#000042">$</font><font color="#5A5A7B">$$</font><font color="#000042">$</font><font color="#525273">$$</font><font color="#00003A">$</font><font color="#4C4C6B">$$</font><font color="#00003A">$</font><font color="#4A4A62">$</font><font color="#42425A">$</font><font color="#000033">$</font><font color="#42425A">$$<br>
</font><font color="#10105A">$$$$$</font><font color="#C4C4D4">$</font><font color="#FFFFFF">$$</font><font color="#BFBFCE">$</font><font color="#00003A">$$</font><font color="#111140">$</font><font color="#A5A5B4">$</font><font color="#FFFFFF">$$$</font><font color="#71718E">$</font><font color="#000033">$</font><font color="#838392">$</font><font color="#FFFFFF">$$$$$$$$$$$$</font><font color="#83839C">$</font><font color="#000033">$</font><font color="#404063">$</font><font color="#FFFFFF">$$$</font><font color="#848450">$</font><font color="#000029">$$</font><font color="#404063">$</font><font color="#EFEFF4">$</font><font color="#FFFFFF">$$</font><font color="#DDDDE5">$</font><font color="#111140">$</font><font color="#000033">$</font><font color="#7B7B39">$</font><font color="#ACAC4A">$</font><font color="#ADAD3A">$</font><font color="#9B9B17">$</font><font color="#858500">$</font><font color="#404021">$</font><font color="#000042">$</font><font color="#333366">$</font><font color="#424275">$$</font><font color="#20205C">$</font><font color="#000042">$$$</font><font color="#383845">$</font><font color="#EEEE20">$</font><font color="#E5E517">$</font><font color="#4A4A37">$</font><font color="#20205C">$</font><font color="#424275">$</font><font color="#101051">$</font><font color="#000042">$$$$$$$$$$$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$$</font><font color="#000042">$$$$$$$$$</font><font color="#00003A">$$$$$</font><font color="#000033">$$$$$$<br>
</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$</font><font color="#DDDDE5">$</font><font color="#FFFFFF">$$</font><font color="#F5F5F6">$</font><font color="#BFBFCE">$</font><font color="#CFCFD7">$</font><font color="#FFFFFF">$$$</font><font color="#F5F5F6">$</font><font color="#7D7D9F">$</font><font color="#42425A">$$</font><font color="#838392">$</font><font color="#FFFFFF">$$$</font><font color="#9C9CA4">$$</font><font color="#838392">$</font><font color="#9C9CAA">$$</font><font color="#7D7D9F">$</font><font color="#FFFFFF">$$$</font><font color="#9C9CAA">$</font><font color="#3A3A50">$</font><font color="#42425A">$</font><font color="#FFFFFF">$$$</font><font color="#DDDDE0">$</font><font color="#CFCFD7">$</font><font color="#DDDDE5">$</font><font color="#FFFFFF">$$$</font><font color="#CFCFD7">$</font><font color="#63637B">$</font><font color="#000033">$</font><font color="#3A3A50">$</font><font color="#82823C">$</font><font color="#A8A834">$$</font><font color="#8B8B15">$</font><font color="#7B7B00">$</font><font color="#69693A">$</font><font color="#5A5A7B">$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$$</font><font color="#DDDDE5">$</font><font color="#636382">$</font><font color="#5A5A7B">$</font><font color="#000042">$</font><font color="#5A5A7B">$</font><font color="#C6C649">$</font><font color="#E5E528">$</font><font color="#C5C52A">$</font><font color="#AEAEC0">$</font><font color="#FFFFFF">$</font><font color="#83839C">$</font><font color="#5A5A7B">$</font><font color="#000042">$</font><font color="#5A5A7B">$$</font><font color="#000042">$</font><font color="#5A5A7B">$$</font><font color="#000042">$</font><font color="#5A5A7B">$$</font><font color="#000042">$</font><font color="#D6D6DE">$</font><font color="#FFFFFF">$$</font><font color="#555578">$$</font><font color="#000042">$</font><font color="#525273">$$</font><font color="#000042">$</font><font color="#555578">$$</font><font color="#000042">$</font><font color="#525273">$$</font><font color="#00003A">$</font><font color="#4C4C6B">$</font><font color="#4A4A62">$</font><font color="#000033">$</font><font color="#42425A">$$</font><font color="#000033">$</font><font color="#42425A">$$<br>
</font><font color="#10105A">$</font><font color="#717194">$$</font><font color="#10105A">$</font><font color="#717194">$</font><font color="#DDDDE5">$</font><font color="#FFFFFF">$$</font><font color="#E8E8EB">$</font><font color="#83839C">$</font><font color="#9C9CAA">$$</font><font color="#71718E">$</font><font color="#737384">$</font><font color="#4A4A62">$</font><font color="#000033">$</font><font color="#42425A">$$</font><font color="#838392">$</font><font color="#FFFFFF">$$$</font><font color="#323244">$$</font><font color="#000029">$</font><font color="#3A3A50">$$</font><font color="#000033">$</font><font color="#FFFFFF">$$$</font><font color="#9C9CAA">$</font><font color="#3A3A50">$</font><font color="#42425A">$</font><font color="#FFFFFF">$$$</font><font color="#B5B5BC">$</font><font color="#9C9CA4">$</font><font color="#838392">$</font><font color="#9C9CA4">$</font><font color="#7B7B8E">$</font><font color="#202050">$</font><font color="#4A4A62">$</font><font color="#42425A">$</font><font color="#000033">$</font><font color="#3A3A50">$</font><font color="#8A8A34">$</font><font color="#A8A834">$</font><font color="#A7A729">$</font><font color="#85850F">$</font><font color="#757502">$</font><font color="#666633">$</font><font color="#5A5A7B">$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$$$</font><font color="#D6D6DE">$</font><font color="#555578">$</font><font color="#00003A">$</font><font color="#555578">$</font><font color="#727274">$</font><font color="#F1F132">$</font><font color="#DFDF23">$</font><font color="#B6B6B8">$</font><font color="#FFFFFF">$</font><font color="#83839C">$</font><font color="#5A5A7B">$</font><font color="#000042">$</font><font color="#555578">$$</font><font color="#000042">$</font><font color="#5A5A7B">$$</font><font color="#000042">$</font><font color="#5A5A7B">$$</font><font color="#000042">$</font><font color="#D6D6DE">$</font><font color="#FFFFFF">$$</font><font color="#525273">$$</font><font color="#00003A">$</font><font color="#52526B">$$</font><font color="#00003A">$</font><font color="#555578">$$</font><font color="#00003A">$</font><font color="#525273">$$</font><font color="#00003A">$</font><font color="#4A4A62">$$</font><font color="#000033">$</font><font color="#42425A">$$</font><font color="#000033">$</font><font color="#42425A">$$<br>
</font><font color="#101051">$$$$$</font><font color="#C4C4D4">$</font><font color="#FFFFFF">$$</font><font color="#BFBFCE">$</font><font color="#000033">$</font><font color="#000029">$$$</font><font color="#000033">$$$$$</font><font color="#838392">$</font><font color="#FFFFFF">$$$</font><font color="#000021">$$$$</font><font color="#000029">$$</font><font color="#FFFFFF">$$$</font><font color="#838392">$</font><font color="#000029">$</font><font color="#42425A">$</font><font color="#FFFFFF">$$$</font><font color="#42425A">$</font><font color="#000029">$$$$</font><font color="#000033">$$$$$</font><font color="#202036">$</font><font color="#282842">$$</font><font color="#1A1A35">$</font><font color="#101029">$</font><font color="#08083A">$</font><font color="#000042">$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$$$$</font><font color="#83839C">$</font><font color="#00003A">$$$</font><font color="#B9B936">$</font><font color="#DFDF23">$</font><font color="#AFAF97">$</font><font color="#FFFFFF">$</font><font color="#41416C">$</font><font color="#00003A">$$$$</font><font color="#000042">$$$$$$$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$$</font><font color="#00003A">$$$$$$$$$$$$</font><font color="#000033">$$$$$$$$<br>
</font><font color="#101051">$</font><font color="#717194">$$</font><font color="#101051">$</font><font color="#717194">$</font><font color="#DDDDE5">$</font><font color="#FFFFFF">$$</font><font color="#D5D5D9">$</font><font color="#000033">$</font><font color="#3A3A50">$$</font><font color="#000029">$</font><font color="#424252">$$</font><font color="#000033">$</font><font color="#42425A">$$</font><font color="#838392">$</font><font color="#FFFFFF">$$$</font><font color="#383845">$$</font><font color="#000021">$</font><font color="#383845">$</font><font color="#3A3A50">$</font><font color="#000029">$</font><font color="#FFFFFF">$$$</font><font color="#9C9CAA">$</font><font color="#383845">$</font><font color="#42425A">$</font><font color="#FFFFFF">$$$</font><font color="#696974">$</font><font color="#383845">$</font><font color="#000029">$</font><font color="#3A3A4A">$$</font><font color="#000029">$</font><font color="#42425A">$$</font><font color="#000033">$</font><font color="#424252">$$$</font><font color="#848463">$</font><font color="#69693A">$</font><font color="#101029">$</font><font color="#555578">$</font><font color="#5A5A7B">$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$$$$$</font><font color="#525273">$</font><font color="#4A4A62">$$</font><font color="#69693A">$</font><font color="#BDBD1A">$</font><font color="#CBCB91">$</font><font color="#FFFFFF">$</font><font color="#83839C">$</font><font color="#525273">$</font><font color="#00003A">$</font><font color="#525273">$$</font><font color="#00003A">$</font><font color="#555578">$$</font><font color="#000042">$</font><font color="#5A5A7B">$$</font><font color="#000042">$</font><font color="#D6D6DE">$</font><font color="#FFFFFF">$$</font><font color="#4C4C6B">$</font><font color="#4A4A62">$</font><font color="#000033">$</font><font color="#4A4A62">$$</font><font color="#00003A">$</font><font color="#525273">$$</font><font color="#00003A">$</font><font color="#525273">$$</font><font color="#00003A">$</font><font color="#4A4A62">$$</font><font color="#000033">$</font><font color="#42425A">$$</font><font color="#000033">$</font><font color="#42425A">$$<br>
</font><font color="#101051">$</font><font color="#717194">$$</font><font color="#101051">$</font><font color="#717194">$</font><font color="#DDDDE5">$</font><font color="#FFFFFF">$$</font><font color="#D5D5D9">$</font><font color="#000033">$</font><font color="#3A3A50">$$</font><font color="#000029">$</font><font color="#3A3A50">$</font><font color="#42425A">$</font><font color="#000033">$</font><font color="#42425A">$$</font><font color="#838392">$</font><font color="#FFFFFF">$$$</font><font color="#3A3A4A">$$</font><font color="#000021">$</font><font color="#383845">$</font><font color="#3A3A50">$</font><font color="#000029">$</font><font color="#FFFFFF">$$$</font><font color="#9C9CAA">$</font><font color="#383845">$</font><font color="#4B4B5A">$</font><font color="#FFFFFF">$$$</font><font color="#696974">$</font><font color="#383845">$</font><font color="#000021">$</font><font color="#383845">$$</font><font color="#000029">$</font><font color="#42425A">$$</font><font color="#000033">$</font><font color="#4A4A62">$</font><font color="#AFAF69">$</font><font color="#CCCC72">$</font><font color="#D7D75D">$</font><font color="#BEBE22">$</font><font color="#B7B703">$</font><font color="#999933">$</font><font color="#5A5A7B">$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$</font><font color="#9C9CAA">$</font><font color="#FFFFFF">$$$</font><font color="#EFEFF4">$</font><font color="#59596B">$</font><font color="#4A4A62">$</font><font color="#31313D">$</font><font color="#BCBC11">$</font><font color="#C8C887">$</font><font color="#FFFFFF">$</font><font color="#838392">$</font><font color="#52526B">$</font><font color="#00003A">$</font><font color="#4C4C6B">$$</font><font color="#00003A">$</font><font color="#525273">$</font><font color="#5A5A73">$</font><font color="#00003A">$</font><font color="#5A5A7B">$$</font><font color="#00003A">$</font><font color="#D6D6DE">$</font><font color="#FFFFFF">$$</font><font color="#4A4A62">$$</font><font color="#000033">$</font><font color="#42425A">$</font><font color="#4A4A62">$</font><font color="#000033">$</font><font color="#52526B">$$</font><font color="#00003A">$</font><font color="#52526B">$$</font><font color="#000033">$</font><font color="#4A4A62">$$</font><font color="#000033">$</font><font color="#42425A">$$</font><font color="#000033">$</font><font color="#42425A">$$<br>
</font><font color="#101051">$$$$$</font><font color="#C4C4D4">$</font><font color="#FFFFFF">$$</font><font color="#BFBFCE">$</font><font color="#000033">$</font><font color="#000029">$$$$$</font><font color="#000033">$$$</font><font color="#83839C">$</font><font color="#FFFFFF">$$$</font><font color="#000029">$$$$$$</font><font color="#FFFFFF">$$$</font><font color="#838392">$</font><font color="#000029">$</font><font color="#58585B">$</font><font color="#FFFFFF">$$$</font><font color="#42425A">$</font><font color="#000021">$$$$</font><font color="#000029">$</font><font color="#000033">$$$</font><font color="#616156">$</font><font color="#D4D480">$</font><font color="#DDDD8E">$</font><font color="#E3E374">$</font><font color="#D4D433">$</font><font color="#CFCF10">$</font><font color="#CCCC00">$</font><font color="#25252E">$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$</font><font color="#00003A">$</font><font color="#A5A5B4">$</font><font color="#FFFFFF">$$$</font><font color="#CFCFD7">$</font><font color="#000029">$</font><font color="#101033">$</font><font color="#BEBE22">$</font><font color="#D4D480">$</font><font color="#FFFFFF">$</font><font color="#41416C">$</font><font color="#000033">$</font><font color="#636382">$</font><font color="#BFBFCE">$$</font><font color="#34345C">$</font><font color="#00003A">$$$</font><font color="#9090AD">$$</font><font color="#00003A">$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$$</font><font color="#000033">$$$</font><font color="#63637B">$</font><font color="#FFFFFF">$</font><font color="#9090AD">$</font><font color="#00003A">$</font><font color="#34345C">$</font><font color="#AEAEC0">$</font><font color="#BFBFCE">$$$$$</font><font color="#63637B">$</font><font color="#000029">$$$$$<br>
</font><font color="#101051">$</font><font color="#717194">$$</font><font color="#101051">$</font><font color="#71718E">$</font><font color="#DDDDE0">$</font><font color="#FFFFFF">$$</font><font color="#D5D5D9">$</font><font color="#000033">$</font><font color="#3A3A50">$$</font><font color="#000029">$</font><font color="#424252">$</font><font color="#42425A">$</font><font color="#000033">$</font><font color="#4C4C6B">$$</font><font color="#83839C">$</font><font color="#FFFFFF">$$$</font><font color="#3A3A50">$$</font><font color="#000021">$</font><font color="#3A3A4A">$</font><font color="#424252">$</font><font color="#000033">$</font><font color="#FFFFFF">$$$</font><font color="#9C9CAA">$</font><font color="#3A3A4A">$</font><font color="#5A5A66">$</font><font color="#FFFFFF">$$$</font><font color="#696974">$</font><font color="#383845">$</font><font color="#000021">$</font><font color="#383845">$</font><font color="#3A3A50">$</font><font color="#000029">$</font><font color="#4A4A62">$$</font><font color="#000033">$</font><font color="#BCBC65">$</font><font color="#E3E374">$</font><font color="#EAEA7B">$</font><font color="#E6E663">$</font><font color="#D4D433">$</font><font color="#CFCF10">$</font><font color="#BEBE08">$</font><font color="#82823C">$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$</font><font color="#52526B">$</font><font color="#111140">$</font><font color="#DDDDE0">$</font><font color="#FFFFFF">$$$</font><font color="#B5B5BC">$</font><font color="#000029">$</font><font color="#B5B528">$</font><font color="#D4D480">$</font><font color="#FFFFFF">$</font><font color="#7B7B8E">$</font><font color="#4C4C6B">$</font><font color="#83839C">$</font><font color="#FFFFFF">$$</font><font color="#404063">$</font><font color="#52526B">$$</font><font color="#00003A">$</font><font color="#D6D6DE">$$</font><font color="#00003A">$</font><font color="#D6D6DE">$</font><font color="#FFFFFF">$$</font><font color="#4A4A62">$</font><font color="#424252">$</font><font color="#303051">$</font><font color="#F5F5F6">$</font><font color="#DDDDE0">$</font><font color="#111140">$</font><font color="#52526B">$</font><font color="#E8E8EB">$</font><font color="#FFFFFF">$</font><font color="#F5F5F6">$</font><font color="#A5A5B4">$</font><font color="#83839C">$</font><font color="#A5A5AD">$$</font><font color="#404063">$</font><font color="#42425A">$$</font><font color="#000029">$</font><font color="#424252">$$<br>
</font><font color="#0E0E4A">$</font><font color="#717194">$$</font><font color="#0E0E4A">$</font><font color="#71718E">$</font><font color="#DDDDE0">$</font><font color="#FFFFFF">$$</font><font color="#D5D5D9">$</font><font color="#000033">$</font><font color="#424252">$</font><font color="#3A3A50">$</font><font color="#000029">$</font><font color="#42425A">$</font><font color="#4A4A62">$</font><font color="#000033">$</font><font color="#52526B">$$</font><font color="#83839C">$</font><font color="#FFFFFF">$$$</font><font color="#424252">$</font><font color="#3A3A4A">$</font><font color="#000021">$</font><font color="#3A3A50">$</font><font color="#42425A">$</font><font color="#000033">$</font><font color="#FFFFFF">$$$</font><font color="#9C9CAA">$</font><font color="#3A3A50">$</font><font color="#5A5A66">$</font><font color="#FFFFFF">$$$</font><font color="#696974">$</font><font color="#383845">$</font><font color="#000021">$</font><font color="#3A3A4A">$$</font><font color="#000029">$</font><font color="#76766A">$</font><font color="#999966">$</font><font color="#000033">$</font><font color="#C7C770">$</font><font color="#ECEC61">$</font><font color="#DFDF46">$</font><font color="#CCCC33">$</font><font color="#A4A410">$</font><font color="#999900">$</font><font color="#ADAD06">$</font><font color="#82823C">$</font><font color="#C5C5CB">$</font><font color="#FFFFFF">$</font><font color="#666666">$</font><font color="#000033">$</font><font color="#636374">$</font><font color="#EFEFF4">$</font><font color="#FFFFFF">$$$</font><font color="#63637B">$</font><font color="#ABAB25">$</font><font color="#D4D480">$</font><font color="#FFFFFF">$</font><font color="#7B7B8E">$</font><font color="#4A4A62">$</font><font color="#83839C">$</font><font color="#FFFFFF">$$</font><font color="#404063">$</font><font color="#4C4C6B">$</font><font color="#52526B">$</font><font color="#00003A">$</font><font color="#D6D6DE">$$</font><font color="#00003A">$</font><font color="#D6D6DE">$</font><font color="#FFFFFF">$$</font><font color="#42425A">$</font><font color="#4A4A62">$</font><font color="#CFCFD7">$</font><font color="#F5F5F6">$</font><font color="#5A5A73">$</font><font color="#000033">$</font><font color="#4C4C6B">$</font><font color="#FFFFFF">$$</font><font color="#D5D5D9">$</font><font color="#4A4A62">$</font><font color="#000033">$</font><font color="#42425A">$$</font><font color="#000029">$</font><font color="#424252">$$</font><font color="#000029">$</font><font color="#424252">$$<br>
</font><font color="#0E0E4A">$$$$$</font><font color="#34346F">$</font><font color="#424275">$$</font><font color="#34345C">$</font><font color="#000033">$</font><font color="#000029">$$$$$</font><font color="#000033">$$$</font><font color="#202050">$</font><font color="#41416C">$$</font><font color="#404063">$</font><font color="#000029">$$$$$$</font><font color="#404063">$$$</font><font color="#202040">$</font><font color="#000029">$</font><font color="#31313D">$</font><font color="#95954F">$</font><font color="#82823C">$</font><font color="#42425A">$</font><font color="#101033">$</font><font color="#000021">$$$</font><font color="#202036">$</font><font color="#9C9C5B">$</font><font color="#E6E663">$</font><font color="#ECEC61">$</font><font color="#58585B">$</font><font color="#6D6D5A">$</font><font color="#D4D433">$</font><font color="#CFCF10">$</font><font color="#ADAD06">$</font><font color="#858500">$</font><font color="#7B7B00">$</font><font color="#999900">$</font><font color="#1A1A35">$</font><font color="#DFDFC9">$</font><font color="#FFFFFF">$</font><font color="#D3D321">$</font><font color="#767626">$</font><font color="#08082A">$</font><font color="#636374">$</font><font color="#FFFFFF">$$$</font><font color="#EFEFF4">$</font><font color="#ACAC4A">$</font><font color="#C8C887">$</font><font color="#FFFFFF">$</font><font color="#404063">$</font><font color="#000033">$</font><font color="#838392">$</font><font color="#FFFFFF">$$</font><font color="#404063">$</font><font color="#000033">$$$</font><font color="#BFBFCE">$$</font><font color="#000033">$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$$</font><font color="#000029">$</font><font color="#9C9CAA">$</font><font color="#FFFFFF">$</font><font color="#52526B">$</font><font color="#000029">$$$</font><font color="#FFFFFF">$$</font><font color="#BFBFCE">$</font><font color="#000029">$$$$$$$$$$<br>
</font><font color="#0E0E4A">$</font><font color="#71718E">$$</font><font color="#0E0E4A">$</font><font color="#71718E">$$</font><font color="#080842">$</font><font color="#5A5A7B">$</font><font color="#52526B">$</font><font color="#08082E">$</font><font color="#424252">$$</font><font color="#000029">$</font><font color="#4A4A62">$</font><font color="#52526B">$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#00003A">$</font><font color="#525273">$</font><font color="#52526B">$</font><font color="#000033">$</font><font color="#42425A">$</font><font color="#3A3A50">$</font><font color="#000029">$</font><font color="#424252">$</font><font color="#42425A">$</font><font color="#000033">$</font><font color="#52526B">$$</font><font color="#000033">$</font><font color="#42425A">$$</font><font color="#101029">$</font><font color="#8B8B15">$</font><font color="#7B7B00">$</font><font color="#000021">$</font><font color="#3A3A50">$$</font><font color="#08082A">$</font><font color="#848463">$</font><font color="#C7C770">$</font><font color="#D4D480">$</font><font color="#E3E374">$</font><font color="#E6E656">$</font><font color="#C6C649">$</font><font color="#5A5A73">$</font><font color="#9B9B17">$</font><font color="#BEBE08">$</font><font color="#A5A508">$</font><font color="#858500">$</font><font color="#757502">$</font><font color="#767626">$</font><font color="#616156">$</font><font color="#F7F7C6">$</font><font color="#FFFFFF">$</font><font color="#D3D321">$</font><font color="#BDBD1A">$</font><font color="#A4A410">$</font><font color="#666633">$</font><font color="#8D8D9B">$</font><font color="#FFFFFF">$$$</font><font color="#EEEEED">$</font><font color="#BEBE95">$</font><font color="#FFFFFF">$</font><font color="#737384">$</font><font color="#42425A">$</font><font color="#838392">$</font><font color="#FFFFFF">$$</font><font color="#404063">$</font><font color="#42425A">$</font><font color="#4A4A62">$</font><font color="#000033">$</font><font color="#D5D5D9">$$</font><font color="#000033">$</font><font color="#D5D5D9">$</font><font color="#FFFFFF">$$</font><font color="#8C8C94">$</font><font color="#FFFFFF">$</font><font color="#9494A1">$</font><font color="#3A3A50">$</font><font color="#424252">$</font><font color="#000029">$</font><font color="#4B4B5A">$</font><font color="#FFFFFF">$$</font><font color="#CFCFD7">$</font><font color="#424252">$</font><font color="#000029">$</font><font color="#3A3A50">$$</font><font color="#000021">$</font><font color="#3A3A4A">$$</font><font color="#000029">$</font><font color="#3A3A50">$</font><font color="#424252">$<br>
</font><font color="#0E0E4A">$</font><font color="#71718E">$$</font><font color="#0E0E4A">$</font><font color="#71718E">$$</font><font color="#080842">$</font><font color="#63637B">$</font><font color="#59596B">$</font><font color="#08082E">$</font><font color="#42425A">$$</font><font color="#000029">$</font><font color="#4A4A62">$</font><font color="#52526B">$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#00003A">$</font><font color="#525273">$</font><font color="#52526B">$</font><font color="#000033">$</font><font color="#42425A">$$</font><font color="#000029">$</font><font color="#424252">$</font><font color="#4A4A62">$</font><font color="#000033">$</font><font color="#52526B">$$</font><font color="#000033">$</font><font color="#4A4A62">$</font><font color="#424252">$</font><font color="#000029">$</font><font color="#9B9B17">$</font><font color="#85850F">$</font><font color="#18181E">$</font><font color="#424252">$</font><font color="#616156">$</font><font color="#A5A554">$</font><font color="#B4B45C">$</font><font color="#C7C770">$</font><font color="#CCCC66">$</font><font color="#CBCB52">$</font><font color="#ABAB25">$</font><font color="#8B8B15">$</font><font color="#69693A">$</font><font color="#5A5A73">$</font><font color="#404021">$</font><font color="#74743D">$</font><font color="#69693A">$</font><font color="#101029">$</font><font color="#5A5A73">$</font><font color="#B5B528">$</font><font color="#F7F7C6">$</font><font color="#FFFFFF">$</font><font color="#CFCF10">$</font><font color="#BCBC11">$</font><font color="#A5A508">$</font><font color="#94940A">$</font><font color="#757502">$</font><font color="#DDDDE0">$</font><font color="#FFFFFF">$$$$$</font><font color="#6C6C78">$</font><font color="#424252">$</font><font color="#838392">$</font><font color="#FFFFFF">$$</font><font color="#42425A">$$$</font><font color="#000029">$</font><font color="#CFCFD7">$$</font><font color="#000033">$</font><font color="#D5D5D9">$</font><font color="#FFFFFF">$$$$</font><font color="#9C9CAA">$</font><font color="#3A3A4A">$$</font><font color="#000029">$</font><font color="#42425A">$</font><font color="#FFFFFF">$$$$$$</font><font color="#CCCCCC">$</font><font color="#000021">$</font><font color="#383845">$$</font><font color="#000021">$</font><font color="#3A3A50">$</font><font color="#424252">$<br>
</font><font color="#0E0E4A">$$$$$$$</font><font color="#08083A">$$$</font><font color="#000033">$$$$$$$$$$$$</font><font color="#000029">$$$$</font><font color="#000033">$$$$$$$</font><font color="#000029">$</font><font color="#858527">$</font><font color="#8C8C04">$</font><font color="#444412">$</font><font color="#000029">$</font><font color="#53533B">$</font><font color="#B9B936">$</font><font color="#BEBE33">$$</font><font color="#A7A729">$</font><font color="#8B8B15">$</font><font color="#666600">$</font><font color="#5C5C00">$</font><font color="#54540B">$</font><font color="#000033">$$$$$$</font><font color="#E4E409">$</font><font color="#F7F7C6">$</font><font color="#FFFFFF">$</font><font color="#C4C40C">$</font><font color="#ADAD06">$</font><font color="#999900">$</font><font color="#8C8C04">$</font><font color="#858500">$</font><font color="#1A1A35">$</font><font color="#EFEFF4">$</font><font color="#FFFFFF">$$$$</font><font color="#42425A">$</font><font color="#000021">$</font><font color="#838392">$</font><font color="#FFFFFF">$$</font><font color="#42425A">$</font><font color="#000021">$$$</font><font color="#BFBFCE">$$</font><font color="#000029">$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$$</font><font color="#EFEFF4">$</font><font color="#FFFFFF">$$</font><font color="#636374">$</font><font color="#000021">$$$</font><font color="#FFFFFF">$$</font><font color="#CFCFD7">$</font><font color="#42425A">$$$</font><font color="#303049">$</font><font color="#000021">$$$$$$<br>
</font><font color="#0E0E4A">$</font><font color="#71718E">$$</font><font color="#0E0E4A">$</font><font color="#71718E">$$</font><font color="#080842">$</font><font color="#636382">$</font><font color="#5A5A73">$</font><font color="#000033">$</font><font color="#52526B">$$</font><font color="#000033">$</font><font color="#52526B">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#525263">$</font><font color="#4A4A62">$</font><font color="#000029">$</font><font color="#4A4A62">$</font><font color="#52526B">$</font><font color="#000033">$</font><font color="#59596B">$$</font><font color="#000033">$</font><font color="#52526B">$</font><font color="#4A4A62">$</font><font color="#000029">$</font><font color="#787847">$</font><font color="#A4A410">$</font><font color="#999900">$</font><font color="#4A4A62">$</font><font color="#525263">$</font><font color="#BEBE22">$</font><font color="#D3D321">$</font><font color="#BDBD1A">$</font><font color="#94940A">$</font><font color="#666600">$</font><font color="#5C5C00">$</font><font color="#333313">$</font><font color="#525263">$</font><font color="#5A5A73">$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$</font><font color="#6D6D5A">$</font><font color="#E7E7C4">$</font><font color="#FFFFFF">$</font><font color="#B7B703">$</font><font color="#999900">$</font><font color="#757502">$$</font><font color="#54540B">$</font><font color="#42425A">$</font><font color="#818173">$</font><font color="#FFFFFF">$$$$</font><font color="#636374">$</font><font color="#383845">$</font><font color="#838392">$</font><font color="#FFFFFF">$$</font><font color="#42425A">$</font><font color="#3A3A50">$$</font><font color="#000021">$</font><font color="#CFCFD7">$$</font><font color="#000029">$</font><font color="#D5D5D9">$</font><font color="#FFFFFF">$$</font><font color="#838392">$</font><font color="#FFFFFF">$$$</font><font color="#5A5A66">$</font><font color="#000021">$</font><font color="#3A3A50">$</font><font color="#FFFFFF">$$</font><font color="#CFCFD7">$</font><font color="#3A3A4A">$</font><font color="#000021">$</font><font color="#31313D">$$</font><font color="#000019">$</font><font color="#323244">$</font><font color="#383845">$</font><font color="#000021">$</font><font color="#3A3A50">$</font><font color="#424252">$<br>
</font><font color="#0E0E4A">$</font><font color="#71718E">$$</font><font color="#0E0E4A">$</font><font color="#71718E">$$</font><font color="#080842">$</font><font color="#636382">$$</font><font color="#00003A">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#52526B">$$</font><font color="#000033">$</font><font color="#52526B">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#52526B">$$</font><font color="#000033">$</font><font color="#59596B">$</font><font color="#C6C616">$</font><font color="#BEBE08">$</font><font color="#91913A">$</font><font color="#52526B">$</font><font color="#565622">$</font><font color="#D3D321">$</font><font color="#BEBE22">$</font><font color="#94940A">$</font><font color="#636319">$</font><font color="#535356">$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$</font><font color="#A4A410">$</font><font color="#858500">$</font><font color="#666600">$$</font><font color="#060624">$</font><font color="#4B4B5A">$</font><font color="#9C9C5B">$</font><font color="#D7D7AC">$</font><font color="#FFFFFF">$$$</font><font color="#636374">$</font><font color="#323244">$</font><font color="#636374">$</font><font color="#FFFFFF">$$</font><font color="#8D8D9B">$</font><font color="#3A3A4A">$$</font><font color="#101033">$</font><font color="#F5F5F6">$</font><font color="#C5C5CB">$</font><font color="#000029">$</font><font color="#CFCFD7">$</font><font color="#FFFFFF">$$</font><font color="#3A3A4A">$</font><font color="#A5A5AD">$</font><font color="#FFFFFF">$$</font><font color="#E8E8EB">$</font><font color="#101029">$</font><font color="#3A3A4A">$</font><font color="#FFFFFF">$$</font><font color="#CFCFD7">$</font><font color="#3A3A4A">$</font><font color="#000021">$</font><font color="#31313D">$$</font><font color="#000019">$</font><font color="#323244">$</font><font color="#383845">$</font><font color="#000021">$</font><font color="#41414D">$$<br>
</font><font color="#0E0E4A">$$$$$$</font><font color="#080842">$$</font><font color="#08083A">$$</font><font color="#000033">$$$$$$$$$$$$$$$$$$$$$$$$$</font><font color="#858527">$</font><font color="#CFCF10">$</font><font color="#C4C40C">$</font><font color="#08082E">$</font><font color="#000033">$</font><font color="#9B9B17">$</font><font color="#ADAD06">$</font><font color="#28281B">$</font><font color="#000033">$$$$$$$$$$$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$</font><font color="#08082A">$</font><font color="#39391B">$</font><font color="#858500">$</font><font color="#757502">$</font><font color="#000029">$</font><font color="#39391B">$</font><font color="#C5C55C">$</font><font color="#999933">$</font><font color="#B6B6B8">$</font><font color="#FFFFFF">$$</font><font color="#424252">$</font><font color="#000019">$</font><font color="#101029">$</font><font color="#EFEFF4">$</font><font color="#FFFFFF">$$</font><font color="#7B7B8E">$</font><font color="#525263">$</font><font color="#ADADB6">$</font><font color="#FFFFFF">$</font><font color="#42425A">$</font><font color="#000029">$</font><font color="#BDBDC5">$</font><font color="#FFFFFF">$$</font><font color="#000021">$$</font><font color="#CFCFD7">$</font><font color="#FFFFFF">$$</font><font color="#ADADB6">$</font><font color="#000021">$</font><font color="#FFFFFF">$$</font><font color="#CFCFD7">$</font><font color="#000021">$</font><font color="#000019">$$$$$</font><font color="#000021">$$$$<br>
</font><font color="#111140">$</font><font color="#71718E">$$</font><font color="#080842">$</font><font color="#6A6A8A">$$</font><font color="#08083A">$</font><font color="#6B6B84">$</font><font color="#636382">$</font><font color="#00003A">$</font><font color="#63637B">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#59596B">$$</font><font color="#000033">$</font><font color="#59596B">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#59596B">$$</font><font color="#D4D41B">$</font><font color="#DEDE14">$</font><font color="#B5B528">$</font><font color="#000033">$</font><font color="#59596B">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#BFBFCE">$</font><font color="#FFFFFF">$</font><font color="#525263">$</font><font color="#000029">$</font><font color="#4B4B5A">$$</font><font color="#101033">$</font><font color="#CCCC66">$</font><font color="#BEBE52">$</font><font color="#656523">$</font><font color="#52526B">$</font><font color="#E8E8EB">$</font><font color="#FFFFFF">$</font><font color="#696974">$</font><font color="#31313D">$</font><font color="#000019">$</font><font color="#5A5A66">$</font><font color="#E8E8EB">$</font><font color="#FFFFFF">$$$</font><font color="#EFEFF4">$</font><font color="#838392">$</font><font color="#424252">$</font><font color="#000021">$</font><font color="#CFCFD7">$</font><font color="#FFFFFF">$$</font><font color="#3A3A4A">$</font><font color="#323244">$</font><font color="#202036">$</font><font color="#EFEFF4">$</font><font color="#FFFFFF">$$</font><font color="#9C9CA4">$</font><font color="#CCCCCC">$</font><font color="#FFFFFF">$$$$$$</font><font color="#BDBDC5">$</font><font color="#323244">$</font><font color="#383845">$</font><font color="#000021">$</font><font color="#41414D">$$<br>
</font><font color="#080842">$</font><font color="#71718E">$$</font><font color="#080842">$</font><font color="#6B6B84">$$</font><font color="#08083A">$</font><font color="#636382">$$</font><font color="#000033">$</font><font color="#63637B">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#4A4A37">$</font><font color="#EEEE20">$$</font><font color="#939326">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#303051">$</font><font color="#7B7B8E">$</font><font color="#525263">$</font><font color="#000029">$</font><font color="#4B4B5A">$$</font><font color="#A6A671">$</font><font color="#C5C55C">$</font><font color="#999933">$</font><font color="#08082A">$</font><font color="#4A4A62">$</font><font color="#59596B">$</font><font color="#42425A">$$</font><font color="#323244">$</font><font color="#000019">$</font><font color="#323244">$</font><font color="#3A3A4A">$</font><font color="#303049">$</font><font color="#6C6C78">$$</font><font color="#000021">$</font><font color="#41414D">$$</font><font color="#000021">$</font><font color="#636374">$</font><font color="#6C6C78">$</font><font color="#42425A">$</font><font color="#3A3A4A">$</font><font color="#323244">$</font><font color="#000019">$</font><font color="#4B4B5A">$</font><font color="#636374">$</font><font color="#424252">$</font><font color="#5A5A66">$</font><font color="#383845">$</font><font color="#424252">$</font><font color="#696974">$$</font><font color="#424252">$</font><font color="#666666">$$</font><font color="#323244">$$</font><font color="#383845">$</font><font color="#000021">$</font><font color="#41414D">$$<br>
</font><font color="#08083A">$$$$$$$</font><font color="#000033">$$$$$$$$$</font><font color="#000029">$$$$$$$$$$$$$$$$$$$$$</font><font color="#8A8A34">$</font><font color="#F1F128">$</font><font color="#EEEE20">$</font><font color="#939326">$</font><font color="#000029">$$$$$$$$$$$$$$$$$</font><font color="#101033">$</font><font color="#A6A671">$</font><font color="#BCBC65">$</font><font color="#9B9B2A">$</font><font color="#1B1B20">$</font><font color="#000029">$$$</font><font color="#000021">$$$$$$$$$$$$$$$$$</font><font color="#000019">$$$$$$$$$$$$$$$$</font><font color="#000021">$$$<br>
</font><font color="#08083A">$</font><font color="#6B6B84">$$</font><font color="#08083A">$</font><font color="#6B6B84">$$</font><font color="#000033">$</font><font color="#63637B">$$</font><font color="#000033">$</font><font color="#5A5A73">$$</font><font color="#000029">$</font><font color="#59596B">$$</font><font color="#000029">$</font><font color="#59596B">$$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#52526B">$</font><font color="#B9B948">$</font><font color="#EEEE20">$$</font><font color="#CCCC33">$</font><font color="#101033">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#525263">$$</font><font color="#282842">$</font><font color="#B9B96E">$</font><font color="#B4B45C">$</font><font color="#939326">$</font><font color="#53533B">$</font><font color="#525263">$</font><font color="#000029">$</font><font color="#525263">$$</font><font color="#000021">$</font><font color="#424252">$$</font><font color="#000021">$</font><font color="#3A3A4A">$$</font><font color="#000021">$</font><font color="#41414D">$$</font><font color="#000021">$</font><font color="#3A3A50">$$</font><font color="#000021">$</font><font color="#424252">$$</font><font color="#000021">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#383845">$$</font><font color="#000019">$</font><font color="#383845">$$</font><font color="#000019">$</font><font color="#383845">$$</font><font color="#000019">$</font><font color="#31313D">$$</font><font color="#000019">$</font><font color="#323244">$$</font><font color="#000019">$</font><font color="#3A3A4A">$</font><font color="#41414D">$<br>
</font><font color="#08083A">$</font><font color="#6B6B84">$$</font><font color="#000033">$</font><font color="#63637B">$</font><font color="#9494A1">$</font><font color="#BFBFCE">$</font><font color="#CFCFD7">$</font><font color="#83839C">$</font><font color="#000029">$</font><font color="#5A5A73">$$</font><font color="#63637B">$</font><font color="#D5D5D9">$</font><font color="#737384">$</font><font color="#000029">$</font><font color="#9494A1">$</font><font color="#D5D5D9">$</font><font color="#303051">$</font><font color="#52526B">$$</font><font color="#101033">$</font><font color="#BDBDC5">$</font><font color="#D5D5D9">$</font><font color="#A5A5AD">$</font><font color="#636374">$</font><font color="#52526B">$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#767626">$</font><font color="#F1F128">$$</font><font color="#DFDF23">$</font><font color="#95954F">$</font><font color="#52526B">$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#000029">$</font><font color="#59596B">$</font><font color="#A6A671">$</font><font color="#C5C55C">$</font><font color="#91913A">$</font><font color="#767626">$</font><font color="#18181E">$</font><font color="#4A4A62">$</font><font color="#525263">$</font><font color="#000029">$</font><font color="#9494A1">$</font><font color="#CCCCCC">$</font><font color="#ADADB6">$$</font><font color="#59596B">$</font><font color="#000021">$</font><font color="#424252">$$</font><font color="#000021">$</font><font color="#424252">$$</font><font color="#000021">$</font><font color="#41414D">$$</font><font color="#000021">$</font><font color="#424252">$$</font><font color="#000021">$</font><font color="#424252">$$</font><font color="#000021">$</font><font color="#41414D">$$</font><font color="#000021">$</font><font color="#3A3A4A">$$</font><font color="#000019">$</font><font color="#383845">$$</font><font color="#000019">$</font><font color="#31313D">$</font><font color="#4B4B5A">$</font><font color="#6C6C78">$</font><font color="#323244">$$</font><font color="#000019">$</font><font color="#3A3A4A">$$<br>
</font><font color="#08083A">$</font><font color="#000033">$$$</font><font color="#525273">$</font><font color="#CFCFD7">$</font><font color="#525273">$</font><font color="#63637B">$</font><font color="#EFEFF4">$</font><font color="#202040">$</font><font color="#000029">$$</font><font color="#838392">$</font><font color="#DDDDE5">$</font><font color="#838392">$</font><font color="#000029">$</font><font color="#BFBFCE">$</font><font color="#DDDDE5">$</font><font color="#42425A">$</font><font color="#000029">$$</font><font color="#737384">$</font><font color="#AEAEC0">$</font><font color="#42425A">$</font><font color="#9494A1">$</font><font color="#52526B">$</font><font color="#000029">$$$$$$$$$$$$$$</font><font color="#333333">$</font><font color="#C6C616">$</font><font color="#DEDE14">$</font><font color="#E5E517">$</font><font color="#DFDF23">$</font><font color="#8A8A34">$</font><font color="#3B3B38">$</font><font color="#000029">$$$$$</font><font color="#101033">$</font><font color="#535356">$</font><font color="#9C9C5B">$</font><font color="#E6E663">$</font><font color="#CBCB52">$</font><font color="#9B9B2A">$</font><font color="#444412">$</font><font color="#060624">$</font><font color="#000021">$$$$</font><font color="#838392">$</font><font color="#9C9CAA">$</font><font color="#3A3A50">$</font><font color="#838392">$</font><font color="#9C9CA4">$</font><font color="#000021">$</font><font color="#101033">$</font><font color="#3A3A50">$</font><font color="#1A1A35">$</font><font color="#000021">$</font><font color="#282842">$</font><font color="#101029">$</font><font color="#000021">$</font><font color="#282842">$</font><font color="#000021">$</font><font color="#1A1A35">$$</font><font color="#000021">$</font><font color="#3A3A50">$</font><font color="#1A1A35">$</font><font color="#000021">$</font><font color="#101029">$</font><font color="#282842">$</font><font color="#3A3A50">$</font><font color="#101029">$</font><font color="#1A1A35">$</font><font color="#303049">$</font><font color="#000019">$$</font><font color="#101029">$</font><font color="#323244">$</font><font color="#424252">$</font><font color="#9C9CA4">$</font><font color="#000019">$$$$$<br>
</font><font color="#000033">$</font><font color="#63637B">$$</font><font color="#000033">$</font><font color="#CFCFD7">$</font><font color="#9494A1">$</font><font color="#000029">$</font><font color="#5A5A73">$</font><font color="#6B6B84">$</font><font color="#000029">$</font><font color="#59596B">$$</font><font color="#838392">$</font><font color="#B5B5BC">$</font><font color="#DDDDE0">$</font><font color="#101033">$</font><font color="#DDDDE0">$</font><font color="#D5D5D9">$</font><font color="#42425A">$</font><font color="#525263">$$$</font><font color="#F5F5F6">$</font><font color="#B5B5BC">$</font><font color="#303051">$</font><font color="#525263">$$</font><font color="#000021">$</font><font color="#525263">$$</font><font color="#000021">$</font><font color="#525263">$$</font><font color="#000021">$</font><font color="#525263">$$</font><font color="#000021">$</font><font color="#525263">$$</font><font color="#000021">$</font><font color="#525263">$$</font><font color="#636319">$</font><font color="#C6C616">$</font><font color="#DEDE14">$</font><font color="#E3E323">$$$</font><font color="#B5B528">$</font><font color="#B9B936">$</font><font color="#BEBE48">$</font><font color="#D0D047">$</font><font color="#E6E656">$$</font><font color="#DFDF46">$</font><font color="#B9B936">$</font><font color="#858527">$</font><font color="#28281B">$</font><font color="#4B4B5A">$$</font><font color="#000021">$</font><font color="#4A4A62">$$</font><font color="#000021">$</font><font color="#A5A5AD">$</font><font color="#BDBDC5">$</font><font color="#42425A">$</font><font color="#ADADB6">$</font><font color="#BDBDC5">$</font><font color="#202036">$</font><font color="#D5D5D9">$</font><font color="#9C9CA4">$</font><font color="#BDBDC5">$</font><font color="#7A7A86">$</font><font color="#8D8D9B">$</font><font color="#838392">$</font><font color="#636374">$</font><font color="#D5D5D9">$</font><font color="#000021">$</font><font color="#CCCCCC">$</font><font color="#696974">$</font><font color="#BDBDC5">$</font><font color="#A5A5AD">$</font><font color="#CCCCCC">$</font><font color="#4A4A62">$</font><font color="#6C6C78">$</font><font color="#DDDDE0">$</font><font color="#737384">$$</font><font color="#C5C5CB">$</font><font color="#7B7B8E">$</font><font color="#BDBDC5">$</font><font color="#41414D">$</font><font color="#B6B6B8">$</font><font color="#999999">$</font><font color="#B6B6B8">$</font><font color="#A5A5AD">$</font><font color="#3A3A4A">$$</font><font color="#000019">$</font><font color="#3A3A4A">$</font><font color="#41414D">$<br>
</font><font color="#000033">$</font><font color="#63637B">$$</font><font color="#000029">$</font><font color="#D6D6DE">$</font><font color="#838392">$</font><font color="#000029">$</font><font color="#59596B">$</font><font color="#6C6C78">$</font><font color="#000029">$</font><font color="#52526B">$$</font><font color="#838392">$</font><font color="#A5A5B4">$</font><font color="#D5D5D9">$</font><font color="#636374">$</font><font color="#A5A5AD">$</font><font color="#D5D5D9">$</font><font color="#42425A">$</font><font color="#4A4A62">$$</font><font color="#000021">$</font><font color="#7A7A86">$</font><font color="#BDBDC5">$</font><font color="#EFEFF4">$</font><font color="#A5A5AD">$</font><font color="#4A4A62">$</font><font color="#000021">$</font><font color="#4A4A62">$$</font><font color="#000021">$</font><font color="#4A4A62">$$</font><font color="#000021">$</font><font color="#4A4A62">$$</font><font color="#000021">$</font><font color="#4A4A62">$$</font><font color="#000021">$</font><font color="#4A4A62">$$</font><font color="#000021">$</font><font color="#4A4A62">$</font><font color="#787847">$</font><font color="#656523">$</font><font color="#ABAB25">$</font><font color="#C6C616">$$$$$</font><font color="#B5B528">$</font><font color="#999933">$</font><font color="#565622">$</font><font color="#484854">$</font><font color="#4B4B5A">$</font><font color="#000021">$</font><font color="#4B4B5A">$$</font><font color="#000021">$</font><font color="#4B4B5A">$$</font><font color="#000021">$</font><font color="#A5A5AD">$</font><font color="#E8E8EB">$</font><font color="#BDBDC5">$</font><font color="#C5C5CB">$</font><font color="#525263">$</font><font color="#7B7B8E">$</font><font color="#ADADB6">$</font><font color="#4B4B5A">$$</font><font color="#CCCCCC">$</font><font color="#636374">$</font><font color="#C5C5CB">$</font><font color="#9C9CA4">$</font><font color="#ADADB6">$</font><font color="#4A4A62">$</font><font color="#DDDDE0">$</font><font color="#737384">$</font><font color="#D5D5D9">$</font><font color="#9C9CAA">$</font><font color="#B5B5BC">$</font><font color="#A5A5B4">$</font><font color="#737384">$</font><font color="#CCCCCC">$</font><font color="#000021">$</font><font color="#C5C5CB">$</font><font color="#B6B6B8">$</font><font color="#7A7A86">$</font><font color="#D5D5D9">$</font><font color="#8C8C94">$</font><font color="#B5B5BC">$</font><font color="#41414D">$</font><font color="#696974">$</font><font color="#B6B6B8">$</font><font color="#3A3A4A">$$</font><font color="#000019">$</font><font color="#41414D">$$<br>
</font><font color="#000029">$$$$</font><font color="#838392">$</font><font color="#AEAEC0">$</font><font color="#101033">$</font><font color="#303051">$</font><font color="#EFEFF4">$</font><font color="#202040">$</font><font color="#000021">$$</font><font color="#838392">$$</font><font color="#737384">$</font><font color="#CFCFD7">$</font><font color="#303049">$</font><font color="#BDBDC5">$</font><font color="#42425A">$</font><font color="#000021">$$</font><font color="#838392">$</font><font color="#636374">$</font><font color="#000021">$</font><font color="#52526B">$</font><font color="#BDBDC5">$</font><font color="#000021">$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$</font><font color="#838392">$$</font><font color="#000021">$$$</font><font color="#6B6B84">$</font><font color="#9C9CAA">$</font><font color="#000021">$</font><font color="#636374">$</font><font color="#ADADB6">$</font><font color="#000021">$</font><font color="#CCCCCC">$</font><font color="#BDBDC5">$</font><font color="#303049">$</font><font color="#CCCCCC">$</font><font color="#8D8D9B">$</font><font color="#303049">$</font><font color="#DDDDE0">$</font><font color="#42425A">$$</font><font color="#303049">$</font><font color="#42425A">$</font><font color="#BDBDC5">$</font><font color="#000021">$</font><font color="#ADADB6">$</font><font color="#7B7B8E">$</font><font color="#424252">$$$</font><font color="#CCCCCC">$</font><font color="#000019">$</font><font color="#4A4A62">$</font><font color="#B5B5BC">$</font><font color="#000019">$$$$$<br>
</font><font color="#000029">$</font><font color="#636374">$$</font><font color="#000029">$</font><font color="#59596B">$</font><font color="#B5B5BC">$</font><font color="#FFFFFF">$</font><font color="#F5F5F6">$</font><font color="#9494A1">$</font><font color="#000021">$</font><font color="#D5D5D9">$</font><font color="#7A7A86">$</font><font color="#838392">$</font><font color="#A5A5AD">$</font><font color="#636374">$</font><font color="#DDDDE5">$</font><font color="#4B4B5A">$</font><font color="#CFCFD7">$</font><font color="#42425A">$</font><font color="#CFCFD7">$</font><font color="#737384">$</font><font color="#303049">$</font><font color="#E8E8EB">$</font><font color="#FFFFFF">$</font><font color="#EFEFF4">$</font><font color="#838392">$</font><font color="#737384">$</font><font color="#BDBDC5">$</font><font color="#484854">$$</font><font color="#000021">$</font><font color="#484854">$$</font><font color="#000021">$</font><font color="#484854">$$</font><font color="#000021">$</font><font color="#484854">$$</font><font color="#000021">$</font><font color="#484854">$$</font><font color="#000021">$</font><font color="#484854">$$</font><font color="#000021">$</font><font color="#484854">$$</font><font color="#000021">$</font><font color="#484854">$$</font><font color="#000021">$</font><font color="#484854">$$</font><font color="#000021">$</font><font color="#484854">$$</font><font color="#000021">$</font><font color="#484854">$$</font><font color="#000021">$</font><font color="#484854">$$</font><font color="#000021">$</font><font color="#A5A5AD">$$</font><font color="#000021">$</font><font color="#484854">$$</font><font color="#101029">$</font><font color="#CFCFD7">$$$</font><font color="#6C6C78">$</font><font color="#484854">$</font><font color="#737384">$</font><font color="#BDBDC5">$</font><font color="#484854">$</font><font color="#DDDDE5">$</font><font color="#6C6C78">$</font><font color="#484854">$</font><font color="#8D8D9B">$</font><font color="#DDDDE0">$$</font><font color="#636374">$</font><font color="#737384">$</font><font color="#CFCFD7">$</font><font color="#000021">$</font><font color="#696974">$</font><font color="#DDDDE0">$</font><font color="#BDBDC5">$</font><font color="#CFCFD7">$</font><font color="#4B4B5A">$</font><font color="#9C9CAA">$</font><font color="#DDDDE0">$</font><font color="#CFCFD7">$</font><font color="#BDBDC5">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$<br>
</font><font color="#000029">$</font><font color="#5A5A73">$$</font><font color="#000021">$</font><font color="#59596B">$$</font><font color="#000021">$</font><font color="#525263">$$</font><font color="#000021">$</font><font color="#4B4B5A">$$</font><font color="#000021">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#9494A1">$</font><font color="#5A5A66">$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$</font><font color="#525263">$</font><font color="#838392">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$<br>
</font><font color="#000029">$</font><font color="#000021">$$$$$$$$$$</font><font color="#000019">$$$$$$$$</font><font color="#101029">$</font><font color="#000019">$$$$$$$</font><font color="#101029">$</font><font color="#000019">$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$<br>
</font><font color="#000021">$</font><font color="#59596B">$$</font><font color="#000021">$</font><font color="#525263">$$</font><font color="#000021">$</font><font color="#4B4B5A">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#424252">$$<br>
</font><font color="#000021">$</font><font color="#59596B">$$</font><font color="#000021">$</font><font color="#525263">$$</font><font color="#000019">$</font><font color="#4B4B5A">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#424252">$$<br>
</font><font color="#000021">$$$$$</font><font color="#000019">$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$<br>
$</font><font color="#5A5A66">$$</font><font color="#000019">$</font><font color="#525263">$$</font><font color="#000019">$</font><font color="#4B4B5A">$$</font><font color="#000019">$</font><font color="#484854">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#41414D">$$</font><font color="#000019">$</font><font color="#424252">$$</font><font color="#000019">$</font><font color="#484854">$$<br>
</font>
</span>
<BR>

<style type="text/css">.asciiimage{
        color           : #000000;
        background-color: #FFFFFF;
        font-size       : 6px;
        font-family     : "Courier New", Courier, mono;
        line-height     : 4px;
        letter-spacing  : 0px;
    }</style><span class="asciiimage"><font color="#8C8C8C">@</font><font color="#948F94">@</font><font color="#999999">@@@@@@@</font><font color="#948F94">@</font><font color="#8C8C8C">@@@</font><font color="#848484">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#7B767B">@@@@@@</font><font color="#746C74">@@@@@@<br>
</font><font color="#948F94">@</font><font color="#BDBDBD">@</font><font color="#C5C5C5">@</font><font color="#A6A6A6">@</font><font color="#CCCCCC">@@</font><font color="#A6A6A6">@</font><font color="#C5C5C5">@</font><font color="#BDBDBD">@</font><font color="#999999">@</font><font color="#BBB5BB">@@</font><font color="#8C8C8C">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@</font><font color="#A6A6A6">@</font><font color="#7B767B">@</font><font color="#A6A6A6">@@</font><font color="#7B767B">@</font><font color="#999999">@@</font><font color="#746C74">@</font><font color="#948F94">@@</font><font color="#666666">@</font><font color="#8C8C8C">@@<br>
</font><font color="#999999">@</font><font color="#C5C5C5">@</font><font color="#CCCCCC">@</font><font color="#B4B2B4">@</font><font color="#DFDDCB">@</font><font color="#F7F7C6">@</font><font color="#FFFFCC">@@</font><font color="#DFDDCB">@</font><font color="#999999">@</font><font color="#BBB5BB">@@</font><font color="#8C8C8C">@</font><font color="#B4B2B4">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#8C8C8C">@</font><font color="#D2CFB2">@</font><font color="#ADADAD">@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#C3BDA9">@</font><font color="#FFFFCC">@</font><font color="#ADADAD">@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@</font><font color="#FFFFCC">@</font><font color="#C3BDA9">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@</font><font color="#FFFFCC">@</font><font color="#C3BDA9">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#A6A6A6">@@</font><font color="#7B767B">@</font><font color="#A6A6A6">@@</font><font color="#7B767B">@</font><font color="#999999">@@</font><font color="#746C74">@</font><font color="#948F94">@@</font><font color="#666666">@</font><font color="#8C8C8C">@@<br>
</font><font color="#A59CA5">@</font><font color="#A6A6A6">@</font><font color="#B4B2B4">@</font><font color="#C6C3B6">@</font><font color="#FFFFCC">@</font><font color="#E6E6C6">@</font><font color="#C6C3B6">@</font><font color="#DFDCBF">@</font><font color="#FFFFCC">@</font><font color="#B7AFAD">@</font><font color="#999999">@</font><font color="#948F94">@@</font><font color="#8C8C8C">@@</font><font color="#848484">@@@@@@@@@</font><font color="#DAD9B6">@</font><font color="#DFDCBF">@</font><font color="#848484">@@@@@@@</font><font color="#948F94">@</font><font color="#A59D98">@</font><font color="#848484">@@@@@@@@@@@@@@@@@@</font><font color="#FFFFCC">@</font><font color="#C3BDA9">@</font><font color="#848484">@@@@</font><font color="#FFFFCC">@</font><font color="#C3BDA9">@</font><font color="#848484">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#7B767B">@@@</font><font color="#746C74">@@@@</font><font color="#666666">@@@@@<br>
</font><font color="#A59CA5">@</font><font color="#CCCCCC">@@@</font><font color="#FFFFCC">@</font><font color="#ECECD2">@</font><font color="#BDBDBD">@</font><font color="#CCCCCC">@</font><font color="#E6E6C6">@</font><font color="#BFBCB5">@@</font><font color="#EFEEC5">@</font><font color="#C0B6A6">@</font><font color="#B4B2B4">@</font><font color="#BFBCB5">@</font><font color="#E7E0BE">@</font><font color="#BFBCB5">@</font><font color="#B7AFAD">@</font><font color="#DFDCBF">@</font><font color="#FFFFCC">@@</font><font color="#CAC6AE">@</font><font color="#ADADAD">@</font><font color="#C6C3B6">@</font><font color="#F7F7C6">@@</font><font color="#DFDCBF">@</font><font color="#B4ADA0">@</font><font color="#F7F7C6">@</font><font color="#FFFFCC">@</font><font color="#EFE5C2">@</font><font color="#B4B2B4">@</font><font color="#ADADAD">@</font><font color="#B4ADA0">@</font><font color="#EFEEC5">@</font><font color="#ADADAD">@</font><font color="#B4ADA0">@</font><font color="#DFDCBF">@@</font><font color="#FFFFCC">@</font><font color="#F7F7C6">@</font><font color="#BFBCB5">@</font><font color="#848484">@</font><font color="#BFBCB5">@</font><font color="#F7F7C6">@</font><font color="#FFFFCC">@</font><font color="#EFEEC5">@</font><font color="#B7AFAD">@</font><font color="#848484">@</font><font color="#BFBCB5">@</font><font color="#F7F7C6">@</font><font color="#FFFFCC">@</font><font color="#DFDCBF">@</font><font color="#FFFFCC">@</font><font color="#C3BDA9">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@</font><font color="#FFFFCC">@</font><font color="#DAD9B6">@</font><font color="#F7F7C6">@</font><font color="#FFFFCC">@</font><font color="#CAC6AE">@</font><font color="#ADADAD">@</font><font color="#D6D3BC">@</font><font color="#D2CFB2">@</font><font color="#ADADAD">@@</font><font color="#C0B6A6">@</font><font color="#E6E6C6">@</font><font color="#ADADAD">@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#848484">@</font><font color="#ADADAD">@@</font><font color="#847A84">@</font><font color="#A6A6A6">@@</font><font color="#7B767B">@</font><font color="#A59CA5">@@</font><font color="#746C74">@</font><font color="#948F94">@@</font><font color="#736373">@</font><font color="#8C8C8C">@@</font><font color="#666666">@</font><font color="#848484">@@<br>
</font><font color="#A59CA5">@</font><font color="#C5C5C5">@</font><font color="#CCCCCC">@</font><font color="#BDBDBD">@</font><font color="#F7F7C6">@</font><font color="#FFFFCC">@@</font><font color="#F1F0CE">@</font><font color="#DFDDCB">@</font><font color="#A59CA5">@</font><font color="#BDBDBD">@</font><font color="#FFFFCC">@</font><font color="#CAC6AE">@</font><font color="#B4B2B4">@</font><font color="#C6C3B6">@</font><font color="#FFFFCC">@</font><font color="#BFBCB5">@</font><font color="#D6D3BC">@</font><font color="#FFFFCC">@</font><font color="#C6C3B6">@</font><font color="#D6D3BC">@</font><font color="#D2CFB2">@</font><font color="#ADADAD">@</font><font color="#BFBCB5">@</font><font color="#EFEEC5">@</font><font color="#F7F7C6">@</font><font color="#C6C3B6">@</font><font color="#EFE5C2">@</font><font color="#DCD5BC">@</font><font color="#C6C3B6">@</font><font color="#FFFFCC">@</font><font color="#D6D3BC">@</font><font color="#ADADAD">@</font><font color="#C3BDA9">@</font><font color="#FFFFCC">@</font><font color="#ADADAD">@</font><font color="#C3BDA9">@</font><font color="#FFFFCC">@</font><font color="#DCD5BC">@</font><font color="#ACA49C">@</font><font color="#F7F7C6">@</font><font color="#E6E6C6">@</font><font color="#847A84">@</font><font color="#F7F7C6">@</font><font color="#E6E6C6">@</font><font color="#A59D98">@</font><font color="#EFEEC5">@</font><font color="#E6E6C6">@</font><font color="#847A84">@</font><font color="#E6E6C6">@</font><font color="#F7F7C6">@</font><font color="#ACA49C">@</font><font color="#DFDCBF">@</font><font color="#FFFFCC">@</font><font color="#C3BDA9">@</font><font color="#ADADAD">@@</font><font color="#847A84">@</font><font color="#ADADAD">@</font><font color="#FFFFCC">@</font><font color="#F7F7C6">@</font><font color="#C6C3B6">@</font><font color="#DFDCBF">@</font><font color="#FFFFCC">@</font><font color="#BFBCB5">@</font><font color="#C6C3B6">@</font><font color="#FFFFCC">@</font><font color="#B7AFAD">@</font><font color="#ADADAD">@</font><font color="#EFEEC5">@</font><font color="#DFDCBF">@</font><font color="#ADADAD">@</font><font color="#847A84">@</font><font color="#ADADAD">@@</font><font color="#847A84">@</font><font color="#ADADAD">@@</font><font color="#847A84">@</font><font color="#ADADAD">@@</font><font color="#847A84">@</font><font color="#ADADAD">@@</font><font color="#847A84">@</font><font color="#ADADAD">@@</font><font color="#847A84">@</font><font color="#A6A6A6">@@</font><font color="#7B767B">@</font><font color="#999999">@@</font><font color="#746C74">@</font><font color="#948F94">@@</font><font color="#666666">@</font><font color="#8C848C">@</font><font color="#848484">@</font><font color="#666666">@</font><font color="#847A84">@@<br>
</font><font color="#A595A5">@</font><font color="#ADA1AD">@</font><font color="#B5A5B5">@</font><font color="#BBB5BB">@@</font><font color="#D6D3BC">@</font><font color="#E6E6C6">@</font><font color="#F7F7C6">@</font><font color="#FFFFCC">@</font><font color="#D6D3BC">@</font><font color="#999999">@</font><font color="#FFFFCC">@</font><font color="#CAC6AE">@</font><font color="#8C848C">@</font><font color="#A59D98">@</font><font color="#FFFFCC">@</font><font color="#A59D98">@</font><font color="#ACA49C">@</font><font color="#FFFFCC">@</font><font color="#F7F7C6">@</font><font color="#DAD9B6">@</font><font color="#B4ADA0">@</font><font color="#847A84">@@</font><font color="#DFDCBF">@@</font><font color="#847A84">@</font><font color="#8C848C">@</font><font color="#B4ADA0">@</font><font color="#CAC6AE">@</font><font color="#FFFFCC">@</font><font color="#C3BDA9">@</font><font color="#847A84">@</font><font color="#C3BDA9">@</font><font color="#FFFFCC">@</font><font color="#847A84">@</font><font color="#C3BDA9">@</font><font color="#FFFFCC">@</font><font color="#847A84">@@</font><font color="#DFDCBF">@@</font><font color="#A59D98">@</font><font color="#FFFFCC">@</font><font color="#D2CFB2">@</font><font color="#C3BDA9">@</font><font color="#DFDCBF">@</font><font color="#FFFFCC">@</font><font color="#847A84">@</font><font color="#FFFFCC">@</font><font color="#C3BDA9">@</font><font color="#847A84">@@</font><font color="#FFFFCC">@</font><font color="#C3BDA9">@</font><font color="#847A84">@@@@</font><font color="#FFFFCC">@</font><font color="#C3BDA9">@</font><font color="#847A84">@@</font><font color="#FFFFCC">@</font><font color="#C3BDA9">@</font><font color="#847A84">@</font><font color="#F7F7C6">@</font><font color="#C0B6A6">@</font><font color="#A19595">@</font><font color="#FFFFCC">@</font><font color="#A19595">@</font><font color="#847A84">@@@@@@@@@@@@@@@@@@</font><font color="#7B767B">@@@</font><font color="#746C74">@@@</font><font color="#6B5B6B">@@@@</font><font color="#625262">@@@<br>
</font><font color="#9C8D9C">@</font><font color="#C7BEC7">@@</font><font color="#C9BFB6">@</font><font color="#F1F0CE">@</font><font color="#D4D4D4">@</font><font color="#BBB5BB">@</font><font color="#CCCCCC">@</font><font color="#F7F7C6">@</font><font color="#E6E6C6">@</font><font color="#BBB5BB">@</font><font color="#FFFFCC">@</font><font color="#CAC6AE">@</font><font color="#ADADAD">@</font><font color="#BFBCB5">@</font><font color="#FFFFCC">@</font><font color="#BFBCB5">@</font><font color="#A6A6A6">@</font><font color="#948F94">@</font><font color="#D6D3BC">@</font><font color="#EFEEC5">@</font><font color="#FFFFCC">@</font><font color="#C6C3B6">@</font><font color="#A6A6A6">@</font><font color="#DFDCBF">@</font><font color="#E6E6C6">@</font><font color="#ADADAD">@</font><font color="#F7F7C6">@</font><font color="#E7E0BE">@</font><font color="#C6C3B6">@</font><font color="#FFFFCC">@</font><font color="#D6D3BC">@</font><font color="#A6A6A6">@</font><font color="#C3BDA9">@</font><font color="#FFFFCC">@</font><font color="#A6A6A6">@</font><font color="#C3BDA9">@</font><font color="#FFFFCC">@</font><font color="#A6A6A6">@</font><font color="#857484">@</font><font color="#E6E6C6">@@</font><font color="#A19595">@</font><font color="#FFFFCC">@</font><font color="#DFDCBF">@</font><font color="#C3BDA9">@</font><font color="#D6D3BC">@@</font><font color="#857484">@</font><font color="#FFFFCC">@</font><font color="#D6D3BC">@</font><font color="#857484">@</font><font color="#A6A6A6">@</font><font color="#FFFFCC">@</font><font color="#C3BDA9">@</font><font color="#A6A6A6">@@</font><font color="#857484">@</font><font color="#A6A6A6">@</font><font color="#FFFFCC">@</font><font color="#CAC6AE">@</font><font color="#A6A6A6">@@</font><font color="#FFFFCC">@</font><font color="#D6D3BC">@</font><font color="#A6A6A6">@</font><font color="#D2CFB2">@</font><font color="#EFEEC5">@</font><font color="#DCD5BC">@</font><font color="#EFEEC5">@</font><font color="#A6A6A6">@@</font><font color="#857484">@</font><font color="#A6A6A6">@@</font><font color="#857484">@</font><font color="#A6A6A6">@@</font><font color="#857484">@</font><font color="#A6A6A6">@@</font><font color="#857484">@</font><font color="#A6A6A6">@@</font><font color="#857484">@</font><font color="#A59CA5">@@</font><font color="#857484">@</font><font color="#A59CA5">@@</font><font color="#7B6B7B">@</font><font color="#999999">@</font><font color="#948F94">@</font><font color="#736373">@</font><font color="#8C8C8C">@</font><font color="#8C848C">@</font><font color="#6B5B6B">@</font><font color="#847A84">@@</font><font color="#625262">@</font><font color="#7B767B">@@<br>
</font><font color="#9C8D9C">@</font><font color="#BDBDBD">@</font><font color="#C7BEC7">@</font><font color="#B7AFAD">@</font><font color="#FFFFCC">@</font><font color="#F1F0CE">@</font><font color="#C9BFB6">@</font><font color="#DFDDCB">@</font><font color="#FFFFCC">@</font><font color="#DCD5BC">@</font><font color="#B4B2B4">@</font><font color="#FFFFCC">@</font><font color="#EFE5C2">@</font><font color="#BFBCB5">@</font><font color="#E6E6C6">@</font><font color="#FFFFCC">@</font><font color="#BFBCB5">@</font><font color="#D2C4B3">@</font><font color="#F7F7C6">@</font><font color="#BFBCB5">@@</font><font color="#FFFFCC">@</font><font color="#D2C4B3">@</font><font color="#A59CA5">@</font><font color="#DFDCBF">@</font><font color="#EFEEC5">@</font><font color="#D6D3BC">@</font><font color="#FFFFCC">@</font><font color="#D6D3BC">@</font><font color="#D2C4B3">@</font><font color="#FFFFCC">@</font><font color="#D6D3BC">@</font><font color="#A59CA5">@</font><font color="#C0B6A6">@</font><font color="#FFFFCC">@</font><font color="#A59CA5">@</font><font color="#C0B6A6">@</font><font color="#FFFFCC">@</font><font color="#A59CA5">@</font><font color="#857484">@</font><font color="#E6E6C6">@@</font><font color="#857484">@</font><font color="#F7F7C6">@</font><font color="#E6E6C6">@</font><font color="#A19595">@</font><font color="#D6D3BC">@@</font><font color="#857484">@</font><font color="#E7E0BE">@</font><font color="#F7F7C6">@</font><font color="#A59D98">@</font><font color="#DFDCBF">@</font><font color="#FFFFCC">@</font><font color="#C0B6A6">@</font><font color="#A59CA5">@@</font><font color="#857484">@</font><font color="#A59CA5">@</font><font color="#FFFFCC">@</font><font color="#F7F7C6">@</font><font color="#BFBCB5">@</font><font color="#DFDCBF">@</font><font color="#FFFFCC">@</font><font color="#B7AFAD">@</font><font color="#A59CA5">@</font><font color="#948F94">@</font><font color="#FFFFCC">@</font><font color="#F5F0C5">@</font><font color="#B4ADA0">@</font><font color="#A59CA5">@@</font><font color="#857484">@</font><font color="#A59CA5">@@</font><font color="#857484">@</font><font color="#A59CA5">@@</font><font color="#857484">@</font><font color="#A59CA5">@@</font><font color="#857484">@</font><font color="#A59CA5">@@</font><font color="#857484">@</font><font color="#A59CA5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#948F94">@@</font><font color="#736373">@</font><font color="#8C848C">@@</font><font color="#6B5B6B">@</font><font color="#7B767B">@@</font><font color="#625262">@</font><font color="#7B767B">@@<br>
</font><font color="#9C849C">@@</font><font color="#A595A5">@@</font><font color="#C9BFB6">@</font><font color="#F5F0C5">@</font><font color="#FFFFCC">@@</font><font color="#DCD5BC">@</font><font color="#9C8D9C">@</font><font color="#948594">@</font><font color="#B4ADA0">@</font><font color="#F7F7C6">@</font><font color="#FFFFCC">@</font><font color="#CAC6AE">@</font><font color="#FFFFCC">@</font><font color="#A19595">@</font><font color="#857484">@</font><font color="#D2CFB2">@</font><font color="#FFFFCC">@@</font><font color="#D2C4B3">@</font><font color="#857484">@</font><font color="#836B83">@</font><font color="#B4ADA0">@</font><font color="#FFFFCC">@</font><font color="#D2CFB2">@</font><font color="#DFDCBF">@</font><font color="#FFFFCC">@</font><font color="#DFDCBF">@</font><font color="#D2CFB2">@</font><font color="#DFDCBF">@</font><font color="#836B83">@</font><font color="#C0B6A6">@</font><font color="#FFFFCC">@</font><font color="#836B83">@</font><font color="#C0B6A6">@</font><font color="#FFFFCC">@</font><font color="#836B83">@@</font><font color="#DFDCBF">@@</font><font color="#836B83">@</font><font color="#948594">@</font><font color="#EFEEC5">@</font><font color="#FFFFCC">@</font><font color="#EFEEC5">@</font><font color="#A59D98">@</font><font color="#836B83">@</font><font color="#857484">@</font><font color="#DFDCBF">@</font><font color="#FFFFCC">@</font><font color="#DFDCBF">@</font><font color="#E7E0BE">@</font><font color="#C0B6A6">@</font><font color="#836B83">@@@@</font><font color="#FFFFCC">@</font><font color="#D2C4B3">@</font><font color="#F7F7C6">@@</font><font color="#B4ADA0">@</font><font color="#836B83">@@@</font><font color="#EFEEC5">@</font><font color="#FFFFCC">@</font><font color="#8E7C8E">@</font><font color="#836B83">@@@@@@@@@@@@@@@@</font><font color="#7B6B7B">@@@@@</font><font color="#736373">@@</font><font color="#6B5B6B">@@@</font><font color="#625262">@@@@@@<br>
</font><font color="#9C849C">@</font><font color="#BBB5BB">@@</font><font color="#9C8D9C">@</font><font color="#C6B4C6">@@</font><font color="#A68DA6">@</font><font color="#BBB5BB">@@</font><font color="#948594">@</font><font color="#B5A5B5">@</font><font color="#ADA1AD">@</font><font color="#857484">@</font><font color="#A59CA5">@@</font><font color="#836B83">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#857484">@</font><font color="#F5F0C5">@</font><font color="#DFDCBF">@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#A595A5">@@</font><font color="#7B6B7B">@</font><font color="#9C8D9C">@@</font><font color="#736373">@</font><font color="#948594">@@</font><font color="#6B5B6B">@</font><font color="#847A84">@@</font><font color="#625262">@</font><font color="#7B767B">@@</font><font color="#5B495B">@</font><font color="#746C74">@@<br>
</font><font color="#947A94">@</font><font color="#BAA7BA">@@</font><font color="#9C849C">@</font><font color="#BBB5BB">@@</font><font color="#9C849C">@</font><font color="#BAA7BA">@</font><font color="#B5A5B5">@</font><font color="#8E7C8E">@</font><font color="#ADA1AD">@@</font><font color="#836B83">@</font><font color="#A595A5">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@</font><font color="#B7AFAD">@</font><font color="#FFFFCC">@@</font><font color="#B7AFAD">@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#735A73">@</font><font color="#948594">@</font><font color="#8C848C">@</font><font color="#6B5B6B">@</font><font color="#847A84">@@</font><font color="#625262">@</font><font color="#7B6B7B">@</font><font color="#746C74">@</font><font color="#5B495B">@</font><font color="#746C74">@@<br>
</font><font color="#947A94">@@@</font><font color="#997899">@@@</font><font color="#947A94">@@@</font><font color="#8C738C">@@</font><font color="#836B83">@@@</font><font color="#7B637B">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#836B83">@</font><font color="#A08393">@</font><font color="#8C738C">@</font><font color="#7B637B">@@@@@@@@@@@@@@@@@@@@@</font><font color="#735A73">@@@@</font><font color="#6B516B">@@</font><font color="#634A63">@@</font><font color="#5B495B">@@@@@<br>
</font><font color="#947094">@</font><font color="#B5A5B5">@@</font><font color="#947A94">@</font><font color="#B5A5B5">@@</font><font color="#947A94">@</font><font color="#B5A5B5">@</font><font color="#ADA1AD">@</font><font color="#8B6C8B">@</font><font color="#A59CA5">@@</font><font color="#846284">@</font><font color="#9C8D9C">@@</font><font color="#7B637B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@</font><font color="#B69EA3">@</font><font color="#BD918A">@</font><font color="#CD9A84">@@</font><font color="#A47579">@</font><font color="#A58B95">@</font><font color="#9C8D9C">@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#A595A5">@</font><font color="#B69EA3">@</font><font color="#BE897F">@</font><font color="#CD9A84">@@</font><font color="#A47579">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#8B6C8B">@</font><font color="#B69EA3">@</font><font color="#AC9399">@</font><font color="#875971">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#735A73">@</font><font color="#8E7C8E">@@</font><font color="#6B516B">@</font><font color="#857484">@</font><font color="#7B767B">@</font><font color="#634A63">@</font><font color="#746C74">@@</font><font color="#5A425A">@</font><font color="#736373">@@<br>
</font><font color="#947094">@</font><font color="#B5A5B5">@@</font><font color="#947094">@</font><font color="#B5A5B5">@@</font><font color="#947094">@</font><font color="#ADA1AD">@@</font><font color="#8B6C8B">@</font><font color="#A595A5">@@</font><font color="#846284">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@@</font><font color="#BD918A">@</font><font color="#FBB383">@@</font><font color="#EEA06C">@</font><font color="#ED8F50">@@</font><font color="#EA803A">@</font><font color="#F68032">@</font><font color="#CD8152">@</font><font color="#735A73">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#9C8D9C">@</font><font color="#A59CA5">@</font><font color="#DEA68C">@</font><font color="#FBB383">@</font><font color="#EEA06C">@</font><font color="#ED8F50">@@</font><font color="#EF8640">@@</font><font color="#F68032">@</font><font color="#CD8152">@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#BD918A">@</font><font color="#FFAA72">@</font><font color="#E17329">@</font><font color="#B65927">@</font><font color="#948594">@@</font><font color="#735A73">@</font><font color="#948594">@@</font><font color="#735273">@</font><font color="#8E7C8E">@</font><font color="#847A84">@</font><font color="#6B516B">@</font><font color="#7B767B">@@</font><font color="#5B495B">@</font><font color="#746C74">@@</font><font color="#5A425A">@</font><font color="#736373">@@<br>
</font><font color="#947094">@@@@@@@@</font><font color="#8C648C">@@</font><font color="#846284">@@@</font><font color="#7B5A7B">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#BD918A">@</font><font color="#FBC099">@</font><font color="#F0B289">@</font><font color="#D89162">@</font><font color="#AF6534">@</font><font color="#AB5319">@</font><font color="#B75717">@</font><font color="#C65D18">@</font><font color="#E36C1D">@@</font><font color="#C65D18">@</font><font color="#6B516B">@</font><font color="#735273">@@</font><font color="#7B5A7B">@@@</font><font color="#A58B95">@</font><font color="#FBC099">@</font><font color="#F0B289">@</font><font color="#D89162">@</font><font color="#AF6534">@</font><font color="#A45019">@</font><font color="#AB5319">@@</font><font color="#C65D18">@</font><font color="#E36C1D">@@</font><font color="#DA641A">@</font><font color="#7A565F">@</font><font color="#735273">@@@</font><font color="#7B5A7B">@</font><font color="#BD918A">@</font><font color="#EEA06C">@</font><font color="#D1641B">@</font><font color="#A45019">@</font><font color="#735273">@@@@@@@</font><font color="#6B516B">@@</font><font color="#634A63">@@@</font><font color="#5A425A">@@@@@<br>
</font><font color="#947094">@</font><font color="#B59DB5">@@</font><font color="#947094">@</font><font color="#B59DB5">@@</font><font color="#947094">@</font><font color="#AC94AC">@@</font><font color="#8C648C">@</font><font color="#A595A5">@@</font><font color="#855A85">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C849C">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#A595A5">@</font><font color="#FBC099">@</font><font color="#E6A479">@</font><font color="#B56F41">@</font><font color="#904E25">@</font><font color="#783A31">@</font><font color="#7D5345">@</font><font color="#88533A">@</font><font color="#A45019">@</font><font color="#C75305">@@</font><font color="#BB4C03">@</font><font color="#945D46">@</font><font color="#857484">@</font><font color="#6B516B">@</font><font color="#8E7C8E">@@</font><font color="#9C7E93">@</font><font color="#FBC099">@</font><font color="#E6A479">@</font><font color="#B56F41">@</font><font color="#904E25">@</font><font color="#7F3A1E">@</font><font color="#6B3C38">@</font><font color="#7D5345">@</font><font color="#88533A">@</font><font color="#AB5319">@</font><font color="#CE5A0C">@@</font><font color="#D75C0A">@</font><font color="#CE5A0C">@</font><font color="#816B72">@</font><font color="#6B516B">@</font><font color="#8E7C8E">@@</font><font color="#BE897F">@</font><font color="#EE965F">@</font><font color="#C65D18">@</font><font color="#964419">@</font><font color="#8E7C8E">@@</font><font color="#6B516B">@</font><font color="#857484">@@</font><font color="#6B516B">@</font><font color="#847A84">@@</font><font color="#6A4A6A">@</font><font color="#7B6B7B">@@</font><font color="#624262">@</font><font color="#736373">@@</font><font color="#5A425A">@</font><font color="#736373">@@<br>
</font><font color="#947094">@</font><font color="#B59DB5">@@</font><font color="#947094">@</font><font color="#B59DB5">@@</font><font color="#947094">@</font><font color="#AC94AC">@@</font><font color="#8C648C">@</font><font color="#A595A5">@@</font><font color="#855A85">@</font><font color="#9C8D9C">@@</font><font color="#7B5A7B">@</font><font color="#9C849C">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#948594">@@</font><font color="#7B5A7B">@</font><font color="#C5A19B">@</font><font color="#F3AA7A">@</font><font color="#B96E3C">@</font><font color="#8C3F1A">@</font><font color="#857484">@</font><font color="#6A4A6A">@</font><font color="#7B6B7B">@@</font><font color="#5A425A">@</font><font color="#A45019">@</font><font color="#9F4000">@</font><font color="#8B3800">@</font><font color="#994715">@</font><font color="#746C74">@</font><font color="#634A63">@</font><font color="#857484">@</font><font color="#8E7C8E">@</font><font color="#F0B289">@</font><font color="#E6A479">@</font><font color="#AF6534">@</font><font color="#723611">@</font><font color="#7A5D6A">@</font><font color="#857484">@</font><font color="#6A4A6A">@</font><font color="#7B6B7B">@</font><font color="#736373">@</font><font color="#5A425A">@</font><font color="#945D46">@</font><font color="#D9600F">@@</font><font color="#C75305">@</font><font color="#AB5319">@</font><font color="#634A63">@</font><font color="#857484">@@</font><font color="#BE897F">@</font><font color="#ED8F50">@</font><font color="#B75717">@</font><font color="#964419">@</font><font color="#857484">@@</font><font color="#6A4A6A">@</font><font color="#7B6B7B">@</font><font color="#857484">@</font><font color="#6A4A6A">@</font><font color="#857484">@@</font><font color="#6A4A6A">@</font><font color="#7B6B7B">@@</font><font color="#624262">@</font><font color="#736373">@@</font><font color="#5A425A">@</font><font color="#736373">@@<br>
</font><font color="#996699">@@@@@@@</font><font color="#8C648C">@@@</font><font color="#855A85">@@@@</font><font color="#7B527B">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#BE897F">@</font><font color="#EE965F">@</font><font color="#B75717">@</font><font color="#964419">@</font><font color="#6A4A6A">@@</font><font color="#624262">@</font><font color="#593A59">@@</font><font color="#783A31">@</font><font color="#BB4C03">@</font><font color="#923C09">@@</font><font color="#593A59">@@</font><font color="#624262">@</font><font color="#A47579">@</font><font color="#F3AA7A">@</font><font color="#B96E3C">@</font><font color="#803605">@</font><font color="#61434E">@</font><font color="#6A4A6A">@@</font><font color="#624262">@</font><font color="#593A59">@@@@</font><font color="#9D4A38">@</font><font color="#E36C1D">@</font><font color="#CE5A0C">@</font><font color="#C75305">@</font><font color="#61434E">@</font><font color="#624262">@</font><font color="#6A4A6A">@</font><font color="#B4766B">@</font><font color="#E88B4E">@</font><font color="#AB5319">@</font><font color="#8C3F1A">@</font><font color="#624262">@@@@@</font><font color="#6A4A6A">@@@@@</font><font color="#624262">@@</font><font color="#5A425A">@@@@@<br>
</font><font color="#996699">@</font><font color="#B59DB5">@@</font><font color="#996699">@</font><font color="#B59DB5">@@</font><font color="#996699">@</font><font color="#AC94AC">@@</font><font color="#8C5B8C">@</font><font color="#A68DA6">@@</font><font color="#855A85">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#BD918A">@</font><font color="#EA803A">@</font><font color="#C65D18">@</font><font color="#CE5A0C">@</font><font color="#B96E3C">@</font><font color="#70535A">@</font><font color="#6B5B6B">@</font><font color="#625262">@</font><font color="#523152">@</font><font color="#625262">@@</font><font color="#523152">@</font><font color="#625262">@@</font><font color="#593A59">@</font><font color="#736373">@</font><font color="#D39379">@</font><font color="#EE965F">@</font><font color="#A45019">@</font><font color="#783A31">@</font><font color="#6A4A6A">@</font><font color="#7B6B7B">@</font><font color="#736373">@</font><font color="#593A59">@</font><font color="#625262">@@</font><font color="#523152">@</font><font color="#625262">@@</font><font color="#EF7523">@</font><font color="#E17329">@</font><font color="#BE540D">@</font><font color="#783A31">@</font><font color="#6B5B6B">@</font><font color="#736373">@</font><font color="#B4766B">@</font><font color="#E88B4E">@</font><font color="#AB5319">@</font><font color="#8C3F1A">@</font><font color="#736373">@@</font><font color="#593A59">@</font><font color="#736373">@</font><font color="#7B6B7B">@</font><font color="#6A426A">@</font><font color="#857484">@@</font><font color="#6A4A6A">@</font><font color="#7B6B7B">@@</font><font color="#624262">@</font><font color="#736373">@@</font><font color="#593A59">@</font><font color="#736373">@@<br>
</font><font color="#996699">@</font><font color="#B59DB5">@@</font><font color="#996699">@</font><font color="#B59DB5">@@</font><font color="#996699">@</font><font color="#B392B3">@</font><font color="#AC94AC">@</font><font color="#8C5B8C">@</font><font color="#A68DA6">@@</font><font color="#865486">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@@</font><font color="#7B527B">@</font><font color="#9C849C">@</font><font color="#E17329">@</font><font color="#CE5A0C">@@</font><font color="#E36C1D">@</font><font color="#EF7523">@</font><font color="#EA803A">@</font><font color="#C07D50">@</font><font color="#945D46">@</font><font color="#6B5B6B">@</font><font color="#625262">@</font><font color="#523152">@</font><font color="#625262">@@</font><font color="#593A59">@</font><font color="#735A73">@</font><font color="#EE965F">@@</font><font color="#A45019">@</font><font color="#7D5345">@</font><font color="#6A426A">@</font><font color="#736373">@</font><font color="#6B5B6B">@</font><font color="#523152">@</font><font color="#625262">@@</font><font color="#593A59">@</font><font color="#6B5B6B">@@</font><font color="#CA744D">@</font><font color="#EA803A">@</font><font color="#B75717">@</font><font color="#7F3A1E">@</font><font color="#625262">@</font><font color="#6B5B6B">@</font><font color="#B4766B">@</font><font color="#EF8640">@</font><font color="#AB5319">@</font><font color="#8C3F1A">@</font><font color="#736373">@</font><font color="#6B5B6B">@</font><font color="#523152">@</font><font color="#6B5B6B">@</font><font color="#736373">@</font><font color="#6A426A">@</font><font color="#857484">@@</font><font color="#6A426A">@</font><font color="#836B83">@</font><font color="#7B6B7B">@</font><font color="#643C64">@</font><font color="#736373">@@</font><font color="#593A59">@</font><font color="#736373">@@<br>
</font><font color="#996699">@@@@@@@@</font><font color="#8C5B8C">@@@@</font><font color="#865486">@</font><font color="#A67DA6">@</font><font color="#FFFFFF">@</font><font color="#F7F7F7">@</font><font color="#E6E6E6">@</font><font color="#DEDEDE">@</font><font color="#E6E6E6">@</font><font color="#EFEFEF">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@</font><font color="#F7F7F7">@</font><font color="#BBB5BB">@</font><font color="#CCCCCC">@</font><font color="#DEDEDE">@</font><font color="#E6E6E6">@</font><font color="#EFEFEF">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@</font><font color="#F7F7F7">@</font><font color="#997899">@</font><font color="#7C4A7C">@</font><font color="#DEDEDE">@</font><font color="#F7F7F7">@</font><font color="#E6E6E6">@</font><font color="#A68DA6">@</font><font color="#7C4A7C">@@@@</font><font color="#FFFFFF">@@</font><font color="#F7F7F7">@</font><font color="#947094">@</font><font color="#7C4A7C">@@</font><font color="#875971">@</font><font color="#CE5A0C">@</font><font color="#C75305">@</font><font color="#CE5A0C">@</font><font color="#E36C1D">@</font><font color="#E17329">@</font><font color="#EA803A">@</font><font color="#F68032">@@</font><font color="#CC6633">@</font><font color="#734242">@</font><font color="#593A59">@@@@</font><font color="#FF8D41">@</font><font color="#E88B4E">@</font><font color="#AB5319">@</font><font color="#61434E">@</font><font color="#643C64">@</font><font color="#593A59">@</font><font color="#523152">@@@</font><font color="#593A59">@@</font><font color="#643C64">@@</font><font color="#AE7064">@</font><font color="#EF8640">@</font><font color="#B75717">@</font><font color="#8C3F1A">@</font><font color="#523152">@@</font><font color="#AE7064">@</font><font color="#EF8640">@</font><font color="#AB5319">@</font><font color="#8C3F1A">@</font><font color="#593A59">@@</font><font color="#523152">@</font><font color="#593A59">@@</font><font color="#6A426A">@@@@@@</font><font color="#643C64">@@@@@@<br>
</font><font color="#996699">@</font><font color="#B59DB5">@@</font><font color="#996699">@</font><font color="#B59DB5">@@</font><font color="#9B5B9B">@</font><font color="#B392B3">@</font><font color="#AC94AC">@</font><font color="#8C5B8C">@</font><font color="#A68DA6">@@</font><font color="#865486">@</font><font color="#CCCCCC">@</font><font color="#FFFFFF">@</font><font color="#E6E6E6">@</font><font color="#ADADAD">@</font><font color="#948594">@</font><font color="#8E7C8E">@</font><font color="#A59CA5">@</font><font color="#C7BEC7">@</font><font color="#F7F7F7">@</font><font color="#E6E6E6">@</font><font color="#BBB5BB">@</font><font color="#857484">@</font><font color="#948594">@</font><font color="#9C8D9C">@@</font><font color="#DEDEDE">@</font><font color="#F7F7F7">@</font><font color="#EFEFEF">@</font><font color="#BBB5BB">@</font><font color="#948594">@</font><font color="#EFEFEF">@</font><font color="#E6E6E6">@</font><font color="#BDBDBD">@</font><font color="#7C4A7C">@</font><font color="#947A94">@@</font><font color="#7C4A7C">@</font><font color="#ADA1AD">@</font><font color="#FFFFFF">@</font><font color="#E6E6E6">@</font><font color="#D4D4D4">@</font><font color="#947A94">@</font><font color="#7C4A7C">@</font><font color="#947A94">@@</font><font color="#784669">@</font><font color="#A35F32">@</font><font color="#BB4C03">@@</font><font color="#BE540D">@@</font><font color="#C65D18">@</font><font color="#E36C1D">@@</font><font color="#D9600F">@</font><font color="#945D46">@</font><font color="#6B5B6B">@</font><font color="#593A59">@</font><font color="#736373">@</font><font color="#FF8D41">@</font><font color="#E68341">@</font><font color="#AB5319">@</font><font color="#70535A">@</font><font color="#643C64">@</font><font color="#6B5B6B">@</font><font color="#625262">@</font><font color="#523152">@</font><font color="#6B5B6B">@</font><font color="#736373">@</font><font color="#643C64">@</font><font color="#836B83">@@</font><font color="#B4766B">@</font><font color="#E88B4E">@</font><font color="#B75717">@</font><font color="#8C3F1A">@</font><font color="#625262">@@</font><font color="#AE7064">@</font><font color="#E68341">@</font><font color="#AB5319">@</font><font color="#8C3F1A">@</font><font color="#6B5B6B">@</font><font color="#625262">@</font><font color="#523152">@</font><font color="#6B5B6B">@</font><font color="#736373">@</font><font color="#6A426A">@</font><font color="#836B83">@@</font><font color="#734173">@</font><font color="#836B83">@</font><font color="#7B6B7B">@</font><font color="#643C64">@</font><font color="#736373">@@</font><font color="#643C64">@</font><font color="#736373">@@<br>
</font><font color="#9B5B9B">@</font><font color="#B59DB5">@@</font><font color="#9B5B9B">@</font><font color="#B59DB5">@@</font><font color="#9B5B9B">@</font><font color="#B392B3">@@</font><font color="#8C5B8C">@</font><font color="#A68DA6">@@</font><font color="#865486">@</font><font color="#EFEFEF">@@</font><font color="#BDBDBD">@</font><font color="#857484">@</font><font color="#8E7C8E">@</font><font color="#734173">@</font><font color="#8C738C">@</font><font color="#ADA1AD">@</font><font color="#F7F7F7">@</font><font color="#D4D4D4">@</font><font color="#999999">@</font><font color="#734173">@</font><font color="#8B6C8B">@@</font><font color="#734173">@</font><font color="#E6E6E6">@</font><font color="#EFEFEF">@</font><font color="#D4D4D4">@</font><font color="#8E7C8E">@</font><font color="#ADA1AD">@</font><font color="#F7F7F7">@</font><font color="#CCCCCC">@</font><font color="#948F94">@</font><font color="#734173">@</font><font color="#8C738C">@@</font><font color="#7C4A7C">@</font><font color="#D4D4D4">@</font><font color="#F7F7F7">@</font><font color="#C5C5C5">@</font><font color="#8E7C8E">@@</font><font color="#7C4A7C">@</font><font color="#8C738C">@@</font><font color="#734173">@</font><font color="#7B6B7B">@</font><font color="#6B5B6B">@</font><font color="#64323F">@</font><font color="#873C27">@</font><font color="#994715">@</font><font color="#BB4C03">@</font><font color="#C75305">@</font><font color="#CE5A0C">@@</font><font color="#CF5503">@</font><font color="#70535A">@</font><font color="#593A59">@</font><font color="#736373">@</font><font color="#FF8D41">@</font><font color="#EF8640">@</font><font color="#B75717">@</font><font color="#70535A">@</font><font color="#5A315A">@</font><font color="#625262">@@</font><font color="#5A315A">@</font><font color="#735A73">@</font><font color="#7B6B7B">@</font><font color="#734173">@</font><font color="#8C738C">@@</font><font color="#BE897F">@</font><font color="#ED8F50">@</font><font color="#AB5319">@</font><font color="#8C3F1A">@</font><font color="#625262">@@</font><font color="#AE7064">@</font><font color="#E68341">@</font><font color="#AB5319">@</font><font color="#8C3F1A">@</font><font color="#6B5B6B">@</font><font color="#625262">@</font><font color="#523152">@</font><font color="#6B5B6B">@</font><font color="#736373">@</font><font color="#643C64">@</font><font color="#836B83">@@</font><font color="#734173">@</font><font color="#836B83">@</font><font color="#7B6B7B">@</font><font color="#643C64">@</font><font color="#736373">@@</font><font color="#643C64">@</font><font color="#736373">@@<br>
</font><font color="#9B5B9B">@@@@@@@@</font><font color="#944F94">@@@@</font><font color="#A46FA4">@</font><font color="#F7F7F7">@</font><font color="#CCCCCC">@</font><font color="#A59CA5">@</font><font color="#7C4A7C">@</font><font color="#734173">@@@</font><font color="#CCCCCC">@</font><font color="#F7F7F7">@</font><font color="#C5C5C5">@</font><font color="#735273">@</font><font color="#6A426A">@@@</font><font color="#846284">@</font><font color="#F7F7F7">@</font><font color="#DEDEDE">@</font><font color="#BDBDBD">@</font><font color="#6A426A">@</font><font color="#C7BEC7">@</font><font color="#EFEFEF">@</font><font color="#BBB5BB">@</font><font color="#6B516B">@</font><font color="#6A426A">@@@</font><font color="#734173">@</font><font color="#EFEFEF">@</font><font color="#E6E6E6">@</font><font color="#ADADAD">@</font><font color="#734173">@@@@@@@</font><font color="#643C64">@</font><font color="#5A315A">@@</font><font color="#523152">@@</font><font color="#783A31">@</font><font color="#D9600F">@@</font><font color="#C75305">@</font><font color="#873C27">@</font><font color="#5A315A">@</font><font color="#643C64">@</font><font color="#E3824F">@</font><font color="#EF8640">@</font><font color="#B75717">@</font><font color="#783A31">@</font><font color="#5A315A">@</font><font color="#523152">@@</font><font color="#5A315A">@</font><font color="#643C64">@</font><font color="#734173">@</font><font color="#7C4A7C">@@@</font><font color="#E6A479">@</font><font color="#EEA06C">@</font><font color="#B65927">@</font><font color="#783A31">@</font><font color="#5A315A">@</font><font color="#523152">@</font><font color="#AE7064">@</font><font color="#EF8640">@</font><font color="#AB5319">@</font><font color="#8C3F1A">@</font><font color="#5A315A">@</font><font color="#523152">@@</font><font color="#5A315A">@</font><font color="#643C64">@@</font><font color="#734173">@@@@</font><font color="#6A426A">@</font><font color="#643C64">@@@@@@<br>
</font><font color="#9B5B9B">@</font><font color="#BD93BD">@@</font><font color="#9B5B9B">@</font><font color="#B59DB5">@@</font><font color="#9B5B9B">@</font><font color="#B392B3">@@</font><font color="#944F94">@</font><font color="#AB87AB">@@</font><font color="#C6B4C6">@</font><font color="#EFEFEF">@</font><font color="#ADADAD">@</font><font color="#7B637B">@</font><font color="#8B6C8B">@</font><font color="#836B83">@</font><font color="#643C64">@</font><font color="#7B6B7B">@</font><font color="#F7F7F7">@</font><font color="#DEDEDE">@</font><font color="#A6A6A6">@</font><font color="#735A73">@</font><font color="#663366">@</font><font color="#735A73">@@</font><font color="#BAA7BA">@</font><font color="#EFEFEF">@</font><font color="#CCCCCC">@</font><font color="#948594">@</font><font color="#7B6B7B">@</font><font color="#F7F7F7">@</font><font color="#E6E6E6">@</font><font color="#A6A6A6">@</font><font color="#6B5B6B">@</font><font color="#663366">@</font><font color="#736373">@</font><font color="#7B637B">@</font><font color="#997899">@</font><font color="#EFEFEF">@</font><font color="#C5C5C5">@</font><font color="#948594">@</font><font color="#8B6C8B">@</font><font color="#836B83">@</font><font color="#784669">@</font><font color="#B4766B">@</font><font color="#CD8152">@</font><font color="#E68341">@</font><font color="#857484">@</font><font color="#7B637B">@</font><font color="#643C64">@</font><font color="#6B5B6B">@</font><font color="#625262">@</font><font color="#523152">@</font><font color="#625262">@</font><font color="#B56F41">@</font><font color="#E17329">@</font><font color="#BE540D">@</font><font color="#994715">@</font><font color="#5A315A">@</font><font color="#735A73">@</font><font color="#C8885E">@</font><font color="#EA803A">@</font><font color="#C55810">@</font><font color="#AB5319">@</font><font color="#5A315A">@</font><font color="#625262">@@</font><font color="#5A315A">@</font><font color="#D89162">@</font><font color="#D39379">@</font><font color="#915187">@</font><font color="#997899">@</font><font color="#B7919E">@</font><font color="#FBB383">@</font><font color="#E09563">@</font><font color="#A45019">@</font><font color="#64323F">@</font><font color="#6B5B6B">@</font><font color="#625262">@</font><font color="#A7655B">@</font><font color="#EF8640">@</font><font color="#B75717">@</font><font color="#8C3F1A">@</font><font color="#6B516B">@</font><font color="#625262">@</font><font color="#523152">@</font><font color="#6B516B">@</font><font color="#735A73">@</font><font color="#6A426A">@</font><font color="#836B83">@@</font><font color="#734173">@</font><font color="#836B83">@@</font><font color="#643C64">@</font><font color="#7B637B">@</font><font color="#735A73">@</font><font color="#663366">@</font><font color="#735A73">@@<br>
</font><font color="#A358A3">@</font><font color="#BD93BD">@@</font><font color="#A358A3">@</font><font color="#B59DB5">@@</font><font color="#9B5B9B">@</font><font color="#B392B3">@@</font><font color="#944F94">@</font><font color="#AB87AB">@@</font><font color="#E6E6E6">@</font><font color="#DEDEDE">@</font><font color="#A59CA5">@</font><font color="#6A426A">@</font><font color="#836B83">@</font><font color="#7B637B">@</font><font color="#663366">@</font><font color="#A595A5">@</font><font color="#EFEFEF">@</font><font color="#B4B2B4">@</font><font color="#7B767B">@</font><font color="#735A73">@</font><font color="#5A315A">@</font><font color="#6B516B">@@</font><font color="#E6E6E6">@</font><font color="#DEDEDE">@</font><font color="#B4B2B4">@</font><font color="#624262">@</font><font color="#9C8D9C">@</font><font color="#EFEFEF">@</font><font color="#BDBDBD">@</font><font color="#7B767B">@</font><font color="#6B516B">@</font><font color="#5A315A">@</font><font color="#6B5B6B">@@</font><font color="#C6B4C6">@</font><font color="#EFEFEF">@</font><font color="#ADADAD">@</font><font color="#6B516B">@</font><font color="#836B83">@</font><font color="#7B637B">@</font><font color="#663366">@</font><font color="#C07D50">@</font><font color="#C8885E">@</font><font color="#D68149">@</font><font color="#AE7064">@</font><font color="#836B83">@</font><font color="#663366">@</font><font color="#735A73">@</font><font color="#6B5B6B">@</font><font color="#5A315A">@</font><font color="#625262">@</font><font color="#C8885E">@</font><font color="#EF8640">@</font><font color="#AB5319">@</font><font color="#8C3F1A">@</font><font color="#523152">@</font><font color="#6B5B6B">@</font><font color="#9C6E69">@</font><font color="#EF7523">@</font><font color="#D9600F">@</font><font color="#CE5A0C">@</font><font color="#88533A">@</font><font color="#625262">@@</font><font color="#875971">@</font><font color="#FFAA72">@@@</font><font color="#C5A19B">@</font><font color="#F0B289">@</font><font color="#EEA06C">@</font><font color="#B96E3C">@</font><font color="#923C09">@</font><font color="#663366">@</font><font color="#6B5B6B">@</font><font color="#625262">@</font><font color="#A7655B">@</font><font color="#EF8640">@</font><font color="#B75717">@</font><font color="#8C3F1A">@</font><font color="#6B516B">@</font><font color="#625262">@</font><font color="#523152">@</font><font color="#6B516B">@</font><font color="#735A73">@</font><font color="#6A426A">@</font><font color="#836B83">@@</font><font color="#734173">@</font><font color="#836B83">@</font><font color="#7B637B">@</font><font color="#663366">@</font><font color="#7B637B">@</font><font color="#735A73">@</font><font color="#663366">@</font><font color="#735A73">@@<br>
</font><font color="#A358A3">@@@@@@@</font><font color="#9D4F9D">@</font><font color="#944F94">@@@</font><font color="#A46FA4">@</font><font color="#E6E6E6">@</font><font color="#ADADAD">@</font><font color="#8C848C">@</font><font color="#734173">@</font><font color="#663366">@@</font><font color="#5A315A">@</font><font color="#C7BEC7">@</font><font color="#D4D4D4">@</font><font color="#8C8C8C">@</font><font color="#593A59">@</font><font color="#5A315A">@@@</font><font color="#735273">@</font><font color="#EFEFEF">@</font><font color="#B4B2B4">@</font><font color="#8C848C">@</font><font color="#663366">@</font><font color="#C6B4C6">@</font><font color="#DEDEDE">@</font><font color="#A59CA5">@</font><font color="#5A425A">@</font><font color="#522952">@@@</font><font color="#5A315A">@</font><font color="#EFEFEF">@</font><font color="#DEDEDE">@</font><font color="#A6A6A6">@</font><font color="#663366">@@@@</font><font color="#945D46">@</font><font color="#CA744D">@</font><font color="#CC6633">@</font><font color="#E17329">@</font><font color="#A7655B">@</font><font color="#663366">@@@@</font><font color="#A47579">@</font><font color="#F3AA7A">@</font><font color="#D68149">@</font><font color="#994715">@</font><font color="#672C27">@</font><font color="#522952">@@</font><font color="#5A315A">@</font><font color="#CC6633">@</font><font color="#DA641A">@</font><font color="#D9600F">@</font><font color="#EF7523">@</font><font color="#A7655B">@</font><font color="#643C64">@@</font><font color="#A27390">@</font><font color="#E6A479">@</font><font color="#FFAA72">@</font><font color="#FAA064">@</font><font color="#EE965F">@</font><font color="#D68149">@</font><font color="#A45019">@</font><font color="#783A31">@</font><font color="#663366">@</font><font color="#5A315A">@@</font><font color="#A7655B">@</font><font color="#EA803A">@</font><font color="#B75717">@</font><font color="#964419">@</font><font color="#5A315A">@@@@</font><font color="#663366">@@</font><font color="#734173">@@@@</font><font color="#663366">@@@@@@@<br>
</font><font color="#A358A3">@</font><font color="#BD93BD">@@</font><font color="#A358A3">@</font><font color="#BD93BD">@@</font><font color="#9D4F9D">@</font><font color="#B392B3">@@</font><font color="#944F94">@</font><font color="#AB87AB">@</font><font color="#C7BEC7">@</font><font color="#C5C5C5">@</font><font color="#848484">@</font><font color="#746C74">@</font><font color="#733373">@</font><font color="#7B5A7B">@</font><font color="#6B5B6B">@</font><font color="#643C64">@</font><font color="#E6E6E6">@</font><font color="#ADADAD">@</font><font color="#7B767B">@</font><font color="#6B5B6B">@@</font><font color="#5A315A">@</font><font color="#625262">@</font><font color="#ADA1AD">@</font><font color="#CCCCCC">@</font><font color="#8C8C8C">@</font><font color="#736373">@</font><font color="#663366">@</font><font color="#EFEFEF">@</font><font color="#C5C5C5">@</font><font color="#999999">@</font><font color="#7B767B">@</font><font color="#8C848C">@</font><font color="#948594">@</font><font color="#ADA1AD">@</font><font color="#CCCCCC">@</font><font color="#F7F7F7">@</font><font color="#C5C5C5">@</font><font color="#948F94">@</font><font color="#663366">@</font><font color="#7B5A7B">@</font><font color="#735A73">@</font><font color="#5A315A">@</font><font color="#7A5D6A">@</font><font color="#B65927">@</font><font color="#C65D18">@</font><font color="#D1641B">@</font><font color="#E17329">@</font><font color="#F68032">@</font><font color="#E3824F">@</font><font color="#D89162">@</font><font color="#EE965F">@</font><font color="#F3AA7A">@</font><font color="#E09563">@</font><font color="#A35F32">@</font><font color="#723611">@</font><font color="#5B495B">@</font><font color="#522952">@</font><font color="#634A63">@@</font><font color="#73365B">@</font><font color="#DA641A">@</font><font color="#D75C0A">@</font><font color="#E36C1D">@</font><font color="#EF8640">@</font><font color="#ED8F50">@</font><font color="#C8885E">@</font><font color="#CE8D6C">@</font><font color="#E88B4E">@@</font><font color="#D68149">@</font><font color="#B65927">@</font><font color="#A45019">@</font><font color="#964419">@</font><font color="#735A73">@</font><font color="#5A315A">@</font><font color="#625262">@@</font><font color="#A95F51">@</font><font color="#E17329">@</font><font color="#BE540D">@@</font><font color="#E36C1D">@</font><font color="#EF7523">@</font><font color="#F68032">@</font><font color="#FF8D41">@@@@@</font><font color="#DB6E3E">@</font><font color="#846284">@</font><font color="#7B637B">@</font><font color="#663366">@</font><font color="#7B5A7B">@</font><font color="#735A73">@</font><font color="#663366">@</font><font color="#735A73">@@<br>
</font><font color="#A358A3">@</font><font color="#BD93BD">@@</font><font color="#A358A3">@</font><font color="#BD93BD">@@</font><font color="#9D4F9D">@</font><font color="#B48BB4">@@</font><font color="#944F94">@</font><font color="#B392B3">@</font><font color="#D4D4D4">@</font><font color="#B4B2B4">@</font><font color="#948F94">@</font><font color="#7B637B">@</font><font color="#733373">@</font><font color="#735A73">@</font><font color="#6B516B">@</font><font color="#AC94AC">@</font><font color="#D4D4D4">@</font><font color="#ADADAD">@</font><font color="#847A84">@</font><font color="#735A73">@@</font><font color="#5A285A">@</font><font color="#736373">@</font><font color="#D4D4D4">@</font><font color="#BDBDBD">@</font><font color="#999999">@</font><font color="#6B5B6B">@</font><font color="#663366">@</font><font color="#B5A5B5">@</font><font color="#BDBDBD">@</font><font color="#ADADAD">@</font><font color="#B4B2B4">@</font><font color="#BDBDBD">@</font><font color="#D4D4D4">@</font><font color="#EFEFEF">@</font><font color="#F7F7F7">@</font><font color="#DEDEDE">@</font><font color="#A59CA5">@</font><font color="#736373">@</font><font color="#663366">@</font><font color="#735A73">@</font><font color="#6B516B">@</font><font color="#5A315A">@</font><font color="#735A73">@</font><font color="#945D46">@</font><font color="#BE540D">@@</font><font color="#C65D18">@</font><font color="#E17329">@</font><font color="#EA803A">@</font><font color="#E88B4E">@</font><font color="#D68149">@</font><font color="#AF6534">@</font><font color="#904E25">@</font><font color="#6F330B">@</font><font color="#61434E">@</font><font color="#634A63">@</font><font color="#522952">@</font><font color="#634A63">@@</font><font color="#5A315A">@</font><font color="#7A565F">@</font><font color="#C55810">@</font><font color="#CE5A0C">@</font><font color="#C65D18">@@@</font><font color="#B75717">@</font><font color="#AB5319">@@</font><font color="#994715">@</font><font color="#803605">@</font><font color="#8B3800">@</font><font color="#9F4000">@</font><font color="#8C3F1A">@</font><font color="#57274B">@</font><font color="#634A63">@@</font><font color="#A45648">@</font><font color="#DA641A">@</font><font color="#BB4C03">@@</font><font color="#D1641B">@</font><font color="#E17329">@</font><font color="#EA803A">@</font><font color="#E68341">@@@@@</font><font color="#BE613A">@</font><font color="#7B637B">@@</font><font color="#663366">@</font><font color="#735A73">@@</font><font color="#663366">@</font><font color="#735A73">@@<br>
</font><font color="#A358A3">@@@@@@</font><font color="#9D4F9D">@@@@</font><font color="#944F94">@@</font><font color="#8B3E8B">@@</font><font color="#7B317B">@</font><font color="#733373">@</font><font color="#663366">@</font><font color="#5A285A">@@</font><font color="#663366">@@@@@</font><font color="#5A315A">@@@</font><font color="#663366">@@@@@</font><font color="#5A285A">@</font><font color="#522952">@@@@</font><font color="#5A315A">@</font><font color="#EFEFEF">@</font><font color="#BBB5BB">@</font><font color="#848484">@</font><font color="#632863">@@@</font><font color="#5A285A">@@</font><font color="#663366">@@</font><font color="#73365B">@</font><font color="#964419">@</font><font color="#C75305">@</font><font color="#C55810">@</font><font color="#B75717">@</font><font color="#AB5319">@</font><font color="#A45019">@</font><font color="#923C09">@</font><font color="#672C27">@</font><font color="#57274B">@</font><font color="#5A315A">@@</font><font color="#522952">@@@</font><font color="#5A285A">@</font><font color="#663366">@@</font><font color="#873C27">@</font><font color="#BB4C03">@@</font><font color="#9F4000">@</font><font color="#8B3800">@@</font><font color="#803605">@</font><font color="#723611">@@</font><font color="#9F4000">@@@</font><font color="#BB4C03">@</font><font color="#6B3C38">@</font><font color="#522952">@</font><font color="#9D4A38">@</font><font color="#D75C0A">@</font><font color="#C75305">@</font><font color="#BB4C03">@</font><font color="#BE540D">@</font><font color="#C55810">@@</font><font color="#C65D18">@@@@</font><font color="#B75717">@</font><font color="#964419">@</font><font color="#632863">@@@@@@@</font><font color="#663366">@<br>
</font><font color="#A54FA5">@</font><font color="#BD93BD">@@</font><font color="#A54FA5">@</font><font color="#BD93BD">@@</font><font color="#9D4F9D">@</font><font color="#B48BB4">@@</font><font color="#944F94">@</font><font color="#AB87AB">@</font><font color="#A67DA6">@</font><font color="#8B3E8B">@</font><font color="#947094">@</font><font color="#8B6C8B">@</font><font color="#733373">@</font><font color="#735A73">@@</font><font color="#632863">@</font><font color="#7B5A7B">@@</font><font color="#733373">@</font><font color="#7B637B">@</font><font color="#735A73">@</font><font color="#632863">@</font><font color="#735273">@</font><font color="#735A73">@</font><font color="#6A296A">@</font><font color="#846284">@@</font><font color="#AB87AB">@</font><font color="#948594">@</font><font color="#8E7C8E">@</font><font color="#846284">@</font><font color="#8C738C">@</font><font color="#857484">@</font><font color="#7B5A7B">@</font><font color="#BBB5BB">@</font><font color="#D4D4D4">@</font><font color="#8C8C8C">@</font><font color="#666666">@</font><font color="#735273">@</font><font color="#5A285A">@</font><font color="#6B516B">@@</font><font color="#5A285A">@</font><font color="#735A73">@</font><font color="#7B637B">@</font><font color="#733373">@</font><font color="#846284">@</font><font color="#7B5A7B">@</font><font color="#64323F">@</font><font color="#61434E">@@</font><font color="#57274B">@</font><font color="#6B516B">@@</font><font color="#632863">@</font><font color="#6B516B">@</font><font color="#634A63">@</font><font color="#522952">@</font><font color="#634A63">@@</font><font color="#632863">@</font><font color="#7B5A7B">@@</font><font color="#663366">@</font><font color="#735273">@</font><font color="#634A63">@</font><font color="#57274B">@</font><font color="#61434E">@@</font><font color="#522952">@</font><font color="#634A63">@@</font><font color="#502230">@</font><font color="#9F4000">@</font><font color="#8B3800">@</font><font color="#923C09">@</font><font color="#513C4E">@</font><font color="#5A425A">@</font><font color="#5A285A">@</font><font color="#6B516B">@</font><font color="#735A73">@</font><font color="#632863">@</font><font color="#6B516B">@</font><font color="#634A63">@</font><font color="#512151">@</font><font color="#5B495B">@@</font><font color="#5A285A">@</font><font color="#6B516B">@@</font><font color="#5A285A">@</font><font color="#634A63">@@</font><font color="#5A285A">@</font><font color="#6B516B">@@</font><font color="#632863">@</font><font color="#735A73">@@<br>
</font><font color="#A54FA5">@</font><font color="#BD93BD">@@</font><font color="#A54FA5">@</font><font color="#BD93BD">@@</font><font color="#9D4F9D">@</font><font color="#B48BB4">@@</font><font color="#943E94">@</font><font color="#AB87AB">@</font><font color="#A67DA6">@</font><font color="#8B3E8B">@</font><font color="#947094">@</font><font color="#8B6C8B">@</font><font color="#733373">@</font><font color="#7B5A7B">@</font><font color="#735A73">@</font><font color="#6A296A">@</font><font color="#7B637B">@</font><font color="#846284">@</font><font color="#733373">@</font><font color="#7B637B">@@</font><font color="#663366">@</font><font color="#735A73">@</font><font color="#7B637B">@</font><font color="#733373">@</font><font color="#846284">@@</font><font color="#F7F7F7">@@</font><font color="#EFEFEF">@@@@</font><font color="#DEDEDE">@</font><font color="#BBB5BB">@</font><font color="#948F94">@</font><font color="#7B767B">@</font><font color="#634A63">@@</font><font color="#5A285A">@</font><font color="#634A63">@@</font><font color="#632863">@</font><font color="#7B5A7B">@</font><font color="#846284">@</font><font color="#733373">@</font><font color="#846284">@</font><font color="#7B5A7B">@</font><font color="#632863">@</font><font color="#6B516B">@</font><font color="#634A63">@</font><font color="#5A285A">@</font><font color="#6A4A6A">@@</font><font color="#5A285A">@</font><font color="#634A63">@@</font><font color="#592459">@</font><font color="#634A63">@</font><font color="#735273">@</font><font color="#663366">@</font><font color="#846284">@@</font><font color="#733373">@</font><font color="#7B5A7B">@</font><font color="#735273">@</font><font color="#5A285A">@</font><font color="#634A63">@@</font><font color="#522952">@</font><font color="#5B495B">@@</font><font color="#4C224C">@</font><font color="#513C4E">@</font><font color="#672C27">@</font><font color="#502230">@</font><font color="#513C4E">@</font><font color="#5B495B">@</font><font color="#5A285A">@</font><font color="#735273">@@</font><font color="#632863">@</font><font color="#6B516B">@</font><font color="#634A63">@</font><font color="#512151">@</font><font color="#5A425A">@@</font><font color="#512151">@</font><font color="#5B495B">@@</font><font color="#522952">@</font><font color="#5B495B">@@</font><font color="#522952">@</font><font color="#634A63">@</font><font color="#6B516B">@</font><font color="#632863">@</font><font color="#735273">@@<br>
</font><font color="#A54FA5">@@@@@@</font><font color="#9D4F9D">@@</font><font color="#943E94">@@@@</font><font color="#8B3E8B">@@</font><font color="#7B317B">@</font><font color="#733373">@@@@@@@@@</font><font color="#6A296A">@@</font><font color="#733373">@@@@</font><font color="#8C5B8C">@</font><font color="#7B527B">@@</font><font color="#734173">@</font><font color="#6A426A">@@</font><font color="#643C64">@</font><font color="#523152">@@</font><font color="#592459">@@@@@@</font><font color="#632863">@</font><font color="#6A296A">@</font><font color="#733373">@@@@</font><font color="#6A296A">@</font><font color="#632863">@</font><font color="#5A285A">@</font><font color="#592459">@@@@@@@</font><font color="#632863">@@</font><font color="#733373">@@@@@</font><font color="#6A296A">@</font><font color="#632863">@</font><font color="#5A285A">@@</font><font color="#512151">@@@</font><font color="#4C224C">@@@@@</font><font color="#512151">@</font><font color="#5A285A">@</font><font color="#632863">@@@@</font><font color="#5A285A">@@</font><font color="#512151">@@@@@@@@@@</font><font color="#5A285A">@@</font><font color="#632863">@@<br>
</font><font color="#A54FA5">@</font><font color="#BD93BD">@@</font><font color="#A443A4">@</font><font color="#B48BB4">@@</font><font color="#9C3E9C">@</font><font color="#AB87AB">@@</font><font color="#943E94">@</font><font color="#A67DA6">@@</font><font color="#8B3E8B">@</font><font color="#947094">@@</font><font color="#7B317B">@</font><font color="#846284">@@</font><font color="#733373">@</font><font color="#8C648C">@@</font><font color="#7B317B">@</font><font color="#8C648C">@@</font><font color="#733373">@</font><font color="#846284">@@</font><font color="#7B317B">@</font><font color="#8B6C8B">@@</font><font color="#733373">@</font><font color="#846284">@</font><font color="#7B5A7B">@</font><font color="#6A296A">@</font><font color="#735273">@@</font><font color="#632863">@</font><font color="#6B516B">@@</font><font color="#5A285A">@</font><font color="#634A63">@@</font><font color="#592459">@</font><font color="#634A63">@</font><font color="#6B516B">@</font><font color="#6A296A">@</font><font color="#846284">@</font><font color="#8B6C8B">@</font><font color="#7B317B">@</font><font color="#8B6C8B">@@</font><font color="#6A296A">@</font><font color="#735A73">@@</font><font color="#5A285A">@</font><font color="#6A4A6A">@@</font><font color="#5A285A">@</font><font color="#6B516B">@@</font><font color="#632863">@</font><font color="#7B5A7B">@@</font><font color="#733373">@</font><font color="#8B6C8B">@@</font><font color="#7B317B">@</font><font color="#8C648C">@</font><font color="#846284">@</font><font color="#6A296A">@</font><font color="#735273">@</font><font color="#6B516B">@</font><font color="#5A285A">@</font><font color="#634A63">@@</font><font color="#592459">@</font><font color="#634A63">@@</font><font color="#512151">@</font><font color="#634A63">@@</font><font color="#5A285A">@</font><font color="#735273">@@</font><font color="#6A296A">@</font><font color="#735A73">@@</font><font color="#5A285A">@</font><font color="#634A63">@@</font><font color="#592459">@</font><font color="#634A63">@</font><font color="#5B495B">@</font><font color="#512151">@</font><font color="#5A425A">@@</font><font color="#512151">@</font><font color="#634A63">@@</font><font color="#632863">@</font><font color="#735273">@@<br>
</font><font color="#A443A4">@</font><font color="#B48BB4">@@</font><font color="#A443A4">@</font><font color="#B583B5">@@</font><font color="#9C3E9C">@</font><font color="#AD7BAD">@@</font><font color="#943E94">@</font><font color="#A67DA6">@</font><font color="#B594A8">@</font><font color="#A06193">@</font><font color="#AA8C9D">@@</font><font color="#7B317B">@</font><font color="#8C648C">@@</font><font color="#7B317B">@</font><font color="#8B6C8B">@@</font><font color="#7B317B">@</font><font color="#8C648C">@@</font><font color="#7B317B">@</font><font color="#8C648C">@@</font><font color="#7B317B">@</font><font color="#8B6C8B">@@</font><font color="#7B317B">@</font><font color="#846284">@</font><font color="#8E7C8E">@</font><font color="#7C4A7C">@</font><font color="#7B5A7B">@</font><font color="#735273">@</font><font color="#632863">@</font><font color="#6B516B">@@</font><font color="#5A285A">@</font><font color="#634A63">@@</font><font color="#592459">@</font><font color="#6A4A6A">@</font><font color="#735273">@</font><font color="#6A296A">@</font><font color="#846284">@</font><font color="#8C648C">@</font><font color="#7B317B">@</font><font color="#8B6C8B">@@</font><font color="#733373">@</font><font color="#846284">@</font><font color="#7B5A7B">@</font><font color="#6A296A">@</font><font color="#735273">@@</font><font color="#663366">@</font><font color="#8E7C8E">@@</font><font color="#975C8A">@</font><font color="#A08393">@</font><font color="#A58B95">@</font><font color="#7B317B">@</font><font color="#8B6C8B">@@</font><font color="#7B317B">@</font><font color="#8C648C">@@</font><font color="#733373">@</font><font color="#7B5A7B">@@</font><font color="#632863">@</font><font color="#735273">@@</font><font color="#632863">@</font><font color="#735A73">@</font><font color="#8E7C8E">@</font><font color="#663366">@</font><font color="#6B516B">@@</font><font color="#632863">@</font><font color="#735A73">@</font><font color="#7B5A7B">@</font><font color="#732973">@</font><font color="#7B5A7B">@@</font><font color="#6A296A">@</font><font color="#735273">@</font><font color="#6B516B">@</font><font color="#632863">@</font><font color="#6A4A6A">@@</font><font color="#592459">@</font><font color="#634A63">@@</font><font color="#592459">@</font><font color="#6A4A6A">@@</font><font color="#632863">@</font><font color="#735273">@@<br>
</font><font color="#A443A4">@@@@</font><font color="#9C3E9C">@@@</font><font color="#943E94">@@@</font><font color="#A46FA4">@</font><font color="#FFFFCC">@@@</font><font color="#F7F7C6">@</font><font color="#DDC9B6">@</font><font color="#7B317B">@@@@@@@</font><font color="#975C8A">@</font><font color="#D2C4B3">@</font><font color="#7B317B">@@@@@@@</font><font color="#CEBCAA">@</font><font color="#C0B6A6">@</font><font color="#6A296A">@@</font><font color="#632863">@@@@@</font><font color="#592459">@@</font><font color="#632863">@</font><font color="#6A296A">@</font><font color="#732973">@</font><font color="#7B317B">@@@@@@@</font><font color="#732973">@@@@</font><font color="#975C8A">@</font><font color="#FFFFCC">@@@@@</font><font color="#7B317B">@@@@@@@@</font><font color="#732973">@@</font><font color="#6A296A">@@@</font><font color="#865486">@</font><font color="#DDC9B6">@</font><font color="#865486">@</font><font color="#6A296A">@@@</font><font color="#732973">@@@@@@</font><font color="#6A296A">@@@</font><font color="#632863">@@@@@@@@@@</font><font color="#6A296A">@<br>
</font><font color="#A443A4">@</font><font color="#B583B5">@@</font><font color="#9C3E9C">@</font><font color="#AD7BAD">@@</font><font color="#943E94">@</font><font color="#A67DA6">@@</font><font color="#8B3E8B">@</font><font color="#B594A8">@</font><font color="#FFFFCC">@</font><font color="#A06193">@</font><font color="#947094">@</font><font color="#AA8C9D">@</font><font color="#FFFFCC">@</font><font color="#C0ACA6">@</font><font color="#8C648C">@</font><font color="#7B317B">@</font><font color="#AA8C9D">@@</font><font color="#8B3E8B">@</font><font color="#947094">@</font><font color="#D2C4B3">@</font><font color="#FFFFCC">@</font><font color="#AA8C9D">@</font><font color="#8C648C">@</font><font color="#8F4A89">@</font><font color="#AA8C9D">@</font><font color="#A08393">@</font><font color="#7B317B">@</font><font color="#8C648C">@</font><font color="#D2CFB2">@</font><font color="#CEBCAA">@</font><font color="#8B6C8B">@</font><font color="#8E7C8E">@</font><font color="#6A296A">@</font><font color="#735273">@@@</font><font color="#857484">@</font><font color="#7B637B">@</font><font color="#6A296A">@</font><font color="#7B5A7B">@</font><font color="#836B83">@</font><font color="#975C8A">@</font><font color="#9C7E93">@</font><font color="#8C648C">@</font><font color="#7B317B">@</font><font color="#8C648C">@</font><font color="#997899">@</font><font color="#A06193">@</font><font color="#8B6C8B">@</font><font color="#846284">@</font><font color="#7B317B">@</font><font color="#846284">@@</font><font color="#98618B">@</font><font color="#FFFFCC">@</font><font color="#A58B95">@</font><font color="#7B317B">@</font><font color="#8C648C">@@</font><font color="#7B317B">@</font><font color="#9C849C">@</font><font color="#997899">@</font><font color="#8F4A89">@</font><font color="#AA8C9D">@</font><font color="#8C648C">@</font><font color="#7B317B">@</font><font color="#846284">@</font><font color="#947094">@</font><font color="#98618B">@</font><font color="#8B6C8B">@</font><font color="#A08393">@</font><font color="#732973">@</font><font color="#8B6C8B">@</font><font color="#A08393">@</font><font color="#7B317B">@</font><font color="#947A94">@</font><font color="#8C738C">@</font><font color="#80407A">@</font><font color="#A08393">@</font><font color="#846284">@</font><font color="#7B317B">@</font><font color="#846284">@</font><font color="#947094">@</font><font color="#98618B">@</font><font color="#8B6C8B">@</font><font color="#7B5A7B">@</font><font color="#732973">@</font><font color="#7B5A7B">@@</font><font color="#6A296A">@</font><font color="#735273">@@</font><font color="#632863">@</font><font color="#735273">@@</font><font color="#632863">@</font><font color="#735273">@@<br>
</font><font color="#9C3E9C">@</font><font color="#B583B5">@@</font><font color="#9C3E9C">@</font><font color="#AD7BAD">@@</font><font color="#993399">@</font><font color="#A46FA4">@@</font><font color="#882F88">@</font><font color="#B594A8">@</font><font color="#FFFFCC">@</font><font color="#A06193">@</font><font color="#8C648C">@@</font><font color="#E6D7BD">@</font><font color="#DDC9B6">@</font><font color="#8C648C">@</font><font color="#E6D7BD">@</font><font color="#E7E0BE">@</font><font color="#EFEEC5">@</font><font color="#F5F0C5">@</font><font color="#AA8C9D">@</font><font color="#EFEEC5">@</font><font color="#FFFFCC">@</font><font color="#E6D7BD">@</font><font color="#AC9399">@</font><font color="#F5F0C5">@</font><font color="#E6D7BD">@</font><font color="#FFFFCC">@</font><font color="#B594A8">@</font><font color="#8C648C">@</font><font color="#DCD5BC">@</font><font color="#EFE5C2">@</font><font color="#D2CFB2">@</font><font color="#E7E0BE">@</font><font color="#C0ACA6">@</font><font color="#7B5A7B">@</font><font color="#B4ADA0">@</font><font color="#CAC6AE">@@</font><font color="#DAD9B6">@</font><font color="#865486">@</font><font color="#9C7E93">@</font><font color="#EFEEC5">@</font><font color="#DDC9B6">@</font><font color="#F7F7C6">@</font><font color="#C0ACA6">@</font><font color="#7B317B">@</font><font color="#B69EA3">@</font><font color="#FFFFCC">@</font><font color="#DDC9B6">@</font><font color="#FFFFCC">@</font><font color="#AC9399">@</font><font color="#7B317B">@</font><font color="#846284">@@</font><font color="#98618B">@</font><font color="#FFFFCC">@</font><font color="#D2C4B3">@</font><font color="#B594A8">@</font><font color="#CDB0AD">@</font><font color="#B69EA3">@</font><font color="#7B317B">@</font><font color="#E6D7BD">@</font><font color="#E7E0BE">@@</font><font color="#F7F7C6">@</font><font color="#E6D7BD">@</font><font color="#7B317B">@</font><font color="#B69EA3">@</font><font color="#FFFFCC">@</font><font color="#DDC9B6">@</font><font color="#E7E0BE">@</font><font color="#FFFFCC">@</font><font color="#7B317B">@</font><font color="#A58B95">@</font><font color="#FFFFCC">@</font><font color="#98618B">@</font><font color="#DCD5BC">@</font><font color="#E7E0BE">@</font><font color="#E6D7BD">@</font><font color="#F7F7C6">@</font><font color="#E6D7BD">@</font><font color="#7B317B">@</font><font color="#B69EA3">@</font><font color="#FFFFCC">@</font><font color="#DDC9B6">@</font><font color="#FFFFCC">@</font><font color="#AC9399">@</font><font color="#732973">@</font><font color="#7B5A7B">@@</font><font color="#6A296A">@</font><font color="#735273">@@</font><font color="#6A296A">@</font><font color="#735273">@@</font><font color="#6A296A">@</font><font color="#735273">@@<br>
</font><font color="#9C3E9C">@@</font><font color="#993399">@@@@@</font><font color="#882F88">@@@</font><font color="#A06193">@</font><font color="#FFFFCC">@</font><font color="#A06193">@</font><font color="#7B317B">@@</font><font color="#DDC9B6">@@</font><font color="#7B317B">@</font><font color="#AC7A99">@</font><font color="#7C257C">@</font><font color="#AC7A99">@</font><font color="#FFFFCC">@</font><font color="#98618B">@</font><font color="#B7919E">@</font><font color="#FFFFCC">@</font><font color="#7C257C">@</font><font color="#98618B">@</font><font color="#915187">@</font><font color="#7B317B">@</font><font color="#E6D7BD">@</font><font color="#DDC9B6">@</font><font color="#7C257C">@</font><font color="#DDC9B6">@</font><font color="#E7E0BE">@</font><font color="#732973">@</font><font color="#A27390">@</font><font color="#EFEEC5">@</font><font color="#865486">@</font><font color="#A27390">@</font><font color="#733373">@</font><font color="#80407A">@</font><font color="#EFEEC5">@</font><font color="#AA8C9D">@@</font><font color="#F7F7C6">@</font><font color="#A06193">@</font><font color="#915187">@</font><font color="#7C257C">@@</font><font color="#EFE5C2">@</font><font color="#CDB0AD">@</font><font color="#7C257C">@</font><font color="#C4A2A7">@</font><font color="#EFE5C2">@</font><font color="#7C257C">@@@</font><font color="#98618B">@</font><font color="#FFFFCC">@</font><font color="#E6D7BD">@</font><font color="#DDC9B6">@@</font><font color="#C4A2A7">@</font><font color="#7C257C">@</font><font color="#DDC9B6">@</font><font color="#E6D7BD">@</font><font color="#7C257C">@</font><font color="#C4A2A7">@</font><font color="#FFFFCC">@</font><font color="#7C257C">@</font><font color="#F5F0C5">@</font><font color="#CDB0AD">@</font><font color="#7C257C">@</font><font color="#CDB0AD">@</font><font color="#FFFFCC">@</font><font color="#7C257C">@</font><font color="#98618B">@</font><font color="#FFFFCC">@</font><font color="#98618B">@</font><font color="#DDC9B6">@</font><font color="#E6D7BD">@</font><font color="#7C257C">@</font><font color="#C4A2A7">@</font><font color="#FFFFCC">@</font><font color="#7C257C">@</font><font color="#EFE5C2">@</font><font color="#CDB0AD">@</font><font color="#732973">@</font><font color="#C4A2A7">@</font><font color="#EFE5C2">@</font><font color="#732973">@@@</font><font color="#6A296A">@@@</font><font color="#6B216B">@@@@@@<br>
</font><font color="#993399">@</font><font color="#AD7BAD">@@</font><font color="#993399">@</font><font color="#A46FA4">@@</font><font color="#932893">@</font><font color="#996699">@@</font><font color="#882F88">@</font><font color="#AA8C9D">@</font><font color="#FFFFCC">@</font><font color="#A06193">@</font><font color="#846284">@@</font><font color="#E6D7BD">@</font><font color="#DDC9B6">@</font><font color="#8C648C">@</font><font color="#D2C4B3">@</font><font color="#E7E0BE">@</font><font color="#DDC9B6">@</font><font color="#FFFFCC">@</font><font color="#A08393">@</font><font color="#C0ACA6">@</font><font color="#FFFFCC">@</font><font color="#855A85">@</font><font color="#B69EA3">@</font><font color="#E6D7BD">@</font><font color="#DDC9B6">@</font><font color="#EFEEC5">@</font><font color="#DDC9B6">@</font><font color="#855A85">@</font><font color="#DCD5BC">@</font><font color="#DDC9B6">@</font><font color="#855A85">@</font><font color="#A08393">@</font><font color="#F7F7C6">@</font><font color="#9C7E93">@</font><font color="#C0B6A6">@</font><font color="#DDC9B6">@</font><font color="#CEBCAA">@</font><font color="#F7F7C6">@</font><font color="#B7919E">@</font><font color="#846284">@</font><font color="#D2C4B3">@</font><font color="#F5F0C5">@@</font><font color="#CEBCAA">@</font><font color="#732973">@</font><font color="#FFFFCC">@</font><font color="#EFEEC5">@</font><font color="#DDC9B6">@</font><font color="#DCD5BC">@@</font><font color="#732973">@</font><font color="#855A85">@@</font><font color="#98618B">@</font><font color="#FFFFCC">@</font><font color="#A08393">@</font><font color="#732973">@</font><font color="#855A85">@@</font><font color="#732973">@</font><font color="#DCD5BC">@@</font><font color="#732973">@</font><font color="#C0ACA6">@</font><font color="#FFFFCC">@</font><font color="#732973">@</font><font color="#FFFFCC">@</font><font color="#C0ACA6">@</font><font color="#732973">@</font><font color="#C0ACA6">@</font><font color="#FFFFCC">@</font><font color="#732973">@</font><font color="#A08393">@</font><font color="#FFFFCC">@</font><font color="#98618B">@</font><font color="#DCD5BC">@@</font><font color="#732973">@</font><font color="#C0ACA6">@</font><font color="#FFFFCC">@</font><font color="#732973">@</font><font color="#FFFFCC">@</font><font color="#EFEEC5">@</font><font color="#DDC9B6">@</font><font color="#DCD5BC">@@</font><font color="#732973">@</font><font color="#7B5A7B">@@</font><font color="#6B216B">@</font><font color="#735273">@@</font><font color="#6B216B">@</font><font color="#735273">@@</font><font color="#6B216B">@</font><font color="#735273">@</font><font color="#7B527B">@<br>
</font><font color="#993399">@</font><font color="#AD7BAD">@@</font><font color="#993399">@</font><font color="#A46FA4">@@</font><font color="#882F88">@</font><font color="#996699">@@</font><font color="#852685">@</font><font color="#AA8C9D">@</font><font color="#FFFFCC">@</font><font color="#AA849C">@@</font><font color="#C0ACA6">@</font><font color="#FFFFCC">@</font><font color="#A58B95">@</font><font color="#C0ACA6">@</font><font color="#FFFFCC">@</font><font color="#846284">@</font><font color="#B69EA3">@</font><font color="#FFFFCC">@</font><font color="#A08393">@</font><font color="#C0ACA6">@</font><font color="#FFFFCC">@</font><font color="#846284">@</font><font color="#FFFFCC">@</font><font color="#C4A2A7">@</font><font color="#846284">@</font><font color="#EFEEC5">@</font><font color="#DDC9B6">@</font><font color="#7B5A7B">@</font><font color="#DCD5BC">@</font><font color="#F5F0C5">@</font><font color="#846284">@</font><font color="#C0ACA6">@</font><font color="#FFFFCC">@</font><font color="#A58B95">@</font><font color="#FFFFCC">@</font><font color="#A06193">@</font><font color="#947A94">@</font><font color="#FFFFCC">@</font><font color="#B7919E">@</font><font color="#947A94">@</font><font color="#B69EA3">@</font><font color="#742174">@</font><font color="#D2C4B3">@</font><font color="#FFFFCC">@</font><font color="#742174">@</font><font color="#E7E0BE">@</font><font color="#DCD5BC">@</font><font color="#742174">@</font><font color="#A58B95">@@</font><font color="#742174">@</font><font color="#7B5A7B">@@</font><font color="#975C8A">@</font><font color="#FFFFCC">@</font><font color="#B69EA3">@</font><font color="#975C8A">@</font><font color="#A08393">@@</font><font color="#7B317B">@</font><font color="#DCD5BC">@@</font><font color="#742174">@</font><font color="#C0ACA6">@</font><font color="#FFFFCC">@</font><font color="#742174">@</font><font color="#E7E0BE">@</font><font color="#DCD5BC">@</font><font color="#742174">@</font><font color="#DCD5BC">@</font><font color="#FFFFCC">@</font><font color="#742174">@</font><font color="#A08393">@</font><font color="#FFFFCC">@</font><font color="#975C8A">@</font><font color="#DCD5BC">@@</font><font color="#742174">@</font><font color="#C0ACA6">@</font><font color="#FFFFCC">@</font><font color="#742174">@</font><font color="#E7E0BE">@</font><font color="#DCD5BC">@</font><font color="#732973">@</font><font color="#A58B95">@@</font><font color="#6B216B">@</font><font color="#7B527B">@@</font><font color="#6B216B">@</font><font color="#735273">@@</font><font color="#6B216B">@</font><font color="#735273">@@</font><font color="#6B216B">@</font><font color="#7B527B">@@<br>
</font><font color="#993399">@@@</font><font color="#932893">@@</font><font color="#8C268C">@@</font><font color="#852685">@@</font><font color="#7C257C">@</font><font color="#975C8A">@</font><font color="#FFFFCC">@@@</font><font color="#F5F0C5">@</font><font color="#B7919E">@</font><font color="#742174">@</font><font color="#8F4A89">@</font><font color="#EFE5C2">@</font><font color="#FFFFCC">@</font><font color="#CDB0AD">@</font><font color="#FFFFCC">@</font><font color="#A06193">@</font><font color="#975C8A">@</font><font color="#F5F0C5">@@</font><font color="#C4A2A7">@</font><font color="#FFFFCC">@</font><font color="#EFE5C2">@</font><font color="#DDC9B6">@</font><font color="#E6D7BD">@</font><font color="#742174">@</font><font color="#DDC9B6">@</font><font color="#E6D7BD">@</font><font color="#F5F0C5">@@</font><font color="#A27390">@</font><font color="#7B317B">@</font><font color="#DDC9B6">@</font><font color="#FFFFCC">@</font><font color="#DDC9B6">@</font><font color="#EFE5C2">@</font><font color="#C4A2A7">@</font><font color="#8F4A89">@</font><font color="#EFE5C2">@</font><font color="#FFFFCC">@</font><font color="#F5F0C5">@</font><font color="#A27390">@</font><font color="#742174">@</font><font color="#8F4A89">@</font><font color="#E6D7BD">@</font><font color="#FFFFCC">@</font><font color="#F5F0C5">@</font><font color="#A27390">@</font><font color="#742174">@@@</font><font color="#975C8A">@</font><font color="#FFFFCC">@@@@@</font><font color="#975C8A">@</font><font color="#DDC9B6">@@</font><font color="#742174">@</font><font color="#B7919E">@</font><font color="#FFFFCC">@</font><font color="#742174">@</font><font color="#8F4A89">@</font><font color="#EFE5C2">@</font><font color="#FFFFCC">@</font><font color="#E6D7BD">@</font><font color="#FFFFCC">@</font><font color="#742174">@</font><font color="#975C8A">@</font><font color="#FFFFCC">@</font><font color="#975C8A">@</font><font color="#DDC9B6">@@</font><font color="#742174">@</font><font color="#B7919E">@</font><font color="#FFFFCC">@</font><font color="#742174">@</font><font color="#8F4A89">@</font><font color="#E6D7BD">@</font><font color="#FFFFCC">@</font><font color="#F5F0C5">@</font><font color="#A27390">@</font><font color="#6B216B">@@@@@@@@@@@@<br>
</font><font color="#993399">@</font><font color="#A46FA4">@@</font><font color="#932893">@</font><font color="#996699">@@</font><font color="#852685">@</font><font color="#8C648C">@@</font><font color="#7C257C">@</font><font color="#855A85">@@</font><font color="#742174">@</font><font color="#7B5A7B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#AC9399">@</font><font color="#8C738C">@</font><font color="#742174">@</font><font color="#C0B6A6">@</font><font color="#F7F7C6">@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#6B216B">@</font><font color="#7B527B">@@</font><font color="#6B216B">@</font><font color="#735273">@@</font><font color="#6B216B">@</font><font color="#735273">@@</font><font color="#6B216B">@</font><font color="#735273">@@</font><font color="#6B216B">@</font><font color="#7B527B">@@<br>
</font><font color="#993399">@</font><font color="#A46FA4">@@</font><font color="#932893">@</font><font color="#996699">@@</font><font color="#852685">@</font><font color="#8C5B8C">@@</font><font color="#7C257C">@</font><font color="#855A85">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#AC9399">@</font><font color="#EFE5C2">@</font><font color="#FFFFCC">@</font><font color="#F7F7C6">@</font><font color="#AC9399">@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#6B216B">@</font><font color="#7B527B">@@</font><font color="#6B216B">@</font><font color="#735273">@@</font><font color="#6B216B">@</font><font color="#735273">@@</font><font color="#6B216B">@</font><font color="#735273">@</font><font color="#7B527B">@</font><font color="#742174">@</font><font color="#7B527B">@@<br>
</font><font color="#932893">@@@@</font><font color="#8C268C">@</font><font color="#852685">@@@</font><font color="#7C257C">@@@</font><font color="#742174">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#6B216B">@@@@@@@@</font><font color="#742174">@@@@@<br>
</font><font color="#932893">@</font><font color="#A46FA4">@@</font><font color="#8C268C">@</font><font color="#996699">@@</font><font color="#852685">@</font><font color="#8C5B8C">@@</font><font color="#7C257C">@</font><font color="#855A85">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#7B527B">@@</font><font color="#742174">@</font><font color="#855A85">@@<br>
</font>
</span>
<BR>

<style type="text/css">.asciiimage{
        color           : #000000;
        background-color: #FFFFFF;
        font-size       : 6px;
        font-family     : "Courier New", Courier, mono;
        line-height     : 4px;
        letter-spacing  : 0px;
    }</style><span class="asciiimage"><font color="#418BD5">@</font><font color="#4B93DB">@</font><font color="#579ADD">@@</font><font color="#64A4E3">@@</font><font color="#579ADD">@@@</font><font color="#4B93DB">@</font><font color="#428EDA">@@@</font><font color="#3786D6">@@@</font><font color="#3484D4">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#3281CF">@@</font><font color="#2F7DCC">@@</font><font color="#2A79C7">@@@</font><font color="#2973BC">@@</font><font color="#246CB4">@@@@<br>
</font><font color="#4B93DB">@</font><font color="#9CBCDD">@</font><font color="#A3C5E6">@</font><font color="#73ADE6">@</font><font color="#ACC9E6">@@</font><font color="#68A4E0">@</font><font color="#A3C5E6">@</font><font color="#9CBCDD">@</font><font color="#4B93DB">@</font><font color="#93B6D9">@@</font><font color="#418BD5">@</font><font color="#8BB2D8">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#2F7DCC">@</font><font color="#7DA5CD">@@</font><font color="#2A79C7">@</font><font color="#799DC3">@</font><font color="#7399BD">@</font><font color="#2973BC">@</font><font color="#7196BB">@</font><font color="#6A90B6">@</font><font color="#246CB4">@</font><font color="#6A8CAD">@@<br>
</font><font color="#579ADD">@</font><font color="#A3C5E6">@</font><font color="#ACC9E6">@</font><font color="#7EB3E9">@</font><font color="#B4CFEA">@@</font><font color="#73ADE6">@</font><font color="#ACC9E6">@</font><font color="#A3C5E6">@</font><font color="#579ADD">@</font><font color="#93B6D9">@@</font><font color="#428EDA">@</font><font color="#8BB2D8">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@</font><font color="#8BB2D8">@</font><font color="#68A4E0">@</font><font color="#A3C1DE">@@</font><font color="#68A4E0">@</font><font color="#A3C1DE">@</font><font color="#85ADD5">@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#579ADD">@</font><font color="#9CBCDD">@</font><font color="#85ADD5">@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@</font><font color="#93B6D9">@</font><font color="#68A4E0">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85A9CD">@@</font><font color="#2F7DCC">@</font><font color="#7CA2C8">@@</font><font color="#2976C4">@</font><font color="#7399BD">@@</font><font color="#2973BC">@</font><font color="#6A90B6">@@</font><font color="#2369AE">@</font><font color="#6A8CAD">@@<br>
</font><font color="#579ADD">@</font><font color="#73ADE6">@</font><font color="#7EB3E9">@</font><font color="#90BEED">@@@@</font><font color="#73ADE6">@</font><font color="#68A4E0">@@</font><font color="#579ADD">@</font><font color="#4B93DB">@</font><font color="#428EDA">@@</font><font color="#3786D6">@@@@</font><font color="#3484D4">@@@@@@@@@@@</font><font color="#68A4E0">@</font><font color="#FFFFFF">@@@@@</font><font color="#3484D4">@@@@@@@</font><font color="#CCDFF3">@@</font><font color="#3484D4">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#A3C5E6">@</font><font color="#FFFFFF">@</font><font color="#3484D4">@@@@@@@@@@@@</font><font color="#3281CF">@@</font><font color="#2F7DCC">@</font><font color="#2A79C7">@@@</font><font color="#2973BC">@@</font><font color="#246CB4">@@</font><font color="#2369AE">@@@@<br>
</font><font color="#64A4E3">@</font><font color="#ACC9E6">@</font><font color="#B4CFEA">@</font><font color="#90BEED">@</font><font color="#C1D5E9">@@</font><font color="#90BEED">@</font><font color="#B4CFEA">@</font><font color="#ACC9E6">@</font><font color="#64A4E3">@</font><font color="#9CBCDD">@@</font><font color="#428EDA">@</font><font color="#8BB2D8">@@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@</font><font color="#A3C1DE">@</font><font color="#FFFFFF">@</font><font color="#A3C1DE">@</font><font color="#85ADD5">@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#579ADD">@</font><font color="#93B6D9">@@</font><font color="#68A4E0">@</font><font color="#85ADD5">@@</font><font color="#CCDFF3">@</font><font color="#D9E8F6">@</font><font color="#8BB2D8">@</font><font color="#68A4E0">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#8BB2D8">@</font><font color="#A3C1DE">@</font><font color="#68A4E0">@</font><font color="#85ADD5">@@</font><font color="#68A4E0">@</font><font color="#8BB2D8">@</font><font color="#9CBCDD">@</font><font color="#579ADD">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#93B6D9">@</font><font color="#A3C1DE">@</font><font color="#418BD5">@</font><font color="#85ADD5">@@</font><font color="#418BD5">@</font><font color="#A3C1DE">@</font><font color="#93B6D9">@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#579ADD">@</font><font color="#9CBCDD">@</font><font color="#C1D5E9">@</font><font color="#FFFFFF">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#3281CF">@</font><font color="#7DA5CD">@@</font><font color="#2A79C7">@</font><font color="#799DC3">@@</font><font color="#2973BC">@</font><font color="#7196BB">@@</font><font color="#246CB4">@</font><font color="#6A8CAD">@@</font><font color="#2163A5">@</font><font color="#6483A3">@@<br>
</font><font color="#64A4E3">@</font><font color="#ACC9E6">@</font><font color="#B4CFEA">@</font><font color="#90BEED">@</font><font color="#C1D5E9">@@</font><font color="#90BEED">@</font><font color="#B4CFEA">@</font><font color="#ACC9E6">@</font><font color="#64A4E3">@</font><font color="#9CBCDD">@@</font><font color="#428EDA">@</font><font color="#8BB2D8">@</font><font color="#85ADD5">@</font><font color="#3786D6">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@</font><font color="#A3C1DE">@</font><font color="#FFFFFF">@</font><font color="#CCDFF3">@</font><font color="#C1D5E9">@</font><font color="#A3C5E6">@</font><font color="#ACC9E6">@</font><font color="#85ADD5">@</font><font color="#CCDFF3">@</font><font color="#E8EFF7">@@</font><font color="#F8FAFC">@</font><font color="#D9E8F6">@</font><font color="#85ADD5">@</font><font color="#CCDFF3">@</font><font color="#F6F7F7">@</font><font color="#D9E8F6">@</font><font color="#F8FAFC">@</font><font color="#D9E8F6">@</font><font color="#85ADD5">@</font><font color="#4B93DB">@</font><font color="#F8FAFC">@</font><font color="#D9E8F6">@</font><font color="#F8FAFC">@</font><font color="#D9E8F6">@</font><font color="#85ADD5">@</font><font color="#FFFFFF">@</font><font color="#E8EFF7">@@</font><font color="#FFFFFF">@</font><font color="#C1D5E9">@</font><font color="#85ADD5">@</font><font color="#B4CFEA">@</font><font color="#F8FAFC">@</font><font color="#E8EFF7">@</font><font color="#FFFFFF">@</font><font color="#ACC9E6">@</font><font color="#9CBCDD">@</font><font color="#F8FAFC">@</font><font color="#E8EFF7">@</font><font color="#F8FAFC">@</font><font color="#ACC9E6">@</font><font color="#85ADD5">@</font><font color="#ACC9E6">@</font><font color="#FFFFFF">@</font><font color="#D9E8F6">@</font><font color="#F8FAFC">@</font><font color="#FFFFFF">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85ADD5">@@</font><font color="#3484D4">@</font><font color="#85A9CD">@@</font><font color="#3281CF">@</font><font color="#7DA5CD">@@</font><font color="#2A79C7">@</font><font color="#799DC3">@@</font><font color="#2973BC">@</font><font color="#6A90B6">@@</font><font color="#2369AE">@</font><font color="#6185AA">@@</font><font color="#2163A5">@</font><font color="#6483A3">@@<br>
</font><font color="#579ADD">@</font><font color="#68A4E0">@</font><font color="#73ADE6">@</font><font color="#7EB3E9">@</font><font color="#90BEED">@@@</font><font color="#7EB3E9">@</font><font color="#73ADE6">@</font><font color="#64A4E3">@</font><font color="#579ADD">@</font><font color="#4B93DB">@</font><font color="#428EDA">@</font><font color="#3786D6">@@@</font><font color="#3281CF">@@@@@@@@@@@@@</font><font color="#68A4E0">@</font><font color="#FFFFFF">@</font><font color="#D9E8F6">@</font><font color="#CCDFF3">@@</font><font color="#A3C5E6">@</font><font color="#3281CF">@</font><font color="#CCDFF3">@</font><font color="#D9E8F6">@</font><font color="#3281CF">@</font><font color="#A3C5E6">@</font><font color="#FFFFFF">@</font><font color="#3281CF">@</font><font color="#CCDFF3">@</font><font color="#D9E8F6">@</font><font color="#3281CF">@</font><font color="#90BEED">@</font><font color="#FFFFFF">@</font><font color="#3281CF">@</font><font color="#4B93DB">@</font><font color="#73ADE6">@</font><font color="#3281CF">@</font><font color="#B4CFEA">@</font><font color="#FFFFFF">@</font><font color="#3281CF">@</font><font color="#FFFFFF">@</font><font color="#A3C5E6">@</font><font color="#3281CF">@</font><font color="#D9E8F6">@</font><font color="#CCDFF3">@</font><font color="#4B93DB">@</font><font color="#FFFFFF">@</font><font color="#7EB3E9">@</font><font color="#3281CF">@</font><font color="#90BEED">@</font><font color="#579ADD">@</font><font color="#B4CFEA">@</font><font color="#E8EFF7">@</font><font color="#3281CF">@</font><font color="#73ADE6">@</font><font color="#FFFFFF">@</font><font color="#4B93DB">@</font><font color="#F8FAFC">@</font><font color="#B4CFEA">@</font><font color="#3281CF">@</font><font color="#B4CFEA">@</font><font color="#FFFFFF">@</font><font color="#3281CF">@@@@@@@@@@@</font><font color="#2F7DCC">@@</font><font color="#2A79C7">@@@</font><font color="#2973BC">@@</font><font color="#246CB4">@</font><font color="#2369AE">@@</font><font color="#2163A5">@</font><font color="#2060A1">@@@@<br>
</font><font color="#579ADD">@</font><font color="#A3C5E6">@@</font><font color="#73ADE6">@</font><font color="#B4CFEA">@@</font><font color="#7EB3E9">@</font><font color="#B4CFEA">@</font><font color="#ACC9E6">@</font><font color="#64A4E3">@</font><font color="#93B6D9">@@</font><font color="#418BD5">@</font><font color="#85ADD5">@@</font><font color="#3281CF">@</font><font color="#7DA5CD">@@</font><font color="#2F7DCC">@</font><font color="#7DA5CD">@@</font><font color="#2F7DCC">@</font><font color="#7DA5CD">@@</font><font color="#2F7DCC">@</font><font color="#7DA5CD">@@</font><font color="#2F7DCC">@</font><font color="#7DA5CD">@</font><font color="#9CBCDD">@</font><font color="#FFFFFF">@</font><font color="#9CBCDD">@</font><font color="#7DA5CD">@</font><font color="#2F7DCC">@</font><font color="#7DA5CD">@@</font><font color="#CCDFF3">@</font><font color="#D9E8F6">@</font><font color="#7DA5CD">@</font><font color="#9CBCDD">@</font><font color="#FFFFFF">@</font><font color="#7DA5CD">@</font><font color="#CCDFF3">@</font><font color="#D9E8F6">@</font><font color="#7DA5CD">@</font><font color="#9CBCDD">@</font><font color="#FFFFFF">@</font><font color="#7DA5CD">@</font><font color="#5695D5">@</font><font color="#E8EFF7">@</font><font color="#D9E8F6">@</font><font color="#CCDFF3">@</font><font color="#FFFFFF">@</font><font color="#7DA5CD">@</font><font color="#FFFFFF">@</font><font color="#C1D5E9">@</font><font color="#7DA5CD">@</font><font color="#CCDFF3">@</font><font color="#D9E8F6">@</font><font color="#9CBCDD">@</font><font color="#FFFFFF">@</font><font color="#9CBCDD">@</font><font color="#7DA5CD">@</font><font color="#2F7DCC">@</font><font color="#7DA5CD">@</font><font color="#D9E8F6">@</font><font color="#F8FAFC">@</font><font color="#D9E8F6">@@</font><font color="#CCDFF3">@</font><font color="#9BB7D4">@</font><font color="#FFFFFF">@</font><font color="#9CBCDD">@</font><font color="#7DA5CD">@</font><font color="#C1D5E9">@</font><font color="#FFFFFF">@</font><font color="#7DA5CD">@@</font><font color="#2F7DCC">@</font><font color="#7DA5CD">@@</font><font color="#2F7DCC">@</font><font color="#7DA5CD">@@</font><font color="#2F7DCC">@</font><font color="#7DA5CD">@@</font><font color="#2A79C7">@</font><font color="#7CA2C8">@</font><font color="#799DC3">@</font><font color="#2976C4">@</font><font color="#7399BD">@@</font><font color="#246CB4">@</font><font color="#6A8CAD">@@</font><font color="#2163A5">@</font><font color="#6483A3">@@</font><font color="#2060A1">@</font><font color="#58799A">@@<br>
</font><font color="#4B93DB">@</font><font color="#9CBCDD">@</font><font color="#A3C5E6">@</font><font color="#68A4E0">@</font><font color="#ACC9E6">@@</font><font color="#73ADE6">@</font><font color="#ACC9E6">@</font><font color="#A3C1DE">@</font><font color="#579ADD">@</font><font color="#93B6D9">@</font><font color="#8BAFD4">@</font><font color="#3A84CE">@</font><font color="#85A9CD">@@</font><font color="#2F7DCC">@</font><font color="#7CA2C8">@@</font><font color="#2F7DCC">@</font><font color="#7CA2C8">@@</font><font color="#2F7DCC">@</font><font color="#7CA2C8">@@</font><font color="#2F7DCC">@</font><font color="#7CA2C8">@@</font><font color="#2F7DCC">@</font><font color="#7CA2C8">@</font><font color="#9BB7D4">@</font><font color="#FFFFFF">@</font><font color="#B4CFEA">@</font><font color="#9BB7D4">@</font><font color="#629DD7">@</font><font color="#9BB7D4">@</font><font color="#85A9CD">@</font><font color="#CCDFF3">@</font><font color="#DFE6EC">@</font><font color="#7CA2C8">@</font><font color="#9CBCDD">@</font><font color="#FFFFFF">@</font><font color="#7CA2C8">@</font><font color="#CCDFF3">@</font><font color="#DFE6EC">@</font><font color="#7CA2C8">@</font><font color="#9CBCDD">@</font><font color="#FFFFFF">@</font><font color="#7CA2C8">@</font><font color="#CCDFF3">@</font><font color="#E8EFF7">@</font><font color="#7CA2C8">@</font><font color="#C1D5E9">@</font><font color="#FFFFFF">@</font><font color="#7CA2C8">@</font><font color="#FFFFFF">@</font><font color="#C1D5E9">@</font><font color="#7CA2C8">@</font><font color="#CCDFF3">@</font><font color="#DFE6EC">@</font><font color="#85A9CD">@</font><font color="#FFFFFF">@</font><font color="#C1D5E9">@</font><font color="#85A9CD">@</font><font color="#E8EFF7">@</font><font color="#C1D5E9">@@</font><font color="#F8FAFC">@</font><font color="#85A9CD">@</font><font color="#93B6D9">@</font><font color="#85ADD5">@</font><font color="#85A9CD">@</font><font color="#E8EFF7">@</font><font color="#CCDFF3">@</font><font color="#7CA2C8">@</font><font color="#DFE6EC">@</font><font color="#FFFFFF">@</font><font color="#7CA2C8">@@</font><font color="#2F7DCC">@</font><font color="#7CA2C8">@@</font><font color="#2F7DCC">@</font><font color="#7CA2C8">@@</font><font color="#2F7DCC">@</font><font color="#7CA2C8">@@</font><font color="#2A79C7">@</font><font color="#799DC3">@@</font><font color="#2973BC">@</font><font color="#7196BB">@</font><font color="#6A90B6">@</font><font color="#2369AE">@</font><font color="#6A8CAD">@</font><font color="#6483A3">@</font><font color="#2060A1">@</font><font color="#627C96">@@</font><font color="#235B92">@</font><font color="#58799A">@@<br>
</font><font color="#4B93DB">@@</font><font color="#579ADD">@@</font><font color="#64A4E3">@@@@</font><font color="#579ADD">@</font><font color="#4B93DB">@</font><font color="#418BD5">@@</font><font color="#3281CF">@@</font><font color="#2F7DCC">@</font><font color="#2A79C7">@@@@@@@@@@@@@@</font><font color="#629DD7">@</font><font color="#FFFFFF">@@@@@</font><font color="#629DD7">@</font><font color="#CCDFF3">@@</font><font color="#2A79C7">@</font><font color="#9CBCDD">@</font><font color="#FFFFFF">@</font><font color="#2163A5">@</font><font color="#C5CFE5">@@</font><font color="#0D1D7A">@</font><font color="#7C9AB8">@</font><font color="#FFFFFF">@</font><font color="#000066">@</font><font color="#5D72A1">@</font><font color="#E8EFF7">@@</font><font color="#A9B7C6">@</font><font color="#FFFFFF">@</font><font color="#101370">@</font><font color="#FFFFFF">@</font><font color="#7C9AB8">@</font><font color="#0D1D7A">@</font><font color="#C5CFE5">@@</font><font color="#2163A5">@</font><font color="#7DA5CD">@</font><font color="#E8EFF7">@</font><font color="#FFFFFF">@</font><font color="#CCDFF3">@</font><font color="#4D8BC9">@</font><font color="#3A84CE">@</font><font color="#C1D5E9">@</font><font color="#FFFFFF">@@</font><font color="#A3C5E6">@</font><font color="#2A79C7">@</font><font color="#5695D5">@</font><font color="#E8EFF7">@</font><font color="#FFFFFF">@</font><font color="#CCDFF3">@</font><font color="#FFFFFF">@</font><font color="#2A79C7">@@@@@@@@@@@@</font><font color="#2973BC">@@@</font><font color="#246CB4">@@</font><font color="#2369AE">@</font><font color="#2163A5">@@</font><font color="#2060A1">@</font><font color="#235B92">@@@@@<br>
</font><font color="#428EDA">@</font><font color="#93B6D9">@@</font><font color="#579ADD">@</font><font color="#9CBCDD">@@</font><font color="#579ADD">@</font><font color="#93B6D9">@@</font><font color="#418BD5">@</font><font color="#85ADD5">@</font><font color="#85A9CD">@</font><font color="#2F7DCC">@</font><font color="#7CA2C8">@@</font><font color="#2A79C7">@</font><font color="#799DC3">@@</font><font color="#2976C4">@</font><font color="#799DC3">@@</font><font color="#2976C4">@</font><font color="#799DC3">@@</font><font color="#2976C4">@</font><font color="#799DC3">@@</font><font color="#2976C4">@</font><font color="#799DC3">@@</font><font color="#2976C4">@</font><font color="#799DC3">@@</font><font color="#2976C4">@</font><font color="#799DC3">@@</font><font color="#1B50A4">@</font><font color="#404089">@</font><font color="#1F2475">@</font><font color="#05086B">@</font><font color="#000066">@@@@@@@@@@@@@@@@@@@@@</font><font color="#05086B">@</font><font color="#1F2475">@</font><font color="#11328C">@</font><font color="#537CA5">@</font><font color="#799DC3">@</font><font color="#2976C4">@</font><font color="#799DC3">@@</font><font color="#2976C4">@</font><font color="#799DC3">@@</font><font color="#2976C4">@</font><font color="#799DC3">@@</font><font color="#2976C4">@</font><font color="#799DC3">@@</font><font color="#2976C4">@</font><font color="#799DC3">@@</font><font color="#2976C4">@</font><font color="#799DC3">@@</font><font color="#2976C4">@</font><font color="#799DC3">@@</font><font color="#2973BC">@</font><font color="#7399BD">@@</font><font color="#246CB4">@</font><font color="#6A90B6">@</font><font color="#6A8CAD">@</font><font color="#2163A5">@</font><font color="#6483A3">@@</font><font color="#235B92">@</font><font color="#58799A">@</font><font color="#537291">@</font><font color="#1C538B">@</font><font color="#537291">@@<br>
</font><font color="#428EDA">@</font><font color="#8BB2D8">@</font><font color="#93B6D9">@</font><font color="#4B93DB">@</font><font color="#93B6D9">@@</font><font color="#4B93DB">@</font><font color="#93B6D9">@</font><font color="#8BAFD4">@</font><font color="#3A84CE">@</font><font color="#85A9CD">@</font><font color="#7DA5CD">@</font><font color="#2A79C7">@</font><font color="#799DC3">@@</font><font color="#2976C4">@</font><font color="#7399BD">@@</font><font color="#2973BC">@</font><font color="#7399BD">@@</font><font color="#2973BC">@</font><font color="#7399BD">@@</font><font color="#2973BC">@</font><font color="#7399BD">@@</font><font color="#2973BC">@</font><font color="#7399BD">@@</font><font color="#2973BC">@</font><font color="#7399BD">@@</font><font color="#1B50A4">@</font><font color="#182E83">@</font><font color="#05086B">@</font><font color="#000066">@@@@@@@@@@@@@</font><font color="#40407B">@@</font><font color="#303078">@</font><font color="#05086B">@</font><font color="#000066">@@@@@@@@@@@@</font><font color="#05086B">@</font><font color="#0D1D7A">@</font><font color="#4A739C">@</font><font color="#7399BD">@</font><font color="#2973BC">@</font><font color="#7399BD">@@</font><font color="#2973BC">@</font><font color="#7399BD">@@</font><font color="#2973BC">@</font><font color="#7399BD">@@</font><font color="#2973BC">@</font><font color="#7399BD">@@</font><font color="#2973BC">@</font><font color="#7399BD">@@</font><font color="#2973BC">@</font><font color="#7399BD">@@</font><font color="#2973BC">@</font><font color="#7196BB">@@</font><font color="#246CB4">@</font><font color="#6A8CAD">@@</font><font color="#2163A5">@</font><font color="#6483A3">@</font><font color="#58799A">@</font><font color="#235B92">@</font><font color="#5B758F">@@</font><font color="#1C538B">@</font><font color="#526D89">@@<br>
</font><font color="#418BD5">@@</font><font color="#428EDA">@@@@@</font><font color="#418BD5">@</font><font color="#3A84CE">@@</font><font color="#2F7DCC">@@</font><font color="#2A79C7">@@</font><font color="#2973BC">@@@@@@@@@@@@@@@@</font><font color="#2369AE">@</font><font color="#11328C">@</font><font color="#05086B">@</font><font color="#000066">@@@@@@@@@@@@@@@</font><font color="#303078">@</font><font color="#FFFF8C">@</font><font color="#EDED62">@</font><font color="#CECE25">@</font><font color="#00005A">@</font><font color="#000066">@@@@@@@@@@@@@@@</font><font color="#05086B">@</font><font color="#11328C">@</font><font color="#2369AE">@</font><font color="#2973BC">@@@@@@@@@@@@@@@@</font><font color="#246CB4">@@@@</font><font color="#2369AE">@@</font><font color="#2163A5">@</font><font color="#2060A1">@@</font><font color="#235B92">@</font><font color="#1C538B">@@@@@<br>
</font><font color="#418BD5">@</font><font color="#8BB2D8">@@</font><font color="#418BD5">@</font><font color="#8BB2D8">@@</font><font color="#418BD5">@</font><font color="#85ADD5">@</font><font color="#85A9CD">@</font><font color="#3281CF">@</font><font color="#7CA2C8">@@</font><font color="#2976C4">@</font><font color="#7399BD">@@</font><font color="#2973BC">@</font><font color="#7196BB">@@</font><font color="#2973BC">@</font><font color="#7196BB">@@</font><font color="#2973BC">@</font><font color="#7196BB">@@</font><font color="#2973BC">@</font><font color="#7196BB">@@</font><font color="#2973BC">@</font><font color="#6185AA">@</font><font color="#2A3D83">@</font><font color="#000066">@@@@@@@@@@@@@@@@@@</font><font color="#606081">@</font><font color="#FAFA79">@</font><font color="#D6D644">@</font><font color="#AEAE0E">@</font><font color="#000066">@@@@@@@@@@@@@@@@@@@</font><font color="#2A3D83">@</font><font color="#2369AE">@</font><font color="#7196BB">@@</font><font color="#2973BC">@</font><font color="#7196BB">@@</font><font color="#2973BC">@</font><font color="#7196BB">@@</font><font color="#2973BC">@</font><font color="#7196BB">@@</font><font color="#2973BC">@</font><font color="#7196BB">@@</font><font color="#246CB4">@</font><font color="#6A90B6">@@</font><font color="#2369AE">@</font><font color="#6A87A5">@@</font><font color="#2060A1">@</font><font color="#58799A">@@</font><font color="#235B92">@</font><font color="#537291">@@</font><font color="#1C538B">@</font><font color="#526D89">@@<br>
</font><font color="#418BD5">@</font><font color="#8BAFD4">@@</font><font color="#418BD5">@</font><font color="#8BAFD4">@@</font><font color="#3786D6">@</font><font color="#85A9CD">@@</font><font color="#327BC5">@</font><font color="#7CA2C8">@</font><font color="#799DC3">@</font><font color="#2976C4">@</font><font color="#7399BD">@@</font><font color="#2973BC">@</font><font color="#7196BB">@@</font><font color="#2C71B5">@</font><font color="#7394B6">@@</font><font color="#2C71B5">@</font><font color="#7394B6">@@</font><font color="#2C71B5">@</font><font color="#7394B6">@@</font><font color="#214694">@</font><font color="#05086B">@</font><font color="#000066">@@@@@@@@@@@@@@@@@@@</font><font color="#909071">@</font><font color="#FAFA79">@</font><font color="#CECE25">@</font><font color="#8F8F22">@</font><font color="#00005A">@@@@@</font><font color="#000066">@@@@@@@@@@@@@@@</font><font color="#05086B">@</font><font color="#36628D">@</font><font color="#7394B6">@</font><font color="#2C71B5">@</font><font color="#7394B6">@@</font><font color="#2C71B5">@</font><font color="#7394B6">@@</font><font color="#2C71B5">@</font><font color="#7394B6">@@</font><font color="#2C71B5">@</font><font color="#7394B6">@@</font><font color="#246CB4">@</font><font color="#6A90B6">@</font><font color="#6A8CAD">@</font><font color="#2369AE">@</font><font color="#6A87A5">@</font><font color="#6483A3">@</font><font color="#25619D">@</font><font color="#58799A">@@</font><font color="#235B92">@</font><font color="#526D89">@@</font><font color="#1C538B">@</font><font color="#526D89">@@<br>
</font><font color="#418BD5">@@@@@@</font><font color="#3A84CE">@@@</font><font color="#327BC5">@@@</font><font color="#2973BC">@@@</font><font color="#2C71B5">@@@@@@@@@@@</font><font color="#0D1D7A">@</font><font color="#000066">@@@@@@@@@@@@@@@@@@@@@</font><font color="#C0C072">@</font><font color="#EDED62">@</font><font color="#CECE25">@</font><font color="#515132">@</font><font color="#00005A">@@@@@@</font><font color="#000066">@@@@@@@@@@@@@@@@</font><font color="#0D1D7A">@</font><font color="#246CB4">@</font><font color="#2C71B5">@@@@@@@@@@@@@</font><font color="#2369AE">@@@</font><font color="#25619D">@@</font><font color="#235B92">@@@</font><font color="#225485">@@@@@<br>
</font><font color="#418BD5">@</font><font color="#8BAFD4">@@</font><font color="#418BD5">@</font><font color="#8BAFD4">@@</font><font color="#3A84CE">@</font><font color="#85A9CD">@@</font><font color="#327BC5">@</font><font color="#799DC3">@@</font><font color="#3173B7">@</font><font color="#7399BD">@@</font><font color="#3173B7">@</font><font color="#7394B6">@@</font><font color="#2C71B5">@</font><font color="#7394B6">@@</font><font color="#2C71B5">@</font><font color="#7394B6">@@</font><font color="#2163A5">@</font><font color="#101370">@</font><font color="#000066">@@@@@@@</font><font color="#606081">@</font><font color="#80807B">@@</font><font color="#40407B">@</font><font color="#101370">@</font><font color="#70706F">@</font><font color="#BDBD56">@</font><font color="#BFBF43">@</font><font color="#60605E">@</font><font color="#05086B">@</font><font color="#000066">@@@@@</font><font color="#FFFF66">@</font><font color="#EDED62">@</font><font color="#CECE25">@</font><font color="#303051">@</font><font color="#060A49">@</font><font color="#67673E">@</font><font color="#B8B837">@</font><font color="#BFBF43">@</font><font color="#A3A336">@</font><font color="#30305A">@</font><font color="#000066">@@@@</font><font color="#40407B">@</font><font color="#80807B">@@</font><font color="#666666">@</font><font color="#000066">@</font><font color="#666666">@</font><font color="#A5A557">@</font><font color="#BDBD56">@</font><font color="#80805B">@</font><font color="#1F2475">@</font><font color="#000066">@@@</font><font color="#091070">@</font><font color="#5D72A1">@</font><font color="#7394B6">@</font><font color="#2C71B5">@</font><font color="#7394B6">@@</font><font color="#2C71B5">@</font><font color="#7394B6">@@</font><font color="#2C71B5">@</font><font color="#7394B6">@@</font><font color="#2C71B5">@</font><font color="#6A8CAD">@@</font><font color="#2369AE">@</font><font color="#6A87A5">@</font><font color="#6483A3">@</font><font color="#25619D">@</font><font color="#627C96">@</font><font color="#5B758F">@</font><font color="#235B92">@</font><font color="#576E85">@@</font><font color="#225485">@</font><font color="#536B84">@@<br>
</font><font color="#418BD5">@</font><font color="#8BAFD4">@@</font><font color="#418BD5">@</font><font color="#8BAFD4">@@</font><font color="#418BD5">@</font><font color="#85A9CD">@@</font><font color="#327BC5">@</font><font color="#799DC3">@@</font><font color="#3173B7">@</font><font color="#7399BD">@@</font><font color="#3173B7">@</font><font color="#7394B6">@@</font><font color="#3173B7">@</font><font color="#7394B6">@@</font><font color="#3173B7">@</font><font color="#7394B6">@</font><font color="#6A8CAD">@</font><font color="#091070">@</font><font color="#000066">@@@@@@@@</font><font color="#FFFF8C">@</font><font color="#FFFF99">@</font><font color="#EBEB71">@</font><font color="#9A9A6E">@</font><font color="#DFDF57">@</font><font color="#E6E64B">@</font><font color="#E7E73D">@</font><font color="#F2F235">@@</font><font color="#CECE25">@</font><font color="#00005A">@</font><font color="#000066">@@@</font><font color="#303078">@</font><font color="#FAFA79">@</font><font color="#EDED62">@</font><font color="#C4C423">@</font><font color="#515132">@</font><font color="#C4C423">@</font><font color="#D3D32B">@</font><font color="#E5E531">@</font><font color="#F2F235">@@</font><font color="#E4E420">@</font><font color="#212758">@</font><font color="#000066">@@@</font><font color="#C0C072">@</font><font color="#FFFF99">@</font><font color="#FFFF8C">@</font><font color="#CCCC66">@</font><font color="#BDBD56">@</font><font color="#E6E64B">@@</font><font color="#F3F340">@@</font><font color="#E4E420">@</font><font color="#303051">@</font><font color="#000066">@@@</font><font color="#101370">@</font><font color="#6A8CAD">@</font><font color="#3173B7">@</font><font color="#7394B6">@@</font><font color="#3173B7">@</font><font color="#7394B6">@@</font><font color="#3173B7">@</font><font color="#7394B6">@@</font><font color="#2C71B5">@</font><font color="#6A8CAD">@@</font><font color="#346CA4">@</font><font color="#6A87A5">@</font><font color="#6483A3">@</font><font color="#25619D">@</font><font color="#627C96">@</font><font color="#5B758F">@</font><font color="#2B5C8D">@</font><font color="#576E85">@@</font><font color="#225485">@</font><font color="#536B84">@@<br>
</font><font color="#418BD5">@@@@@@@@</font><font color="#3A84CE">@@</font><font color="#327BC5">@@@</font><font color="#3173B7">@@@@@@@@@@</font><font color="#0D1D7A">@</font><font color="#000066">@@@@@@@@</font><font color="#303078">@</font><font color="#FFFF99">@</font><font color="#F2F280">@</font><font color="#BFBF43">@</font><font color="#959521">@@</font><font color="#808024">@</font><font color="#ACAC28">@</font><font color="#E5E531">@@</font><font color="#DADA13">@</font><font color="#808024">@</font><font color="#00005A">@@@</font><font color="#606081">@</font><font color="#FAFA79">@</font><font color="#DFDF57">@</font><font color="#A2A219">@</font><font color="#8F8F0B">@</font><font color="#A3A30D">@</font><font color="#74741D">@</font><font color="#ACAC28">@</font><font color="#E7E73D">@</font><font color="#F2F235">@</font><font color="#DADA13">@</font><font color="#8F8F22">@</font><font color="#00005A">@@@</font><font color="#F2F280">@</font><font color="#FFFF99">@</font><font color="#F2F280">@</font><font color="#DEDE44">@</font><font color="#C0C02A">@</font><font color="#808024">@</font><font color="#A3A336">@</font><font color="#E5E531">@@</font><font color="#DADA13">@</font><font color="#C4C412">@</font><font color="#00005A">@@@@</font><font color="#0D1D7A">@</font><font color="#3173B7">@@@@@@@@@@@</font><font color="#346CA4">@@@</font><font color="#25619D">@@@</font><font color="#2B5C8D">@@</font><font color="#225485">@@@@@<br>
</font><font color="#418BD5">@</font><font color="#8BB2D8">@@</font><font color="#418BD5">@</font><font color="#8BAFD4">@@</font><font color="#418BD5">@</font><font color="#85A9CD">@@</font><font color="#4284C6">@</font><font color="#7CA2C8">@@</font><font color="#3B79B8">@</font><font color="#7C9AB8">@@</font><font color="#3976B3">@</font><font color="#7394B6">@@</font><font color="#3976B3">@</font><font color="#7394B6">@@</font><font color="#3976B3">@</font><font color="#5D72A1">@</font><font color="#000066">@@@@@@@@@</font><font color="#606081">@</font><font color="#FFFF99">@</font><font color="#DDDD6E">@</font><font color="#8F8F22">@</font><font color="#3A3A25">@</font><font color="#000052">@@@</font><font color="#A5A557">@</font><font color="#F3F340">@</font><font color="#CFCF0F">@@</font><font color="#000052">@@</font><font color="#00005A">@</font><font color="#909071">@</font><font color="#EBEB71">@</font><font color="#B8B837">@</font><font color="#808009">@</font><font color="#585816">@</font><font color="#000042">@@@</font><font color="#CCCC66">@</font><font color="#F0F059">@</font><font color="#CECE25">@</font><font color="#8F8F0B">@</font><font color="#000052">@@</font><font color="#1F2475">@</font><font color="#FFFF8C">@</font><font color="#EBEB71">@</font><font color="#BFBF43">@</font><font color="#808024">@</font><font color="#060A49">@</font><font color="#00005A">@@</font><font color="#60605E">@</font><font color="#F2F235">@</font><font color="#E4E420">@</font><font color="#CFCF0F">@</font><font color="#262640">@</font><font color="#000052">@@</font><font color="#00005A">@@</font><font color="#235B92">@</font><font color="#7394B6">@@</font><font color="#3976B3">@</font><font color="#7394B6">@@</font><font color="#3976B3">@</font><font color="#7394B6">@@</font><font color="#3976B3">@</font><font color="#7491AE">@@</font><font color="#346CA4">@</font><font color="#6A87A5">@@</font><font color="#336699">@</font><font color="#627C96">@@</font><font color="#2B5C8D">@</font><font color="#5C7185">@@</font><font color="#225485">@</font><font color="#576E85">@@<br>
</font><font color="#4B93DB">@</font><font color="#8BB2D8">@@</font><font color="#4B93DB">@</font><font color="#8BAFD4">@@</font><font color="#418BD5">@</font><font color="#85A9CD">@@</font><font color="#4284C6">@</font><font color="#7CA2C8">@@</font><font color="#3B79B8">@</font><font color="#7C9AB8">@@</font><font color="#3B79B8">@</font><font color="#7394B6">@@</font><font color="#3976B3">@</font><font color="#7394B6">@@</font><font color="#3976B3">@</font><font color="#2A3D83">@</font><font color="#000066">@@@@@@@@@</font><font color="#909071">@</font><font color="#F2F280">@</font><font color="#B8B837">@</font><font color="#74741D">@</font><font color="#000052">@@@@</font><font color="#212758">@</font><font color="#F3F340">@</font><font color="#CECE25">@</font><font color="#C4C412">@</font><font color="#262640">@</font><font color="#000052">@@</font><font color="#C0C072">@</font><font color="#EDED62">@</font><font color="#A2A219">@</font><font color="#585816">@</font><font color="#00004A">@</font><font color="#000042">@@@</font><font color="#C0C072">@</font><font color="#EDED62">@</font><font color="#C4C423">@</font><font color="#424224">@</font><font color="#00004A">@@</font><font color="#50506F">@</font><font color="#EBEB71">@</font><font color="#B8B837">@</font><font color="#8F8F0B">@</font><font color="#16163D">@</font><font color="#000052">@@@@</font><font color="#DEDE44">@</font><font color="#F2F235">@</font><font color="#C4C412">@</font><font color="#515132">@</font><font color="#00004A">@</font><font color="#000052">@@</font><font color="#00005A">@</font><font color="#182E83">@</font><font color="#7491AE">@@</font><font color="#3976B3">@</font><font color="#7394B6">@@</font><font color="#3976B3">@</font><font color="#7394B6">@@</font><font color="#3976B3">@</font><font color="#7491AE">@@</font><font color="#346CA4">@</font><font color="#6A87A5">@@</font><font color="#336699">@</font><font color="#627C96">@@</font><font color="#2B5C8D">@</font><font color="#5C7185">@@</font><font color="#2E5A85">@</font><font color="#576E85">@@<br>
</font><font color="#4B93DB">@@@@@@@</font><font color="#4D8BC9">@</font><font color="#4284C6">@@@@</font><font color="#3B79B8">@@@@</font><font color="#3976B3">@@@@@@</font><font color="#05086B">@</font><font color="#000066">@@@@@@@@@</font><font color="#C0C072">@</font><font color="#EDED62">@</font><font color="#A2A219">@</font><font color="#3A3A25">@</font><font color="#000052">@</font><font color="#00004A">@@@@</font><font color="#FBFB47">@</font><font color="#E7E73D">@</font><font color="#B6B614">@</font><font color="#171730">@</font><font color="#00004A">@@</font><font color="#FFFF66">@</font><font color="#E5E557">@</font><font color="#959521">@</font><font color="#23232D">@</font><font color="#00004A">@</font><font color="#000042">@@@</font><font color="#FFFF59">@</font><font color="#E6E64B">@</font><font color="#B6B61F">@</font><font color="#23232D">@</font><font color="#000042">@@</font><font color="#80805B">@</font><font color="#EDED62">@</font><font color="#ACAC28">@</font><font color="#686812">@</font><font color="#000052">@</font><font color="#00004A">@@@@</font><font color="#BFBF43">@</font><font color="#E7E73D">@</font><font color="#B6B614">@</font><font color="#424224">@</font><font color="#00004A">@@@</font><font color="#00005A">@@</font><font color="#3870A8">@</font><font color="#3976B3">@@@@@@@@@</font><font color="#3870A8">@@</font><font color="#346CA4">@@</font><font color="#336699">@@</font><font color="#2B5C8D">@@@</font><font color="#2E5A85">@@@@<br>
</font><font color="#5695D5">@</font><font color="#93B6D9">@@</font><font color="#5695D5">@</font><font color="#8BAFD4">@@</font><font color="#4D8BC9">@</font><font color="#8DACC9">@@</font><font color="#4284C6">@</font><font color="#85A0BB">@@</font><font color="#3B79B8">@</font><font color="#7C9AB8">@@</font><font color="#3B79B8">@</font><font color="#7A97B5">@@</font><font color="#3976B3">@</font><font color="#7A97B5">@@</font><font color="#3976B3">@</font><font color="#000066">@@@@@@@@@@</font><font color="#FFFF66">@</font><font color="#EDED62">@</font><font color="#ACAC28">@</font><font color="#16163D">@</font><font color="#000052">@</font><font color="#00004A">@</font><font color="#000042">@@</font><font color="#15194F">@</font><font color="#FFFF59">@</font><font color="#DEDE44">@</font><font color="#A2A219">@</font><font color="#171730">@</font><font color="#000042">@</font><font color="#30305A">@</font><font color="#FFFF66">@</font><font color="#D6D644">@</font><font color="#939314">@</font><font color="#060A49">@</font><font color="#00004A">@</font><font color="#000042">@@</font><font color="#303051">@</font><font color="#FFFF66">@</font><font color="#DEDE44">@</font><font color="#AEAE0E">@</font><font color="#000033">@</font><font color="#000042">@@</font><font color="#C0C072">@</font><font color="#EDED62">@</font><font color="#ACAC28">@</font><font color="#3A3A25">@</font><font color="#00004A">@@</font><font color="#000042">@@@</font><font color="#CCCC66">@</font><font color="#E6E64B">@</font><font color="#B6B61F">@</font><font color="#424224">@</font><font color="#000042">@@</font><font color="#00004A">@</font><font color="#000052">@</font><font color="#00005A">@</font><font color="#738DA7">@</font><font color="#7491AE">@</font><font color="#3976B3">@</font><font color="#7A97B5">@@</font><font color="#3976B3">@</font><font color="#7A97B5">@@</font><font color="#3976B3">@</font><font color="#7491AE">@@</font><font color="#3870A8">@</font><font color="#6A87A5">@@</font><font color="#336699">@</font><font color="#627C96">@@</font><font color="#2B5C8D">@</font><font color="#5C7185">@@</font><font color="#2E5A85">@</font><font color="#576E85">@@<br>
</font><font color="#5695D5">@</font><font color="#93B6D9">@@</font><font color="#5695D5">@</font><font color="#93B6D9">@@</font><font color="#558FC9">@</font><font color="#8DACC9">@@</font><font color="#4284C6">@</font><font color="#85A0BB">@@</font><font color="#4B83BA">@</font><font color="#7C9AB8">@@</font><font color="#427BB5">@</font><font color="#7A97B5">@@</font><font color="#427BB5">@</font><font color="#7A97B5">@@</font><font color="#427BB5">@</font><font color="#05086B">@</font><font color="#000066">@@@@@@@@</font><font color="#303078">@</font><font color="#FAFA79">@</font><font color="#EDED62">@</font><font color="#B6B61F">@</font><font color="#16163D">@</font><font color="#00004A">@</font><font color="#000042">@@@</font><font color="#505063">@</font><font color="#EDED62">@</font><font color="#C0C02A">@</font><font color="#8F8F0B">@</font><font color="#000042">@@</font><font color="#60605E">@</font><font color="#EDED62">@</font><font color="#C0C02A">@</font><font color="#8F8F0B">@</font><font color="#00004A">@</font><font color="#000042">@@@</font><font color="#60605E">@</font><font color="#F0F059">@</font><font color="#C0C02A">@</font><font color="#999900">@</font><font color="#000042">@@@</font><font color="#EDED62">@@</font><font color="#B6B61F">@</font><font color="#3A3A25">@</font><font color="#00004A">@</font><font color="#000042">@@@</font><font color="#15194F">@</font><font color="#FAFA79">@</font><font color="#DFDF57">@</font><font color="#A2A219">@</font><font color="#171730">@</font><font color="#000042">@@@</font><font color="#00004A">@</font><font color="#00005A">@</font><font color="#738DA7">@</font><font color="#7491AE">@</font><font color="#427BB5">@</font><font color="#7A97B5">@@</font><font color="#427BB5">@</font><font color="#7A97B5">@@</font><font color="#3976B3">@</font><font color="#7491AE">@@</font><font color="#3870A8">@</font><font color="#6A87A5">@@</font><font color="#336699">@</font><font color="#627C96">@@</font><font color="#36628D">@</font><font color="#5C7185">@@</font><font color="#2E5A85">@</font><font color="#5C7185">@@<br>
</font><font color="#5695D5">@@@@@@@</font><font color="#4D8BC9">@@@@</font><font color="#4284C6">@@</font><font color="#427BB5">@@@@@@@@@</font><font color="#182E83">@</font><font color="#000066">@@@@@@@@</font><font color="#606081">@</font><font color="#FAFA79">@</font><font color="#E6E64B">@</font><font color="#AEAE0E">@</font><font color="#16163D">@</font><font color="#00004A">@</font><font color="#000042">@@@</font><font color="#9A9A6E">@</font><font color="#EBEB71">@</font><font color="#A2A219">@</font><font color="#686812">@</font><font color="#000042">@@</font><font color="#80805B">@</font><font color="#E5E557">@</font><font color="#A2A219">@</font><font color="#686812">@</font><font color="#00004A">@</font><font color="#000042">@@@</font><font color="#80805B">@</font><font color="#E5E557">@</font><font color="#A2A219">@</font><font color="#686812">@</font><font color="#000042">@@</font><font color="#212758">@</font><font color="#FAFA79">@</font><font color="#F0F059">@</font><font color="#B6B61F">@</font><font color="#424224">@</font><font color="#00004A">@</font><font color="#000042">@@@</font><font color="#5A6979">@</font><font color="#F2F280">@</font><font color="#B8B837">@</font><font color="#808009">@</font><font color="#000042">@@@@</font><font color="#00004A">@</font><font color="#1F2475">@</font><font color="#3870A8">@</font><font color="#4175A8">@</font><font color="#427BB5">@@@@@@@</font><font color="#4175A8">@@@</font><font color="#3870A8">@@</font><font color="#336699">@@@</font><font color="#36628D">@</font><font color="#2E5A85">@@@@@<br>
</font><font color="#5695D5">@</font><font color="#93B6D9">@@</font><font color="#5695D5">@</font><font color="#93B6D9">@@</font><font color="#5695D5">@</font><font color="#8DACC9">@@</font><font color="#4D8BC9">@</font><font color="#8DA6BF">@@</font><font color="#4B83BA">@</font><font color="#7C9AB8">@@</font><font color="#427BB5">@</font><font color="#7A97B5">@@</font><font color="#427BB5">@</font><font color="#7A97B5">@@</font><font color="#427BB5">@</font><font color="#5D72A1">@</font><font color="#000066">@@@@@@@@</font><font color="#909071">@</font><font color="#EDED62">@</font><font color="#D6D644">@</font><font color="#A3A30D">@</font><font color="#424224">@</font><font color="#00004A">@</font><font color="#000042">@@</font><font color="#30305A">@</font><font color="#FFFF99">@</font><font color="#DDDD6E">@</font><font color="#959521">@</font><font color="#23232D">@</font><font color="#00004A">@</font><font color="#000042">@</font><font color="#BDBD56">@</font><font color="#E6E64B">@</font><font color="#A2A219">@</font><font color="#3A3A25">@</font><font color="#000042">@@@@</font><font color="#BDBD56">@</font><font color="#E6E64B">@</font><font color="#A2A219">@</font><font color="#3A3A25">@</font><font color="#00004A">@</font><font color="#000042">@</font><font color="#505063">@</font><font color="#FAFA79">@</font><font color="#F0F059">@</font><font color="#B6B61F">@</font><font color="#74741D">@</font><font color="#000042">@@@</font><font color="#15194F">@</font><font color="#DCDC92">@</font><font color="#DDDD6E">@</font><font color="#959521">@</font><font color="#424224">@</font><font color="#00004A">@</font><font color="#000042">@@@</font><font color="#00004A">@</font><font color="#225485">@</font><font color="#6A87A5">@</font><font color="#7491AE">@</font><font color="#427BB5">@</font><font color="#7A97B5">@@</font><font color="#427BB5">@</font><font color="#7A97B5">@@</font><font color="#427BB5">@</font><font color="#7B94AE">@@</font><font color="#4175A8">@</font><font color="#738DA7">@</font><font color="#6A87A5">@</font><font color="#336699">@</font><font color="#627C96">@@</font><font color="#36628D">@</font><font color="#5C7185">@@</font><font color="#2E5A85">@</font><font color="#5C7185">@@<br>
</font><font color="#5695D5">@</font><font color="#9BB7D4">@@</font><font color="#5695D5">@</font><font color="#9BB7D4">@@</font><font color="#5695D5">@</font><font color="#92ADC8">@@</font><font color="#4D8BC9">@</font><font color="#8DA6BF">@@</font><font color="#4B83BA">@</font><font color="#85A0BB">@</font><font color="#7C9AB8">@</font><font color="#427BB5">@</font><font color="#7C9AB8">@@</font><font color="#427BB5">@</font><font color="#7A97B5">@@</font><font color="#427BB5">@</font><font color="#7A97B5">@</font><font color="#1F2475">@</font><font color="#000066">@@@@@@@</font><font color="#C0C072">@</font><font color="#EDED62">@</font><font color="#D3D32B">@</font><font color="#A3A30D">@</font><font color="#AEAE0E">@</font><font color="#67673E">@</font><font color="#3E3E4F">@</font><font color="#80805B">@</font><font color="#F2F280">@</font><font color="#EBEB71">@</font><font color="#A3A336">@</font><font color="#686812">@</font><font color="#000052">@</font><font color="#00004A">@</font><font color="#000042">@</font><font color="#FBFB47">@</font><font color="#DEDE44">@</font><font color="#939314">@</font><font color="#171730">@</font><font color="#000042">@@@@</font><font color="#FBFB47">@</font><font color="#DEDE44">@</font><font color="#939314">@</font><font color="#171730">@</font><font color="#00004A">@@</font><font color="#80805B">@</font><font color="#FAFA79">@</font><font color="#DEDE44">@</font><font color="#A2A219">@</font><font color="#AEAE0E">@</font><font color="#A3A336">@</font><font color="#3E3E4F">@</font><font color="#60605E">@</font><font color="#DCDC92">@</font><font color="#DDDD6E">@</font><font color="#A3A336">@</font><font color="#686812">@</font><font color="#060A49">@</font><font color="#00004A">@</font><font color="#000042">@@@</font><font color="#171C59">@</font><font color="#3F6891">@</font><font color="#738DA7">@</font><font color="#7B94AE">@</font><font color="#427BB5">@</font><font color="#7A97B5">@@</font><font color="#427BB5">@</font><font color="#7A97B5">@@</font><font color="#427BB5">@</font><font color="#7B94AE">@@</font><font color="#4175A8">@</font><font color="#738DA7">@</font><font color="#6A87A5">@</font><font color="#426E9B">@</font><font color="#627C96">@@</font><font color="#36628D">@</font><font color="#5C7185">@@</font><font color="#2E5A85">@</font><font color="#5C7185">@@<br>
</font><font color="#629DD7">@@@@</font><font color="#5695D5">@@@</font><font color="#558FC9">@@@@</font><font color="#4B83BA">@@@@@</font><font color="#497DB1">@@@@@@@@</font><font color="#091070">@</font><font color="#000066">@@@@@@</font><font color="#FFFF59">@</font><font color="#F0F059">@</font><font color="#B6B61F">@</font><font color="#585816">@</font><font color="#999900">@</font><font color="#C4C412">@</font><font color="#E5E531">@</font><font color="#E5E557">@</font><font color="#DFDF57">@</font><font color="#A3A336">@</font><font color="#585816">@</font><font color="#060A49">@</font><font color="#00004A">@@</font><font color="#303051">@</font><font color="#E7E73D">@</font><font color="#B6B61F">@</font><font color="#808009">@</font><font color="#000042">@@@@</font><font color="#303051">@</font><font color="#E7E73D">@</font><font color="#B6B61F">@</font><font color="#808009">@</font><font color="#060A49">@</font><font color="#00004A">@@</font><font color="#BDBD56">@</font><font color="#EDED62">@</font><font color="#ACAC28">@</font><font color="#4F4F17">@</font><font color="#939314">@</font><font color="#CECE25">@</font><font color="#E5E531">@</font><font color="#E6E64B">@</font><font color="#DFDF57">@</font><font color="#A3A336">@</font><font color="#686812">@</font><font color="#16163D">@</font><font color="#000052">@</font><font color="#00004A">@@</font><font color="#000042">@</font><font color="#060A49">@</font><font color="#2E5A85">@</font><font color="#3F6891">@</font><font color="#4175A8">@</font><font color="#497DB1">@@@@@@@@@</font><font color="#4175A8">@@@@</font><font color="#426E9B">@@</font><font color="#3F6891">@</font><font color="#36628D">@@</font><font color="#385C80">@@@@<br>
</font><font color="#629DD7">@</font><font color="#9BB7D4">@@</font><font color="#629DD7">@</font><font color="#9BB7D4">@@</font><font color="#5695D5">@</font><font color="#92ADC8">@@</font><font color="#558FC9">@</font><font color="#8DA6BF">@@</font><font color="#4B83BA">@</font><font color="#85A0BB">@@</font><font color="#4B83BA">@</font><font color="#849CB4">@@</font><font color="#497DB1">@</font><font color="#7C9AB8">@@</font><font color="#497DB1">@</font><font color="#7C9AB8">@@</font><font color="#346CA4">@</font><font color="#101370">@</font><font color="#000066">@@@@</font><font color="#303078">@</font><font color="#FFFF66">@</font><font color="#D6D644">@</font><font color="#A2A219">@</font><font color="#060A49">@</font><font color="#3A3A25">@</font><font color="#A2A219">@</font><font color="#C4C423">@</font><font color="#B6B61F">@</font><font color="#959521">@</font><font color="#424224">@</font><font color="#00004A">@@@@</font><font color="#555544">@</font><font color="#CFCF0F">@</font><font color="#AEAE0E">@</font><font color="#999900">@</font><font color="#000042">@@@@</font><font color="#555544">@</font><font color="#DADA13">@</font><font color="#AEAE0E">@</font><font color="#999900">@</font><font color="#000052">@</font><font color="#00004A">@@</font><font color="#EDED62">@</font><font color="#E5E557">@</font><font color="#959521">@</font><font color="#171730">@@</font><font color="#959521">@</font><font color="#C0C02A">@</font><font color="#ACAC28">@</font><font color="#939314">@</font><font color="#585816">@</font><font color="#000042">@</font><font color="#00004A">@@@</font><font color="#000042">@</font><font color="#060A49">@</font><font color="#495774">@</font><font color="#5B758F">@</font><font color="#426E9B">@</font><font color="#738DA7">@</font><font color="#7B94AE">@</font><font color="#497DB1">@</font><font color="#7C9AB8">@@</font><font color="#497DB1">@</font><font color="#7A97B5">@@</font><font color="#497DB1">@</font><font color="#7B94AE">@@</font><font color="#4175A8">@</font><font color="#738DA7">@@</font><font color="#426E9B">@</font><font color="#6F849A">@</font><font color="#6B7C8E">@</font><font color="#36628D">@</font><font color="#637384">@@</font><font color="#385C80">@</font><font color="#5C7185">@@<br>
</font><font color="#629DD7">@</font><font color="#9BB7D4">@@</font><font color="#629DD7">@</font><font color="#9BB7D4">@@</font><font color="#6699CC">@</font><font color="#92ADC8">@@</font><font color="#558FC9">@</font><font color="#8DA6BF">@@</font><font color="#4B83BA">@</font><font color="#85A0BB">@@</font><font color="#5283B4">@</font><font color="#849CB4">@@</font><font color="#5283B4">@</font><font color="#849CB4">@@</font><font color="#5283B4">@</font><font color="#849CB4">@@</font><font color="#5283B4">@</font><font color="#7B94AE">@</font><font color="#1F2475">@</font><font color="#000066">@@@</font><font color="#5A6979">@</font><font color="#F0F059">@</font><font color="#ACAC28">@</font><font color="#8F8F0B">@</font><font color="#000052">@</font><font color="#00004A">@</font><font color="#000042">@</font><font color="#262640">@</font><font color="#171730">@</font><font color="#000042">@@</font><font color="#00004A">@@@</font><font color="#000042">@@@</font><font color="#00004A">@@@</font><font color="#000042">@@@</font><font color="#00004A">@</font><font color="#000052">@@@@</font><font color="#00004A">@</font><font color="#212758">@</font><font color="#FFFF66">@</font><font color="#D6D644">@</font><font color="#939314">@</font><font color="#171730">@</font><font color="#000042">@@</font><font color="#262640">@</font><font color="#171730">@</font><font color="#000033">@</font><font color="#000042">@</font><font color="#00004A">@@@@</font><font color="#15194F">@</font><font color="#315276">@</font><font color="#5C7185">@</font><font color="#6B7C8E">@</font><font color="#426E9B">@</font><font color="#7C91A6">@</font><font color="#7B94AE">@</font><font color="#5283B4">@</font><font color="#849CB4">@@</font><font color="#497DB1">@</font><font color="#849CB4">@@</font><font color="#497DB1">@</font><font color="#7B94AE">@@</font><font color="#4C79A6">@</font><font color="#738DA7">@@</font><font color="#426E9B">@</font><font color="#6F849A">@</font><font color="#6B7C8E">@</font><font color="#40658C">@</font><font color="#637384">@@</font><font color="#385C80">@</font><font color="#5C7185">@@<br>
</font><font color="#629DD7">@@@@@@@</font><font color="#5B92C9">@@@@</font><font color="#598ABA">@@</font><font color="#5283B4">@@@@@@@@@@@@@@</font><font color="#214694">@</font><font color="#05086B">@</font><font color="#000066">@</font><font color="#909071">@</font><font color="#E6E64B">@</font><font color="#939314">@</font><font color="#585816">@</font><font color="#000052">@</font><font color="#000042">@@@@@@@@@@@</font><font color="#00004A">@@@@@@@@</font><font color="#000052">@@@@</font><font color="#00004A">@</font><font color="#505063">@</font><font color="#F0F059">@</font><font color="#ACAC28">@</font><font color="#8F8F0B">@</font><font color="#00004A">@</font><font color="#000042">@@@@@@@@@</font><font color="#253A63">@</font><font color="#315276">@</font><font color="#385C80">@</font><font color="#40658C">@</font><font color="#426E9B">@</font><font color="#4C79A6">@@</font><font color="#497DB1">@</font><font color="#5283B4">@@@@@</font><font color="#497DB1">@@@</font><font color="#4C79A6">@@@</font><font color="#4A739C">@</font><font color="#426E9B">@@</font><font color="#3F6891">@@@</font><font color="#416283">@@@@<br>
</font><font color="#629DD7">@</font><font color="#9BB7D4">@@</font><font color="#629DD7">@</font><font color="#9BB7D4">@@</font><font color="#6699CC">@</font><font color="#92ADC8">@@</font><font color="#5B92C9">@</font><font color="#8DA6BF">@@</font><font color="#598ABA">@</font><font color="#85A0BB">@@</font><font color="#5283B4">@</font><font color="#849CB4">@@</font><font color="#5283B4">@</font><font color="#849CB4">@@</font><font color="#5283B4">@</font><font color="#849CB4">@@</font><font color="#5283B4">@</font><font color="#849CB4">@@</font><font color="#5283B4">@</font><font color="#738DA7">@</font><font color="#2A3D83">@</font><font color="#BDBD56">@</font><font color="#DEDE44">@</font><font color="#939314">@</font><font color="#3A3A25">@</font><font color="#00004A">@@</font><font color="#000042">@@@@@@@@</font><font color="#00004A">@@@@@@@@@@</font><font color="#000052">@@@@@</font><font color="#80805B">@</font><font color="#DEDE44">@</font><font color="#939314">@</font><font color="#686812">@</font><font color="#00004A">@</font><font color="#000042">@@@@@@@</font><font color="#212758">@</font><font color="#315276">@</font><font color="#5A6979">@</font><font color="#5C7185">@</font><font color="#40658C">@</font><font color="#6B7C8E">@</font><font color="#758A9D">@</font><font color="#4C79A6">@</font><font color="#7B94AE">@@</font><font color="#5283B4">@</font><font color="#849CB4">@@</font><font color="#5283B4">@</font><font color="#849CB4">@@</font><font color="#5381AE">@</font><font color="#7B94AE">@@</font><font color="#4C79A6">@</font><font color="#738DA7">@</font><font color="#758A9D">@</font><font color="#426E9B">@</font><font color="#6F849A">@</font><font color="#6B7C8E">@</font><font color="#40658C">@</font><font color="#637384">@@</font><font color="#416283">@</font><font color="#637384">@@<br>
</font><font color="#629DD7">@</font><font color="#9BB7D4">@@</font><font color="#6699CC">@</font><font color="#9BB7D4">@@</font><font color="#6699CC">@</font><font color="#92ADC8">@@</font><font color="#5B92C9">@</font><font color="#8DA6BF">@@</font><font color="#598ABA">@</font><font color="#849CB4">@@</font><font color="#5283B4">@</font><font color="#849CB4">@@</font><font color="#5381AE">@</font><font color="#8398AD">@@</font><font color="#5381AE">@</font><font color="#8398AD">@@</font><font color="#5381AE">@</font><font color="#8398AD">@@</font><font color="#5381AE">@</font><font color="#8398AD">@@</font><font color="#F2F235">@</font><font color="#CECE25">@</font><font color="#808009">@</font><font color="#171730">@</font><font color="#00004A">@</font><font color="#000042">@@@@@</font><font color="#00004A">@@@@@</font><font color="#000052">@@@@@@@@@</font><font color="#00005A">@@@@</font><font color="#000052">@</font><font color="#BFBF43">@</font><font color="#D3D32B">@</font><font color="#808009">@</font><font color="#424224">@</font><font color="#00004A">@</font><font color="#000042">@@@@@</font><font color="#212758">@</font><font color="#546371">@</font><font color="#5A6979">@</font><font color="#385C80">@</font><font color="#637384">@@</font><font color="#4A6E92">@</font><font color="#758A9D">@</font><font color="#7C91A6">@</font><font color="#5381AE">@</font><font color="#8398AD">@@</font><font color="#5381AE">@</font><font color="#8398AD">@@</font><font color="#5381AE">@</font><font color="#8398AD">@@</font><font color="#5381AE">@</font><font color="#7B94AE">@@</font><font color="#4C79A6">@</font><font color="#758A9D">@@</font><font color="#4A739C">@</font><font color="#6B7C8E">@@</font><font color="#40658C">@</font><font color="#637384">@@</font><font color="#416283">@</font><font color="#637384">@@<br>
</font><font color="#6699CC">@@@@@@@@</font><font color="#5B92C9">@</font><font color="#598ABA">@@@@</font><font color="#5283B4">@@</font><font color="#5381AE">@@@@@@@@@@@@@@</font><font color="#738DA7">@</font><font color="#E4E420">@</font><font color="#C4C412">@</font><font color="#999900">@</font><font color="#324764">@</font><font color="#171C59">@</font><font color="#000042">@@@@@</font><font color="#00004A">@</font><font color="#000052">@@@@</font><font color="#00005A">@@@@@@@@@@@@@@</font><font color="#E4E420">@</font><font color="#CFCF0F">@</font><font color="#999900">@</font><font color="#31313A">@</font><font color="#00004A">@</font><font color="#000042">@@</font><font color="#15194F">@</font><font color="#253A63">@</font><font color="#385C80">@@</font><font color="#416283">@@</font><font color="#40658C">@@</font><font color="#4A6E92">@</font><font color="#4A739C">@</font><font color="#4C79A6">@@</font><font color="#5381AE">@@@@@@@@@@@</font><font color="#4C79A6">@@@</font><font color="#4A739C">@@</font><font color="#4A6E92">@@</font><font color="#40658C">@</font><font color="#416283">@@@@@<br>
</font><font color="#6699CC">@</font><font color="#9CB4CD">@@</font><font color="#6699CC">@</font><font color="#9CB4CD">@@</font><font color="#8BAFD4">@</font><font color="#B0C3D5">@</font><font color="#92ADC8">@</font><font color="#598ABA">@</font><font color="#85A0BB">@@</font><font color="#598ABA">@</font><font color="#849CB4">@@</font><font color="#5381AE">@</font><font color="#8398AD">@@</font><font color="#5381AE">@</font><font color="#8398AD">@@</font><font color="#85A0BB">@</font><font color="#849CB4">@</font><font color="#8398AD">@</font><font color="#5381AE">@</font><font color="#8398AD">@@</font><font color="#5381AE">@</font><font color="#8398AD">@@</font><font color="#537CA5">@</font><font color="#7C91A6">@</font><font color="#6F849A">@</font><font color="#738DA7">@</font><font color="#727D89">@</font><font color="#546371">@</font><font color="#253A63">@</font><font color="#30305A">@</font><font color="#171C59">@</font><font color="#000052">@@</font><font color="#00005A">@@@@@</font><font color="#000066">@@@@</font><font color="#101370">@</font><font color="#404089">@</font><font color="#101370">@</font><font color="#000066">@@@@@</font><font color="#00005A">@@@@</font><font color="#171C59">@</font><font color="#253A63">@</font><font color="#404B67">@</font><font color="#546371">@</font><font color="#385471">@</font><font color="#5A6979">@</font><font color="#637384">@</font><font color="#40658C">@</font><font color="#6B7C8E">@@</font><font color="#4A6E92">@</font><font color="#758696">@</font><font color="#758A9D">@</font><font color="#537CA5">@</font><font color="#7C91A6">@@</font><font color="#5381AE">@</font><font color="#8398AD">@@</font><font color="#5381AE">@</font><font color="#8398AD">@@</font><font color="#5381AE">@</font><font color="#7B94AE">@@</font><font color="#537CA5">@</font><font color="#7C91A6">@@</font><font color="#4C79A6">@</font><font color="#758A9D">@@</font><font color="#4A6E92">@</font><font color="#6B7C8E">@@</font><font color="#40658C">@</font><font color="#637384">@@</font><font color="#416283">@</font><font color="#637384">@@<br>
</font><font color="#6699CC">@</font><font color="#9CB4CD">@@</font><font color="#6699CC">@</font><font color="#9CB4CD">@</font><font color="#F6F7F7">@</font><font color="#FFFFFF">@@@</font><font color="#9BB7D4">@</font><font color="#849CB4">@@</font><font color="#5381AE">@</font><font color="#8398AD">@@</font><font color="#5381AE">@</font><font color="#7C91A6">@@</font><font color="#537CA5">@</font><font color="#7C91A6">@</font><font color="#93A4B5">@</font><font color="#DADEE3">@</font><font color="#93A4B5">@</font><font color="#7C91A6">@</font><font color="#537CA5">@</font><font color="#7C91A6">@@</font><font color="#537CA5">@</font><font color="#7C91A6">@</font><font color="#8398AD">@</font><font color="#C5CFE5">@</font><font color="#9EA9B4">@</font><font color="#6F849A">@</font><font color="#D0D7DE">@</font><font color="#97A4B0">@</font><font color="#546371">@</font><font color="#385471">@</font><font color="#5A6979">@</font><font color="#637384">@</font><font color="#4A6E92">@</font><font color="#5B758F">@</font><font color="#526D89">@</font><font color="#2A3D83">@</font><font color="#40407B">@</font><font color="#1F2475">@@@</font><font color="#000066">@@@</font><font color="#404089">@</font><font color="#FFFFFF">@</font><font color="#404089">@</font><font color="#000066">@</font><font color="#101370">@</font><font color="#1F2475">@@</font><font color="#2A3D83">@</font><font color="#40407B">@</font><font color="#526D89">@</font><font color="#3F6891">@</font><font color="#73818E">@</font><font color="#637384">@</font><font color="#416283">@</font><font color="#5A6979">@</font><font color="#546371">@</font><font color="#385471">@</font><font color="#65727F">@</font><font color="#6B7C8E">@</font><font color="#4A6E92">@</font><font color="#758696">@@</font><font color="#51759A">@</font><font color="#758A9D">@@</font><font color="#537CA5">@</font><font color="#7C91A6">@@</font><font color="#537CA5">@</font><font color="#7C91A6">@@</font><font color="#537CA5">@</font><font color="#7C91A6">@@</font><font color="#537CA5">@</font><font color="#7C91A6">@@</font><font color="#537CA5">@</font><font color="#7C91A6">@@</font><font color="#51759A">@</font><font color="#758696">@@</font><font color="#4A6E92">@</font><font color="#6B7C8E">@@</font><font color="#416283">@</font><font color="#637384">@@</font><font color="#416283">@</font><font color="#637384">@@<br>
</font><font color="#6F9AC5">@</font><font color="#6699CC">@@@</font><font color="#B4CFEA">@</font><font color="#FFFFFF">@</font><font color="#7CA2C8">@</font><font color="#6A90B6">@</font><font color="#CCDFF3">@</font><font color="#F8FAFC">@</font><font color="#648BB1">@@@</font><font color="#85A0BB">@</font><font color="#6A90B6">@</font><font color="#537CA5">@@</font><font color="#85A0BB">@</font><font color="#6A8CAD">@</font><font color="#85A0BB">@</font><font color="#6A8CAD">@</font><font color="#85A0BB">@</font><font color="#6185AA">@@</font><font color="#85A0BB">@</font><font color="#6185AA">@</font><font color="#85A0BB">@</font><font color="#6185AA">@</font><font color="#537CA5">@</font><font color="#9CB4CD">@</font><font color="#FFFFFF">@</font><font color="#A0B2C3">@</font><font color="#58799A">@</font><font color="#738DA7">@</font><font color="#5B758F">@</font><font color="#576E85">@</font><font color="#627C96">@</font><font color="#526D89">@</font><font color="#738DA7">@</font><font color="#58799A">@</font><font color="#51759A">@@@</font><font color="#7C9AB8">@</font><font color="#6A8CAD">@</font><font color="#7394B6">@</font><font color="#6A8CAD">@</font><font color="#537CA5">@@@</font><font color="#7C9AB8">@</font><font color="#FFFFFF">@</font><font color="#7C9AB8">@</font><font color="#537CA5">@@@@@</font><font color="#7C9AB8">@@</font><font color="#6483A3">@</font><font color="#4A6E92">@</font><font color="#6A87A5">@</font><font color="#5B758F">@</font><font color="#576E85">@</font><font color="#6F849A">@</font><font color="#416283">@@</font><font color="#4A6E92">@</font><font color="#58799A">@</font><font color="#7C9AB8">@</font><font color="#6185AA">@</font><font color="#7C9AB8">@</font><font color="#6185AA">@</font><font color="#6A8CAD">@</font><font color="#85A0BB">@</font><font color="#537CA5">@</font><font color="#6185AA">@</font><font color="#85A0BB">@</font><font color="#6185AA">@</font><font color="#537CA5">@</font><font color="#6185AA">@</font><font color="#85A0BB">@@</font><font color="#537CA5">@@@</font><font color="#6A8CAD">@</font><font color="#7C9AB8">@</font><font color="#6483A3">@</font><font color="#7A97B5">@</font><font color="#51759A">@</font><font color="#4A6E92">@</font><font color="#6483A3">@</font><font color="#738DA7">@</font><font color="#537291">@</font><font color="#496682">@</font><font color="#416283">@@@@@<br>
</font><font color="#6F9AC5">@</font><font color="#9CB4CD">@@</font><font color="#6F9AC5">@</font><font color="#B0C3D5">@</font><font color="#FFFFFF">@</font><font color="#DFE6EC">@</font><font color="#C5CDD6">@</font><font color="#A0B2C3">@</font><font color="#648BB1">@</font><font color="#8398AD">@</font><font color="#B1BECB">@</font><font color="#FFFFFF">@</font><font color="#DFE6EC">@</font><font color="#FFFFFF">@</font><font color="#B0C3D5">@</font><font color="#7D8C9A">@</font><font color="#FFFFFF">@</font><font color="#F6F7F7">@</font><font color="#FFFFFF">@</font><font color="#C5CDD6">@</font><font color="#FFFFFF">@</font><font color="#9EA9B4">@@</font><font color="#FFFFFF">@</font><font color="#E9EDF0">@@</font><font color="#F6F7F7">@</font><font color="#93A4B5">@</font><font color="#E5E8EB">@</font><font color="#FFFFFF">@</font><font color="#E5E8EB">@</font><font color="#8896A4">@</font><font color="#FFFFFF">@</font><font color="#ABB5C0">@@</font><font color="#E9EDF0">@</font><font color="#E5E8EB">@</font><font color="#E9EDF0">@</font><font color="#F6F7F7">@</font><font color="#7C91A6">@@</font><font color="#DFE6EC">@</font><font color="#E9EDF0">@@@</font><font color="#BDC6D0">@</font><font color="#758A9D">@</font><font color="#537CA5">@</font><font color="#758A9D">@</font><font color="#9EA9B4">@</font><font color="#FFFFFF">@</font><font color="#9EA9B4">@</font><font color="#758A9D">@</font><font color="#537CA5">@</font><font color="#758A9D">@@</font><font color="#DFE6EC">@@</font><font color="#E9EDF0">@</font><font color="#F6F7F7">@</font><font color="#7D8C9A">@</font><font color="#DADEE3">@@</font><font color="#DFE6EC">@</font><font color="#F6F7F7">@</font><font color="#D0D7DE">@</font><font color="#6B7C8E">@</font><font color="#8C9BAA">@</font><font color="#F6F7F7">@</font><font color="#E5E8EB">@@</font><font color="#FFFFFF">@</font><font color="#9EA9B4">@</font><font color="#BDC6D0">@</font><font color="#FFFFFF">@</font><font color="#758A9D">@</font><font color="#9EA9B4">@</font><font color="#FFFFFF">@</font><font color="#9EA9B4">@</font><font color="#8C9BAA">@</font><font color="#F6F7F7">@</font><font color="#DFE6EC">@</font><font color="#F6F7F7">@</font><font color="#DADEE3">@</font><font color="#758A9D">@</font><font color="#ABB5C0">@</font><font color="#FFFFFF">@</font><font color="#DADEE3">@</font><font color="#E5E8EB">@</font><font color="#FFFFFF">@</font><font color="#758696">@</font><font color="#ABB5C0">@</font><font color="#FFFFFF">@</font><font color="#DADEE3">@</font><font color="#FFFFFF">@</font><font color="#8398AD">@</font><font color="#637384">@@</font><font color="#416283">@</font><font color="#637384">@@<br>
</font><font color="#6F9AC5">@</font><font color="#A0B2C3">@@</font><font color="#6F9AC5">@</font><font color="#95A9BD">@</font><font color="#B0C3D5">@</font><font color="#DFE6EC">@</font><font color="#FFFFFF">@@</font><font color="#C5CFE5">@</font><font color="#8398AD">@</font><font color="#F6F7F7">@</font><font color="#C5CDD6">@</font><font color="#7D8C9A">@</font><font color="#A0B2C3">@</font><font color="#8DA6BF">@</font><font color="#758A9D">@</font><font color="#FFFFFF">@</font><font color="#DADEE3">@</font><font color="#758A9D">@</font><font color="#9EA9B4">@</font><font color="#FFFFFF">@</font><font color="#9EA9B4">@@</font><font color="#FFFFFF">@</font><font color="#ABB5C0">@</font><font color="#758A9D">@</font><font color="#E9EDF0">@</font><font color="#D4D9DE">@</font><font color="#9EA9B4">@</font><font color="#FFFFFF">@</font><font color="#97A4B0">@</font><font color="#73818E">@</font><font color="#FFFFFF">@</font><font color="#B6BEC5">@@</font><font color="#FFFFFF">@</font><font color="#73818E">@</font><font color="#9EA9B4">@</font><font color="#FFFFFF">@</font><font color="#97A4B0">@</font><font color="#B6BEC5">@</font><font color="#FFFFFF">@</font><font color="#8896A4">@@</font><font color="#FFFFFF">@</font><font color="#BDC6D0">@</font><font color="#758A9D">@</font><font color="#58799A">@</font><font color="#758A9D">@</font><font color="#9EA9B4">@</font><font color="#FFFFFF">@</font><font color="#9EA9B4">@</font><font color="#758A9D">@</font><font color="#58799A">@</font><font color="#758A9D">@</font><font color="#7C91A6">@</font><font color="#95A9BD">@</font><font color="#758A9D">@</font><font color="#ABB5C0">@</font><font color="#FFFFFF">@</font><font color="#97A4B0">@</font><font color="#DADEE3">@</font><font color="#DFE6EC">@</font><font color="#6A7683">@</font><font color="#BDC6D0">@</font><font color="#FFFFFF">@</font><font color="#6B7C8E">@</font><font color="#D4D9DE">@</font><font color="#E9EDF0">@</font><font color="#758A9D">@</font><font color="#ABB5C0">@</font><font color="#FFFFFF">@</font><font color="#9EA9B4">@</font><font color="#BDC6D0">@</font><font color="#FFFFFF">@</font><font color="#758A9D">@</font><font color="#9EA9B4">@</font><font color="#FFFFFF">@</font><font color="#9EA9B4">@</font><font color="#8896A4">@</font><font color="#85A0BB">@</font><font color="#758A9D">@</font><font color="#D0D7DE">@</font><font color="#FFFFFF">@</font><font color="#758A9D">@</font><font color="#F6F7F7">@</font><font color="#C5CDD6">@</font><font color="#758696">@</font><font color="#C5CDD6">@</font><font color="#FFFFFF">@</font><font color="#73818E">@</font><font color="#E9EDF0">@</font><font color="#BDC6D0">@</font><font color="#6C7985">@</font><font color="#BDC6D0">@</font><font color="#E9EDF0">@</font><font color="#65727F">@@</font><font color="#496682">@</font><font color="#637384">@@<br>
</font><font color="#6F9AC5">@@@@</font><font color="#85A9CD">@</font><font color="#9BB7D4">@</font><font color="#648BB1">@@</font><font color="#B0C3D5">@</font><font color="#FFFFFF">@</font><font color="#85A0BB">@</font><font color="#FFFFFF">@</font><font color="#B1BECB">@</font><font color="#58799A">@@@@</font><font color="#FFFFFF">@</font><font color="#A9B7C6">@</font><font color="#51759A">@</font><font color="#8398AD">@</font><font color="#FFFFFF">@</font><font color="#8398AD">@@</font><font color="#FFFFFF">@</font><font color="#8398AD">@</font><font color="#51759A">@</font><font color="#DADEE3">@@</font><font color="#8398AD">@</font><font color="#FFFFFF">@</font><font color="#7B94AE">@</font><font color="#537291">@</font><font color="#FFFFFF">@</font><font color="#A9B7C6">@@</font><font color="#FFFFFF">@</font><font color="#526D89">@</font><font color="#7B94AE">@</font><font color="#FFFFFF">@</font><font color="#7B94AE">@</font><font color="#A9B7C6">@</font><font color="#FFFFFF">@</font><font color="#51759A">@@</font><font color="#FFFFFF">@</font><font color="#A9B7C6">@</font><font color="#51759A">@@@</font><font color="#8398AD">@</font><font color="#FFFFFF">@</font><font color="#8398AD">@</font><font color="#51759A">@@@</font><font color="#627C96">@</font><font color="#D0D7DE">@</font><font color="#DFE6EC">@</font><font color="#D0D7DE">@</font><font color="#FFFFFF">@</font><font color="#7B94AE">@</font><font color="#D4D9DE">@@</font><font color="#526D89">@</font><font color="#A9B7C6">@</font><font color="#FFFFFF">@</font><font color="#537291">@</font><font color="#DADEE3">@@</font><font color="#537291">@</font><font color="#8398AD">@</font><font color="#FFFFFF">@</font><font color="#8398AD">@</font><font color="#A9B7C6">@</font><font color="#FFFFFF">@</font><font color="#51759A">@</font><font color="#8398AD">@</font><font color="#FFFFFF">@</font><font color="#8398AD">@</font><font color="#738DA7">@</font><font color="#DFE6EC">@</font><font color="#DADEE3">@@</font><font color="#FFFFFF">@</font><font color="#537291">@</font><font color="#FFFFFF">@</font><font color="#A9B7C6">@</font><font color="#537291">@</font><font color="#A9B7C6">@</font><font color="#FFFFFF">@</font><font color="#526D89">@</font><font color="#FFFFFF">@</font><font color="#E9EDF0">@</font><font color="#D4D9DE">@@@</font><font color="#496682">@@@@@<br>
</font><font color="#6F9AC5">@</font><font color="#95A9BD">@@</font><font color="#6A90B6">@</font><font color="#C5CDD6">@</font><font color="#FFFFFF">@</font><font color="#B0C3D5">@</font><font color="#A0B2C3">@</font><font color="#D0D7DE">@</font><font color="#FFFFFF">@</font><font color="#8C9BAA">@</font><font color="#E5E8EB">@</font><font color="#DADEE3">@</font><font color="#758696">@</font><font color="#D4D9DE">@@</font><font color="#73818E">@</font><font color="#FFFFFF">@</font><font color="#A9B7C6">@</font><font color="#73818E">@</font><font color="#97A4B0">@</font><font color="#FFFFFF">@</font><font color="#97A4B0">@@</font><font color="#FFFFFF">@</font><font color="#B6BEC5">@</font><font color="#7D8C9A">@</font><font color="#F6F7F7">@</font><font color="#C5CDD6">@</font><font color="#97A4B0">@</font><font color="#FFFFFF">@</font><font color="#939EAA">@</font><font color="#758696">@</font><font color="#FFFFFF">@</font><font color="#B6BEC5">@@</font><font color="#FFFFFF">@</font><font color="#6B7C8E">@</font><font color="#939EAA">@</font><font color="#FFFFFF">@</font><font color="#939EAA">@</font><font color="#9EA9B4">@</font><font color="#FFFFFF">@</font><font color="#97A4B0">@@</font><font color="#FFFFFF">@</font><font color="#B6BEC5">@</font><font color="#73818E">@</font><font color="#537291">@</font><font color="#73818E">@</font><font color="#97A4B0">@</font><font color="#FFFFFF">@</font><font color="#ABB5C0">@</font><font color="#97A4B0">@</font><font color="#7B94AE">@</font><font color="#8C9BAA">@</font><font color="#B6BEC5">@</font><font color="#FFFFFF">@</font><font color="#7D8C9A">@</font><font color="#ABB5C0">@</font><font color="#FFFFFF">@</font><font color="#939EAA">@</font><font color="#DADEE3">@@</font><font color="#6B7C8E">@</font><font color="#B6BEC5">@</font><font color="#FFFFFF">@</font><font color="#73818E">@</font><font color="#BDC6D0">@</font><font color="#F6F7F7">@</font><font color="#7D8C9A">@</font><font color="#B6BEC5">@</font><font color="#FFFFFF">@</font><font color="#97A4B0">@</font><font color="#B6BEC5">@</font><font color="#FFFFFF">@</font><font color="#84909B">@</font><font color="#ABB5C0">@</font><font color="#FFFFFF">@</font><font color="#97A4B0">@</font><font color="#DADEE3">@</font><font color="#DFE6EC">@</font><font color="#73818E">@</font><font color="#D4D9DE">@</font><font color="#FFFFFF">@</font><font color="#73818E">@</font><font color="#E5E8EB">@</font><font color="#D4D9DE">@</font><font color="#73818E">@</font><font color="#DADEE3">@</font><font color="#FFFFFF">@</font><font color="#6C7985">@</font><font color="#E5E8EB">@</font><font color="#D4D9DE">@</font><font color="#637384">@</font><font color="#939EAA">@</font><font color="#8398AD">@</font><font color="#65727F">@@</font><font color="#496682">@</font><font color="#637384">@</font><font color="#6C7985">@<br>
</font><font color="#7399BD">@</font><font color="#95A9BD">@@</font><font color="#6A90B6">@</font><font color="#93A4B5">@</font><font color="#D4D9DE">@</font><font color="#F6F7F7">@</font><font color="#FFFFFF">@</font><font color="#E8EFF7">@</font><font color="#95A9BD">@</font><font color="#7D8C9A">@</font><font color="#939EAA">@</font><font color="#DFE6EC">@</font><font color="#FFFFFF">@</font><font color="#E9EDF0">@</font><font color="#7B94AE">@</font><font color="#73818E">@</font><font color="#FFFFFF">@</font><font color="#A9B7C6">@</font><font color="#6B7C8E">@</font><font color="#939EAA">@</font><font color="#FFFFFF">@</font><font color="#939EAA">@@</font><font color="#FFFFFF">@</font><font color="#D0D7DE">@</font><font color="#FFFFFF">@</font><font color="#D4D9DE">@</font><font color="#758696">@@</font><font color="#E9EDF0">@</font><font color="#FFFFFF">@</font><font color="#8896A4">@</font><font color="#FFFFFF">@</font><font color="#B6BEC5">@@</font><font color="#FFFFFF">@</font><font color="#6B7C8E">@</font><font color="#939EAA">@</font><font color="#FFFFFF">@</font><font color="#939EAA">@</font><font color="#6B7C8E">@</font><font color="#B1BECB">@</font><font color="#FFFFFF">@</font><font color="#E5E8EB">@</font><font color="#FFFFFF">@</font><font color="#B6BEC5">@</font><font color="#6B7C8E">@</font><font color="#526D89">@</font><font color="#6B7C8E">@</font><font color="#939EAA">@</font><font color="#FFFFFF">@@@@</font><font color="#DADEE3">@</font><font color="#8896A4">@</font><font color="#E9EDF0">@</font><font color="#FFFFFF">@</font><font color="#C5CDD6">@</font><font color="#FFFFFF">@</font><font color="#9EA9B4">@</font><font color="#DADEE3">@@</font><font color="#6B7C8E">@</font><font color="#B6BEC5">@</font><font color="#FFFFFF">@</font><font color="#6B7C8E">@</font><font color="#758696">@</font><font color="#D4D9DE">@</font><font color="#FFFFFF">@</font><font color="#E5E8EB">@</font><font color="#FFFFFF">@</font><font color="#939EAA">@</font><font color="#84909B">@</font><font color="#E9EDF0">@</font><font color="#FFFFFF">@</font><font color="#C5CDD6">@</font><font color="#FFFFFF">@</font><font color="#939EAA">@</font><font color="#9EA9B4">@</font><font color="#F6F7F7">@@</font><font color="#D0D7DE">@</font><font color="#FFFFFF">@</font><font color="#758696">@</font><font color="#8896A4">@</font><font color="#E9EDF0">@</font><font color="#FFFFFF">@</font><font color="#E5E8EB">@</font><font color="#FFFFFF">@</font><font color="#6A7683">@</font><font color="#84909B">@</font><font color="#DFE6EC">@</font><font color="#FFFFFF">@</font><font color="#F6F7F7">@</font><font color="#8C9BAA">@</font><font color="#65727F">@@</font><font color="#496682">@</font><font color="#6A7683">@@<br>
</font><font color="#7196BB">@@</font><font color="#6A90B6">@@</font><font color="#6A8CAD">@@</font><font color="#6483A3">@@</font><font color="#627C96">@@@</font><font color="#5B758F">@@@</font><font color="#526D89">@@@@@@@@@</font><font color="#7C91A6">@</font><font color="#FFFFFF">@</font><font color="#7C91A6">@</font><font color="#526D89">@@@@@@@@@@@@@@@</font><font color="#627C96">@</font><font color="#93A4B5">@</font><font color="#5B758F">@@</font><font color="#FFFFFF">@</font><font color="#A0B2C3">@</font><font color="#526D89">@@@@@@@@@@@@@@@@@@@@@</font><font color="#7C91A6">@</font><font color="#8C9BAA">@</font><font color="#526D89">@</font><font color="#8C9BAA">@</font><font color="#FFFFFF">@</font><font color="#758A9D">@</font><font color="#526D89">@@@@@@@@@@@@</font><font color="#93A4B5">@</font><font color="#758A9D">@</font><font color="#536B84">@</font><font color="#B1BECB">@</font><font color="#F6F7F7">@</font><font color="#536B84">@</font><font color="#496682">@@@@@@@@</font><font color="#536B84">@@<br>
</font><font color="#7196BB">@</font><font color="#93A4B5">@@</font><font color="#6A8CAD">@</font><font color="#8C9BAA">@</font><font color="#8896A4">@</font><font color="#6483A3">@</font><font color="#7D8C9A">@@</font><font color="#58799A">@</font><font color="#73818E">@@</font><font color="#537291">@</font><font color="#707B87">@@</font><font color="#526D89">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@</font><font color="#939EAA">@</font><font color="#FFFFFF">@</font><font color="#939EAA">@</font><font color="#6C7985">@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@</font><font color="#73818E">@</font><font color="#C5CDD6">@</font><font color="#FFFFFF">@@</font><font color="#D4D9DE">@</font><font color="#73818E">@</font><font color="#6C7985">@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@</font><font color="#84909B">@</font><font color="#DFE6EC">@</font><font color="#FFFFFF">@@</font><font color="#B1BECB">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@</font><font color="#9EA9B4">@</font><font color="#E9EDF0">@</font><font color="#FFFFFF">@</font><font color="#F6F7F7">@</font><font color="#93A4B5">@</font><font color="#6A7683">@@</font><font color="#496682">@</font><font color="#65727F">@@</font><font color="#496682">@</font><font color="#65727F">@@</font><font color="#536B84">@</font><font color="#6C7985">@</font><font color="#727D89">@<br>
</font><font color="#7394B6">@</font><font color="#93A4B5">@@</font><font color="#6A8CAD">@</font><font color="#8896A4">@@</font><font color="#6483A3">@</font><font color="#7D8C9A">@@</font><font color="#5B758F">@</font><font color="#73818E">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6C7985">@@</font><font color="#536B84">@</font><font color="#6A7683">@@</font><font color="#536B84">@</font><font color="#6A7683">@@</font><font color="#536B84">@</font><font color="#65727F">@@</font><font color="#536B84">@</font><font color="#6A7683">@@</font><font color="#536B84">@</font><font color="#707B87">@</font><font color="#73818E">@<br>
</font><font color="#7394B6">@@</font><font color="#6A8CAD">@@</font><font color="#6A87A5">@@</font><font color="#6483A3">@</font><font color="#627C96">@@</font><font color="#5B758F">@@@</font><font color="#576E85">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#536B84">@@@@@@@@@</font><font color="#576E85">@@@</font><font color="#5B758F">@@<br>
</font><font color="#7394B6">@</font><font color="#939EAA">@@</font><font color="#738DA7">@</font><font color="#8896A4">@@</font><font color="#6483A3">@</font><font color="#7D8C9A">@@</font><font color="#5B758F">@</font><font color="#73818E">@@</font><font color="#5B758F">@</font><font color="#727D89">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#707B87">@@</font><font color="#576E85">@</font><font color="#6C7985">@@</font><font color="#576E85">@</font><font color="#6C7985">@@</font><font color="#576E85">@</font><font color="#727D89">@@</font><font color="#5B758F">@</font><font color="#73818E">@</font><font color="#758696">@<br>
</font>
</span>
<BR>

<style type="text/css">.asciiimage{
        color           : #000000;
        background-color: #FFFFFF;
        font-size       : 6px;
        font-family     : "Courier New", Courier, mono;
        line-height     : 4px;
        letter-spacing  : 0px;
    }</style><span class="asciiimage"><font color="#D5251E">$</font><font color="#DD2923">$</font><font color="#DF332D">$</font><font color="#E0423D">$$$$</font><font color="#DF332D">$$</font><font color="#DD2923">$$</font><font color="#D51B13">$$</font><font color="#D51010">$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$</font><font color="#D51008">$$$</font><font color="#CC0000">$$$$$$$</font><font color="#B20600">$$$$$<br>
</font><font color="#DD2923">$</font><font color="#E0938A">$$</font><font color="#E35341">$</font><font color="#E4A099">$$</font><font color="#E35341">$</font><font color="#E0938A">$$</font><font color="#DF332D">$</font><font color="#DC7F7D">$$</font><font color="#D51B13">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$</font><font color="#CC6666">$</font><font color="#9E100A">$</font><font color="#9D5652">$$</font><font color="#B50D06">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$</font><font color="#AF5F57">$</font><font color="#B50D06">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$</font><font color="#AF5F57">$</font><font color="#9E100A">$</font><font color="#9D5652">$$</font><font color="#B50D06">$</font><font color="#D26D6D">$$</font><font color="#CC0000">$</font><font color="#CC6666">$$</font><font color="#CC0000">$</font><font color="#CC6666">$</font><font color="#BC6B61">$</font><font color="#B20600">$</font><font color="#AF5F57">$$</font><font color="#B20600">$</font><font color="#AF5F57">$$<br>
</font><font color="#DF332D">$</font><font color="#E0938A">$</font><font color="#E4A099">$</font><font color="#F06C70">$</font><font color="#E5B1A0">$$</font><font color="#B9A9A0">$</font><font color="#E4A099">$</font><font color="#E0938A">$</font><font color="#DF332D">$</font><font color="#DC7F7D">$$</font><font color="#D51B13">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#DC7F7D">$</font><font color="#D67373">$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$</font><font color="#9D5652">$</font><font color="#000000">$$$$</font><font color="#261D13">$</font><font color="#D67373">$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$</font><font color="#321C1A">$</font><font color="#330000">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$</font><font color="#321C1A">$</font><font color="#000000">$$$$</font><font color="#552F2B">$</font><font color="#D26D6D">$</font><font color="#CC0000">$</font><font color="#CC6666">$$</font><font color="#CC0000">$</font><font color="#BC6B61">$$</font><font color="#B20600">$</font><font color="#AF5F57">$$</font><font color="#B20600">$</font><font color="#AF5F57">$$<br>
</font><font color="#E0423D">$</font><font color="#E66157">$$</font><font color="#ED7A76">$$$</font><font color="#856C61">$</font><font color="#494B49">$</font><font color="#BDBDBD">$</font><font color="#E0423D">$</font><font color="#DF332D">$</font><font color="#DD2923">$$</font><font color="#D51B13">$$</font><font color="#D6BCB5">$</font><font color="#BF4642">$$</font><font color="#D51010">$$</font><font color="#DD2923">$</font><font color="#D51B13">$$$$</font><font color="#D51010">$$$$$$$$$$$$$</font><font color="#9E100A">$</font><font color="#000000">$</font><font color="#9E100A">$</font><font color="#D51010">$</font><font color="#750E06">$</font><font color="#000000">$</font><font color="#9E100A">$</font><font color="#D51010">$</font><font color="#C7130D">$</font><font color="#9E100A">$$</font><font color="#D51010">$</font><font color="#C7130D">$</font><font color="#9E100A">$</font><font color="#C7130D">$</font><font color="#D51010">$</font><font color="#9E100A">$</font><font color="#C7130D">$</font><font color="#D51010">$</font><font color="#9E100A">$</font><font color="#B50D06">$</font><font color="#D51010">$</font><font color="#A61507">$</font><font color="#9E100A">$</font><font color="#D51010">$$</font><font color="#C7130D">$</font><font color="#9E100A">$</font><font color="#B50D06">$</font><font color="#9E100A">$</font><font color="#D51010">$</font><font color="#C7130D">$</font><font color="#9E100A">$</font><font color="#B50D06">$</font><font color="#D51010">$$$</font><font color="#9E100A">$</font><font color="#B50D06">$</font><font color="#330000">$$</font><font color="#D51010">$$$$</font><font color="#330000">$$</font><font color="#D51010">$$</font><font color="#4B0802">$</font><font color="#000000">$</font><font color="#D51008">$</font><font color="#A10B00">$</font><font color="#B20600">$</font><font color="#CC0000">$</font><font color="#B20600">$</font><font color="#8F1300">$</font><font color="#B20600">$$$$$$$<br>
</font><font color="#E0423D">$</font><font color="#E4A099">$</font><font color="#E5B1A0">$</font><font color="#ED7A76">$</font><font color="#EEBBB7">$$</font><font color="#ED7A76">$</font><font color="#ABABAB">$</font><font color="#270941">$</font><font color="#494B49">$</font><font color="#CCCCCC">$</font><font color="#DC8B7F">$</font><font color="#D5251E">$</font><font color="#DC7F7D">$</font><font color="#D67373">$</font><font color="#A69388">$</font><font color="#857F7D">$</font><font color="#B5B5B5">$</font><font color="#D51010">$</font><font color="#F06C70">$</font><font color="#D51B13">$</font><font color="#D51008">$</font><font color="#D5251E">$$</font><font color="#D51008">$</font><font color="#DF442D">$</font><font color="#CF7A4D">$</font><font color="#DD2923">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$</font><font color="#9D5652">$</font><font color="#000000">$</font><font color="#9D5652">$</font><font color="#D67373">$</font><font color="#750E06">$</font><font color="#000000">$</font><font color="#AF5F57">$</font><font color="#9E100A">$</font><font color="#080604">$</font><font color="#261D13">$</font><font color="#080604">$</font><font color="#4B2A27">$</font><font color="#D67373">$</font><font color="#080604">$</font><font color="#95544A">$</font><font color="#C57565">$</font><font color="#000000">$</font><font color="#95544A">$</font><font color="#C57565">$</font><font color="#000000">$</font><font color="#AF5F57">$</font><font color="#4B2A27">$</font><font color="#080604">$</font><font color="#261D13">$</font><font color="#080604">$</font><font color="#B50D06">$</font><font color="#9D5652">$</font><font color="#000000">$$$</font><font color="#9D5652">$</font><font color="#080604">$</font><font color="#261D13">$</font><font color="#080604">$</font><font color="#660D04">$</font><font color="#D67373">$</font><font color="#4B2A27">$</font><font color="#080604">$</font><font color="#261D13">$</font><font color="#080604">$</font><font color="#330000">$</font><font color="#D67373">$$</font><font color="#D51010">$</font><font color="#D67373">$</font><font color="#321C1A">$</font><font color="#330000">$</font><font color="#9D5652">$$</font><font color="#330000">$</font><font color="#321C1A">$</font><font color="#CD736B">$</font><font color="#330000">$</font><font color="#4B2A27">$</font><font color="#BC6B61">$</font><font color="#750E06">$</font><font color="#000000">$</font><font color="#AF5F57">$</font><font color="#B20600">$</font><font color="#AF5F57">$$</font><font color="#A10B00">$</font><font color="#9D5652">$$<br>
</font><font color="#E0423D">$</font><font color="#E4A099">$</font><font color="#E5B1A0">$</font><font color="#ED7A76">$</font><font color="#EEBBB7">$$</font><font color="#ED7A76">$</font><font color="#E5B1A0">$</font><font color="#D6BCB5">$</font><font color="#494B49">$</font><font color="#000000">$</font><font color="#494B49">$</font><font color="#CCCCCC">$</font><font color="#DC7F7D">$</font><font color="#D67373">$</font><font color="#999999">$</font><font color="#857F7D">$</font><font color="#ABABAB">$</font><font color="#CCCCCC">$</font><font color="#CE2179">$</font><font color="#DD006E">$$$</font><font color="#DE0234">$$</font><font color="#D51008">$$$</font><font color="#D5251E">$</font><font color="#DF442D">$</font><font color="#D73C0F">$</font><font color="#D68673">$</font><font color="#D67373">$</font><font color="#CD1A09">$</font><font color="#D67373">$$</font><font color="#CD1A09">$</font><font color="#D67373">$</font><font color="#9D5652">$</font><font color="#000000">$$$$</font><font color="#4B2A27">$</font><font color="#D67373">$</font><font color="#160200">$</font><font color="#4B2A27">$</font><font color="#D67373">$</font><font color="#A61507">$</font><font color="#000000">$</font><font color="#7D4741">$</font><font color="#4B0802">$</font><font color="#4B2A27">$</font><font color="#7D4741">$</font><font color="#160200">$</font><font color="#552F2B">$</font><font color="#7D4741">$</font><font color="#160200">$</font><font color="#BC6B61">$</font><font color="#000000">$</font><font color="#801006">$</font><font color="#D67373">$</font><font color="#261D13">$</font><font color="#4B0802">$</font><font color="#9D5652">$</font><font color="#000000">$</font><font color="#660D04">$</font><font color="#D67373">$</font><font color="#4B2A27">$</font><font color="#160200">$</font><font color="#D67373">$</font><font color="#95544A">$</font><font color="#000000">$</font><font color="#95544A">$</font><font color="#000000">$</font><font color="#801006">$</font><font color="#D67373">$</font><font color="#1B150D">$</font><font color="#330000">$</font><font color="#D67373">$$</font><font color="#CD1A09">$</font><font color="#D67373">$</font><font color="#321C1A">$</font><font color="#000000">$$$$</font><font color="#7D4741">$</font><font color="#CC6666">$</font><font color="#801006">$</font><font color="#080604">$</font><font color="#BC6B61">$</font><font color="#330000">$</font><font color="#4B2A27">$</font><font color="#AF5F57">$</font><font color="#B20600">$</font><font color="#AF5F57">$</font><font color="#9D5652">$</font><font color="#A10B00">$</font><font color="#9D5652">$$<br>
</font><font color="#E0423D">$</font><font color="#E35341">$</font><font color="#E66157">$</font><font color="#EB746B">$</font><font color="#ED7A76">$$$</font><font color="#EB746B">$</font><font color="#E66157">$</font><font color="#E35341">$</font><font color="#CC6666">$</font><font color="#675043">$</font><font color="#03030E">$</font><font color="#270941">$</font><font color="#5E596B">$</font><font color="#999999">$</font><font color="#494B49">$</font><font color="#5E596B">$</font><font color="#ABABAB">$</font><font color="#BC34BB">$</font><font color="#9A02BE">$</font><font color="#B100E7">$</font><font color="#E400DB">$</font><font color="#DE00A6">$$</font><font color="#DD006E">$$</font><font color="#DE0234">$$</font><font color="#D51008">$$</font><font color="#DF4313">$</font><font color="#D51008">$</font><font color="#D73C0F">$$</font><font color="#D0683A">$</font><font color="#D5251E">$</font><font color="#D51B13">$</font><font color="#9E100A">$</font><font color="#000000">$</font><font color="#750E06">$</font><font color="#9E100A">$</font><font color="#A61507">$</font><font color="#CD1A09">$$</font><font color="#000000">$</font><font color="#660D04">$</font><font color="#CD1A09">$$</font><font color="#000000">$</font><font color="#660D04">$</font><font color="#8F1300">$</font><font color="#160200">$</font><font color="#4B0802">$</font><font color="#801006">$</font><font color="#160200">$</font><font color="#4B0802">$</font><font color="#660D04">$</font><font color="#9E100A">$</font><font color="#000000">$</font><font color="#330000">$$$</font><font color="#660D04">$</font><font color="#9E100A">$</font><font color="#000000">$</font><font color="#9E100A">$</font><font color="#CD1A09">$</font><font color="#330000">$</font><font color="#080604">$</font><font color="#330000">$$$</font><font color="#750E06">$</font><font color="#000000">$</font><font color="#9E100A">$</font><font color="#CD1A09">$</font><font color="#330000">$$</font><font color="#CD1A09">$$$$</font><font color="#330000">$$</font><font color="#CD1A09">$$</font><font color="#750E06">$</font><font color="#000000">$</font><font color="#A10B00">$</font><font color="#B50D06">$</font><font color="#000000">$</font><font color="#8F1300">$</font><font color="#000000">$</font><font color="#750E06">$</font><font color="#B20600">$</font><font color="#A10B00">$$$$$$<br>
</font><font color="#DF442D">$</font><font color="#E0938A">$</font><font color="#E4A099">$</font><font color="#E66157">$</font><font color="#E5B1A0">$$</font><font color="#EB746B">$</font><font color="#E5B1A0">$</font><font color="#E4A099">$</font><font color="#E35341">$</font><font color="#E0938A">$</font><font color="#E4A099">$</font><font color="#9B918D">$</font><font color="#494B49">$</font><font color="#000000">$$$</font><font color="#494B49">$</font><font color="#ABABAB">$</font><font color="#5901E5">$$$</font><font color="#9A02BE">$</font><font color="#E400DB">$</font><font color="#9A02BE">$</font><font color="#E400DB">$</font><font color="#DE00A6">$</font><font color="#E400DB">$</font><font color="#DE00A6">$</font><font color="#DD006E">$</font><font color="#DE0234">$$</font><font color="#DD006E">$</font><font color="#DE0234">$</font><font color="#D51008">$$$</font><font color="#DF442D">$</font><font color="#A6593C">$</font><font color="#000000">$</font><font color="#9D5652">$</font><font color="#CD736B">$</font><font color="#CD1A09">$</font><font color="#CD736B">$$</font><font color="#330000">$</font><font color="#261D13">$</font><font color="#BC6B61">$</font><font color="#801006">$</font><font color="#000000">$</font><font color="#9D5652">$</font><font color="#CD1A09">$</font><font color="#080604">$</font><font color="#1B150D">$</font><font color="#C41903">$</font><font color="#261D13">$</font><font color="#1B150D">$</font><font color="#A61507">$</font><font color="#BC6B61">$</font><font color="#000000">$</font><font color="#660D04">$</font><font color="#CD736B">$</font><font color="#704B38">$</font><font color="#A61507">$</font><font color="#9D5652">$</font><font color="#000000">$</font><font color="#9E100A">$</font><font color="#CD736B">$</font><font color="#552F2B">$</font><font color="#080604">$</font><font color="#BC6B61">$</font><font color="#AF5F57">$</font><font color="#801006">$</font><font color="#B76C5B">$</font><font color="#000000">$</font><font color="#660D04">$</font><font color="#BC6B61">$</font><font color="#080604">$</font><font color="#330000">$</font><font color="#CD736B">$$</font><font color="#CD1A09">$</font><font color="#CD736B">$</font><font color="#321C1A">$</font><font color="#330000">$</font><font color="#9D5652">$$</font><font color="#4B0802">$</font><font color="#000000">$</font><font color="#9D5652">$</font><font color="#C41903">$</font><font color="#4B2A27">$</font><font color="#1B150D">$</font><font color="#160200">$</font><font color="#AF5F57">$$</font><font color="#A10B00">$</font><font color="#9D5652">$$</font><font color="#A10B00">$</font><font color="#95544A">$$<br>
</font><font color="#DF442D">$</font><font color="#E0938A">$$</font><font color="#E35341">$</font><font color="#E4A099">$$</font><font color="#E66157">$</font><font color="#E4A099">$$</font><font color="#DF442D">$</font><font color="#DC8B7F">$$</font><font color="#D5251E">$</font><font color="#D2846D">$</font><font color="#BA9580">$</font><font color="#494B49">$</font><font color="#000000">$$</font><font color="#494B49">$</font><font color="#270941">$</font><font color="#2500C9">$$$</font><font color="#5901E5">$</font><font color="#9A02BE">$</font><font color="#B100E7">$$</font><font color="#E400DB">$</font><font color="#DE00A6">$$$$$</font><font color="#DD006E">$$</font><font color="#DE0234">$$</font><font color="#D51008">$</font><font color="#A10B00">$</font><font color="#000000">$</font><font color="#9E100A">$</font><font color="#F06C70">$</font><font color="#D13623">$</font><font color="#CD736B">$$</font><font color="#A61507">$</font><font color="#321C1A">$</font><font color="#000000">$$</font><font color="#7D4741">$</font><font color="#CD736B">$</font><font color="#C61B05">$</font><font color="#4B2A27">$</font><font color="#321C1A">$</font><font color="#C61B05">$</font><font color="#614A30">$</font><font color="#1B150D">$</font><font color="#C61B05">$</font><font color="#CD736B">$</font><font color="#7D4741">$</font><font color="#160200">$</font><font color="#000000">$</font><font color="#1B150D">$</font><font color="#A61507">$</font><font color="#95544A">$</font><font color="#000000">$</font><font color="#8F1300">$</font><font color="#CD736B">$</font><font color="#BC6B61">$</font><font color="#4B0802">$</font><font color="#000000">$$</font><font color="#4B0802">$</font><font color="#CD736B">$</font><font color="#7D4741">$</font><font color="#080604">$$</font><font color="#261D13">$</font><font color="#330000">$</font><font color="#CD736B">$$</font><font color="#C61B05">$</font><font color="#CD736B">$</font><font color="#321C1A">$</font><font color="#000000">$$$$</font><font color="#552F2B">$</font><font color="#BC6B61">$</font><font color="#BC1B01">$</font><font color="#7D4741">$</font><font color="#000000">$</font><font color="#4B0802">$</font><font color="#AF5F57">$$</font><font color="#A10B00">$</font><font color="#9D5652">$$</font><font color="#8F1300">$</font><font color="#95544A">$$<br>
</font><font color="#D93C1E">$</font><font color="#DF442D">$$</font><font color="#E35341">$$$$$</font><font color="#DF442D">$</font><font color="#D93C1E">$$</font><font color="#D13623">$</font><font color="#C82607">$$</font><font color="#C7200A">$</font><font color="#7B5744">$</font><font color="#270941">$</font><font color="#494B49">$</font><font color="#03030E">$</font><font color="#000000">$</font><font color="#03030E">$</font><font color="#000033">$</font><font color="#0E0174">$</font><font color="#2500C9">$$</font><font color="#5901E5">$$</font><font color="#9A02BE">$</font><font color="#B100E7">$</font><font color="#E400DB">$</font><font color="#9A02BE">$</font><font color="#E400DB">$$</font><font color="#DE00A6">$$</font><font color="#DD006E">$$$$</font><font color="#DE0234">$$</font><font color="#D51008">$</font><font color="#D73C0F">$</font><font color="#D0683A">$</font><font color="#C42D11">$</font><font color="#C7200A">$$</font><font color="#C61B05">$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$</font><font color="#C41903">$$$$$</font><font color="#BC1B01">$</font><font color="#8F1300">$</font><font color="#000000">$</font><font color="#8F1300">$</font><font color="#A81A00">$$</font><font color="#A10B00">$</font><font color="#8F1300">$$$$$<br>
</font><font color="#D93C1E">$</font><font color="#DC8B7F">$$</font><font color="#DF442D">$</font><font color="#E0938A">$$</font><font color="#DF442D">$</font><font color="#DC9381">$</font><font color="#DC8B7F">$</font><font color="#D5371A">$</font><font color="#D68673">$</font><font color="#C19F8B">$</font><font color="#C42D11">$</font><font color="#C57565">$$</font><font color="#C21E03">$</font><font color="#C07A60">$</font><font color="#999999">$</font><font color="#9A02BE">$</font><font color="#4F018F">$</font><font color="#0E0174">$</font><font color="#000033">$</font><font color="#000000">$</font><font color="#03030E">$</font><font color="#000033">$$</font><font color="#0E0174">$</font><font color="#2500C9">$</font><font color="#5901E5">$$$$</font><font color="#9A02BE">$</font><font color="#B100E7">$$</font><font color="#E400DB">$</font><font color="#9A02BE">$</font><font color="#E400DB">$</font><font color="#DE00A6">$$</font><font color="#DD006E">$</font><font color="#DE0234">$$$</font><font color="#D51B13">$</font><font color="#D51008">$</font><font color="#BF4642">$</font><font color="#DF442D">$</font><font color="#D73C0F">$</font><font color="#D93C1E">$</font><font color="#CF7A4D">$</font><font color="#DF442D">$</font><font color="#D2846D">$</font><font color="#F06C70">$$</font><font color="#D2846D">$</font><font color="#C57565">$</font><font color="#C21E03">$</font><font color="#C57565">$$</font><font color="#C21E03">$</font><font color="#C57565">$$</font><font color="#C21E03">$</font><font color="#C57565">$$</font><font color="#C21E03">$</font><font color="#C57565">$$</font><font color="#C21E03">$</font><font color="#C57565">$$</font><font color="#C21E03">$</font><font color="#C57565">$$</font><font color="#C21E03">$</font><font color="#C57565">$$</font><font color="#C21E03">$</font><font color="#C57565">$$</font><font color="#C21E03">$</font><font color="#C57565">$$</font><font color="#C21E03">$</font><font color="#BC6B61">$$</font><font color="#BC1B01">$</font><font color="#BC6B61">$$</font><font color="#330000">$</font><font color="#000000">$</font><font color="#4B2A27">$</font><font color="#A81A00">$</font><font color="#9D5652">$$</font><font color="#8F1300">$</font><font color="#95544A">$$</font><font color="#8F1300">$</font><font color="#8D5646">$$<br>
</font><font color="#D83415">$</font><font color="#DC8B7F">$$</font><font color="#D93C1E">$</font><font color="#DC8B7F">$$</font><font color="#DF442D">$</font><font color="#DC8B7F">$</font><font color="#D68673">$</font><font color="#D83415">$</font><font color="#D2846D">$$</font><font color="#C82607">$</font><font color="#C57565">$$</font><font color="#C21E03">$</font><font color="#BC6B61">$</font><font color="#BC34BB">$</font><font color="#E400DB">$</font><font color="#B100E7">$</font><font color="#5901E5">$$</font><font color="#2500C9">$</font><font color="#0E0174">$</font><font color="#000033">$</font><font color="#000000">$$$</font><font color="#000033">$</font><font color="#0E0174">$</font><font color="#2500C9">$$$</font><font color="#5901E5">$$$$</font><font color="#B100E7">$$</font><font color="#9A02BE">$</font><font color="#E400DB">$</font><font color="#DE00A6">$</font><font color="#E400DB">$</font><font color="#DD006E">$$</font><font color="#B11610">$</font><font color="#DD006E">$</font><font color="#DE0234">$</font><font color="#D51008">$$</font><font color="#DF4313">$$</font><font color="#DE0234">$</font><font color="#D51008">$$</font><font color="#DF4313">$</font><font color="#CF7A4D">$</font><font color="#C42D11">$</font><font color="#BC6B61">$$</font><font color="#C21E03">$</font><font color="#BC6B61">$$</font><font color="#C21E03">$</font><font color="#BC6B61">$$</font><font color="#C21E03">$</font><font color="#BC6B61">$$</font><font color="#C21E03">$</font><font color="#BC6B61">$$</font><font color="#C21E03">$</font><font color="#BC6B61">$$</font><font color="#C21E03">$</font><font color="#BC6B61">$$</font><font color="#C21E03">$</font><font color="#BC6B61">$$</font><font color="#C21E03">$</font><font color="#BC6B61">$$</font><font color="#C21E03">$</font><font color="#BC6B61">$$</font><font color="#BC1B01">$</font><font color="#B76C5B">$$</font><font color="#BC1B01">$</font><font color="#AF5F57">$$</font><font color="#A81A00">$</font><font color="#9D5652">$$</font><font color="#8F1300">$</font><font color="#95544A">$$</font><font color="#8F1300">$</font><font color="#8D5646">$$<br>
</font><font color="#D83415">$$$</font><font color="#D93C1E">$$$$</font><font color="#D5371A">$$</font><font color="#C42D11">$$</font><font color="#C82607">$</font><font color="#C42D11">$</font><font color="#C21E03">$$$</font><font color="#C42D11">$</font><font color="#CE2179">$</font><font color="#DD006E">$</font><font color="#DE00A6">$</font><font color="#B100E7">$</font><font color="#9A02BE">$</font><font color="#B100E7">$$</font><font color="#5901E5">$</font><font color="#2500C9">$</font><font color="#0E0174">$</font><font color="#03030E">$</font><font color="#000000">$$</font><font color="#03030E">$</font><font color="#000033">$</font><font color="#0E0174">$$</font><font color="#2500C9">$$</font><font color="#5901E5">$$$</font><font color="#B100E7">$$$$</font><font color="#E400DB">$</font><font color="#DE00A6">$</font><font color="#E400DB">$</font><font color="#DE00A6">$</font><font color="#DD006E">$$</font><font color="#DE0234">$$</font><font color="#DE00A6">$</font><font color="#DD006E">$</font><font color="#DE0234">$</font><font color="#D51008">$$</font><font color="#DE0234">$</font><font color="#D51008">$$$</font><font color="#D0683A">$$</font><font color="#C42D11">$</font><font color="#BC2101">$$$$$$$$$$$$$$$$$$$$$$$$$$$</font><font color="#AB2000">$</font><font color="#A81A00">$$$$</font><font color="#8F1300">$$$$$$$<br>
</font><font color="#D83415">$</font><font color="#D68673">$$</font><font color="#D83415">$</font><font color="#D68673">$$</font><font color="#D83415">$</font><font color="#D2846D">$$</font><font color="#C82607">$</font><font color="#C57565">$$</font><font color="#B9A9A0">$</font><font color="#C57565">$</font><font color="#BC6B61">$</font><font color="#BC2101">$</font><font color="#BC6B61">$</font><font color="#CF7A4D">$</font><font color="#DE0234">$</font><font color="#DD006E">$</font><font color="#DE00A6">$</font><font color="#9A02BE">$</font><font color="#E400DB">$$</font><font color="#B100E7">$</font><font color="#9A02BE">$</font><font color="#5901E5">$$</font><font color="#4F018F">$$</font><font color="#000033">$</font><font color="#000000">$$$</font><font color="#03030E">$</font><font color="#000033">$</font><font color="#0E0174">$$</font><font color="#2500C9">$</font><font color="#5901E5">$</font><font color="#2500C9">$</font><font color="#5901E5">$$</font><font color="#B100E7">$$$</font><font color="#9A02BE">$</font><font color="#E400DB">$$</font><font color="#9A02BE">$</font><font color="#E400DB">$</font><font color="#9A02BE">$</font><font color="#DE00A6">$</font><font color="#DD006E">$</font><font color="#CE2179">$</font><font color="#DE00A6">$</font><font color="#DD006E">$$</font><font color="#DE0234">$</font><font color="#D51008">$$</font><font color="#DF4313">$</font><font color="#D93C1E">$</font><font color="#D73C0F">$</font><font color="#CF7A4D">$</font><font color="#F06C70">$</font><font color="#D13623">$</font><font color="#B76C5B">$$</font><font color="#BC2101">$</font><font color="#B76C5B">$$</font><font color="#BC2101">$</font><font color="#B76C5B">$$</font><font color="#BC2101">$</font><font color="#B76C5B">$$</font><font color="#BC2101">$</font><font color="#B76C5B">$$</font><font color="#BC2101">$</font><font color="#B76C5B">$$</font><font color="#BC2101">$</font><font color="#B76C5B">$$</font><font color="#BC2101">$</font><font color="#B76C5B">$$</font><font color="#AB2000">$</font><font color="#AF5F57">$$</font><font color="#A81A00">$</font><font color="#9D5652">$</font><font color="#95544A">$</font><font color="#8F1300">$</font><font color="#8D5646">$$</font><font color="#8F1300">$</font><font color="#8D5646">$$<br>
</font><font color="#D83415">$</font><font color="#D68673">$$</font><font color="#D83415">$</font><font color="#D68673">$$</font><font color="#D83415">$</font><font color="#D2846D">$$</font><font color="#C82607">$</font><font color="#C57565">$$</font><font color="#BE2901">$</font><font color="#C07A60">$</font><font color="#BC6B61">$</font><font color="#BC2101">$</font><font color="#B76C5B">$$</font><font color="#C97745">$</font><font color="#DF4313">$</font><font color="#DE0234">$$</font><font color="#DD006E">$$</font><font color="#DE00A6">$$</font><font color="#B100E7">$$$</font><font color="#E400DB">$</font><font color="#9A02BE">$$</font><font color="#4F018F">$$</font><font color="#0E0174">$</font><font color="#000033">$</font><font color="#000000">$$</font><font color="#03030E">$</font><font color="#000033">$$$</font><font color="#0E0174">$$</font><font color="#2500C9">$$</font><font color="#5901E5">$$$$$</font><font color="#B100E7">$$$$$</font><font color="#E400DB">$$</font><font color="#DE00A6">$$</font><font color="#DD006E">$$$$$</font><font color="#DE0234">$</font><font color="#D51008">$</font><font color="#EB746B">$</font><font color="#C07A60">$</font><font color="#BE2901">$</font><font color="#B76C5B">$$</font><font color="#BC2101">$</font><font color="#B76C5B">$$</font><font color="#BC2101">$</font><font color="#B76C5B">$$</font><font color="#BC2101">$</font><font color="#B76C5B">$$</font><font color="#BC2101">$</font><font color="#B76C5B">$$</font><font color="#BC2101">$</font><font color="#B76C5B">$$</font><font color="#BC2101">$</font><font color="#B76C5B">$$</font><font color="#AB2000">$</font><font color="#9E6551">$$</font><font color="#A12904">$</font><font color="#95544A">$$</font><font color="#8F1300">$</font><font color="#8D5646">$$</font><font color="#8F1300">$</font><font color="#8D5646">$$<br>
</font><font color="#D73C0F">$$$$$$$$</font><font color="#CC3300">$</font><font color="#C82607">$$$</font><font color="#BE2901">$</font><font color="#B24725">$</font><font color="#D07058">$</font><font color="#DC9381">$$</font><font color="#BF4642">$</font><font color="#AC340F">$</font><font color="#A6593C">$</font><font color="#DF4313">$</font><font color="#D51008">$$$</font><font color="#DE0234">$</font><font color="#E98D96">$</font><font color="#EF80D3">$</font><font color="#F280ED">$</font><font color="#EF80D3">$</font><font color="#F280ED">$</font><font color="#EF80D3">$</font><font color="#F280ED">$</font><font color="#CE60EF">$</font><font color="#B71EE6">$</font><font color="#B100E7">$$</font><font color="#4F018F">$$</font><font color="#270941">$</font><font color="#000033">$</font><font color="#23083B">$</font><font color="#857F7D">$$</font><font color="#5E596B">$</font><font color="#000000">$</font><font color="#000033">$</font><font color="#0E0174">$</font><font color="#000033">$</font><font color="#0E0174">$$</font><font color="#2500C9">$$$</font><font color="#5901E5">$</font><font color="#4020D0">$</font><font color="#9473E6">$</font><font color="#E7B0F8">$</font><font color="#E7C0EF">$$</font><font color="#F280ED">$</font><font color="#B71EE6">$</font><font color="#B100E7">$</font><font color="#9A02BE">$</font><font color="#E400DB">$</font><font color="#DE00A6">$</font><font color="#CE2179">$</font><font color="#EF80D3">$</font><font color="#E98D96">$</font><font color="#D2424E">$</font><font color="#CC0033">$</font><font color="#D73C0F">$</font><font color="#A61507">$</font><font color="#E66157">$$</font><font color="#E98D96">$</font><font color="#DC9381">$</font><font color="#D68673">$</font><font color="#AC340F">$</font><font color="#BC2101">$$</font><font color="#CD736B">$</font><font color="#DC9381">$$$$$$$$$</font><font color="#C57565">$</font><font color="#AB2000">$$$</font><font color="#8E2200">$$$$$$$$<br>
</font><font color="#D73C0F">$</font><font color="#D68673">$$</font><font color="#D73C0F">$</font><font color="#D68673">$$</font><font color="#D73C0F">$</font><font color="#D2846D">$$</font><font color="#C82607">$</font><font color="#C57565">$$</font><font color="#BE2901">$</font><font color="#BC6B61">$</font><font color="#EFEFEF">$</font><font color="#FFFFFF">$$</font><font color="#D6BCB5">$</font><font color="#AD2E03">$</font><font color="#B76C5B">$$</font><font color="#C97745">$</font><font color="#A4693E">$</font><font color="#DF4313">$</font><font color="#D51008">$</font><font color="#FFFFFF">$$</font><font color="#EFEFEF">$</font><font color="#E6E6E6">$$$</font><font color="#EFEFEF">$$$</font><font color="#EF80D3">$</font><font color="#E400DB">$</font><font color="#A800DB">$$</font><font color="#5901E5">$</font><font color="#9A02BE">$</font><font color="#CE60EF">$</font><font color="#FFFFFF">$$</font><font color="#EFEFEF">$</font><font color="#270941">$</font><font color="#03030E">$</font><font color="#000000">$$$$$</font><font color="#03030E">$</font><font color="#000033">$</font><font color="#7F67A5">$</font><font color="#FFFFFF">$</font><font color="#EFEFEF">$</font><font color="#E6E6E6">$$</font><font color="#EFEFEF">$$$</font><font color="#9473E6">$</font><font color="#5901E5">$$</font><font color="#A800DB">$</font><font color="#E740E1">$</font><font color="#FFFFFF">$</font><font color="#DEDEDE">$</font><font color="#C559C1">$</font><font color="#DE00A6">$$</font><font color="#E400DB">$</font><font color="#DE00A6">$</font><font color="#DE0234">$</font><font color="#DACE84">$</font><font color="#FFFFFF">$</font><font color="#DEDEDE">$</font><font color="#DC9381">$</font><font color="#AB2000">$</font><font color="#B76C5B">$</font><font color="#DEDEDE">$</font><font color="#FFFFFF">$</font><font color="#EFEFEF">$</font><font color="#E6E6E6">$$$$$$</font><font color="#DEDEDE">$</font><font color="#B9A9A0">$</font><font color="#9D5652">$$</font><font color="#8E2200">$</font><font color="#95544A">$$</font><font color="#8E2200">$</font><font color="#8D5646">$$</font><font color="#7F2100">$</font><font color="#835842">$$<br>
</font><font color="#D73C0F">$</font><font color="#D68673">$$</font><font color="#D73C0F">$</font><font color="#D68673">$$</font><font color="#D73C0F">$</font><font color="#D2846D">$$</font><font color="#CC3300">$</font><font color="#C07A60">$$</font><font color="#BE2901">$</font><font color="#C19F8B">$</font><font color="#FFFFFF">$$</font><font color="#EFEFEF">$</font><font color="#D7D7D7">$</font><font color="#AC340F">$</font><font color="#AF5F57">$$</font><font color="#A12904">$</font><font color="#9E6551">$</font><font color="#A4693E">$$</font><font color="#FFFFFF">$</font><font color="#EFEFEF">$</font><font color="#CCCCCC">$</font><font color="#BDBDBD">$$</font><font color="#CCCCCC">$</font><font color="#D7D7D7">$$$$</font><font color="#CE31A5">$</font><font color="#CC0099">$</font><font color="#CC00CC">$</font><font color="#A800DB">$</font><font color="#9A02BE">$</font><font color="#F8CFF7">$</font><font color="#FFFFFF">$</font><font color="#EFEFEF">$</font><font color="#CCCCCC">$</font><font color="#C559C1">$</font><font color="#A800DB">$</font><font color="#9202B4">$$</font><font color="#4F018F">$</font><font color="#0E0174">$</font><font color="#270941">$$</font><font color="#A2A0B3">$</font><font color="#FFFFFF">$</font><font color="#E6E6E6">$</font><font color="#BDBDBD">$</font><font color="#857F7D">$$</font><font color="#B5B5B5">$</font><font color="#DEDEDE">$</font><font color="#E6E6E6">$$</font><font color="#7F67A5">$</font><font color="#0E0174">$</font><font color="#2500C9">$</font><font color="#8435A9">$</font><font color="#EFEFEF">$</font><font color="#CCCCCC">$</font><font color="#7A4FBE">$</font><font color="#5901E5">$</font><font color="#A800DB">$</font><font color="#B231B1">$</font><font color="#C97745">$</font><font color="#D3B707">$</font><font color="#DACE84">$</font><font color="#EFEFEF">$</font><font color="#CCCCCC">$</font><font color="#C5AA06">$</font><font color="#D3B707">$</font><font color="#DCC7BF">$</font><font color="#DEDEDE">$</font><font color="#EFEFEF">$</font><font color="#CCCCCC">$</font><font color="#BDBDBD">$</font><font color="#B5B5B5">$$</font><font color="#C5C5C5">$$$</font><font color="#B5B5B5">$</font><font color="#A69388">$</font><font color="#95544A">$$</font><font color="#8E2200">$</font><font color="#8D5646">$$</font><font color="#8E2200">$</font><font color="#835842">$$</font><font color="#7F2100">$</font><font color="#835842">$$<br>
</font><font color="#D73C0F">$$$$$$$</font><font color="#CC3300">$$$</font><font color="#BE2901">$$$</font><font color="#E5B1A0">$</font><font color="#FFFFFF">$$</font><font color="#E6E6E6">$</font><font color="#CCCCCC">$</font><font color="#A6593C">$</font><font color="#A12904">$$$$$</font><font color="#AD2E03">$</font><font color="#EFEFEF">$</font><font color="#D7D7D7">$</font><font color="#BA9580">$</font><font color="#D73C0F">$</font><font color="#B50D06">$$</font><font color="#B11610">$</font><font color="#BB6176">$</font><font color="#DEDEDE">$</font><font color="#D7D7D7">$</font><font color="#B9A9A0">$</font><font color="#B8022B">$</font><font color="#CC0066">$$</font><font color="#CE31A5">$</font><font color="#FFFFFF">$</font><font color="#E6E6E6">$</font><font color="#C5C5C5">$</font><font color="#B5B5B5">$$</font><font color="#CC00CC">$</font><font color="#CC0099">$</font><font color="#CC00CC">$$</font><font color="#A800DB">$$</font><font color="#B441CE">$</font><font color="#FFFFFF">$</font><font color="#E6E6E6">$</font><font color="#A2A0B3">$</font><font color="#8402A3">$</font><font color="#9202B4">$</font><font color="#4F018F">$$</font><font color="#7F67A5">$</font><font color="#DEDEDE">$</font><font color="#D7D7D7">$</font><font color="#CCCCCC">$</font><font color="#23083B">$$</font><font color="#5E596B">$</font><font color="#EFEFEF">$</font><font color="#C5C5C5">$</font><font color="#5E596B">$</font><font color="#0E0174">$</font><font color="#23083B">$</font><font color="#8F7703">$$$</font><font color="#DACE84">$</font><font color="#EFEFEF">$</font><font color="#BDBDBD">$</font><font color="#8F7703">$</font><font color="#C5AA06">$$</font><font color="#DECFC8">$</font><font color="#DEDEDE">$</font><font color="#C5C5C5">$</font><font color="#A12904">$$$</font><font color="#8E2200">$$$$$$$$$$$$</font><font color="#7F2100">$$$$<br>
</font><font color="#D73C0F">$</font><font color="#D68673">$$</font><font color="#D73C0F">$</font><font color="#D68673">$$</font><font color="#D73C0F">$</font><font color="#D2846D">$</font><font color="#C98A68">$</font><font color="#CC3300">$</font><font color="#C07A60">$$</font><font color="#C64105">$</font><font color="#FFFFFF">$</font><font color="#EFEFEF">$</font><font color="#C19F8B">$</font><font color="#CCCCCC">$</font><font color="#BDBDBD">$</font><font color="#A69388">$</font><font color="#8D5646">$$</font><font color="#993300">$</font><font color="#9E6551">$$</font><font color="#AD2E03">$</font><font color="#EFEFEF">$</font><font color="#C5C5C5">$</font><font color="#A69388">$</font><font color="#9E6551">$</font><font color="#895832">$$</font><font color="#AC340F">$$</font><font color="#DCC7BF">$</font><font color="#D7D7D7">$</font><font color="#CCCCCC">$</font><font color="#A10B00">$$</font><font color="#B8022B">$</font><font color="#E98D96">$</font><font color="#EFEFEF">$</font><font color="#B5B5B5">$</font><font color="#9D5652">$</font><font color="#A5A5A5">$</font><font color="#B5B5B5">$</font><font color="#A01046">$</font><font color="#AB0055">$$$</font><font color="#CC0099">$$</font><font color="#E7B0F8">$</font><font color="#E6E6E6">$</font><font color="#BDBDBD">$</font><font color="#CC0099">$</font><font color="#CC00CC">$$$</font><font color="#A4007B">$</font><font color="#B000A9">$</font><font color="#BB65B7">$</font><font color="#C5C5C5">$</font><font color="#B5B5B5">$</font><font color="#8435A9">$</font><font color="#8402A3">$</font><font color="#BC34BB">$</font><font color="#EFEFEF">$</font><font color="#C5C5C5">$</font><font color="#914EA0">$</font><font color="#8402A3">$$</font><font color="#8F7703">$$$</font><font color="#C19F8B">$</font><font color="#EFEFEF">$</font><font color="#BDBDBD">$</font><font color="#5F531C">$$$</font><font color="#BDBDBD">$</font><font color="#CCCCCC">$$</font><font color="#95544A">$</font><font color="#8E2200">$</font><font color="#8D5646">$$</font><font color="#7F2100">$</font><font color="#835842">$$</font><font color="#7F2100">$</font><font color="#79543C">$$</font><font color="#7F2100">$</font><font color="#835842">$$</font><font color="#7F2100">$</font><font color="#835842">$$</font><font color="#7F2100">$</font><font color="#835842">$$<br>
</font><font color="#D5460E">$</font><font color="#D68673">$$</font><font color="#D5460E">$</font><font color="#D68673">$$</font><font color="#D5460E">$</font><font color="#D2846D">$</font><font color="#C98A68">$</font><font color="#C64105">$</font><font color="#C07A60">$$$</font><font color="#E6E6E6">$</font><font color="#C5C5C5">$</font><font color="#A6593C">$</font><font color="#B9A9A0">$</font><font color="#CCCCCC">$</font><font color="#BDBDBD">$</font><font color="#7B5744">$$</font><font color="#8E2200">$</font><font color="#9E6551">$$</font><font color="#AC340F">$</font><font color="#EFEFEF">$</font><font color="#BDBDBD">$</font><font color="#AC8979">$</font><font color="#9E6551">$</font><font color="#835842">$</font><font color="#802900">$</font><font color="#79543C">$$</font><font color="#DECFC8">$</font><font color="#C5C5C5">$</font><font color="#B5B5B5">$</font><font color="#704B38">$</font><font color="#AC340F">$$</font><font color="#E6E6E6">$</font><font color="#D7D7D7">$</font><font color="#988278">$</font><font color="#A61507">$</font><font color="#C5C5C5">$</font><font color="#BDBDBD">$</font><font color="#AB6165">$</font><font color="#9E100A">$</font><font color="#9C0125">$</font><font color="#A10B00">$</font><font color="#B8022B">$</font><font color="#CC0033">$</font><font color="#EFEFEF">$</font><font color="#C5C5C5">$</font><font color="#A95F8C">$</font><font color="#CC0066">$</font><font color="#CC0099">$</font><font color="#AB0055">$$</font><font color="#A4007B">$</font><font color="#AB0055">$</font><font color="#A4007B">$</font><font color="#8B194F">$</font><font color="#A4007B">$</font><font color="#B000A9">$$</font><font color="#BC407D">$</font><font color="#EFEFEF">$</font><font color="#C5C5C5">$</font><font color="#A95F8C">$</font><font color="#A4007B">$</font><font color="#B000A9">$$</font><font color="#A4693E">$</font><font color="#C5AA06">$</font><font color="#DACE84">$</font><font color="#EFEFEF">$</font><font color="#B5B5B5">$</font><font color="#A28D05">$</font><font color="#B28C05">$</font><font color="#8F7703">$</font><font color="#DCC7BF">$</font><font color="#CCCCCC">$$</font><font color="#8D5646">$</font><font color="#8E2200">$</font><font color="#835842">$</font><font color="#79543C">$</font><font color="#7F2100">$</font><font color="#704B38">$$</font><font color="#7F2100">$</font><font color="#79543C">$$</font><font color="#7F2100">$</font><font color="#79543C">$</font><font color="#835842">$</font><font color="#7F2100">$</font><font color="#835842">$$</font><font color="#7F2100">$</font><font color="#835842">$$<br>
</font><font color="#D5460E">$$$$$$$</font><font color="#C64105">$$$$$</font><font color="#DECFC8">$</font><font color="#C5C5C5">$</font><font color="#A5A5A5">$</font><font color="#A12904">$</font><font color="#B24725">$</font><font color="#E6E6E6">$</font><font color="#CCCCCC">$</font><font color="#8B776B">$</font><font color="#702300">$</font><font color="#7F2100">$</font><font color="#8E2200">$</font><font color="#993300">$</font><font color="#AC340F">$</font><font color="#EFEFEF">$</font><font color="#CCCCCC">$</font><font color="#A69388">$</font><font color="#8F3800">$</font><font color="#802900">$$</font><font color="#873C14">$</font><font color="#C19F8B">$</font><font color="#EFEFEF">$</font><font color="#ABABAB">$</font><font color="#857F7D">$</font><font color="#702300">$$</font><font color="#9E6551">$</font><font color="#EFEFEF">$</font><font color="#B5B5B5">$</font><font color="#7B5744">$</font><font color="#895832">$</font><font color="#D6BCB5">$</font><font color="#DEDEDE">$</font><font color="#CCCCCC">$</font><font color="#873C14">$</font><font color="#8F1300">$</font><font color="#AC340F">$</font><font color="#B50D06">$</font><font color="#D2424E">$</font><font color="#EFEFEF">$</font><font color="#B5B5B5">$</font><font color="#A43D70">$</font><font color="#CC0033">$</font><font color="#B8022B">$</font><font color="#AB0055">$</font><font color="#9C0125">$$$$$$</font><font color="#AB0055">$$</font><font color="#BC407D">$</font><font color="#EFEFEF">$</font><font color="#CCCCCC">$</font><font color="#B5B5B5">$</font><font color="#D6BCB5">$</font><font color="#E4BCD0">$$$$</font><font color="#EFEFEF">$$</font><font color="#BDBDBD">$</font><font color="#A28D05">$$$</font><font color="#DECFC8">$</font><font color="#E6E6E6">$</font><font color="#DEDEDE">$</font><font color="#DCC7BF">$$$$$$$</font><font color="#8A4A2F">$</font><font color="#7F2100">$$$$</font><font color="#802900">$$$$$$$<br>
</font><font color="#D5460E">$</font><font color="#D59771">$$</font><font color="#D5460E">$</font><font color="#D68673">$$</font><font color="#CD4909">$</font><font color="#C98A68">$$</font><font color="#C64105">$</font><font color="#C07A60">$</font><font color="#C98A68">$</font><font color="#EFEFEF">$</font><font color="#B5B5B5">$</font><font color="#988278">$</font><font color="#993300">$</font><font color="#8C6446">$</font><font color="#E6E6E6">$$</font><font color="#C5C5C5">$</font><font color="#6B4B36">$</font><font color="#702300">$</font><font color="#835842">$</font><font color="#8C6446">$</font><font color="#A12904">$</font><font color="#FFFFFF">$</font><font color="#E6E6E6">$</font><font color="#DEDEDE">$</font><font color="#EFEFEF">$</font><font color="#FFFFFF">$$</font><font color="#EFEFEF">$</font><font color="#E6E6E6">$</font><font color="#CCCCCC">$</font><font color="#999999">$</font><font color="#755546">$</font><font color="#702300">$</font><font color="#704B38">$</font><font color="#D6BCB5">$</font><font color="#DEDEDE">$</font><font color="#999999">$</font><font color="#835842">$</font><font color="#8E2200">$</font><font color="#A69388">$</font><font color="#EFEFEF">$</font><font color="#C5C5C5">$</font><font color="#755546">$</font><font color="#494B49">$</font><font color="#6B4B36">$</font><font color="#895832">$</font><font color="#AD8257">$</font><font color="#EFEFEF">$</font><font color="#B5B5B5">$</font><font color="#8D4E54">$</font><font color="#B8022B">$</font><font color="#A10B00">$</font><font color="#7C1720">$</font><font color="#8B194F">$</font><font color="#7C1720">$</font><font color="#9C0125">$</font><font color="#7C1720">$$</font><font color="#A10B00">$</font><font color="#7C1720">$$</font><font color="#9D5652">$</font><font color="#EFEFEF">$</font><font color="#C5C5C5">$</font><font color="#BDBDBD">$</font><font color="#CCCCCC">$</font><font color="#D7D7D7">$</font><font color="#E6E6E6">$</font><font color="#EFEFEF">$</font><font color="#FFFFFF">$$</font><font color="#EFEFEF">$</font><font color="#BDBDBD">$</font><font color="#735339">$$$</font><font color="#DECFC8">$</font><font color="#EFEFEF">$</font><font color="#DEDEDE">$$</font><font color="#E6E6E6">$$$$$</font><font color="#DEDEDE">$</font><font color="#8A4A2F">$</font><font color="#79543C">$$</font><font color="#7F2100">$</font><font color="#835842">$$</font><font color="#802900">$</font><font color="#835842">$$</font><font color="#802900">$</font><font color="#835842">$$<br>
</font><font color="#D5460E">$</font><font color="#D59771">$$</font><font color="#D5460E">$</font><font color="#D59771">$$</font><font color="#CD4909">$</font><font color="#C98A68">$$</font><font color="#C64105">$</font><font color="#C07A60">$</font><font color="#DCC7BF">$</font><font color="#EFEFEF">$</font><font color="#BDBDBD">$</font><font color="#9E6551">$</font><font color="#993300">$</font><font color="#8D5646">$</font><font color="#B9A9A0">$</font><font color="#EFEFEF">$</font><font color="#DEDEDE">$</font><font color="#856C61">$</font><font color="#702300">$</font><font color="#79543C">$</font><font color="#8D5646">$</font><font color="#993300">$</font><font color="#FFFFFF">$</font><font color="#EFEFEF">$</font><font color="#DEDEDE">$$</font><font color="#E6E6E6">$</font><font color="#D7D7D7">$</font><font color="#B5B5B5">$</font><font color="#999999">$</font><font color="#857F7D">$</font><font color="#755546">$</font><font color="#79543C">$</font><font color="#722900">$</font><font color="#7B5744">$</font><font color="#EFEFEF">$</font><font color="#CCCCCC">$</font><font color="#9B918D">$</font><font color="#8D5646">$</font><font color="#802900">$</font><font color="#8C6446">$</font><font color="#E6E6E6">$</font><font color="#C5C5C5">$</font><font color="#999999">$</font><font color="#6B4B36">$</font><font color="#722900">$</font><font color="#835842">$</font><font color="#AC8979">$</font><font color="#EFEFEF">$</font><font color="#BDBDBD">$</font><font color="#8B776B">$</font><font color="#993300">$</font><font color="#835842">$</font><font color="#79543C">$</font><font color="#802900">$</font><font color="#835842">$$</font><font color="#8E2200">$</font><font color="#8C6446">$$</font><font color="#8E2200">$</font><font color="#8D5646">$</font><font color="#AC8979">$</font><font color="#EFEFEF">$</font><font color="#BDBDBD">$</font><font color="#999999">$</font><font color="#988278">$</font><font color="#9B918D">$</font><font color="#999999">$</font><font color="#B9A9A0">$</font><font color="#DCC7BF">$</font><font color="#E6E6E6">$</font><font color="#EFEFEF">$</font><font color="#B5B5B5">$</font><font color="#755546">$</font><font color="#802900">$</font><font color="#79543C">$</font><font color="#DECFC8">$</font><font color="#E6E6E6">$</font><font color="#C5C5C5">$</font><font color="#A5A5A5">$</font><font color="#A69388">$</font><font color="#9B918D">$</font><font color="#999999">$</font><font color="#A69388">$</font><font color="#999999">$</font><font color="#9B918D">$</font><font color="#673111">$</font><font color="#79543C">$$</font><font color="#802900">$</font><font color="#835842">$$</font><font color="#802900">$</font><font color="#835842">$$</font><font color="#802900">$</font><font color="#835842">$$<br>
</font><font color="#D5460E">$$$$$</font><font color="#CD4909">$$$$</font><font color="#C64105">$$</font><font color="#EFEFEF">$$</font><font color="#BDBDBD">$</font><font color="#A69388">$</font><font color="#D6BCB5">$</font><font color="#DCC7BF">$</font><font color="#DECFC8">$</font><font color="#EFEFEF">$</font><font color="#CCCCCC">$</font><font color="#988278">$</font><font color="#702300">$</font><font color="#802900">$$</font><font color="#993300">$</font><font color="#FFFFFF">$</font><font color="#E6E6E6">$</font><font color="#B9A9A0">$</font><font color="#9E6551">$$</font><font color="#835842">$</font><font color="#704B38">$</font><font color="#673111">$</font><font color="#702300">$</font><font color="#802900">$$</font><font color="#722900">$</font><font color="#AC8979">$</font><font color="#EFEFEF">$</font><font color="#B5B5B5">$</font><font color="#B9A9A0">$</font><font color="#D6BCB5">$</font><font color="#DCC7BF">$</font><font color="#D6BCB5">$</font><font color="#D7D7D7">$</font><font color="#C5C5C5">$</font><font color="#B5B5B5">$</font><font color="#673111">$</font><font color="#722900">$</font><font color="#802900">$</font><font color="#AD4513">$</font><font color="#EFEFEF">$</font><font color="#CCCCCC">$</font><font color="#AC8979">$</font><font color="#8F3800">$</font><font color="#802900">$$$$</font><font color="#993300">$</font><font color="#B24725">$</font><font color="#B76C5B">$</font><font color="#AD4513">$</font><font color="#993300">$$</font><font color="#A4693E">$</font><font color="#EFEFEF">$</font><font color="#BDBDBD">$</font><font color="#835842">$</font><font color="#802900">$$</font><font color="#702300">$$</font><font color="#802900">$</font><font color="#BA9580">$</font><font color="#EFEFEF">$</font><font color="#B5B5B5">$</font><font color="#673111">$</font><font color="#722900">$$</font><font color="#D6BCB5">$</font><font color="#D7D7D7">$</font><font color="#BDBDBD">$</font><font color="#802900">$</font><font color="#722900">$</font><font color="#702300">$$$$$</font><font color="#802900">$$$$$$$$$$$$<br>
</font><font color="#D4590E">$</font><font color="#D59771">$$</font><font color="#D4590E">$</font><font color="#D59771">$$</font><font color="#CD4909">$</font><font color="#C98A68">$$</font><font color="#C64105">$</font><font color="#E4A099">$</font><font color="#FFFFFF">$</font><font color="#DEDEDE">$</font><font color="#A5A5A5">$$</font><font color="#D7D7D7">$</font><font color="#E6E6E6">$</font><font color="#DEDEDE">$$</font><font color="#CCCCCC">$</font><font color="#BDBDBD">$</font><font color="#6B2800">$</font><font color="#735339">$</font><font color="#835842">$</font><font color="#8F3800">$</font><font color="#EFEFEF">$</font><font color="#CCCCCC">$</font><font color="#A69388">$</font><font color="#8C6446">$</font><font color="#79543C">$</font><font color="#722900">$</font><font color="#704B38">$$</font><font color="#722900">$</font><font color="#79543C">$$</font><font color="#722900">$</font><font color="#DEDEDE">$</font><font color="#E6E6E6">$</font><font color="#A5A5A5">$$</font><font color="#DEDEDE">$$</font><font color="#CCCCCC">$</font><font color="#BDBDBD">$</font><font color="#B5B5B5">$</font><font color="#999999">$</font><font color="#8B776B">$</font><font color="#722900">$</font><font color="#79543C">$</font><font color="#8C6446">$</font><font color="#DEDEDE">$$</font><font color="#CCCCCC">$</font><font color="#873C14">$</font><font color="#7B5744">$$</font><font color="#7B3300">$</font><font color="#8C6446">$$</font><font color="#E5B1A0">$</font><font color="#FFFFFF">$</font><font color="#E6E6E6">$</font><font color="#A4693E">$</font><font color="#9C734D">$</font><font color="#BA9580">$</font><font color="#EFEFEF">$</font><font color="#B5B5B5">$</font><font color="#8B776B">$</font><font color="#802900">$</font><font color="#735339">$</font><font color="#704B38">$</font><font color="#6B2800">$</font><font color="#704B38">$</font><font color="#B9A9A0">$</font><font color="#EFEFEF">$</font><font color="#ABABAB">$</font><font color="#675043">$</font><font color="#673111">$</font><font color="#704B38">$</font><font color="#C5C5C5">$$</font><font color="#BDBDBD">$</font><font color="#79543C">$</font><font color="#722900">$</font><font color="#704B38">$$</font><font color="#6B2800">$</font><font color="#704B38">$$</font><font color="#722900">$</font><font color="#79543C">$$</font><font color="#802900">$</font><font color="#835842">$$</font><font color="#802900">$</font><font color="#835842">$$</font><font color="#802900">$</font><font color="#835842">$$<br>
</font><font color="#D4590E">$</font><font color="#D59771">$$</font><font color="#D4590E">$</font><font color="#D59771">$$</font><font color="#CD4909">$</font><font color="#C98A68">$$</font><font color="#C64105">$</font><font color="#DECFC8">$</font><font color="#DEDEDE">$</font><font color="#ABABAB">$</font><font color="#988278">$$</font><font color="#A69388">$</font><font color="#A5A5A5">$$</font><font color="#B5B5B5">$</font><font color="#CCCCCC">$</font><font color="#B5B5B5">$</font><font color="#704B38">$$</font><font color="#79543C">$</font><font color="#843700">$</font><font color="#E6E6E6">$</font><font color="#B5B5B5">$</font><font color="#988278">$</font><font color="#856342">$</font><font color="#79543C">$</font><font color="#722900">$</font><font color="#6B4B36">$$</font><font color="#722900">$</font><font color="#79543C">$$</font><font color="#895832">$</font><font color="#FFFFFF">$</font><font color="#D7D7D7">$</font><font color="#857F7D">$$</font><font color="#999999">$</font><font color="#A69388">$</font><font color="#9B918D">$$</font><font color="#ABABAB">$</font><font color="#A5A5A5">$</font><font color="#999999">$</font><font color="#6B2800">$</font><font color="#79543C">$</font><font color="#856342">$</font><font color="#C19F8B">$</font><font color="#EFEFEF">$</font><font color="#DEDEDE">$</font><font color="#C19F8B">$</font><font color="#856342">$</font><font color="#7B5744">$</font><font color="#873C14">$</font><font color="#916C49">$</font><font color="#C19F8B">$</font><font color="#FFFFFF">$</font><font color="#DEDEDE">$</font><font color="#BDBDBD">$</font><font color="#AD4513">$</font><font color="#A67A52">$</font><font color="#BA9580">$</font><font color="#E6E6E6">$</font><font color="#A5A5A5">$</font><font color="#856C61">$</font><font color="#873C14">$</font><font color="#755546">$</font><font color="#675043">$</font><font color="#673111">$</font><font color="#735339">$</font><font color="#B9A9A0">$</font><font color="#E6E6E6">$</font><font color="#A5A5A5">$</font><font color="#675043">$</font><font color="#673111">$</font><font color="#735339">$</font><font color="#C5C5C5">$$</font><font color="#BDBDBD">$</font><font color="#79543C">$</font><font color="#722900">$</font><font color="#704B38">$$</font><font color="#6B2800">$</font><font color="#704B38">$$</font><font color="#722900">$</font><font color="#79543C">$$</font><font color="#802900">$</font><font color="#835842">$$</font><font color="#843700">$</font><font color="#835842">$$</font><font color="#802900">$</font><font color="#835842">$$<br>
</font><font color="#D4590E">$$$$$$$</font><font color="#CD4909">$$</font><font color="#D4590E">$</font><font color="#E6E6E6">$</font><font color="#ABABAB">$</font><font color="#856C61">$</font><font color="#A53D00">$</font><font color="#8F3800">$</font><font color="#7B3300">$</font><font color="#722900">$$</font><font color="#673111">$</font><font color="#D7D7D7">$</font><font color="#B5B5B5">$</font><font color="#A69388">$</font><font color="#6B2800">$</font><font color="#722900">$</font><font color="#843700">$</font><font color="#E6E6E6">$</font><font color="#A5A5A5">$</font><font color="#8B776B">$</font><font color="#843700">$</font><font color="#7B3300">$</font><font color="#6B2800">$$$</font><font color="#722900">$$</font><font color="#7B3300">$</font><font color="#C19F8B">$</font><font color="#DEDEDE">$</font><font color="#ABABAB">$</font><font color="#873C14">$</font><font color="#843700">$</font><font color="#7B3300">$</font><font color="#722900">$$</font><font color="#6B2800">$</font><font color="#8B776B">$</font><font color="#B5B5B5">$</font><font color="#ABABAB">$</font><font color="#704B38">$</font><font color="#722900">$</font><font color="#7B3300">$$</font><font color="#DCC7BF">$</font><font color="#E6E6E6">$$</font><font color="#DECFC8">$</font><font color="#C19F8B">$</font><font color="#BA9580">$</font><font color="#D6BCB5">$</font><font color="#EFEFEF">$</font><font color="#D7D7D7">$</font><font color="#B5B5B5">$</font><font color="#916C49">$</font><font color="#A53D00">$$</font><font color="#A4693E">$</font><font color="#DEDEDE">$</font><font color="#999999">$</font><font color="#79543C">$</font><font color="#7B3300">$</font><font color="#722900">$$$$</font><font color="#BA9580">$</font><font color="#DEDEDE">$</font><font color="#999999">$</font><font color="#673111">$</font><font color="#6B2800">$$</font><font color="#D6BCB5">$</font><font color="#D7D7D7">$</font><font color="#CCCCCC">$</font><font color="#AC8979">$</font><font color="#BA9580">$$$$$$$</font><font color="#802900">$$$</font><font color="#843700">$$$$$$$$<br>
</font><font color="#D4590E">$</font><font color="#D59771">$$</font><font color="#D4590E">$</font><font color="#D59771">$$</font><font color="#D4590E">$</font><font color="#C98A68">$$</font><font color="#D59771">$</font><font color="#CCCCCC">$</font><font color="#857F7D">$</font><font color="#8A4A2F">$</font><font color="#9C734D">$</font><font color="#8C6446">$</font><font color="#7B3300">$</font><font color="#704B38">$$</font><font color="#6B2800">$</font><font color="#B9A9A0">$</font><font color="#BDBDBD">$</font><font color="#B5B5B5">$</font><font color="#675043">$</font><font color="#735339">$</font><font color="#7B3300">$</font><font color="#DEDEDE">$</font><font color="#999999">$</font><font color="#856C61">$</font><font color="#835842">$</font><font color="#79543C">$</font><font color="#722900">$</font><font color="#704B38">$$</font><font color="#7B3300">$</font><font color="#835842">$$</font><font color="#D7D7D7">$</font><font color="#999999">$</font><font color="#857F7D">$</font><font color="#8F3800">$</font><font color="#835842">$</font><font color="#79543C">$</font><font color="#722900">$</font><font color="#6B4B36">$$</font><font color="#673111">$</font><font color="#BDBDBD">$</font><font color="#999999">$</font><font color="#8B776B">$</font><font color="#704B38">$</font><font color="#79543C">$</font><font color="#843700">$</font><font color="#8C6446">$</font><font color="#DECFC8">$</font><font color="#DEDEDE">$$</font><font color="#E6E6E6">$$</font><font color="#D7D7D7">$</font><font color="#ABABAB">$</font><font color="#999999">$</font><font color="#988278">$</font><font color="#9C734D">$</font><font color="#A53D00">$</font><font color="#916C49">$</font><font color="#AC8979">$</font><font color="#CCCCCC">$</font><font color="#857F7D">$</font><font color="#7B5744">$</font><font color="#843700">$</font><font color="#79543C">$</font><font color="#735339">$</font><font color="#722900">$</font><font color="#79543C">$</font><font color="#B9A9A0">$</font><font color="#D7D7D7">$</font><font color="#9B918D">$</font><font color="#675043">$</font><font color="#722900">$</font><font color="#735339">$</font><font color="#C5C5C5">$</font><font color="#D7D7D7">$</font><font color="#C5C5C5">$</font><font color="#DEDEDE">$</font><font color="#E6E6E6">$$$$$</font><font color="#DEDEDE">$$</font><font color="#835842">$$</font><font color="#843700">$</font><font color="#835842">$$</font><font color="#843700">$</font><font color="#856342">$$</font><font color="#843700">$</font><font color="#835842">$$<br>
</font><font color="#D4590E">$</font><font color="#D59771">$$</font><font color="#D4590E">$</font><font color="#D59771">$$</font><font color="#D4590E">$</font><font color="#C98A68">$$</font><font color="#DCC7BF">$</font><font color="#C5C5C5">$</font><font color="#999999">$</font><font color="#954600">$</font><font color="#916C49">$</font><font color="#856342">$</font><font color="#7B3300">$</font><font color="#704B38">$$</font><font color="#6B2800">$</font><font color="#8B776B">$</font><font color="#C5C5C5">$</font><font color="#ABABAB">$</font><font color="#8B776B">$</font><font color="#704B38">$</font><font color="#7B3300">$</font><font color="#D7D7D7">$</font><font color="#A5A5A5">$</font><font color="#988278">$</font><font color="#835842">$</font><font color="#79543C">$</font><font color="#722900">$</font><font color="#735339">$</font><font color="#79543C">$</font><font color="#843700">$</font><font color="#8C6446">$</font><font color="#AC8979">$</font><font color="#CCCCCC">$</font><font color="#999999">$</font><font color="#8B776B">$</font><font color="#8F3800">$</font><font color="#835842">$</font><font color="#79543C">$</font><font color="#722900">$</font><font color="#6B4B36">$$</font><font color="#6B2800">$</font><font color="#BDBDBD">$</font><font color="#B5B5B5">$</font><font color="#C5C5C5">$</font><font color="#735339">$$</font><font color="#7B3300">$</font><font color="#835842">$$</font><font color="#9C734D">$</font><font color="#B9A9A0">$</font><font color="#D7D7D7">$</font><font color="#CCCCCC">$</font><font color="#B5B5B5">$</font><font color="#8B776B">$</font><font color="#8A4A2F">$</font><font color="#916C49">$$</font><font color="#8F3800">$</font><font color="#8C6446">$</font><font color="#8B776B">$</font><font color="#CCCCCC">$</font><font color="#999999">$</font><font color="#856C61">$</font><font color="#7B3300">$</font><font color="#79543C">$$</font><font color="#7B3300">$</font><font color="#835842">$</font><font color="#B9A9A0">$</font><font color="#CCCCCC">$</font><font color="#999999">$</font><font color="#755546">$</font><font color="#7B3300">$</font><font color="#79543C">$</font><font color="#BDBDBD">$</font><font color="#CCCCCC">$</font><font color="#C5C5C5">$</font><font color="#CCCCCC">$$$</font><font color="#C5C5C5">$$$</font><font color="#B5B5B5">$</font><font color="#BDBDBD">$</font><font color="#835842">$$</font><font color="#843700">$</font><font color="#835842">$$</font><font color="#843700">$</font><font color="#835842">$$</font><font color="#843700">$</font><font color="#835842">$$<br>
</font><font color="#D4590E">$$$$$$$$</font><font color="#C15703">$$$</font><font color="#AE4C00">$</font><font color="#A44A00">$</font><font color="#954600">$</font><font color="#843700">$</font><font color="#7B3300">$</font><font color="#733300">$$$$$$$$$</font><font color="#843700">$$$$</font><font color="#7B3300">$$$</font><font color="#843700">$$</font><font color="#954600">$</font><font color="#A44A00">$$$</font><font color="#954600">$</font><font color="#8F3800">$</font><font color="#843700">$</font><font color="#7B3300">$</font><font color="#733300">$$$$$$$$$</font><font color="#7B3300">$</font><font color="#843700">$$$$</font><font color="#7B3300">$$$</font><font color="#843700">$$$$$$$$$$$</font><font color="#7B3300">$$$</font><font color="#8F3800">$$$$$</font><font color="#843700">$</font><font color="#7B3300">$$$$$$</font><font color="#733300">$$$$</font><font color="#7B3300">$$$$$</font><font color="#843700">$$$$$$$$<br>
</font><font color="#D4590E">$</font><font color="#D59771">$$</font><font color="#D4590E">$</font><font color="#D59771">$$</font><font color="#D4590E">$</font><font color="#CC9966">$$</font><font color="#C15703">$</font><font color="#B98B5C">$</font><font color="#AD8257">$</font><font color="#A44A00">$</font><font color="#916C49">$</font><font color="#856342">$</font><font color="#7B3300">$</font><font color="#79543C">$$</font><font color="#843700">$</font><font color="#856342">$$</font><font color="#843700">$</font><font color="#7B5744">$$</font><font color="#7B3300">$</font><font color="#835842">$$</font><font color="#843700">$</font><font color="#856342">$$</font><font color="#7B3300">$</font><font color="#835842">$</font><font color="#8C6446">$</font><font color="#954600">$</font><font color="#9E764F">$</font><font color="#A67A52">$</font><font color="#AE4C00">$</font><font color="#A67A52">$</font><font color="#9C734D">$</font><font color="#954600">$</font><font color="#856342">$</font><font color="#835842">$</font><font color="#7B3300">$</font><font color="#79543C">$</font><font color="#835842">$</font><font color="#843700">$</font><font color="#856342">$$</font><font color="#7B3300">$</font><font color="#79543C">$$</font><font color="#843700">$</font><font color="#856342">$</font><font color="#8C6446">$</font><font color="#8F3800">$</font><font color="#8C6446">$</font><font color="#856342">$</font><font color="#7B3300">$</font><font color="#79543C">$$</font><font color="#7B3300">$</font><font color="#7B5744">$$</font><font color="#7B3300">$</font><font color="#835842">$$</font><font color="#843700">$</font><font color="#8C6446">$$</font><font color="#843700">$</font><font color="#835842">$$</font><font color="#843700">$</font><font color="#916C49">$</font><font color="#9C734D">$</font><font color="#9C4B00">$</font><font color="#9C734D">$</font><font color="#916C49">$</font><font color="#843700">$</font><font color="#835842">$$</font><font color="#843700">$</font><font color="#835842">$$</font><font color="#7B3300">$</font><font color="#735339">$$</font><font color="#733300">$</font><font color="#735339">$$</font><font color="#7B3300">$</font><font color="#79543C">$$</font><font color="#7B3300">$</font><font color="#835842">$$</font><font color="#843700">$</font><font color="#856342">$$</font><font color="#843700">$</font><font color="#856342">$$<br>
</font><font color="#D4590E">$</font><font color="#D59771">$$</font><font color="#D4590E">$</font><font color="#D59771">$$</font><font color="#CC6600">$</font><font color="#CC9966">$$</font><font color="#C15703">$</font><font color="#B98B5C">$</font><font color="#AD8257">$</font><font color="#A44A00">$</font><font color="#916C49">$</font><font color="#8C6446">$</font><font color="#843700">$</font><font color="#856342">$$</font><font color="#8C4500">$</font><font color="#916C49">$$</font><font color="#8C4500">$</font><font color="#856342">$$</font><font color="#843700">$</font><font color="#856342">$$</font><font color="#8F3800">$</font><font color="#8C6446">$$</font><font color="#843700">$</font><font color="#8C6446">$</font><font color="#916C49">$</font><font color="#9C4B00">$</font><font color="#A67A52">$$</font><font color="#AE4C00">$</font><font color="#A67A52">$</font><font color="#9E764F">$</font><font color="#954600">$</font><font color="#8C6446">$</font><font color="#856342">$</font><font color="#843700">$</font><font color="#856342">$</font><font color="#8C6446">$</font><font color="#954600">$</font><font color="#916C49">$$</font><font color="#8F3800">$</font><font color="#856342">$$</font><font color="#843700">$</font><font color="#8C6446">$$</font><font color="#954600">$</font><font color="#916C49">$</font><font color="#8C6446">$</font><font color="#843700">$</font><font color="#835842">$$</font><font color="#7B3300">$</font><font color="#79543C">$$</font><font color="#7B3300">$</font><font color="#835842">$</font><font color="#856342">$</font><font color="#8F3800">$</font><font color="#8C6446">$$</font><font color="#8F3800">$</font><font color="#856342">$$</font><font color="#8C4500">$</font><font color="#9C734D">$$</font><font color="#A44A00">$</font><font color="#9E764F">$$</font><font color="#8C4500">$</font><font color="#8C6446">$$</font><font color="#843700">$</font><font color="#856342">$$</font><font color="#843700">$</font><font color="#79543C">$$</font><font color="#733300">$</font><font color="#735339">$$</font><font color="#733300">$</font><font color="#735339">$$</font><font color="#7B3300">$</font><font color="#79543C">$$</font><font color="#843700">$</font><font color="#856342">$$</font><font color="#843700">$</font><font color="#856342">$$<br>
</font><font color="#CC6600">$$$$$$$</font><font color="#C15703">$$$$</font><font color="#AE4C00">$</font><font color="#A44A00">$</font><font color="#954600">$</font><font color="#8C4500">$$$</font><font color="#954600">$$$$$$</font><font color="#8C4500">$$$$$$$$$</font><font color="#954600">$</font><font color="#A44A00">$$</font><font color="#AE4C00">$$$</font><font color="#A44A00">$</font><font color="#954600">$</font><font color="#8C4500">$$$$</font><font color="#954600">$</font><font color="#9C4B00">$$$</font><font color="#954600">$</font><font color="#8C4500">$$$$</font><font color="#954600">$$$$$</font><font color="#8C4500">$</font><font color="#843700">$$$$$$</font><font color="#8C4500">$</font><font color="#954600">$$$$$$$$</font><font color="#A44A00">$$$$</font><font color="#954600">$</font><font color="#8C4500">$$$$$$</font><font color="#843700">$</font><font color="#7B3300">$$$$</font><font color="#733300">$$$$</font><font color="#7B3300">$</font><font color="#843700">$$$$$$$<br>
</font><font color="#CC6600">$</font><font color="#CC9966">$$</font><font color="#CC6600">$</font><font color="#CC9966">$$</font><font color="#CC6600">$</font><font color="#C98A68">$</font><font color="#BC935E">$</font><font color="#C15703">$</font><font color="#B98B5C">$</font><font color="#AD8257">$</font><font color="#A44A00">$</font><font color="#9E764F">$$</font><font color="#954600">$</font><font color="#9C734D">$$</font><font color="#A44A00">$</font><font color="#A67A52">$$</font><font color="#9C4B00">$</font><font color="#9C734D">$$</font><font color="#954600">$</font><font color="#916C49">$$</font><font color="#954600">$</font><font color="#916C49">$$</font><font color="#954600">$</font><font color="#9C734D">$$</font><font color="#A44A00">$</font><font color="#A67A52">$$</font><font color="#AE4C00">$</font><font color="#A67A52">$$</font><font color="#9C4B00">$</font><font color="#9C734D">$</font><font color="#916C49">$</font><font color="#954600">$</font><font color="#9C734D">$$</font><font color="#A44A00">$</font><font color="#A67A52">$$</font><font color="#9C4B00">$</font><font color="#9C734D">$$</font><font color="#954600">$</font><font color="#9C734D">$$</font><font color="#9C4B00">$</font><font color="#9E764F">$$</font><font color="#954600">$</font><font color="#916C49">$$</font><font color="#8C4500">$</font><font color="#8C6446">$$</font><font color="#8C4500">$</font><font color="#916C49">$$</font><font color="#9C4B00">$</font><font color="#9C734D">$$</font><font color="#9C4B00">$</font><font color="#9C734D">$$</font><font color="#9C4B00">$</font><font color="#9E764F">$$</font><font color="#A44A00">$</font><font color="#A67A52">$</font><font color="#9E764F">$</font><font color="#9C4B00">$</font><font color="#9C734D">$$</font><font color="#954600">$</font><font color="#916C49">$$</font><font color="#954600">$</font><font color="#8C6446">$$</font><font color="#843700">$</font><font color="#856342">$$</font><font color="#843700">$</font><font color="#835842">$$</font><font color="#843700">$</font><font color="#835842">$$</font><font color="#843700">$</font><font color="#856342">$$</font><font color="#843700">$</font><font color="#856342">$$<br>
</font><font color="#CC6600">$</font><font color="#CC9966">$$</font><font color="#CC6600">$</font><font color="#CC9966">$$</font><font color="#C15703">$</font><font color="#BC935E">$$</font><font color="#B15A00">$</font><font color="#B98B5C">$</font><font color="#AD8257">$</font><font color="#AE4C00">$</font><font color="#A67A52">$</font><font color="#9E764F">$</font><font color="#733300">$</font><font color="#79543C">$</font><font color="#9C734D">$</font><font color="#A05100">$</font><font color="#A67A52">$$</font><font color="#A05100">$</font><font color="#9E764F">$$</font><font color="#9C4B00">$</font><font color="#9C734D">$$</font><font color="#9C4B00">$</font><font color="#9C734D">$$</font><font color="#9C4B00">$</font><font color="#9C734D">$$</font><font color="#A44A00">$</font><font color="#A67A52">$$</font><font color="#A05100">$</font><font color="#A67A52">$$</font><font color="#9C4B00">$</font><font color="#9C734D">$$</font><font color="#9C4B00">$</font><font color="#9E764F">$$</font><font color="#A44A00">$</font><font color="#A67A52">$$</font><font color="#A05100">$</font><font color="#79543C">$$</font><font color="#954600">$</font><font color="#9C734D">$$</font><font color="#A05100">$</font><font color="#9E764F">$$</font><font color="#9C4B00">$</font><font color="#9C734D">$$</font><font color="#954600">$</font><font color="#79543C">$</font><font color="#735339">$</font><font color="#954600">$</font><font color="#9C734D">$$</font><font color="#A05100">$</font><font color="#9E764F">$$</font><font color="#9C4B00">$</font><font color="#9C734D">$$</font><font color="#9C4B00">$</font><font color="#9E764F">$$</font><font color="#A05100">$</font><font color="#A67A52">$$</font><font color="#9C4B00">$</font><font color="#9C734D">$$</font><font color="#9C4B00">$</font><font color="#9C734D">$$</font><font color="#9C4B00">$</font><font color="#916C49">$$</font><font color="#8C4500">$</font><font color="#8C6446">$$</font><font color="#8C4500">$</font><font color="#856342">$$</font><font color="#834700">$</font><font color="#856342">$$</font><font color="#834700">$</font><font color="#856342">$$</font><font color="#834700">$</font><font color="#856342">$$<br>
</font><font color="#CC6600">$$$$$$</font><font color="#C16801">$$</font><font color="#B15A00">$$$$$</font><font color="#9C4B00">$</font><font color="#160200">$</font><font color="#000000">$$$</font><font color="#663300">$</font><font color="#A05100">$$$$$$$$$$$$$$$$$$$$$$$$$$$$</font><font color="#9C4B00">$</font><font color="#160200">$</font><font color="#000000">$$$</font><font color="#663300">$</font><font color="#A05100">$$$$$$$</font><font color="#663300">$</font><font color="#000000">$</font><font color="#1C0F00">$</font><font color="#663300">$</font><font color="#2A1800">$</font><font color="#A05100">$$$$$$$$$$$$$$$$$$$</font><font color="#9C4B00">$$$</font><font color="#954600">$$$</font><font color="#8C4500">$$$$</font><font color="#834700">$$$$$$$$<br>
</font><font color="#CC6600">$</font><font color="#CC9966">$$</font><font color="#C16801">$</font><font color="#BC935E">$$</font><font color="#C16801">$</font><font color="#B98B5C">$$</font><font color="#B15A00">$</font><font color="#AD8257">$$</font><font color="#A05100">$</font><font color="#552F2B">$</font><font color="#000000">$</font><font color="#8C4500">$</font><font color="#9E764F">$</font><font color="#312519">$</font><font color="#080604">$</font><font color="#9E764F">$$</font><font color="#8C4500">$</font><font color="#79543C">$</font><font color="#916C49">$</font><font color="#A05100">$</font><font color="#9E764F">$</font><font color="#79543C">$</font><font color="#8C4500">$</font><font color="#79543C">$$</font><font color="#834700">$</font><font color="#9E764F">$</font><font color="#8C6446">$</font><font color="#7B3300">$</font><font color="#9E764F">$$</font><font color="#8C4500">$</font><font color="#79543C">$</font><font color="#916C49">$</font><font color="#A05100">$</font><font color="#9E764F">$</font><font color="#79543C">$</font><font color="#8C4500">$</font><font color="#79543C">$</font><font color="#916C49">$</font><font color="#A05100">$</font><font color="#9E764F">$</font><font color="#552F2B">$</font><font color="#000000">$</font><font color="#8C6446">$</font><font color="#9E764F">$</font><font color="#2A1800">$</font><font color="#080604">$</font><font color="#9E764F">$</font><font color="#A05100">$</font><font color="#8C6446">$</font><font color="#79543C">$</font><font color="#8C4500">$</font><font color="#9E764F">$</font><font color="#916C49">$</font><font color="#3C2200">$</font><font color="#000000">$</font><font color="#79543C">$</font><font color="#3C2200">$</font><font color="#000000">$</font><font color="#79543C">$</font><font color="#7B3300">$</font><font color="#8C6446">$</font><font color="#9E764F">$</font><font color="#834700">$</font><font color="#8C6446">$</font><font color="#9E764F">$</font><font color="#834700">$</font><font color="#856342">$</font><font color="#9E764F">$</font><font color="#954600">$</font><font color="#79543C">$$</font><font color="#A05100">$</font><font color="#9E764F">$</font><font color="#856342">$</font><font color="#8C4500">$</font><font color="#79543C">$</font><font color="#8C6446">$</font><font color="#A05100">$</font><font color="#735339">$</font><font color="#856342">$</font><font color="#9C4B00">$</font><font color="#9C734D">$$</font><font color="#954600">$</font><font color="#916C49">$$</font><font color="#8C4500">$</font><font color="#856342">$$</font><font color="#834700">$</font><font color="#856342">$$</font><font color="#834700">$</font><font color="#856342">$$<br>
</font><font color="#CC6600">$</font><font color="#CC9966">$$</font><font color="#C16801">$</font><font color="#BC935E">$$</font><font color="#B15A00">$</font><font color="#B98B5C">$</font><font color="#AD8257">$</font><font color="#B15A00">$</font><font color="#AD8257">$</font><font color="#A67A52">$</font><font color="#A05100">$</font><font color="#735339">$</font><font color="#000000">$</font><font color="#2A1800">$</font><font color="#5C482E">$</font><font color="#856342">$</font><font color="#A05100">$</font><font color="#9C734D">$</font><font color="#614A30">$</font><font color="#000000">$</font><font color="#261D13">$</font><font color="#000000">$</font><font color="#663300">$</font><font color="#9C734D">$</font><font color="#000000">$</font><font color="#080604">$</font><font color="#000000">$</font><font color="#1B150D">$</font><font color="#1C0F00">$</font><font color="#9C734D">$</font><font color="#433322">$</font><font color="#160200">$</font><font color="#9C734D">$</font><font color="#614A30">$</font><font color="#000000">$</font><font color="#261D13">$</font><font color="#000000">$</font><font color="#663300">$</font><font color="#9C734D">$</font><font color="#000000">$</font><font color="#080604">$</font><font color="#000000">$</font><font color="#6B4B36">$</font><font color="#A05100">$</font><font color="#9C734D">$</font><font color="#6B4B36">$</font><font color="#000000">$</font><font color="#261D13">$</font><font color="#5C482E">$</font><font color="#834700">$</font><font color="#9C734D">$$</font><font color="#542D00">$</font><font color="#000000">$</font><font color="#261D13">$</font><font color="#000000">$</font><font color="#614A30">$</font><font color="#856342">$</font><font color="#160200">$</font><font color="#000000">$</font><font color="#261D13">$</font><font color="#160200">$</font><font color="#000000">$</font><font color="#261D13">$</font><font color="#2A1800">$</font><font color="#433322">$</font><font color="#9C734D">$</font><font color="#1C0F00">$</font><font color="#433322">$</font><font color="#9C734D">$</font><font color="#1C0F00">$</font><font color="#5C482E">$</font><font color="#856B42">$</font><font color="#080604">$</font><font color="#261D13">$</font><font color="#080604">$</font><font color="#2A1800">$</font><font color="#9C734D">$</font><font color="#261D13">$</font><font color="#080604">$</font><font color="#000000">$</font><font color="#312519">$</font><font color="#1C0F00">$$$$</font><font color="#9C734D">$$</font><font color="#954600">$</font><font color="#916C49">$$</font><font color="#8C4500">$</font><font color="#856B42">$$</font><font color="#834700">$</font><font color="#856342">$$</font><font color="#834700">$</font><font color="#856342">$$<br>
</font><font color="#C16801">$$$$$</font><font color="#B15A00">$$$$$$</font><font color="#A05100">$$$</font><font color="#663300">$</font><font color="#2A1800">$</font><font color="#000000">$$</font><font color="#3C2200">$</font><font color="#8F5300">$</font><font color="#160200">$</font><font color="#3C2200">$</font><font color="#8F5300">$</font><font color="#3C2200">$</font><font color="#160200">$</font><font color="#8F5300">$</font><font color="#000000">$</font><font color="#2A1800">$</font><font color="#8F5300">$</font><font color="#834700">$</font><font color="#000000">$</font><font color="#8F5300">$</font><font color="#2A1800">$</font><font color="#542D00">$</font><font color="#8F5300">$</font><font color="#160200">$</font><font color="#3C2200">$</font><font color="#8F5300">$</font><font color="#3C2200">$</font><font color="#160200">$</font><font color="#8F5300">$</font><font color="#000000">$</font><font color="#2A1800">$</font><font color="#8F5300">$$$$$</font><font color="#663300">$</font><font color="#2A1800">$</font><font color="#000000">$$</font><font color="#3C2200">$</font><font color="#834700">$</font><font color="#000000">$</font><font color="#542D00">$</font><font color="#8F5300">$</font><font color="#542D00">$</font><font color="#000000">$</font><font color="#834700">$</font><font color="#482800">$</font><font color="#000000">$</font><font color="#8F5300">$</font><font color="#482800">$</font><font color="#000000">$</font><font color="#8F5300">$</font><font color="#663300">$</font><font color="#160200">$</font><font color="#834700">$</font><font color="#160200">$</font><font color="#1C0F00">$</font><font color="#834700">$</font><font color="#000000">$</font><font color="#834700">$$</font><font color="#663300">$</font><font color="#8F5300">$</font><font color="#3C2200">$</font><font color="#000000">$</font><font color="#8F5300">$</font><font color="#2A1800">$</font><font color="#080604">$</font><font color="#8C4500">$</font><font color="#663300">$</font><font color="#000000">$</font><font color="#834700">$$</font><font color="#000000">$</font><font color="#553100">$</font><font color="#8F5300">$$$$</font><font color="#834700">$$$$$$$$$<br>
</font><font color="#C16801">$</font><font color="#BC935E">$$</font><font color="#C16801">$</font><font color="#B98B5C">$$</font><font color="#B15A00">$</font><font color="#AD8257">$$</font><font color="#A15F00">$</font><font color="#9E764F">$$</font><font color="#A05100">$</font><font color="#79543C">$</font><font color="#5C482E">$</font><font color="#8F5300">$</font><font color="#917448">$</font><font color="#433322">$</font><font color="#000000">$</font><font color="#735339">$</font><font color="#000000">$</font><font color="#160200">$</font><font color="#261D13">$$</font><font color="#2A1800">$</font><font color="#917448">$</font><font color="#000000">$</font><font color="#482800">$</font><font color="#917448">$$</font><font color="#160200">$</font><font color="#614A30">$</font><font color="#000000">$</font><font color="#834700">$</font><font color="#917448">$</font><font color="#000000">$</font><font color="#160200">$</font><font color="#261D13">$$</font><font color="#2A1800">$</font><font color="#917448">$</font><font color="#000000">$</font><font color="#482800">$</font><font color="#917448">$$</font><font color="#8F5300">$</font><font color="#917448">$</font><font color="#79543C">$</font><font color="#553100">$</font><font color="#917448">$$</font><font color="#482800">$</font><font color="#000000">$</font><font color="#433322">$</font><font color="#000000">$</font><font color="#735339">$</font><font color="#917448">$</font><font color="#733300">$</font><font color="#000000">$</font><font color="#735339">$</font><font color="#482800">$</font><font color="#000000">$</font><font color="#917448">$</font><font color="#482800">$</font><font color="#000000">$</font><font color="#917448">$</font><font color="#834700">$</font><font color="#000000">$</font><font color="#433322">$</font><font color="#3C2200">$</font><font color="#1B150D">$</font><font color="#433322">$</font><font color="#1C0F00">$</font><font color="#917448">$</font><font color="#79543C">$</font><font color="#1C0F00">$</font><font color="#261D13">$$</font><font color="#000000">$</font><font color="#917448">$</font><font color="#261D13">$</font><font color="#2A1800">$</font><font color="#917448">$</font><font color="#433322">$</font><font color="#000000">$</font><font color="#261D13">$$</font><font color="#2A1800">$</font><font color="#5C482E">$</font><font color="#916C49">$</font><font color="#8C4500">$</font><font color="#856B42">$$</font><font color="#834700">$</font><font color="#856342">$$</font><font color="#834700">$</font><font color="#856342">$$</font><font color="#834700">$</font><font color="#856342">$$<br>
</font><font color="#C16801">$</font><font color="#BC935E">$$</font><font color="#B16D00">$</font><font color="#B98B5C">$</font><font color="#AD8257">$</font><font color="#A15F00">$</font><font color="#A78653">$</font><font color="#A67A52">$</font><font color="#A15F00">$</font><font color="#9C734D">$$</font><font color="#8F5300">$</font><font color="#433322">$</font><font color="#000000">$</font><font color="#542D00">$</font><font color="#6B4B36">$</font><font color="#312519">$</font><font color="#000000">$</font><font color="#7B5744">$</font><font color="#1B150D">$</font><font color="#2A1800">$</font><font color="#8D7346">$</font><font color="#614A30">$</font><font color="#663300">$</font><font color="#8D7346">$</font><font color="#000000">$</font><font color="#482800">$</font><font color="#8D7346">$$</font><font color="#482800">$</font><font color="#080604">$</font><font color="#261D13">$</font><font color="#8F5300">$</font><font color="#8D7346">$</font><font color="#1B150D">$</font><font color="#2A1800">$</font><font color="#8D7346">$</font><font color="#614A30">$</font><font color="#663300">$</font><font color="#8D7346">$</font><font color="#000000">$</font><font color="#482800">$</font><font color="#8D7346">$$</font><font color="#8F5300">$</font><font color="#8D7346">$</font><font color="#433322">$</font><font color="#000000">$</font><font color="#552F2B">$</font><font color="#6B4B36">$</font><font color="#3C2200">$</font><font color="#000000">$</font><font color="#735339">$</font><font color="#080604">$</font><font color="#312519">$</font><font color="#8D7346">$</font><font color="#3C2200">$</font><font color="#080604">$</font><font color="#856B42">$</font><font color="#482800">$</font><font color="#000000">$</font><font color="#8D7346">$</font><font color="#482800">$</font><font color="#000000">$</font><font color="#856B42">$</font><font color="#8F5300">$</font><font color="#312519">$</font><font color="#080604">$</font><font color="#663300">$</font><font color="#433322">$</font><font color="#080604">$</font><font color="#542D00">$</font><font color="#8D7346">$</font><font color="#261D13">$</font><font color="#1C0F00">$</font><font color="#8D7346">$</font><font color="#312519">$</font><font color="#000000">$</font><font color="#8D7346">$</font><font color="#261D13">$</font><font color="#2A1800">$</font><font color="#8D7346">$</font><font color="#614A30">$</font><font color="#000000">$</font><font color="#6B4B36">$</font><font color="#856342">$</font><font color="#542D00">$</font><font color="#79543C">$</font><font color="#856B42">$</font><font color="#834700">$</font><font color="#856B42">$$</font><font color="#834700">$</font><font color="#856342">$$</font><font color="#834700">$</font><font color="#856342">$$</font><font color="#834700">$</font><font color="#856B42">$$<br>
</font><font color="#C16801">$</font><font color="#B16D00">$$$$</font><font color="#A15F00">$$$$</font><font color="#8F5300">$$$$</font><font color="#845200">$</font><font color="#3C2200">$</font><font color="#080604">$</font><font color="#000000">$</font><font color="#160200">$</font><font color="#553100">$</font><font color="#845200">$</font><font color="#663300">$</font><font color="#1C0F00">$</font><font color="#000000">$</font><font color="#080604">$</font><font color="#553100">$</font><font color="#845200">$</font><font color="#000000">$</font><font color="#482800">$</font><font color="#845200">$$</font><font color="#834700">$</font><font color="#000000">$</font><font color="#553100">$</font><font color="#845200">$$</font><font color="#663300">$</font><font color="#1C0F00">$</font><font color="#000000">$</font><font color="#080604">$</font><font color="#553100">$</font><font color="#845200">$</font><font color="#000000">$</font><font color="#482800">$</font><font color="#845200">$$$$$</font><font color="#3C2200">$</font><font color="#080604">$</font><font color="#000000">$</font><font color="#160200">$</font><font color="#553100">$</font><font color="#845200">$</font><font color="#663300">$</font><font color="#160200">$</font><font color="#000000">$</font><font color="#160200">$</font><font color="#663300">$</font><font color="#845200">$</font><font color="#482800">$</font><font color="#000000">$</font><font color="#845200">$</font><font color="#663300">$</font><font color="#080604">$$</font><font color="#845200">$</font><font color="#553100">$</font><font color="#000000">$</font><font color="#845200">$</font><font color="#663300">$</font><font color="#000000">$</font><font color="#834700">$$</font><font color="#553100">$</font><font color="#080604">$$</font><font color="#2A1800">$</font><font color="#000000">$</font><font color="#834700">$</font><font color="#1C0F00">$$</font><font color="#845200">$$</font><font color="#3C2200">$</font><font color="#080604">$</font><font color="#000000">$</font><font color="#1C0F00">$</font><font color="#834700">$$$$$$$$$$$$$$<br>
</font><font color="#B16D00">$</font><font color="#B98B5C">$$</font><font color="#B16D00">$</font><font color="#A78653">$$</font><font color="#A15F00">$</font><font color="#9E764F">$$</font><font color="#8F5300">$</font><font color="#917448">$$</font><font color="#8F5300">$</font><font color="#8D7346">$</font><font color="#856B42">$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#834700">$</font><font color="#856342">$$</font><font color="#834700">$</font><font color="#856342">$$</font><font color="#845200">$</font><font color="#856B42">$$<br>
</font><font color="#B16D00">$</font><font color="#B98B5C">$$</font><font color="#B16D00">$</font><font color="#A78653">$$</font><font color="#A15F00">$</font><font color="#9E764F">$$</font><font color="#8F5300">$</font><font color="#8D7346">$$</font><font color="#8F5300">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$</font><font color="#8D7346">$<br>
</font><font color="#B16D00">$$$$</font><font color="#A15F00">$$$$</font><font color="#8F5300">$$$$$</font><font color="#845200">$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$</font><font color="#8F5300">$<br>
</font><font color="#B16D00">$</font><font color="#B98B5C">$</font><font color="#A78653">$</font><font color="#B16D00">$</font><font color="#A78653">$$</font><font color="#A15F00">$</font><font color="#9E764F">$$</font><font color="#8F5300">$</font><font color="#917448">$$</font><font color="#8F5300">$</font><font color="#8D7346">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$$</font><font color="#845200">$</font><font color="#856B42">$</font><font color="#8D7346">$</font><font color="#8F5300">$</font><font color="#917448">$$<br>
</font>
</span>
<BR>

<style type="text/css">.asciiimage{
        color           : #000000;
        background-color: #FFFFFF;
        font-size       : 6px;
        font-family     : "Courier New", Courier, mono;
        line-height     : 4px;
        letter-spacing  : 0px;
    }</style><span class="asciiimage"><font color="#DC2424">@</font><font color="#DE2B2B">@</font><font color="#DF3232">@</font><font color="#E14040">@@@</font><font color="#E03939">@</font><font color="#DF3232">@</font><font color="#DE2B2B">@</font><font color="#DC2424">@@</font><font color="#D41A17">@@</font><font color="#D51010">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#D20A0A">@@@</font><font color="#C90707">@@</font><font color="#C50101">@@@</font><font color="#BD0000">@@@</font><font color="#B40000">@@@<br>
</font><font color="#DE2B2B">@</font><font color="#DF8C8C">@</font><font color="#DF9696">@</font><font color="#E55151">@</font><font color="#E59C9C">@@</font><font color="#E55151">@</font><font color="#DF8C8C">@@</font><font color="#DE2B2B">@</font><font color="#DA8080">@</font><font color="#DB7B7B">@</font><font color="#D41A17">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#CE0909">@</font><font color="#CC6666">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#BB5D5D">@@</font><font color="#B40000">@</font><font color="#AE5A5A">@@<br>
</font><font color="#DF3232">@</font><font color="#DF9696">@</font><font color="#E59C9C">@</font><font color="#E66363">@</font><font color="#E1A0A0">@</font><font color="#D69494">@</font><font color="#CA5555">@</font><font color="#C68484">@</font><font color="#C47D7D">@</font><font color="#C32C2C">@</font><font color="#C87373">@</font><font color="#C06C6C">@</font><font color="#BD1714">@</font><font color="#BC6565">@@</font><font color="#BC0E0E">@</font><font color="#BC6565">@@</font><font color="#BC0E0E">@</font><font color="#BC6565">@@</font><font color="#BC0E0E">@</font><font color="#BC6565">@@</font><font color="#BC0E0E">@</font><font color="#BC6565">@@</font><font color="#BC0E0E">@</font><font color="#BC6565">@@</font><font color="#BC0E0E">@</font><font color="#BC6565">@@</font><font color="#BC0E0E">@</font><font color="#BC6565">@@</font><font color="#BC0E0E">@</font><font color="#BC6565">@@</font><font color="#BC0E0E">@</font><font color="#BC6565">@@</font><font color="#CD0F0F">@</font><font color="#D26D6D">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D51010">@</font><font color="#D67373">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#C90707">@</font><font color="#CC6666">@@</font><font color="#C50101">@</font><font color="#C46363">@</font><font color="#BB5D5D">@</font><font color="#BD0000">@</font><font color="#B55A5A">@@</font><font color="#AD0000">@</font><font color="#AA5454">@@<br>
</font><font color="#E14040">@</font><font color="#E55151">@</font><font color="#E66363">@</font><font color="#CC6666">@</font><font color="#C46363">@</font><font color="#B55A5A">@</font><font color="#A55252">@</font><font color="#A64141">@</font><font color="#993333">@</font><font color="#A52727">@@</font><font color="#A51A1A">@@</font><font color="#9F1010">@@@</font><font color="#9C0808">@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#A70909">@</font><font color="#B20B09">@</font><font color="#BC0E0E">@</font><font color="#CD0F0F">@</font><font color="#D51010">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#D20A0A">@@@</font><font color="#C90707">@</font><font color="#C50101">@@@</font><font color="#BD0000">@@@</font><font color="#B40000">@</font><font color="#AD0000">@@@@<br>
</font><font color="#E14040">@</font><font color="#E59C9C">@</font><font color="#D69494">@</font><font color="#BB5D5D">@</font><font color="#967979">@</font><font color="#8C6D6D">@</font><font color="#844141">@</font><font color="#8F6363">@@</font><font color="#8F2929">@</font><font color="#945A5A">@@</font><font color="#920F0F">@</font><font color="#8D5252">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#960806">@</font><font color="#9E5252">@</font><font color="#A55A5A">@</font><font color="#B50E0E">@</font><font color="#C06C6C">@</font><font color="#D26D6D">@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@</font><font color="#CC6666">@</font><font color="#CC0000">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#BB5D5D">@@</font><font color="#B40000">@</font><font color="#AE5A5A">@</font><font color="#AA5454">@</font><font color="#A50000">@</font><font color="#A55252">@@<br>
</font><font color="#E14040">@</font><font color="#DF9696">@</font><font color="#C68484">@</font><font color="#994C4C">@</font><font color="#835A5A">@</font><font color="#735050">@</font><font color="#744141">@</font><font color="#856363">@</font><font color="#8F6363">@</font><font color="#8F2929">@</font><font color="#945A5A">@@</font><font color="#920F0F">@</font><font color="#8D5252">@</font><font color="#8C4A4A">@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#8B0909">@</font><font color="#8C4A4A">@@</font><font color="#960806">@</font><font color="#9E5252">@</font><font color="#A55A5A">@</font><font color="#B50E0E">@</font><font color="#C06C6C">@</font><font color="#D26D6D">@</font><font color="#D51010">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#D20A0A">@</font><font color="#D26D6D">@@</font><font color="#CE0909">@</font><font color="#CC6666">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#B55A5A">@@</font><font color="#AD0000">@</font><font color="#AA5454">@@</font><font color="#A50000">@</font><font color="#9E5252">@@<br>
</font><font color="#E03939">@</font><font color="#CE4141">@</font><font color="#B14646">@</font><font color="#8A4040">@</font><font color="#703838">@@</font><font color="#844141">@</font><font color="#934141">@</font><font color="#A64141">@</font><font color="#993333">@</font><font color="#A52727">@</font><font color="#A51A1A">@@</font><font color="#9F1010">@@</font><font color="#9C0808">@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#A70909">@</font><font color="#B20B09">@</font><font color="#BD1714">@</font><font color="#CE1A17">@@@</font><font color="#D51010">@</font><font color="#D20A0A">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#CE0909">@@@@@</font><font color="#C50101">@@@</font><font color="#BD0000">@@</font><font color="#B40000">@@@</font><font color="#A50000">@@</font><font color="#990000">@@@<br>
</font><font color="#DF3232">@</font><font color="#C47D7D">@</font><font color="#A57272">@</font><font color="#843434">@</font><font color="#7B5353">@</font><font color="#856363">@</font><font color="#FFFFFF">@@@@@@@@@@@@@@@</font><font color="#F7F7F7">@@@@</font><font color="#FFFFFF">@@@@@@@@@@@@@@@@@</font><font color="#CC2020">@</font><font color="#DA8080">@@</font><font color="#CE2A2A">@</font><font color="#D67373">@</font><font color="#D26D6D">@</font><font color="#CE0909">@</font><font color="#D26D6D">@@</font><font color="#CE0909">@</font><font color="#D26D6D">@@</font><font color="#CE0909">@</font><font color="#D26D6D">@@</font><font color="#CE0909">@</font><font color="#D26D6D">@@</font><font color="#CE0909">@</font><font color="#D26D6D">@@</font><font color="#CE0909">@</font><font color="#D26D6D">@@</font><font color="#CE0909">@</font><font color="#D26D6D">@@</font><font color="#CE0909">@</font><font color="#D26D6D">@@</font><font color="#CE0909">@</font><font color="#D26D6D">@@</font><font color="#CE0909">@</font><font color="#D26D6D">@@</font><font color="#CE0909">@</font><font color="#D26D6D">@@</font><font color="#CE0909">@</font><font color="#D26D6D">@@</font><font color="#CE0909">@</font><font color="#CC6666">@@</font><font color="#C90707">@</font><font color="#C46363">@@</font><font color="#C50101">@</font><font color="#BB5D5D">@@</font><font color="#B40000">@</font><font color="#AE5A5A">@</font><font color="#AA5454">@</font><font color="#A50000">@</font><font color="#9E5252">@@</font><font color="#990000">@</font><font color="#994C4C">@@<br>
</font><font color="#DE2B2B">@</font><font color="#C47D7D">@</font><font color="#A46969">@</font><font color="#8F2929">@</font><font color="#835A5A">@</font><font color="#996666">@</font><font color="#FFFFFF">@@@@@@@@@@</font><font color="#F7F7F7">@</font><font color="#EDE7E7">@</font><font color="#B5B5B6">@</font><font color="#7A7A7A">@</font><font color="#525252">@</font><font color="#4A4A4B">@</font><font color="#424242">@@</font><font color="#4A4A4B">@</font><font color="#666666">@</font><font color="#999999">@</font><font color="#CCCCCC">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@@@@@@@@@@@@@</font><font color="#CE2A2A">@</font><font color="#DA8080">@@</font><font color="#CC3333">@</font><font color="#C87373">@</font><font color="#CC6666">@</font><font color="#C90707">@</font><font color="#CC6666">@@</font><font color="#C90707">@</font><font color="#CC6666">@@</font><font color="#C90707">@</font><font color="#CC6666">@@</font><font color="#C90707">@</font><font color="#CC6666">@@</font><font color="#C90707">@</font><font color="#CC6666">@@</font><font color="#C90707">@</font><font color="#CC6666">@@</font><font color="#C90707">@</font><font color="#CC6666">@@</font><font color="#C90707">@</font><font color="#CC6666">@@</font><font color="#C90707">@</font><font color="#CC6666">@@</font><font color="#C90707">@</font><font color="#CC6666">@@</font><font color="#C90707">@</font><font color="#CC6666">@@</font><font color="#C90707">@</font><font color="#CC6666">@@</font><font color="#C90707">@</font><font color="#CC6666">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#BB5D5D">@</font><font color="#B55A5A">@</font><font color="#AD0000">@</font><font color="#AA5454">@@</font><font color="#A50000">@</font><font color="#994C4C">@@</font><font color="#990000">@</font><font color="#954A4A">@@<br>
</font><font color="#DC2424">@</font><font color="#BD2020">@</font><font color="#A52727">@</font><font color="#8F2929">@@</font><font color="#993333">@</font><font color="#FFFFFF">@@@@@@@@</font><font color="#F7F7F7">@</font><font color="#CCCCCC">@</font><font color="#666666">@</font><font color="#101010">@</font><font color="#000000">@@@@@@@@@@</font><font color="#3B3B3C">@</font><font color="#999999">@</font><font color="#EFEFEF">@</font><font color="#FFFFFF">@@@@@@@@@@@</font><font color="#CC3333">@</font><font color="#D64B4B">@@</font><font color="#D23B3B">@</font><font color="#CC2020">@</font><font color="#C90707">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#C50101">@@@@</font><font color="#BD0000">@@@@</font><font color="#B40000">@@</font><font color="#A50000">@@</font><font color="#990000">@@@</font><font color="#8C0000">@@@<br>
</font><font color="#DC2424">@</font><font color="#C06C6C">@</font><font color="#A46363">@</font><font color="#932020">@</font><font color="#945A5A">@</font><font color="#A46969">@</font><font color="#FFFFFF">@@@@@@@</font><font color="#E6E6E6">@</font><font color="#747373">@</font><font color="#000000">@@@@@@@@@@@@@@@</font><font color="#2A2A2A">@</font><font color="#AEAEAE">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@@@@@@@@@</font><font color="#D23B3B">@</font><font color="#D69494">@@</font><font color="#D23B3B">@</font><font color="#C87373">@</font><font color="#C46363">@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#C50101">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#BB5D5D">@@</font><font color="#B40000">@</font><font color="#B55A5A">@@</font><font color="#AD0000">@</font><font color="#A55252">@@</font><font color="#990000">@</font><font color="#954A4A">@@</font><font color="#8C0000">@</font><font color="#8C4A4A">@@<br>
</font><font color="#D41A17">@</font><font color="#C06C6C">@</font><font color="#A46363">@</font><font color="#932020">@</font><font color="#945A5A">@</font><font color="#A46363">@</font><font color="#FFFFFF">@@@@@@</font><font color="#BDBDBE">@</font><font color="#2A2A2A">@</font><font color="#000000">@@@@</font><font color="#220607">@@@@</font><font color="#190407">@</font><font color="#220607">@</font><font color="#2A0708">@@@</font><font color="#0F0205">@</font><font color="#000000">@@@@</font><font color="#666666">@</font><font color="#EDE7E7">@</font><font color="#FFFFFF">@@@@@@@@</font><font color="#CE4141">@</font><font color="#D69494">@@</font><font color="#CE4141">@</font><font color="#C87373">@</font><font color="#C46363">@</font><font color="#BD0000">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#C46363">@@</font><font color="#BD0000">@</font><font color="#BB5D5D">@@</font><font color="#BD0000">@</font><font color="#BB5D5D">@@</font><font color="#B40000">@</font><font color="#AE5A5A">@</font><font color="#AA5454">@</font><font color="#A50000">@</font><font color="#9E5252">@</font><font color="#994C4C">@</font><font color="#990000">@</font><font color="#954A4A">@@</font><font color="#8C0000">@</font><font color="#8C4A4A">@@<br>
</font><font color="#D41A17">@</font><font color="#BD1714">@</font><font color="#A40E0E">@</font><font color="#920F0F">@@</font><font color="#A51A1A">@</font><font color="#FFFFFF">@@@@@</font><font color="#B0B0B1">@</font><font color="#101010">@</font><font color="#000000">@@@@</font><font color="#430908">@</font><font color="#BD1714">@@@</font><font color="#AC1415">@@</font><font color="#BD1714">@</font><font color="#AC1415">@</font><font color="#540A0A">@</font><font color="#4B0A0A">@</font><font color="#670C10">@</font><font color="#190407">@</font><font color="#000000">@@@@</font><font color="#525252">@</font><font color="#DDDDDD">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@@@@@@</font><font color="#CE4141">@</font><font color="#CA5555">@@</font><font color="#CE4141">@</font><font color="#CC2020">@</font><font color="#BD0000">@@@@@@@@@</font><font color="#DF8C8C">@</font><font color="#EFC0C0">@</font><font color="#BD0000">@@@@@</font><font color="#DF8C8C">@</font><font color="#EFC0C0">@</font><font color="#BD0000">@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#B40000">@@@</font><font color="#A50000">@@</font><font color="#990000">@@@</font><font color="#8C0000">@@@@@<br>
</font><font color="#D51010">@</font><font color="#BC6565">@</font><font color="#A55A5A">@</font><font color="#920F0F">@</font><font color="#945353">@</font><font color="#A55A5A">@</font><font color="#FFFFFF">@@@@</font><font color="#C5C5C5">@</font><font color="#101010">@</font><font color="#000000">@@@@</font><font color="#080103">@</font><font color="#920F0F">@</font><font color="#C61A18">@</font><font color="#BD1714">@@@@@@</font><font color="#731010">@</font><font color="#190407">@</font><font color="#9F1010">@</font><font color="#7B100F">@</font><font color="#000000">@@@@@</font><font color="#525252">@</font><font color="#E6E6E6">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@@@@@</font><font color="#CE4141">@</font><font color="#D69494">@@</font><font color="#CE4141">@</font><font color="#C87373">@</font><font color="#BB5D5D">@</font><font color="#BD0000">@</font><font color="#BB5D5D">@@</font><font color="#BD0000">@</font><font color="#BB5D5D">@@</font><font color="#BD0000">@</font><font color="#BB5D5D">@</font><font color="#EED7D7">@</font><font color="#FFFFFF">@</font><font color="#B55A5A">@@</font><font color="#B40000">@</font><font color="#B55A5A">@@</font><font color="#DF8C8C">@</font><font color="#EED7D7">@</font><font color="#B55A5A">@</font><font color="#B40000">@</font><font color="#B55A5A">@@</font><font color="#B40000">@</font><font color="#B55A5A">@@</font><font color="#BD0000">@</font><font color="#BB5D5D">@@</font><font color="#BD0000">@</font><font color="#BB5D5D">@@</font><font color="#BD0000">@</font><font color="#BB5D5D">@@</font><font color="#BD0000">@</font><font color="#BB5D5D">@@</font><font color="#BD0000">@</font><font color="#BB5D5D">@@</font><font color="#B40000">@</font><font color="#B55A5A">@@</font><font color="#AD0000">@</font><font color="#AA5454">@</font><font color="#A55252">@</font><font color="#990000">@</font><font color="#994C4C">@</font><font color="#954A4A">@</font><font color="#8C0000">@</font><font color="#8C4A4A">@@</font><font color="#8C0000">@</font><font color="#844141">@@<br>
</font><font color="#D51010">@</font><font color="#BC6565">@</font><font color="#9C5858">@</font><font color="#920F0F">@</font><font color="#8D5252">@</font><font color="#9C5858">@</font><font color="#FFFFFF">@@@</font><font color="#E6E6E6">@</font><font color="#222223">@</font><font color="#000000">@@@@@</font><font color="#430908">@</font><font color="#9F1010">@</font><font color="#4B0A0A">@</font><font color="#7B100F">@</font><font color="#920F0F">@</font><font color="#84100F">@</font><font color="#9F1010">@</font><font color="#B51715">@@@@@@</font><font color="#230406">@</font><font color="#000000">@@@@@</font><font color="#747373">@</font><font color="#EFEFEF">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@@@@</font><font color="#C34040">@</font><font color="#CB8E8E">@@</font><font color="#C34040">@</font><font color="#C06C6C">@</font><font color="#B55A5A">@</font><font color="#B40000">@</font><font color="#B55A5A">@@</font><font color="#B40000">@</font><font color="#B55A5A">@@</font><font color="#B40000">@</font><font color="#B55A5A">@</font><font color="#EED7D7">@</font><font color="#FFFFFF">@</font><font color="#B55A5A">@@</font><font color="#AD0000">@</font><font color="#AE5A5A">@@</font><font color="#CC6666">@</font><font color="#D8ADAD">@</font><font color="#B55A5A">@</font><font color="#BD2020">@</font><font color="#D8ADAD">@</font><font color="#C47D7D">@</font><font color="#E1A0A0">@</font><font color="#EED7D7">@</font><font color="#D8ADAD">@</font><font color="#B40000">@</font><font color="#B55A5A">@</font><font color="#DBAEAE">@</font><font color="#CC6666">@</font><font color="#B55A5A">@@</font><font color="#DA8080">@</font><font color="#CC9999">@</font><font color="#B55A5A">@</font><font color="#DA8080">@</font><font color="#DBAEAE">@</font><font color="#B55A5A">@</font><font color="#BD2020">@</font><font color="#D8ADAD">@</font><font color="#CB8E8E">@</font><font color="#AD0000">@</font><font color="#AE5A5A">@@</font><font color="#A50000">@</font><font color="#A55252">@@</font><font color="#990000">@</font><font color="#994C4C">@</font><font color="#954A4A">@</font><font color="#8C0000">@</font><font color="#8A4040">@@</font><font color="#840000">@</font><font color="#844141">@@<br>
</font><font color="#CD0F0F">@</font><font color="#B50E0E">@</font><font color="#9C0808">@</font><font color="#8B0909">@@</font><font color="#9C0808">@</font><font color="#FFFFFF">@@@</font><font color="#666666">@</font><font color="#000000">@@@@@@</font><font color="#5B0707">@</font><font color="#BD1714">@</font><font color="#3A0708">@</font><font color="#190407">@</font><font color="#3A0708">@</font><font color="#540A0A">@</font><font color="#9F1010">@</font><font color="#BD1714">@</font><font color="#B31713">@@@@</font><font color="#BD1714">@</font><font color="#670C10">@</font><font color="#000000">@@@@@</font><font color="#101010">@</font><font color="#AEAEAE">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@@@@</font><font color="#C34040">@</font><font color="#CA5555">@@</font><font color="#C34040">@</font><font color="#BD2020">@</font><font color="#AD0000">@@@@@@@@@</font><font color="#EFC0C0">@</font><font color="#FFFFFF">@</font><font color="#A50000">@@@@@</font><font color="#E7BFBF">@</font><font color="#FFFFFF">@</font><font color="#A50000">@</font><font color="#BD4040">@</font><font color="#FFFFFF">@</font><font color="#F7EFEF">@</font><font color="#D69494">@</font><font color="#E7D0D0">@</font><font color="#FFFFFF">@</font><font color="#C46363">@</font><font color="#A50000">@</font><font color="#FFFFFF">@</font><font color="#E7BFBF">@</font><font color="#AD0000">@@</font><font color="#FFFFFF">@</font><font color="#E7BFBF">@</font><font color="#AD0000">@</font><font color="#DA8080">@</font><font color="#FFFFFF">@</font><font color="#C46363">@</font><font color="#E7BFBF">@</font><font color="#FFFFFF">@</font><font color="#B83030">@</font><font color="#A50000">@@@@</font><font color="#990000">@@@</font><font color="#8C0000">@@@</font><font color="#840000">@@@@@<br>
</font><font color="#CD0F0F">@</font><font color="#B56363">@</font><font color="#9C5858">@</font><font color="#8B0909">@</font><font color="#8C4A4A">@</font><font color="#9C5858">@</font><font color="#FFFFFF">@@</font><font color="#C5C5C5">@</font><font color="#080808">@</font><font color="#000000">@@@</font><font color="#0F0205">@@</font><font color="#080103">@</font><font color="#540A0A">@</font><font color="#D41A17">@</font><font color="#C61A18">@</font><font color="#AC1613">@@</font><font color="#BD1714">@@</font><font color="#B31713">@@@@@</font><font color="#BD1714">@</font><font color="#9F1010">@</font><font color="#0F0205">@</font><font color="#000000">@@@@@</font><font color="#424242">@</font><font color="#E6E6E6">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@@@</font><font color="#C34040">@</font><font color="#CB8E8E">@@</font><font color="#C34040">@</font><font color="#B67070">@</font><font color="#AE5A5A">@</font><font color="#AD0000">@</font><font color="#AE5A5A">@@</font><font color="#AD0000">@</font><font color="#AE5A5A">@@</font><font color="#AD0000">@</font><font color="#AE5A5A">@</font><font color="#EED7D7">@</font><font color="#FFFFFF">@</font><font color="#AA5454">@@</font><font color="#990000">@</font><font color="#9E5252">@@</font><font color="#E7BFBF">@</font><font color="#FFFFFF">@</font><font color="#A55252">@</font><font color="#B44040">@</font><font color="#FFFFFF">@</font><font color="#DEBFBF">@</font><font color="#990000">@</font><font color="#B77D7D">@</font><font color="#FFFFFF">@</font><font color="#C68484">@</font><font color="#A55252">@</font><font color="#FFFFFF">@</font><font color="#E7BFBF">@</font><font color="#A55252">@@</font><font color="#FFFFFF">@</font><font color="#E7D6D6">@</font><font color="#AA5454">@</font><font color="#A50000">@</font><font color="#EFDFDF">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@</font><font color="#D0AFAF">@</font><font color="#A55252">@</font><font color="#990000">@</font><font color="#9E5252">@@</font><font color="#990000">@</font><font color="#9E5252">@@</font><font color="#8C0000">@</font><font color="#954A4A">@@</font><font color="#840000">@</font><font color="#844141">@@</font><font color="#7B0000">@</font><font color="#844141">@@<br>
</font><font color="#CD0F0F">@</font><font color="#B56363">@</font><font color="#9C5858">@</font><font color="#840909">@</font><font color="#8C4A4A">@</font><font color="#9E5252">@</font><font color="#FFFFFF">@@</font><font color="#666666">@</font><font color="#000000">@@</font><font color="#190407">@</font><font color="#620707">@</font><font color="#84100F">@@</font><font color="#3A0708">@</font><font color="#220607">@</font><font color="#9F1010">@</font><font color="#CE1A17">@@@</font><font color="#BD1714">@@</font><font color="#B31713">@@@@@@@</font><font color="#430908">@</font><font color="#000000">@@@@@</font><font color="#080808">@</font><font color="#A5A5A6">@</font><font color="#EFEFEF">@</font><font color="#FFFFFF">@@@</font><font color="#BD4040">@</font><font color="#CB8E8E">@@</font><font color="#BD4040">@</font><font color="#B67070">@</font><font color="#AE5A5A">@</font><font color="#A50000">@</font><font color="#AE5A5A">@@</font><font color="#A50000">@</font><font color="#AE5A5A">@@</font><font color="#A50000">@</font><font color="#AE5A5A">@</font><font color="#E7D6D6">@</font><font color="#FFFFFF">@</font><font color="#9E5252">@@</font><font color="#8C0000">@</font><font color="#954A4A">@</font><font color="#9E5252">@</font><font color="#E7BFBF">@</font><font color="#FFFFFF">@</font><font color="#9E5252">@</font><font color="#B44040">@</font><font color="#FFFFFF">@</font><font color="#C8A6A6">@</font><font color="#8C0000">@</font><font color="#B77D7D">@</font><font color="#FFFFFF">@</font><font color="#C47D7D">@</font><font color="#994C4C">@</font><font color="#FFFFFF">@</font><font color="#E7BFBF">@</font><font color="#994C4C">@@</font><font color="#FFFFFF">@</font><font color="#E7D6D6">@</font><font color="#9E5252">@</font><font color="#990000">@</font><font color="#B68989">@</font><font color="#FFFFFF">@</font><font color="#F7EFEF">@</font><font color="#9E5252">@@</font><font color="#990000">@</font><font color="#994C4C">@@</font><font color="#8C0000">@</font><font color="#994C4C">@@</font><font color="#8C0000">@</font><font color="#954A4A">@</font><font color="#8C4A4A">@</font><font color="#840000">@</font><font color="#844141">@@</font><font color="#7B0000">@</font><font color="#844141">@@<br>
</font><font color="#BC0E0E">@</font><font color="#AB0C0A">@</font><font color="#920F0F">@</font><font color="#840909">@@@</font><font color="#FFFFFF">@</font><font color="#DDDDDD">@</font><font color="#101010">@</font><font color="#000000">@</font><font color="#100303">@</font><font color="#920F0F">@</font><font color="#D41A17">@@@</font><font color="#731010">@</font><font color="#000000">@</font><font color="#0F0205">@</font><font color="#670C10">@</font><font color="#920F0F">@</font><font color="#B31713">@</font><font color="#BD1714">@@</font><font color="#B31713">@@@@@@</font><font color="#C61A18">@</font><font color="#670C10">@</font><font color="#000000">@@@@@@</font><font color="#5D5D5D">@</font><font color="#DDDDDD">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@@</font><font color="#BD4040">@</font><font color="#CA5555">@@</font><font color="#BD4040">@</font><font color="#AF2020">@</font><font color="#A50000">@@@@@@@@@</font><font color="#E7BFBF">@</font><font color="#FFFFFF">@</font><font color="#990000">@</font><font color="#8C0000">@@@@</font><font color="#E7BFBF">@</font><font color="#FFFFFF">@</font><font color="#990000">@</font><font color="#AD4040">@</font><font color="#FFFFFF">@</font><font color="#C47D7D">@</font><font color="#840000">@</font><font color="#A64141">@</font><font color="#FFFFFF">@</font><font color="#BC8080">@</font><font color="#840000">@</font><font color="#FFFFFF">@</font><font color="#DEBFBF">@</font><font color="#840000">@@</font><font color="#FFFFFF">@</font><font color="#DEBFBF">@</font><font color="#8C0000">@@</font><font color="#DBAEAE">@</font><font color="#FFFFFF">@@</font><font color="#B67070">@</font><font color="#840000">@@@@</font><font color="#8C0000">@@@@@</font><font color="#840000">@@</font><font color="#7B0000">@@@@@<br>
</font><font color="#BC0E0E">@</font><font color="#B56363">@</font><font color="#9C5858">@</font><font color="#840909">@</font><font color="#8C4A4A">@</font><font color="#945353">@</font><font color="#FFFFFF">@</font><font color="#B5B5B6">@</font><font color="#000000">@@</font><font color="#2A0708">@</font><font color="#C61A18">@@</font><font color="#AC1613">@</font><font color="#B51715">@</font><font color="#AC1613">@</font><font color="#4B0A0A">@</font><font color="#080103">@</font><font color="#000000">@</font><font color="#0F0205">@</font><font color="#3A0708">@</font><font color="#540A0A">@</font><font color="#84100F">@</font><font color="#BD1714">@@</font><font color="#B31713">@@@@</font><font color="#BD1714">@</font><font color="#5B0707">@</font><font color="#220607">@</font><font color="#3A0708">@</font><font color="#000000">@@@@</font><font color="#2A2A2A">@</font><font color="#BDBDBE">@</font><font color="#EDE7E7">@</font><font color="#FFFFFF">@@</font><font color="#BD4040">@</font><font color="#C49191">@@</font><font color="#BD4040">@</font><font color="#B56F6F">@</font><font color="#AE5A5A">@</font><font color="#A50000">@</font><font color="#AE5A5A">@@</font><font color="#A50000">@</font><font color="#AE5A5A">@@</font><font color="#A50000">@</font><font color="#AE5A5A">@</font><font color="#E7D6D6">@</font><font color="#FFFFFF">@</font><font color="#C8A6A6">@@</font><font color="#BC8080">@</font><font color="#C0A5A5">@</font><font color="#996666">@</font><font color="#DEBFBF">@</font><font color="#FFFFFF">@</font><font color="#945353">@</font><font color="#A64141">@</font><font color="#FFFFFF">@</font><font color="#C0A5A5">@</font><font color="#7B0000">@</font><font color="#9D7272">@</font><font color="#FFFFFF">@</font><font color="#BC8080">@</font><font color="#844141">@</font><font color="#F7F7F7">@</font><font color="#F7EFEF">@</font><font color="#A57A7A">@</font><font color="#D5BEBE">@</font><font color="#FFFFFF">@</font><font color="#E0D3D3">@</font><font color="#8C4A4A">@</font><font color="#A55252">@</font><font color="#FFFFFF">@</font><font color="#C0A5A5">@</font><font color="#E7D0D0">@</font><font color="#F7F7F7">@</font><font color="#8C5A5A">@</font><font color="#7B0000">@</font><font color="#844141">@@</font><font color="#840000">@</font><font color="#8C4A4A">@@</font><font color="#8C0000">@</font><font color="#8C4A4A">@@</font><font color="#7B0000">@</font><font color="#844141">@@</font><font color="#7B0000">@</font><font color="#7B4242">@@<br>
</font><font color="#BC0E0E">@</font><font color="#AD6363">@</font><font color="#945353">@</font><font color="#840909">@</font><font color="#824B4B">@</font><font color="#945353">@</font><font color="#FFFFFF">@</font><font color="#848484">@</font><font color="#000000">@@</font><font color="#080103">@</font><font color="#7B100F">@</font><font color="#CE1A17">@</font><font color="#BD1714">@</font><font color="#AC1613">@</font><font color="#BD1714">@@</font><font color="#84100F">@</font><font color="#3A0708">@</font><font color="#080103">@</font><font color="#000000">@@</font><font color="#080103">@</font><font color="#920F0F">@</font><font color="#C61A18">@</font><font color="#B31713">@@@@@</font><font color="#670C10">@</font><font color="#9F1010">@</font><font color="#C61A18">@</font><font color="#6C1111">@</font><font color="#0F0205">@</font><font color="#000000">@@</font><font color="#191919">@</font><font color="#999999">@</font><font color="#E6E6E6">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@</font><font color="#B44040">@</font><font color="#C49191">@@</font><font color="#B44040">@</font><font color="#B56F6F">@</font><font color="#A55A5A">@</font><font color="#990000">@</font><font color="#A55A5A">@@</font><font color="#990000">@</font><font color="#A55A5A">@@</font><font color="#990000">@</font><font color="#A55A5A">@</font><font color="#E7D6D6">@</font><font color="#FFFFFF">@@@@@</font><font color="#A57A7A">@</font><font color="#DEBFBF">@</font><font color="#FFFFFF">@</font><font color="#8C4A4A">@</font><font color="#A64141">@</font><font color="#FFFFFF">@</font><font color="#C0A5A5">@</font><font color="#730000">@</font><font color="#9D7272">@</font><font color="#FFFFFF">@</font><font color="#BC8080">@</font><font color="#7B4242">@</font><font color="#AF8484">@</font><font color="#F7EFEF">@</font><font color="#FFFFFF">@</font><font color="#D1C3C3">@</font><font color="#E7D0D0">@@</font><font color="#845151">@</font><font color="#F7EFEF">@@</font><font color="#845151">@</font><font color="#9C4040">@</font><font color="#FFFFFF">@</font><font color="#DDCFCF">@</font><font color="#730000">@</font><font color="#7B4242">@@</font><font color="#7B0000">@</font><font color="#8C4A4A">@@</font><font color="#840000">@</font><font color="#8C4A4A">@@</font><font color="#7B0000">@</font><font color="#7B4242">@@</font><font color="#730000">@</font><font color="#7B4242">@@<br>
</font><font color="#B50E0E">@</font><font color="#A40E0E">@</font><font color="#8B0909">@</font><font color="#7B0909">@@</font><font color="#8B0909">@</font><font color="#FFFFFF">@</font><font color="#666666">@</font><font color="#000000">@@@</font><font color="#100303">@</font><font color="#7B100F">@</font><font color="#BD1714">@@</font><font color="#B31713">@@</font><font color="#CE1A17">@</font><font color="#BD1714">@</font><font color="#84100F">@</font><font color="#540A0A">@</font><font color="#2A0708">@</font><font color="#000000">@</font><font color="#430908">@</font><font color="#BD1714">@@</font><font color="#B31713">@@@@@</font><font color="#BD1714">@@</font><font color="#CE1A17">@</font><font color="#670C10">@</font><font color="#000000">@@</font><font color="#080808">@</font><font color="#8D8D8D">@</font><font color="#DDDDDD">@</font><font color="#EFEFEF">@</font><font color="#FFFFFF">@</font><font color="#B44040">@</font><font color="#B65555">@@</font><font color="#B44040">@</font><font color="#AF2020">@</font><font color="#990000">@@@@@@@@@@@</font><font color="#8C0000">@</font><font color="#840000">@</font><font color="#7B0000">@@@@@@@</font><font color="#730000">@@@@@@@@@@@@@@@@@@@</font><font color="#660000">@@@@</font><font color="#7B0000">@@</font><font color="#840000">@@@@</font><font color="#7B0000">@</font><font color="#730000">@@@@@<br>
</font><font color="#B50E0E">@</font><font color="#AD6363">@</font><font color="#945353">@</font><font color="#7B0909">@</font><font color="#824B4B">@</font><font color="#945353">@</font><font color="#F7F7F7">@</font><font color="#666666">@</font><font color="#000000">@@@@</font><font color="#080103">@</font><font color="#540A0A">@</font><font color="#A40E0E">@</font><font color="#BC0E0E">@</font><font color="#BD1714">@</font><font color="#AC1613">@</font><font color="#BD1714">@</font><font color="#C61A18">@@</font><font color="#9F1010">@</font><font color="#84100F">@@</font><font color="#AC1415">@</font><font color="#B51715">@</font><font color="#B31713">@@@@@@@</font><font color="#BD1714">@</font><font color="#AC1613">@</font><font color="#190407">@</font><font color="#000000">@</font><font color="#080808">@</font><font color="#848484">@</font><font color="#D6D6D6">@</font><font color="#EFEFEF">@</font><font color="#FFFFFF">@</font><font color="#B44040">@</font><font color="#C49191">@@</font><font color="#B44040">@</font><font color="#B56F6F">@</font><font color="#A55A5A">@</font><font color="#990000">@</font><font color="#A55A5A">@@</font><font color="#990000">@</font><font color="#A55A5A">@@</font><font color="#990000">@</font><font color="#A55A5A">@@</font><font color="#8C0000">@</font><font color="#945353">@</font><font color="#8C4A4A">@</font><font color="#7B0000">@</font><font color="#7B4242">@</font><font color="#824B4B">@</font><font color="#7B0000">@</font><font color="#824B4B">@@</font><font color="#7B0000">@</font><font color="#7B4242">@@</font><font color="#730000">@</font><font color="#7B4242">@@</font><font color="#730000">@</font><font color="#7B4242">@@</font><font color="#660000">@</font><font color="#7B4242">@@</font><font color="#660000">@</font><font color="#744141">@@</font><font color="#730000">@</font><font color="#744141">@@</font><font color="#730000">@</font><font color="#744141">@@</font><font color="#660000">@</font><font color="#744141">@@</font><font color="#730000">@</font><font color="#8C4A4A">@@</font><font color="#840000">@</font><font color="#8C4A4A">@@</font><font color="#7B0000">@</font><font color="#7B4242">@@</font><font color="#730000">@</font><font color="#7B4242">@@<br>
</font><font color="#B50E0E">@</font><font color="#AD6363">@</font><font color="#945353">@</font><font color="#7B0909">@</font><font color="#824B4B">@</font><font color="#945353">@</font><font color="#F7F7F7">@</font><font color="#666666">@</font><font color="#000000">@@@@@@</font><font color="#230406">@</font><font color="#7B0909">@</font><font color="#B20B09">@</font><font color="#CE1A17">@</font><font color="#BD1917">@</font><font color="#B31713">@@</font><font color="#BD1714">@</font><font color="#CE1A17">@@</font><font color="#B31713">@@@@@@@@@</font><font color="#C61A18">@</font><font color="#AC1613">@</font><font color="#100303">@</font><font color="#000000">@</font><font color="#080808">@</font><font color="#7A7A7A">@</font><font color="#D6D6D6">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@</font><font color="#AD4040">@</font><font color="#C49191">@@</font><font color="#AD4040">@</font><font color="#AD6F6F">@</font><font color="#A55A5A">@</font><font color="#990000">@</font><font color="#A55A5A">@@</font><font color="#990000">@</font><font color="#A55A5A">@@</font><font color="#990000">@</font><font color="#A55A5A">@@</font><font color="#8C0000">@</font><font color="#945353">@@</font><font color="#7B0000">@</font><font color="#7C4A4A">@@</font><font color="#730000">@</font><font color="#824B4B">@@</font><font color="#7B0000">@</font><font color="#7C4A4A">@@</font><font color="#730000">@</font><font color="#7B4242">@@</font><font color="#730000">@</font><font color="#824B4B">@@</font><font color="#730000">@</font><font color="#7B4242">@@</font><font color="#730000">@</font><font color="#744141">@@</font><font color="#730000">@</font><font color="#7B4242">@@</font><font color="#730000">@</font><font color="#7B4242">@@</font><font color="#660000">@</font><font color="#7B4242">@@</font><font color="#730000">@</font><font color="#8C4A4A">@@</font><font color="#7B0000">@</font><font color="#8C4A4A">@@</font><font color="#730000">@</font><font color="#7B4242">@@</font><font color="#730000">@</font><font color="#7B4242">@@<br>
</font><font color="#AB0C0A">@</font><font color="#9C0808">@</font><font color="#840909">@</font><font color="#730909">@@</font><font color="#840909">@</font><font color="#F7F7F7">@</font><font color="#666666">@</font><font color="#000000">@@@@@</font><font color="#080808">@</font><font color="#3A4B4A">@</font><font color="#5D5D5D">@</font><font color="#4B0A0A">@</font><font color="#660000">@</font><font color="#B20B09">@</font><font color="#CE1A17">@</font><font color="#BD1917">@</font><font color="#B31713">@@@@@@@@@@@</font><font color="#C61A18">@@</font><font color="#5B0707">@</font><font color="#000000">@@</font><font color="#080808">@</font><font color="#848484">@</font><font color="#D6D6D6">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@</font><font color="#AD4040">@</font><font color="#B65555">@@</font><font color="#AD4040">@</font><font color="#A02020">@</font><font color="#CB8E8E">@</font><font color="#E7BFBF">@@@@</font><font color="#BB5D5D">@</font><font color="#8C0000">@@@@@@</font><font color="#840000">@</font><font color="#7B0000">@</font><font color="#730000">@@@@@@@@@@@</font><font color="#7B0000">@@@@@</font><font color="#730000">@@@@@@@@@@@@@</font><font color="#7B0000">@@@</font><font color="#993333">@</font><font color="#DEBFBF">@</font><font color="#AD6363">@</font><font color="#730000">@@@@@@<br>
</font><font color="#AB0C0A">@</font><font color="#AD6363">@</font><font color="#945353">@</font><font color="#730909">@</font><font color="#824B4B">@</font><font color="#8D5252">@</font><font color="#FFFFFF">@</font><font color="#8D8D8D">@</font><font color="#000000">@@@@@</font><font color="#101010">@</font><font color="#A5A5A6">@</font><font color="#B5B5B6">@</font><font color="#6E7779">@</font><font color="#222929">@</font><font color="#3A0708">@</font><font color="#730000">@</font><font color="#B31713">@</font><font color="#C61A18">@@@</font><font color="#BD1917">@@@@@@</font><font color="#CE1A17">@@</font><font color="#AC1415">@</font><font color="#4B0A0A">@</font><font color="#080103">@@</font><font color="#000000">@</font><font color="#191919">@</font><font color="#8D8D8D">@</font><font color="#D6D6D6">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@</font><font color="#AD4040">@</font><font color="#C49191">@@</font><font color="#AD4040">@</font><font color="#AD6F6F">@</font><font color="#E7D6D6">@</font><font color="#FFFFFF">@</font><font color="#E7D6D6">@@</font><font color="#F7EFEF">@</font><font color="#FFFFFF">@</font><font color="#BB9494">@</font><font color="#8C0000">@</font><font color="#9C5858">@@</font><font color="#8C0000">@</font><font color="#945353">@@</font><font color="#7B0000">@</font><font color="#8C4A4A">@@</font><font color="#7B0000">@</font><font color="#8C4A4A">@@</font><font color="#7B0000">@</font><font color="#8C4A4A">@@</font><font color="#7B0000">@</font><font color="#8D5252">@@</font><font color="#7B0000">@</font><font color="#8D5252">@@</font><font color="#7B0000">@</font><font color="#8D5252">@@</font><font color="#7B0000">@</font><font color="#8C4A4A">@@</font><font color="#7B0000">@</font><font color="#8C4A4A">@@</font><font color="#7B0000">@</font><font color="#8C4A4A">@@</font><font color="#7B0000">@</font><font color="#8C4A4A">@@</font><font color="#7B0000">@</font><font color="#8C4A4A">@@</font><font color="#9C4040">@</font><font color="#FFFFFF">@</font><font color="#C0A5A5">@</font><font color="#730000">@</font><font color="#7B4242">@@</font><font color="#660000">@</font><font color="#744141">@@<br>
</font><font color="#A40E0E">@</font><font color="#A46363">@</font><font color="#945353">@</font><font color="#730909">@</font><font color="#824B4B">@</font><font color="#8D5252">@</font><font color="#FFFFFF">@</font><font color="#BDBDBE">@</font><font color="#000000">@</font><font color="#080808">@</font><font color="#191919">@@</font><font color="#080808">@</font><font color="#000000">@</font><font color="#666666">@</font><font color="#D6D6D6">@</font><font color="#E6E6E6">@</font><font color="#C5C5C5">@</font><font color="#788383">@</font><font color="#080103">@</font><font color="#230406">@</font><font color="#4A0000">@</font><font color="#7B0000">@</font><font color="#960806">@</font><font color="#A70909">@</font><font color="#AB0C0A">@@@</font><font color="#A70909">@</font><font color="#9C0808">@</font><font color="#84100F">@</font><font color="#540A0A">@</font><font color="#230406">@</font><font color="#000000">@@@@</font><font color="#2A2A2A">@</font><font color="#A5A5A6">@</font><font color="#CCCCCC">@</font><font color="#EFEFEF">@</font><font color="#FFFFFF">@</font><font color="#A64141">@</font><font color="#C49191">@@</font><font color="#A64141">@</font><font color="#AD6F6F">@</font><font color="#E7D6D6">@</font><font color="#FFFFFF">@</font><font color="#9C5858">@@</font><font color="#932020">@</font><font color="#FFFFFF">@</font><font color="#E7D6D6">@</font><font color="#7B0000">@</font><font color="#945353">@</font><font color="#BC9C9C">@</font><font color="#DEBFBF">@</font><font color="#DBC8C8">@</font><font color="#B68989">@</font><font color="#840000">@</font><font color="#A57272">@</font><font color="#C8A6A6">@</font><font color="#8C2020">@</font><font color="#8D5252">@</font><font color="#A57272">@</font><font color="#BC8080">@</font><font color="#945A5A">@</font><font color="#945353">@</font><font color="#9C4040">@</font><font color="#C8A6A6">@</font><font color="#945A5A">@</font><font color="#932020">@</font><font color="#D5BEBE">@</font><font color="#E7D6D6">@</font><font color="#BC8080">@</font><font color="#945A5A">@</font><font color="#945353">@</font><font color="#AD6363">@</font><font color="#B69191">@@</font><font color="#DEBFBF">@</font><font color="#A57A7A">@</font><font color="#945A5A">@</font><font color="#BC8080">@</font><font color="#E0D3D3">@</font><font color="#D5BEBE">@</font><font color="#8C2020">@</font><font color="#8D5252">@@</font><font color="#993333">@</font><font color="#DBC8C8">@@</font><font color="#B56F6F">@</font><font color="#FFFFFF">@</font><font color="#C0A5A5">@</font><font color="#660000">@</font><font color="#744141">@@</font><font color="#660000">@</font><font color="#744141">@@<br>
</font><font color="#A40E0E">@</font><font color="#920F0F">@</font><font color="#7B0909">@</font><font color="#730909">@@</font><font color="#7B0909">@</font><font color="#FFFFFF">@</font><font color="#DDDDDD">@</font><font color="#4A4A4B">@</font><font color="#848484">@@@@</font><font color="#424242">@</font><font color="#080103">@</font><font color="#848484">@</font><font color="#FFFFFF">@</font><font color="#F7F7F7">@</font><font color="#E6E6E6">@</font><font color="#879090">@</font><font color="#222929">@</font><font color="#080808">@</font><font color="#080103">@</font><font color="#190407">@</font><font color="#230406">@</font><font color="#330000">@@@</font><font color="#2A0708">@</font><font color="#220607">@</font><font color="#100303">@</font><font color="#000000">@@@@@@</font><font color="#525252">@</font><font color="#B5B5B6">@</font><font color="#DDDDDD">@</font><font color="#FFFFFF">@@</font><font color="#A64141">@</font><font color="#B65555">@@</font><font color="#A64141">@</font><font color="#932020">@</font><font color="#DEBFBF">@</font><font color="#FFFFFF">@</font><font color="#840000">@@</font><font color="#8C2020">@</font><font color="#FFFFFF">@</font><font color="#DEBFBF">@</font><font color="#730000">@</font><font color="#C49191">@</font><font color="#FFFFFF">@</font><font color="#C49191">@</font><font color="#D8ADAD">@</font><font color="#FFFFFF">@</font><font color="#A55252">@</font><font color="#8C2020">@</font><font color="#FFFFFF">@</font><font color="#B67070">@</font><font color="#7B0000">@</font><font color="#CC9999">@</font><font color="#FFFFFF">@</font><font color="#AD6363">@</font><font color="#840000">@</font><font color="#D8ADAD">@</font><font color="#EFDFDF">@</font><font color="#891010">@</font><font color="#EFDFDF">@@</font><font color="#CB8E8E">@</font><font color="#F7EFEF">@</font><font color="#DEBFBF">@</font><font color="#7B0000">@</font><font color="#DEBFBF">@</font><font color="#F7EFEF">@</font><font color="#FFFFFF">@@</font><font color="#9C4040">@</font><font color="#D8ADAD">@</font><font color="#F7EFEF">@</font><font color="#C49191">@</font><font color="#EFDFDF">@</font><font color="#F7EFEF">@</font><font color="#84100F">@@</font><font color="#F7EFEF">@@</font><font color="#BC8080">@</font><font color="#F7EFEF">@</font><font color="#FFFFFF">@</font><font color="#B77D7D">@</font><font color="#660000">@</font><font color="#5A0000">@@@@@<br>
</font><font color="#A40E0E">@</font><font color="#A46363">@</font><font color="#8D5252">@</font><font color="#6B0707">@</font><font color="#7C4A4A">@</font><font color="#8D5252">@</font><font color="#FFFFFF">@</font><font color="#F7F7F7">@</font><font color="#C5C5C5">@</font><font color="#D6D6D6">@</font><font color="#CCCCCC">@@</font><font color="#D6D6D6">@</font><font color="#C5C5C5">@</font><font color="#848484">@</font><font color="#7A7A7A">@</font><font color="#DDDDDD">@</font><font color="#EFEFEF">@</font><font color="#F7F7F7">@@</font><font color="#C5C5C5">@</font><font color="#999999">@</font><font color="#788383">@@</font><font color="#6E7779">@@@@</font><font color="#788383">@</font><font color="#3B3B3C">@</font><font color="#000000">@@@@@@</font><font color="#101010">@</font><font color="#848484">@</font><font color="#BDBDBE">@</font><font color="#E6E6E6">@</font><font color="#FFFFFF">@@</font><font color="#A64141">@</font><font color="#BB9494">@@</font><font color="#A64141">@</font><font color="#AD6F6F">@</font><font color="#E7D6D6">@</font><font color="#FFFFFF">@</font><font color="#E7D6D6">@@</font><font color="#F7EFEF">@</font><font color="#FFFFFF">@</font><font color="#A48484">@</font><font color="#7B2020">@</font><font color="#FFFFFF">@</font><font color="#D5BEBE">@</font><font color="#730000">@</font><font color="#8D5252">@</font><font color="#EDE7E7">@</font><font color="#EFDFDF">@</font><font color="#8D5252">@</font><font color="#EFDFDF">@</font><font color="#D8ADAD">@</font><font color="#8D5252">@</font><font color="#EDE7E7">@</font><font color="#EFDFDF">@</font><font color="#D5BEBE">@</font><font color="#945353">@</font><font color="#F7EFEF">@</font><font color="#D0AFAF">@</font><font color="#BB9494">@</font><font color="#FFFFFF">@</font><font color="#B68989">@</font><font color="#945353">@</font><font color="#C49191">@</font><font color="#FFFFFF">@</font><font color="#996666">@</font><font color="#DEBFBF">@</font><font color="#FFFFFF">@</font><font color="#BC9C9C">@</font><font color="#7B0000">@</font><font color="#996666">@</font><font color="#FFFFFF">@</font><font color="#C49191">@</font><font color="#8D5252">@</font><font color="#AF8484">@</font><font color="#FFFFFF">@</font><font color="#B69191">@</font><font color="#BC9C9C">@</font><font color="#FFFFFF">@</font><font color="#B69191">@</font><font color="#824B4B">@</font><font color="#A46363">@</font><font color="#FFFFFF">@</font><font color="#B49E9E">@</font><font color="#5A0000">@</font><font color="#643A3A">@@</font><font color="#5A0000">@</font><font color="#6E3939">@@<br>
</font><font color="#9F1010">@</font><font color="#A46363">@</font><font color="#8C5A5A">@</font><font color="#6B0707">@</font><font color="#7C4A4A">@</font><font color="#8D5252">@</font><font color="#FFFFFF">@@@</font><font color="#E6E6E6">@@</font><font color="#EFEFEF">@@</font><font color="#F7F7F7">@</font><font color="#EFEFEF">@</font><font color="#D6D6D6">@</font><font color="#DDDDDD">@</font><font color="#EFEFEF">@</font><font color="#FFFFFF">@@@</font><font color="#EFEFEF">@</font><font color="#D6D6D6">@</font><font color="#BDBDBE">@</font><font color="#D6D6D6">@@</font><font color="#CCCCCC">@</font><font color="#D6D6D6">@</font><font color="#DDDDDD">@</font><font color="#5D5D5D">@</font><font color="#000000">@@@@@@</font><font color="#3B3B3C">@</font><font color="#A5A5A6">@</font><font color="#C5C5C5">@</font><font color="#EFEFEF">@</font><font color="#FFFFFF">@@</font><font color="#A64141">@</font><font color="#BB9494">@@</font><font color="#A64141">@</font><font color="#AD6F6F">@</font><font color="#E7D6D6">@</font><font color="#FFFFFF">@</font><font color="#E0D3D3">@@</font><font color="#D0AFAF">@</font><font color="#9C7B7B">@</font><font color="#744141">@</font><font color="#8A4040">@</font><font color="#FFFFFF">@</font><font color="#C0A5A5">@</font><font color="#660000">@</font><font color="#824B4B">@</font><font color="#E0D3D3">@</font><font color="#FFFFFF">@</font><font color="#845151">@</font><font color="#BC9C9C">@</font><font color="#F7EFEF">@</font><font color="#9D7272">@</font><font color="#FFFFFF">@</font><font color="#BC8080">@</font><font color="#F7F7F7">@</font><font color="#A57272">@</font><font color="#FFFFFF">@</font><font color="#9D7272">@</font><font color="#C8A6A6">@</font><font color="#FFFFFF">@@@@@</font><font color="#A57A7A">@</font><font color="#DEBFBF">@</font><font color="#FFFFFF">@</font><font color="#845151">@</font><font color="#730000">@</font><font color="#A57A7A">@</font><font color="#FFFFFF">@@@@@</font><font color="#C0A5A5">@@</font><font color="#FFFFFF">@</font><font color="#9D7272">@</font><font color="#7B4242">@</font><font color="#8A4040">@</font><font color="#FFFFFF">@</font><font color="#B49E9E">@</font><font color="#520000">@</font><font color="#5C3A3A">@@</font><font color="#520000">@</font><font color="#643A3A">@@<br>
</font><font color="#9F1010">@</font><font color="#8B0909">@</font><font color="#730909">@@@@</font><font color="#FFFFFF">@@@@@@@@@@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@@@@@@</font><font color="#999999">@</font><font color="#333333">@</font><font color="#747373">@</font><font color="#E6E6E6">@</font><font color="#F7F7F7">@</font><font color="#EDE7E7">@</font><font color="#333333">@</font><font color="#000000">@@@@@</font><font color="#101010">@</font><font color="#848484">@</font><font color="#B5B5B6">@</font><font color="#DDDDDD">@</font><font color="#FFFFFF">@@@</font><font color="#9C4040">@</font><font color="#AA5454">@@</font><font color="#9C4040">@</font><font color="#8C2020">@</font><font color="#DEBFBF">@</font><font color="#FFFFFF">@</font><font color="#730000">@@</font><font color="#660000">@</font><font color="#5A0000">@@</font><font color="#762727">@</font><font color="#FFFFFF">@</font><font color="#B69191">@</font><font color="#660000">@@</font><font color="#E0D3D3">@</font><font color="#F7EFEF">@</font><font color="#660000">@</font><font color="#7B2020">@</font><font color="#FFFFFF">@</font><font color="#D0AFAF">@</font><font color="#E7D0D0">@</font><font color="#731010">@</font><font color="#FFFFFF">@</font><font color="#D0AFAF">@</font><font color="#EFDFDF">@</font><font color="#660000">@</font><font color="#AD6F6F">@</font><font color="#FFFFFF">@</font><font color="#945353">@</font><font color="#660000">@@@@</font><font color="#D5BEBE">@</font><font color="#FFFFFF">@</font><font color="#660000">@@</font><font color="#843434">@</font><font color="#FFFFFF">@</font><font color="#BB9494">@</font><font color="#660000">@@@@</font><font color="#A57272">@</font><font color="#FFFFFF">@</font><font color="#8D5252">@</font><font color="#5A0000">@</font><font color="#8D5252">@</font><font color="#FFFFFF">@</font><font color="#A48484">@</font><font color="#4A0000">@@@@@</font><font color="#5A0000">@<br>
</font><font color="#920F0F">@</font><font color="#A46363">@</font><font color="#8D5252">@</font><font color="#620707">@</font><font color="#7C4A4A">@</font><font color="#845151">@</font><font color="#FFFFFF">@@@@@@@@@@@@@@@@@</font><font color="#E6E6E6">@</font><font color="#A5A5A6">@</font><font color="#B5B5B6">@</font><font color="#E6E6E6">@</font><font color="#FFFFFF">@</font><font color="#999999">@</font><font color="#000000">@</font><font color="#191919">@</font><font color="#666666">@@</font><font color="#525252">@</font><font color="#2A2A2A">@</font><font color="#5D5D5D">@</font><font color="#A5A5A6">@</font><font color="#C5C5C5">@</font><font color="#EFEFEF">@</font><font color="#FFFFFF">@@@</font><font color="#9C4040">@</font><font color="#B69191">@@</font><font color="#9C4040">@</font><font color="#A57272">@</font><font color="#E7D6D6">@</font><font color="#FFFFFF">@</font><font color="#845151">@</font><font color="#7C4A4A">@</font><font color="#5A0000">@</font><font color="#6B4242">@@</font><font color="#520000">@</font><font color="#E5DCDC">@</font><font color="#F7F7F7">@</font><font color="#8D5252">@</font><font color="#AB9494">@</font><font color="#FFFFFF">@</font><font color="#AF8484">@</font><font color="#744141">@@</font><font color="#DDCFCF">@</font><font color="#FFFFFF">@</font><font color="#C0A5A5">@</font><font color="#5A0000">@</font><font color="#DDCFCF">@</font><font color="#FFFFFF">@</font><font color="#B69191">@</font><font color="#744141">@</font><font color="#835A5A">@</font><font color="#FFFFFF">@</font><font color="#E5DCDC">@</font><font color="#957272">@</font><font color="#DDCFCF">@</font><font color="#EDE7E7">@</font><font color="#734949">@</font><font color="#D5BEBE">@</font><font color="#FFFFFF">@</font><font color="#6B4242">@</font><font color="#5A0000">@</font><font color="#744141">@</font><font color="#EDE7E7">@</font><font color="#F7EFEF">@</font><font color="#9C7B7B">@</font><font color="#C9B8B8">@</font><font color="#F7EFEF">@</font><font color="#8C6D6D">@</font><font color="#7B5353">@</font><font color="#FFFFFF">@</font><font color="#E5DCDC">@</font><font color="#8C6D6D">@</font><font color="#DDCFCF">@</font><font color="#FFFFFF">@</font><font color="#AB9494">@</font><font color="#420000">@</font><font color="#523131">@@</font><font color="#4A0000">@</font><font color="#5C3A3A">@</font><font color="#643A3A">@<br>
</font><font color="#920F0F">@</font><font color="#996666">@</font><font color="#845151">@</font><font color="#620707">@</font><font color="#734949">@</font><font color="#845151">@</font><font color="#FFFFFF">@@@@@@@@@@@@@@@@@@</font><font color="#F7F7F7">@</font><font color="#E6E6E6">@</font><font color="#FFFFFF">@</font><font color="#CCCCCC">@</font><font color="#080808">@</font><font color="#2A2A2A">@</font><font color="#999999">@</font><font color="#B5B5B6">@@@</font><font color="#AEAEAE">@@</font><font color="#C5C5C5">@</font><font color="#DDDDDD">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@@@</font><font color="#9C4040">@</font><font color="#B69191">@@</font><font color="#9C4040">@</font><font color="#A46969">@</font><font color="#E0D3D3">@</font><font color="#FFFFFF">@</font><font color="#824B4B">@</font><font color="#7C4A4A">@</font><font color="#5A0000">@</font><font color="#643A3A">@@</font><font color="#520000">@</font><font color="#734949">@</font><font color="#D1C3C3">@</font><font color="#FFFFFF">@</font><font color="#F7F7F7">@</font><font color="#BFACAC">@</font><font color="#520000">@</font><font color="#6B4242">@@</font><font color="#9D7272">@</font><font color="#FFFFFF">@</font><font color="#856363">@</font><font color="#5A0000">@</font><font color="#AB9494">@</font><font color="#FFFFFF">@</font><font color="#703838">@</font><font color="#6B4242">@@</font><font color="#8D5252">@</font><font color="#EDE7E7">@</font><font color="#FFFFFF">@</font><font color="#EFDFDF">@</font><font color="#9E8585">@</font><font color="#643A3A">@</font><font color="#D5BEBE">@</font><font color="#FFFFFF">@</font><font color="#643A3A">@</font><font color="#520000">@</font><font color="#6B4242">@</font><font color="#856363">@</font><font color="#D5BEBE">@</font><font color="#FFFFFF">@</font><font color="#F7F7F7">@</font><font color="#B69191">@</font><font color="#643A3A">@@</font><font color="#8F6363">@</font><font color="#F7EFEF">@</font><font color="#FFFFFF">@</font><font color="#B69191">@</font><font color="#FFFFFF">@</font><font color="#AB9494">@</font><font color="#420000">@</font><font color="#4D2F2F">@@</font><font color="#420000">@</font><font color="#5C3A3A">@</font><font color="#643A3A">@<br>
</font><font color="#8B0909">@</font><font color="#7B0909">@</font><font color="#6B0707">@</font><font color="#620707">@@@</font><font color="#FFFFFF">@@@@@@@@@@@@@@@@@@@@</font><font color="#DDDDDD">@</font><font color="#222223">@</font><font color="#424242">@</font><font color="#BDBDBE">@@</font><font color="#C5C5C5">@</font><font color="#DDDDDD">@</font><font color="#EFEFEF">@@</font><font color="#E6E6E6">@@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@@@@</font><font color="#934141">@</font><font color="#A55252">@@</font><font color="#934141">@</font><font color="#8C2020">@</font><font color="#730000">@</font><font color="#660000">@@@</font><font color="#5A0000">@</font><font color="#520000">@@@@</font><font color="#5A0000">@@@</font><font color="#520000">@@@@@@@@@@@@@@@@@</font><font color="#4A0000">@@@@@</font><font color="#520000">@@@@@@</font><font color="#4A0000">@@@@@@@</font><font color="#420000">@@@@@@</font><font color="#4A0000">@@<br>
</font><font color="#8B0909">@</font><font color="#945A5A">@</font><font color="#845151">@</font><font color="#5B0707">@</font><font color="#734949">@</font><font color="#845151">@</font><font color="#FFFFFF">@@@@@@@@@@@@@@@@@@@@</font><font color="#B0B0B1">@</font><font color="#848484">@</font><font color="#D6D6D6">@</font><font color="#C5C5C5">@@</font><font color="#E6E6E6">@</font><font color="#F7F7F7">@</font><font color="#FFFFFF">@@@@@@@@@</font><font color="#934141">@</font><font color="#B69191">@@</font><font color="#934141">@</font><font color="#996666">@</font><font color="#8D5252">@</font><font color="#660000">@</font><font color="#7C4A4A">@@</font><font color="#5A0000">@</font><font color="#6B4242">@@</font><font color="#5A0000">@</font><font color="#734949">@@</font><font color="#5A0000">@</font><font color="#744141">@@</font><font color="#520000">@</font><font color="#634242">@@</font><font color="#520000">@</font><font color="#634242">@@</font><font color="#520000">@</font><font color="#643A3A">@@</font><font color="#4A0000">@</font><font color="#643A3A">@@</font><font color="#4A0000">@</font><font color="#643A3A">@@</font><font color="#4A0000">@</font><font color="#643A3A">@@</font><font color="#4A0000">@</font><font color="#643A3A">@@</font><font color="#520000">@</font><font color="#643A3A">@@</font><font color="#520000">@</font><font color="#6B4242">@@</font><font color="#4A0000">@</font><font color="#643A3A">@@</font><font color="#4A0000">@</font><font color="#5C3A3A">@@</font><font color="#420000">@</font><font color="#523131">@@</font><font color="#3A0000">@</font><font color="#4D2F2F">@@</font><font color="#420000">@</font><font color="#5C3A3A">@@<br>
</font><font color="#840909">@</font><font color="#945A5A">@</font><font color="#845151">@</font><font color="#5A0000">@</font><font color="#734949">@</font><font color="#824B4B">@</font><font color="#FFFFFF">@@@@@@@@@@@@@@@@@@@@</font><font color="#F7F7F7">@</font><font color="#EFEFEF">@</font><font color="#E6E6E6">@</font><font color="#DDDDDD">@</font><font color="#EDE7E7">@</font><font color="#FFFFFF">@@@@@@@@@@@</font><font color="#954A4A">@</font><font color="#B69191">@@</font><font color="#934141">@</font><font color="#996666">@</font><font color="#845151">@</font><font color="#660000">@</font><font color="#7C4A4A">@@</font><font color="#520000">@</font><font color="#6B4242">@@</font><font color="#5A0000">@</font><font color="#734949">@@</font><font color="#5A0000">@</font><font color="#734949">@</font><font color="#6B4242">@</font><font color="#520000">@</font><font color="#6B4242">@@</font><font color="#520000">@</font><font color="#6B4242">@@</font><font color="#520000">@</font><font color="#634242">@@</font><font color="#4A0000">@</font><font color="#643A3A">@@</font><font color="#4A0000">@</font><font color="#634242">@@</font><font color="#520000">@</font><font color="#643A3A">@@</font><font color="#4A0000">@</font><font color="#643A3A">@@</font><font color="#520000">@</font><font color="#634242">@@</font><font color="#520000">@</font><font color="#6B4242">@@</font><font color="#520000">@</font><font color="#643A3A">@@</font><font color="#4A0000">@</font><font color="#5C3A3A">@@</font><font color="#420000">@</font><font color="#523131">@@</font><font color="#3A0000">@</font><font color="#523131">@@</font><font color="#420000">@</font><font color="#5C3A3A">@</font><font color="#643A3A">@<br>
</font><font color="#7B0909">@</font><font color="#730000">@</font><font color="#660000">@</font><font color="#5A0000">@@@</font><font color="#FFFFFF">@@@@@@@@@@@@@@@@@@@@@</font><font color="#F7F7F7">@</font><font color="#EFEFEF">@@</font><font color="#FFFFFF">@@@@@@@@@@@@</font><font color="#945353">@</font><font color="#A46969">@</font><font color="#A46363">@</font><font color="#8A4040">@</font><font color="#7B2020">@</font><font color="#660000">@@</font><font color="#5A0000">@@@@@@@@@@</font><font color="#520000">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#4A0000">@@@@@@</font><font color="#420000">@@@@@@@</font><font color="#4A0000">@<br>
</font><font color="#7B0000">@</font><font color="#945A5A">@</font><font color="#835A5A">@</font><font color="#5A0000">@</font><font color="#7C4A4A">@</font><font color="#845151">@</font><font color="#FFFFFF">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#A46969">@</font><font color="#C0A5A5">@</font><font color="#B69191">@</font><font color="#8A4040">@</font><font color="#8F6363">@</font><font color="#845151">@</font><font color="#5A0000">@</font><font color="#7C4A4A">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#5A0000">@</font><font color="#7C4A4A">@@</font><font color="#5A0000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#6B4242">@@</font><font color="#520000">@</font><font color="#6B4242">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#6B4242">@@</font><font color="#4A0000">@</font><font color="#634242">@@</font><font color="#4A0000">@</font><font color="#5C3A3A">@@</font><font color="#420000">@</font><font color="#5C3A3A">@@</font><font color="#420000">@</font><font color="#5E4040">@@<br>
</font><font color="#730000">@</font><font color="#8F6363">@</font><font color="#8C5A5A">@</font><font color="#660000">@</font><font color="#835A5A">@@</font><font color="#731010">@</font><font color="#9D7272">@</font><font color="#A57A7A">@</font><font color="#8A4040">@</font><font color="#A48484">@@</font><font color="#844141">@</font><font color="#9C7B7B">@@</font><font color="#844141">@</font><font color="#9C7B7B">@@</font><font color="#844141">@</font><font color="#9C7B7B">@@</font><font color="#844141">@</font><font color="#9C7B7B">@@</font><font color="#844141">@</font><font color="#9C7B7B">@@</font><font color="#844141">@</font><font color="#9C7B7B">@@</font><font color="#844141">@</font><font color="#9C7B7B">@@</font><font color="#844141">@</font><font color="#9C7B7B">@@</font><font color="#844141">@</font><font color="#9C7B7B">@@</font><font color="#8C4A4A">@</font><font color="#A68E8E">@</font><font color="#B49E9E">@</font><font color="#AF8484">@</font><font color="#C0A5A5">@</font><font color="#AB9494">@</font><font color="#7E3939">@</font><font color="#835A5A">@</font><font color="#7C4A4A">@</font><font color="#5A0000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#5A0000">@</font><font color="#7C4A4A">@@</font><font color="#5A0000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#734949">@@</font><font color="#520000">@</font><font color="#6B4242">@@</font><font color="#4A0000">@</font><font color="#6B4242">@@</font><font color="#4A0000">@</font><font color="#643A3A">@@</font><font color="#420000">@</font><font color="#5C3A3A">@@</font><font color="#420000">@</font><font color="#5E4040">@@<br>
</font><font color="#730000">@</font><font color="#660000">@@@@</font><font color="#6C1111">@</font><font color="#7B2020">@</font><font color="#843434">@</font><font color="#8C4A4A">@</font><font color="#8D5252">@@@@</font><font color="#8C5A5A">@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#996666">@</font><font color="#A57A7A">@</font><font color="#AF8484">@</font><font color="#A57A7A">@</font><font color="#8D5252">@</font><font color="#762727">@</font><font color="#5B0707">@</font><font color="#520000">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#4A0000">@@@@@@@@</font><font color="#420000">@@@@@@<br>
</font><font color="#660000">@</font><font color="#8F6363">@@</font><font color="#660000">@</font><font color="#8C5A5A">@</font><font color="#8F6363">@</font><font color="#762727">@</font><font color="#9C7B7B">@</font><font color="#A48484">@</font><font color="#8D5252">@</font><font color="#A68E8E">@@</font><font color="#8C5A5A">@</font><font color="#A48484">@@</font><font color="#8C5A5A">@</font><font color="#9E8585">@@</font><font color="#8C5A5A">@</font><font color="#9E8585">@@</font><font color="#8C5A5A">@</font><font color="#9E8585">@@</font><font color="#8C5A5A">@</font><font color="#9E8585">@@</font><font color="#8C5A5A">@</font><font color="#9E8585">@@</font><font color="#8C5A5A">@</font><font color="#9E8585">@@</font><font color="#8C5A5A">@</font><font color="#9E8585">@@</font><font color="#8C5A5A">@</font><font color="#9E8585">@@</font><font color="#8C5A5A">@</font><font color="#A68E8E">@</font><font color="#AB9494">@</font><font color="#996666">@</font><font color="#9E8585">@</font><font color="#8C6D6D">@</font><font color="#611717">@</font><font color="#734949">@@</font><font color="#4A0000">@</font><font color="#734949">@@</font><font color="#4A0000">@</font><font color="#6B4A4A">@@</font><font color="#4A0000">@</font><font color="#734949">@@</font><font color="#4A0000">@</font><font color="#734949">@@</font><font color="#4A0000">@</font><font color="#6B4A4A">@@</font><font color="#4A0000">@</font><font color="#6B4A4A">@@</font><font color="#4A0000">@</font><font color="#6B4A4A">@@</font><font color="#4A0000">@</font><font color="#6B4A4A">@@</font><font color="#4A0000">@</font><font color="#6B4A4A">@@</font><font color="#4A0000">@</font><font color="#6B4A4A">@@</font><font color="#4A0000">@</font><font color="#6B4A4A">@@</font><font color="#4A0000">@</font><font color="#6B4A4A">@@</font><font color="#4A0000">@</font><font color="#6B4A4A">@@</font><font color="#4A0000">@</font><font color="#6B4A4A">@@</font><font color="#4A0000">@</font><font color="#6B4242">@@</font><font color="#4A0000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#5E4040">@@</font><font color="#420000">@</font><font color="#634242">@@<br>
</font><font color="#660000">@</font><font color="#8C5A5A">@@</font><font color="#5A0000">@</font><font color="#8C5A5A">@</font><font color="#8F6363">@</font><font color="#622020">@</font><font color="#957272">@@</font><font color="#7B4242">@</font><font color="#967979">@@</font><font color="#7B4242">@</font><font color="#967979">@@</font><font color="#7B4242">@</font><font color="#957272">@@</font><font color="#744141">@</font><font color="#957272">@@</font><font color="#744141">@</font><font color="#957272">@@</font><font color="#744141">@</font><font color="#957272">@@</font><font color="#744141">@</font><font color="#957272">@@</font><font color="#744141">@</font><font color="#957272">@@</font><font color="#744141">@</font><font color="#957272">@@</font><font color="#744141">@</font><font color="#957272">@@</font><font color="#7B4242">@</font><font color="#967979">@@</font><font color="#703838">@</font><font color="#856363">@</font><font color="#7B5353">@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#664747">@@</font><font color="#4A0000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#5E4040">@@</font><font color="#420000">@</font><font color="#634242">@@<br>
</font><font color="#5A0000">@@@@@</font><font color="#5B0707">@</font><font color="#670C10">@</font><font color="#611717">@</font><font color="#622020">@@@@</font><font color="#5C2020">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@</font><font color="#540A0A">@</font><font color="#4B0A0A">@</font><font color="#4A0000">@</font><font color="#420000">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@<br>
</font><font color="#5A0000">@</font><font color="#835A5A">@@</font><font color="#520000">@</font><font color="#7B5353">@@</font><font color="#520000">@</font><font color="#735050">@@</font><font color="#4A0000">@</font><font color="#6B4A4A">@@</font><font color="#420000">@</font><font color="#664747">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#5E4040">@@</font><font color="#3A0000">@</font><font color="#5E4040">@@</font><font color="#420000">@</font><font color="#634242">@@<br>
</font><font color="#520000">@</font><font color="#835A5A">@@</font><font color="#520000">@</font><font color="#7B5353">@@</font><font color="#4A0000">@</font><font color="#735050">@</font><font color="#6B4A4A">@</font><font color="#420000">@</font><font color="#664747">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#420000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#5E4040">@@</font><font color="#3A0000">@</font><font color="#5E4040">@@</font><font color="#3A0000">@</font><font color="#5E4040">@@</font><font color="#3A0000">@</font><font color="#5E4040">@@</font><font color="#420000">@</font><font color="#634242">@</font><font color="#664747">@<br>
</font><font color="#520000">@@@</font><font color="#4A0000">@@@@</font><font color="#420000">@@@@@@</font><font color="#3A0000">@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@<br>
</font><font color="#4A0000">@</font><font color="#7B5353">@@</font><font color="#4A0000">@</font><font color="#735050">@@</font><font color="#420000">@</font><font color="#6B4A4A">@@</font><font color="#420000">@</font><font color="#664747">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#5E4040">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#634242">@@</font><font color="#3A0000">@</font><font color="#664747">@@<br>
</font>
</span>
<BR>
<?php
}

// begin http://www.zend.com/manual/features.error-handling.php

function errorchk() {
	error_reporting(0);

	$old_error_handler = set_error_handler("userErrorHandler");

/*	$t = I_AM_NOT_DEFINED;

	$a = array(2,3,"foo");
	$b = array(5.5, 4.3, -1.6);
	$c = array (1,-3);

	$t1 = distance($c,$b)."\n";
	$t2 = distance($b,"i am not an array")."\n";
	$t3 = distance($a,$b)."\n";
*/
}

function userErrorHandler ($errno, $errmsg, $filename, $linenum, $vars) {
    $dt = date("Y-m-d H:i:s (T)");

    $errortype = array (
                1   =>  "Error",
                2   =>  "Warning",
                4   =>  "Parsing Error",
                8   =>  "Notice",
                16  =>  "Core Error",
                32  =>  "Core Warning",
                64  =>  "Compile Error",
       	        128 =>  "Compile Warning",
               	256 =>  "User Error",
                512 =>  "User Warning",
       	        1024=>  "User Notice"
               	);
    $user_errors = array(E_USER_ERROR, E_USER_WARNING, E_USER_NOTICE);
   
    $err = "<errorentry>\n";
    $err .= "\t<datetime>".$dt."</datetime>\n";
    $err .= "\t<errornum>".$errno."</errornum>\n";
    $err .= "\t<errortype>".$errortype[$errno]."</errortype>\n";
    $err .= "\t<errormsg>".$errmsg."</errormsg>\n";
    $err .= "\t<scriptname>".$filename."</scriptname>\n";
    $err .= "\t<scriptlinenum>".$linenum."</scriptlinenum>\n";

    if (in_array($errno, $user_errors))
        $err .= "\t<vartrace>".wddx_serialize_value($vars,"Variables")."</vartrace>\n";
    $err .= "</errorentry>\n\n";
    
    echo "<B><U>NCNOTICE: ".$err."</U></B><BR><BR>";

    //// error_log($err, 3, "/usr/local/php4/error.log");
    if ($errno == E_USER_ERROR)
	echo "Critical User Error: ".$err;
        //// mail("phpdev@example.com","Critical User Error",$err);
}

/*function distance ($vect1, $vect2) {
    if (!is_array($vect1) || !is_array($vect2)) {
        trigger_error("Incorrect parameters, arrays expected", E_USER_ERROR);
        return NULL;
    }

    if (count($vect1) != count($vect2)) {
        trigger_error("Vectors need to be of the same size", E_USER_ERROR);
        return NULL;
    }
    for ($i=0; $i<count($vect1); $i++) {
        $c1 = $vect1[$i]; $c2 = $vect2[$i];
        $d = 0.0;
        if (!is_numeric($c1)) {
            trigger_error("Coordinate $i in vector 1 is not a number, using zero", 
                            E_USER_WARNING);
            $c1 = 0.0;
        }
        if (!is_numeric($c2)) {
            trigger_error("Coordinate $i in vector 2 is not a number, using zero", 
                            E_USER_WARNING);
            $c2 = 0.0;
        }
        $d += $c2*$c2 - $c1*$c1;
    }
    return sqrt($d);
}*/
// end http://www.zend.com/manual/features.error-handling.php

function gfx($random_num) {
    global $prefix;
    require("config.php");
    $datekey = date("F j");
    $rcode = hexdec(md5($_SERVER[HTTP_USER_AGENT] . $sitekey . $random_num . $datekey));
    $code = substr($rcode, 2, 10);
    $image = ImageCreateFromJPEG("images/admin/code_bg.jpg");
    $text_color = ImageColorAllocate($image, 80, 80, 80);
    Header("Content-type: image/jpeg");
    ImageString ($image, 5, 12, 2, $code, $text_color);
    ImageJPEG($image, '', 75);
    ImageDestroy($image);
    die();
}

function gfx2($random_num) {
    global $prefix;
    require("config.php");
    $datekey = date("F j");
    $rcode = hexdec(md5($_SERVER[HTTP_USER_AGENT] . $sitekey . $random_num . $datekey));
    $code = substr($rcode, 2, 10);
    $image = ImageCreateFromJPEG("modules/Your_Account/images/code_bg.jpg");
    $text_color = ImageColorAllocate($image, 80, 80, 80);
    Header("Content-type: image/jpeg");
    ImageString ($image, 5, 12, 2, $code, $text_color);
    ImageJPEG($image, '', 75);
    ImageDestroy($image);
    die();
}

function gfximg() {
	global $NCsitename, $appname;
	define("_SECURITYCODE","Security Code");

	mt_srand ((double)microtime()*1000000);
	$maxran = 1000000;
	$random_num = mt_rand(0, $maxran);

	$adminbg = "images/admin/code_bg.jpg";
	$yabg = "modules/Your_Account/images/code_bg.jpg";

	if (file_exists($adminbg)) { 
		echo "&middot; Admin Security Image Found: $adminbg &middot;<BR>";
		$admintoken = 1;
	} else {
		echo "&middot; Admin Security Image <b>Not</b> Found: $adminbg &middot;<BR>";
	}

	echo "<br>";

        if (file_exists($yabg)) {
                echo "&middot; Your_Account Security Image Found: $yabg &middot;<BR>";
		$yatoken = 1;
        } else {
		echo "&middot; Your_Account Security Image <B>Not</b> Found: $yabg &middot;<BR>";
	}

	echo "<BR>";

	if (extension_loaded("gd") && $admintoken) {
		echo "<B>Security Code Graphic for $NCsitename</B>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
		. "<TR bgcolor=#FFCC66><TD>Security Code Image with Random Number</TD></TR>"
		. "<tr bgcolor=#FFFF99><td>"
		. "<center><img src='$appname?zx=gfx&random_num=$random_num' border='1' alt='"._SECURITYCODE."' title='"._SECURITYCODE."'>"
                . "</center></td></tr>"
                . "</table><BR>";
	} elseif (extension_loaded("gd") && $yatoken) {
                echo "<B>Security Code Graphic for $NCsitename</B>"
                . "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
                . "<TR bgcolor=#FFCC66><TD>Security Code Image with Random Number</TD></TR>"
                . "<tr bgcolor=#FFFF99><td>"
                . "<center><img src='$appname?zx=gfx2&random_num=$random_num' border='1' alt='"._SECURITYCODE."' title='"._SECURITYCODE."'>"
                . "</center></td></tr>"
                . "</table><BR>";
	} elseif (extension_loaded("gd")) {
		?>
                <B>GD & Security Image Data</B>
                <TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">
                <TR bgcolor=#FFCC66><TD>Status</TD></TR>
                <TR bgcolor=#FFFF99>
                <TD>GD Loaded but security images are not present.</TD>
                </TR>
                </TABLE><BR>
                <?php
	} else {
                ?>
                <B>GD Library Information</B>
                <TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">
                <TR bgcolor=#FFCC66><TD>Extension Status</TD></TR>
                <TR bgcolor=#FFFF99>
                <TD>Not-Loaded</TD>
                </TR>
                </TABLE><BR>
                <?php
	}
}

function phploc() {
	global $NCsitename, $SERVER_NAME;
	
	if ($SERVER_NAME != "www.nukecops.com" && $SERVER_NAME != "beta.nukecops.com" && $SERVER_NAME != "www.computercops.biz") {
		echo "<B>php.ini location for $NCsitename</B>"
        	. "<TABLE cellspacing=\"1\" cellpadding=\"3\" cellspacing=\"2\" border=\"1\">"
	        . "<TR bgcolor=#FFCC66><TD>php.ini location</TD></TR>"
        	. "<tr bgcolor=#FFFF99><td>"
        	. get_cfg_var("cfg_file_path")
	        . "</td></tr>"
	        . "</table><BR>";
	}
}

## GZIP Disable Function

function disablegzip() {

global $prefix, $dbtype, $dbname, $dbuname, $dbpass, $dbhost, $dbi;

if ($_SERVER['SERVER_NAME'] != "www.nukecops.com" && $_SERVER['SERVER_NAME'] != "beta.nukecops.com" && $_SERVER['SERVER_NAME'] != "www.computercops.biz") {
	$sql = "update ".$prefix."_bbconfig set config_value='0' where config_name='gzip_compress'";
        $result = mysql_query($sql);
	if ($result) {
		echo "GZIP Compression Setting has been disabled in Nuke Cops bbtonuke port<BR><BR>";
	} else {
	        $sql2 = "update ".$prefix."_config set config_value='0' where config_name='gzip_compress'";
		$result2 = mysql_query($sql2);
		if ($result2) {
			echo "GZIP Compression Setting has been disabled<BR><BR>";
		} else {
			echo "ERROR: Unable to disable GZIP compression<BR><BR>";
		}
	}
} else { echo "Function Disabled for Nuke Cops/Computer Cops Servers<BR><BR>"; }

}

## SMTP Test block start by disgruntledtech

function testmailstart() {
	if(!$to) { 
		echo "<b>Test Your SMTP Server</b>"; 
		echo "<form action=\"".$_SERVER['PHP_SELF']."?zx=testmail\" method=\"post\">"; 
		echo "Send To: <input type\"text\" name=\"to\"><input type=\"submit\" value=\"Send!\">"; 
		echo "</form>"; 
		echo "Notice: leaving this script online may bring unwanted intruders using it for SPAM.  Use at your own risk.<BR><BR>";
	} 
}

function family() {

?> <BR>
Visit the family of Team Cops websites:<BR><BR>
<li><a href="http://beta.nukecops.com">beta.nukecops.com</a>: Live PHP-Nuke Development Site
<li><a href="http://bugs.nukecops.com">bugs.nukecops.com</a>: PHP-Nuke Bug Reporting and Tracking
<li><a href="http://computercops.biz">computercops.biz</a>: Computer Security Portal
<li><a href="http://cvs.nukecops.com">cvs.nukecops.com</a>: PHP-Nuke delivered CVS Style
<li><a href="http://www.nukecops.com">www.nukecops.com</a>: Nuke Cops Home Site, Official PHP-Nuke Developers
<li><a href="http://phpnuke.nukecops.com">phpnuke.nukecops.com</a>: Official Archived PHPNuke.org Forums
<li><a href="http://snaps.nukecops.com">snaps.nukecops.com</a>: Daily Snapshots of beta.nukecops.com
<li><a href="http://teamcops.com">teamcops.com</a>: Central Staff Location
<li><a href="http://zhen-xjell.com">zhen-xjell.com</a>: Personal Blog
<BR><BR>
<?php
}

function testmail($to){ 
	if ($_SERVER['SERVER_NAME'] != "www.nukecops.com" && $_SERVER['SERVER_NAME'] && $_SERVER['SERVER_NAME'] != "www.computercops.biz") {
		$message = "This is a test Message Sent from ".$_SERVER['SERVER_NAME']." initiated by a user at ".$_SERVER['REMOTE_ADDR']
			. ". \n\n"
			. "Notice: leaving this script running on your server may expose it to unwanted intruders sending SPAM"
			. ", use at your own risk!\n\n"
			. "The Nuke Cops Analyzer tool is available from http://www.nukecops.com, the premiere and official member"
			. " of the PHP-Nuke development team.  And our most excellent support and system hardening team is "
			. "available in the forums to help you any time.  They are known as the \"Elite Nukers\". "
			. " This tester was developed by our Elite Nuker: disgruntledtech.";
		mail($to, "Nuke Cops SMTP Test Script", $message, 
		     "From: Nuke Cops SMTP Tester\r\n" 
		    ."X-Mailer: PHP/" . phpversion()); 
		echo "<b>Sent mail to: <u>".$to;
		echo "</u></b><BR><BR>";
	}
} 

## SMTP Test block end by disgruntledtech

switch($zx) {
	case "testmailstart":
		shorttop();
		testmailstart();
		shortend();
		break;

	case "gzipfalse":
		shorttop();
		disablegzip();
		shortend();
		break;

	case "testmail":
		shorttop();
		testmail($_POST[to]);
		shortend();
		break;

        case "ls":
		global $appname;
		head();
		ncimg();
		echo "Click <a href=\"$appname\">here</a> for Analyzer home.<BR><BR>";
                DirectoryListing();
		echo "<BR>Click <a href=\"$appname\">here</a> for Analyzer home.<BR><BR>";
		foot();
                break;
	case "logo":
		if (extension_loaded("gd")) { analyzerImage(); } else { foot(); }
		break;

	case "gfx":
        	gfx($random_num);
	        break;

        case "gfx2":
                gfx2($random_num);
                break;

	case "configconn":
                shorttop();
		configconn();
                shortend();
                break;

	case "secchk":
                shorttop();
		secchk();
                shortend();
                break;

	case "gdchk":
                shorttop();
		gdchk();
                shortend();
                break;

	case "bulk":
                shorttop();
		bulk();
                shortend();
                break;

	case "listdbs":
                shorttop();
		listdbs();
                shortend();
                break;

	case "modchk":
                shorttop();
		modchk();
                shortend();
                break;

	case "blkchk":
                shorttop();
		blkchk();
                shortend();
                break;

	case "ranks":
                shorttop();
		ranks();
                shortend();
                break;

	case "admins":
                shorttop();
		admins();
                shortend();
                break;

	case "mods":
                shorttop();
		mods();
                shortend();
                break;

	case "phpini":
		shorttop();
		phpini();
                shortend();
                break;

	case "gfximg":
		shorttop();
		gfximg();
		shortend();
                break;

	case "family":
		shorttop();
		family();
		shortend();
		break;
	
	case "tables":
		shorttop();
		tables();
		shortend();
		break;

	case "errchk":
		errorchk();
		all();
		break;
	
	case "power":
		shorttop();
		enimg();
		shortend();
		break;

	case "phploc":
		shorttop();
		phploc();
		shortend();
		break;

	default:
		all();
		break;
}

function shorttop() {
                head();
                ncimg();
                main();
                menu();
                verchk();
}

function shortend() {
                foot();
}

function all(){
                head();
                ncimg();
                main();
		menu();
		verchk();
		secchk();
                configconn();
                gdchk();
                bulk();
                listdbs();
                modchk();
                blkchk();
                ranks();
                admins();
                mods();
		tables();
		phploc();
                phpini();
                gfximg();
                foot();
}

function menu() {
	global $appname;
	echo "<FORM METHOD=GET ACTION=\"$appname\">";
        echo "<SELECT NAME=\"zx\" SIZE=\"7\" onChange=\"top.location.href=this.options[this.selectedIndex].value\">";
        echo "<OPTION VALUE=\"$appname\">>> All Sections [Default] <<";
        echo "<OPTION VALUE=\"$appname?zx=configconn\">Config.php";
	echo "<OPTION VALUE=\"$appname?zx=testmailstart\">SMTP Tester";
        echo "<OPTION VALUE=\"$appname?zx=secchk\">System Security Check";
	echo "<OPTION VALUE=\"$appname?zx=gzipfalse\">Disable Forums GZIP";
        echo "<OPTION VALUE=\"$appname?zx=gdchk\">GD Library Check";
        echo "<OPTION VALUE=\"$appname?zx=bulk\">Majority of Analyzer";
        echo "<OPTION VALUE=\"$appname?zx=listdbs\">Show all Databases";
        echo "<OPTION VALUE=\"$appname?zx=modchk\">Show all Modules";
        echo "<OPTION VALUE=\"$appname?zx=blkchk\">Show all Blocks";
	echo "<OPTION VALUE=\"$appname?zx=errchk\">Show any notices [NCNOTICE]";
        echo "<OPTION VALUE=\"$appname?zx=ranks\">Show Ranks";
        echo "<OPTION VALUE=\"$appname?zx=admins\">Show Administrators";
        echo "<OPTION VALUE=\"$appname?zx=mods\">Show Moderators";
        echo "<OPTION VALUE=\"$appname?zx=phpini\">Show php.ini settings";
        echo "<OPTION VALUE=\"$appname?zx=gfximg\">Show security code image";
	echo "<OPTION VALUE=\"$appname?zx=tables\">Show tables";
	echo "<OPTION VALUE=\"$appname?zx=phploc\">Your php.ini location";
	echo "<OPTION VALUE=\"$appname?zx=power\">Powered By...";
        echo "</SELECT></FORM>";
}

function foot() {
	global $appname, $total_time, $start_time;
    	$mtime = microtime();
	$mtime = explode(" ",$mtime);
    	$mtime = $mtime[1] + $mtime[0];
    	$end_time = $mtime;
    	$total_time = ($end_time - $start_time);
    	$total_time = "Page Generation: ".substr($total_time,0,5)." seconds.";
	?>
	Notice: leaving this script online may bring unwanted intruders using it for security attacks at your server. Use at your own risk.
	<BR><BR>
	<p align="center"><a href="http://www.magtrb.com"> </a>  </p>
   <br><br>
	Copyright 2003 <a href="http://nukecops.com"><b>Nuke Cops</b></a>, <a href="http://computercops.biz"><b>Computer Cops</b></a>, Paul Laudanski (AKA <a href="http://zhen-xjell.com"><b>Zhen-Xjell</b></a>). <BR>
	PHP-Nuke/phpBB2 Portal Checker Version 1.89.9-c (<a href="http://nukecops.com/analyze.php">analyze.php</a>). For support visit Nuke Cops. <BR>
	<a href="http://nukecops.com/downloads-file-13-details-Analyzer.html">Download Analyzer</a>
	- <a href="<?php $appname?>?zx=logo">PHP Generated Logo</a>
	- <a href="http://nukecops.com/modules.php?name=Downloads&d_op=ratedownload&lid=13&ttitle=Analyzer">Rate this Resource</a>
	<BR><BR> <?php echo "$total_time"; ?> 
	</SPAN>
	</BODY>
	</HTML>
<?php
}
# $Log: analyze.php,v $
# Revision 1.4  2003/08/15 01:35:29  zx
# Added ability to disable GZIP compression
#
# Revision 1.3  2003/08/01 20:23:04  zx
# CVS Keyword Repair
#
?>
