<?php
/*
+----------------------------------------------------------------------------+
|	e107 website system
|
|	Steve Dunstan 2001-2002
|	http://e107.org
|	jalist@e107.org
|
|	Released under the terms and conditions of the
|	GNU General Public License (http://gnu.org).
|
|	$Source: /cvsroot/e107/e107_0.7/e107_themes/reline/theme.php,v $
|	$Revision: 1.16 $
|	$Date: 2006/04/29 06:00:37 $
|	$Author: sweetas $
|              www.romh.net
*/


// Protect the file from direct access
if (!defined('e107_INIT')) { exit; }


// Get language definition files for this theme
@include_once(e_THEME."corvette/languages/".e_LANGUAGE.".php");
@include_once(e_THEME."corvette/languages/English.php");


// Set theme info
$themename = "";
$themeversion = "1.0";
$themeauthor = "  ";
$themedate = "2007-12-12";
$themeinfo = "     <br />   ";
$xhtmlcompliant = TRUE;	// If set to TRUE will display an XHTML compliant logo in theme manager
$csscompliant = TRUE;	// If set to TRUE will display a CSS compliant logo in theme manager


// Define which icon set to use.
// There are two possible values here 'dark' and 'lite'.
// If your theme has a light background then use 'lite' and vice versa for dark themes.
// Because IE does not yet support Alpha transparency with PNG24 images, all of e10ww7's
// icons have been saved with both a light and dark matte background (to prevent jagged
// edges that you see when no matte is present).
// The IMODE is specifying which of the icon sets to use.
// IE7 will support Alpha transparent PNG's at which point we will create a third set
// of icons (using alpha transparency instead of a matte) and IMODE will gradually be
// filtered out as this new set will work with all background colours.
// Uncomment the line below to define IMODE (remove the // ). Default is 'lite'.

define("IMODE", "dark");


// Theme disclaimer is displayed in your site disclaimer appended to the site disclaimer text.
// Uncomment the line below to set a theme disclaimer (remove the // ).

define("THEME_DISCLAIMER", "<br />Corvette theme by <a href='http://e107.no-ip.org/' rel='external'>Flash</a>");


// Dont render core style sheet link.
// the contents of e107_files/e107.css have been copied to this themes style.css.
// By setting $no_core_css to TRUE below we can prevent the <link> tag
// that would normally be generated in the <head> of the page from being outputted.
// This saves us a call by the browser to a stylesheet that we no longer need.

$no_core_css = TRUE;


// Output into <head> section.
// Anything echoed from within the theme_head() function gets outputted into the <head> of your page.
// Please note that you have other choices for <head> based javascript. You can create a theme.js file
// in your themes folder and a link will automatically be generated to it in the <head> of your page.
// If you have javascript that is independant of the theme rather than use theme.js or the theme_head()
// function below, its advisable to instead create a new file e107_files/user.js, placing your script
// into this, and as with theme.js, a link will automatically be generated to this file.
// Uncomment the following three lines to use.

//function theme_head() {
//	echo "<script></script>";
//}


// Header and footer templates for the body of your site.
// These are the header and footer that wraps the content of a page.
// Note that these are the templates for *inbetween* the <body> and </body> tags.
// The rest of the output (eg. the <head> section of the page) are covered by
// the header and footer template files in e107_themes/templates.
// These are called header_default.php and footer_default.php.
// If you wish to use your own versions of these files uncomment the line below (remove the // )
// and edit it so that the text string represents the postfix of the new set of files.
// eg. using the example text e107 will include these files:
// e107_themes/templates/header_your_version.php and e107_themes/templates/footer_your_version.php
// instead of the default:
// e107_themes/templates/header_default.php and e107_themes/templates/footer_default.php
// Please note however that using non default core header and footer templates is not recommended
// and that the flexibility of these files enables you to add and edit content to them without editing
// the files directly. Documentation for this can be found on e107.org.

// $layout = '_your_version'; // uncomment this line (remove the // ) to use alternative template files.


// Main header
$HEADER = "<table class='container'>
<tr>
<td class='right_logo'>
<img class='logo_right' src='".THEME_ABS."images/e_logo.jpg' alt='' />
</td>

<td class='sitetag'>
{SITETAG}
</td>
</tr>
 <tr>
<td colspan='2'>
{SITELINKS_ALT=no_icons+noclick}
</td>
</tr>
</table>

<table class='container'>
<tr>
<td class='left_section'>

<table class='top_left_menu_container'>
<tr>
<td>
{SETSTYLE=top_left_menu}
{MENU=1}
<img src='".THEME_ABS."images/leftcol_bg_197.gif' alt='' />
</td>
</tr>
<tr><td class='bottom_left_menu_area'>
{SETSTYLE=bottom_left_menu}
{MENU=2}
<img src='".THEME_ABS."images/leftcol_bg_197.gif' alt='' />
</td></tr></table>
</td>
<td class='main_container'>
<table class='top_inner_container'>
<tr>
</tr>
</table>

{SETSTYLE=default}

<table class='bottom_inner_container'>
<tr>
<td class='main_section'>
{WMESSAGE}
";


// Main footer
$FOOTER = "
<br />
<div style='text-align: center'>
{MENU=6}
</div>
<br />
</td>
<td class='right_section'>
{SETSTYLE=right_menu}
{MENU=3}
<img src='".THEME_ABS."images/leftcol_bg_197.gif' alt='' />
{SETSTYLE=post_it}
{MENU=4}
{SETSTYLE=right_menu}
{MENU=5}
<img src='".THEME_ABS."images/leftcol_bg_197.gif' alt='' />
</td>
</tr>
</table>

</td>
</tr>
</table>
<br />
<div class='disclaimer style='width: 950px;'>
{SITEDISCLAIMER}
</div>";

// Custom footer for pages with no right menu area. Uncomment the $CUSTOMPAGES line below the
// footer to activate and use.

$CUSTOMFOOTER['No_Right_Menu_Area'] = "</td>
</tr>
</table>

</td>
</tr>
</table>
<br />
<div class='disclaimer style='width: 950px;'>
{SITEDISCLAIMER}
</div>";


 // Uncomment the below line (remove the // ) and enter in the filenames (or part of) for
 // those pages you wish to use the custom page layout defined above (seperate with spaces).

$CUSTOMPAGES['No_Right_Menu_Area'] = "e107_plugins/ submitnews.php download.php upload.php forum.php forum_post.php forum_viewtopic.php user.php usersettings.php";


// Define attributes associated with site links.

define('PRELINK', ''); // Prefixed to all links as a group
define('POSTLINK', ''); // Postfixed to all links as a group
define('LINKSTART', ''); // Prefixed to each indivdual link
define('LINKEND', ''); // Postfixed to each indivdual link
define('LINKDISPLAY', 1);
define('LINKALIGN', 'left');


// News style

$NEWSSTYLE = "<div class='tablerender'><div class='main_caption'>
{STICKY_ICON}{NEWSTITLE}</div>

<div class='top_section_left' style='width: 100%; text-align: right; padding: 10px'>
{NEWSIMAGE}{NEWSBODY}{EXTENDED}</div>

<table class='news_info_bottom'>
<tr>
<td class='news_info_bottom_left'>
{NEWSICON}
</td>
<div class='news_info_top'>
<img class='news_comments_icon' src='".THEME_ABS."images/comments_16.png' alt='' />&nbsp;
{NEWSCOMMENTS}{TRACKBACK}
</div>
<td class='news_info_bottom_middle'>
".LAN_THEME_5." {NEWSAUTHOR} ".LAN_THEME_6." {NEWSDATE}
</td>

<td class='news_info_bottom_right'>
{EMAILICON}{PRINTICON}{PDFICON}{ADMINOPTIONS}
</td>
</tr>
</table>";


// Define attributes associated with news style.

define('ICONMAIL', 'email_16.png');
define('ICONPRINT', 'print_16.png');
define('ICONSTYLE', 'border: 0px');
define('COMMENTOFFSTRING', LAN_THEME_1);
define('COMMENTLINK', LAN_THEME_2);
define('PRE_EXTENDEDSTRING', '<br /><br />[ ');
define('EXTENDEDSTRING', LAN_THEME_3);
define('POST_EXTENDEDSTRING', ' ]<br />');
define('TRACKBACKSTRING', LAN_THEME_4);
define('TRACKBACKBEFORESTRING', '&nbsp;&nbsp;|&nbsp;&nbsp;');


// Table style

function tablestyle($caption, $text, $mode){
	global $style;

	if ($style == 'top_left_menu')
	{
		echo "<div class='top_left_menu'>";
		if (USER && $mode == 'login')
		{
			echo "";
		}
		echo "<div class='top_left_menu_caption'>".$caption."</div>".$text."</div>";
	}
	else if ($style == 'paperclip')
	{
		echo "<div class='paperclip_container'>
		<table class='paperclip_inner_container'><tr><td class='paperclip'>";
		if ($caption)
		{
			echo "<div class='paperclip_caption'>".$caption."</div>";
		}
		echo $text."</td></tr></table></div>";
	}
	else if ($style == 'post_it')
	{
		echo "<div class='post_it_container'><div class='post_it_back'><div class='post_it_top'><div class='post_it_bottom'>
		<div class='post_it_caption'>".$caption."</div>".$text."</div></div></div></div>";
	}
	else if ($style == 'bottom_left_menu' || $style == 'right_menu')
	{
		echo "<table class='menu_container'><tr><td class='menu_inner_container'>
		<div class='menu_caption'>".$caption."</div>".$text."</td></tr></table>";
	}
	else
	{
		echo "<div class='tablerender'><div class='main_caption'>".$caption."</div>".$text."</div>";
	}

}


// Comment post style
$sc_style['REPLY']['pre'] = "<tr><td class='forumheader'>";
$sc_style['REPLY']['post'] = "";

$sc_style['SUBJECT']['pre'] = "<td class='forumheader'>";
$sc_style['SUBJECT']['post'] = "</td></tr>";

$sc_style['COMMENTEDIT']['pre'] = "<tr><td class='forumheader' colspan='2' style='text-align: right'>";
$sc_style['COMMENTEDIT']['post'] = "</td></tr>";

$sc_style['JOINED']['post'] = "<br />";

$sc_style['LOCATION']['post'] = "<br />";

$sc_style['RATING']['post'] = "<br /><br />";

$sc_style['RATING']['post'] = "<br />";

$COMMENTSTYLE = "<div class='spacer' style='text-align:center'><table class='fborder' style='width: 95%'>
<tr>
<td class='fcaption' colspan='2'>".LAN_THEME_5." {USERNAME} ".LAN_THEME_6." {TIMEDATE}
</td>
</tr>
{REPLY}{SUBJECT}
<tr>
<td style='width: 20%; vertical-align: top' class='forumheader3'>
<div style='text-align: center'>
{AVATAR}
</div>
{LEVEL}<span class='smalltext'>{JOINED}{COMMENTS}{LOCATION}{IPADDRESS}</span>
</td>
<td style='width: 80%; vertical-align: top' class='forumheader3'>
{COMMENT}
{RATING}
{SIGNATURE}
</td>
</tr>
{COMMENTEDIT}
</table>
</div>";


// Search shortcode style
$SEARCH_SHORTCODE = "<input class='tbox search' type='text' name='q' size='20' value='' maxlength='50' />
<input type='image' name='s' src='".THEME_ABS."images/search.png'  value='' style='width: 16px; height: 16px; border: 0px; vertical-align: middle'  />";


// Chatbox post style
$CHATBOXSTYLE = "<br />
<div style='text-align: right'>
<b>{USERNAME}</b><br />{TIMEDATE}<br />{MESSAGE}<br />
</div>
";


?>