<?php
if (!defined ('JA_NEWS')){
	define ('JA_NEWS', 1);
	require_once ('ja_news/common.php');

	//Process the buildin css file
	$addcss = intval (trim( $params->get( 'addcss', 1 )));
	$addcsstohead = intval (trim( $params->get( 'addcsstohead', 0 )));
	
	if ($addcss) {
	  global $mosConfig_live_site;
		//Insert link to head (onece)
		$linktag = '<link rel="stylesheet" type="text/css" href="'.$mosConfig_live_site.'/modules/ja_news/ja-news.css" />'."\n";
		if ($addcsstohead) {
			$buffer = ob_get_contents();
			$pos = strpos ($buffer, '</head>');
			$buffer = substr ($buffer, 0, $pos) . "\n$linktag\n". substr($buffer, $pos);
			ob_clean();
			echo $buffer;
		}else{
			echo $linktag;
		}
	}
}
?>

<?php
// no direct access
defined( '_VALID_MOS' ) or die( 'Restricted access' );

global $mosConfig_offset, $mosConfig_live_site, $mainframe;
global $_MAMBOTS;
$_MAMBOTS->loadBotGroup( 'content' );

$catid = trim( $params->get( 'catid' ) );
$showheadline = intval (trim( $params->get( 'showheadline', 0 ) ));
$headlinelang = trim( $params->get( 'headlinelang' ) );
$headlineheight = intval( $params->get( 'headlineheight' ) );
$catorsec = trim( $params->get( 'catorsec' ) );
$linksitem 	= intval (trim( $params->get( 'linkitems', 0 ) ));
$maxchars = intval (trim( $params->get( 'maxchars', 200 ) ));
$width = intval (trim( $params->get( 'width', 100 ) ));
$height = intval (trim( $params->get( 'height', 100 ) ));
$showintro = $params->get( 'showintro', 0 );
$showimage = $params->get( 'showimage', 0 );
$showreadmore = $params->get( 'showreadmore', 0 );
$catshowreadmore = $params->get( 'catshowreadmore', 0 );
$cols	= intval (trim( $params->get( 'cols', 2 ) ));
$showcattitle	= $params->get( 'showcattitle' , 0);
$linkmenu	= $params->get( 'linkmenu' , 0);
$linktype	= $params->get( 'linktype' , "");
$numbercontent = $params->get( 'numbercontent' , 1);
$numberofheadlinenews = intval (trim( $params->get( 'numberofheadlinenews', 10 ) ));
$autoroll = ($params->get( 'autoroll', 1 )) ? 1 : 0;
$delaytime = intval (trim( $params->get( 'delaytime', 5 ) ));

$now 		= _CURRENT_SERVER_TIME;
$access 	= !$mainframe->getCfg( 'shownoauth' );
$nullDate 	= $database->getNullDate();

$current_charset = JA_News::getCharset();

$params->set( 'image', 		0 );
$params->set( 'intro_only', 		1 );
$params->set( 'hide_author', 		1 );
$params->set( 'hide_createdate', 	0 );
$params->set( 'hide_modifydate', 	1 );
$params->set( 'link_titles', 		1 );

if ($catid) $catids = split(",", $catid);
else{
	if($catorsec){
		$query = "SELECT id FROM #__categories WHERE published = 1;";
	}
	else{
		$query = "SELECT id FROM #__sections WHERE published = 1;";
	}
	$database->setQuery($query);
	$c = $database->loadObjectList();
	$catids = array();
	foreach($c as $_c) $catids[] = $_c->id;
}

if ($showheadline) {
	$c = JA_News::getTotalNews();
	$numberofheadlinenews = ($numberofheadlinenews < $c) ? $numberofheadlinenews : $c;

	$firstnew = JA_News::getNews(1);

	if ($firstnew) {
    
		$headlineid = $firstnew->id;
		echo "<div class=\"ja-newshlwrap\">";
		echo "<div class=\"ja-newsblock clearfix\" style=\"width: 100%;". ($headlineheight ? " height: {$headlineheight}px; overflow: hidden;" : "") ."\">";

		$bs 	= $mainframe->getBlogSectionCount();
		$bc 	= $mainframe->getBlogCategoryCount();
		$gbs 	= $mainframe->getGlobalBlogSectionCount();

		$Itemid = $mainframe->getItemid( $firstnew->id, 0, 0, $bs, $bc, $gbs );
		if ($Itemid == NULL) {
			$Itemid = '';
		} else {
			$Itemid = '&amp;Itemid='. $Itemid;
		}
		$link = sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id='. $firstnew->id . $Itemid );

		echo "<div class=\"ja-newsitem\" style=\"width: 100%;\">\n";

		echo "<div class=\"ja-newsitem-inner\" style=\"width: 100%;\">\n";
		if ($numberofheadlinenews > 1) {
			if (isset($_COOKIE['JAHL-AUTOROLL'])) $autoroll = ($_COOKIE['JAHL-AUTOROLL']) ? 1 : 0;
			setcookie("JAHL-AUTOROLL", $autoroll, 0, "/");
			?>
			<script type="text/javascript">
				var jahl = new Object
				jahl.livesite = '<?php echo $mosConfig_live_site; ?>';
				jahl.autoroll = <?php echo ($autoroll) ? "true" : "false" ?>;
				jahl.delaytime = '<?php echo $delaytime; ?>';
				jahl.total = '<?php echo $numberofheadlinenews; ?>';
				jahl.current = 1;
				jahl.modid = '<?php echo $module->id; ?>';
			</script>
			<?php
			echo "<script type=\"text/javascript\" src=\"$mosConfig_live_site/modules/ja_news/janews.js\"></script>\n";
		}
		
		echo "<div class=\"ja-newscat\"><span id=\"jahl-headlineanchor\">{$headlinelang}</span>";
		if ($numberofheadlinenews > 1) {

			$nexttitle = JA_News::getNextTitle (1, $numberofheadlinenews);
			
			$prevtitle = JA_News::getPrevTitle (1, $numberofheadlinenews);
		
			echo "<div class=\"jahl-newscontrol\">";
			echo "<img id=\"loading-indicator\" style=\"display: none;\" src=\"{$mosConfig_live_site}/modules/ja_news/loading.gif\" alt=\"Loading\" border=\"0\" />\n";
			echo "<ul>";
			echo "<li>".($autoroll ? "<img title=\"Pause\" style=\"cursor: pointer;\" id=\"jahl-switcher\" onclick=\"jahl.switchRoll(); return false;\" src=\"$mosConfig_live_site/modules/ja_news/pause.png\" alt=\"Pause\" border=\"0\" />" : "<img title=\"Play\" style=\"cursor: pointer;\" id=\"jahl-switcher\" onclick=\"jahl.switchRoll(); return false;\" src=\"$mosConfig_live_site/modules/ja_news/play.png\" alt=\"Play\" border=\"0\" />")."</li>\n";
			echo "<li><img title=\"Previous: ".trim(htmlentities($prevtitle, ENT_QUOTES, $current_charset))."\" style=\"cursor: pointer;\" onclick=\"jahl.showNews(((jahl.current==1)?jahl.total : jahl.current - 1), jahl.total, jahl.modid); return false;\" id=\"jahl-prev\" src=\"$mosConfig_live_site/modules/ja_news/prev.png\" alt=\"Previous\" border=\"0\" /></li>\n";
			echo "<li><img title=\"Next: ".trim(htmlentities($nexttitle, ENT_QUOTES, $current_charset))."\" style=\"cursor: pointer;\" onclick=\"jahl.showNews(((jahl.current==jahl.total)?1 : jahl.current + 1), jahl.total, jahl.modid); return false;\" id=\"jahl-next\" src=\"$mosConfig_live_site/modules/ja_news/next.png\" alt=\"Next\" border=\"0\" /></li>\n";
			echo "</ul>";
			echo "<span id=\"jahl-indicator\">1/{$numberofheadlinenews}</span>\n";
			echo "</div>";
		}
		echo  "</div>\n";
		echo "<div id=\"jahl-newsitem\">\n";

		$image = JA_News::replaceImage ($firstnew, 0, 1);
        
        $firstnew->text 	= $firstnew->introtext;
		$_MAMBOTS->trigger( 'onPrepareContent', array( &$firstnew, &$params, 0 ), true );
        $firstnew->introtext = $firstnew->text;
        
		echo "<div class=\"ja-newscontent\">\n";
		echo $image. "\n";
		echo "<a href=\"$link\" class=\"ja-newstitle\" title=\"".trim(htmlentities($firstnew->title, ENT_QUOTES, $current_charset))."\">{$firstnew->title}</a>\n";
		echo "{$firstnew->introtext}\n</div>\n";
		if ($showreadmore) echo "<a href=\"$link\" class=\"readon\">"._READ_MORE."</a>";
		echo "</div>\n</div>\n</div></div></div>\n";
		echo "<span class=\"article_seperator\">&nbsp;</span>";
	}
}

if ($cols > 0) {
	echo "<div class=\"ja-newscatwrap\">";
	$modwidth = round(100 / $cols, 2) ;
	$l = 0;
	$modStyle = JA_News::calModStyle ($cols);
	$isrowopen = false;
	for ($k=0;$k<count($catids);++$k){
		$query = "SELECT a.images, a.introtext, a.id, a.title, a.sectionid, a.catid, cc.title as cattitle, cc.description as catdesc, sc.title as sectitle, sc.description as secdescription"
				. "\n FROM #__content AS a"
				. "\n LEFT JOIN #__content_frontpage AS f ON f.content_id = a.id"
				. "\n INNER JOIN #__categories AS cc ON cc.id = a.catid"
				. "\n INNER JOIN #__sections AS sc ON sc.id = a.sectionid"
				. "\n WHERE ( a.state = 1 AND a.sectionid > 0 "
				. "\n AND ( a.publish_up = '$nullDate' OR a.publish_up <= '$now' )"
				. "\n AND ( a.publish_down = '$nullDate' OR a.publish_down >= '$now' )";
		if($catorsec){
		$query .= ( $access ? "\n AND a.access <= $my->gid AND cc.access <= $my->gid" : '' )
				  . ( $catids ? "\n AND ( a.catid = {$catids[$k]} )" : "" )
				  . ( isset($headlineid) ? "\n AND a.id <> $headlineid" : "" )
				  . "\n AND cc.published = 1 )"
				  . "\n ORDER BY a.created DESC limit " . ($linksitem+1);		
		}
		else{
		$query .= ( $access ? "\n AND a.access <= $my->gid AND sc.access <= $my->gid" : '' )
				  . ( $catids ? "\n AND ( a.sectionid = {$catids[$k]} )" : "" )
				  . ( isset($headlineid) ? "\n AND a.id <> $headlineid" : "" )
				  . "\n AND sc.published = 1 )"
				  . "\n ORDER BY a.created DESC limit " . ($linksitem+1);		
		}		
		$database->setQuery( $query );
		$temp = $database->loadObjectList();

		$rows = array();
		if (count($temp)) {
			foreach ($temp as $row ) {
				$rows[] = $row;
			}
		}
		unset($temp);
		if (count($rows)) {
			$bs 	= $mainframe->getBlogSectionCount();
			$bc 	= $mainframe->getBlogCategoryCount();
			$gbs 	= $mainframe->getGlobalBlogSectionCount();

			// Output
			if ($l == 0){
				//Begin a row
				echo "<div class=\"ja-newsblock clearfix\">\n";
			$isrowopen = true;
			}

			//get Itemid of category
			$Itemid = $mainframe->getItemid( $rows[0]->id, 0, 0, $bs, $bc, $gbs );
			if ($Itemid == NULL) {
				$Itemid = '';
			} else {
				$Itemid = '&amp;Itemid='. $Itemid;
			}
			if($linkmenu){
				$query = "SELECT id,link FROM #__menu WHERE published=1 AND type LIKE 'content_%";	
				$temp = ($catorsec) ? "category" : "section";
				$temp .= "'";
				$temp .= ($catorsec) ? " AND componentid=".$rows[0]->catid : " AND componentid=".$rows[0]->sectionid;
				$query .= $temp;
				$database->setQuery( $query );
				$link = $database->loadObjectList();
				if(count($link)){
					$link = $link[0]->link.'&amp;Itemid='. $link[0]->id;
				}
				else{
					if($linktype){
						if(strpos("section",$linktype) === 0 && $catorsec)	$tasklink = "category";
						else if (strpos("category",$linktype) === 0 && !$catorsec)	$tasklink = "section";
						else $tasklink = $linktype; 		
					}
					else{
						$tasklink =($catorsec) ? "category" : "section"; 
					}
					$idlink = ($catorsec) ? $rows[0]->catid : $rows[0]->sectionid;
					$link = sefRelToAbs('index.php?option=com_content&amp;task='.$tasklink."&amp;id=".$idlink.$Itemid);					
				}
			}
			else{
				$link = sefRelToAbs( 'index.php?option=com_content&amp;task=category&amp;sectionid='.$rows[0]->sectionid.'&amp;id='. $rows[0]->catid . $Itemid );			
			}		

			echo "<div class=\"ja-newsitem{$modStyle[$l]['class']}\" style=\"width: {$modStyle[$l]['width']};\"><div class=\"ja-newsitem-inner\" style=\"width:{$modStyle[$l]['subwidth']};\">\n";
			if($catorsec && $showcattitle){
				echo "<a href=\"$link\" class=\"ja-newscat\" title=\"".trim(htmlentities($rows[0]->catdesc, ENT_QUOTES, $current_charset))."\"><span>{$rows[0]->cattitle}</span></a>\n";
			}
			else if($showcattitle){
				echo "<a href=\"$link\" class=\"ja-newscat\" title=\"".trim(htmlentities($rows[0]->secdescription, ENT_QUOTES, $current_charset))."\"><span>{$rows[0]->sectitle}</span></a>\n";
			}

			$hasul = true;

			for ( $i=0; $i<count($rows); $i++ ) {
				$row = $rows[$i];
				// get Itemid
				$Itemid = $mainframe->getItemid( $row->id, 0, 0, $bs, $bc, $gbs );
				// Blank itemid checker for SEF
				if ($Itemid == NULL) {
					$Itemid = '';
				} else {
					$Itemid = '&amp;Itemid='. $Itemid;
				}


				$link = sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id='. $row->id . $Itemid );

				$row->text 	= $row->introtext;
				$_MAMBOTS->trigger( 'onPrepareContent', array( &$row, &$params, 0 ), true );
		    $row->introtext = $row->text;

				$image = JA_News::replaceImage ($row, $maxchars, $showimage, $width, $height);

				if ($i < $numbercontent){
					//Show the latest news
					echo "<div class=\"ja-newscontent\">\n";
					echo $image. "\n";
					echo "<a href=\"$link\" class=\"ja-newstitle\" title=\"".($showintro ? $row->title : $row->introtext1)."\">{$row->title}</a>\n";
  					if ($showintro){
  						if ($maxchars)
							echo "{$row->introtext1}\n";
						  else
							echo "{$row->introtext}\n";
						if ($catshowreadmore) echo "<a href=\"$link\" class=\"readon\">"._READ_MORE."</a>";
  					}
		            echo "</div>\n";
					if (count ($rows) > 1) echo "<ul class=\"ja-newslinks\">\n"; else $hasul = false;
				}else{
					?>
					<li>
					<a title="<?php echo $row->introtext1; ?>" href="<?php echo $link; ?>">
					<?php echo $row->title; ?></a>
					</li>
					<?php
				}
			}
			if ($hasul) echo "</ul>\n";
			echo "</div></div>\n";
			$l++;
		}
		if ($isrowopen && ($l == $cols || $k == (count ($catids)-1))){
			//End a row
			echo "</div>\n";
			echo "<span class=\"article_seperator\">&nbsp;</span>";
			$l = 0;
			$isrowopen = false;
		}
	}
	echo "</div>";
}
?>
