<?php
/*------------------------------------------------------------------------
# JA News 1.1.3 - June, 2007
# ------------------------------------------------------------------------
# Copyright (C) 2004-2007 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
# @license - Copyrighted Commercial Software
# Author: J.O.O.M Solutions Co., Ltd
# Websites:  http://www.joomlart.com -  http://www.joomlancers.com
-------------------------------------------------------------------------*/
if (!defined ('_VALID_MOS')) {
	
	$splitter = md5("JA Headline");
	require_once ('common.php');
	chdir ('../../');
	
	define( '_VALID_MOS', 1 );
	
	require( 'globals.php' );
	require_once( 'configuration.php' );
	// SSL check - $http_host returns <live site url>:<port number if it is 443>
	$http_host = explode(':', $_SERVER['HTTP_HOST'] );
	if( (!empty( $_SERVER['HTTPS'] ) && strtolower( $_SERVER['HTTPS'] ) != 'off' || isset( $http_host[1] ) && $http_host[1] == 443) && substr( $mosConfig_live_site, 0, 8 ) != 'https://' ) {
		$mosConfig_live_site = 'https://'.substr( $mosConfig_live_site, 7 );
	}
	
	require_once( 'includes/joomla.php' );
	require_once( $mosConfig_absolute_path .'/includes/sef.php' );
	require_once( $mosConfig_absolute_path .'/includes/frontend.php' );
	include_once( $mosConfig_absolute_path .'/language/' . $mosConfig_lang . '.php' );

	header( "Expires: Mon, 26 Jul 1997 05:00:00 GMT" );  // disable IE caching
	header( "Last-Modified: " . gmdate( "D, d M Y H:i:s" ) . " GMT" ); 
	header( "Cache-Control: no-cache, must-revalidate" ); 
	header( "Pragma: no-cache" );
	//header(	"Content-Type: text/plain; charset="._ISO);
	
	// displays offline/maintanance page or bar
	if ($mosConfig_offline == 1) {
		require( $mosConfig_absolute_path .'/offline.php' );
	}
	
	// load system bot group
	$_MAMBOTS->loadBotGroup( 'system' );
	
	// trigger the onStart events
	$_MAMBOTS->trigger( 'onStart' );	
	
	// retrieve some expected url (or form) arguments
	$news 	= intval( mosGetParam( $_REQUEST, 'news' , 1) ) ;
	$total 	= intval( mosGetParam( $_REQUEST, 'total', 0 ) );
	$modid 	= intval( mosGetParam( $_REQUEST, 'modid', 0 ) );
	
	// mainframe is an API workhorse, lots of 'core' interaction routines
	$mainframe = new mosMainFrame( $database, '', '.' );
	$mainframe->initSession();
	
	// trigger the onAfterStart events
	$_MAMBOTS->trigger( 'onAfterStart' );
	
	// get the information about the current user from the sessions table
	$my = $mainframe->getUser();
	
	// loads english language file by default
	if ($mosConfig_lang=='') {
		$mosConfig_lang = 'english';
	}
	
	// detect first visit
	$mainframe->detect();
	
	// precapture the output of the component
	require_once( $mosConfig_absolute_path . '/editor/editor.php' );
	
	ob_start();
	
	$_MOS_OPTION['buffer'] = ob_get_contents();
	
	ob_end_clean();
	

	$current_charset = JA_News::getCharset();
	
	$now 		= _CURRENT_SERVER_TIME;
	$access 	= !$mainframe->getCfg( 'shownoauth' );
	$nullDate 	= $database->getNullDate();
	$my = $mainframe->getUser();
	$gid = intval( $my->gid );
	$db = new database( $mosConfig_host, $mosConfig_user, $mosConfig_password, $mosConfig_db, $mosConfig_dbprefix );
	
	//Get module parameter
	$paramss = "";
	if ($modid) {
		$query = "SELECT params from #__modules where id='".$modid."'";
		$database->setQuery($query);
		$paramss = $database->loadResult();
	}

	$params = new mosParameters ($paramss);
	$params->set( 'image', 		0 );
	$params->set( 'intro_only', 		1 );
	$params->set( 'hide_author', 		1 );
	$params->set( 'hide_createdate', 	0 );
	$params->set( 'hide_modifydate', 	1 );
	$params->set( 'link_titles', 		1 );

}

$firstnew = JA_News::getNews($news);
$iconvenabled = $params->get('iconv');
$Itemid = $mainframe->getItemid( $firstnew->id, 0, 0, 1, 1, 1 );
if ($Itemid == NULL) {
	$Itemid = '';
} else {
	$Itemid = '&amp;Itemid='. $Itemid;
}
$link = sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id='. $firstnew->id . $Itemid );

$image = JA_News::replaceImage ($firstnew, 0, 1);

$_MAMBOTS->loadBotGroup( 'content' );
$firstnew->text 	= $firstnew->introtext;
$_MAMBOTS->trigger( 'onPrepareContent', array( &$firstnew, $params, 0 ), true );
$firstnew->introtext = $firstnew->text;

echo "<div class=\"ja-newscontent\">\n";
echo $image. "\n";

echo "<a href=\"$link\" class=\"ja-newstitle\" title=\"".JA_News::textprocess($firstnew->title, $iconvenabled)."\">".JA_News::textprocess($firstnew->title, $iconvenabled)."</a>\n";
echo JA_News::textprocess($firstnew->introtext, $iconvenabled) . "\n</div>\n";
if ($params->get('showreadmore',0)) echo "<a href=\"$link\" class=\"readon\">".JA_News::textprocess(_READ_MORE, $iconvenabled)."</a>";
echo "</div>";

$nexttitle = JA_News::getNextTitle ($news, $total);

$prevtitle = JA_News::getPrevTitle ($news, $total);

echo $splitter.JA_News::textprocess($nexttitle, $iconvenabled).$splitter.JA_News::textprocess($prevtitle, $iconvenabled);

doGzip();

?>
