<?php
class JA_News {
	function replaceImage( &$row, $maxchars, $showimage, $width = 0, $height = 0 ) {
		global $database, $_MAMBOTS, $current_charset;

		// expression to search for
		$regex = '/{mosimage\s*.*?}/i';

		$image = $showimage?JA_News::processImage ( $row, $width, $height ):"";

		if ($image) {
			$row->introtext = trim($row->introtext);
			$row->introtext = preg_replace( $regex, '', $row->introtext );
		} else {
			$regex = "/\<img.*\/\>/";
			preg_match ($regex, $row->introtext, $matches);
			$row->introtext = trim($row->introtext);
			$row->introtext = preg_replace ($regex, '', $row->introtext);

			$image = $showimage && count($matches)?$matches[0]:"";
			if ($image) {
				if ($width) {
					if (is_numeric ($width)) $width = $width."px";
					$regex = '/(width\s*=\s*\"?)([^\s,^\"]*)/';
					if (preg_match ($regex, $image))
						$image = preg_replace ($regex, '${1}'.$width, $image);
					else {
						$image = substr ($image, 0, -2) . " width=\"$width\" />";
					}
				}
				if ($height) {
					if (is_numeric ($height)) $height = $height."px";
					$regex = '/(height\s*=\s*\"?)([^\s,^\"]*)/';
					if (preg_match ($regex, $image))
						$image = preg_replace ($regex, '${1}'.$height, $image);
					else {
						$image = substr ($image, 0, -2) . " heigh=\"$height\" />";
					}
				}
			}
		}

		$row->introtext1 = strip_tags($row->introtext);
		if ($maxchars && strlen ($row->introtext) > $maxchars) {
			$row->introtext1 = substr ($row->introtext1, 0, $maxchars) . "...";
		}
		// clean up globals
		return $image;
	}

	function processImage ( &$row, $width, $height ) {
		global $mosConfig_absolute_path, $mosConfig_live_site;

		// split on \n the images fields into an array
		$row->images 	= explode( "\n", $row->images );
		$img = trim( $row->images[0] );

		// split on pipe the attributes of the image
		if ( $img ) {
			$attrib = explode( '|', trim( $img ) );
			// $attrib[0] image name and path from /images/stories

			// $attrib[1] alignment
			if ( !isset($attrib[1]) || !$attrib[1] ) {
				$attrib[1] = '';
			}

			// $attrib[2] alt & title
			if ( !isset($attrib[2]) || !$attrib[2] ) {
				$attrib[2] = 'Image';
			} else {
				$attrib[2] = htmlspecialchars( $attrib[2] );
			}

			// $attrib[3] border
			if ( !isset($attrib[3]) || !$attrib[3] ) {
				$attrib[3] = 0;
			}

			$attrib[4]	= '';
			$border 	= 0;

			// $attrib[5] caption position
			if ( !isset($attrib[5]) || !$attrib[5] ) {
				$attrib[5] = '';
			}

			// $attrib[6] caption alignment
			if ( !isset($attrib[6]) || !$attrib[6] ) {
				$attrib[6] = '';
			}

			// image size attibutes

			// assemble the <image> tag
			$image = '<img src="'. $mosConfig_live_site .'/images/stories/'. $attrib[0] .'"';
			// no aligment variable - if caption detected
			if ( !$attrib[4] ) {
				$image .= $attrib[1] ? ' align="'. $attrib[1] .'"' : '';
			}
			$image .=' alt="'. $attrib[2] .'" title="'. $attrib[2] .'" border="'. $border .'" '. (($width) ? 'width="'. $width . '"' : '') .(($height) ? ' height="'. $height .'"' : '').' />';

			$img = $image;
		}
		return $img;
	}

	function calModStyle ($cols) {
		$modules = array();
		switch ($cols) {
			case 0: return null;
			break;
			case 1:
				$modules[0]['class'] = "";
				$modules[0]['width'] = "100%";
				$modules[0]['subwidth'] = "100%";
				break;
			case 2:
				$modules[0]['class'] = "-left";
				$modules[0]['width'] = "49.9%";
				$modules[0]['subwidth'] = "95%";
				$modules[1]['class'] = "-right";
				$modules[1]['width'] = "49.9%";
				$modules[1]['subwidth'] = "95%";
				break;
			default:

				$width1 = round(99.6/($cols-0.1), 2);
				$width2 = round((99.6 - $width1*($cols-2))/2, 2);

				for ($i=1; $i<$cols - 1; $i++){
					$modules[$i]['class'] = "-center";
					$modules[$i]['width'] = $width1."%";
					$modules[$i]['subwidth'] = "90%";
				}
				$modules[0]['class'] = "-left";
				$modules[0]['width'] = $width2."%";
				$modules[0]['subwidth'] = "95%";
				$modules[$cols - 1]['class'] = "-right";
				$modules[$cols - 1]['width'] = $width2."%";
				$modules[$cols - 1]['subwidth'] = "95%";
				break;
		}
		return $modules;
	}
	
	function textprocess($string, $enableIconv = false) {
		$current_charset = JA_News::getCharset();
		
		if ($current_charset == "UTF-8") return $string;
		if ($enableIconv && function_exists("iconv")) {
			return iconv(str_replace("CHARSET=", "", strtoupper(_ISO)), "UTF-8", $string);
		}
		
		if ($current_charset) {
			$trans_tbl = array("&lt;" => "<", "&gt;" => ">", "&amp;" => "&");
			return strtr(htmlentities($string, ENT_NOQUOTES, $current_charset), $trans_tbl);
		} 
		
		return $string;
	}
		
	function getNextTitle ($news, $total) {
		global $database, $mainframe, $my, $now, $access, $nullDate;
		$query = "SELECT a.title"
				. "\n FROM #__content AS a"
				. "\n INNER JOIN #__content_frontpage AS f ON f.content_id = a.id"
				. "\n INNER JOIN #__categories AS cc ON cc.id = a.catid"
				. "\n WHERE ( a.state = 1 AND a.sectionid > 0 "
				. "\n AND ( a.publish_up = '$nullDate' OR a.publish_up <= '$now' )"
				. "\n AND ( a.publish_down = '$nullDate' OR a.publish_down >= '$now' )"
				. ( $access ? "\n AND a.access <= $my->gid AND cc.access <= $my->gid" : '' )
				. "\n AND cc.published = 1 )"
				. "\n ORDER BY f.ordering ASC limit ".(($news < $total) ? $news : 0).", 1";
		$database->setQuery($query);
		return $database->loadResult();
	}

	function getPrevTitle ($news, $total) {
		global $database, $mainframe, $my, $now, $access, $nullDate;
		$query = "SELECT a.title"
				. "\n FROM #__content AS a"
				. "\n INNER JOIN #__content_frontpage AS f ON f.content_id = a.id"
				. "\n INNER JOIN #__categories AS cc ON cc.id = a.catid"
				. "\n WHERE ( a.state = 1 AND a.sectionid > 0 "
				. "\n AND ( a.publish_up = '$nullDate' OR a.publish_up <= '$now' )"
				. "\n AND ( a.publish_down = '$nullDate' OR a.publish_down >= '$now' )"
				. ( $access ? "\n AND a.access <= $my->gid AND cc.access <= $my->gid" : '' )
				. "\n AND cc.published = 1 )"
				. "\n ORDER BY f.ordering ASC limit ". (($news > 1) ? $news - 2 : $total - 1) .", 1";
		$database->setQuery($query);
		return $database->loadResult();		
	}
	
	function getCharset() {
		$charset = array(
		   "CHARSET=ISO-8859-1" => "ISO8859-1",
		   "CHARSET=ISO8859-1" => "ISO8859-1",
		   "CHARSET=ISO-8859-15" => "ISO8859-15",
		   "CHARSET=ISO8859-15" => "ISO8859-15",
		   "CHARSET=UTF-8" => "UTF-8",
		   "CHARSET=CP866" => "ibm866",
		   "CHARSET=866" => "ibm866",
		   "CHARSET=IBM866" => "ibm866",
		   "CHARSET=CP1251" => "Windows-1251",
		   "CHARSET=WINDOWS-1251" => "Windows-1251",
		   "CHARSET=WIN-1251" => "Windows-1251",
		   "CHARSET=1251" => "Windows-1251",
		   "CHARSET=CP1252" => "Windows-1252",
		   "CHARSET=WINDOWS-1252" => "Windows-1252",
		   "CHARSET=1252" => "Windows-1252",
		   "CHARSET=KOI8-R" => "koi8-ru",
		   "CHARSET=KOI8-RU" => "koi8-ru",
		   "CHARSET=KOI8R" => "koi8-ru",
		   "CHARSET=BIG5" => "950",
		   "CHARSET=950" => "950",
		   "CHARSET=GB2312" => "936",
		   "CHARSET=936" => "936",
		   "CHARSET=BIG5-HKSCS" => "BIG5-HKSCS",
		   "CHARSET=SHIFT_JIS" => "SJIS",
		   "CHARSET=SJIS" => "SJIS",
		   "CHARSET=932" => "SJIS",
		   "CHARSET=EUC-JP" => "EUCJP",
		   "CHARSET=EUCJP" => "EUCJP"
		);

		$current_charset = isset($charset[strtoupper(_ISO)]) ? $charset[strtoupper(_ISO)] : "ISO8859-1";		
		return $current_charset;				
	}
	
	function getTotalNews(){
		global $database, $mainframe, $my, $now, $access;
		$nullDate 	= $database->getNullDate();
	
		$query = "SELECT COUNT(*)"
				. "\n FROM #__content AS a"
				. "\n INNER JOIN #__content_frontpage AS f ON f.content_id = a.id"
				. "\n INNER JOIN #__categories AS cc ON cc.id = a.catid"
				. "\n WHERE ( a.state = 1 AND a.sectionid > 0 "
				. "\n AND ( a.publish_up = '$nullDate' OR a.publish_up <= '$now' )"
				. "\n AND ( a.publish_down = '$nullDate' OR a.publish_down >= '$now' )"
				. ( $access ? "\n AND a.access <= $my->gid AND cc.access <= $my->gid" : '' )
				. "\n AND cc.published = 1 )";
				
		$database->setQuery($query);
		$c = $database->loadResult();
		return $c;		
	}
	
	function getNews($news) {
		global $database, $mainframe, $my, $now, $access;
		$nullDate 	= $database->getNullDate();
		$query = "SELECT a.images, a.introtext, a.id, a.title, a.sectionid, a.catid, cc.title as cattitle"
					. "\n FROM #__content AS a"
					. "\n INNER JOIN #__content_frontpage AS f ON f.content_id = a.id"
					. "\n INNER JOIN #__categories AS cc ON cc.id = a.catid"
					. "\n WHERE ( a.state = 1 AND a.sectionid > 0 "
					. "\n AND ( a.publish_up = '$nullDate' OR a.publish_up <= '$now' )"
					. "\n AND ( a.publish_down = '$nullDate' OR a.publish_down >= '$now' )"
					. ( $access ? "\n AND a.access <= $my->gid AND cc.access <= $my->gid" : '' )
					. "\n AND cc.published = 1 )"
					. "\n ORDER BY f.ordering ASC limit ". ($news - 1) .", 1";
		$database->setQuery($query);
		$firstnew = null;
		$database->loadObject($firstnew);
		return $firstnew;		
	}
}
?>