// JA MOO ROLLER CONFIG

var autoroll = true; // set to false if you don't want it
var delayroll = 4000; // delay length, in miliseconds
var rollspeed = 2000; // animation duration, in miliseconds

var rollerOuter = "roller-wrapper"; // roller holder
var rollerLoading = "roller-loading"; // roller loading image holder
var rollerClass = "roller"; // roller class name
var clickerClass = "clicker"; // clicker class name
var activeSuffix = "-active"; // active clicker class suffix

// END OF JA MOO ROLLER CONFIG

// JA MOO ROLLER
var isShowing = 0;
var rollers;
var clickers;
var fx1 = new Array();
var firstDelay = false;
var pauseFlag = false;
var timer;
var playButton;

function initRoll() {
	displayloading = document.getElementById(rollerLoading);
	if (displayloading) displayloading.style.display = "none";
	else return;
	displayroller = document.getElementById(rollerOuter);
	if (displayroller) displayroller.style.display = "block";
	
	if (readCookie("ja-moofx-autoroll") == "true") autoroll = true;
	else if (readCookie("ja-moofx-autoroll") == "false") autoroll = false;	
	playButton = document.getElementById('playButton');
	if (autoroll) { showPauseButton(); }
	else { showPlayButton(); }

	rollers = document.getElementsByClassName(rollerClass);
	clickers = document.getElementsByClassName(clickerClass);
	
	if (rollers.length == 0 || clickers.length == 0) return;
	
	for (i = 0; i < rollers.length; ++i) {
		fx1[i] = new fx.Combo(rollers[i], { opacity: true, width: false, duration: rollspeed, height: true });
		clickers[i].onclick = function() {
			current = null;
			for (j = 0; j < clickers.length; ++j) {
				if (this == clickers[j]) current = j;
			}
			if (current != isShowing) {
				fx1[isShowing].clearTimer();
				if (fx1[isShowing].el.offsetHeight) fx1[isShowing].hide();
				fx1[current].toggle();
				clickers[isShowing].className = clickerClass;
				clickers[current].className = clickerClass + activeSuffix;
				isShowing = current;
				clearRoll();
			}
			
			return false;
		}
		if (i != 0) {
			fx1[i].hide();
		} else {
			clickers[i].className = clickerClass + activeSuffix;
		}
	}
}

function showPauseButton() {
	createCookie("ja-moofx-autoroll", "true");
	playButton.innerHTML = "Pause";
	playButton.title = "Pause";
	pauseFlag = false;
	autoRoll();
}

function showPlayButton() {
	createCookie("ja-moofx-autoroll", "false");
	playButton.innerHTML = "Play";
	playButton.title = "Play";
	pauseFlag = true;
	clearTimeout(timer);
	firstDelay = false;
}

function showNext() {
	if (rollers.length <= 1) return;
	fx1[isShowing].clearTimer();
	if (fx1[isShowing].el.offsetHeight) fx1[isShowing].hide();
	clickers[isShowing].className = clickerClass;
	if (isShowing == rollers.length - 1) {
		fx1[0].toggle();
		isShowing = 0;
	} else {
		fx1[++isShowing].toggle();
	}
	clickers[isShowing].className = clickerClass + activeSuffix;
}

function showPrev() {
	if (rollers.length <= 1) return;
	fx1[isShowing].clearTimer();
	if (fx1[isShowing].el.offsetHeight) fx1[isShowing].hide();
	clickers[isShowing].className = clickerClass;
	if (isShowing == 0) {
		fx1[rollers.length - 1].toggle();
		isShowing = rollers.length - 1;
	} else {
		fx1[--isShowing].toggle();
	}
	clickers[isShowing].className = clickerClass + activeSuffix;
}

function autoRoll() {
	if (!pauseFlag) {
		timer = setTimeout('autoRoll()', delayroll);
		if (!firstDelay) firstDelay = true;
		else showNext();
	}
}

function clearRoll() {
	if (!pauseFlag) {
		clearTimeout(timer);
		firstDelay = false;
		autoRoll();
	}
}

function playButtonClicked() {
	if (pauseFlag) showPauseButton();
	else showPlayButton();
}
