<?php
/*
+ ----------------------------------------------------------------------------+
|     e107 website system
|
|     Steve Dunstan 2001-2002
|     http://e107.org
|     jalist@e107.org
|
|     Released under the terms and conditions of the
|     GNU General Public License (http://gnu.org).
|
|     $Source: /cvsrepo/connections/theme.php,v $
|     $Revision: 1.5 $
|     $Date: 2005/07/27 23:40:05 $
|     $Author: ian $
+----------------------------------------------------------------------------+
*/
if(!defined("e_THEME")){ exit; }

// [multilanguage]
@include_once(e_THEME."Limburgia/languages/".e_LANGUAGE.".php");
@include_once(e_THEME."Limburgia/languages/English.php");

// [theme]
$themename = "Limburgia";
$themeversion = "1.0";
$themeauthor = "Dennis van Houts";
$themeemail = "dennisvanhouts@gmail.com";
$themewebsite = "";
$themedate = "March 21, 2007";
$themeinfo = "A nice solid looking theme.";
define("STANDARDS_MODE", TRUE);
$xhtmlcompliant = TRUE;
$csscompliant = TRUE;
define("IMODE", "lite");
define("THEME_DISCLAIMER", "<br/><i>".LAN_THEME_1."</i>");
define("BULLET", "bullet.gif");

// [layout]

$layout = "_default";

$HEADER = "
<div id='rap'>
	<div id='header'>
		<div id='searchbox'>
		{CUSTOM=search+".THEME."images/search.gif+19+18}
		</div>
		<ul id='topnav'>
			{SITELINKS=flat}
		</ul>
		<h1></h1>
		<div id='desc'></div>
	</div>
	<div id='main'>
		<div id='content'>
		{SETSTYLE=content}
";

$FOOTER = "
		</div>
		<div id='sidebar'>
			{SETSTYLE=menu}
			{MENU=1}
			{MENU=2}
		</div>
		<p id='footer'>{SITEDISCLAIMER} {THEMEDISCLAIMER}</p>
	</div>
</div>
";

function news_style($news) 
{
	$date = strftime("%a", $news['news_datestamp']);
	$date .= "<br/>";
	$date .= strftime("%d %b %Y %H:%M", $news['news_datestamp']);
	$NEWSSTYLE = "
	<div class='post'>
		<p class='post-date'>".$date."</p>	
		<div class='post-info'>
			<h6>{STICKY_ICON} {NEWSTITLE}</h6>
			&#1606;&#1588;&#1585;&#1578;&nbsp; &#1576;&#1608;&#1575;&#1587;&#1591;&#1577; {NEWSAUTHOR} &#1601;&#1610; &#1602;&#1587;&#1605; {NEWSCATEGORY}<br/>
			{NEWSCOMMENTS}{TRACKBACK}&nbsp;
			</div>							
		<div class='post-content'>
			<div class='news-icon'>{NEWSICON}</div>
			{NEWSBODY}<br />
			{EXTENDED}
			<br />
			{EMAILICON}
			{PRINTICON}
			{ADMINOPTIONS}			
			<div class='post-footer'>&nbsp;</div>
		</div>
	</div>\n";
	return $NEWSSTYLE;
}



//        [tablestyle]

function tablestyle($caption, $text, $mode="")
{
	global $style;
	if($style == "menu")
	{
		echo "<h2>$caption</h2>
		<ul>
			<li>$text</li>	
		</ul><br/>\n";
	}
	else
	{
		echo "<h2>$caption</h2>
		$text	
		<br/>\n";
	}
}

define("ICONSTYLE", "float: left; border:0");
define("COMMENTLINK", LAN_THEME_3);
define("COMMENTOFFSTRING", LAN_THEME_2);
define("PRE_EXTENDEDSTRING", "<br /><br />[ ");
define("EXTENDEDSTRING", LAN_THEME_4);
define("POST_EXTENDEDSTRING", " ]<br />");
define("TRACKBACKSTRING", LAN_THEME_5);
define("TRACKBACKBEFORESTRING", " | ");


// [linkstyle]

define(PRELINK, "<div class='linkstreepje'>| ");
define('POSTLINK', "");
define('LINKSTART', "<li>");
define('LINKEND', "</li> | ");
define('LINKDISPLAY', 1);
define('LINKALIGN', "");
define('LINKCLASS', "");

$COMMENTSTYLE = "
<ol class='commentlist'>
	<li class='alt'>
		<div style='float: left; padding: 4px; margin-bottom: -20px; margin-left: 5px;'>{AVATAR}</div>
		<small class='commentmetadata'>{TIMEDATE} {COMMENTEDIT}</small><br />
		<cite>{USERNAME}</cite> &#1603;&#1578;&#1576;:<br /><br />
		{COMMENT}<br/>
		{REPLY}
	</li>
</ol>
";


$CHATBOXSTYLE = "
<img src='".THEME."images/bullet2.gif' alt='bullet' />
<b>{USERNAME}</b><br />{TIMEDATE}
<div class='smalltext'>
{MESSAGE}
</div>
<br />";
?>
