<?php
//################################################################################//
//         MOD NAME: VBISpy                                                      #//
//################################################################################//
//      DESCRIPTION: This modification for vBulletin adds a "live" scrolling     #//
//                   update of new posts to the forum                            #//
//################################################################################//
//               :                                                     #//     BlackScorpion   
//                                                                  #//
//          VERSION: 1.0.12                                                      #//
//################################################################################//

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'vaispy');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');

// #########################   CONFIG VARS    ############################
// The number of days to scan the table for .. (86400 represents the number of seconds in 24 hours)
$daysprune = 1;

// Do not list these forums even if they have permissions (test categories, etc)
$blockforums = "";

// #########################   CONFIG VARS    ############################

$forumperms = array();
$lastpostid = (int)$_REQUEST['last'];
$subscribe = (int)$_REQUEST['subscribe'];

foreach($vbulletin->forumcache AS $forum) {
    $forumid = $forum['forumid'];
    $forumperms =& $vbulletin->userinfo['forumpermissions']["$forumid"];

    if (!isset($vbulletin->forumcache["$forumid"]) OR !($forumperms & $vbulletin->bf_ugp_forumpermissions['canview']) OR !($forumperms & $vbulletin->bf_ugp_forumpermissions['canviewothers']) OR !verify_forum_password($forumid, $vbulletin->forumcache["$forumid"]['password'], false))
    {
        $blockforums .= ','.$forum['forumid'];
    }
}
unset($forum);

$datecut = "AND thread.lastpost >= " . (TIMENOW - ($daysprune * 86400));
$prefetched = null;

############################################################################
// Get Threads I've Posted In
require_once(DIR . '/includes/functions_forumdisplay.php');
$result = $db->query_read("
    SELECT threadid
    FROM " . TABLE_PREFIX . "thread as thread
    WHERE thread.forumid NOT IN (0$blockforums) and
        thread.visible = 1 and
        thread.open <> 10 and
        thread.lastpostid > $lastpostid
        $datecut
");

$idsArray = array();
while ($id = $db->fetch_array($result))
{
    $idsArray[] = $id['threadid'];
}

$dotthreads = fetch_dot_threads_array(implode(',', $idsArray));
############################################################################
// Get Threads

// Do not set to more than 20 unless you know how to modify the html at the bottom of the page (and at line 291)
$limitq = ( isset($_REQUEST['do']) ? "20" : "5,20" );

if ( $subscribe == 1 )
{
$getthreads = $db->query_read("
      SELECT subscribethread.subscribethreadid,
             thread.forumid,
             thread.firstpostid,
             thread.lastpost,
             thread.lastposter,
             thread.lastpostid,
             thread.replycount,
             thread.threadid,
             thread.title,
             thread.open,
             thread.views,
             post.pagetext AS preview,
             post.userid AS lastpuserid
		FROM " . TABLE_PREFIX . "subscribethread AS subscribethread
		     INNER JOIN " . TABLE_PREFIX . "thread AS thread ON (subscribethread.threadid = thread.threadid)
             LEFT JOIN " . TABLE_PREFIX . "deletionlog AS deletionlog ON (thread.threadid = deletionlog.primaryid AND type = 'thread')
             LEFT JOIN " . TABLE_PREFIX . "post AS post ON (post.postid = thread.lastpostid)
		WHERE subscribethread.userid = " . $vbulletin->userinfo['userid'] . "
            AND thread.forumid NOT IN (0$blockforums)
			AND thread.visible = 1
			AND subscribethread.canview = 1
            AND thread.lastpostid > $lastpostid
            AND deletionlog.primaryid IS NULL
            $datecut
       ORDER BY thread.lastpost DESC LIMIT $limitq
");
}
else
{
$getthreads = $db->query_read("
      SELECT thread.forumid,
             thread.firstpostid,
             thread.lastpost,
             thread.lastposter,
             thread.lastpostid,
             thread.replycount,
             thread.threadid,
             thread.title,
             thread.open,
             thread.views,
             post.pagetext AS preview,
             post.userid AS lastpuserid
        FROM " . TABLE_PREFIX . "thread AS thread
             LEFT JOIN " . TABLE_PREFIX . "deletionlog AS deletionlog ON (thread.threadid = deletionlog.primaryid AND type = 'thread')
             LEFT JOIN " . TABLE_PREFIX . "post AS post ON (post.postid = thread.lastpostid)
       WHERE open <> 10
         $datecut
         AND thread.forumid NOT IN (0$blockforums)
         AND thread.visible = '1'
         AND thread.lastpostid > $lastpostid
         AND post.visible = 1
         AND deletionlog.primaryid IS NULL
       ORDER BY thread.lastpost DESC LIMIT $limitq
");
}

$row = $highestid = 1;
$rowcolor = "alt2";

while($thread = $db->fetch_array($getthreads)) {
    $color = $color == 'alt1' ? 'alt2' : 'alt1';

    $thread['title'] = htmlspecialchars_uni(fetch_censored_text(fetch_trimmed_title(unhtmlspecialchars($thread['title']), 85)));
    $thread['date'] = vbdate($vbulletin->options['dateformat'], $thread['lastpost'], 1);
    $thread['time'] = vbdate($vbulletin->options['timeformat'], $thread['lastpost']);

    // Get rid of html and bbcode first
    $thread['preview'] = strip_tags(strip_bbcode($thread['preview'], true, true));
    $thread['preview'] = htmlspecialchars_uni(fetch_trimmed_title($thread['preview'], 200));
    $thread['preview'] = fetch_censored_text(fetch_word_wrapped_string($thread['preview'], 20));

    $thread['replycount'] = vb_number_format($thread['replycount']);
    $thread['views'] = vb_number_format($thread['views']);

    $tforumid = $thread['forumid'];
    $thread['forum'] = htmlspecialchars_uni($vbulletin->forumcache["$tforumid"]['title']);

    if ( $thread['lastpostid'] == $thread['firstpostid'] )
    {
        $etype = " ";
    }
    else
    {
        $etype = " ";
    }

    // Statusicon
    // show dot folder?
    if ($vbulletin->userinfo['userid'] AND $vbulletin->options['showdots'] AND $dotthreads["$thread[threadid]"])
    {
        $thread['statusicon'] .= '_dot';
        $thread['dot_count'] = $dotthreads["$thread[threadid]"]['count'];
        $thread['dot_lastpost'] = $dotthreads["$thread[threadid]"]['lastpost'];
    }

    // show hot folder?
    if ($vbulletin->options['usehotthreads'] AND (($thread['replycount'] >= $vbulletin->options['hotnumberposts'] AND $vbulletin->options['hotnumberposts'] > 0) OR ($thread['views'] >= $vbulletin->options['hotnumberviews'] AND $vbulletin->options['hotnumberviews'] > 0)))
    {
        $thread['statusicon'] .= '_hot';
    }

    // show locked folder?
    if (!$thread['open'])
    {
        $thread['statusicon'] .= '_lock';
    }

    $thread['statusicon'] = $stylevar['imgdir_statusicon'] . '/thread' . $thread['statusicon'] . '.gif';

    if ( $_REQUEST['do'] == "xml" )
    {
$output .= <<<VAPRINT
<event>
<id>{$thread['lastpostid']}</id>
<what>$etype</what>
<when>{$thread['date']} {$thread['time']}</when>
<title>{$thread['title']}</title>
<preview>{$thread['preview']}</preview>
<poster>{$thread['lastposter']}</poster>
<threadid>{$thread['threadid']}</threadid>
<postid>{$thread['lastpostid']}</postid>
<lastpost>{$thread['lastpost']}</lastpost>
<userid>{$thread['lastpuserid']}</userid>
<forumid>{$thread['forumid']}</forumid>
<forumname>{$thread['forum']}</forumname>
<views>{$thread['views']}</views>
<replies>{$thread['replycount']}</replies>
<statusicon>{$thread['statusicon']}</statusicon>
</event>
VAPRINT;
    }
    else
    {
        $rowcolor = ( $rowcolor == "alt1" ? "alt2" : "alt1" );

        $where = $clip = $poster_clip = $poster = null;

        if ( stristr($etype, "thread") )
        {
            $post_url = "showthread.php?t={$thread['threadid']}";
        }
        else
        {
            $post_url = "showthread.php?p={$thread['lastpostid']}#post{$thread['lastpostid']}";
        }

        if( !$thread['title'] )
        {
            $clip = "<strong>Unknown</strong>";
        }
        else
        {
            $clip = "<strong><img src=\"{$thread['statusicon']}\" alt=\"\" /><a target=\"_blank\" href=\"{$post_url}\">{$thread['title']}</a></strong>";
        }

        if ( $thread['preview'] )
        {
            $clip .= "<br />{$thread['preview']}";
        }

        $clip .= " ({$thread['views']} views, {$thread['replycount']} replies)";

        if ( $thread['lastpuserid'] )
        {
            $poster_clip = "<a target=\"_blank\" href=\"member.php?u={$thread['lastpuserid']}\">{$thread['lastposter']}</a>";
        }

        $poster_clip .= "<br />{$thread['date']} {$thread['time']}";

        if ( $thread['forum'] )
        {
            $where .= "<strong><a target=\"_blank\" href=\"forumdisplay.php?f={$thread['forumid']}\">{$thread['forum']}</a></strong>";
        }
        else
        {
            $where = "";
        }

        if (is_browser('opera'))
        {
$prefetched .= <<<VAPRINT
<div id="row{$row}"><table cellpadding="3" cellspacing="0" border="0" width="100%"><tr><td width="20" class="$rowcolor smallfont" nowrap="nowrap" align="center">$etype</td><td class="$rowcolor smallfont" width="225" nowrap="nowrap" align="left">$poster_clip</td><td class="$rowcolor smallfont" width="80%">$clip</td><td class="$rowcolor smallfont" width="200" nowrap="nowrap" align="center">$where</td></tr></table></div>\n
VAPRINT;
        }
        else
        {
$prefetched .= <<<VAPRINT
<tr id="row{$row}"><td class="$rowcolor smallfont" align="center"><div class="smallfont">$etype</div></td><td class="$rowcolor smallfont"><div class="smallfont">$poster_clip</div></td><td class="$rowcolor smallfont"><div class="smallfont">$clip</div></td><td class="$rowcolor smallfont" align="center"><div class="smallfont">$where</div></td></tr>\n
VAPRINT;
        }

        $row++;
        if ( $thread['lastpostid'] > $highestid )
        {
            $highestid = $thread['lastpostid'];
        }
    }
}

if ( $row < 20 )
{
    for( $x = $row; $x < 21; $x++ )
    {
        if (is_browser('opera'))
        {
$prefetched .= <<<VAPRINT
<div id="row{$x}"></div>\n
VAPRINT;
        }
        else
        {
$prefetched .= <<<VAPRINT
<tr id="row{$x}"><td class="$rowcolor smallfont" align="center">&nbsp;</td><td class="$rowcolor smallfont">&nbsp;</td><td class="$rowcolor smallfont">&nbsp;</td><td class="$rowcolor smallfont" align="center">&nbsp;</td></tr>\n
VAPRINT;
        }
    }
}

// memory saving
unset($thread);
$db->free_result($getthreads);

if ( $_REQUEST['do'] == "xml" )
{
    header( 'Content-Type: text/xml' . ($stylevar['charset'] != '' ? '; charset=' .  $stylevar['charset'] : '') );
    echo '<?xml version="1.0" encoding="' . $stylevar['charset'] . '"?>' . "\r\n";

    if ( $output )
    {
        echo "<events>$output</events>";
    }
    else
    {
        echo "<events />";
    }

    exit;
}

$navbits = array();
$navbits[$parent] = 'iSpy';
$navbits = construct_navbits($navbits);

eval('$navbar = "' . fetch_template('navbar') . '";');
$navbar = process_replacement_vars($navbar);

eval('$headinclude = "' . fetch_template('headinclude') . '";');
$headinclude = process_replacement_vars($headinclude);

eval('$footer = "' . fetch_template('footer') . '";');
$footer = process_replacement_vars($footer);

echo<<<VAPRINT
$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
$headinclude
<style type="text/css">
.spyfade1 div, .spyfade1 span,, .spyfade1 td, .spyfade1 img {
opacity:0.90;
filter:alpha(opacity=90);
-moz-opacity:0.90;
}
.spyfade2 div, .spyfade2 span, .spyfade2 td, .spyfade2 img {
opacity:0.80;
filter:alpha(opacity=80);
-moz-opacity:0.80;
}
.spyfade3 div, .spyfade3 span, .spyfade3 td, .spyfade3 img {
opacity:0.70;
filter:alpha(opacity=70);
-moz-opacity:0.70;
}
.spyfade4 div, .spyfade4 span, .spyfade4 td, .spyfade4 img {
opacity:0.50;
filter:alpha(opacity=50);
-moz-opacity:0.50;
}
.spyfade5 div, .spyfade5 span, .spyfade5 td, .spyfade5 img {
opacity:0.30;
filter:alpha(opacity=30);
-moz-opacity:0.30;
}
</style>
<script language="javascript" src="clientscript/va_prototype.js"></script>
<script language="javascript" src="clientscript/va_effects.js"></script>
<script language="javascript" src="clientscript/va_spy.js"></script>
<script language="javascript" type="text/javascript">
<!--
    spymax = 25;
	highestid = $highestid;

function pauseSpy() {
    var playimg = document.getElementById("vaplay");
    var pauseimg = document.getElementById("vapause");

    playimg.src = "images/misc/play_up.gif";
    playimg.alt = "Click to Play";
    pauseimg.src = "images/misc/pause_down.gif";
    pauseimg.alt = "Paused...";

    pause();
}

function playSpy() {
    var playimg = document.getElementById("vaplay");
    var pauseimg = document.getElementById("vapause");

    playimg.src = "images/misc/play_down.gif";
    playimg.alt = "Playing...";
    pauseimg.src = "images/misc/pause_up.gif";
    pauseimg.alt = "Click to Pause";

    resume();
}

function pause() {
    play = 0;
}

function resume() {
    play = 1;
}
// -->
</script>
<title>iSpy</title>
</head>
<body onload="spyinit();">
$header
$navbar

<table width="90%" align="center"><tr><td width="50%" align="left"><input type="checkbox" id="subscribe" value="1">&nbsp;  </td>
<td width="50%" align="right">
<img id="vaplay" src="images/misc/play_down.gif" style="cursor:pointer;" alt="Play" title="Play Comments" onclick="playSpy();" /> &nbsp;
<img id="vapause" src="images/misc/pause_up.gif" style="cursor:pointer;" alt="Pause" title="Pause Comments" onclick="pauseSpy();" />
</td></tr></table>
<br />
VAPRINT;

if (is_browser('opera'))
{
$output .= <<<VAPRINT
<table class="tborder" cellpadding="0" cellspacing="0" border="0" width="100%" align="center" id="spy_table">
<tr><td width="20" class="tcat" nowrap="nowrap" style="height:25px;">&nbsp;</td>
<td class="tcat" width="225" nowrap="nowrap" style="height:25px;"></td>
<td class="tcat" width="80%" style="height:25px;">/</td>
<td class="tcat" width="200" nowrap="nowrap" style="height:25px;">
</tr>
<tr><td colspan="4" class="alt1">
$prefetched
<div id="row21" style="display:none;" class="spyfade1"></div>
<div id="row22" style="display:none;" class="spyfade2"></div>
<div id="row23" style="display:none;" class="spyfade3"></div>
<div id="row24" style="display:none;" class="spyfade4"></div>
<div id="row25" style="display:none;" class="spyfade5"></div>
</td></tr>
</table>
VAPRINT;
}
else
{
$output .= <<<VAPRINT
<table class="tborder" cellpadding="6" cellspacing="1" border="0" width="100%" align="center" id="spy_table">
<thead>
<tr align="center"><td class="thead" width="100"></td><td class="thead" width="190"></td><td class="thead">/</td><td class="thead" width="190"></td></tr>
</thead>
<tbody class="alt1">
$prefetched
<tr id="row21" style="display: none;" class="spyfade1"><td align="center">&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td align="center">&nbsp;</td></tr>
<tr id="row22" style="display: none;" class="spyfade2"><td align="center">&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td align="center">&nbsp;</td></tr>
<tr id="row23" style="display: none;" class="spyfade3"><td align="center">&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td align="center">&nbsp;</td></tr>
<tr id="row24" style="display: none;" class="spyfade4"><td align="center">&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td align="center">&nbsp;</td></tr>
<tr id="row25" style="display: none;" class="spyfade5"><td align="center">&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td align="center">&nbsp;</td></tr>
</tbody>
</table>
<center>
<table>
<tr>
<td>
<center><font size='3' color='red'><a href='http://www.pc-xray.com/vb'>   <br>BlackScorpion </a></font></center>
</tr>
</table>
</center>
VAPRINT;
}

$output .= <<<VAPRINT
$footer
VAPRINT;
echo $output;


?>
