<?php
  // ######################## SET PHP ENVIRONMENT ###########################
  error_reporting(E_ALL & ~E_NOTICE);
  
  // ##################### DEFINE IMPORTANT CONSTANTS #######################
  // change the line below to the actual filename without ".php" extention.
  // the reason for using actual filename without extention as a value of this constant is to ensure uniqueness of the value throughout every PHP file of any given vBulletin installation.
  
  define('THIS_SCRIPT', 'videogallery');
  
  // #################### PRE-CACHE TEMPLATES AND DATA ######################
  // get special phrase groups
  $phrasegroups = array();
  
  // get special data templates from the datastore
  $specialtemplates = array();
  
  // pre-cache templates used by all actions
  $globaltemplates = array(// change the lines below to the list of actual templates used in the script
  'vgal_addcategory','vgal_videobitsRated', 'vgal_videocommentbits', 'vgal_movevideobits', 'vgal_addtype', 'vgal_addvideo', 'vgal_adminmenu', 'vgal_categorybits', 'vgal_categorypage', 'vgal_categoryvideos', 'vgal_deletecategories', 'vgal_deletecategorybits', 'vgal_deletetypebits', 'vgal_editcategories', 'vgal_editcategorybits', 'vgal_edittypebits', 'vgal_edittypes', 'vgal_videobits', 'vgal_videotypebits', 'vgal_viewvideo');
  
  // pre-cache templates used by specific actions
  $actiontemplates = array();
  
  // ########################## REQUIRE BACK-END ############################
  require_once('./global.php');
  // #################### HARD CODE JAVASCRIPT PATHS ########################
  $headinclude = str_replace('clientscript', $vbulletin->options['bburl'] . '/clientscript', $headinclude);
  
  // ########################################################################
  // ######################### START MAIN SCRIPT ############################
  // ########################################################################
  require_once('./includes/videogalleryinclude.php');
  require_once('./includes/adminfunctions.php');
  
  
  	//initialize bbcode class
	require_once(DIR . '/includes/class_bbcode.php');
	$parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
  
  
  $vdata =& new attilitus_data;
  $attilitus =& new attilitus;
  

  //Input cleaning
  $attilitus->clean(g,'do',str);
  //
  //Permissions Section
  //
  //explode admin groups into an array and check if current user belongs.
  $vbulletin->options['vgal_admingroups'] = explode(',', $vbulletin->options['vgal_admingroups']);
  
  
  if ((in_array($vbulletin->userinfo['usergroupid'], $vbulletin->options['vgal_admingroups']))) {
      $masterperms['admin'] = true;
  }
  
  $vbulletin->options['vgal_uploadgroups'] = explode(',', $vbulletin->options['vgal_uploadgroups']);
  if ((in_array($vbulletin->userinfo['usergroupid'], $vbulletin->options['vgal_uploadgroups']))) {
      $masterperms['upload'] = true;
  }
  
  $vbulletin->options['vgal_bannedgroups'] = explode(',', $vbulletin->options['vgal_bannedgroups']);
  if ((in_array($vbulletin->userinfo['usergroupid'], $vbulletin->options['vgal_bannedgroups']))) {
      $masterperms['banned'] = true;
  }
  
  $vbulletin->options['vgal_canrategroups'] = explode(',', $vbulletin->options['vgal_canrategroups']);
  if ((in_array($vbulletin->userinfo['usergroupid'], $vbulletin->options['vgal_canrategroups']))) {
      $masterperms['canrate'] = true;
  }

  $vbulletin->options['vgal_groupscancomment'] = explode(',', $vbulletin->options['vgal_groupscancomment']);
  if ((in_array($vbulletin->userinfo['usergroupid'], $vbulletin->options['vgal_groupscancomment']))) {
      $masterperms['cancomment'] = true;
  }  
  
  $vgal['VideosPerPage'] = $vbulletin->options['vgal_videosperpage'];
  $vgal['CommentsPerPage'] = $vbulletin->options['vgal_CommentsPerPage'];  
  
  if ($masterperms['admin']) {
      eval($attilitus->buildtemplate(vgal_adminmenu));
  }
  if ($masterperms['banned']) {
      standard_error("      ");
  }

    
    
    $attilitus->clean(g,catid,uint);
    $attilitus->clean(g,videoid,uint);
                        
  
  if ($attilitus->clean['videoid']) {
      $vdata->set(vgal_videos);
      $vdata->select('*');
      $vdata->where(videoid, $attilitus->clean['videoid']);
      $videoinfo = $vdata->execute(select1);
      
      if (!$videoinfo) {
          standard_error("       ");
      }
      
      //Video exists, lets fetch type info.
      $vdata->set(vgal_videotypes);
      $vdata->select('*');
      $vdata->where(typeid, $videoinfo['typeid']);
      $typeinfo = $vdata->execute(select1);
      
      $vdata->set(vgal_categories);
      $vdata->select('*');
      $vdata->where(catid, $videoinfo['catid']);
      $categoryinfo = $vdata->execute(select1);
      
      $typeinfo['code'] = str_replace('$code', $videoinfo['code'], $typeinfo['code']);
      $videoinfo['code'] = $typeinfo['code'];
      
      //convert html characters
      $videoinfo['code'] = html_entity_decode($videoinfo['code']);
      
      $videoinfo['time'] = vbdate("F j, Y, g:i a", $videoinfo['time']);
      $videoinfo['rating']=round($videoinfo['rating'],2);
      
      //Time to comment
      

     $attilitus->clean(p,commentsubmit,str);
      
     if($attilitus->clean['commentsubmit']==yes){
         if(!$masterperms['cancomment']){
          standard_error("       ");   
         }
      $attilitus->clean(p,comment,nohtml);
     //add the comment.
     $vdata->set(vgal_comments);
     $vdata->insert(userid,$vbulletin->userinfo['userid']);
     $vdata->insert(username,$vbulletin->userinfo['username']);
     $vdata->insert(comment,$attilitus->clean['comment']);
     $currtime=time();
     $vdata->insert(time,$currtime);
     $vdata->insert(videoid,$videoinfo['videoid']);
     $vdata->execute(insert);
     
     //refresh
     $attilitus->redirect("videogallery.php?videoid=$videoinfo[videoid]");
     
         
     }
      
      
     //Time to rate
     $attilitus->clean(p,ratingsubmit,str);
     
     if($attilitus->clean['ratingsubmit']==yes){
         
     $attilitus->clean(p,rating,uint);
     
     //perform security checks
     if(!$masterperms['canrate']){
      standard_error("      ");   
     }
     if($vbulletin->userinfo['userid']==$videoinfo['userid']){
      standard_error("      ");   
     }
     //Process array of users who have already voted.
     $voterarray=unserialize($videoinfo['voterarray']);
     if($voterarray){
     if(array_key_exists($vbulletin->userinfo['userid'],$voterarray)){
         $votevalue=$voterarray[$vbulletin->userinfo['userid']];
      standard_error("         $votevalue ");   
     }
     }
     $rating=$attilitus->clean['rating'];
     if($rating==1 OR $rating==2 OR $rating==3 OR $rating==4 OR $rating==5){
      //add voter to the voter array
      $voterarray[$vbulletin->userinfo['userid']]=$rating;
      
      //recount average rating.
      $total=0;
      $votecount=0;
      foreach($voterarray AS $value){
       $total=$total+$value;
       $votecount++;
      }
      $averagerating=$total/$votecount;
      
      //Consolidate information and update.
      $videoinfo['rating']=$averagerating;
      $videoinfo['voterarray']=serialize($voterarray);
      $videoinfo['votecount']=$videoinfo['votecount']+1;
      
      $vdata->set(vgal_videos);
      $vdata->update(rating,$videoinfo['rating']);
      $vdata->update(voterarray,$videoinfo['voterarray']);
      $vdata->update(votecount,$videoinfo['votecount']);
      $vdata->where(videoid,$videoinfo['videoid']);
      $vdata->execute(update);
      
      //refresh the page
      $attilitus->redirect("videogallery.php?videoid=$videoinfo[videoid]");
                                     
     }
     }
      
      
      
      
      $canmove = false;
      $candelete = false;
      //lets check if this user has permissions to delete this video.
      if ($vbulletin->userinfo['userid'] == $videoinfo['userid'] or $masterperms['admin']) {
          $candelete = true;
          $canmove = true;
      }
      
      if ($canmove) {
       //fetch a listing of categories.
       $vdata->set(vgal_categories);
       $vdata->select('*');
       $categorylist=$vdata->execute(select);
       
       while($categorylistinfo=$vbulletin->db->fetch_array($categorylist)){
           $attilitus->buildtemplate(vgal_movevideobits);   
       }
       
       //Now clean input
       $attilitus->clean(p,movevideo,str);
       $attilitus->clean(p,movevideo_catid,uint);
       
       if($attilitus->clean['movevideo']==yes){
        //check to make sure that the category we are moving to exists.
        $vdata->set(vgal_categories);
        $vdata->select('*');
        $vdata->where(catid,$attilitus->clean['movevideo_catid']);
        $newcategoryinfo=$vdata->execute(select1);
        
        if(!$newcategoryinfo){
         standard_error("    ");   
        }
        if($newcategoryinfo['catid']==$categoryinfo['catid']){
         standard_error("     ");   
        }
        
        //Perform the move
        $vdata->set(vgal_videos);
        $vdata->update(catid,$newcategoryinfo['catid']);
        $vdata->where(videoid,$videoinfo['videoid']);
        $vdata->execute(update);
        
        //update video counts
        $newcategoryinfo['videocount']=$newcategoryinfo['videocount']+1;
        $categoryinfo['videocount']=$categoryinfo['videocount']-1;
        $vdata->set(vgal_categories);
        $vdata->update(videocount,$newcategoryinfo['videocount']);
        $vdata->where(catid,$newcategoryinfo['catid']);
        $vdata->execute(update);
        
        $vdata->set(vgal_categories);
        $vdata->update(videocount,$categoryinfo['videocount']);
        $vdata->where(catid,$categoryinfo['catid']);
        $vdata->execute(update);
        
        //Refresh
        $attilitus->redirect("videogallery.php?videoid=$videoinfo[videoid]");
        
       }   
      }

      if ($candelete) {
          $attilitus->clean(p,removevideo,str);
          if ($attilitus->clean['removevideo'] == yes) {
              $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vgal_videos WHERE videoid={$videoinfo['videoid']}");
              $vdata->set(vgal_categories);
              $categoryinfo['videocount'] = $categoryinfo['videocount'] - 1;
              $vdata->update(videocount, $categoryinfo['videocount']);
              $vdata->execute(update);
              $attilitus->redirect("videogallery.php?catid=$categoryinfo[catid]");
          }
      }
      
      //lets deal with comments
      
      
      $attilitus->clean(g,page,uint);
      
      $pageinfo=$attilitus->pages(page,$vgal['CommentsPerPage'],'vgal_comments');
      
      $nextpage=$pageinfo['next'];
      $prevpage=$pageinfo['prev'];
      
      $vdata->set(vgal_comments);
      $vdata->select('*');
      $vdata->order(time,desc);
      $vdata->limit($pageinfo['limit'],$vgal['CommentsPerPage']);
      $vdata->where(videoid,$videoinfo['videoid']);
      $comments=$vdata->execute(select);
      
      while($commentinfo=$vbulletin->db->fetch_array($comments)){
      	//parse bbcode in comments
      	$commentinfo['comment']=$parser->do_parse($commentinfo['comment']);
      	$commentinfo['time'] = vbdate("F j, Y, g:i a", $commentinfo['time']);
        if($commentinfo['userid']==$vbulletin->userinfo['userid'] OR $masterperms['admin']){
         $showdelete=true;   
        }
  
  
              eval($attilitus->buildtemplate('vgal_videocommentbits'));      	
      }
      $attilitus->clean(g,deletecomment,uint);
      
      if($attilitus->clean['deletecomment']){

          $vdata->set(vgal_comments);
          $vdata->select('*');
          $vdata->where(commentid,$attilitus->clean['deletecomment']);
          $commentinfo=$vdata->execute(select1);
          
          if(!$commentinfo){
           standard_error("   ");   
          }
          
       if(!$masterperms['admin'] AND $attilitus->clean['userid']!=$commentinfo['userid']){
         standard_error("       ");  
       }
       
       $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vgal_comments WHERE commentid={$commentinfo['commentid']}");
       $attilitus->redirect("videogallery.php?videoid=$videoinfo[videoid]");
       
       
       
          
      }
      
      
      
      //Variable $videoinfo['code'] now contains the full html embed code that we need.   
      //Navbits for user navigation
      $navbits = array();
      $navbits['videogallery.php'] = '  ';
      $navbits["videogallery.php?catid=$videoinfo[catid]"] = "$categoryinfo[name]";
      $navbits["videogallery.php?videoid=$videoinfo[videoid]"] = "View Video: $videoinfo[name]";
      $navbits = construct_navbits($navbits);
      
      //Pull for use
      eval('$navbar = "' . fetch_template('navbar') . '";');
      
      //Fetch and load.
      eval('print_output("' . fetch_template('vgal_viewvideo') . '");');
      ////   
  }
  
  if ($attilitus->clean['catid']) {
      if (!$attilitus->clean['do']) {
          $attilitus->clean['do'] = view;
      }
      //category specific stuff
      //First lets make sure this cateogry exists.
      $vdata->set(vgal_categories);
      $vdata->select('*');
      $vdata->where(catid, $attilitus->clean['catid']);
      $categoryinfo = $vdata->execute(select1);
      if (!$categoryinfo) {
          standard_error("   ");
      }
      if ($attilitus->clean['do'] == view) {
          $attilitus->clean(g,page,uint);
      $pageinfo=$attilitus->pages(page,$vgal['VideosPerPage'],vgal_videos);
      $nextpage=$pageinfo['next'];
      $prevpage=$pageinfo['prev'];
          
          $vdata->set(vgal_videos);
          $vdata->select('*');
          $vdata->where(catid, $categoryinfo['catid']);
          $vdata->order(time, desc);
          $vdata->limit($pageinfo['limit'], $vgal['VideosPerPage']);
          $videos = $vdata->execute(select);
          
          $i = 0;
          while ($video = $vbulletin->db->fetch_array($videos)) {
              $i++;
              $video['rating']=round($video['rating'],2);
              eval($attilitus->buildtemplate(vgal_videobits));
          }
          if ($i == 0) {
              $novideos = true;
          }
          
          
          //Now lets do the same thing for the videos but order them by rating.
          $attilitus->clean(g,page2,uint);
          
      $pageinfo=$attilitus->pages(page2,$vgal['VideosPerPage'],vgal_videos);
      $nextpage2=$pageinfo['next'];
      $prevpage2=$pageinfo['prev'];
      

          

          
          $vdata->set(vgal_videos);
          $vdata->select('*');
          $vdata->where(catid, $categoryinfo['catid']);
          $vdata->order(rating, desc);
          $vdata->limit($pageinfo['limit'], $vgal['VideosPerPage']);
          $videos2 = $vdata->execute(select);
          
          $i = 0;
          while ($video = $vbulletin->db->fetch_array($videos2)) {
              $i++;
              $video['rating']=round($video['rating'],2);
              eval($attilitus->buildtemplate(vgal_videobitsRated)); 
          }
          if ($i == 0) {
              $novideosrating = true;
          }
          
          
          
          //Navbits for user navigation
          $navbits = array();
          $navbits['videogallery.php'] = '  ';
          $navbits["videogallery.php?cat={$categoryinfo['catid']}"] = $categoryinfo['name'];
          $navbits = construct_navbits($navbits);
          
          //Pull for use
          eval('$navbar = "' . fetch_template('navbar') . '";');
          
          //Fetch and load.
          eval('print_output("' . fetch_template('vgal_categoryvideos') . '");');
          ////
      }
      //We now have valid information for the category in variable $categoryinfo
      
      if ($attilitus->clean['do'] == addvideo) {
          if (!$masterperms['upload'] and !$masterperms['admin']) {
              standard_error("       ");
          }
          //clean required variables
          $attilitus->clean(p,videoname,str);
          $attilitus->clean(p,videodescription,nohtml);
          $attilitus->clean(p,videotype,uint);
          $attilitus->clean(p,videocode,str);
          $attilitus->clean(p,postcheck,str);
          
          $vdata->set(vgal_videotypes);
          $vdata->select('*');
          $vdata->where(active, 2);
          $videotypes = $vdata->execute(select);
          
          if ($attilitus->clean['postcheck'] == yes) {
              //Post data exists.
              //Make sure required info exists and is valid.
              if (!$attilitus->clean['videoname']) {
                  standard_error("   ");
              }
              if (!$attilitus->clean['videodescription']) {
                  standard_error("   ");
              }
              if (!$attilitus->clean['videotype']) {
                  standard_error("  / ");
              }
              if (!$attilitus->clean['videocode']) {
                  standard_error("  / ");
              }
              
              //Check the database to make sure the videotype ID is valid.
              $vdata->set(vgal_videotypes);
              $vdata->select('*');
              $vdata->where(typeid, $attilitus->clean['videotype']);
              $vdata->where(active, 2);
              $typeinfo = $vdata->execute(select1);
              if (!$typeinfo) {
                  standard_error("/  ");
              }
              $vdata->set(vgal_videos);
              $vdata->insert(name, $attilitus->clean['videoname']);
              $vdata->insert(description, $attilitus->clean['videodescription']);
              $vdata->insert(typeid, $attilitus->clean['videotype']);
              $vdata->insert(code, $attilitus->clean['videocode']);
              $vdata->insert(userid, $vbulletin->userinfo['userid']);
              $vdata->insert(username, $vbulletin->userinfo['username']);
              $vdata->insert(catid, $categoryinfo['catid']);
              $currtime = time();
              $vdata->insert(time, $currtime);
              $vdata->execute(insert);
              $videoid = $vbulletin->db->insert_id();
              //increment category video count
              $categoryinfo['videocount']++;
              $vdata->set(vgal_categories);
              $vdata->update(videocount, $categoryinfo['videocount']);
              $vdata->where(catid, $categoryinfo['catid']);
              $vdata->execute(update);
              $attilitus->redirect("videogallery.php?videoid=$videoid");
          }
          while ($videotype = $vbulletin->db->fetch_array($videotypes)) {
              eval($attilitus->buildtemplate(vgal_videotypebits));
          }
          //Navbits for user navigation
          $navbits = array();
          $navbits['videogallery.php'] = '  ';
          $navbits["videogallery.php?cat={$categoryinfo['catid']}"] = $categoryinfo['name'];
          $navbits["videogallery.php?cat={$categoryinfo['catid']}&do=addvideo"] = ' ';
          $navbits = construct_navbits($navbits);
          
          //Pull for use
          eval('$navbar = "' . fetch_template('navbar') . '";');
          
          //Fetch and load.
          eval('print_output("' . fetch_template('vgal_addvideo') . '");');
          ////   
      }
  }
  
  if (!$attilitus->clean['do']) {
      //Display Category List
      $vdata->set(vgal_categories);
      $vdata->select('*');
      $vdata->where(open, 2);
      $vdata->order(weight, asc);
      $categories = $vdata->execute(select);
      
      while ($category = $vbulletin->db->fetch_array($categories)) {
          eval($attilitus->buildtemplate(vgal_categorybits));
      }
      
      //Navbits for user navigation
      $navbits = array();
      $navbits['videogallery.php'] = '  ';
      $navbits = construct_navbits($navbits);
      
      //Pull for use
      eval('$navbar = "' . fetch_template('navbar') . '";');
      
      //Fetch and load.
      eval('print_output("' . fetch_template('vgal_categorypage') . '");');
      ////   
  }
  
  
  if ($masterperms['admin']) {
      //start admin only functions
      if ($attilitus->clean['do'] == addcategory) {
          //clean required variables
          $attilitus->clean(p,categoryname,str);
          $attilitus->clean(p,categorydescription,nohtml);
          $attilitus->clean(p,categoryweight,uint);
          $attilitus->clean(p,open,uint);
          $attilitus->clean(p,postcheck,str);

          
          if ($attilitus->clean['postcheck'] == yes) {
              //Post Data Exists, lets process it.
              
              //First lets make sure the post data exists and is valid.
              if (!$attilitus->clean['categoryname']) {
                  standard_error("   ");
              }
              if (!$attilitus->clean['categorydescription']) {
                  standard_error("   ");
              }
              if (!$attilitus->clean['categoryweight']) {
                  standard_error("   ");
              }
              if ($attilitus->clean['open'] != 1 and $attilitus->clean['open'] != 2) {
                  standard_error("           ");
              }
              
              //All data exists, and is valid at this point.
              
              //Add data to the database
              $vdata->set(vgal_categories);
              $vdata->insert(name, $attilitus->clean['categoryname']);
              $vdata->insert(description, $attilitus->clean['categorydescription']);
              $vdata->insert(weight, $attilitus->clean['categoryweight']);
              $vdata->insert(open, $attilitus->clean['open']);
              $vdata->execute(insert);
              $attilitus->redirect('videogallery.php');
          }
          
          //Navbits for user navigation
          $navbits = array();
          $navbits['videogallery.php'] = '  ';
          $navbits['videogallery.php?do=addcategory'] = ' ';
          $navbits = construct_navbits($navbits);
          
          //Pull for use
          eval('$navbar = "' . fetch_template('navbar') . '";');
          
          //Fetch and load.
          eval('print_output("' . fetch_template('vgal_addcategory') . '");');
          ////
      }
      
      if ($attilitus->clean['do'] == addtype) {
          $code = '$code';
          
          $attilitus->clean(p,typename,str);
          $attilitus->clean(p,active,uint);
          $attilitus->clean(p,code,nohtml);
          $attilitus->clean(p,weight,nohtml);
          $attilitus->clean(p,postcheck,str);

          if ($attilitus->clean['postcheck'] == yes) {
              if (!$attilitus->clean['typename']) {
                  standard_error("   / ");
              }
              if ($attilitus->clean['active'] != 1 and $attilitus->clean['active'] != 2) {
                  standard_error("    ");
              }
              if (!$attilitus->clean['code']) {
                  standard_error("    ");
              }
              if (!$attilitus->clean['weight']) {
                  standard_error("   ");
              }
              
              
              //process code and determine if it is formatted correctly.
              $codecheck = $attilitus->clean['code'];
              $codecheck1 = str_replace('$code', '', $codecheck);
              if ($codecheck == $codecheck1) {
                  standard_error(' :           $code    ($code          )');
              }
              
              //Ok... we've done all we can to make sure they formatted it right.
              //Time to add info to database.
              $vdata->set(vgal_videotypes);
              $vdata->insert(name, $attilitus->clean['typename']);
              $vdata->insert(active, $attilitus->clean['active']);
              $vdata->insert(code, $attilitus->clean['code']);
              $vdata->insert(weight, $attilitus->clean['weight']);
              $vdata->execute(insert);
          }
          
          
          //Navbits for user navigation
          $navbits = array();
          $navbits['videogallery.php'] = '  ';
          $navbits['videogallery.php?do=addtype'] = '  ';
          $navbits = construct_navbits($navbits);
          
          //Pull for use
          eval('$navbar = "' . fetch_template('navbar') . '";');
          
          //Fetch and load.
          eval('print_output("' . fetch_template('vgal_addtype') . '");');
          ////    
      }
      
      if ($attilitus->clean['do'] == edittypes) {
          $vdata->set(vgal_videotypes);
          $vdata->select('*');
          $vdata->order(weight, asc);
          $types = $vdata->execute(select);
          $typecount = 0;
          while ($type = $vbulletin->db->fetch_array($types)) {
              $typearray[$typecount] = $type;
              //convert html chars
              $type['code'] = html_entity_decode($type['code']);
              eval($attilitus->buildtemplate(vgal_edittypebits));
              $typecount++;
          }
          
          //Ok now lets check for input
          $attilitus->clean(p,postcheck,str);
          
          if ($attilitus->clean['postcheck'] == yes) {
              //we have post info.
              //Lets clean all the required slots for all the categories.
              $i = 0;
              while ($i < $typecount) {
                  //lets build an array of the info for each category as inputted.
                  $attilitus->clean(p,"typename$i",str);
                  $attilitus->clean(p,"code$i",NOHTML);
                  
                  $attilitus->clean(p,"weight$i",uint);
                  $attilitus->clean(p,"active$i",uint);

                  $currtype = $typearray[$i];
                  
                  $codecheck = $vbulletin->GPC["code$i"];
                  $codecheck1 = str_replace('$code', '', $codecheck);
                  if ($codecheck == $codecheck1) {
                      $code_error = true;
                  }
                  
                  
                  $vdata->set(vgal_videotypes);
                  $vdata->update(name, $attilitus->clean["typename$i"]);
                  $vdata->update(code, $attilitus->clean["code$i"]);
                  $vdata->update(weight, $attilitus->clean["weight$i"]);
                  $vdata->update(active, $attilitus->clean["active$i"]);
                  $vdata->where(typeid, $currtype['typeid']);
                  $vdata->execute(update);
                  
                  $i++;
              }
              if ($code_error) {
                  standard_error('              $code    ($code          )');
              }
              $attilitus->redirect("videogallery.php?do=edittypes");
          }
          //Navbits for user navigation
          $navbits = array();
          $navbits['videogallery.php'] = '  ';
          $navbits['videogallery.php?do=edittypes'] = ' ';
          $navbits = construct_navbits($navbits);
          
          //Pull for use
          eval('$navbar = "' . fetch_template('navbar') . '";');
          
          //Fetch and load.
          eval('print_output("' . fetch_template('vgal_edittypes') . '");');
          ////    
      }
      
      if ($attilitus->clean['do'] == editcategories) {
          $vdata->set(vgal_categories);
          $vdata->select('*');
          $vdata->order(weight, asc);
          $categories = $vdata->execute(select);
          $categorycount = 0;
          while ($category = $vbulletin->db->fetch_array($categories)) {
              $categoryarray[$categorycount] = $category;
              
              eval($attilitus->buildtemplate(vgal_editcategorybits));
              $categorycount++;
          }
          
          //Ok now lets check for input
          $attilitus->clean(p,postcheck,str);
          
          if ($attilitus->clean['postcheck'] == yes) {
              //we have post info.
              //Lets clean all the required slots for all the categories.
              $i = 0;
              while ($i < $categorycount) {
                  //lets build an array of the info for each category as inputted.
                  
                  $attilitus->clean(p,"categoryname$i",str);
                  $attilitus->clean(p,"categorydescription$i",nohtml);
                  $attilitus->clean(p,"weight$i",uint);
                  $attilitus->clean(p,"open$i",uint);

                  $currcategory = $categoryarray[$i];
                  
                  $vdata->set(vgal_categories);
                  $vdata->update(name, $attilitus->clean["categoryname$i"]);
                  $vdata->update(description, $attilitus->clean["categorydescription$i"]);
                  $vdata->update(weight, $attilitus->clean["weight$i"]);
                  $vdata->update(open, $attilitus->clean["open$i"]);
                  $vdata->where(catid, $currcategory['catid']);
                  $vdata->execute(update);
                  
                  $i++;
              }
              $attilitus->redirect("videogallery.php?do=editcategories");
          }
          //Navbits for user navigation
          $navbits = array();
          $navbits['videogallery.php'] = '  ';
          $navbits['videogallery.php?do=editcategories'] = ' ';
          $navbits = construct_navbits($navbits);
          
          //Pull for use
          eval('$navbar = "' . fetch_template('navbar') . '";');
          
          //Fetch and load.
          eval('print_output("' . fetch_template('vgal_editcategories') . '");');
          ////   
      }
      
      if ($attilitus->clean['do'] == deletecategories) {
          $vdata->set(vgal_categories);
          $vdata->select('*');
          $categories = $vdata->execute(select);
          $categorycount = 0;
          while ($category = $vbulletin->db->fetch_array($categories)) {
              $categoryarray[$categorycount] = $category;
              eval($attilitus->buildtemplate(vgal_deletecategorybits));
              
              $categorycount++;
          }
          $attilitus->clean(p,postcheck,str);
          if ($attilitus->clean['postcheck'] == yes) {
              //we have post data lets use it!
              $i = 0;
              while ($i < $categorycount) {
                  $currcategory = $categoryarray[$i];
                  $vbulletin->input->clean_gpc('p', "delete$i", TYPE_STR);
                  if ($attilitus->clean["delete$i"] == yesdelete and $currcategory['catid']) {
                      $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vgal_categories WHERE catid={$currcategory['catid']}");
                  }
                  $i++;
              }
              $attilitus->redirect("videogallery.php?do=deletecategories");
          }
          
          //Navbits for user navigation
          $navbits = array();
          $navbits['videogallery.php'] = '  ';
          $navbits["videogallery.php?do=deletecategories"] = ' ';
          $navbits = construct_navbits($navbits);
          
          //Pull for use
          eval('$navbar = "' . fetch_template('navbar') . '";');
          
          //Fetch and load.
          eval('print_output("' . fetch_template('vgal_deletecategories') . '");');
          //// 
      }
      
      if ($attilitus->clean['do'] == deletetypes) {
          $vdata->set(vgal_videotypes);
          $vdata->select('*');
          $types = $vdata->execute(select);
          $typecount = 0;
          while ($type = $vbulletin->db->fetch_array($types)) {
              $typearray[$typecount] = $type;
              eval($attilitus->buildtemplate(vgal_deletetypebits));
              $typecount++;
          }
          $attilitus->clean(p,postcheck,str);

          if ($attilitus->clean['postcheck'] == yes) {
              //we have post data lets use it!
              $i = 0;
              while ($i < $typecount) {
                  $currtype = $typearray[$i];

                  $attilitus->clean(p,"delete$i",str);
                  
                  if ($attilitus->clean["delete$i"] == yesdelete and $currtype['typeid']) {
                      $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vgal_videotypes WHERE typeid={$currtype['typeid']}");
                  }
                  $i++;
              }
              $attilitus->redirect("videogallery.php?do=deletetypes");
          }
          
          //Navbits for user navigation
          $navbits = array();
          $navbits['videogallery.php'] = '  ';
          $navbits["videogallery.php?do=deletetypes"] = ' ';
          $navbits = construct_navbits($navbits);
          
          //Pull for use
          eval('$navbar = "' . fetch_template('navbar') . '";');
          
          //Fetch and load.
          eval('print_output("' . fetch_template('vgal_deletetypes') . '");');
          //// 
      }
  }
?>