/*  Prototype JavaScript framework, version 1.4.0
 *  (c) 2005 Sam Stephenson <sam@conio.net>
 *
 *  Prototype is freely distributable under the terms of an MIT-style license.
 *  For details, see the Prototype web site: http://prototype.conio.net/
 *
 *  Modified for vBulletin use.
/*--------------------------------------------------------------------------*/

var spymax;
var highestid;
var play = 1;

var whats = new Array();
var titles = new Array();
var previews = new Array();
var posters = new Array();
var threadids = new Array();
var postids = new Array();
var userids = new Array();
var spyids = new Array();
var forumids = new Array();
var forumnames = new Array();
var views = new Array();
var replies = new Array();
var whens = new Array();
var lastposts = new Array();
var statusicons = new Array();
var rowClass = 'alt1';

/* Effect delay of fade-in */
var fadetime = .25;

/* Time delay between updates to table while scrolling */
var pushtime = 1000;

/*--

This must include both slashes: i.e.

var vburl='/forum/';

Use this is you integrate outside /forum with a portal or other product

*/
var vburl = '';

/* Delay between polls to the XML feed for new updates to page */
var xmldelay = 7000;

function spyinit() {
	getXML();
}

function getXML() {
	if (highestid > 0) {
		var querystring = "do=xml&last=" + highestid;
	} else {
		var querystring = "do=xml";
	}

	querystring = querystring + '&r=' + Math.random();

    if (document.getElementById("subscribe")) {
        if (document.getElementById("subscribe").checked) { querystring = querystring + "&subscribe=1"; }
    }

	var url = vburl + "vaispy.php";
	var myAjax = null;

	myAjax = new Ajax.Request(
	url,
		{
			method: 'get',
			asynchronous: true,
			parameters: querystring,
			onComplete: processXML
		});
}

function processXML(request) {
	var events;
	var event;

	try {
		events = request.responseXML.getElementsByTagName("events")[0];
		event = events.getElementsByTagName("event");
		if (event.length == 0) {
			setTimeout("getXML()", xmldelay);
			return;
		}
	}

	catch (e) {
		setTimeout("getXML()", xmldelay);
		return;
	}

	for (i = 0; i < event.length; i++) {
		try {
			whats[i] = event[i].getElementsByTagName("what")[0].firstChild.nodeValue;
		}
		catch (e) {
			whats[i] = "Unknown";
		}

		try {
			whens[i] = event[i].getElementsByTagName("when")[0].firstChild.nodeValue;
		}
		catch (e) {
			whens[i] = "";
		}

		try {
			titles[i] = event[i].getElementsByTagName("title")[0].firstChild.nodeValue;
		}
		catch (e) {
			titles[i] = "";
		}

		try {
			previews[i] = event[i].getElementsByTagName("preview")[0].firstChild.nodeValue;
		}
		catch (e) {
			previews[i] = "";
		}

		try {
			posters[i] = event[i].getElementsByTagName("poster")[0].firstChild.nodeValue;
		}
		catch (e) {
			posters[i] = "Guest";
		}

		try {
			threadids[i] = event[i].getElementsByTagName("threadid")[0].firstChild.nodeValue;
		}
		catch (e) {
			threadids[i] = "";
		}

		try {
			postids[i] = event[i].getElementsByTagName("postid")[0].firstChild.nodeValue;
		}
		catch (e) {
			postids[i] = "";
		}

		try {
			lastposts[i] = event[i].getElementsByTagName("lastpost")[0].firstChild.nodeValue;
		}
		catch (e) {
			lastposts[i] = "";
		}

		try {
			userids[i] = event[i].getElementsByTagName("userid")[0].firstChild.nodeValue;
		}
		catch (e) {
			userids[i] = "";
		}

		try {
			spyids[i] = event[i].getElementsByTagName("id")[0].firstChild.nodeValue;
		}
		catch (e) {
			spyids[i] = 1;
		}

		try {
			forumids[i] = event[i].getElementsByTagName("forumid")[0].firstChild.nodeValue;
		}
		catch (e) {
			forumids[i] = 1;
		}

		try {
			forumnames[i] = event[i].getElementsByTagName("forumname")[0].firstChild.nodeValue;
		}
		catch (e) {
			forumnames[i] = 1;
		}

		try {
			views[i] = event[i].getElementsByTagName("views")[0].firstChild.nodeValue;
		}
		catch (e) {
			views[i] = 1;
		}

		try {
			replies[i] = event[i].getElementsByTagName("replies")[0].firstChild.nodeValue;
		}
		catch (e) {
			replies[i] = 1;
		}

		try {
			statusicons[i] = event[i].getElementsByTagName('statusicon')[0].firstChild.nodeValue;
		}
		catch (e) {
		    statusicons[i] = 1;
		}
	}

	push();
}

function push() {
	if (play == 0) {
		setTimeout("push()", 1000);
		return;
	}

	var cell;
	var cellnext;
	var text;
	var clip;
	var poster_clip = '';
	var where = '';
	var post_url;
	var style = '';

	var what = whats.pop();
	var when = whens.pop();
	var title = titles.pop();
	var preview = previews.pop();
	var poster = posters.pop();
	var threadid = threadids.pop();
	var postid = postids.pop();
	var userid = userids.pop();
	var spyid = spyids.pop();
	var forumid = forumids.pop();
	var forumname = forumnames.pop();
	var view = views.pop();
	var numreplies = replies.pop();
	var lastpost = lastposts.pop();
	var statusicon = statusicons.pop();

	rowClass = rowClass == 'alt2' ? 'alt1' : 'alt2';
	highestid = Math.max(parseInt(spyid), highestid);

	if (vB_PHP_Emulator.prototype.stripos(what, 'thread')) {
		post_url = vburl + 'showthread.php?t=' + threadid;
	} else {
		post_url = vburl + 'showthread.php?p=' + spyid + '#post' + spyid;
	}

	if(title.length == 0) {
		clip = '<strong>Unknown</strong>';
	} else {
		clip = '<img src="' + statusicon + '" alt="" /><strong><a href="' + post_url + '">' + title + '</a></strong>';
	}

	if (preview.length > 0) {
	    clip = clip + '<br />' + preview ;
	}

    clip = clip + ' (' + view + ' views, ' + numreplies + ' replies)';

	if (userid.length > 0) {
		poster_clip = '<a href="' + vburl + 'member.php?u=' + userid + '">' + poster + '</a>';
	}

    poster_clip = poster_clip + '<br />' + when;

	if (parseInt(forumname.length) > 0) {
		where = where + '<strong><a href="' + vburl + 'forumdisplay.php?f=' + forumid + '">' + forumname + '</a></strong>';
	} else {
		where = '';
	}

    if (is_opera) {
        text = '<table cellpadding="3" cellspacing="0" border="0" width="100%"><tr><td width="20" class="' + rowClass + ' smallfont" nowrap="nowrap" align="center">' + what + '</td><td class="' + rowClass + ' smallfont" width="225" nowrap="nowrap" align="left">' + poster_clip + '</td><td class="' + rowClass + ' smallfont" width="80%">' + clip + '</td><td class="' + rowClass + ' smallfont" width="200" nowrap="nowrap" align="center">' + where + '</td></tr></table>';
	} else {
	    text = '<td class="' + rowClass + ' smallfont" align="center">' + what + '</td><td class="' + rowClass + ' smallfont">' + poster_clip + '</td><td class="' + rowClass + ' smallfont">' + clip + '</td><td align="center" class="' + rowClass + ' smallfont">' + where + '</td>';
    }

	Element.setOpacity('row1', 0.0);

	if (is_ie) {
		for (i = (spymax - 1); i >= 1; i--) {
			cell = document.getElementById("spy_table").rows[i];
			cellnext = document.getElementById("spy_table").rows[i + 1];
			if (cell.innerHTML.length > 31) {
				cellnext.cells[0].innerHTML = cell.cells[0].innerHTML;
				cellnext.cells[1].innerHTML = cell.cells[1].innerHTML;
				cellnext.cells[2].innerHTML = cell.cells[2].innerHTML;
				cellnext.cells[3].innerHTML = cell.cells[3].innerHTML;
				cellnext.style.display = '';
			}
		}

		document.getElementById("row1").cells[0].innerHTML = '<div class="smallfont">' + what + '</div>';
		document.getElementById("row1").cells[1].innerHTML = '<div class="smallfont">' + poster_clip + '</div>';
		document.getElementById("row1").cells[2].innerHTML = '<div class="smallfont">' + clip + '</div>';
		document.getElementById("row1").cells[3].innerHTML = '<div class="smallfont">' + where + '</div>';
	} else {
		for (i = (spymax - 1); i >= 1; i--) {
			cell = document.getElementById("row" + i);
			cellnext = document.getElementById("row" + (i + 1));
			if (cell.innerHTML != "") {
				cellnext.innerHTML = cell.innerHTML;
				cellnext.style.display = '';
			}
		}
		document.getElementById("row1").innerHTML = text;
	}

	Effect.Appear('row1', { duration: fadetime });

	if (whats.length > 0) {
		setTimeout("push()", pushtime);
	}
	else {
		setTimeout("getXML()", xmldelay);
	}
}