<?php
/*======================================================================*\
|| #################################################################### ||
|| # New Members Page v1.0.3                                          # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2006-2007 Eric Sizemore (SecondV). All Rights Reserved.# ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'newmembers');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('user');

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
	'newmembers',
	'newmembers_results'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################
if (!($permissions['forumpermissions'] & $vbulletin->bf_ugp_forumpermissions['canview']) OR !($permissions['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canviewmembers']) OR (!$vbulletin->options['newmembers_enabled'] AND !$vbulletin->options['newmembers_limit']))
{
	print_no_permission();
}

// Default vars
$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);

$now = (TIMENOW - ($vbulletin->options['newmembers_daylimit'] * 24 * 60 * 60)) - $vbulletin->options['timeoffset'];
$cutoff = mktime(0, 0, 0, date('m', $now), date('d', $now), date('Y', $now));

// User count
$member_count = $db->query_first_slave("
	SELECT COUNT(userid) AS count
	FROM " . TABLE_PREFIX . "user
	WHERE joindate >= $cutoff
	ORDER BY joindate DESC
	LIMIT " . $vbulletin->options['newmembers_limit'] . "
");
$member_count = $member_count['count'];

// No new registrations?
if (!$member_count)
{
	$newmemberbits = "<tr>\n\t<td class=\"alt1\" colspan=\"3\">$vbphrase[newmembers_none]</td>\n</tr>";
}
else
{
	// Begin pagination
	sanitize_pageresults($member_count, $pagenumber, $perpage, 100, $vbulletin->options['newmembers_limit']);

	// Default lower and upper limit variables
	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = $pagenumber * $perpage;

	if ($limitupper > $member_count)
	{
		// Too many for upper limit
		$limitupper = $member_count;

		if ($limitlower > $member_count)
		{
			// Too many for lower limit
			$limitlower = $member_count - $perpage;
		}
	}

	if ($limitlower <= 0)
	{
		// Can't have negative or null lower limit
		$limitlower = 1;
	}

	// Finally, let's get the members along w/avatar and profile pic.
	$getnewmembers = $db->query_read("
		SELECT user.userid, user.username, user.joindate, avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, customprofilepic.userid AS profilepic, customprofilepic.dateline AS profilepicdateline, customprofilepic.width AS ppwidth, customprofilepic.height AS ppheight
		FROM " . TABLE_PREFIX . "user AS user
		LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid)
		LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "customprofilepic AS customprofilepic ON (user.userid = customprofilepic.userid)
		WHERE user.joindate >= $cutoff
		ORDER BY user.joindate DESC
		LIMIT " . ($limitlower - 1) . ", $perpage
	");

	$counter = 0;
	$newmemberbits = '';

	while ($newmembers = $db->fetch_array($getnewmembers) AND $counter++ < $perpage)
	{
		// Profile Pic
		if ($newmembers['profilepic'])
		{
			if ($vbulletin->options['usefileavatar'])
			{
				$newmembers['profilepicurl'] = $vbulletin->options['profilepicurl'] . "/profilepic$newmembers[userid]_$newmembers[profilepicrevision].gif";
			}
			else
			{
				$newmembers['profilepicurl'] = 'image.php?' . $vbulletin->session->vars['sessionurl'] . "u=$newmembers[userid]&amp;dateline=$newmembers[profilepicdateline]&amp;type=profile";
			}

			$newmembers['profilepic'] = "<img src=\"$newmembers[profilepicurl]\" alt=\"\" title=\"$newmembers[username]'s picture\" border=\"0\"";
			$newmembers['profilepic'] .= ($newmembers['ppwidth'] AND $newmembers['ppheight']) ? " width=\"$newmembers[ppwidth]\" height=\"$newmembers[ppheight]\" " : ' ';
			$newmembers['profilepic'] .= '/>';
		}
		else
		{
			$newmembers['profilepic'] = "<img src=\"$stylevar[imgdir_misc]/" . $vbulletin->options['newmembers_defaultpic'] . "\" alt=\"\" title=\"$newmembers[username]'s picture\" border=\"0\"";

			if ($vbulletin->options['newmembers_defaultpicw'] > 0 AND $vbulletin->options['newmembers_defaultpich'] > 0)
			{
				$newmembers['profilepic'] .= ' width="' . $vbulletin->options['newmembers_defaultpicw'] . '" height="' . $vbulletin->options['newmembers_defaultpich'] . '" ';
			}

			$newmembers['profilepic'] .= '/>';
		}

		// Avatar
		$avwidth = '';
		$avheight = '';

		if ($newmembers['avatarid'])
		{
			$avatarurl = $newmembers['avatarpath'];
		}
		else
		{
			if ($newmembers['hascustomavatar'] AND $vbulletin->options['avatarenabled'])
			{
				if ($vbulletin->options['usefileavatar'])
				{
					$avatarurl = $vbulletin->options['avatarurl'] . "/avatar$newmembers[userid]_$newmembers[avatarrevision].gif";
				}
				else
				{
					$avatarurl = 'image.php?' . $vbulletin->session->vars['sessionurl'] . "u=$newmembers[userid]&amp;dateline=$newmembers[avatardateline]";
				}

				if ($newmembers['avheight'] AND $newmembers['avwidth'])
				{
					$avheight = "height=\"$newmembers[avheight]\"";
					$avwidth = "width=\"$newmembers[avwidth]\"";
				}
			}
			else
			{
				$avatarurl = $stylevar['imgdir_misc'] . '/' . $vbulletin->options['newmembers_defaultav'];
				$avheight = 'height="' . $vbulletin->options['newmembers_defaultavh'] . '"';
				$avwidth = 'width="' . $vbulletin->options['newmembers_defaultavw'] . '"';
			}
		}
		$newmembers['datejoined'] = vbdate($vbulletin->options['dateformat'], $newmembers['joindate'], true);

		$bgclass = 'alt2';
		eval('$newmemberbits .= "' . fetch_template('newmembers_results') . '";');
	}
	$db->free_result($getnewmembers);
	$pagenav = construct_page_nav($pagenumber, $perpage, $member_count, 'newmembers.php?' . $vbulletin->session->vars['sessionurl']);
}

// Navbar
$navbits = array('' => $vbphrase['newmembers']);
$navbits = construct_navbits($navbits);

// Done, spit out the HTML
eval('$navbar = "' . fetch_template('navbar') . '";');
eval('print_output("' . fetch_template('newmembers') . '");');

?>