
# Dumping table construction info for 'mos_articles'
DROP TABLE IF EXISTS mos_articles;
CREATE TABLE mos_articles (
	artid int(11) auto_increment not null,
	catid int(11) not null,
	title text not null,
	userID int(11) not null,
	author varchar(50),
	content text not null,
	date date not null default '0000-00-00',
	counter int(11) not null,
	approved tinyint(1) not null,
	archived tinyint(1) not null,
	ordering int(11) not null,
	checked_out tinyint(1) not null,
	checked_out_time time not null default '00:00:00',
	editor varchar(50),
	published tinyint(1) not null,
	PRIMARY KEY (artid),
	KEY show (artid,published,catid),
	KEY listsections (catid,approved,published,archived)
);

# Dumping table data from 'mos_articles'
INSERT INTO mos_articles SET artid="1", catid="2", title="   ", userID="0", author=" ", content="  ", date="2003-02-18", counter="9", approved="1", archived="0", ordering="1", checked_out="0", checked_out_time="00:00:00", editor="", published="1";

# Dumping table construction info for 'mos_banner'
DROP TABLE IF EXISTS mos_banner;
CREATE TABLE mos_banner (
	bid int(11) auto_increment not null,
	cid int(11) not null,
	type varchar(10) not null default 'banner',
	name varchar(50) not null,
	imptotal int(11) not null,
	impmade int(11) not null,
	clicks int(11) not null,
	imageurl varchar(100) not null,
	clickurl varchar(200) not null,
	date datetime,
	showBanner tinyint(1) not null,
	checked_out tinyint(1) not null,
	checked_out_time time,
	editor varchar(50),
	PRIMARY KEY (bid),
	KEY viewbanner (showBanner)
);

# Dumping table data from 'mos_banner'
INSERT INTO mos_banner SET bid="1", cid="1", type="banner", name="Ka-Ching", imptotal="0", impmade="184", clicks="0", imageurl="ka-chingBanner.gif", clickurl="http://www.miro.com.au", date="2003-01-01 16:12:55", showBanner="1", checked_out="0", checked_out_time="00:00:00", editor="";
INSERT INTO mos_banner SET bid="2", cid="1", type="banner", name="Mambo2002", imptotal="0", impmade="161", clicks="0", imageurl="Mambo2002Banner.gif", clickurl="www.miro.com.au", date="2003-01-01 15:20:37", showBanner="1", checked_out="0", checked_out_time="00:00:00", editor="";

# Dumping table construction info for 'mos_bannerclient'
DROP TABLE IF EXISTS mos_bannerclient;
CREATE TABLE mos_bannerclient (
	cid int(11) auto_increment not null,
	name varchar(60) not null,
	contact varchar(60) not null,
	email varchar(60) not null,
	extrainfo text not null,
	checked_out tinyint(1) not null,
	checked_out_time time,
	editor varchar(50),
	PRIMARY KEY (cid)
);

# Dumping table data from 'mos_bannerclient'
INSERT INTO mos_bannerclient SET cid="1", name="  ", contact="  ", email="Moraibt@hodejan.camle", extrainfo="", checked_out="1", checked_out_time="09:11:43", editor="Administrator";

# Dumping table construction info for 'mos_bannerfinish'
DROP TABLE IF EXISTS mos_bannerfinish;
CREATE TABLE mos_bannerfinish (
	bid int(11) auto_increment not null,
	cid int(11) not null,
	type varchar(10) not null,
	name varchar(50) not null,
	impressions int(11) not null,
	clicks int(11) not null,
	imageurl varchar(50) not null,
	datestart datetime,
	dateend datetime,
	PRIMARY KEY (bid)
);

# Dumping table data from 'mos_bannerfinish'

# Dumping table construction info for 'mos_categories'
DROP TABLE IF EXISTS mos_categories;
CREATE TABLE mos_categories (
	categoryid int(11) auto_increment not null,
	categoryname text not null,
	categoryimage varchar(50),
	section varchar(20) not null,
	image_position varchar(20),
	published tinyint(1) not null,
	checked_out tinyint(1) not null,
	checked_out_time time not null default '00:00:00',
	editor varchar(50),
	ordering int(11) not null,
	access tinyint(3) unsigned not null,
	PRIMARY KEY (categoryid),
	KEY articles (section,published,access)
);

# Dumping table data from 'mos_categories'
INSERT INTO mos_categories SET categoryid="1", categoryname=" ", categoryimage="", section="News", image_position="", published="1", checked_out="0", checked_out_time="00:00:00", editor="", ordering="0", access="0";
INSERT INTO mos_categories SET categoryid="2", categoryname=" ", categoryimage="", section="Articles", image_position="", published="1", checked_out="0", checked_out_time="00:00:00", editor="", ordering="0", access="0";
INSERT INTO mos_categories SET categoryid="4", categoryname="  ", categoryimage="", section="Weblinks", image_position="", published="1", checked_out="0", checked_out_time="00:00:00", editor="", ordering="0", access="0";
INSERT INTO mos_categories SET categoryid="3", categoryname="", categoryimage="", section="Faq", image_position="", published="1", checked_out="0", checked_out_time="00:00:00", editor="", ordering="0", access="0";
INSERT INTO mos_categories SET categoryid="5", categoryname="  ", categoryimage="", section="Articles", image_position="", published="0", checked_out="0", checked_out_time="00:00:00", editor="", ordering="0", access="0";
INSERT INTO mos_categories SET categoryid="7", categoryname="  ", categoryimage="", section="Weblinks", image_position="", published="1", checked_out="0", checked_out_time="00:00:00", editor="", ordering="0", access="0";
INSERT INTO mos_categories SET categoryid="8", categoryname="  ", categoryimage="", section="Faq", image_position="", published="1", checked_out="0", checked_out_time="00:00:00", editor="", ordering="0", access="0";

# Dumping table construction info for 'mos_component_module'
DROP TABLE IF EXISTS mos_component_module;
CREATE TABLE mos_component_module (
	id int(4) auto_increment not null,
	content text not null,
	componentid int(4) not null,
	PRIMARY KEY (id),
	KEY componentid (componentid)
);

# Dumping table data from 'mos_component_module'

# Dumping table construction info for 'mos_components'
DROP TABLE IF EXISTS mos_components;
CREATE TABLE mos_components (
	id int(11) auto_increment not null,
	title text not null,
	ordering tinyint(4) not null,
	position varchar(10),
	checked_out tinyint(1) not null,
	checked_out_time time,
	publish tinyint(1) not null,
	editor varchar(50),
	module varchar(50),
	numnews int(11) not null,
	access tinyint(3) unsigned not null,
	PRIMARY KEY (id),
	KEY publish (publish,access),
	KEY newsfeeds (module,publish)
);

# Dumping table data from 'mos_components'
INSERT INTO mos_components SET id="1", title="", ordering="2", position="left", checked_out="0", checked_out_time="00:00:00", publish="1", editor="", module="login", numnews="0", access="0";
INSERT INTO mos_components SET id="2", title="", ordering="3", position="right", checked_out="0", checked_out_time="00:00:00", publish="1", editor="", module="survey", numnews="0", access="0";
INSERT INTO mos_components SET id="3", title=" ", ordering="3", position="left", checked_out="0", checked_out_time="00:00:00", publish="0", editor="", module="newsfeeds", numnews="3", access="0";
INSERT INTO mos_components SET id="4", title=" ", ordering="2", position="right", checked_out="0", checked_out_time="00:00:00", publish="1", editor="", module="articlearchive", numnews="0", access="0";
INSERT INTO mos_components SET id="5", title=" ", ordering="1", position="right", checked_out="0", checked_out_time="00:00:00", publish="1", editor="", module="newsarchive", numnews="0", access="0";
INSERT INTO mos_components SET id="6", title=" ", ordering="3", position="left", checked_out="0", checked_out_time="00:00:00", publish="1", editor="", module="usermenu", numnews="0", access="0";
INSERT INTO mos_components SET id="7", title=" ", ordering="4", position="left", checked_out="0", checked_out_time="00:00:00", publish="1", editor="", module="whos_online", numnews="0", access="0";
INSERT INTO mos_components SET id="8", title=" ", ordering="1", position="left", checked_out="0", checked_out_time="00:00:00", publish="1", editor="", module="main_menu", numnews="0", access="0";
INSERT INTO mos_components SET id="9", title=" - ", ordering="1", position="left", checked_out="0", checked_out_time="00:00:00", publish="0", editor="", module="main_menu2", numnews="0", access="0";

# Dumping table construction info for 'mos_contact_details'
DROP TABLE IF EXISTS mos_contact_details;
CREATE TABLE mos_contact_details (
	id int(11) not null default '1',
	name varchar(100) not null,
	ACN varchar(20),
	address text,
	suburb varchar(50),
	state varchar(20),
	country varchar(50),
	postcode varchar(10),
	telephone varchar(25),
	fax varchar(25),
	email_to varchar(100),
	PRIMARY KEY (id)
);

# Dumping table data from 'mos_contact_details'
INSERT INTO mos_contact_details SET id="1", name="Your Name Here", ACN="", address="", suburb="", state="", country="", postcode="", telephone="", fax="", email_to="your_email@some-address.com";

# Dumping table construction info for 'mos_counter'
DROP TABLE IF EXISTS mos_counter;
CREATE TABLE mos_counter (
	id int(11) auto_increment not null,
	type varchar(25) not null,
	name varchar(50) not null,
	count bigint(20) not null,
	PRIMARY KEY (id),
	KEY type (type)
);

# Dumping table data from 'mos_counter'
INSERT INTO mos_counter SET id="1", type="browser", name="Netscape", count="0";
INSERT INTO mos_counter SET id="2", type="browser", name="MSIE", count="14";
INSERT INTO mos_counter SET id="3", type="browser", name="Unknown", count="0";
INSERT INTO mos_counter SET id="4", type="OS", name="Windows", count="14";
INSERT INTO mos_counter SET id="5", type="OS", name="Mac", count="0";
INSERT INTO mos_counter SET id="6", type="OS", name="Unknown", count="0";
INSERT INTO mos_counter SET id="7", type="OS", name="Linux", count="0";
INSERT INTO mos_counter SET id="8", type="OS", name="FreeBSD", count="0";
INSERT INTO mos_counter SET id="9", type="browser", name="Lynx", count="0";

# Dumping table construction info for 'mos_faqcont'
DROP TABLE IF EXISTS mos_faqcont;
CREATE TABLE mos_faqcont (
	artid int(11) auto_increment not null,
	catid int(11) not null,
	title text not null,
	content text not null,
	counter int(11) not null,
	published tinyint(1) not null,
	checked_out tinyint(1) not null,
	checked_out_time time not null default '00:00:00',
	editor varchar(50) not null,
	archived tinyint(1) not null,
	ordering int(11),
	approved tinyint(1) not null default '1',
	PRIMARY KEY (artid),
	KEY catid (catid,published,archived)
);

# Dumping table data from 'mos_faqcont'
INSERT INTO mos_faqcont SET artid="1", catid="3", title="My First Question", content="The answer would go here", counter="2", published="1", checked_out="0", checked_out_time="00:00:00", editor="", archived="0", ordering="1", approved="1";
INSERT INTO mos_faqcont SET artid="2", catid="8", title="My Second Question", content="The answer would go here", counter="2", published="1", checked_out="0", checked_out_time="00:00:00", editor="", archived="0", ordering="1", approved="1";

# Dumping table construction info for 'mos_groups'
DROP TABLE IF EXISTS mos_groups;
CREATE TABLE mos_groups (
	id tinyint(3) unsigned not null,
	name varchar(50) not null,
	PRIMARY KEY (id)
);

# Dumping table data from 'mos_groups'
INSERT INTO mos_groups SET id="0", name="Public";
INSERT INTO mos_groups SET id="1", name="Registered";
INSERT INTO mos_groups SET id="2", name="Special";

# Dumping table construction info for 'mos_links'
DROP TABLE IF EXISTS mos_links;
CREATE TABLE mos_links (
	lid int(11) auto_increment not null,
	catid int(11) not null,
	sid int(11) not null,
	title varchar(100) not null,
	url varchar(100) not null,
	description varchar(200) not null,
	date datetime,
	hits int(11) not null,
	published tinyint(1) not null,
	checked_out tinyint(1) not null,
	checked_out_time time not null default '00:00:00',
	editor varchar(50) not null,
	ordering int(11) not null,
	archived tinyint(1) not null,
	approved tinyint(1) default '1',
	PRIMARY KEY (lid),
	KEY catid (catid,published,archived)
);

# Dumping table data from 'mos_links'
INSERT INTO mos_links SET lid="1", catid="4", sid="0", title=" ", url="http://www.magtrb.com", description="     ", date="2003-02-18 11:32:45", hits="0", published="1", checked_out="1", checked_out_time="09:21:21", editor="Administrator", ordering="0", archived="0", approved="1";
INSERT INTO mos_links SET lid="2", catid="4", sid="0", title="Mambo Open Source Project", url="http://www.mamboserver.com", description="Where Mambo lives since leaving home", date="2003-02-18 11:33:24", hits="0", published="1", checked_out="0", checked_out_time="00:00:00", editor="", ordering="0", archived="0", approved="1";
INSERT INTO mos_links SET lid="3", catid="7", sid="0", title="php.net", url="http://www.php.net", description="The language that Mambo is developed in", date="2003-02-18 11:33:24", hits="0", published="1", checked_out="0", checked_out_time="00:00:00", editor="", ordering="0", archived="0", approved="1";

# Dumping table construction info for 'mos_mambo_modules'
DROP TABLE IF EXISTS mos_mambo_modules;
CREATE TABLE mos_mambo_modules (
	moduleid int(11) auto_increment not null,
	modulename varchar(50) not null,
	modulelink varchar(50),
	menuid int(4),
	PRIMARY KEY (moduleid)
);

# Dumping table data from 'mos_mambo_modules'
INSERT INTO mos_mambo_modules SET moduleid="1", modulename="Story", modulelink="index.php", menuid="1";
INSERT INTO mos_mambo_modules SET moduleid="2", modulename="Stories List", modulelink="index.php?option=news", menuid="2";
INSERT INTO mos_mambo_modules SET moduleid="3", modulename="Articles", modulelink="index.php?option=articles", menuid="3";
INSERT INTO mos_mambo_modules SET moduleid="4", modulename="Web Links", modulelink="index.php?option=weblinks", menuid="4";
INSERT INTO mos_mambo_modules SET moduleid="5", modulename="FAQ", modulelink="index.php?option=faq", menuid="5";
INSERT INTO mos_mambo_modules SET moduleid="6", modulename="Contact Us", modulelink="index.php?option=contact", menuid="6";

# Dumping table construction info for 'mos_menu'
DROP TABLE IF EXISTS mos_menu;
CREATE TABLE mos_menu (
	id int(11) auto_increment not null,
	menutype varchar(25),
	name varchar(25),
	link text,
	contenttype varchar(10),
	inuse tinyint(1) not null,
	componentid int(11),
	sublevel int(11),
	ordering int(11),
	checked_out tinyint(1) not null,
	checked_out_time time,
	editor varchar(50),
	pollid int(11) not null,
	browserNav tinyint(4),
	access tinyint(3) unsigned not null,
	PRIMARY KEY (id),
	KEY componentid (componentid,menutype,inuse,access),
	KEY menutype (menutype)
);

# Dumping table data from 'mos_menu'
INSERT INTO mos_menu SET id="1", menutype="mainmenu", name=" ", link="index.php", contenttype="mambo", inuse="1", componentid="0", sublevel="0", ordering="1", checked_out="0", checked_out_time="00:00:00", editor="", pollid="1", browserNav="0", access="0";
INSERT INTO mos_menu SET id="2", menutype="mainmenu", name="", link="index.php?option=news", contenttype="mambo", inuse="1", componentid="0", sublevel="0", ordering="2", checked_out="0", checked_out_time="00:00:00", editor="", pollid="2", browserNav="0", access="0";
INSERT INTO mos_menu SET id="3", menutype="mainmenu", name="", link="index.php?option=articles", contenttype="mambo", inuse="1", componentid="0", sublevel="0", ordering="3", checked_out="0", checked_out_time="00:00:00", editor="", pollid="0", browserNav="0", access="0";
INSERT INTO mos_menu SET id="4", menutype="mainmenu", name=" ", link="index.php?option=weblinks", contenttype="mambo", inuse="1", componentid="0", sublevel="0", ordering="4", checked_out="0", checked_out_time="00:00:00", editor="", pollid="0", browserNav="0", access="0";
INSERT INTO mos_menu SET id="5", menutype="mainmenu", name="FAQ", link="index.php?option=faq", contenttype="mambo", inuse="1", componentid="0", sublevel="0", ordering="5", checked_out="0", checked_out_time="00:00:00", editor="", pollid="0", browserNav="0", access="0";
INSERT INTO mos_menu SET id="6", menutype="mainmenu", name=" ", link="index.php?option=contact", contenttype="mambo", inuse="1", componentid="0", sublevel="0", ordering="6", checked_out="0", checked_out_time="00:00:00", editor="", pollid="0", browserNav="0", access="0";
INSERT INTO mos_menu SET id="7", menutype="usermenu", name="Your Details", link="index.php?option=user&op=UserDetails", contenttype="", inuse="0", componentid="0", sublevel="0", ordering="1", checked_out="0", checked_out_time="00:00:00", editor="", pollid="0", browserNav="0", access="0";
INSERT INTO mos_menu SET id="8", menutype="usermenu", name="Submit Article", link="index.php?option=user&op=UserArticle", contenttype="", inuse="0", componentid="0", sublevel="0", ordering="3", checked_out="0", checked_out_time="00:00:00", editor="", pollid="0", browserNav="0", access="0";
INSERT INTO mos_menu SET id="9", menutype="usermenu", name="Logout", link="index.php?option=logout", contenttype="", inuse="0", componentid="0", sublevel="0", ordering="6", checked_out="0", checked_out_time="00:00:00", editor="", pollid="0", browserNav="0", access="0";
INSERT INTO mos_menu SET id="26", menutype="usermenu", name="Submit FAQ", link="index.php?option=user&op=UserFAQ", contenttype="", inuse="0", componentid="0", sublevel="0", ordering="4", checked_out="0", checked_out_time="00:00:00", editor="", pollid="0", browserNav="0", access="0";
INSERT INTO mos_menu SET id="27", menutype="usermenu", name="Submit Weblink", link="index.php?option=user&op=UserLink", contenttype="", inuse="0", componentid="0", sublevel="0", ordering="5", checked_out="0", checked_out_time="00:00:00", editor="", pollid="0", browserNav="0", access="0";
INSERT INTO mos_menu SET id="28", menutype="usermenu", name="Submit News", link="index.php?option=user&op=UserNews", contenttype="", inuse="0", componentid="0", sublevel="0", ordering="2", checked_out="0", checked_out_time="00:00:00", editor="", pollid="0", browserNav="0", access="0";
INSERT INTO mos_menu SET id="49", menutype="mainmenu", name="Second Level", link="", contenttype="typed", inuse="1", componentid="48", sublevel="2", ordering="2", checked_out="0", checked_out_time="00:00:00", editor="", pollid="0", browserNav="0", access="0";
INSERT INTO mos_menu SET id="48", menutype="mainmenu", name="First Level", link="", contenttype="typed", inuse="1", componentid="47", sublevel="1", ordering="1", checked_out="0", checked_out_time="00:00:00", editor="", pollid="0", browserNav="0", access="0";
INSERT INTO mos_menu SET id="47", menutype="mainmenu", name=" ", link="", contenttype="typed", inuse="1", componentid="0", sublevel="0", ordering="7", checked_out="0", checked_out_time="00:00:00", editor="", pollid="0", browserNav="0", access="0";

# Dumping table construction info for 'mos_menucontent'
DROP TABLE IF EXISTS mos_menucontent;
CREATE TABLE mos_menucontent (
	mcid int(11) auto_increment not null,
	menuid int(11) not null,
	content text not null,
	heading varchar(100),
	PRIMARY KEY (mcid),
	KEY menuid (menuid)
);

# Dumping table data from 'mos_menucontent'
INSERT INTO mos_menucontent SET mcid="25", menuid="48", content="This page is on the first level of navigation under the home page.", heading="First level of navigation";
INSERT INTO mos_menucontent SET mcid="26", menuid="49", content="This is the second page in this sub-category<BR>
<IMG SRC=images/stories/messy_trashcan.jpg ALIGN=left HSPACE=6><BR>
<IMG SRC=images/stories/messy_trashcan.jpg ALIGN=left HSPACE=6><BR>", heading="second level of navigation";
INSERT INTO mos_menucontent SET mcid="24", menuid="47", content="<p align=\"center\"><a href=\"http://www.magtrb.com\" target=\"_blank\"><img border=0 src=\"http://www.magtrb.com/Globallogo/Magtrb.gif\" alt=\"\" width=88 height=31></a></p>
", heading="";

# Dumping table construction info for 'mos_newsfeedscategory'
DROP TABLE IF EXISTS mos_newsfeedscategory;
CREATE TABLE mos_newsfeedscategory (
	id int(11) auto_increment not null,
	category text not null,
	PRIMARY KEY (id),
	KEY id (id)
);

# Dumping table data from 'mos_newsfeedscategory'
INSERT INTO mos_newsfeedscategory SET id="1", category="Business: general";
INSERT INTO mos_newsfeedscategory SET id="2", category="Companies";
INSERT INTO mos_newsfeedscategory SET id="3", category="Entertainment";
INSERT INTO mos_newsfeedscategory SET id="4", category="Finance";
INSERT INTO mos_newsfeedscategory SET id="5", category="Industry";
INSERT INTO mos_newsfeedscategory SET id="6", category="Internet";
INSERT INTO mos_newsfeedscategory SET id="7", category="Lifestyle";
INSERT INTO mos_newsfeedscategory SET id="8", category="Regional";
INSERT INTO mos_newsfeedscategory SET id="9", category="Science";
INSERT INTO mos_newsfeedscategory SET id="10", category="Society";
INSERT INTO mos_newsfeedscategory SET id="11", category="Sports";
INSERT INTO mos_newsfeedscategory SET id="12", category="Technology";
INSERT INTO mos_newsfeedscategory SET id="13", category="US regional";
INSERT INTO mos_newsfeedscategory SET id="14", category="Business: media";
INSERT INTO mos_newsfeedscategory SET id="15", category="Top Stories";

# Dumping table construction info for 'mos_newsfeedslinks'
DROP TABLE IF EXISTS mos_newsfeedslinks;
CREATE TABLE mos_newsfeedslinks (
	categoryid int(11) not null,
	id int(11) auto_increment not null,
	name text not null,
	link text not null,
	filename varchar(200),
	inuse tinyint(1) not null,
	PRIMARY KEY (id),
	KEY inuse (inuse)
);

# Dumping table data from 'mos_newsfeedslinks'
INSERT INTO mos_newsfeedslinks SET categoryid="6", id="1", name="Linux Today", link="http://linuxtoday.com/backend/my-netscape.rdf", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="1", id="2", name="Internet:Business News", link="http://headlines.internet.com/internetnews/bus-news/news.rss", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="6", id="3", name="Web Developer News", link="http://headlines.internet.com/internetnews/wd-news/news.rss", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="6", id="4", name="Linux Central:New Products", link="http://linuxcentral.com/backend/lcnew.rdf", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="6", id="5", name="Linux Central:Best Selling", link="http://linuxcentral.com/backend/lcbestns.rdf", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="6", id="6", name="Linux Central:Daily Specials", link="http://linuxcentral.com/backend/lcspecialns.rdf", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="8", id="7", name="BBC: UK News", link="http://www.bbc.co.uk/syndication/feeds/news/ukfs_news/uk/rss091.xml", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="12", id="8", name="BBC: Technology", link="http://www.bbc.co.uk/syndication/feeds/news/ukfs_news/technology/rss091.xml", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="11", id="9", name="NHL", link="http://www.sportingnews.com/klip/foods/sportingNewsNHL.food", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="11", id="10", name="NASCAR", link="http://www.sportingnews.com/klip/foods/sportingNewsNASCAR.food", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="11", id="11", name="NFL", link="http://www.sportingnews.com/klip/foods/sportingNewsNFL.food", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="11", id="12", name="NBA", link="http://www.sportingnews.com/klip/foods/sportingNewsNBA.food", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="6", id="13", name="Security Forums", link="http://www.security-forums.com/klip/content_feed.php", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="4", id="14", name="Internet:Finance News", link="http://headlines.internet.com/internetnews/fina-news/news.rss", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="15", id="15", name="BBC: World News", link="http://www.bbc.co.uk/syndication/feeds/news/ukfs_news/world/rss091.xml", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="9", id="16", name="Space.com", link="http://myrss.com/f/s/p/space99znm12.rss", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="7", id="17", name="Amazon : DVD Releases", link="http://myrss.com/f/a/m/amazon102Minus3289784Minus3662556N6f8pb3.rss", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="4", id="18", name="Bloomberg", link="http://myrss.com/f/b/l/bloombergH8n6k63.rss", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="3", id="19", name="Motley Fool", link="http://www.fool.com/xml/foolnews_rss091.xml", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="12", id="20", name="PDA Buzz", link="http://www.pdabuzz.com/netscape.txt", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="3", id="21", name="Digital Theatre", link="http://www.dtheatre.com/backend.php?xml=yes", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="7", id="22", name="Cars Everything", link="http://www.carseverything.com/data/headlines.rdf", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="9", id="23", name="Beyond 2000", link="http://www.beyond2000.com/b2k.rdf", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="10", id="24", name="The Cancer Letter", link="http://www.cancerletter.com/cancerletter.xml", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="4", id="25", name="Asia Street Intelligence Ezine", link="http://www.apmforum.com/channel.xml", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="7", id="26", name="Car Survey", link="http://www.carsurvey.org/carsurvey.rss", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="7", id="27", name="Beer News", link="http://realbeer.com/rdf/realbeernews.rdf", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="9", id="28", name="NASA's Earth Observatory", link="http://earthobservatory.nasa.gov/eo.rss", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="6", id="29", name="BSD Today", link="http://www.bsdtoday.com/backend/bt.rdf", filename="", inuse="1";
INSERT INTO mos_newsfeedslinks SET categoryid="2", id="30", name="Company News", link="http://www.newsisfree.com/HPE/xml/feeds/07/1107.xml", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="7", id="31", name="Garden Guides", link="http://www.gardenguides.com/ggrdf.cdf", filename="", inuse="0";
INSERT INTO mos_newsfeedslinks SET categoryid="11", id="32", name="Cricket", link="http://www.newsisfree.com/HPE/xml/feeds/24/1324.xml", filename="", inuse="0";

# Dumping table construction info for 'mos_newsflash'
DROP TABLE IF EXISTS mos_newsflash;
CREATE TABLE mos_newsflash (
	newsflashID int(11) auto_increment not null,
	flashtitle varchar(50) not null,
	flashcontent text not null,
	showflash tinyint(1) not null,
	checked_out tinyint(1),
	checked_out_time time,
	editor varchar(50),
	PRIMARY KEY (newsflashID,showflash),
	KEY showflash (showflash)
);

# Dumping table data from 'mos_newsflash'
INSERT INTO mos_newsflash SET newsflashID="4", flashtitle=" ", flashcontent="     ", showflash="1", checked_out="", checked_out_time="", editor="";

# Dumping table construction info for 'mos_poll_data'
DROP TABLE IF EXISTS mos_poll_data;
CREATE TABLE mos_poll_data (
	pollid int(4) not null,
	optionText text not null,
	optionCount int(11) not null,
	voteid int(11) not null,
	KEY pollid (pollid,optionText(1))
);

# Dumping table data from 'mos_poll_data'
INSERT INTO mos_poll_data SET pollid="14", optionText="", optionCount="0", voteid="12";
INSERT INTO mos_poll_data SET pollid="14", optionText="", optionCount="0", voteid="11";
INSERT INTO mos_poll_data SET pollid="14", optionText="", optionCount="0", voteid="10";
INSERT INTO mos_poll_data SET pollid="14", optionText="", optionCount="0", voteid="9";
INSERT INTO mos_poll_data SET pollid="14", optionText="", optionCount="0", voteid="8";
INSERT INTO mos_poll_data SET pollid="14", optionText="", optionCount="0", voteid="7";
INSERT INTO mos_poll_data SET pollid="14", optionText="", optionCount="0", voteid="6";
INSERT INTO mos_poll_data SET pollid="14", optionText="   ", optionCount="1", voteid="5";
INSERT INTO mos_poll_data SET pollid="14", optionText="     ", optionCount="0", voteid="4";
INSERT INTO mos_poll_data SET pollid="14", optionText="     ", optionCount="0", voteid="3";
INSERT INTO mos_poll_data SET pollid="14", optionText="www.magtrb.com", optionCount="0", voteid="2";
INSERT INTO mos_poll_data SET pollid="14", optionText="    ", optionCount="0", voteid="1";

# Dumping table construction info for 'mos_poll_date'
DROP TABLE IF EXISTS mos_poll_date;
CREATE TABLE mos_poll_date (
	id bigint(20) auto_increment not null,
	date datetime not null default '0000-00-00 00:00:00',
	vote_id int(11) not null,
	poll_id int(11) not null,
	PRIMARY KEY (id),
	KEY poll_id (poll_id)
);

# Dumping table data from 'mos_poll_date'
INSERT INTO mos_poll_date SET id="1", date="2003-11-13 10:19:58", vote_id="5", poll_id="14";

# Dumping table construction info for 'mos_poll_desc'
DROP TABLE IF EXISTS mos_poll_desc;
CREATE TABLE mos_poll_desc (
	pollID int(11) auto_increment not null,
	pollTitle varchar(100) not null,
	voters mediumint(9) not null,
	checked_out tinyint(1) not null,
	checked_out_time time not null default '00:00:00',
	editor varchar(50),
	published tinyint(1) not null,
	PRIMARY KEY (pollID,published)
);

# Dumping table data from 'mos_poll_desc'
INSERT INTO mos_poll_desc SET pollID="14", pollTitle="<FONT color=ff6600><b>    </b></font>", voters="1", checked_out="0", checked_out_time="00:00:00", editor="", published="1";

# Dumping table construction info for 'mos_poll_menu'
DROP TABLE IF EXISTS mos_poll_menu;
CREATE TABLE mos_poll_menu (
	pollid int(11) not null,
	menuid int(11) not null,
	PRIMARY KEY (pollid,menuid)
);

# Dumping table data from 'mos_poll_menu'
INSERT INTO mos_poll_menu SET pollid="14", menuid="1";
INSERT INTO mos_poll_menu SET pollid="14", menuid="4";

# Dumping table construction info for 'mos_queue'
DROP TABLE IF EXISTS mos_queue;
CREATE TABLE mos_queue (
	qid smallint(5) unsigned auto_increment not null,
	uid mediumint(9) not null,
	uname varchar(40) not null,
	subject varchar(100) not null,
	story text,
	timestamp datetime not null default '0000-00-00 00:00:00',
	topic varchar(20) not null,
	PRIMARY KEY (qid)
);

# Dumping table data from 'mos_queue'

# Dumping table construction info for 'mos_session'
DROP TABLE IF EXISTS mos_session;
CREATE TABLE mos_session (
	username varchar(50),
	time varchar(14),
	session_id varchar(200) not null,
	guest tinyint(4) default '1',
	userid int(11),
	usertype varchar(50),
	gid tinyint(3) unsigned not null,
	PRIMARY KEY (session_id),
	KEY whosonline (guest,usertype)
);

# Dumping table data from 'mos_session'
INSERT INTO mos_session SET username="", time="1068739143", session_id="60b22c823b918310271998c9c45017f7", guest="1", userid="", usertype="", gid="0";
INSERT INTO mos_session SET username="", time="1068738160", session_id="198689ce5d30d102091f8e80f2b75f81", guest="1", userid="", usertype="", gid="0";
INSERT INTO mos_session SET username="", time="1068738172", session_id="9805ac7782e32d54174487a6a767d1f7", guest="1", userid="", usertype="", gid="0";

# Dumping table construction info for 'mos_stories'
DROP TABLE IF EXISTS mos_stories;
CREATE TABLE mos_stories (
	sid int(11) auto_increment not null,
	title varchar(100) not null,
	time datetime not null default '0000-00-00 00:00:00',
	author varchar(50),
	introtext text not null,
	fultext text,
	counter mediumint(8) unsigned,
	catid int(11) not null default '1',
	hits int(11),
	archived tinyint(1) not null,
	newsimage varchar(40) not null,
	published tinyint(1) not null,
	checked_out tinyint(1) not null,
	checked_out_time time,
	editor varchar(50),
	image_position varchar(10) not null,
	ordering int(11),
	frontpage tinyint(1) not null,
	approved tinyint(1) not null,
	access tinyint(3) unsigned not null,
	PRIMARY KEY (sid),
	KEY body (archived,published,frontpage),
	KEY news (catid,published,frontpage,archived),
	KEY published (published)
);

# Dumping table data from 'mos_stories'
INSERT INTO mos_stories SET sid="1", title="    ", time="2003-02-18 09:25:58", author="", introtext="
<head>
<meta http-equiv=\"Content-Language\" content=\"en-us\">
</head>

<p dir=\"rtl\"><span lang=\"ar-sa\">         
                
             </span>
</p>
<p dir=\"rtl\"><span lang=\"ar-sa\">    </span></p>
", fultext="", counter="0", catid="1", hits="0", archived="0", newsimage="", published="1", checked_out="0", checked_out_time="00:00:00", editor="", image_position="left", ordering="2", frontpage="1", approved="1", access="0";

# Dumping table construction info for 'mos_system'
DROP TABLE IF EXISTS mos_system;
CREATE TABLE mos_system (
	id int(11) not null,
	sitename varchar(50) not null,
	cur_theme varchar(50) not null,
	col_main char(1) not null default '1',
	PRIMARY KEY (id)
);

# Dumping table data from 'mos_system'
INSERT INTO mos_system SET id="0", sitename="Mambo 4.0.13 Stable", cur_theme="original", col_main="1";

# Dumping table construction info for 'mos_users'
DROP TABLE IF EXISTS mos_users;
CREATE TABLE mos_users (
	id int(11) auto_increment not null,
	name varchar(50) not null,
	username varchar(25) not null,
	email varchar(100) not null,
	password varchar(100) not null,
	usertype varchar(25) not null,
	block tinyint(4) not null,
	sendEmail tinyint(4),
	gid tinyint(3) unsigned not null default '1',
	PRIMARY KEY (id),
	KEY usertype (usertype)
);

# Dumping table data from 'mos_users'
INSERT INTO mos_users SET id="62", name="Administrator", username="admin", email="matrb@magtrb.com", password="21232f297a57a5a743894a0e4a801fc3", usertype="superadministrator", block="0", sendEmail="0", gid="1";
