CREATE TABLE `articles` (
  `id` int(10) NOT NULL auto_increment,
  `type` tinyint(1) NOT NULL default '0',
  `category` text NOT NULL,
  `tim` int(14) NOT NULL default '0',
  `status` tinyint(1) NOT NULL default '0',
  `title` text NOT NULL,
  `description` text NOT NULL,
  `body` longtext NOT NULL,
  `publisher` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

CREATE TABLE `ban_group` (
  `id` int(4) NOT NULL auto_increment,
  `width` int(4) NOT NULL default '0',
  `height` int(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

INSERT INTO `ban_group` VALUES (5, 468, 60);
INSERT INTO `ban_group` VALUES (12, 140, 140);
INSERT INTO `ban_group` VALUES (13, 468, 61);

CREATE TABLE `ban_source` (
  `id` int(4) NOT NULL auto_increment,
  `name` text NOT NULL,
  `image` text NOT NULL,
  `gr` int(4) NOT NULL default '0',
  `url` text NOT NULL,
  `active` enum('on','off') NOT NULL default 'on',
  `imp_limit` int(10) NOT NULL default '0',
  `imp_total` int(10) NOT NULL default '0',
  `clicks` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

INSERT INTO `ban_source` VALUES (25, 'N1', '1097808940.gif', 5, 'http://www.newsphp.com', 'on', 0, 3003, 57);
INSERT INTO `ban_source` VALUES (28, 'medium', '1097870997.gif', 12, 'http://www.newsphp.com', 'on', 0, 5071, 4);

CREATE TABLE `categories` (
  `id` int(3) NOT NULL default '1',
  `name` varchar(100) NOT NULL default '',
  `protect` enum('on','off') NOT NULL default 'off',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

INSERT INTO `categories` VALUES (1, 'World', 'off');
INSERT INTO `categories` VALUES (2, 'U.S.', 'off');
INSERT INTO `categories` VALUES (3, 'Politics', 'off');
INSERT INTO `categories` VALUES (4, 'Business', 'off');
INSERT INTO `categories` VALUES (5, 'Science', 'off');
INSERT INTO `categories` VALUES (6, 'Sport', 'off');
INSERT INTO `categories` VALUES (7, 'Technology', 'off');
INSERT INTO `categories` VALUES (8, 'Entertainment', 'on');

CREATE TABLE `comments` (
  `id` int(8) NOT NULL auto_increment,
  `parent` int(8) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `comment` text NOT NULL,
  `tim` int(14) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

CREATE TABLE `newsletter` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `address` varchar(255) NOT NULL default '',
  `dateadd` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `address` (`address`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

CREATE TABLE `poll` (
  `id` int(5) NOT NULL auto_increment,
  `question` text NOT NULL,
  `answer` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

INSERT INTO `poll` VALUES (11, 'How would you rate our site?', 'Excellent\r\nGood\r\nNot bad\r\nBad\r\nPoor');

CREATE TABLE `poll_ip` (
  `pollID` int(11) NOT NULL default '0',
  `votersIP` char(16) NOT NULL default '',
  `timeout` int(11) NOT NULL default '0'
) TYPE=MyISAM;

CREATE TABLE `poll_result` (
  `id` int(3) NOT NULL default '0',
  `result` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

CREATE TABLE `properties` (
  `title` text NOT NULL,
  `keywords` text NOT NULL,
  `description` text NOT NULL,
  `bodytagset` text NOT NULL,
  `email` varchar(50) NOT NULL default '',
  `language` varchar(100) NOT NULL default '',
  `encoding` varchar(100) NOT NULL default '',
  `date_format` varchar(100) NOT NULL default '',
  `counter` enum('yes','no') NOT NULL default 'yes',
  `admin_language` varchar(100) NOT NULL default '',
  `txt_direction` enum('LTR','RTL') NOT NULL default 'LTR'
) TYPE=MyISAM;

INSERT INTO `properties` VALUES ('NewsPHP.com', 'Keywords', 'Description', '<body>', 'contact@newsphp.com', 'english.php', 'Windows-1252', '#d/#m/#Y - #H:#i', 'yes', 'english.php', 'LTR');

CREATE TABLE `rating` (
  `id` int(5) NOT NULL default '0',
  `rating` int(5) NOT NULL default '0',
  `amount` int(5) NOT NULL default '0',
  `time` int(15) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

CREATE TABLE `session` (
  `total_hits` int(11) NOT NULL default '0',
  `unique_hits` int(11) NOT NULL default '0',
  `reset` enum('yes','no') NOT NULL default 'yes'
) TYPE=MyISAM;

INSERT INTO `session` VALUES (3, 1, 'yes');

CREATE TABLE `session_detail` (
  `id` int(10) NOT NULL auto_increment,
  `REMOTE_ADDR` varchar(20) NOT NULL default '',
  `REMOTE_HOST` varchar(50) NOT NULL default '',
  `HTTP_REFERER` varchar(100) NOT NULL default '',
  `REQUEST_URI` varchar(100) NOT NULL default '',
  `HTTP_USER_AGENT` varchar(100) NOT NULL default '',
  `tim` int(14) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

CREATE TABLE `styles` (
  `function_set` text NOT NULL,
  `day_title_color` text NOT NULL,
  `day_title_font` text NOT NULL,
  `day_title_font_size` text NOT NULL,
  `day_title_font_weight` text NOT NULL,
  `day_description_color` text NOT NULL,
  `day_description_font` text NOT NULL,
  `day_description_font_size` text NOT NULL,
  `day_description_font_weight` text NOT NULL,
  `day_image_width` text NOT NULL,
  `day_image_height` text NOT NULL,
  `head_day_amount` text NOT NULL,
  `head_day_title_color` text NOT NULL,
  `head_day_title_font` text NOT NULL,
  `head_day_title_font_size` text NOT NULL,
  `head_day_title_font_weight` text NOT NULL,
  `head_day_description_color` text NOT NULL,
  `head_day_description_font` text NOT NULL,
  `head_day_description_font_size` text NOT NULL,
  `head_day_description_font_weight` text NOT NULL,
  `head_day_tmb` text NOT NULL,
  `head_day_tmb_width` text NOT NULL,
  `head_day_tmb_height` text NOT NULL,
  `head_day_tmb_align` text NOT NULL,
  `typical_amount` text NOT NULL,
  `typical_title_color` text NOT NULL,
  `typical_title_font` text NOT NULL,
  `typical_title_font_size` text NOT NULL,
  `typical_title_font_weight` text NOT NULL,
  `typical_description_color` text NOT NULL,
  `typical_description_font` text NOT NULL,
  `typical_description_font_size` text NOT NULL,
  `typical_description_font_weight` text NOT NULL,
  `typical_tmb_width` text NOT NULL,
  `typical_tmb_height` text NOT NULL,
  `typical_tmb_align` text NOT NULL,
  `typical_headlines_amount` text NOT NULL,
  `typical_headlines_title_color` text NOT NULL,
  `typical_headlines_title_font` text NOT NULL,
  `typical_headlines_title_font_size` text NOT NULL,
  `typical_headlines_title_font_weight` text NOT NULL,
  `typical_headlines_description_color` text NOT NULL,
  `typical_headlines_description_font` text NOT NULL,
  `typical_headlines_description_font_size` text NOT NULL,
  `typical_headlines_description_font_weight` text NOT NULL,
  `typical_headlines_border` text NOT NULL,
  `typical_headlines_border_color` text NOT NULL,
  `typical_headlines_bg_color` text NOT NULL,
  `typical_headlines__color` text NOT NULL,
  `typical_headlines__font` text NOT NULL,
  `typical_headlines__font__size` text NOT NULL,
  `typical_headlines__font__weight` text NOT NULL,
  `typical_headlines__bg__color` text NOT NULL,
  `typical_headlines_tmb` text NOT NULL,
  `typical_headlines_tmb_width` text NOT NULL,
  `typical_headlines_tmb_height` text NOT NULL,
  `typical_headlines_tmb_align` text NOT NULL,
  `headlines_amount` text NOT NULL,
  `headlines_title_color` text NOT NULL,
  `headlines_title_font` text NOT NULL,
  `headlines_title_font_size` text NOT NULL,
  `headlines_title_font_weight` text NOT NULL,
  `headlines_description_color` text NOT NULL,
  `headlines_description_font` text NOT NULL,
  `headlines_description_font_size` text NOT NULL,
  `headlines_description_font_weight` text NOT NULL,
  `title_color` text NOT NULL,
  `title_font` text NOT NULL,
  `title_font_size` text NOT NULL,
  `title_font_weight` text NOT NULL,
  `description_color` text NOT NULL,
  `description_font` text NOT NULL,
  `description_font_size` text NOT NULL,
  `description_font_weight` text NOT NULL,
  `image_width` text NOT NULL,
  `image_height` text NOT NULL,
  `headlines_border` text NOT NULL,
  `headlines_border_color` text NOT NULL,
  `headlines_bg_color` text NOT NULL,
  `headlines__color` text NOT NULL,
  `headlines__font` text NOT NULL,
  `headlines__font__size` text NOT NULL,
  `headlines__font__weight` text NOT NULL,
  `headlines__bg__color` text NOT NULL,
  `headlines_tmb` text NOT NULL,
  `tmb_width` text NOT NULL,
  `tmb_height` text NOT NULL,
  `tmb_align` text NOT NULL,
  `interv_title_color` text NOT NULL,
  `interv_title_font` text NOT NULL,
  `interv_title_font_size` text NOT NULL,
  `interv_title_font_weight` text NOT NULL,
  `interv_description_color` text NOT NULL,
  `interv_description_font` text NOT NULL,
  `interv_description_font_size` text NOT NULL,
  `interv_description_font_weight` text NOT NULL,
  `interv_tmb_width` text NOT NULL,
  `interv_tmb_height` text NOT NULL,
  `interv_tmb_align` text NOT NULL,
  `interv_wind_width` text NOT NULL,
  `interv_border` text NOT NULL,
  `interv_border_color` text NOT NULL,
  `interv_bg_color` text NOT NULL,
  `interv_amount` text NOT NULL,
  `interv_tmb_display` text NOT NULL,
  `vscroll_title_color` text NOT NULL,
  `vscroll_title_font` text NOT NULL,
  `vscroll_title_font_size` text NOT NULL,
  `vscroll_title_font_weight` text NOT NULL,
  `vscroll_description_color` text NOT NULL,
  `vscroll_description_font` text NOT NULL,
  `vscroll_description_font_size` text NOT NULL,
  `vscroll_description_font_weight` text NOT NULL,
  `vscroll_tmb_width` text NOT NULL,
  `vscroll_tmb_height` text NOT NULL,
  `vscroll_tmb_align` text NOT NULL,
  `vscroll_wind_width` text NOT NULL,
  `vscroll_wind_height` text NOT NULL,
  `vscroll_border` text NOT NULL,
  `vscroll_border_color` text NOT NULL,
  `vscroll_bg_color` text NOT NULL,
  `vscroll_amount` text NOT NULL,
  `vscroll_tmb_display` text NOT NULL,
  `vscroll_direct` text NOT NULL,
  `vscroll_category` text NOT NULL,
  `cal_first` text NOT NULL,
  `cal_bg_color` text NOT NULL,
  `cal_my_color` text NOT NULL,
  `cal_wd_bg_color` text NOT NULL,
  `cal_hd_bg_color` text NOT NULL,
  `cal_cd_color` text NOT NULL,
  `cal_cd_bg_color` text NOT NULL,
  `cal_d_color` text NOT NULL,
  `las2post_category` text NOT NULL,
  `las2post_amount` text NOT NULL,
  `las2post_column` text NOT NULL,
  `las2post_title_color` text NOT NULL,
  `las2post_title_font` text NOT NULL,
  `las2post_title_font_size` text NOT NULL,
  `las2post_title_font_weight` text NOT NULL,
  `las2post_description_color` text NOT NULL,
  `las2post_description_font` text NOT NULL,
  `las2post_description_font_size` text NOT NULL,
  `las2post_description_font_weight` text NOT NULL,
  `las2post_tmb_width` text NOT NULL,
  `las2post_tmb_height` text NOT NULL,
  `las2post_tmb_align` text NOT NULL,
  `catlist_title_color` text NOT NULL,
  `catlist_title_font` text NOT NULL,
  `catlist_title_font_size` text NOT NULL,
  `catlist_title_font_weight` text NOT NULL,
  `catlist_color` text NOT NULL,
  `catlist_font` text NOT NULL,
  `catlist_font_size` text NOT NULL,
  `catlist_font_weight` text NOT NULL,
  `catlist_bg_color` text NOT NULL,
  `catlist_bullet` text NOT NULL,
  `catlist_amount` text NOT NULL,
  `poll_border` text NOT NULL,
  `poll_border_color` text NOT NULL,
  `poll_bg_color` text NOT NULL,
  `poll_question_color` text NOT NULL,
  `poll_question_font` text NOT NULL,
  `poll_question_font_size` text NOT NULL,
  `poll_question_font_weight` text NOT NULL,
  `poll_answer_color` text NOT NULL,
  `poll_answer_font` text NOT NULL,
  `poll_answer_font_size` text NOT NULL,
  `poll_answer_font_weight` text NOT NULL,
  `rss_category` text NOT NULL,
  `rss_amount` text NOT NULL,
  `cat_color` text NOT NULL,
  `cat_font` text NOT NULL,
  `cat_font_size` text NOT NULL,
  `cat_font_weight` text NOT NULL,
  `cat_decoration` text NOT NULL,
  `cat_bg_color` text NOT NULL,
  `cat_border` text NOT NULL,
  `cat_border_color` text NOT NULL,
  `cat_bullet_display` enum('yes','no') NOT NULL default 'no',
  `topmenu_color` text NOT NULL,
  `topmenu_font` text NOT NULL,
  `topmenu_font_size` text NOT NULL,
  `topmenu_font_weight` text NOT NULL,
  `topmenu_decoration` text NOT NULL,
  `topmenu_horizontal` text NOT NULL,
  `topmenu_vertical` text NOT NULL,
  `topmenu_width` text NOT NULL,
  `topmenu_height` text NOT NULL,
  `topmenu_padding` text NOT NULL,
  `topmenu_bg_color` text NOT NULL,
  `topmenu_border` text NOT NULL,
  `topmenu_border_color` text NOT NULL,
  `search_color` text NOT NULL,
  `search_font` text NOT NULL,
  `search_font_size` text NOT NULL,
  `search_font_weight` text NOT NULL,
  `search_width` text NOT NULL,
  `search_where` text NOT NULL,
  `skin` text NOT NULL,
  `active` enum('yes','no') NOT NULL default 'no'
) TYPE=MyISAM;

INSERT INTO `styles` VALUES ('main()', '#aa0000', 'Verdana', '20', 'normal', '#000000', 'Tahoma', '12', 'normal', '298', '', '3', '#0000ee', 'Tahoma', '11', 'normal', '#999999', 'Arial', '9', 'normal', 'yes', '60', '', 'left', '10', 'blue', 'Tahoma', '12', 'normal', '#222222', 'Tahoma', '11', 'normal', '100', '', 'left', '3', 'blue', 'Tahoma', '11', 'normal', '#999999', 'Tahoma', '10', 'normal', '1', '#999999', '#ffffff', '#ffffff', 'Verdana', '10', 'normal', '#999999', 'yes', '70', '', 'right', '2', 'blue', 'Tahoma', '11', 'normal', '#999999', 'Tahoma', '9', 'normal', 'blue', 'Times New Roman', '20', 'bold', '#444444', 'Tahoma', '11', 'normal', '200', '', '1', '#999999', '#ffffff', '#ffffff', 'Verdana', '12', 'bold', '#999999', 'yes', '60', '', 'right', '#0000ee', 'Tahoma', '12', 'normal', '#999999', 'Tahoma', '10', 'normal', '60', '', 'right', '100%', '1', '#999999', '#ffffff', '3', 'yes', '#0000ee', 'Tahoma', '12', 'normal', '#a0a0a0', 'Tahoma', '10', 'normal', '50', '', 'right', '100%', '280', '1', '#999999', '#ffffff', '5', 'yes', 'up', 'U.S.', '1', '#eeeeee', '#ffffff', '#dddddd', '#ffeeee', '#ffffff', '#555555', '#777777', 'All', '6', '3', '#0000ff', 'Tahoma', '11', 'normal', '#999999', 'Tahoma', '10', 'normal', '60', '', 'left', 'blue', 'Tahoma', '10', 'normal', 'black', 'MS Sans Serif', '14', 'bold', '#999999', 'yes', '3', '1', '#999999', '', '#999999', 'Tahoma', '14', 'normal', '#999999', 'Tahoma', '10', 'normal', 'All', '10', '#000088', 'Tahoma', '11', 'normal', 'none', '#ffffff', '2', '#999999', 'yes', '#222222', 'Verdana', '12', 'normal', 'none', 'center', 'middle', '98', '25', '0', '#ffffff', '2', '#999999', '#555555', 'Tahoma', '11', 'normal', '20', 'altavista', 'temp.tpl', 'yes');

CREATE TABLE `sub_categories` (
  `parent` int(3) NOT NULL default '0',
  `name` text NOT NULL
) TYPE=MyISAM;


INSERT INTO `sub_categories` VALUES (1, '1\r\n2\r\n3\r\n4');

CREATE TABLE `topmenu` (
  `items` text NOT NULL
) TYPE=MyISAM;

INSERT INTO `topmenu` VALUES ('Home\r\nAbout Us\r\nSite Map\r\nLinks\r\nAdvertise\r\nTestimonials\r\nFAQ\r\nContact Us');

CREATE TABLE `users` (
  `id` int(11) NOT NULL auto_increment,
  `username` text NOT NULL,
  `password` text NOT NULL,
  `root` int(1) NOT NULL default '0',
  `allowed` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

INSERT INTO `users` VALUES (24, 'admin', '21232f297a57a5a743894a0e4a801fc3', 0, '1\r\n2\r\n3\r\n4\r\n5\r\n6\r\n7\r\n8\r\n');

CREATE TABLE `visitors` (
  `id` int(11) NOT NULL auto_increment,
  `username` text NOT NULL,
  `password` text NOT NULL,
  `allowed` text NOT NULL,
  `status` enum('enabled','disabled') NOT NULL default 'disabled',
  `valid` int(12) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

INSERT INTO `visitors` VALUES (24, 'visitor', '127870930d65c57ee65fcc47f2170d38', '1\r\n', 'enabled', 1167681599);
