<?php
/**
* AkoComment - A User Comments Component
* @version 2.0
* @package AkoComment
* @copyright (C) 2004 by Arthur Konze - All rights reserved!
* @license http://www.konze.de/content/view/8/26/ Copyrighted Commercial Software
**/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
require_once( $mosConfig_absolute_path."/administrator/components/com_akocomment/class.akocomment.php");
require_once( $mainframe->getPath( 'admin_html' ) );

$task = mosGetParam( $_REQUEST, 'task', null );
$cid = mosGetParam( $_REQUEST, 'cid', array( 0 ) );
$uid = mosGetParam( $_REQUEST, 'uid', array( 0 ) );
if (!is_array( $cid )) {
$ocid=$cid;
$cid = array ();
$cid[]=$ocid;
mosArrayToInts($cid);
}


switch ($task) {
  case "new":
    editComment( $option, 0 );
    break;

  case "edit":
    editComment( $option, $cid[0] );
    break;

  case "save":
    saveComment( $option );
    break;

  case "remove":
    removeComments( $cid, $option );
    break;

  case "publish":
    publishComments( $cid, 1, $option );
    break;

  case "unpublish":
    publishComments( $cid, 0, $option );
    break;

  ##############################################

  case "about":
    showAbout();
    break;

  ##############################################

  case "settings":
    showConfig( $option );
    break;

  case "savesettings":
    $ac_sectionlist   = implode(',',$_POST['acselections']);
    saveConfig ($option, 
    $ac_autopublish, $ac_anonentry, 
    $ac_sorting, $ac_bbcodesupport, 
    $ac_picsupport, $ac_smiliesupport, 
    $ac_notify, $ac_notify_email, 
    $ac_openingmode, $ac_pagination, 
    $ac_perpage, $ac_formposition, 
    $ac_regedit, $ac_mainmode, 
    $ac_sectionlist,$ac_smileysthemes, 
    $ac_hashcash, $ac_securityimage);
    break;

  ##############################################

  case "language":
    showLanguage($option);
    break;

  case "savefile":
    saveLanguage($file, $filecontent, $option);
    break;

  ##############################################

  default:
    showComments( $option );
    break;
}
echo "<p><font class='smalldark'><b>AkoComment V2.0</b> - &copy Copyright 2004 by Arthur Konze - <a href='http://www.mamboportal.com/' target='_blank'>www.mamboportal.com</a></font></p>";

############################################################################

function showComments ( $option ) {
  global $database, $mainframe;

  $limit      = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
  $limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );
  $search     = $mainframe->getUserStateFromRequest( "search{$option}", 'search', '' );
  $search     = $database->getEscaped( trim( strtolower( $search ) ) );

  $where = array();
  if ($search) {
    $where[] = "LOWER(comment) LIKE '%$search%'";
  }

  $database->setQuery( "SELECT count(*) FROM #__akocomment AS a" . (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "") );
  $total = $database->loadResult();
  echo $database->getErrorMsg();
  include_once( "includes/pageNavigation.php" );
  $pageNav = new mosPageNav( $total, $limitstart, $limit  );

  $database->setQuery( "SELECT * FROM #__akocomment"
    . (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
    . "\nORDER BY id DESC"
    . "\nLIMIT $pageNav->limitstart,$pageNav->limit"
  );
  $rows = $database->loadObjectList();
  if ($database->getErrorNum()) {
    echo $database->stderr();
    return false;
  }

  HTML_comment::showComments( $option, $rows, $search, $pageNav );
}

############################################################################

function editComment( $option, $uid ) {
  global $database;

  $row = new mosAkocomment( $database );
  $row->load( $uid );

  #Get list of Content
  $contentitem[] = mosHTML::makeOption( '0', 'Select Content Item' );
  $database->setQuery( "SELECT id AS value, title AS text FROM #__content ORDER BY title" );
  $contentitem = array_merge( $contentitem, $database->loadObjectList() );
  if (count( $contentitem ) < 1) {
    mosRedirect( "index2.php?option=com_sections&scope=content", 'You must add content first.' );
  }
  $clist = mosHTML::selectList( $contentitem, 'contentid', 'class="inputbox" size="1"', 'value', 'text', intval( $row->contentid ) );

  # Check if new or edit
  if ($uid) {
    $row->checkout( $my->id );
  } else {
    $row->published = 0;
  }

  # Prepare Ordering box
  $order = mosGetOrderingList( "SELECT ordering AS value, title AS text FROM #__akocomment"
    . "\nWHERE contentid='$row->contentid' ORDER BY ordering" );
  $olist = mosHTML::selectList( $order, 'ordering', 'class="inputbox" size="1"', 'value', 'text', intval( $row->ordering ) );

  # Build up published box
  $publist = mosHTML::yesnoRadioList( 'published', 'class="inputbox"', $row->published );

  HTML_comment::editComment( $option, $row, $clist, $olist, $publist );
}

############################################################################

function saveComment( $option ) {
  global $database;
  $row = new mosAkocomment( $database );
  if (!$row->bind( $_POST )) {
    echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
    exit();
  }
  $row->date = date( "Y-m-d H:i:s" );
  $row->ip   = getenv('REMOTE_ADDR');
  if (!$row->store()) {
    echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
    exit();
  }
  $row->updateOrder( "contentid='$row->contentid'" );
  mosRedirect( "index2.php?option=$option" );
}

############################################################################

function publishComments( $cid=null, $publish=1,  $option ) {
  global $database;
  if (!is_array( $cid ) || count( $cid ) < 1) {
    $action = $publish ? 'publish' : 'unpublish';
    echo "<script> alert('Select an item to $action'); window.history.go(-1);</script>\n";
    exit;
  }
  $cids = implode( ',', $cid );
  $database->setQuery( "UPDATE #__akocomment SET published='$publish' WHERE id IN ($cids)" );
  if (!$database->query()) {
    echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    exit();
  }
  mosRedirect( "index2.php?option=$option" );
}

############################################################################

function showAbout() {
  HTML_comment::showAbout();
}

############################################################################

function showConfig( $option ) {
  global $mosConfig_absolute_path, $database;
  require($mosConfig_absolute_path."/administrator/components/com_akocomment/config.akocomment.php");
?>
    <script language="javascript" type="text/javascript">
    function submitbutton(pressbutton) {
      var form = document.adminForm;
      if (pressbutton == 'cancel') {
        submitform( pressbutton );
        return;
      }
      if (form.ac_autopublish.value == ""){
        alert( "Please choose publish mode." );
      } else {
        submitform( pressbutton );
      }
    }
    </script>

  <form action="index2.php" method="POST" name="adminForm">
  <table cellpadding="4" cellspacing="0" border="0" width="100%">
  <tr>
    <td width="100%" class="sectionname">
      <img src="components/com_akocomment/images/logo.png">
    </td>
  </tr>
  </table>

  <?php
  $akogbtabs = new mosTabs( 0 );
  $akogbtabs->startPane( "ako_comment" );
  $akogbtabs->startTab("General","General-page");
  ?>
  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong>Main Operating Mode:</strong></td>
      <td align="left" valign="top">
      <?php
        $acmainmode[] = mosHTML::makeOption( '0', 'Use individual botcommand' );
        $acmainmode[] = mosHTML::makeOption( '1', 'Choose from sections below' );
        $mc_ac_mainmode = mosHTML::selectList( $acmainmode, 'ac_mainmode', 'class="inputbox" size="2"', 'value', 'text', $ac_mainmode );
        echo $mc_ac_mainmode;
      ?>
      </td>
      <td align="left" valign="top" width="50%">With individual botcommand <font color="green">{moscomment}</font> you can choose wether to allow comments or not
      for every content item individually. Using the second option allows you to turn comments on/off for complete sections.</td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong>Sections available:</strong></td>
      <td align="left" valign="top"><select size="5" name="acselections[]" class="inputbox" multiple="multiple">
      <?php
        $seclistarray = explode (",", $ac_sectionlist);
        $database -> setQuery("SELECT id,title FROM #__sections ORDER BY title ASC");
        $dbsectionlist = $database -> loadObjectList();
        foreach ($dbsectionlist as $slrow){
          echo "<option value='$slrow->id' ";
          if (in_array ($slrow->id, $seclistarray)) echo "selected";
          echo ">$slrow->title</option>";
        }
      ?>
        </select>
      </td>
      <td align="left" valign="top">If you use second operating mode, you can choose here which sections should use comment system. Multiple selections
      are possible.</td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Autopublish Comments:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        echo mosHTML::yesnoRadioList( 'ac_autopublish', 'class="inputbox"', $ac_autopublish );
      ?>
      </td>
      <td align="left" valign="top"><?php echo "Automatically publish new comments?" ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "User profile Comments:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        $acanonentry[] = mosHTML::makeOption( '0', 'No anonymous comments' );
        $acanonentry[] = mosHTML::makeOption( '1', 'Comments for guest users without name' );
        $acanonentry[] = mosHTML::makeOption( '2', 'Comments for guest users with input box for the name' );
        $mc_ac_anonentry = mosHTML::selectList( $acanonentry, 'ac_anonentry', 'class="inputbox" size="3"', 'value', 'text', $ac_anonentry );
        echo $mc_ac_anonentry;
      ?>
      </td>
      <td align="left" valign="top"><?php echo "Allow unregistered users to post comments?" ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong>Comment Window:</strong></td>
      <td align="left" valign="top">
      <?php
        $acopeningmode[] = mosHTML::makeOption( '0', 'Open in same window' );
        $acopeningmode[] = mosHTML::makeOption( '1', 'Open in new window' );
        $mc_ac_openingmode = mosHTML::selectList( $acopeningmode, 'ac_openingmode', 'class="inputbox" size="2"', 'value', 'text', $ac_openingmode );
        echo $mc_ac_openingmode;
      ?>
      </td>
      <td align="left" valign="top">Choose where to open the comments.</td>
    </tr>
  </table>
  <?php
    $akogbtabs->endTab();
    $akogbtabs->startTab("Layout","Layout-page");
  ?>
  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong>Comments Sorting:</strong></td>
      <td align="left" valign="top">
      <?php
        $acsorting[] = mosHTML::makeOption( 'DESC', 'New entries first' );
        $acsorting[] = mosHTML::makeOption( 'ASC', 'New entries last' );
        $mc_ac_sorting = mosHTML::selectList( $acsorting, 'ac_sorting', 'class="inputbox" size="2"', 'value', 'text', $ac_sorting );
        echo $mc_ac_sorting;
      ?>
      </td>
      <td align="left" valign="top" width="50%">Sorting of new comments.</td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong>Form Position:</strong></td>
      <td align="left" valign="top">
      <?php
        $acformpos[] = mosHTML::makeOption( '0', 'Behind Comments' );
        $acformpos[] = mosHTML::makeOption( '1', 'Above Comments' );
        $mc_ac_formposition = mosHTML::selectList( $acformpos, 'ac_formposition', 'class="inputbox" size="2"', 'value', 'text', $ac_formposition );
        echo $mc_ac_formposition;
      ?>
      </td>
      <td align="left" valign="top">Where should the form be displayed?</td>
    </tr>
  </table>
    <?php
    $akogbtabs->endTab();
    $akogbtabs->startTab("Posting","Posting-page");
    ?>
  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "BB Code Support:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        echo mosHTML::yesnoRadioList( 'ac_bbcodesupport', 'class="inputbox"', $ac_bbcodesupport );
      ?>
      </td>
      <td align="left" valign="top" width="50%"><?php echo "Allow the use of BB Codes?" ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Picture Support:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        echo mosHTML::yesnoRadioList( 'ac_picsupport', 'class="inputbox"', $ac_picsupport );
      ?>
      </td>
      <td align="left" valign="top"><?php echo "Allow the use of pictures in comments?" ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong>Smilie Support:</strong></td>
      <td align="left" valign="top">
      <?php
        echo mosHTML::yesnoRadioList( 'ac_smiliesupport', 'class="inputbox"', $ac_smiliesupport );
      ?>
      </td>
      <td align="left" valign="top">Allow the use of Smilies in comments?</td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong></strong></td>
      <td align="left" valign="top"><b>Settings added by <a href="www.waltercedric.com">www.waltercedric.com</a></b></td>
      <td align="left" valign="top"></td>
    </tr>   
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong>Smilie Theme name:</strong></td>
      <td align="left" valign="top"><input type="text" name="ac_smileysthemes" value="<? echo "$ac_smileysthemes"; ?>"></td>
      <td align="left" valign="top">Name of smileys theme (store in /packs/)?</td>
    </tr>
    
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong>Hashcash engine:</strong></td>
      <td align="left" valign="top">
      <?php
        echo mosHTML::yesnoRadioList( 'ac_hashcash', 'class="inputbox"', $ac_hashcash );
      ?>
      </td>
      <td align="left" valign="top">Use hashcash technology to prevent spammer posting? require com_hashcash prior to activation!</td>
    </tr> 
     <tr align="center" valign="middle">
      <td align="left" valign="top"><strong>Security Images:</strong></td>
      <td align="left" valign="top">
      <?php
        echo mosHTML::yesnoRadioList( 'ac_securityimage', 'class="inputbox"', $ac_securityimage );
      ?>
      </td>
      <td align="left" valign="top">Use security images to prevent spammer posting? require com_securityimages prior to activation!</td>
    </tr> 
  </table>
  <?php
    $akogbtabs->endTab();
    $akogbtabs->startTab("Notification","Notification-page");
  ?>
  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong>Notify Admin:</strong></td>
      <td align="left" valign="top">
      <?php
        echo mosHTML::yesnoRadioList( 'ac_notify', 'class="inputbox"', $ac_notify );
      ?>
      </td>
      <td align="left" valign="top" width="50%">Notify an administrator by email?</td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong>Admin's Email:</strong></td>
      <td align="left" valign="top"><input type="text" name="ac_notify_email" value="<? echo "$ac_notify_email"; ?>"></td>
      <td align="left" valign="top">Mail notificationto which email address?</td>
    </tr>
  </table>
  <?php
  $akogbtabs->endTab();
  $akogbtabs->endPane();
  ?>
  <input type="hidden" name="option" value="<?php echo $option; ?>">
  <input type="hidden" name="act" value="<?php echo $act; ?>">
  <input type="hidden" name="task" value="">
  <input type="hidden" name="boxchecked" value="0">
</form>
<?php
}

############################################################################

function saveConfig ($option, $ac_autopublish, $ac_anonentry, $ac_sorting, $ac_bbcodesupport, $ac_picsupport, $ac_smiliesupport, $ac_notify, $ac_notify_email, $ac_openingmode, $ac_pagination, $ac_perpage, $ac_formposition, $ac_regedit, $ac_mainmode, $ac_sectionlist, $ac_smileysthemes, $ac_hashcash,$ac_securityimage) {
  $configfile = "components/com_akocomment/config.akocomment.php";
  @chmod ($configfile, 0766);
  $permission = is_writable($configfile);
  if (!$permission) {
    $mosmsg = "Config file not writeable!";
    mosRedirect("index2.php?option=$option&act=config",$mosmsg);
    break;
  }

  $config  = "<?php\n";
  $config .= "\$ac_autopublish = \"$ac_autopublish\";\n";
  $config .= "\$ac_anonentry = \"$ac_anonentry\";\n";
  $config .= "\$ac_sorting = \"$ac_sorting\";\n";
  $config .= "\$ac_bbcodesupport = \"$ac_bbcodesupport\";\n";
  $config .= "\$ac_picsupport = \"$ac_picsupport\";\n";
  $config .= "\$ac_smiliesupport = \"$ac_smiliesupport\";\n";
  $config .= "\$ac_notify = \"$ac_notify\";\n";
  $config .= "\$ac_notify_email = \"$ac_notify_email\";\n";
  $config .= "\$ac_openingmode = \"$ac_openingmode\";\n";
  $config .= "\$ac_pagination = \"$ac_pagination\";\n";
  $config .= "\$ac_perpage = \"$ac_perpage\";\n";
  $config .= "\$ac_formposition = \"$ac_formposition\";\n";
  $config .= "\$ac_regedit = \"$ac_regedit\";\n";
  $config .= "\$ac_mainmode = \"$ac_mainmode\";\n";
  $config .= "\$ac_sectionlist = \"$ac_sectionlist\";\n";
  
//add by Cedric Walter www.waltercedric.com
  $config .= "\$ac_smileysthemes = \"$ac_smileysthemes\";\n";
  $config .= "\$ac_hashcash = \"$ac_hashcash\";\n";
  $config .= "\$ac_securityimage = \"$ac_securityimage\";\n";
 
  $config .= "?>";

  if ($fp = fopen("$configfile", "w")) {
    fputs($fp, $config, strlen($config));
    fclose ($fp);
  }
  mosRedirect("index2.php?option=$option&task=settings", "Settings saved");
}


############################################################################

function removeComments( $cid, $option ) {
  global $database;
  if (count( $cid )) {
    $cids = implode( ',', $cid );
    $database->setQuery( "DELETE FROM #__akocomment WHERE id IN ($cids)" );
    if (!$database->query()) {
      echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    }
  }
  mosRedirect( "index2.php?option=$option" );
}

############################################################################

function showLanguage($option) {

  global $mosConfig_absolute_path, $mosConfig_lang;

  if (file_exists($mosConfig_absolute_path.'/components/com_akocomment/languages/'.$mosConfig_lang.'.php')) {
    $file = $mosConfig_absolute_path.'/components/com_akocomment/languages/'.$mosConfig_lang.'.php';
  } else {
    $file = $mosConfig_absolute_path.'/components/com_akocomment/languages/english.php';
  }
  @chmod ($file, 0766);
  $permission = is_writable($file);
  if (!$permission) {
    echo "<center><h1><font color=red>Warning...</FONT></h1><BR>";
    echo "<B>You need to chmod the file to 766 in order to save your updates.</B></center><BR />";
  }

  HTML_comment::showFile($file,$option);
}

function saveLanguage($file, $filecontent, $option) {

  @chmod ($file, 0766);
  $permission = is_writable($file);
  if (!$permission) {
    mosRedirect("index2.php?option=$option&task=language", "File not writeable!");
    break;
  }

  if ($fp = fopen( $file, "w")) {
    fputs($fp,stripslashes($filecontent));
    fclose($fp);
    mosRedirect( "index2.php?option=$option&task=language", "Language file saved" );
  }
}