<?php /* $Id: mod_mainmenu.class.php,v 1.13 2004/01/13 20:36:55 ronbakker Exp $ */
/**
* Menu handling functions
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.13 $
**/

/**
* Utility function for writing a menu link
*/
function mosGetMenuLink( $mitem, $level=0, $class_sfx='' ) {
	global $Itemid, $mosConfig_live_site;
	$txt = '';

	switch ($mitem->type) {
		case 'separator';
		// do nothing
		break;

		case 'url':
		if (eregi( "index.php\?", $mitem->link )) {
			//$mitem->link .= "&Returnid=$Itemid";
			if (!eregi( "Itemid=", $mitem->link )) {
				$mitem->link .= "&Itemid=$mitem->id";
			}
		}
		break;

		default:
		$mitem->link .= "&Itemid=$mitem->id";
		break;
	}

	$mitem->link = str_replace( '&', '&amp;', $mitem->link );

	if (strcasecmp(substr($mitem->link,0,4),"http")) {
		$mitem->link = sefRelToAbs($mitem->link);
	}

	$menuclass = "mainlevel$class_sfx";
	if ($level > 0) {
		$menuclass = "sublevel$class_sfx";
	}

	switch ($mitem->browserNav) {
		// cases are slightly different
		case 1:
		// open in a new window
		$txt = "<a href=\"$mitem->link\" target=\"_window\" class=\"$menuclass\">$mitem->name</a>\n";
		break;

		case 2:
		// open in a popup window
		$txt = "<a href=\"#\" onClick=\"javascript: window.open('$mitem->link', '', 'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=780,height=550'); return false\" class=\"$menuclass\">$mitem->name</a>\n";
		break;

		case 3:
		// don't link it
		$txt = "<span class=\"$menuclass\">$mitem->name</span>\n";
		break;

		default:	// formerly case 2
		// open in parent window
		$txt = "<a href=\"$mitem->link\" class=\"$menuclass\">$mitem->name</a>\n";
		break;
	}

	return $txt;
}

/**
* Vertically Indented Menu
*/
function mosShowVIMenu( $menutype, $class_sfx ) {
	global $database, $my, $cur_template, $Itemid;
	global $mosConfig_absolute_path, $mosConfig_live_site, $mosConfig_shownoauth;

	/* If a user has signed in, get their user type */
	$intUserType = 0;
	if($my->gid){
		switch ($my->usertype)
		{
			case 'Super Administrator':
			$intUserType = 0;
			break;
			case 'Administrator':
			$intUserType = 1;
			break;
			case 'Editor':
			$intUserType = 2;
			break;
			case 'Registered':
			$intUserType = 3;
			break;
			case 'Author':
			$intUserType = 4;
			break;
			case 'Publisher':
			$intUserType = 5;
			break;
			case 'Manager':
			$intUserType = 6;
			break;
		}
	}
	else
	{
		/* user isn't logged in so make their usertype 0 */
		$intUserType = 0;
	}

	if ($mosConfig_shownoauth) {
		$sql = "SELECT m.* FROM #__menu AS m"
		. "\nWHERE menutype='$menutype' AND published='1'"
		//. "\nAND utaccess >= '$intUserType' "
		. "\nORDER BY parent,ordering";
	} else {
		$sql = "SELECT m.* FROM #__menu AS m"
		. "\nWHERE menutype='$menutype' AND published='1' AND access <= '$my->gid'"
		//. "\nAND utaccess >= '$intUserType' "
		. "\nORDER BY parent,ordering";
	}
	$database->setQuery( $sql	);
	//	$database->setQuery( "SELECT m.* FROM #__menu AS m"
	//	. "\nWHERE menutype='$menutype' AND published='1' AND access <= '$my->gid'"
	//	. "\nORDER BY parent,ordering"
	//	);

	$rows = $database->loadObjectList( 'id' );
	echo $database->getErrorMsg();
	// TODO: One day this should be user configurable
	if (file_exists( "$mosConfig_absolute_path/templates/$cur_template/images/indent1.png" )) {
		$imgpath = "$mosConfig_live_site/templates/$cur_template/images";
	} else {
		$imgpath = "$mosConfig_live_site/images/M_images";
	}
	$indents = array(
	// block prefix / item prefix / item suffix / block suffix
	array( "<table dir=rtl width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"1\">", "<tr align=\"right\"><td>&nbsp;" , "</td></tr>", "</table>" ),
	array( "", "<br /><img src=\"$mosConfig_live_site/images/M_images/blank.png\" alt=\"\" height=\"12\" width=\"4\" /><img src=\"$imgpath/indent1.png\" alt=\"\" />&nbsp;", "", "" ),
	array( "", "<br /><img src=\"$mosConfig_live_site/images/M_images/blank.png\" alt=\"\" height=\"12\" width=\"8\" /><img src=\"$imgpath/indent2.png\" alt=\"indent\" />&nbsp;", "", "" ),
	array( "", "<br /><img src=\"$mosConfig_live_site/images/M_images/blank.png\" alt=\"\" height=\"12\" width=\"12\" /><img src=\"$imgpath/indent3.png\" alt=\"indent\" />&nbsp;", "", "" ),
	array( "", "<br /><img src=\"$mosConfig_live_site/images/M_images/blank.png\" alt=\"\" height=\"12\" width=\"16\" /><img src=\"$imgpath/indent4.png\" alt=\"indent\" />&nbsp;", "", "" ),
	array( "", "<br /><img src=\"$mosConfig_live_site/images/M_images/blank.png\" alt=\"\" height=\"12\" width=\"20\" /><img src=\"$imgpath/indent5.png\" alt=\"indent\" />&nbsp;", "", "" ),
	array( "", "<br /><img src=\"$mosConfig_live_site/images/M_images/blank.png\" alt=\"\" height=\"12\" width=\"24\" /><img src=\"$imgpath/indent.png\" alt=\"indent\" />&nbsp;", "", "" )
	);

	// establish the hierarchy of the menu
	$children = array();
	// first pass - collect children
	foreach ($rows as $v ) {
		$pt = $v->parent;
		$list = @$children[$pt] ? $children[$pt] : array();
		array_push( $list, $v );
		$children[$pt] = $list;
	}

	// second pass - collect 'open' menus
	$open = array( $Itemid );
	$count = 20; // maximum levels - to prevent runaway loop
	$id = $Itemid;
	while (--$count) {
		if (isset($rows[$id]) && $rows[$id]->parent > 0) {
			$id = $rows[$id]->parent;
			$open[] = $id;
		} else {
			break;
		}
	}
	mosRecurseVIMenu( 0, 0, $children, $open, $indents, $class_sfx );
	//echo "<br />\n";

}

/**
* Utility function to recursively work through a vertically indented
* hierarchial menu
*/
function mosRecurseVIMenu( $id, $level, &$children, &$open, &$indents, $class_sfx ) {
	global $Itemid;
	if (@$children[$id]) {
		$n = min( $level, count( $indents )-1 );

		echo "\n".$indents[$n][0];
		foreach ($children[$id] as $row) {

			echo "\n".$indents[$n][1];

			echo mosGetMenuLink( $row, $level, $class_sfx );

			if (in_array( $row->id, $open )) {
				mosRecurseVIMenu( $row->id, $level+1, $children, $open, $indents, $class_sfx );
			}
			echo $indents[$n][2];
		}
		echo "\n".$indents[$n][3];
	}
}

/**
* Draws a horizontal 'flat' style menu (very simple case)
*/
function mosShowHFMenu( $menutype, $class_sfx ) {
	global $database, $my, $cur_template, $Itemid;
	global $mosConfig_absolute_path, $mosConfig_shownoauth;

	if ($mosConfig_shownoauth) {
		$sql = "SELECT m.* FROM #__menu AS m"
		. "\nWHERE menutype='$menutype' AND published='1' AND parent='0'"
		. "\nORDER BY ordering";
	} else {
		$sql = "SELECT m.* FROM #__menu AS m"
		. "\nWHERE menutype='$menutype' AND published='1' AND access <= '$my->gid' AND parent='0'"
		. "\nORDER BY ordering";
	}
	$database->setQuery( $sql );

	$rows = $database->loadObjectList( 'id' );
	echo $database->getErrorMsg();

	$links = array();
	foreach ($rows as $row) {
		$links[] = mosGetMenuLink( $row, 0, $class_sfx );
	}

	$menuclass = "mainlevel$class_sfx";

	if (count( $links )) {
		echo "<table dir=rtl width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"1\">\n";
		echo "<tr>\n<td nowrap=\"nowrap\">";
		echo implode( "<span class=\"$menuclass\"> | </span>", $links );
		echo "</td>\n</tr>\n";
		echo "</table>\n";
	}
}
?>
