<?php
// $Id: moscode.inc,v 1.2 2003/12/15 00:54:14 eddieajau Exp $
/**
* Page Break Mambot
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.2 $
* @author Andrew Eddie <eddieajau@user.sourceforge.net>
**/

defined( '_VALID_MOS' ) or die( '      ' );

function MAMBOT_highlight_code( &$row ) {
	// override default colours to something a bit better
	ini_set('highlight.html', '000000');
	ini_set('highlight.default', '#800000');
	ini_set('highlight.keyword','#0000ff');
	ini_set('highlight.string', '#ff00ff');
	ini_set('highlight.comment','#008000');

	// $bots holds all the mospagebreak mambots

	// next line is a fix for /m option not working as it should??
	$row->text = str_replace( "\n", "__CRLF__", $row->text );
	preg_match_all( "/{moscode}(.*?){\/moscode}/im", $row->text, $bots, PREG_SET_ORDER );

	// split the text around the mambot
	$text = preg_split( "/{moscode}(.*?){\/moscode}/im", $row->text );

	// count the number of pages
	$n = count( $text );
	if ($n > 1) {
		$row->text = '';
		for ($i=0; $i < $n; $i++) {
			$row->text .= str_replace( "__CRLF__", "\n", $text[$i] );
			if (trim( @$bots[$i][1] )) {
				$code = highlight_string( @$bots[$i][1], true );
				$code = str_replace( "\r", "", $code );
				$code = str_replace( "__CRLF__", "\n", $code );
				$row->text .= "<pre class=\"moscode\">$code</pre>";
			}
		}
	} else {
		$row->text = str_replace( "__CRLF__", "\n", $row->text );
	}
}
?>