<?php
// $Id: debug.php,v 1.7 2003/12/08 21:54:25 rcastley Exp $
/**
* Debug code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.7 $
**/

defined( '_VALID_MOS' ) or die( '      ' );

class mosDebug
{
	var $show			= false;
	var $depth			= 0;
	var	$dodebug		= 0;
	var	$setwindowfocus	= true;

	function mosDebug($dodebug)
	{
		$this->dodebug = $dodebug;
	}

	//
	// Format variable recursively based on type
	//
	function formatvar( &$var, $varname = "", $class = false)
	{
		if ($this->depth > 32)
		{
			return '<p>Recursive Depth Exceeded</p>';
		}
		$this->depth++;

		$displayStr = "";

		$varname = htmlspecialchars($varname);
		$type = gettype($var);

		if (is_string($var))
		{
			$var = htmlspecialchars($var);
			$displayStr = "<font color=\"red\"><b>$type: </b></font>";

			if ($varname!="")
			{
				$displayStr .= "<font color=\"blue\">$varname</font> = ";
			}

			$displayStr .= "<font color=\"black\">&quot;$var&quot;</font>";
		}
		else if (is_object($var))
		{
			$displayStr .= $this->formatvar(get_object_vars($var),$varname,get_class($var));
			$displayStr = substr($displayStr,0,strlen($displayStr)-4); // get rid of last BR
		}
		else if (is_array($var))
		{
			if ($class)
			{
				$t = "Class $class";
			}
			else
			{
				$t = 'Array';
			}

			$displayStr = "<font color=\"red\"><b>$t: </b></font>";

			if ($varname!="")
			{
				$displayStr .= " (<font color=\"blue\">$varname</font>) ";
			}
			$displayStr .= "<font color=\"black\"><ul>";

			foreach($var as $key => $varal)
			{
				$displayStr .= $this->formatvar($varal,$key);
			}
			$displayStr .= "</ul></font>";
		}
		else
		{
			if ($var === null)
			{
				$var = 'null';
			}
			else if ($var === false)
			{
				$var = 'false';
			}
			else if ($var === true)
			{
				$var = 'true';
			}

			$displayStr = "<font color=\"red\"><b>$type: </b></font>";

			if ($varname!="")
			{
				$displayStr .= "<font color=\"blue\">$varname</font> = ";
			}

			$displayStr .= "<font color=\"black\">$var</font>";
		}

		$displayStr .= "<br />";
		$this->depth -= 1;
		return( $displayStr );
	}

	function _show()
	{
		if(!$this->dodebug)
		{
			return;
		}

		if (!$this->show)
		{
			global $PHP_SELF;
			$file = $PHP_SELF;
			$displayStr = "<title>MOS Debug Console</title><TABLE width=100% CELLSPACING=0 CELLPADDING=0 BORDER=0><TR><TD><HR SIZE=1></TD><TD WIDTH=1%><FONT FACE='Verdana,arial' SIZE=1>".date("d.m.Y")."&nbsp;".date("H:i:s")."</FONT></TD></TR></TABLE>";
		?>
		<script language="javascript" type="text/javascript">
		var mosdebugw=window.open('',"DEBUGVAR","WIDTH=450,HEIGHT=500,scrollbars=yes,resizable=yes");
		if (mosdebugw)
		{
		<?php
		if($this->setwindowfocus)
		{
			?>
			mosdebugw.focus();
			<?php
		}
			?>
			mosdebugw.document.write("<?php echo $displayStr;?>"+'<b>'+window.location.href+'</b></p>');
		}
		</script>
		<?php
			$this->show = true;
		}
	}

	//
	// display message in debug window
	//
	function message($displayStr, $encode = true)
	{
		$this->_show();
		if ($encode)
		{
			$displayStr = htmlspecialchars($displayStr).'<p>';
		}
		$displayStr = str_replace('\\','\\\\',$displayStr);
		$displayStr = str_replace('"','\"',$displayStr);
		$displayStr = str_replace("\r",' ',$displayStr);
		$displayStr = str_replace("\n",' ',$displayStr);
	?>
	<script language="Javascript1.2" type="text/javascript">
		if (mosdebugw)
		{
			mosdebugw.document.write("<?php echo $displayStr; ?>");
			mosdebugw.scrollBy(0,100000);
		}
	</script>
	<?php
	}

	//
	// display variable in debug window
	//
	function showvar($var, $varname = "")
	{
		if (!$this->dodebug) {
			return;
		}
		$this->_show();

		$displayStr = $this->formatvar($var,$varname);

		if (!is_object($var) and !is_array($var))
		{
			$displayStr .= '<br />';
		}
		$this->message($displayStr,false);
	}
}

function mosDebugVar($var, $change_focus_window = false)
{
	global $mosDebug,$mainframe;

	if(!is_object($mosDebug))
	$mosDebug = new mosDebug(true);

	if ($mainframe->getCfg( 'debug' ))
	{
		if($change_focus_window)
		{
			$mosDebug->setwindowfocus = ($mosDebug->setwindowfocus ? false : true);
		}
		$mosDebug->showvar($var);
	}
}

function mosDebugMessage($msg,$change_focus_window = false)
{
	global $mosDebug,$mainframe;

	if(!is_object($mosDebug))
	$mosDebug = new mosDebug(true);

	if ($mainframe->getCfg( 'debug' ))
	{
		if($change_focus_window)
		{
			$mosDebug->setwindowfocus = ($mosDebug->setwindowfocus ? false : true);
		}

		$mosDebug->message($msg);
	}
}
?>