<?php
// $Id: admin.newsflash.php,v 1.15 2004/02/29 13:27:51 rcastley Exp $
/**
* Newsflash admin component code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.15 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

// ensure user has access to this function
if (!($acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'all' )
		| $acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'com_newsflash' ))) {
	mosRedirect( 'index2.php', _NOT_AUTH );
}

require_once( $mainframe->getPath( 'admin_html' ) );

/**
*  Table Class
*
* Provides access to the mos_newsflash table
*/
class mosNewsflash extends mosDBTable {
	/** @var int Unique id*/
	var $id=null;
	/** @var string */
	var $title=null;
	/** @var string */
	var $content=null;
	/** @var int */
	var $published=null;
	/** @var int */
	var $checked_out=null;
	/** @var datetime */
	var $checked_out_time=null;
	/** @var datetime */
	var $publish_up=null;
	/** @var datetime */
	var $publish_down=null;
	/** @var int */
	var $catid=null;
	/** @var int */
	var $access=null;
	/**
	* @param database A database connector object
	*/
	function mosNewsflash( &$database ) {
		$this->mosDBTable( '#__newsflash', 'id', $database );
	}
}

$cid = mosGetParam( $_POST, 'cid', array(0) );
if (!is_array( $cid )) {
	$cid = array(0);
}

switch ($task)
{
	case "new":
		editNewsflash( 0, $option);
		break;

	case "edit":
		editNewsflash( $cid[0], $option );
		break;

	case "save":
		saveNewsflash( $option );
		break;

	case "remove":
		removeNewsflash( $cid, $option );
		break;

	case "publish":
		publishNewsflash( $cid, 1, $option );
		break;

	case "unpublish":
		publishNewsflash( $cid, 0, $option );
		break;

	case "cancel":
		cancelNewsflash( $option );
		break;

	default:
		viewNewsflash( $option );
		break;
}

function viewNewsflash( $option) {
	global $database, $mainframe;

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );
	$search = $mainframe->getUserStateFromRequest( "search{$option}", 'search', '' );
	$search = $database->getEscaped( trim( strtolower( $search ) ) );

	$where = "";
	if ($search) {
		$where = " WHERE a.title LIKE '%$search%' OR a.content LIKE '%$search%'";
	}

	$database->setQuery( "SELECT COUNT(*) FROM #__newsflash AS a $where" );
	$total = $database->loadResult();

	require_once( "includes/pageNavigation.php" );
	$pageNav = new mosPageNav( $total, $limitstart, $limit  );

	$database->setQuery( "SELECT a.*, u.name AS editor, g.name AS groupname"
	. "\nFROM #__newsflash AS a"
	. "\nLEFT JOIN #__users AS u ON u.id=a.checked_out"
	. "\nLEFT JOIN #__groups AS g ON g.id = a.access"
	. "\n$where LIMIT $pageNav->limitstart,$pageNav->limit"
	);
	$rows = $database->loadObjectList();

	HTML_newsflash::showNewsflash( $rows, $search, $pageNav, $option );
}

function editNewsflash( $uid, $option ) {
	global $database, $my;

	$row = new mosNewsflash( $database );
	// load the row from the db table
	$row->load( $uid );

	//echo "<pre>"; print_r ($row); echo "</pre>";
	if ($uid) {
		$row->checkout( $my->id );
	} else {
		// initialise new record
		$row->published = 0;
	}

	// make the select list for the image positions
	$yesno[] = mosHTML::makeOption( '0', '' );
	$yesno[] = mosHTML::makeOption( '1', '' );

	// build the html select list
	$publist = mosHTML::selectList( $yesno, 'published', 'class="inputbox" size="2"',
	'value', 'text', $row->published );

	// get list of groups
	$database->setQuery( "SELECT id AS value, name AS text FROM #__groups ORDER BY id" );
	$groups = $database->loadObjectList();	if (!($orders = $database->loadObjectList())) {
		echo $database->stderr();
		return false;
	}

	// build the html select list
	$glist = mosHTML::selectList( $groups, 'access', 'class="inputbox" size="1"',
	'value', 'text', intval( $row->access ) );


	HTML_newsflash::editNewsflash( $row, $publist, $option , $glist );
}

function saveNewsflash( $option ) {
	global $database, $my;

	$row = new mosNewsflash( $database );
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	mosMakeHtmlSafe($row->title);

	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();

	mosRedirect( "index2.php?option=$option" );
}

/**
* Publishes or Unpublishes one or more records
* @param database A database connector object
* @param array An array of unique category id numbers
* @param integer 0 if unpublishing, 1 if publishing
* @param string The current url option
*/
function publishNewsflash( $cid=null, $publish=1, $option ) {
	global $database, $my;

	if (!is_array( $cid ) || count( $cid ) < 1) {
		$action = $publish ? 'publish' : 'unpublish';
		echo "<script> alert('Select an item to $action'); window.history.go(-1);</script>\n";
		exit;
	}

	$cids = implode( ',', $cid );

	$database->setQuery( "UPDATE #__newsflash SET published='$publish'"
	. "\nWHERE id IN ($cids) AND (checked_out=0 OR (checked_out='$my->id'))"
	);
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (count( $cid ) == 1) {
		$row = new mosNewsflash( $database );
		$row->checkin( $cid[0] );
	}
	mosRedirect( "index2.php?option=$option" );
}

/**
* Deletes one or more records
* @param array An array of unique category id numbers
* @param string The current url option
*/
function removeNewsflash( $cid, $option ) {
	global $database;

	if (count( $cid )) {
		$cids = implode( ',', $cid );
		$database->setQuery( "DELETE FROM #__newsflash WHERE id IN ($cids)" );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		}
	}

	mosRedirect( "index2.php?option=$option" );
}

/**
* Cancels an edit operation
* @param string The current url option
*/
function cancelNewsflash( $option ) {
	global $database;
	$row = new mosNewsflash( $database );
	$row->bind( $_POST );
	$row->checkin();
	mosRedirect( "index2.php?option=$option" );
}
?>
