<?php
// $Id: url.class.php,v 1.7 2003/12/11 23:55:36 eddieajau Exp $
/**
* Administrator menu url class
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.7 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

/**
*/
class url_menu {
/**
* @param database A database connector object
* @param integer The unique id of the category to edit (0 if new)
*/
	function edit( &$uid, $menutype, $option ) {
		global $database, $my;
		global $mosConfig_absolute_path;

		$menu = new mosMenu( $database );
		$menu->load( $uid );

		// fail if checked out not by 'me'
		if ($menu->checked_out && $menu->checked_out <> $my->id) {
			echo "<script>alert('The module $menu->title is currently being edited by another administrator'); document.location.href='index2.php?option=$option'</script>\n";
			exit(0);
		}

		if ($uid) {
			$menu->checkout( $my->id );
		} else {
			$menu->type = 'url';
			$menu->menutype = $menutype;
			$menu->browserNav = 0;
			$menu->ordering = 9999;
			$menu->parent = intval( mosGetParam( $_POST, 'parent', 0 ) );
		}

	// build the html select list for ordering
		if ($uid) {
			$order = mosGetOrderingList( "SELECT ordering AS value, name AS text"
				. "\nFROM #__menu"
				. "\nWHERE menutype='$menu->menutype' AND parent='$menu->parent'"
				. "\nORDER BY ordering"
			);
			$olist = mosHTML::selectList( $order, 'ordering', 'class="inputbox" size="1"',
				'value', 'text', intval( $menu->ordering ) );
		} else {
			$olist = "<input type=\"hidden\" name=\"ordering\" value=\"$menu->ordering\" />"
				. "      ";
		}

	// get list of groups
		$database->setQuery( "SELECT id AS value, name AS text FROM #__groups ORDER BY id" );
		$groups = $database->loadObjectList();

	// build the html select list for the group access
		$glist = mosHTML::selectList( $groups, 'access', 'class="inputbox" size="5"',
			'value', 'text', intval( $menu->access ) );

	// build html for browser navigation
		$click[] = mosHTML::makeOption( '0', '  ' );
		$click[] = mosHTML::makeOption( '1', '  ' );
		$click[] = mosHTML::makeOption( '2', '      ' );

		$clist = mosHTML::selectList( $click, 'browserNav', 'class="inputbox" size="3"',
			'value', 'text', intval( $menu->browserNav ) );

	// menu parent item
	// get a list of the menu items
		$database->setQuery( "SELECT m.*"
			. "\nFROM #__menu m"
			. "\nWHERE menutype='$menu->menutype'"
			. "\nORDER BY ordering"
		);
		$mitems = $database->loadObjectList();

	// establish the hierarchy of the menu
		$children = array();
	// first pass - collect children
		foreach ($mitems as $v ) {
			$pt = $v->parent;
			$list = @$children[$pt] ? $children[$pt] : array();
			array_push( $list, $v );
			$children[$pt] = $list;
		}
	// second pass - get an indent list of the items
		$list = mosTreeRecurse( 0, '', array(), $children );

	// assemble menu items to the array
		$mitems = array();
		$mitems[] = mosHTML::makeOption( '0', '' );
		$this_treename = '';
		foreach ($list as $item) {
			if ($this_treename) {
				if ($item->id != $menu->id && strpos( $item->treename, $this_treename ) === false) {
					$mitems[] = mosHTML::makeOption( $item->id, $item->treename );
				}
			} else {
				if ($item->id != $menu->id) {
					$mitems[] = mosHTML::makeOption( $item->id, $item->treename );
				} else {
					$this_treename = "$item->treename/";
				}
			}
		}

	// build the html select list
		$parlist = mosHTML::selectList( $mitems, 'parent', 'class="inputbox" size="1"',
			'value', 'text', $menu->parent );

		url_menu_html::edit( $menu, $olist, $glist, $clist, $parlist, $option );
	}
}
?>
