<?php
// $Id: admin.languages.php,v 1.7 2004/03/28 21:47:36 rcastley Exp $
//
// Copyright (C) 2000-2003 Miro International Pty Ltd
// All rights reserved.
//
// This source file is part of the Mambo Open Source Content
// Management System.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html.

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

// ensure user has access to this function
if (!$acl->acl_check( 'administration', 'config', 'users', $my->usertype )) {
	mosRedirect( 'index2.php', _NOT_AUTH );
}


require_once( $mainframe->getPath( 'admin_html' ) );
// XML library
require_once( "$mosConfig_absolute_path/administrator/classes/minixml/minixml.inc.php" );

$task = trim( strtolower( mosGetParam( $_REQUEST, "task", "" ) ) );
$cid = mosGetParam( $_REQUEST, "cid", array(0) );

if (!is_array( $cid )) {
	$cid = array(0);
}

switch ($task) {
	case "new":
		mosRedirect ("index2.php?option=language_installer");
		break;

	case "edit_source":
		editLanguageSource( $cid[0], $option );
		break;

	case "save_source":
		saveLanguageSource( $option );
		break;

	case "remove":
		removeLanguage( $cid[0], $option );
		break;

	case "publish":
		publishLanguage( $cid[0], $option );
		break;

	case "cancel":
		mosRedirect( "index2.php?option=$option" );
		break;

	default:
		viewLanguages( $option );
		break;
}

/**
* Compiles a list of installed languages
*/
function viewLanguages( $option ) {
	global $languages;
	global $mainframe;
	global $mosConfig_lang, $mosConfig_absolute_path;

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );

	// get current languages
	$cur_language = $mosConfig_lang;

	$rows = array();
	// Read the template dir to find templates
	$languageBaseDir = mosPathName(mosPathName($mosConfig_absolute_path) . "language");

	$rowid = 0;

	$xmlFilesInDir = mosReadDirectory($languageBaseDir,".xml");

	$dirName = $languageBaseDir;
	//mosDebugVar($xmlFilesInDir);
	foreach($xmlFilesInDir as $xmlfile) {
		// Read the file to see if it's a valid template XML file
		$xmlDoc = new MiniXMLDoc($dirName . $xmlfile);
		$xmlDoc->fromFile($dirName . $xmlfile);

		$element = &$xmlDoc->getElementByPath('mosinstall');

		mosDebugVar($element);

		if (is_null( $element )) {
			continue;
		}
		if ($element->attribute( "type" ) != "language") {
			continue;
		}

		$row = new StdClass();
		$row->id = $rowid;
		$row->language = substr($xmlfile,0,-4);
		$element = &$xmlDoc->getElementByPath('mosinstall/name');
		$row->name = $element->getValue();

		$element = &$xmlDoc->getElementByPath('mosinstall/version');
		$row->version = $element->getValue();

		$element = &$xmlDoc->getElementByPath('mosinstall/creationDate');
		$row->creationdate = $element->getValue();

		$element = &$xmlDoc->getElementByPath('mosinstall/author');
		$row->author = $element->getValue();

		$element = &$xmlDoc->getElementByPath('mosinstall/authoremail');
		$row->authoremail = $element->getValue();

		// if current than set published
		if ($cur_language == $row->language) {
			$row->published	= 1;
		} else {
			$row->published = 0;
		}

		$row->checked_out = 0;
		$row->mosname = strtolower( str_replace( " ", "_", $row->name ) );
		$rows[] = $row;
		$rowid++;
	}

        require_once("includes/pageNavigation.php");
	$pageNav = new mosPageNav( count( $rows ), $limitstart, $limit );

	$rows = array_slice( $rows, $pageNav->limitstart, $pageNav->limit );

	HTML_languages::showLanguages( $cur_language, $rows, $pageNav, $option );
}

/**
* Publish, or make current, the selected language
*/
function publishLanguage( $p_lname, $option ) {
	global $mosConfig_lang;

	$config = "";

	$fp = fopen("../configuration.php","r");
	while(!feof($fp)){
	    $buffer = fgets($fp,4096);
	    if (strstr($buffer,"\$mosConfig_lang")){
	      $config .= "\$mosConfig_lang = \"$p_lname\";\n";
	    } else {
	      $config .= $buffer;
	    }
	}
	fclose($fp);

	if ($fp = fopen("../configuration.php","w")){
	    fputs($fp, $config, strlen($config));
	    fclose($fp);
	    mosRedirect("index2.php","Configuration succesfully updated!");
	} else {
	    mosRedirect("index2.php","Error! Make sure that configuration.php is writeable.");
	}

}

/**
* Remove the selected language
*/
function removeLanguage( $cid, $option ) {
	global $mosConfig_lang;

	$cur_language = $mosConfig_lang;

	if ($cur_language == $cid) {
		echo "<script>alert(\"You can not delete language in use.\"); window.history.go(-1); </script>\n";
		exit();
	}

	$lang_path = "../language/$cid.php";
	$xml_path = "../language/$cid.xml";

	unlink($lang_path);
	unlink($xml_path);

	mosRedirect("index2.php?option=$option");
}

function editLanguageSource( $p_lname, $option) {
	$file = stripslashes( "../language/$p_lname.php" );

	if ($fp = fopen( $file, "r" )) {
		$content = fread( $fp, filesize( $file ) );
		$content = htmlspecialchars( $content );

		HTML_languages::editLanguageSource( $p_lname, $content, $option );
	} else {
		mosRedirect( "index2.php?option=$option&mosmsg=Operation Failed: Could not open $file" );
	}
}

function saveLanguageSource( $option ) {
	$language = trim( mosGetParam( $_POST, 'language', '' ) );
	$filecontent = mosGetParam( $_POST, 'filecontent', '', _MOS_ALLOWHTML );

	if (!$language) {
		mosRedirect( "index2.php?option=$option&mosmsg=Operation failed: No language specified." );
	}
	if (!$filecontent) {
		mosRedirect( "index2.php?option=$option&mosmsg=Operation failed: Content empty." );
	}

	$file = "../language/$language.php";
	if (is_writable( $file ) == false) {
		mosRedirect( "index2.php?option=$option&mosmsg=Operation failed: The file is not writable." );
	}

	if ($fp = fopen ($file, "w")) {
		fputs( $fp, stripslashes( $filecontent ) );
		fclose( $fp );
		mosRedirect( "index2.php?option=$option" );
	} else {
		mosRedirect( "index2.php?option=$option&mosmsg=Operation failed: Failed to open file for writing." );
	}

}

?>
