<?php
// $Id: admin.help.php,v 1.3 2003/09/24 23:36:26 eddieajau Exp $
/**
* Administrator help event handler
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.3 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

require_once( $mainframe->getPath( 'admin_html' ) );
require_once( $mainframe->getPath( 'class' ) );

// Set default values to prevent errors in case of error_reporting(E_ALL)
$file		= mosGetParam( $_REQUEST, "file", "" );
$task		= mosGetParam( $_REQUEST, "task", "" );
$helpid		= intval( mosGetParam( $_REQUEST, "helpid", 0 ) );
$catid		= intval( mosGetParam( $_REQUEST, "catid", 0 ) );

switch( $task )
{
	case "helpsearch":
		HTML_help::mosHelp_ShowHelpSearchResult( "Search in help",
												  $helpsearchvalue,
												  mosHelp_Search($helpsearchvalue)
												  );
		break;

	case "remove":
		mosHelp_DeleteHelp( $helpid );
		mosHelp_ShowHelpIndex( $catid );
		break;

	case "new":
		mosHelp_editHelp( 0 );
		break;

	case "edit":
		mosHelp_editHelp( $helpid );
		break;

	case "save":
		mosHelp_SaveHelp();
		mosHelp_ShowHelpIndex( $catid );
		break;

	case "showhelp":
		$helpdocument = new mosHelp( $database );
		$helpdocument->load( $helpid );

		$helpcat = new mosCategory( $database );
		$helpcat->load( $helpdocument->catid );

		HTML_help::mosHelp_ShowHelp( "$helpcat->title Index",
									$helpdocument,
									mosHelp_GetHelpIndexDB( $catid, $helpdocument->id));
		break;

	default:
		mosHelp_ShowHelpIndex( $catid );
		break;
}

//
// Below this we have helper functions
//

function mosHelp_editHelp( $helpid=0 ) {
	global $database;

	$row = new mosHelp( $database );
	$row->load( $helpid );

	if ($row->id) {
	} else {
		// populate vars for new entry
		$row->ordering = 9999;
	}

	// get list of categories
	$categories[] = mosHTML::makeOption( '0', ' ' );
	$database->setQuery( "SELECT id AS value, name AS text FROM #__categories"
	. "\nWHERE section='help' ORDER BY ordering" );
	$categories = array_merge( $categories, $database->loadObjectList() );

	if (count( $categories ) < 1) {
		mosRedirect( "index2.php?option=categories&section=help",
		"    " );
	}

	$catlist = mosHTML::selectList( $categories, 'catid', 'class="inputbox" size="1"',
	'value', 'text', intval( $row->catid ) );

	if ($helpid) {
	// build the html select list for ordering
		$orders = mosGetOrderingList( "SELECT ordering AS value, name AS text"
			. "\nFROM #__help"
			. "\nWHERE catid='$row->catid' AND parent='$row->parent'"
			. "\nORDER BY ordering"
		);
		$orderlist = mosHTML::selectList( $orders, 'ordering', 'class="inputbox" size="1"',
			'value', 'text', intval( $row->ordering ) );
	} else {
		$orderlist = 'New items placed last '
			. '<input type="hidden" name="ordering" value="9999" />';
	}

// get list of parent help items
// get a list of the menu items
	$database->setQuery( "SELECT m.*"
		. "\nFROM #__help m"
		. "\nWHERE catid='$row->catid'"
		. "\nORDER BY ordering"
	);
	$items = $database->loadObjectList();

// establish the hierarchy of the menu
	$children = array();
// first pass - collect children
	foreach ($items as $v ) {
		$pt = $v->parent;
		$list = @$children[$pt] ? $children[$pt] : array();
		array_push( $list, $v );
		$children[$pt] = $list;
	}
// second pass - get an indent list of the items
	$list = mosTreeRecurse( 0, '', array(), $children );

// assemble menu items to the array
	$items = array();
	$items[] = mosHTML::makeOption( '0', 'Top Level' );
	foreach ($list as $item) {
		//if ($item->id != $menu->id) {
			$items[] = mosHTML::makeOption( $item->id, $item->treename );
		//}
	}

// build the html select list
	$parlist = mosHTML::selectList( $items, 'parent', 'class="inputbox" size="1"',
		'value', 'text', $row->parent );


	HTML_help::mosHelp_ShowHelpForm(
		"Section",
		$catlist,
		$orderlist,
		$parlist,
		$row
	);
}

function mosHelp_ShowHelpIndex( $catid )
{
	global $database;

	if ($catid == 0) {
		$database->setQuery( "SELECT id FROM #__categories"
			. "\nWHERE section='help' ORDER BY ordering"
			. "\nLIMIT 1"
		);
		$catid = $database->loadResult();
	}

	$helpcat = new mosCategory( $database );
	$helpcat->load( $catid );

	HTML_help::mosHelp_ShowHelpIndex( $helpcat->id, "Mambo Help - $helpcat->name",
										   mosHelp_GetHelpIndexDB( $catid ));
}

function mosHelp_SaveHelp()
{
	global $database;

	$row = new mosHelp($database);

	if (!$row->bind( $_POST ))
	{
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (!$row->check())
	{
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (!$row->store())
	{
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();
	$row->updateOrder( "catid='$row->catid' AND parent='$row->parent'" );
}

function mosHelp_DeleteHelp($id)
{
	global $database;
	$row = new mosHelp($database);
	$row->id = $id;
	$row->delete();
}

function mosHelp_GetHelpIndexDB( $catid, $parent = 0)
{
	global $database;

	$helpfiles	= array();

	$sql = "SELECT * FROM #__help WHERE catid=$catid AND parent=$parent ORDER BY ordering,id";
	$database->setQuery($sql);
	if($database->query())
	{
		$helpfiles = $database->loadObjectList();
	}
	else
	{
		die ($database->stderr(true));
	}

	return $helpfiles;
}

function mosHelp_GetAllHelpPages( $catid=0 )
{
	global $database;
	$helpfiles	= array();

	$database->setQuery( "SELECT * FROM #__help WHERE catid=$catid" );

	if($database->query())
	{
		$helpfiles = $database->loadObjectList();
	}
	else
	{
		die($database->stderr(true));
	}

	return $helpfiles;
}

function mosHelp_Search($helpsearchvalue)
{
	global $database;

	$searchresult = array();

	if(empty($helpsearchvalue))
	{
		return $searchresult;
	}

	$sql	= "select * from #__help where helptext like '%" . addslashes($helpsearchvalue) . "%' or title like '%" . addslashes($helpsearchvalue) . "%'";
	$database->setQuery($sql);

	if($database->query())
	{
		$searchresult = $database->loadObjectList();
	}
	else
	{
		die ($database->stderr(true));
	}

	return $searchresult;
}

function array_csort($marray, $column)
{
	foreach ($marray as $row) {
		$sortarr[] = $row[$column];
	}

	array_multisort($sortarr, $marray);
	return $marray;
}

function minimum_version( $vercheck )
{
	$minver = explode(".", $vercheck);
	$curver = explode(".", phpversion());
	if (
		($curver[0] < $minver[0])
		||
		(($curver[0] == $minver[0]) && ($curver[1] < $minver[1]))
		||
		(($curver[0] == $minver[0]) && ($curver[1] == $minver[1])
		&& ($curver[2][0] < $minver[2][0]))
		)
	{
		return false;
	}
	else
	{
		return true;
	}
}
?>
