<?php
// $Id: admin.config.php,v 1.31 2004/02/08 13:48:02 saka_car Exp $
/**
* Config admin
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.31 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

if (!$acl->acl_check( 'administration', 'config', 'users', $my->usertype )) {
	mosRedirect( 'index2.php', _NOT_AUTH );
}

class mosConfig extends mosDBTable {
	var $config_editor=null;
	var $config_offline=null;
	var $config_host=null;
	var $config_user=null;
	var $config_password=null;
	var $config_db=null;
	var $config_dbprefix=null;
	var $config_lang=null;
	//var $config_defaultpage=null;
	var $config_path=null;
	var $config_live_site=null;
	var $config_sitename=null;
	var $config_auth=null;
	var $config_lifetime=null;
	var $config_offline_message=null;
	var $config_error_message=null;
	var $config_usebanner=null;
	var $config_emailpass=null;
	var $config_metadesc=null;
	var $config_metakeys=null;
	var $config_debug=0;
	var $config_locale=null;
	var $config_offset=null;
	var $config_hideauthor=null;
	var $config_hidecreate=null;
	var $config_hidemodify=null;
	var $config_hidepdf=null;
	var $config_hideprint=null;
	var $config_hideemail=null;
	var $config_enable_log_items=null;
	var $config_enable_log_searches=null;
	var $config_sef=0;
	var $config_vote=0;
	var $config_gzip=0;
	var $config_multipage_toc=0;
	var $config_allowUserRegistration=0;
	var $config_error_reporting=0;
	var $config_link_titles=0;
	var $_alias=null;

	function mosConfig() {
		$this->_alias = array(
		'config_editor'			=>'mosConfig_editor',
		'config_offline'		=>'mosConfig_offline',
		'config_host'			=>'mosConfig_host',
		'config_user'			=>'mosConfig_user',
		'config_password'		=>'mosConfig_password',
		'config_db'			=>'mosConfig_db',
		'config_dbprefix'		=>'mosConfig_dbprefix',
		'config_lang'			=>'mosConfig_lang',
		//'config_defaultpage'		=>'mosConfig_defaultpage',
		'config_path'			=>'mosConfig_absolute_path',
		'config_live_site'		=>'mosConfig_live_site',
		'config_sitename'		=>'mosConfig_sitename',
		'config_auth'			=>'mosConfig_shownoauth',
		'config_emailpass'		=>'mosConfig_emailpass',
		'config_offline_message'	=>'mosConfig_offline_message',
		'config_error_message'		=>'mosConfig_error_message',
		'config_usebanner'		=>'mosConfig_UseBanner',
		'config_lifetime'		=>'mosConfig_lifetime',
		'config_metadesc'		=>'mosConfig_MetaDesc',
		'config_metakeys'		=>'mosConfig_MetaKeys',
		'config_debug' 			=>'mosConfig_debug',
		'config_locale'			=>'mosConfig_locale',
		'config_offset'			=>'mosConfig_offset',
		'config_hideauthor'		=>'mosConfig_hideAuthor',
		'config_hidecreate'		=>'mosConfig_hideCreateDate',
		'config_hidemodify'		=>'mosConfig_hideModifyDate',
		'config_hidepdf'		=>'mosConfig_hidePdf',
		'config_hideprint'		=>'mosConfig_hidePrint',
		'config_hideemail'		=>'mosConfig_hideEmail',
		'config_enable_log_items'	=>'mosConfig_enable_log_items',
		'config_enable_log_searches'	=>'mosConfig_enable_log_searches',
		'config_sef'			=>'mosConfig_sef',
		'config_vote'			=>'mosConfig_vote',
		'config_gzip'			=>'mosConfig_gzip',
		'config_multipage_toc'		=>'mosConfig_multipage_toc',
		'config_allowUserRegistration'	=>'mosConfig_allowUserRegistration',
		'config_error_reporting'	=>'mosConfig_error_reporting',
		'config_link_titles'	=>'mosConfig_link_titles'
		);
	}

	function getVarText() {
		$txt = '';
		foreach ($this->_alias as $k=>$v) {
			$txt .= "\$$v = '".addslashes( $this->$k )."';\n";
		}
		return $txt;
	}

	function bindGlobals() {
		foreach ($this->_alias as $k=>$v) {
			if(isset($GLOBALS[$v]))
			$this->$k = $GLOBALS[$v];
			else
			$this->$k = "";
		}
	}
}

require_once("components/com_config/admin.config.html.php");
$confightml = new HTML_config();


switch ($task) {
	case "save":
	saveconfig();
	break;

	default:
	showconfig($confightml, $database, $option);
	break;
}


function showconfig($confightml, &$database, $option) {
	global $mosConfig_absolute_path;
	$row = new mosConfig();
	$row->bindGlobals();

	// compile list of the languages
	$langs = array();
	$menuitems = array();

	if ($handle=opendir("../language/")) {
		$i=0;
		while ($file = readdir($handle)) {
			if (!strcasecmp(substr($file,-4),".php") && $file <> "." && $file <> ".." && strcasecmp(substr($file,-11),".ignore.php")) {
				$langs[] = mosHTML::makeOption( substr($file,0,-4) );
			}
		}
	}

	// sort list of languages
	sort($langs);
	reset($langs);

	$lists = array();
	// build the html select list
	$lists['lang'] = mosHTML::selectList( $langs, 'config_lang', 'class="inputbox" size="1"',
	'value', 'text', $row->config_lang );

	// make a generic -24 - 24 list
	for ($i=-24;$i<=24;$i++) {
		$timeoffset[] = mosHTML::makeOption( $i, $i );
	}

	// get list of menuitems
	$database->setQuery( "SELECT id AS value, name AS text FROM #__menu"
	. "\nWHERE (type='content_section' OR type='components' OR type='content_typed')"
	. "\nAND published=1 AND access=0 ORDER BY name" );
	$menuitems = array_merge( $menuitems, $database->loadObjectList() );

	/*$defpagelist = mosHTML::selectList( $menuitems, 'config_defaultpage', 'class="inputbox" size="1";"',
	'value', 'text', $row->config_defaultpage );*/

	// build the html select lists
	$lists['offline'] = mosHTML::yesnoSelectList( 'config_offline', 'class="inputbox" size="1"', $row->config_offline );

	$lists['auth'] = mosHTML::yesnoSelectList( 'config_auth', 'class="inputbox" size="1"', $row->config_auth );

	$lists['emailpass'] = mosHTML::yesnoSelectList( 'config_emailpass', 'class="inputbox" size="1"',	$row->config_emailpass );

	$lists['allowuserregistration'] = mosHTML::yesnoSelectList( 'config_allowUserRegistration', 'class="inputbox" size="1"',	$row->config_allowUserRegistration );

	$lists['usebanner'] = mosHTML::yesnoSelectList( 'config_usebanner', 'class="inputbox" size="1"',	$row->config_usebanner );

	$lists['debug'] = mosHTML::yesnoSelectList( 'config_debug', 'class="inputbox" size="1"', $row->config_debug );

	$lists['offset'] = mosHTML::selectList( $timeoffset, 'config_offset', 'class="inputbox" size="1"',	'value', 'text', $row->config_offset );

	$lists['hideauthor'] = mosHTML::yesnoSelectList( 'config_hideauthor', 'class="inputbox" size="1"',	$row->config_hideauthor );

	$lists['hidecreate'] = mosHTML::yesnoSelectList( 'config_hidecreate', 'class="inputbox" size="1"',	$row->config_hidecreate );

	$lists['hidemodify'] = mosHTML::yesnoSelectList( 'config_hidemodify', 'class="inputbox" size="1"', $row->config_hidemodify );

	if (is_writable( "$mosConfig_absolute_path/media/" )) {
		$lists['hidepdf'] = mosHTML::yesnoSelectList( 'config_hidepdf', 'class="inputbox" size="1"',	$row->config_hidepdf );
	} else {
		$lists['hidepdf'] = "<input type=\"hidden\" name=\"config_hidepdf\" value=\"1\" /><strong>Yes</strong>";
	}

	$lists['hideprint'] = mosHTML::yesnoSelectList( 'config_hideprint', 'class="inputbox" size="1"',	$row->config_hideprint );

	$lists['hideemail'] = mosHTML::yesnoSelectList( 'config_hideemail', 'class="inputbox" size="1"',	$row->config_hideemail );

	$lists['log_items'] = mosHTML::yesnoSelectList( 'config_enable_log_items', 'class="inputbox" size="1"', $row->config_enable_log_items );

	$lists['log_searches'] = mosHTML::yesnoSelectList( 'config_enable_log_searches', 'class="inputbox" size="1"', $row->config_enable_log_searches );

	$lists['sef'] = mosHTML::yesnoSelectList( 'config_sef', 'class="inputbox" size="1" onChange="javascript: if (document.adminForm.config_sef.value==\'1\') { alert(\'Remember to rename htaccess.txt to .htaccess\') }"', $row->config_sef );

	$lists['vote'] = mosHTML::yesnoSelectList( 'config_vote', 'class="inputbox" size="1"', $row->config_vote );

	$lists['gzip'] = mosHTML::yesnoSelectList( 'config_gzip', 'class="inputbox" size="1"', $row->config_gzip );

	$lists['multipage_toc'] = mosHTML::yesnoSelectList( 'config_multipage_toc', 'class="inputbox" size="1"', $row->config_multipage_toc );

	$errors = array(
		mosHTML::makeOption( -1, '' ),
		mosHTML::makeOption( 0, ' ' ),
		mosHTML::makeOption( E_ERROR|E_WARNING|E_PARSE, '' ),
		mosHTML::makeOption( E_ALL , '' )
	);
	$lists['error_reporting'] = mosHTML::selectList( $errors, 'config_error_reporting', 'class="inputbox" size="1"', 'value', 'text', $row->config_error_reporting );

	$lists['link_titles'] = mosHTML::yesnoSelectList( 'config_link_titles', 'class="inputbox" size="1"', $row->config_link_titles );

	$confightml->showconfig( $row, $lists, $option );
}

function saveconfig() {
	$row = new mosConfig();
	if (!$row->bind( $_POST )) {
		mosRedirect( "index2.php", $row->getError() );
	}

	$config = "<?php\n";

	$config .= $row->getVarText();
	$config .= "setlocale (LC_TIME, \$mosConfig_locale);\n";
	$config .= "?>";

	if ($fp = fopen("../configuration.php", "w")) {
		fputs($fp, $config, strlen($config));
		fclose ($fp);

		mosRedirect( "index2.php", "The configuration details have been updated!" );
	} else {
		mosRedirect( "index2.php", "An Error Has Occurred! Unable to open config file to write!" );
	}
}
?>
