<?php
// $Id: admin.banners.php,v 1.16 2004/01/13 00:57:16 eddieajau Exp $
/**
* Banner admin
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.16 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

// ensure user has access to this function
if (!($acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'all' )
		| $acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'com_banners' ))) {
	mosRedirect( 'index2.php', _NOT_AUTH );
}

require_once( $mainframe->getPath( 'admin_html' ) );
require_once( $mainframe->getPath( 'class' ) );

$cid = mosGetParam( $_REQUEST, 'cid', array(0) );
if (!is_array( $cid )) {
	$cid = array(0);
}

switch ($task) {
// CLIENT EVENTS

	case "newclient":
		editBannerClient( 0, $option );
		break;

	case "editclient":
		editBannerClient( $cid[0], $option );
		break;

	case "saveclient":
		saveBannerClient( $option );
		break;

	case "removeclients":
		removeBannerClients( $cid, $option );
		break;

	case "cancelclient":
		cancelEditClient( $option );
		break;

	case "listclients":
		viewBannerClients( $option );
		break;

// BANNER EVENTS

	case "new":
		editBanner( null, $option);
		break;

	case "cancel":
		cancelEditBanner( $option);
		break;

	case "save":
		saveBanner( $option);
		break;

	case "edit":
		editBanner( $cid[0], $option);
		break;

	case "remove":
		removeBanner( $cid, $option);
		break;

	case "publish":
		publishBanner( $cid,1,$option);
		break;

	case "unpublish":
		publishBanner( $cid, 0, $option);
		break;

	default:
		viewBanners( $option);
		break;
}

function viewBanners( $option ) {
	global $database, $mainframe;

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "viewban{$option}limitstart", 'limitstart', 0 );

	// get the total number of records
	$database->setQuery( "SELECT count(*) FROM #__banner" );
	$total = $database->loadResult();
	echo $database->getErrorMsg();

	require_once("includes/pageNavigation.php");
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	$query = "SELECT * FROM #__banner"
	. "\nLIMIT $pageNav->limitstart,$pageNav->limit";
	$database->setQuery( $query );

	if(!$result = $database->query()) {
		echo $database->stderr();
		return false;
	}
	$rows = $database->loadObjectList();
	HTML_banners::showBanners( $rows, $pageNav, $option );
}

function editBanner( $bannerid, $option ) {
	global $database;
	global $mainframe;
	$lists = array();

	$row = new mosBanner($database);
	$row->load( $bannerid );

	// Build Client select list
	$sql	= "SELECT cid as value, name as text FROM #__bannerclient";
	$database->setQuery($sql);
	if (!$database->query()) {
		echo $database->stderr();
		return false;
	}

	$clientlist[] = mosHTML::makeOption( '0', ' ' );
	$clientlist = array_merge( $clientlist, $database->loadObjectList() );
	$lists['cid'] = mosHTML::selectList( $clientlist, 'cid', 'class="inputbox" size="1"','value', 'text', $row->cid);

	// Imagelist
	// get list of images
	$imgFiles = mosReadDirectory( $mainframe->getCfg( 'absolute_path' ) . "/images/banners" );
	$images = array();
	foreach ($imgFiles as $file) {
		if (eregi( "(\.bmp|\.gif|\.jpg|\.jpeg|\.png|\.swf)$", $file )) {
			$images[] = mosHTML::makeOption( $file );
		}
	}

	$lists['imageurl'] = mosHTML::selectList( $images, 'imageurl', "class=\"inputbox\" size=\"1\" onchange=\"changeDisplayImage();\"" ,
	'value', 'text', $row->imageurl );

	// make the select list for the image positions
	$yesno[] = mosHTML::makeOption( '0', 'No' );
	$yesno[] = mosHTML::makeOption( '1', 'Yes' );

	HTML_banners::bannerForm( $row, $lists, $option );
}

function saveBanner( $option )
{
	global $database;
	$row = new mosBanner($database);

	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();

	mosRedirect( "index2.php?option=$option" );
}

function cancelEditBanner( $option ) {
	global $database;
	$row = new mosBanner($database);
	$row->bind( $_POST );
	$row->checkin();
	mosRedirect( "index2.php?option=$option" );
}

function publishBanner( $cid, $publish=1 ,$option )
{
	global $database, $my;

	if (!is_array( $cid ) || count( $cid ) < 1) {
		$action = $publish ? 'publish' : 'unpublish';
		echo "<script> alert('Select an item to $action'); window.history.go(-1);</script>\n";
		exit;
	}

	$cids = implode( ',', $cid );

	$database->setQuery( "UPDATE #__banner SET showBanner='$publish'"
	. "\nWHERE bid IN ($cids) AND (checked_out=0 OR (checked_out='$my->id'))"
	);
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (count( $cid ) == 1) {
		$row = new mosBanner( $database );
		$row->checkin( $cid[0] );
	}
	mosRedirect( "index2.php?option=$option" );

}

function removeBanner( $cid, $option ) {
	global $database;
	if (count( $cid )) {
		$cids = implode( ',', $cid );
		$database->setQuery( "DELETE FROM #__banner WHERE bid IN ($cids)" );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		}
	}
	mosRedirect( "index2.php?option=$option" );
}

// ---------- BANNER CLIENTS ----------

function viewBannerClients( $option ) {
	global $database, $mainframe;

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "viewcli{$option}limitstart", 'limitstart', 0 );

	// get the total number of records
	$database->setQuery( "SELECT count(*) FROM #__bannerclient" );
	$total = $database->loadResult();
	echo $database->getErrorMsg();

	require_once("includes/pageNavigation.php");
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	$sql = "SELECT a.*,	count(b.bid) AS bid"
	. "\nFROM #__bannerclient AS a"
	. "\nLEFT JOIN #__banner AS b ON a.cid = b.cid"
	. "\nGROUP BY a.cid"
	. "\nLIMIT $pageNav->limitstart,$pageNav->limit";
	$database->setQuery($sql);

	if(!$result = $database->query()) {
		echo $database->stderr();
		return false;
	}
	$rows = $database->loadObjectList();

	HTML_bannerClient::showClients( $rows, $pageNav, $option );
}

function editBannerClient( $clientid, $option ) {
	global $database, $my;
	$row = new mosBannerClient($database);
	$row->load($clientid);

	// fail if checked out not by 'me'
	if ($row->checked_out && $row->checked_out <> $my->id) {
		mosRedirect( "index2.php?option=$option&task=listclients",
		'The component $row->title is currently being edited by another administrator.' );
	}

	if ($clientid) {
		// do stuff for existing record
		$row->checkout( $my->id );
	} else {
		// do stuff for new record
		$row->published = 0;
		$row->approved = 0;
	}

	HTML_bannerClient::bannerClientForm( $row, $option );
}

function saveBannerClient( $option ) {
	global $database;

	$row = new mosBannerClient( $database );
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->check()) {
		mosRedirect( "index2.php?option=$option&task=editclient&cid[]=$row->id", $row->getError() );
	}

	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();
	mosRedirect( "index2.php?option=$option&task=listclients" );
}

function cancelEditClient( $option ) {
	global $database;
	$row = new mosBannerClient( $database );
	$row->bind( $_POST );
	$row->checkin();
	mosRedirect( "index2.php?option=$option&task=listclients" );
}

function removeBannerClients( $cid, $option ) {
	global $database;

	for ($i = 0; $i < count($cid); $i++) {
		$query = "SELECT COUNT(bid) FROM #__banner WHERE cid='".$cid[$i]."'";
		$database->setQuery($query);

		if(($count = $database->loadResult()) == null) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		}

		if ($count != 0) {
			mosRedirect( "index2.php?option=$option&task=listclients",
			"Cannot delete client at this time as they have a banner still running" );
		} else {
			$query="DELETE FROM #__bannerfinish WHERE `cid`='".$cid[$i]."'";
			$database->setQuery($query);
			$database->query();

			$query="DELETE FROM #__bannerclient WHERE `cid`='".$cid[$i]."'";
			$database->setQuery($query);
			$database->query();
		}
	}
	mosRedirect("index2.php?option=$option&task=listclients");
}
?>