<?php
// $Id: component_installer.php,v 1.31 2004/01/13 00:57:16 eddieajau Exp $
/**
* Administrator component installer event handler
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.31 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

require_once($mosConfig_absolute_path . "/administrator/classes/html/HTML_installer.php");
require_once($mosConfig_absolute_path . "/administrator/includes/installer_common.php");

$task = mosGetParam( $_REQUEST, "task", "" );

switch($task)
{
	case "uploadfile":
		// Check that the zlib is available
		if(!extension_loaded('zlib'))
		{
			HTML_installer::showInstallMessage("   Zlib",'  ',$option);
			exit();
		}
		// Check if file uploads are enabled
		if(!(bool)ini_get('file_uploads')){
			HTML_installer::showInstallMessage("            ",'  ',$option);
			exit();
		}

		if(!isset($userfile) || $userfile == "")
		{
			HTML_installer::showInstallMessage("  ",'  ',$option);
			exit();
		}
		$msg = "";
		$resultdir = uploadFile($userfile,$userfile_name,$option,$msg);
		if(! $resultdir === false)
		{
			$installer = new mosInstallerComponent($userfile_name);
			if($installer->install() === false)
			{
				HTML_installer::showInstallMessage($installer->getError(),'    ', $option);
				cleanupInstall($userfile_name,$installer->unpackDir());
				exit();
			}
			else
			{
				HTML_installer::showInstallMessage($installer->getError(false),'  ', $option);
				cleanupInstall($userfile_name,$installer->unpackDir());
				exit();
			}
		} else {
			HTML_installer::showInstallMessage( "$msg     ",'  ',$option);
			exit();
		}

		mosRedirect("index2.php?option=$option");
		break;

	case "remove":
		$result = "";
		if(is_array($cid) && count($cid) >1)
		{
			foreach($cid as $delid)
			{
				$result .= unInstallComponent($delid,$option) . "<br>";
			}
		}
		else
		{
			$delid = $cid[0];
			$result = unInstallComponent($delid,$option);
		}
		if($result != "")
		{
			HTML_installer::showInstallMessage($result,'  ', $option);
			exit();
		}
		mosRedirect("index2.php?option=$option");
		break;

	case "installfromdir":
		installFromDirectory( $option );
		break;

	default:
		showInstalledComponents($option);
		HTML_installer::showInstallForm(' ',$option,dirname(__FILE__));
		break;
}

/**
* Install a component from a directory
*/
function installFromDirectory( $option ) {
	$userfile = trim( mosGetParam( $_REQUEST, 'userfile', '' ) );

	if (!$userfile) {
		mosRedirect( "index2.php?option=$option&mosmsg=Please select a directory" );
	}

	$installer = new mosInstallerComponent( null, false );

	if (is_dir( $installer->pathName( $userfile ))) {
		$instdir = $installer->pathName( $userfile );
	} else {
		$instdir = dirname( $userfile );
	}

	if ($installer->install( $instdir ) === false) {
		//cleanupInstall($userfile_name,$installer->unpackDir());
		mosRedirect( "index2.php?option=$option&mosmsg=Failed with error ".$installer->getError() );
	} else {
		//cleanupInstall($userfile_name,$installer->unpackDir());
		mosRedirect( "index2.php?option=$option&mosmsg=Success ".$installer->getError(false) );
	}
}

function unInstallComponent($cid,$option)
{
	global $database,$mosConfig_absolute_path;

	$uninstallret = "";

	$sql = "SELECT * FROM #__components WHERE id=$cid";
	$database->setQuery($sql);

	$row = null;
	if (!$database->loadObject( $row )) {
		return;
	}

	if ($row->iscore) {
		HTML_installer::showInstallMessage(" $row->name      <br>    ", '  ', $option);
		exit();
	}

	// Try to find the uninstall file
	$filesindir = mosReadDirectory( $mosConfig_absolute_path."/administrator/components/".$row->option, "uninstall" );
	if (count( $filesindir ) > 0) {
		$uninstall_file = $filesindir[0];
		if(file_exists($mosConfig_absolute_path."/administrator/components/".$row->option ."/$uninstall_file"))
		{
			require_once($mosConfig_absolute_path."/administrator/components/".$row->option ."/$uninstall_file");
			$uninstallret = com_uninstall();
		}
	}

	// Try to find the XML file
	$filesindir = mosReadDirectory($mosConfig_absolute_path."/administrator/components/".$row->option ,".xml");
	if(count($filesindir) > 0)
	{
		$ismosinstall = false;
		foreach($filesindir as $file)
		{
			$xmlDoc = new MiniXMLDoc();
			$xmlDoc->fromFile($mosConfig_absolute_path."/administrator/components/".$row->option . "/" . $file);
			$ismosinstall = & $xmlDoc->getElementByPath('mosinstall');
			if($ismosinstall)
			{
				$query_element = &$xmlDoc->getElementbyPath('mosinstall/uninstall/queries');
				if(!is_null($query_element))
				{
					$queries = $query_element->getAllChildren();
					foreach($queries as $query)
					{
						$database->setQuery( $query->getValue());
						if (!$database->query())
						{
							HTML_installer::showInstallMessage($database->stderr(true),'  ', $option);
							exit();
						}
					}
				}
			}
		}
	}
	else
	{
		HTML_installer::showInstallMessage("    $mosConfig_absolute_path/administrator/components/$row->option",'  ', $option);
		exit();
	}

	// Delete entries in the DB
	$sql = "delete from #__components where parent=$row->id";
	$database->setQuery($sql);
	$database->query();

	$sql = "delete from #__components where id=$row->id";
	$database->setQuery($sql);
	$database->query();

	// Delete directories
	deldir($mosConfig_absolute_path."/administrator/components/".$row->option);
	deldir($mosConfig_absolute_path."/components/".$row->option);

	return $uninstallret;
}

function showInstalledComponents($option)
{
	global $database, $mosConfig_absolute_path;

	$database->setQuery( "SELECT * FROM #__components where parent=0 ORDER BY name" );
	$res = $database->query();
	$rows = $database->loadObjectList();


	// Read the component dir to find components
	$componentBaseDir	= mosPathName(mosPathName($mosConfig_absolute_path) . "administrator/components");
	$componentDirs		= mosReadDirectory($componentBaseDir);

	$id = 0;
	foreach($rows as $row) {
		$dirName = mosPathName($componentBaseDir . $row->option);
		$xmlFilesInDir = mosReadDirectory($dirName,".xml");

		foreach($xmlFilesInDir as $xmlfile) {
			// Read the file to see if it's a valid component XML file
			$xmlDoc = new MiniXMLDoc($dirName . $xmlfile);
			$xmlDoc->fromFile($dirName . $xmlfile);

			$element = &$xmlDoc->getElementByPath('mosinstall');

			if (is_null( $element )) {
				continue;
			}
			if ($element->attribute( "type" ) != "component") {
				continue;
			}

			$element = &$xmlDoc->getElementByPath('mosinstall/creationDate');
			$row->creationdate = $element->getValue();

			$element = &$xmlDoc->getElementByPath('mosinstall/author');
			$row->author = $element->getValue();

			$element = &$xmlDoc->getElementByPath('mosinstall/copyright');
			$row->copyright = $element->getValue();

			$element = &$xmlDoc->getElementByPath('mosinstall/authoremail');
			$row->authoremail = $element->getValue();

			$element = &$xmlDoc->getElementByPath('mosinstall/authorurl');
			$row->authorurl = $element->getValue();

			$element = &$xmlDoc->getElementByPath('mosinstall/version');
			$row->version = $element->getValue();

			$row->mosname = strtolower( str_replace( " ", "_", $row->name ) );
			$rows[$id] = $row;
		}
		$id++;
	}

	HTML_installer::showInstalledComponents($rows, $option);
}
?>
