# $Id: mambo.sql,v 1.121 2004/04/07 11:56:03 rcastley Exp $

#
# Table structure for table `mos_banner`
#

CREATE TABLE `mos_banner` (
  `bid` int(11) NOT NULL auto_increment,
  `cid` int(11) NOT NULL default '0',
  `type` varchar(10) NOT NULL default 'banner',
  `name` varchar(50) NOT NULL default '',
  `imptotal` int(11) NOT NULL default '0',
  `impmade` int(11) NOT NULL default '0',
  `clicks` int(11) NOT NULL default '0',
  `imageurl` varchar(100) NOT NULL default '',
  `clickurl` varchar(200) NOT NULL default '',
  `date` datetime default NULL,
  `showBanner` tinyint(1) NOT NULL default '0',
  `checked_out` tinyint(1) NOT NULL default '0',
  `checked_out_time` time default NULL,
  `editor` varchar(50) default NULL,
  `custombannercode` text,
  PRIMARY KEY  (`bid`),
  KEY `viewbanner` (`showBanner`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Dumping data for table `mos_banner`
#

# --------------------------------------------------------

#
# Table structure for table `mos_bannerclient`
#

CREATE TABLE `mos_bannerclient` (
  `cid` int(11) NOT NULL auto_increment,
  `name` varchar(60) NOT NULL default '',
  `contact` varchar(60) NOT NULL default '',
  `email` varchar(60) NOT NULL default '',
  `extrainfo` text NOT NULL,
  `checked_out` tinyint(1) NOT NULL default '0',
  `checked_out_time` time default NULL,
  `editor` varchar(50) default NULL,
  PRIMARY KEY  (`cid`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_bannerclient`
#

# --------------------------------------------------------

#
# Table structure for table `mos_bannerfinish`
#

CREATE TABLE `mos_bannerfinish` (
  `bid` int(11) NOT NULL auto_increment,
  `cid` int(11) NOT NULL default '0',
  `type` varchar(10) NOT NULL default '',
  `name` varchar(50) NOT NULL default '',
  `impressions` int(11) NOT NULL default '0',
  `clicks` int(11) NOT NULL default '0',
  `imageurl` varchar(50) NOT NULL default '',
  `datestart` datetime default NULL,
  `dateend` datetime default NULL,
  PRIMARY KEY  (`bid`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_bannerfinish`
#

# --------------------------------------------------------

#
# Table structure for table `mos_categories`
#

CREATE TABLE `mos_categories` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(50) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `image` varchar(100) NOT NULL default '',
  `section` varchar(20) NOT NULL default '',
  `image_position` varchar(10) NOT NULL default '',
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `editor` varchar(50) default NULL,
  `ordering` int(11) NOT NULL default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
  `count` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cat_idx` (`section`,`published`,`access`),
  KEY `idx_section` (`section`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_categories`
#

INSERT INTO `mos_categories` VALUES (1, '', ' ', 'pastarchives.jpg', '1', 'left', '    ', 1, 0, '0000-00-00 00:00:00', '', 0, 0, 1);
INSERT INTO `mos_categories` VALUES (2, '', 'Mambo', 'mos_asterisk.png', 'com_weblinks', 'left', '      ', 1, 0, '0000-00-00 00:00:00', NULL, 0, 0, 0);
INSERT INTO `mos_categories` VALUES (3, ' ', '', '', 'help', 'left', '      ', 1, 0, '0000-00-00 00:00:00', NULL, 1, 0, 0);
INSERT INTO `mos_categories` VALUES (4, '', ' ', '', 'help', 'left', '   ', 1, 0, '0000-00-00 00:00:00', NULL, 3, 0, 0);
INSERT INTO `mos_categories` VALUES (5, '', '', '', 'help', 'left', '  ', 1, 0, '0000-00-00 00:00:00', NULL, 4, 0, 0);
INSERT INTO `mos_categories` VALUES (6, '', '', '', 'help', 'left', '  ', 1, 0, '0000-00-00 00:00:00', NULL, 2, 0, 0);
# --------------------------------------------------------

#
# Table structure for table `mos_components`
#

CREATE TABLE `mos_components` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `link` varchar(255) NOT NULL default '',
  `menuid` int(11) unsigned NOT NULL default '0',
  `parent` int(11) unsigned NOT NULL default '0',
  `admin_menu_link` varchar(255) NOT NULL default '',
  `admin_menu_alt` varchar(255) NOT NULL default '',
  `option` varchar(50) NOT NULL default '',
  `ordering` int(11) unsigned NOT NULL default '0',
  `admin_menu_img` varchar(255) NOT NULL default '',
  `iscore` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_components`
#

INSERT INTO `mos_components` VALUES (1, '', '', 0, 0, '', ' ', 'com_banners', 0, 'js/ThemeOffice/component.png', 1);
INSERT INTO `mos_components` VALUES (2, ' ', '', 0, 1, 'option=com_banners', ' ', 'com_banners', 1, 'js/ThemeOffice/edit.png', 1);
INSERT INTO `mos_components` VALUES (3, ' ', '', 0, 1, 'option=com_banners&task=listclients', ' ', 'com_banners', 2, 'js/ThemeOffice/categories.png', 1);
INSERT INTO `mos_components` VALUES (4, ' ', 'option=com_weblinks', 0, 0, '', ' ', 'com_weblinks', 0, 'js/ThemeOffice/component.png', 1);
INSERT INTO `mos_components` VALUES (5, ' ', '', 0, 0, 'option=com_newsflash', '  ', 'com_newsflash', 0, 'js/ThemeOffice/component.png', 1);
INSERT INTO `mos_components` VALUES (6, ' ', 'option=com_contact', 0, 0, 'option=com_contact', '  ', 'com_contact', 0, 'js/ThemeOffice/component.png', 1);
INSERT INTO `mos_components` VALUES (7, '', '', 0, 4, 'option=com_weblinks', '  ', 'com_weblinks', 1, 'js/ThemeOffice/edit.png', 1);
INSERT INTO `mos_components` VALUES (8, '', '', 0, 4, 'option=categories&section=com_weblinks', '  ', '', 2, 'js/ThemeOffice/categories.png', 1);
INSERT INTO `mos_components` VALUES (9, ' ', 'option=com_frontpage', 0, 0, '', '   ', 'com_frontpage', 0, 'js/ThemeOffice/component.png', 1);
INSERT INTO `mos_components` VALUES (10, ' ', '', 0, 9, 'option=com_frontpage', '   ', 'com_frontpage', 1, 'js/ThemeOffice/edit.png', 1);
INSERT INTO `mos_components` VALUES (11, '', '', 0, 9, 'option=com_frontpage&act=settings', '  ', 'com_frontpage', 2, 'js/ThemeOffice/config.png', 1);
INSERT INTO `mos_components` VALUES (12, '', 'option=com_poll', 0, 0, 'option=com_poll', ' ', 'com_poll', 0, 'js/ThemeOffice/component.png', 1);
INSERT INTO `mos_components` VALUES (13, ' ', '', 0, 0, '', '  ', 'com_newsfeeds', 0, 'js/ThemeOffice/component.png', 1);
INSERT INTO `mos_components` VALUES (14, ' ', '', 0, 13, 'option=com_newsfeeds', '  ', 'com_newsfeeds', 1, 'js/ThemeOffice/edit.png', 1);
INSERT INTO `mos_components` VALUES (15, ' ', '', 0, 13, 'option=categories&section=com_newsfeeds', ' ', '', 2, 'js/ThemeOffice/categories.png', 1);
INSERT INTO `mos_components` VALUES (16, '  ', 'option=com_newsfeeds', '', '', '','', '', '', '', '');
INSERT INTO `mos_components` VALUES (17, '', '', 0, 0, 'option=com_media', ' ', 'com_media', 0, 'js/ThemeOffice/media.png', 1);
INSERT INTO `mos_components` VALUES (18, ' ', 'option=com_login', 0, 0, '', '', 'com_login', 0, '', 1);
# --------------------------------------------------------

#
# Table structure for table `mos_contact_details`
#

CREATE TABLE `mos_contact_details` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `con_position` varchar(50) default NULL,
  `address` text,
  `suburb` varchar(50) default NULL,
  `state` varchar(20) default NULL,
  `country` varchar(50) default NULL,
  `postcode` varchar(10) default NULL,
  `telephone` varchar(25) default NULL,
  `fax` varchar(25) default NULL,
  `misc` mediumtext,
  `image` varchar(100) default NULL,
  `imagepos` varchar(20) default NULL,
  `email_to` varchar(100) default NULL,
  `default_con` tinyint(1) unsigned NOT NULL default '0',
  `published` tinyint(1) unsigned NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_contact_details`
#

# --------------------------------------------------------

#
# Table structure for table `mos_content`
#

CREATE TABLE `mos_content` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `title_alias` varchar(100) NOT NULL default '',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL default '0',
  `sectionid` int(11) unsigned NOT NULL default '0',
  `mask` int(11) unsigned NOT NULL default '0',
  `catid` int(11) unsigned NOT NULL default '0',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  `created_by` int(11) unsigned NOT NULL default '0',
  `created_by_alias` varchar(100) NOT NULL default '',
  `modified` datetime NOT NULL default '0000-00-00 00:00:00',
  `modified_by` int(11) unsigned NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL default '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL default '0000-00-00 00:00:00',
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `attribs` text NOT NULL,
  `version` int(11) unsigned NOT NULL default '1',
  `parentid` int(11) unsigned NOT NULL default '0',
  `ordering` float unsigned NOT NULL default '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `access` int(11) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `idx_section` (`sectionid`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_mask` (`mask`)
) TYPE=MyISAM;


#
# Dumping data for table `mos_content`
#

INSERT INTO `mos_content` VALUES (1, '   ', '', '        . <BR><BR>{mosimage}         html          ', '<H4><FONT color=#ff6600>  :</FONT></H4>\r\n<UL>\r\n<LI>      \r\n<LI>     \r\n<LI>     \r\n<LI>   \r\n<LI>     \r\n<LI>     \r\n<LI>          php \r\n<P></P></LI></UL>\r\n<H4>  :</H4>\r\n<UL>\r\n<LI>        \r\n<LI>    \r\n<LI>         \r\n<LI>      \r\n<LI>     \r\n<LI>      \r\n<LI>     360  \r\n<LI>    \r\n<LI>      \r\n<LI>   \r\n<LI>     \r\n<LI>      \r\n<LI>        \r\n<LI>   \r\n<LI>    \r\n<LI> </LI></UL>', 1, 1, 0, 1, '2004-04-12 11:54:06', 62, 'Web Master', '2003-06-12 12:33:27', 62, 0, '0000-00-00 00:00:00', '2003-01-01 00:00:00', '0000-00-00 00:00:00', 'mos_asterisk.png|left|Another logo|0', '', '', 1, 0, '1', '', '', 0, 0);
# --------------------------------------------------------

#
# Table structure for table `mos_content_frontpage`
#

CREATE TABLE `mos_content_frontpage` (
  `content_id` int(11) NOT NULL default '0',
  `ordering` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`content_id`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_content_frontpage`
#

INSERT INTO `mos_content_frontpage` VALUES (1, 1);
# --------------------------------------------------------



#
# Table structure for table `mos_content_rating`
#

CREATE TABLE `mos_content_rating` (
  `content_id` int(11) NOT NULL default '0',
  `rating_sum` int(11) unsigned NOT NULL default '',
  `rating_count` int(11) unsigned NOT NULL default '0',
  `lastip` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`content_id`)
) TYPE=MyISAM;

# --------------------------------------------------------

# Table structure for table `mos_core_log_items`
#
# To be implemented in Version 4.6

CREATE TABLE `mos_core_log_items` (
  `time_stamp` date NOT NULL default '0000-00-00',
  `item_table` varchar(50) NOT NULL default '',
  `item_id` int(11) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0'
) TYPE=MyISAM;

# --------------------------------------------------------

#
# Table structure for table `mos_core_log_searches`
#
# To be implemented in Version 4.6

CREATE TABLE `mos_core_log_searches` (
  `search_term` varchar(128) NOT NULL default '',
  `hits` int(11) unsigned NOT NULL default '0'
) TYPE=MyISAM;

# --------------------------------------------------------

#
# Table structure for table `mos_groups`
#

CREATE TABLE `mos_groups` (
  `id` tinyint(3) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_groups`
#

INSERT INTO `mos_groups` VALUES (0, '');
INSERT INTO `mos_groups` VALUES (1, '');
INSERT INTO `mos_groups` VALUES (2, '');
# --------------------------------------------------------

#
# Table structure for table `mos_help`
#

CREATE TABLE `mos_help` (
  `id` int(11) NOT NULL auto_increment,
  `lang` char(3) NOT NULL default 'eng',
  `context` varchar(40) NOT NULL default '',
  `name` varchar(40) NOT NULL default '',
  `title` varchar(100) NOT NULL default '',
  `parent` int(11) NOT NULL default '0',
  `ordering` int(11) NOT NULL default '0',
  `helptext` text NOT NULL,
  `catid` int(11) unsigned NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `IdLangIdx` (`id`,`lang`),
  KEY `id_2` (`id`),
  FULLTEXT KEY `HeltextIdx` (`helptext`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_help`
#

# --------------------------------------------------------

#
# Table structure for table `mos_menu`
#

CREATE TABLE `mos_menu` (
  `id` int(11) NOT NULL auto_increment,
  `menutype` varchar(25) default NULL,
  `name` varchar(100) default NULL,
  `link` text,
  `type` varchar(50) NOT NULL default '',
  `published` tinyint(1) NOT NULL default '0',
  `parent` int(11) unsigned NOT NULL default '0',
  `componentid` int(11) unsigned NOT NULL default '0',
  `sublevel` int(11) default '0',
  `ordering` int(11) default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `pollid` int(11) NOT NULL default '0',
  `browserNav` tinyint(4) default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
  `utaccess` tinyint(3) unsigned NOT NULL default '0',
  `params` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `componentid` (`componentid`,`menutype`,`published`,`access`),
  KEY `menutype` (`menutype`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_menu`
#

INSERT INTO `mos_menu` VALUES (1, 'mainmenu', ' ', 'index.php?option=com_frontpage', 'components', 1, 0, 9, 0, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, 'count=6\r\nintro=3\r\nimage=1\r\nheader=    \r\nempty=   \r\norderby=ordering');
INSERT INTO `mos_menu` VALUES (2, 'mainmenu', '', 'index.php?option=content&task=section&id=1', 'content_section', 1, 0, 1, 0, 2, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, '');
INSERT INTO `mos_menu` VALUES (3, 'mainmenu', ' ', 'index.php?option=com_contact', 'components', 1, 0, 6, 0, 5, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, '');
INSERT INTO `mos_menu` VALUES (4, 'mainmenu', ' ', 'index.php?option=com_weblinks', 'components', 1, 0, 4, 0, 4, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, '');
INSERT INTO `mos_menu` VALUES (5, 'mainmenu', ' ', 'http://www.mamboserver.com', 'url', 1, 0, 0, 0, 7, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, '');
INSERT INTO `mos_menu` VALUES (6, 'mainmenu', '', 'administrator/', 'url', 1, 0, 0, 0, 8, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, '');
INSERT INTO `mos_menu` VALUES (21, 'usermenu', '', 'index.php?option=com_user&task=UserDetails', 'url', 1, 0, 0, 0, 1, 0, '2000-00-00 00:00:00', 0, 0, 1, 3, '');
INSERT INTO `mos_menu` VALUES (22, 'usermenu', ' ', 'index.php?option=content&task=new&sectionid=1&Itemid=0', 'url', 1, 0, 0, 0, 2, 0, '2000-00-00 00:00:00', 0, 0, 1, 2, '');
INSERT INTO `mos_menu` VALUES (23, 'usermenu', ' ', 'index.php?option=com_weblinks&task=new', 'url', 1, 0, 0, 0, 4, 0, '2000-00-00 00:00:00', 0, 0, 1, 2, '');
INSERT INTO `mos_menu` VALUES (24, 'usermenu', ' ', 'index.php?option=com_user&task=CheckIn', 'url', 1, 0, 0, 0, 5, 0, '0000-00-00 00:00:00', 0, 0, 1, 2, '');
# --------------------------------------------------------

#
# Dumping data for table `mos_messages`
#

CREATE TABLE `mos_messages` (
  `message_id` int(10) unsigned NOT NULL auto_increment,
  `user_id_from` int(10) unsigned NOT NULL default '0',
  `user_id_to` int(10) unsigned NOT NULL default '0',
  `folder_id` int(10) unsigned NOT NULL default '0',
  `date_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `state` int(11) NOT NULL default '0',
  `priority` int(1) unsigned NOT NULL default '0',
  `subject` varchar(230) NOT NULL default '',
  `message` text NOT NULL,
  PRIMARY KEY  (`message_id`)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Dumping data for table `mos_messages_cfg`
#

CREATE TABLE `mos_messages_cfg` (
  `user_id` int(10) unsigned NOT NULL default '0',
  `cfg_name` varchar(100) NOT NULL default '',
  `cfg_value` varchar(255) NOT NULL default '',
  UNIQUE `idx_user_var_name` (`user_id`,`cfg_name`)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `mos_modules`
#

CREATE TABLE `mos_modules` (
  `id` int(11) NOT NULL auto_increment,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `ordering` tinyint(4) NOT NULL default '0',
  `position` varchar(10) default NULL,
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL default '0',
  `module` varchar(50) default NULL,
  `numnews` int(11) NOT NULL default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
  `showtitle` tinyint(3) unsigned NOT NULL default '1',
  `params` text NOT NULL,
  `iscore` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_modules`
#

INSERT INTO `mos_modules` VALUES (1, '', '', 1, 'right', 0, '0000-00-00 00:00:00', 1, 'mod_poll', 0, 0, 1, '', 1);
INSERT INTO `mos_modules` VALUES (2, ' ', '', 2, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_mainmenu', 0, 1, 1, 'menutype=usermenu', 1);
INSERT INTO `mos_modules` VALUES (3, ' ', '', 1, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_mainmenu', 0, 0, 1, '', 1);
INSERT INTO `mos_modules` VALUES (4, ' ', '', 3, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_login', 0, 0, 1, '', 1);
INSERT INTO `mos_modules` VALUES (5, ' ', '', 2, 'right', 0, '0000-00-00 00:00:00', 1, 'mod_rssfeed', 0, 0, 0, '', 1);
INSERT INTO `mos_modules` VALUES (6, '', '', 3, 'right', 0, '0000-00-00 00:00:00', 0, 'mod_browser_prefs', 0, 0, 1, '', 1);
INSERT INTO `mos_modules` VALUES (7, ' ', '', 1, 'user2', 0, '0000-00-00 00:00:00', 1, 'mod_counter', 0, 0, 1, '', 1);
INSERT INTO `mos_modules` VALUES (8, ' ', '', 4, 'right', 0, '0000-00-00 00:00:00', 0, 'mod_latestnews', 0, 0, 1, '', 1);
INSERT INTO `mos_modules` VALUES (9, ' ', '', 5, 'right', 0, '0000-00-00 00:00:00', 0, 'mod_newsfeeds', 0, 0, 1, '', 1);
INSERT INTO `mos_modules` VALUES (10, ' ', '', 5, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_online', 0, 0, 1, '', 1);
INSERT INTO `mos_modules` VALUES (11, '', '', 4, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_stats', 0, 0, 1, '', 1);
INSERT INTO `mos_modules` VALUES (12, ' ', '', 1, 'user1', 0, '0000-00-00 00:00:00', 1, 'mod_whosonline', 0, 0, 1, '', 1);
INSERT INTO `mos_modules` VALUES (13, ' ', '', 6, 'right', 0, '0000-00-00 00:00:00', 0, 'mod_mostread', 0, 0, 1, '', 1);
INSERT INTO `mos_modules` VALUES (14, ' ','',6,'left',0,'0000-00-00 00:00:00',0,'mod_templatechooser', 0, 0, 1, 'show_preview=1', 1);
INSERT INTO `mos_modules` VALUES (15, '', '', 7, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_archive', 0, 0, 1, '', 1);
INSERT INTO `mos_modules` VALUES (16, '', '', 8, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_sections', 0, 0, 1, '', 1);
INSERT INTO `mos_modules` VALUES (17, '  ', '', 1, 'top', 0, '0000-00-00 00:00:00', 1, 'mod_newsflash', 0, 0, 1, '', 1);
INSERT INTO `mos_modules` VALUES (18, ' ', '', 9, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_related_items', 0, 0, 1, '', 1);

# --------------------------------------------------------

#
# Table structure for table `mos_modules_menu`
#

CREATE TABLE `mos_modules_menu` (
  `moduleid` int(11) NOT NULL default '0',
  `menuid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`moduleid`,`menuid`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_modules_menu`
#

INSERT INTO `mos_modules_menu` VALUES (1, 1);
INSERT INTO `mos_modules_menu` VALUES (2, 0);
INSERT INTO `mos_modules_menu` VALUES (3, 0);
INSERT INTO `mos_modules_menu` VALUES (4, 0);
INSERT INTO `mos_modules_menu` VALUES (5, 1);
INSERT INTO `mos_modules_menu` VALUES (6, 0);
INSERT INTO `mos_modules_menu` VALUES (7, 0);
INSERT INTO `mos_modules_menu` VALUES (8, 0);
INSERT INTO `mos_modules_menu` VALUES (9, 0);
INSERT INTO `mos_modules_menu` VALUES (10, 0);
INSERT INTO `mos_modules_menu` VALUES (11, 0);
INSERT INTO `mos_modules_menu` VALUES (12, 0);
INSERT INTO `mos_modules_menu` VALUES (13, 0);
INSERT INTO `mos_modules_menu` VALUES (14, 0);
INSERT INTO `mos_modules_menu` VALUES (16, 1);
INSERT INTO `mos_modules_menu` VALUES (17, 0);
# --------------------------------------------------------

#
# Table structure for table `mos_newsfeeds`
#

CREATE TABLE `mos_newsfeeds` (
  `catid` int(11) NOT NULL default '0',
  `id` int(11) NOT NULL auto_increment,
  `name` text NOT NULL,
  `link` text NOT NULL,
  `filename` varchar(200) default NULL,
  `published` tinyint(1) NOT NULL default '0',
  `numarticles` int(11) unsigned NOT NULL default '1',
  `cache_time` int(11) unsigned NOT NULL default '3600',
  `checked_out` tinyint(3) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `ordering` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `published` (`published`)
) TYPE=MyISAM;

# --------------------------------------------------------

#
# Table structure for table `mos_newsfeedscache`
#

CREATE TABLE `mos_newsfeedscache` (
  `time` varchar(14) default NULL,
  `cachefile` varchar(50) NOT NULL default '',
  `filedata` text NOT NULL
) TYPE=MyISAM;

#
# Dumping data for table `mos_newsfeedscache`
#

# --------------------------------------------------------

#
# Table structure for table `mos_newsflash`
#

CREATE TABLE `mos_newsflash` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(50) NOT NULL default '',
  `content` text NOT NULL,
  `published` tinyint(1) NOT NULL default '0',
  `checked_out` int(11) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `catid` int(11) unsigned NOT NULL default '0',
  `publish_up` datetime NOT NULL default '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL default '0000-00-00 00:00:00',
  `access` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_newsflash`
#

INSERT INTO `mos_newsflash` VALUES (1, '  1', '                 ', 1, 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0);
INSERT INTO `mos_newsflash` VALUES (2, '  2', '                 ', 1, 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0);
INSERT INTO `mos_newsflash` VALUES (3, '  3', '                 ', 1, 0, '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0);
# --------------------------------------------------------

#
# Table structure for table `mos_poll_data`
#

CREATE TABLE `mos_poll_data` (
  `id` int(11) NOT NULL auto_increment,
  `pollid` int(4) NOT NULL default '0',
  `text` text NOT NULL default '',
  `hits` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `pollid` (`pollid`,`text`(1))
) TYPE=MyISAM;

#
# Dumping data for table `mos_poll_data`
#

# --------------------------------------------------------

#
# Table structure for table `mos_poll_date`
#

CREATE TABLE `mos_poll_date` (
  `id` bigint(20) NOT NULL auto_increment,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `vote_id` int(11) NOT NULL default '0',
  `poll_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `poll_id` (`poll_id`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_poll_date`
#

# --------------------------------------------------------

#
# Table structure for table `mos_polls`
#

CREATE TABLE `mos_polls` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `voters` int(9) NOT NULL default '0',
  `checked_out` int(11) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL default '0',
  `access` int(11) NOT NULL default '0',
  `lag` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Table structure for table `mos_poll_menu`
#

CREATE TABLE `mos_poll_menu` (
  `pollid` int(11) NOT NULL default '0',
  `menuid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`pollid`,`menuid`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_poll_menu`
#

# --------------------------------------------------------

#
# Table structure for table `mos_sections`
#

CREATE TABLE `mos_sections` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(50) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `image` varchar(100) NOT NULL default '',
  `scope` varchar(50) NOT NULL default '',
  `image_position` varchar(10) NOT NULL default '',
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
	`count` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `idx_scope` (`scope`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_sections`
#

INSERT INTO `mos_sections` VALUES (1, '', '', 'articles.jpg', 'content', 'right', '         ', 1, 0, '0000-00-00 00:00:00', 1, 0, 1);

#
# Table structure for table `mos_session`
#

CREATE TABLE `mos_session` (
  `username` varchar(50) default '',
  `time` varchar(14) default '',
  `session_id` varchar(200) NOT NULL default '0',
  `guest` tinyint(4) default '1',
  `userid` int(11) default '0',
  `usertype` varchar(50) default '',
  `gid` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`session_id`),
  KEY `whosonline` (`guest`,`usertype`)
) TYPE=MyISAM;

#
# Table structure for table `mos_stats_agents`
#

CREATE TABLE `mos_stats_agents` (
  `agent` varchar(255) NOT NULL default '',
  `type` tinyint(1) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '1'
) TYPE=MyISAM;

#
# Dumping data for table `mos_stats_agents`
#

# --------------------------------------------------------

#
# Table structure for table `mos_templates`
#

CREATE TABLE `mos_templates` (
  `id` int(11) NOT NULL default '0',
  `cur_template` varchar(50) NOT NULL default '',
  `col_main` char(1) NOT NULL default '1',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_templates`
#

INSERT INTO `mos_templates` VALUES (0, 'mt_business', '3');
# --------------------------------------------------------

#
# Table structure for table `mos_users`
#

CREATE TABLE `mos_users` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `username` varchar(25) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `password` varchar(100) NOT NULL default '',
  `usertype` varchar(25) NOT NULL default '',
  `block` tinyint(4) NOT NULL default '0',
  `sendEmail` tinyint(4) default '0',
  `gid` tinyint(3) unsigned NOT NULL default '1',
  `registerDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastvisitDate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`),
  KEY `usertype` (`usertype`),
  KEY `idx_name` (`name`)
) TYPE=MyISAM;

#
# Table structure for table `mos_usertypes`
#

CREATE TABLE `mos_usertypes` (
  `id` tinyint(3) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `mask` varchar(11) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_usertypes`
#

INSERT INTO `mos_usertypes` VALUES (0, '', '');
INSERT INTO `mos_usertypes` VALUES (1, '', '');
INSERT INTO `mos_usertypes` VALUES (2, '', '');
INSERT INTO `mos_usertypes` VALUES (3, '', '');
INSERT INTO `mos_usertypes` VALUES (4, '', '');
INSERT INTO `mos_usertypes` VALUES (5, '', '');
INSERT INTO `mos_usertypes` VALUES (6, '', '');
# --------------------------------------------------------

#
# Table structure for table `mos_weblinks`
#

CREATE TABLE `mos_weblinks` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `sid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `url` varchar(250) NOT NULL default '',
  `description` varchar(250) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `hits` int(11) NOT NULL default '0',
  `published` tinyint(1) NOT NULL default '0',
  `checked_out` int(11) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL default '0',
  `archived` tinyint(1) NOT NULL default '0',
  `approved` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`id`),
  KEY `catid` (`catid`,`published`,`archived`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_weblinks`
#

INSERT INTO `mos_weblinks` VALUES (1, 2, 0, ' ', 'http://www.dndon.com', '  ', '2003-07-16 10:18:31', 0, 1, 0, '0000-00-00 00:00:00', 1, 0, 0);

#
# Table structure for table `mos_core_acl_aro`
#

CREATE TABLE `mos_core_acl_aro` (
  `aro_id` int(11) NOT NULL auto_increment,
  `section_value` varchar(240) NOT NULL default '0',
  `value` varchar(240) NOT NULL default '',
  `order_value` int(11) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `hidden` int(11) NOT NULL default '0',
  PRIMARY KEY  (`aro_id`),
  UNIQUE KEY `section_value_value_aro` (`section_value`,`value`),
  UNIQUE KEY `mos_gacl_section_value_value_aro` (`section_value`,`value`),
  KEY `hidden_aro` (`hidden`),
  KEY `mos_gacl_hidden_aro` (`hidden`)
) TYPE=MyISAM;

#
# Table structure for table `mos_core_acl_aro_groups`
#
CREATE TABLE `mos_core_acl_aro_groups` (
  `group_id` int(11) NOT NULL auto_increment,
  `parent_id` int(11) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `lft` int(11) NOT NULL default '0',
  `rgt` int(11) NOT NULL default '0',
  PRIMARY KEY  (`group_id`),
  KEY `parent_id_aro_groups` (`parent_id`),
  KEY `mos_gacl_parent_id_aro_groups` (`parent_id`),
  KEY `mos_gacl_lft_rgt_aro_groups` (`lft`,`rgt`)
) TYPE=MyISAM;

#
# Dumping data for table `mos_core_acl_aro_groups`
#
INSERT INTO `mos_core_acl_aro_groups` VALUES (17,0,'ROOT',1,22);
INSERT INTO `mos_core_acl_aro_groups` VALUES (28,17,'USERS',2,21);
INSERT INTO `mos_core_acl_aro_groups` VALUES (29,28,'Public Frontend',3,12);
INSERT INTO `mos_core_acl_aro_groups` VALUES (18,29,'Registered',4,11);
INSERT INTO `mos_core_acl_aro_groups` VALUES (19,18,'Author',5,10);
INSERT INTO `mos_core_acl_aro_groups` VALUES (20,19,'Editor',6,9);
INSERT INTO `mos_core_acl_aro_groups` VALUES (21,20,'Publisher',7,8);
INSERT INTO `mos_core_acl_aro_groups` VALUES (30,28,'Public Backend',13,20);
INSERT INTO `mos_core_acl_aro_groups` VALUES (23,30,'Manager',14,19);
INSERT INTO `mos_core_acl_aro_groups` VALUES (24,23,'Administrator',15,18);
INSERT INTO `mos_core_acl_aro_groups` VALUES (25,24,'Super Administrator',16,17);

#
# Table structure for table `mos_core_acl_groups_aro_map`
#
CREATE TABLE `mos_core_acl_groups_aro_map` (
  `group_id` int(11) NOT NULL default '0',
  `section_value` varchar(240) NOT NULL default '',
  `aro_id` int(11) NOT NULL default '0',
  UNIQUE KEY `group_id_aro_id_groups_aro_map` (`group_id`,`section_value`,`aro_id`)
) TYPE=MyISAM;

#
# Table structure for table `mos_core_acl_aro_sections`
#
CREATE TABLE `mos_core_acl_aro_sections` (
  `section_id` int(11) NOT NULL auto_increment,
  `value` varchar(230) NOT NULL default '',
  `order_value` int(11) NOT NULL default '0',
  `name` varchar(230) NOT NULL default '',
  `hidden` int(11) NOT NULL default '0',
  PRIMARY KEY  (`section_id`),
  UNIQUE KEY `value_aro_sections` (`value`),
  UNIQUE KEY `mos_gacl_value_aro_sections` (`value`),
  KEY `hidden_aro_sections` (`hidden`),
  KEY `mos_gacl_hidden_aro_sections` (`hidden`)
) TYPE=MyISAM;

INSERT INTO mos_core_acl_aro_sections VALUES (10,'users',1,'Users',0);

#
# Dumping data for table `mos_users`
#

#INSERT INTO `mos_users` VALUES (62, 'Administrator', 'admin', 'admin@wherever', '21232f297a57a5a743894a0e4a801fc3', 'superadministrator', 0, 1, 25, '2003-11-11 00:00:00', '0000-00-00 00:00:00');
#INSERT INTO `mos_core_acl_aro` VALUES (62,'users','62',0,'Administrator',0);
#INSERT INTO `mos_core_acl_groups_aro_map` VALUES (25,'',62);

#INSERT INTO `mos_users` VALUES (63, 'Editor', 'editor', 'editor@wherever', '5aee9dbd2a188839105073571bee1b1f', 'editor', 0, 0, 20, '2003-11-11 00:00:00', '0000-00-00 00:00:00');
#INSERT INTO `mos_core_acl_aro` VALUES (63,'users','63',0,'Editor',0);
#INSERT INTO `mos_core_acl_groups_aro_map` VALUES (20,'',63);
