<?php /* $Id: mod_templatechooser.php,v 1.7 2004/03/31 08:22:50 rcastley Exp $ */
/**
* Template changer
* @package Mambo Open Source
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.7 $
* Original module by Arthur Konze - webmaster@mamboportal.com
* Upgrade to 4.5 by Josh Mandeville - webmaster@jtn-designs.com
* Massaged into core by Andrew Eddie
**/

defined( '_VALID_MOS' ) or die( '      ' );

global $cur_template;

// titlelength can be set in module params
$titlelength = @$params->title_length ? $params->title_length : 20;
$preview_height = @$params->preview_height ? $params->preview_height : 90;
$preview_width = @$params->preview_width ? $params->preview_width : 140;
$show_preview = @$params->show_preview;

// Read files from template directory
$template_path = "$mosConfig_absolute_path/templates";
$templatefolder = @dir( $template_path );
$darray = array();
if ($templatefolder) {
	while ($templatefile = $templatefolder->read()) {
		if ($templatefile != "." && $templatefile != ".." && $templatefile != "CVS" && is_dir( "$template_path/$templatefile" )  ) {
			if(strlen($templatefile) > $titlelength) {
				$templatename = substr( $templatefile, 0, $titlelength-3 );
				$templatename .= "...";
			} else {
				$templatename = $templatefile;
			}
			$darray[] = mosHTML::makeOption( $templatefile, $templatename );
		}
	}
	$templatefolder->close();
}

// Sort files and build up menu
sort( $darray );

// Show the preview image
// Set up JavaScript for instant preview
$onchange = "";
if ($show_preview) {
	$onchange = "showimage()";
?>
<img src="<?php echo "$mosConfig_live_site/templates/$cur_template/template_thumbnail.png";?>" name="preview" border="1" width="<?php echo $preview_width;?>" height="<?php echo $preview_height;?>" />
<script language='JavaScript1.2' type='text/javascript'>
	function showimage() {
		//if (!document.images) return;
		document.images.preview.src = 'templates/'
			+ getSelectedValue( 'templateform', 'mos_change_template' )
			+ '/template_thumbnail.png';
	}
</script>
<?php
}
?>
<form action="<?php echo $_SERVER['REQUEST_URI'];?>" name='templateform' method="POST">
<?php
echo mosHTML::selectList( $darray, 'mos_change_template', "class=\"button\" onChange=\"$onchange\"",'value', 'text', $cur_template );
?>
<input class="button" type="submit" value="<?php echo _CMN_SELECT;?>">
</form>
