<?php
// $Id: mod_newsfeeds.php,v 1.12 2004/03/19 15:23:20 rcastley Exp $
/**
* Newsfeeds Module
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.12 $
**/

defined( '_VALID_MOS' ) or die( '      ' );

// $database and $my are made available via the calling function

require_once( $mainframe->getCfg( 'absolute_path' ) . "/classes/mos.rdf.class.php" );

$database->setQuery( "SELECT name, link, numarticles, cache_time"
. "\nFROM #__newsfeeds"
. "\nWHERE published='1' AND checked_out='0'"
. "\nORDER BY ordering"
);

$newsfeeds = $database->loadObjectList();

foreach ($newsfeeds as $newsfeed) {
	$rdf = new mosRDF();
	$rdf->set_Options(
	array( "channel"=>"hidden",
	"build"=>"hidden",
	"cache_update"=>"hidden",
	"image"=>"",
	"textinput"=>"hidden"));
	$rdf->use_dynamic_display( false );
	$rdf->set_table_width( "98%" );
	$rdf->_link_target = "_blank";
	$rdf->set_max_item( $newsfeed->numarticles );
	$rdf->set_refresh( $newsfeed->cache_time );
	$rdf->parse_RDF( $newsfeed->link );
	?>
	<span class="newsfeedheading"><?php echo $newsfeed->name;?></span><br />
	<span class="newsfeeddate"><?php echo $rdf->get_cache_update_time();?></span>
	<?php
	echo $rdf->getMosContent();
	$rdf->finish();
}
?>
