<?php
// $Id: mod_latestnews.php,v 1.16 2004/04/07 11:56:03 rcastley Exp $
/**
* Latest News Module
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.16 $
**/

defined( '_VALID_MOS' ) or die( '      ' );

global $mosConfig_offset;

$count = @$params->count ? intval( $params->count ) : 5;
$catid = @$params->catid ? intval( $params->catid ) : 0;

$now = date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );

// set up the query, the '#__' is converted into the table prefix
// set all content items:
// - not on the front page :: mask=0
// - pubslished :: state=1
// - checked out :: checked_out = 0
// - not in a menu :: sectionid > 0
// - between the publish_up and publish_down dates

$query = "SELECT f.content_id, a.id, a.title, a.sectionid, a.catid"
	. "\nFROM #__content AS a"
	. "\nLEFT JOIN #__content_frontpage AS f ON f.content_id = a.id"
	. "\nWHERE (f.content_id IS NULL AND a.state='1' AND a.checked_out='0' AND a.sectionid > '0')"
	. "\n	AND (a.publish_up = '0000-00-00 00:00:00' OR a.publish_up <= '$now')"
	. "\n	AND (a.publish_down = '0000-00-00 00:00:00' OR a.publish_down >= '$now')"
	. ($catid ? "\n	AND a.catid='$catid'" : '')
	. "\nORDER BY a.created DESC LIMIT $count";
// initialise the query in the $database connector
// this translates the '#__' prefix into the real database prefix

$database->setQuery( $query );

// retrieve the list of returned records as an array of objects

$rows = $database->loadObjectList();

// cycle through the returned rows displaying them in a table
// with links to the content item
// escaping in and out of php is now permitted
?>
<table dir=rtl cellpadding="1" cellspacing="1" border="0">
<?php foreach ($rows as $row) { ?>
	<tr>
		<td valign="top"><img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" /></td>
		<td><a href="<?php echo sefRelToAbs("index.php?option=content&amp;task=view&amp;id=$row->id"); ?>"><?php echo $row->title ?></a></td>
	</tr>
<?php
}
?>
</table>
