<?php
// $Id: mospaging.inc,v 1.17 2004/04/07 11:56:03 rcastley Exp $
/**
* Page Break Mambot
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.17 $
* @author Andrew Eddie <eddieajau@user.sourceforge.net>
**/

defined( '_VALID_MOS' ) or die( '      ' );

function MAMBOT_paging( &$row, $mask, $pop ) {
	global $mosConfig_live_site, $Itemid;
	global $mainframe;
	
	$page = intval( mosGetParam( $_REQUEST, 'limitstart', 0 ) );
	
	// $bots holds all the mospagebreak mambots
	preg_match_all( "/{(mospagebreak)\s*(.*?)}/i", $row->text, $bots, PREG_SET_ORDER );
	
	// split the text around the mambot
	$text = preg_split( "/{(mospagebreak)\s*(.*?)}/i", $row->text );
	
	// count the number of pages
	$n = count( $text );
	if ($n > 1) {
		// we have found at least one mambot, therefore at least 2 pages
		
		// reset the text, we already hold it in the $text array
		$row->text = "";
		
		$hasToc = false;
		$hasTitle = false;
		
		$args = array();
		if (@$bots[$page-1]) {
			// we have a mambot for this page
			if (@$bots[$page-1][2]) {
				// the mambot has arguments
				parse_str( str_replace( '&amp;', '&', $bots[$page-1][2] ), $args );
				if (@$args['toc'] == '1' || @$args['toc'] == 'yes') {
					$hasToc = true;
				}
				if (@$args['title']) {
					$hasTitle = true;
				}
			}
		}
		$hasToc = $mainframe->getCfg('multipage_toc');
		
		if ($hasToc) {
			$link = "index.php?option=content&amp;task=view&amp;id=$row->id&Itemid=$Itemid";
			
			$row->toc = "<table cellspacing=\"1\" cellpadding=\"1\" border=\"0\" class=\"contenttoc\" align=\"right\">";
			$row->toc .= "<tr class=\"contenttocheading\">";
			$row->toc .= "<td align=\"center\" class=\"contenttocheading\">";
			$row->toc .= "<div class=\"contenttocheading\">";
			$row->toc .= _TOC_JUMPTO.":</div></td></tr>";
			$row->toc .= "<tr><td><a href=\"".sefRelToAbs( $link )."\" class=\"toclink\">$row->title</a></td></tr>";
			
			$i = 2;
			$nextTitle = _PN_PAGE." ".($page+2);
			foreach ($bots as $bot) {
				$link2 = "$link&limit=1&limitstart=" . ($i-1);
				if (@$bot[2]) {
					parse_str( str_replace( '&amp;', '&', $bot[2] ), $args2 );
					if (@$args2['title']) {
						$row->toc .= "<tr><td><a href=\"".sefRelToAbs( $link2 )."\" class=\"toclink\">{$args2['title']}</a></td></tr>";
						if ($page == $i-2) {
							$nextTitle = $args2['title'];
						}
					} else {
						$row->toc .= "<tr><td><a href=\"".sefRelToAbs( $link2 )."\" class=\"toclink\">"._PN_PAGE." $i</a></td></tr>";
					}
				} else {
					$row->toc .= "<tr><td><a href=\"".sefRelToAbs( $link2 )."\" class=\"toclink\">"._PN_PAGE." $i</a></td></tr>";
				}
				$i++;
			}
			
			$row->toc .= "</table>";
			
		} else {
			$row->toc = "";
		}
		
		
		if ($hasTitle) {
			$row->text .= "<span class=\"contentpagetitle\">{$args['title']}</span>";
		}
		
		// traditional mos page navigation
		require_once( "includes/pageNavigation.php" );
		$pageNav = new mosPageNav( $n, $page, 1 );
		
		// page counter
		$row->text .= "<div align=\"right\">";
		$row->text .= $pageNav->writeLeafsCounter();
		$row->text .= "</div>";
		
		// the page text
		$row->text .= $text[$page];
		$row->text .= "<br />";
		$row->text .= "<div class=\"pagenavbar\" align=\"center\">";
		
		if ($page < $n-1 && $hasToc) {
			$link = "index.php?option=content&amp;task=view&amp;id=$row->id&Itemid=$Itemid";
			$link2 = "$link&limit=1&limitstart=" . ($page+1);
			$nextTitle  = mosGetParam( $_REQUEST, 'nextTitle ', 0 ); // hack to hide undefined var when error reporting on max
			$n = $nextTitle ? $nextTitle : "";
			$next = "<a href=\"".sefRelToAbs( $link2 )."\">"
			._CMN_NEXT . ": $n " . _CMN_NEXT_ARROW
			. "</a>";
			$row->text .= "<div align=\"right\">$next</div>";
		}
		
		// the page links
		if ($pop) {
			$row->text .= $pageNav->writePagesLinks( "index2.php?option=content&amp;task=view&amp;pop=$pop&amp;id=$row->id" );
		} else {
			$row->text .= $pageNav->writePagesLinks( "index.php?option=content&amp;task=view&amp;id=$row->id&amp;Itemid=$Itemid" );
		}
		$row->text .= "</div><br />";
	}
}
?>
