<?php
// $Id: index.php,v 1.51 2004/04/06 21:28:52 eddieajau Exp $
/**
* Main index.php file
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.51 $
**/

define( "_VALID_MOS", 1 );

if (!file_exists( "configuration.php" ) || filesize( "configuration.php") < 10) {
	header( "Location: installation/index.php" );
	exit();
}

include_once( "globals.php" );
require_once( "configuration.php" );

if ($mosConfig_offline == 1){
	include( 'offline.php' );
	exit();
}

require_once( "classes/mambo.php" );
require_once( "includes/sef.php" );
require_once( "includes/frontend.php" );

/*
if (file_exists( "installation/index.php" )) {
	include ("offline.php");
	exit();
}
*/

// retrieve some expected url (or form) arguments
$option = trim( strtolower( mosGetParam( $_REQUEST, 'option' ) ) );
$Itemid = intval( mosGetParam( $_REQUEST, 'Itemid', null ) );
$database = new database( $mosConfig_host, $mosConfig_user, $mosConfig_password, $mosConfig_db, $mosConfig_dbprefix );
$acl = new gacl_api();

if ($option == '') {
	if ($Itemid) {
		$database->setQuery( "SELECT id, link"
		. "\nFROM #__menu"
		. "\nWHERE menutype='mainmenu' AND id='$Itemid' AND published='1'"
		);
	} else {
		$database->setQuery( "SELECT id, link"
		. "\nFROM #__menu"
		. "\nWHERE menutype='mainmenu' AND published='1'"
		. "\nORDER BY parent, ordering LIMIT 1" );
	}
	$menu = new mosMenu( $database );
	if ($database->loadObject( $menu )) {
		$Itemid = $menu->id;
	}
	$link = $menu->link;
	if (($pos = strpos( $link, '?' )) !== false) {
		$link = substr( $link, $pos+1 ). '&Itemid='.$Itemid;
	}
	parse_str( $link, $temp );
	// this is a patch, need to rework when globals are handled better
	foreach ($temp as $k=>$v) {
		$GLOBALS[$k] = $v;
		$_REQUEST[$k] = $v;
		if ($k == 'option') {
			$option = $v;
		}
	}
}
// do we have a valid Itemid yet??
if ($Itemid === null) {
	// Nope, just use the homepage then.
	$database->setQuery( "SELECT id"
	. "\nFROM #__menu"
	. "\nWHERE menutype='mainmenu' AND published='1'"
	. "\nORDER BY parent, ordering LIMIT 1"
	);
	if (!($Itemid = $database->loadResult())) {
		echo $database->getErrorMsg();
	}
}

// patch to lessen the impact on templates
if ($option == 'search') {
	$option = 'com_search';
}

// mainframe is an API workhorse, lots of 'core' interaction routines
$mainframe = new mosMainFrame( $database, $option, '.' );

// Support for simple debug
include_once($mosConfig_absolute_path . "/includes/debug.php");
$mosDebug = new mosDebug($mosConfig_debug);

$mainframe->initSession();

if ($mosConfig_lang=='') {
	$mosConfig_lang='english';
}
include_once ('language/'.$mosConfig_lang.'.php');

$return = mosGetParam( $_REQUEST, 'return', null );
if ($option == "login") {
	$mainframe->login();

	if ($return) {
		mosRedirect( $return );
	} else {
		mosRedirect( 'index.php' );
	}

} else if ($option == "logout") {
	$mainframe->logout();

		if ($return) {
			mosRedirect($return);
		} else {
			mosRedirect('index.php');
		}
}

// get the information about the current user from the sessions table
$my = $mainframe->getUser();

// detect first visit
$mainframe->detect();

$gid = intval( $my->gid );

$cur_template = $mainframe->getTemplate();
$col_main = 1;		// temp fix - this feature is currently disabled

$do_gzip_compress = FALSE;
if ($mosConfig_gzip==1) {
	$phpver = phpversion();
	$useragent = (isset($_SERVER["HTTP_USER_AGENT"]) ) ? $_SERVER["HTTP_USER_AGENT"] : $HTTP_USER_AGENT;

	if ( $phpver >= '4.0.4pl1' && ( strstr($useragent,'compatible') || strstr($useragent,'Gecko') ) )
	{
		if ( extension_loaded('zlib') )
		{
			ob_start('ob_gzhandler');
		}
	}
	else if ( $phpver > '4.0' )
	{
		if ( strstr($HTTP_SERVER_VARS['HTTP_ACCEPT_ENCODING'], 'gzip') )
		{
			if ( extension_loaded('zlib') )
			{
				$do_gzip_compress = TRUE;
				ob_start();
				ob_implicit_flush(0);

				header('Content-Encoding: gzip');
			}
		}
	}
} else {
	ob_start();
}
header( "Expires: Mon, 26 Jul 1997 05:00:00 GMT" );	// Date in the past
header( "Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT" );	// always modified
header( "Cache-Control: no-store, no-cache, must-revalidate" );
header( "Cache-Control: post-check=0, pre-check=0", false );
header( "Pragma: no-cache" );

if (!file_exists("templates/$cur_template/index.php")){
	echo "Template File Not Found!";
} else {
	require_once( "templates/$cur_template/index.php" );
}

if ( $do_gzip_compress )
{
	//
	// Borrowed from php.net!
	//
	$gzip_contents = ob_get_contents();
	ob_end_clean();

	$gzip_size = strlen($gzip_contents);
	$gzip_crc = crc32($gzip_contents);

	$gzip_contents = gzcompress($gzip_contents, 9);
	$gzip_contents = substr($gzip_contents, 0, strlen($gzip_contents) - 4);

	echo "\x1f\x8b\x08\x00\x00\x00\x00\x00";
	echo $gzip_contents;
	echo pack('V', $gzip_crc);
	echo pack('V', $gzip_size);
} else {
	ob_end_flush();
}
?>
