<?php
// $Id: pdf.php,v 1.17 2004/04/07 11:56:02 rcastley Exp $
/**
* PDF code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.17 $
* Created by Phil Taylor me@phil-taylor.com
* Support file to display PDF Text Only using class from - http://www.ros.co.nz/pdf/readme.pdf
* HTMLDoc is available from: http://www.easysw.com/htmldoc and needs installing on the server for better HTML to PDF conversion
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

global $mosConfig_offset, $mosConfig_hideAuthor, $mosConfig_hideModifyDate, $mosConfig_hideCreateDate, $mosConfig_live_site;

$safe="0";
if (get_php_setting('safe_mode') == 'ON') {
	$safe="1";
}

if ($safe == "0") {

	if (@file_exists( "/usr/bin/htmldoc" )) {
		$id = strtolower( trim( mosGetParam( $_REQUEST, 'id',1 ) ) );
		$article = $mosConfig_live_site . '/index2.php?option=content&task=view&pop=1&page=0&hide_js=1&pdf=1&id=' . $id;
		header( "Content-Type: application/pdf" );
		header( "Content-Disposition: inline; filename=\"pdf-mambo.pdf\"" );
		flush();
		//following line for Linux only - windows may need the path as well...
		passthru( "/usr/bin/htmldoc --no-localfiles --no-compression -t pdf14 --jpeg --webpage --header t.D --footer ./. --size letter --left 0.5in '$article'" );
	} else {
		dofreePDF ($database);
	}
} else {

	dofreePDF ($database);
}

function dofreePDF ($database) {
	global $mosConfig_live_site, $mosConfig_sitename, $mosConfig_offset, $mosConfig_hideCreateDate, $mosConfig_hideAuthor, $mosConfig_hideModifyDate;

	$id = strtolower( trim( mosGetParam( $_REQUEST, 'id',1 ) ) );
	include('classes/class.ezpdf.php');
	$row = new mosContent( $database );
	$row->load($id);
	//Find Author Name
	$users_rows = new mosUser( $database );
	$users_rows->load($row->created_by);
	$row->author = $users_rows->name;
	$row->usertype = $users_rows->usertype;

	// Ugly but needed to get rid of all the stuff the PDF class cant handle
	$row->introtext = str_replace('<p>', "\n\n", $row->introtext);
	$row->fulltext = str_replace('<p>', "\n\n" , $row->fulltext);
	$row->introtext = str_replace('<P>', "\n\n", $row->introtext);
	$row->fulltext = str_replace('<P>', "\n\n" , $row->fulltext);
	$row->fulltext = str_replace('<br />', "\n" , $row->fulltext);
	$row->fulltext = str_replace('<br>', "\n" , $row->fulltext);
	$row->fulltext = str_replace('<BR />', "\n" , $row->fulltext);
	$row->fulltext = str_replace('<BR>', "\n" , $row->fulltext);
	$row->introtext = str_replace('<li>', "   - " , $row->introtext);
	$row->fulltext = str_replace('<li>', "   - " , $row->fulltext);
	$row->introtext = str_replace('<LI>', "   - " , $row->introtext);
	$row->fulltext = str_replace('<LI>', "   - " , $row->fulltext);
	$row->introtext = strip_tags($row->introtext);
	$row->introtext = str_replace( '{mosimage}', '', $row->introtext );
	$row->introtext = str_replace( '{mospagebreak}', '', $row->introtext );
	$row->fulltext = strip_tags($row->fulltext);
	$row->fulltext = str_replace( '{mosimage}', '', $row->fulltext );
	$row->fulltext = str_replace( '{mospagebreak}', '', $row->fulltext );
	$row->fulltext = decodeHTML($row->fulltext);
	$row->introtext = decodeHTML($row->introtext);

	$pdf =& new Cezpdf('a4','P');  //A4 Portrait
	$pdf -> ezSetCmMargins(2,1.5,1,1);
	$pdf->selectFont('./fonts/Helvetica.afm'); //choose font

	$all = $pdf->openObject();
	$pdf->saveState();
	$pdf->setStrokeColor(0,0,0,1);
	$pdf->line(10,40,578,40);
	$pdf->line(10,822,578,822);
	$pdf->addText(30,34,6,$mosConfig_live_site . " - " . $mosConfig_sitename);
	$pdf->addText(250,34,6,"Powered by Mambo Open Source");
	$pdf->addText(450,34,6,"Generated: " . date("j F, Y, H:i", time()+$mosConfig_offset*60*60));
	$pdf->restoreState();
	$pdf->closeObject();
	$pdf->addObject($all,'all');
	$pdf->ezSetDy(30);

	$txt1 = $row->title;
	$pdf->ezText($txt1,14);

	$txt2=null;
	$mod_date = null; $create_date = null;
	if (intval( $row->modified ) <> 0) {
		$mod_date = mosFormatDate($row->modified);
	}
	if (intval( $row->created ) <> 0) {
		$create_date = mosFormatDate($row->created);
	}

	if ($mosConfig_hideCreateDate == "0") {
		$txt2 .= "(".$create_date.") - ";
	}

	if ($mosConfig_hideAuthor == "0") {
		if ($row->author != "" && $mosConfig_hideAuthor == "0") {
			if ($row->usertype == 'administrator' || $row->usertype == 'superadministrator') {
				$txt2 .=  _WRITTEN_BY." ".($row->created_by_alias ? $row->created_by_alias : $row->author);
			} else {
				$txt2 .=  _AUTHOR_BY." ".($row->created_by_alias ? $row->created_by_alias : $row->author);
			}
		}
	}

	if ($mosConfig_hideModifyDate == "0") {
		$txt2 .= " - " . _LAST_UPDATED." (".$mod_date.") ";
	}

	$txt2 .= "\n\n";
	$pdf->ezText($txt2,8);
	$txt3 ="$row->introtext\n$row->fulltext";
	$pdf->ezText($txt3,10);
	$pdf->ezStream();

}
function decodeHTML($string) {
	$string = strtr($string, array_flip(get_html_translation_table(HTML_ENTITIES)));
	$string = preg_replace("/&#([0-9]+);/me", "chr('\\1')", $string);
	return $string;
}

function get_php_setting($val) {
	$r =  (ini_get($val) == '1' ? 1 : 0);
	return $r ? 'ON' : 'OFF';
}
?>
