<?php
// $Id: HTML_toolbar.php,v 1.3 2004/01/13 02:12:19 eddieajau Exp $
/**
* Button Bar HTML
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.3 $
*
* This file differs slightly from the admin file in that the icons are 20x20 max
**/

/**
* Utility class for the button bar
*/
class mosToolBar {
	/**
	* Writes the start of the button bar table
	*/
	function startTable() { ?>
		<table cellpadding="0" cellspacing="0" border="0" width="99%">
		<tr>
<?php
	}
	/**
	* Writes a custom option and task button for the button bar
	* @param string The task to perform (picked up by the switch($task) blocks
	* @param string The image to display
	* @param string The image to display when moused over
	* @param string The alt text for the icon image
	* @param boolean True if required to check that a standard list item is checked
	*/
	function custom( $task='', $icon='', $iconOver='', $alt='', $listSelect=true ) {
		if ($listSelect) {
			$href = "javascript:if (document.adminForm.boxchecked.value == 0){ alert('      $alt');}else{submitbutton('$task')}";
		} else {
			$href = "javascript:submitbutton('$task')";
		}
?>
			<td width="25" align="center"><a href="<?php echo $href;?>" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('<?php echo $task;?>','','images/<?php echo $iconOver;?>',1);"><img name="<?php echo $task;?>" src="images/<?php echo $icon;?>" alt="<?php echo $alt;?>" border="0" /></a></td>
<?php
	}
	/**
	* Writes the common 'new' icon for the button bar
	* @param string An override for the task
	* @param string An override for the alt text
	*/
	function addNew( $task='new', $alt='New' ) { ?>
			<td width="25" align="center"><a href="javascript:submitbutton('<?php echo $task;?>');" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('<?php echo $task;?>','','images/new_f2.png',1);"><img src="images/new.png"  alt="<?php echo $alt;?>" value="<?php echo $task;?>" border="0" name="<?php echo $task;?>" /></a></td>
<?php
	}
	/**
	* Writes a common 'publish' button
	* @param string An override for the task
	* @param string An override for the alt text
	*/
	function publish( $task='publish', $alt='Publish' ) { ?>
			<td width="25" align="center"><a href="javascript:submitbutton('<?php echo $task;?>');" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('<?php echo $task;?>','','images/publish_f2.png',1);"><img name="<?php echo $task;?>" src="images/publish.png" alt="<?php echo $alt;?>" border="0" /></a></td>
<?php
	}
	/**
	* Writes a common 'publish' button for a list of records
	* @param string An override for the task
	* @param string An override for the alt text
	*/
	function publishList( $task='publish', $alt='Publish' ) { ?>
			<td width="25" align="center"><a href="javascript:if (document.adminForm.boxchecked.value == 0){ alert('    '); } else {submitbutton('<?php echo $task;?>', '');}" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('<?php echo $task;?>','','images/publish_f2.png',1);"><img name="<?php echo $task;?>" src="images/publish.png" alt="<?php echo $alt;?>" border="0" /></a></td>
<?php
	}
	/**
	* Writes a common 'unpublish' button
	* @param string An override for the task
	* @param string An override for the alt text
	*/
	function unpublish( $task='unpublish', $alt='Unpublish' ) { ?>
			<td width="25" align="center"><a href="javascript:submitbutton('<?php echo $task;?>');" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('<?php echo $task;?>','','images/unpublish_f2.png',1);" ><img name="<?php echo $task;?>" src="images/unpublish.png" alt="<?php echo $alt;?>" border="0" /></a></td>
<?php
	}
	/**
	* Writes a common 'unpublish' button for a list of records
	* @param string An override for the task
	* @param string An override for the alt text
	*/
	function unpublishList( $task='unpublish', $alt='Unpublish' ) { ?>
			<td width="25" align="center"><a href="javascript:if (document.adminForm.boxchecked.value == 0){ alert('    '); } else {submitbutton('<?php echo $task;?>', '');}" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('<?php echo $task;?>','','images/unpublish_f2.png',1);" ><img name="<?php echo $task;?>" src="images/unpublish.png" alt="<?php echo $alt;?>" border="0" /></a></td>
<?php
	}
	/**
	* Writes a common 'archive' button for a list of records
	* @param string An override for the task
	* @param string An override for the alt text
	*/
	function archiveList( $task='archive', $alt='Archive' ) { ?>
			<td width="25" align="center"><a href="javascript:if (document.adminForm.boxchecked.value == 0){ alert('    '); } else {submitbutton('<?php echo $task;?>', '');}" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('<?php echo $task;?>','','images/archive_f2.png',1);"><img src="images/archive.png" alt="<?php echo $alt;?>" border="0" name="<?php echo $task;?>" /></a></td>
<?php
	}
	/**
	* Writes an unarchive button for a list of records
	* @param string An override for the task
	* @param string An override for the alt text
	*/
	function unarchiveList( $task='unarchive', $alt='Unarchive' ) { ?>
			<td width="25" align="center"><a href="javascript:if (document.adminForm.boxchecked.value == 0){ alert('      '); } else {submitbutton('<?php echo $task;?>', '');}" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('<?php echo $task;?>','','images/unarchive_f2.png',1);"><img src="images/unarchive.png" alt="<?php echo $alt;?>" border="0" name="<?php echo $task;?>" /></a></td>
<?php
	}
	/**
	* Writes a common 'edit' button for a list of records
	* @param string An override for the task
	* @param string An override for the alt text
	*/
	function editList( $task='edit', $alt='Edit' ) { ?>
			<td width="25" align="center"><a href="javascript:if (document.adminForm.boxchecked.value == 0){ alert('    '); } else {submitbutton('<?php echo $task;?>', '');}" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('<?php echo $task;?>','','images/edit_f2.png',1);"><img src="images/edit.png" name="<?php echo $task;?>" alt="<?php echo $alt;?>" border="0" /></a></td>
<?php
	}
	/**
	* Writes a common 'edit' button for a template html
	* @param string An override for the task
	* @param string An override for the alt text
	*/
	function editHtml( $task='edit_source', $alt='Edit HTML' ) { ?>
			<td width="25" align="center"><a href="javascript:if (document.adminForm.boxchecked.value == 0){ alert('    '); } else {submitbutton('<?php echo $task;?>', '');}" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('<?php echo $task;?>','','images/html_f2.png',1);"><img src="images/html.png" name="<?php echo $task;?>" alt="<?php echo $alt;?>" border="0" /></a></td>
<?php
	}
	/**
	* Writes a common 'edit' button for a template css
	* @param string An override for the task
	* @param string An override for the alt text
	*/
	function editCss( $task='edit_css', $alt='Edit CSS' ) { ?>
			<td width="25" align="center"><a href="javascript:if (document.adminForm.boxchecked.value == 0){ alert('    '); } else {submitbutton('<?php echo $task;?>', '');}" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('<?php echo $task;?>','','images/css_f2.png',1);"><img src="images/css.png" name="<?php echo $task;?>" alt="<?php echo $alt;?>" border="0" /></a></td>

<?php
	}
	/**
	* Writes a common 'delete' button for a list of records
	* @param string  Postscript for the 'are you sure' message
	* @param string An override for the task
	* @param string An override for the alt text
	*/
	function deleteList( $msg='', $task='remove', $alt='Delete' ) { ?>
			<td width="25" align="center"><a href="javascript:if (document.adminForm.boxchecked.value == 0){ alert('    '); } else if (confirm('Are you sure you want to delete selected items. <?php echo $msg;?>')){ submitbutton('<?php echo $task;?>');}" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('<?php echo $task;?>','','images/delete_f2.png',1);"><img src="images/delete.png" alt="<?php echo $alt;?>" border="0" name="<?php echo $task;?>" /></td>
<?php
	}
	/**
	* Writes a preview button for a given option (opens a popup window)
	* @param string The name of the popup file (excluding the file extension)
	*/
	function preview( $popup='' ) {
			global $database;
			$sql = "SELECT cur_template FROM #__templates";
			$database->setQuery( $sql );
			$cur_template = $database->loadResult();
			?>
			<td width="25" align="center"><a href="#" onclick="window.open('popups/<?php echo $popup;?>.php?t=<?php echo $cur_template; ?>', 'win1', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no');" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('preview','','images/preview_f2.png',1);"><img src="images/preview.png" alt="" border="0" name="preview" /></a></td>
<?php
	}
	/**
	* Writes a save button for a given option
	* @param string An override for the task
	* @param string An override for the alt text
	*/
	function save( $task='save', $alt=_CMN_SAVE ) { ?>
			<td width="25" align="center"><a href="javascript:submitbutton('<?php echo $task;?>');" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('<?php echo $task;?>','','images/save_f2.png',1);"><img src="images/save.png" alt="<?php echo $alt;?>" border="0" name="<?php echo $task;?>" /></a></td>

<?php
	}
	/**
	* Writes a save button for a given option (NOTE this is being deprecated)
	*/
	function savenew() { ?>
			<td width="25" align="center"><a href="javascript:submitbutton('savenew');" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('save','','images/save_f2.png',1);"><img src="images/save.png" alt="" border="0" name="save" /></a></td>

			<?php
	}
	/**
	* Writes a save button for a given option (NOTE this is being deprecated)
	*/
	function saveedit() { ?>
			<td width="25" align="center"><a href="javascript:submitbutton('saveedit');" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('save','','images/save_f2.png',1);"><img src="images/save.png" alt="" border="0" name="save" /></a></td>

<?php
	}
	/**
	* Writes a cancel button and invokes a cancel operation (eg a checkin)
	* @param string An override for the task
	* @param string An override for the alt text
	*/
	function cancel( $task='cancel', $alt=_CMN_CANCEL ) { ?>
			<td width="25" align="center"><a href="javascript:submitbutton('<?php echo $task;?>');" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('<?php echo $task;?>','','images/cancel_f2.png',1);"><img src="images/cancel.png" alt="<?php echo $alt;?>" border="0" name="<?php echo $task;?>" /></a></td>
<?php
	}
	/**
	* Writes a cancel button that will go back to the previous page without doing
	* any other operation
	*/
	function back() { ?>
			<td width="25" align="center"><a href="javascript:window.history.back();" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('cancel','','images/back_f2.png',1);"><img src="images/back.png" alt="" border="0" name="cancel" ></a></td>
<?php
	}
	/**
	* Write a divider between menu buttons
	*/
	function divider() { ?>
			<td width="25" align="center"><img src="images/menu_divider.png" border="0" alt="" /></td>
<?php
	}
	/**
	* Writes a media_manager button
	* @param string The sub-drectory to upload the media to
	*/
	function media_manager( $directory = '' ) { ?>
			<td width="25" align="center"><a href="#" onclick="popupWindow('media_manager/uploadimage.php?directory=<?php echo $directory; ?>','win1',250,100,'no');" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('uploadPic','','images/upload_f2.png',1);"><img src="images/upload.png" alt=" " border="0" name="uploadPic" /></a></td>
<?php
	}
	/**
	* Writes a spacer cell
	* @param string The width for the cell
	*/
	function spacer( $width='' ) { ?>
			<td width="<?php echo $width;?>">&nbsp;</td>
<?php
	}
	/**
	* Writes the end of the menu bar table
	*/
	function endTable() { ?>
		</tr>
		</table>
<?php
	}
}
?>
