<?php
// $Id: weblinks.php,v 1.17 2004/04/06 21:28:53 eddieajau Exp $
/**
* Content code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.17 $
**/

defined( '_VALID_MOS' ) or die( '      ' );

// load the html drawing class
require_once( $mainframe->getPath( 'front_html' ) );
require_once( $mainframe->getPath( 'class' ) );

$task = trim( mosGetParam( $_REQUEST, 'task', "" ) );
$id = intval( mosGetParam( $_REQUEST, 'id', 0 ) );
$catid = intval( mosGetParam( $_REQUEST, 'catid', 0 ) );

switch ($task) {
	case 'new':
	editWebLink( 0, $option );
	break;

	case 'edit':
	// disabled until permissions system can handle it
	editWebLink( 0, $option );
	break;

	case 'save':
	saveWebLink( $option );
	break;

	case 'cancel':
	cancelWebLink( $option );
	break;

	case "view":
	showItem( $id, $catid );
	break;

	default:
	listWeblinks( $catid );
	break;
}

function listWeblinks( $catid ) {
	global $database, $my;
	global $mosConfig_shownoauth, $Itemid;

	/* Query to retrieve all categories that belong under the web links section and that are published. */
	$database->setQuery( "SELECT *, COUNT(a.id) AS numlinks FROM #__categories AS cc"
	. "\nLEFT JOIN #__weblinks AS a ON a.catid = cc.id"
	. "\nWHERE a.published='1' AND section='com_weblinks' AND cc.published='1' AND cc.access <= '$my->gid'"
	. "\nGROUP BY cc.id"
	. "\nORDER BY cc.ordering"
	);

	$categories = $database->loadObjectList();
	echo $database->getErrorMsg();

	$rows = array();
	if ($catid) {
		$database->setQuery( "SELECT id, url, title, description, date, hits FROM #__weblinks"
		. "\nWHERE catid = '$catid' AND published='1' AND archived=0"
		. "\nORDER BY ordering"
		);
		$rows = $database->loadObjectList();

		$database->setQuery( "SELECT name, description, image, image_position FROM #__categories"
		. "\nWHERE id = '$catid' AND published='1'"
		);
		$currentcat=null;
		$database->loadObject($currentcat);
	}
	HTML_weblinks::displaylist( $categories, $rows, $catid, $currentcat);
}

function showItem ( $id, $catid ) {
	global $database;

	//Record the hit
	$sql="UPDATE #__weblinks SET hits=hits+1 WHERE id=$id";
	$database->setQuery( $sql );
	$database->query();

	$database->setQuery( "SELECT url FROM #__weblinks WHERE id=$id" );
	$url = $database->loadResult();

	mosRedirect ( $url );

	listWeblinks( $catid );

}

function editWebLink( $id, $option ) {
	global $database, $my;
	global $mosConfig_absolute_path, $mosConfig_live_site;

	if ($my->gid < 1) {
		mosNotAuth();
		return;
	}

	$row = new mosWeblink( $database );
	// load the row from the db table
	$row->load( $id );

	// get list of categories
	$categories[] = mosHTML::makeOption( '0', _SEL_CATEGORY );
	$database->setQuery( "SELECT id AS value, name AS text FROM #__categories"
	. "\nWHERE section='$option' ORDER BY ordering" );
	$categories = array_merge( $categories, $database->loadObjectList() );

	if (count( $categories ) < 1) {
		mosRedirect( "index2.php?option=categories&section=$option",
		'       ' );
	}

	$clist = mosHTML::selectList( $categories, 'catid', 'class="inputbox" size="1"',
	'value', 'text', intval( $row->catid ) );

	// fail if checked out not by 'me'
	if ($row->checked_out && $row->checked_out <> $my->id) {
		mosRedirect( "index2.php?option=$option",
		'The module $row->title is currently being edited by another administrator.' );
	}

	if ($id) {
		$row->checkout( $my->id );
	} else {
		// initialise new record
		$row->published = 0;
		$row->approved = 0;
	}

	// build the html select list for ordering
	$order = mosGetOrderingList( "SELECT ordering AS value, title AS text"
	. "\nFROM #__weblinks"
	. "\nWHERE catid='$row->catid' ORDER BY ordering"
	);
	$olist = mosHTML::selectList( $order, 'ordering', 'class="inputbox" size="1"',
	'value', 'text', intval( $row->ordering ) );

	// make the select list for the image positions
	$yesno[] = mosHTML::makeOption( '0', 'No' );
	$yesno[] = mosHTML::makeOption( '1', 'Yes' );

	// build the html select list
	$applist = mosHTML::selectList( $yesno, 'approved', 'class="inputbox" size="2"',
	'value', 'text', $row->approved );


	HTML_weblinks::editWeblink( $option, $row, $clist, $olist, $applist );
}

function cancelWebLink( $option ) {
	global $database, $my;

	if ($my->gid < 1) {
		mosNotAuth();
		return;
	}

	$row = new mosWeblink( $database );
	$row->id = intval( mosGetParam( $_POST, 'id', 0 ) );
	$row->checkin();
	$Itemid = mosGetParam( $_POST, 'Returnid', '' );
	mosRedirect( "index.php?Itemid=$Itemid" );
}

/**
* Saves the record on an edit form submit
* @param database A database connector object
*/
function saveWeblink( $option ) {
	global $database, $my;

	if ($my->gid < 1) {
		mosNotAuth();
		return;
	}

	$row = new mosWeblink( $database );
	if (!$row->bind( $_POST, "approved published" )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$isNew = $row->id < 1;

	$row->date = date( "Y-m-d H:i:s" );
	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();

	// Notify admin's
	$query = "SELECT email, name"
	. "\nFROM #__users"
	. "\nWHERE usertype='superadministrator' and sendemail=1";
	$database->setQuery($query);
	if(!$database->query()) {
		echo $database->stderr( true );
		return;
	}

	$adminRows = $database->loadObjectList();
	foreach( $adminRows as $adminRow) {
		$type	= "Weblink";
		$title	= $linktitle;
		mosSendAdminMail($adminRow->name, $adminRow->email, "", $type, $row->title, $my->name );
	}

	$msg = $isNew ? _THANK_SUB : '';
	$Itemid = mosGetParam( $_POST, 'Returnid', '' );
	mosRedirect( "index.php?Itemid=$Itemid&mosmsg=$msg" );
}
?>
