<?php
// $Id: weblinks.html.php,v 1.17 2004/03/16 00:35:53 eddieajau Exp $
/**
* Content code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.17 $
**/

defined( '_VALID_MOS' ) or die( '      ' );

require_once( "includes/HTML_toolbar.php" );

class HTML_weblinks {
	function displaylist( &$categories, &$rows, $catid, &$currentcat ) {
		global $Itemid, $mosConfig_live_site;
	?>
<table dir=rtl width="100%" cellpadding="4" cellspacing="0" border="0" align="center" class="contentpane">
  <form name="news">
    <tr>
      <td colspan="2"> <span class="componentheading">
        <?php if (($currentcat->name)<>''){
        	echo $currentcat->name;
        } else {
        	echo _WEBLINKS_TITLE;
        }
			?>
        </span> </td>
    </tr>
    <tr>
      <td width="60%" valign="top" class="contentdescription" colspan="2">
        <?php if (($currentcat->image)<>'') {
        	$img='stories/'.$currentcat->image;
        	$align=$currentcat->image_position;
        } else {
        	$img='M_images/web_links.jpg';
        	$align='right';
        }
		?>
        <img src="<?php echo $mosConfig_live_site;?>/images/<?php echo $img; ?>" align="<?php echo $align; ?>" hspace="6" alt="Weblinks Section" />
        <?php if (($currentcat->description)<>'') {
        	echo $currentcat->description;
        } else {
        	echo _WEBLINKS_DESC;
        }
		?>
      </td>
    </tr>
    <?php
    if (count( $rows )) { ?>
    <tr>
      <td colspan="2"> <table dir=rtl width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td width="32" height="20" align="center" class="sectiontableheader">&nbsp;</td>
            <td width="85%" height="20" class="sectiontableheader"><?php echo _HEADER_TITLE_WEBLINKS; ?></td>
						<td width="15%" height="20" class="sectiontableheader" align="right"><?php echo _HEADER_HITS; ?></td>
          </tr>
          <?php
    $tabclass = array("sectiontableentry1", "sectiontableentry2");
    $k = 0;
    foreach ($rows as $row) {
    	$date = split( " ", $row->date );
    	$datesplit = split( "-", $date[0] );
    	$today = date( "n d Y" );
    	$todaydate = split( " ", $today );
    	$sum = $todaydate[2] - $datesplit[0]; ?>
          <tr class="<?php echo $tabclass[$k]; ?>">
            <td width="32" height="20" align="center"> <img src="<?php echo $mosConfig_live_site;?>/images/M_images/weblink.png" width="16" height="16" align="bottom" vspace="3" hspace="10" />
            </td>
            <td> <a href="<?php echo sefRelToAbs("index.php?option=com_weblinks&amp;task=view&amp;Itemid=$Itemid&amp;catid=$catid&amp;id=$row->id"); ?>" target="_blank" class="category">
              <?php echo $row->title; ?> </a> <br /> <?php echo $row->description; ?>
            </td>
						<td align="right">
							<?php echo $row->hits; ?>
						</td>
          </tr>
          <?php	$k = 1 - $k; } ?>
        </table>
        <?php } ?>
      </td>
    </tr>
  </form>
  <tr><td>&nbsp;</td></tr>
  <?php foreach ($categories as $cat) {
			if ($catid == $cat->catid) { ?>
    <tr>
      <td><img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" />&nbsp;&nbsp;
      	<b><?php echo $cat->name;?></b>&nbsp;<span class="small">(<?php echo $cat->numlinks;?>)</span></td>
    </tr>
    <?php		} else {
    	?>
    <tr>
      <td><img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" />&nbsp;
      	<a href="<?php echo sefRelToAbs("index.php?option=com_weblinks&amp;Itemid=$Itemid&amp;catid=$cat->catid"); ?>" class="category">
        <?php echo $cat->name;?> </a>&nbsp;<span class="small">(<?php echo $cat->numlinks;?>)</span></td>
    </tr>
    <?php		}
  }
    ?>
</table>
<?php
	}

	/**
	* Writes the edit form for new and existing record (FRONTEND)
	*
	* A new record is defined when <var>$row</var> is passed witht the <var>id</var>
	* property set to 0.
	* @param mosWeblink The weblink object
	* @param string The html for the categories select list
	*/
	function editWeblink( $option, &$row, &$clist ) {
		$Returnid = intval( mosGetParam( $_REQUEST, 'Returnid', 0 ) );
?>
	<script language="javascript" type="text/javascript">
	function submitbutton(pressbutton) {
		var form = document.adminForm;
		if (pressbutton == 'cancel') {
			submitform( pressbutton );
			return;
		}

		// do field validation
		if (form.title.value == ""){
			alert( "Weblink item must have a title" );
		} else if (getSelectedValue('adminForm','catid') < 1) {
			alert( "  " );
		} else if (form.url.value == ""){
			alert( "    " );
		} else {
			submitform( pressbutton );
		}
	}
	</script>
	<form action="<?php echo sefRelToAbs("index.php"); ?>" method="post" name="adminForm" id="adminForm">
	<table dir=rtl cellpadding="4" cellspacing="0" border="0" width="100%">
		<tr>
			<td width="50%"><span class="componentheading"><?php echo _SUBMIT_LINK;?></span></td>
			<td width="50%">
<?php
mosToolBar::startTable();
mosToolBar::spacer();
mosToolBar::save();
mosToolBar::cancel();
mosToolBar::endtable();
?>
			</td>
		</tr>
	</table>
	<table dir=rtl cellpadding="4" cellspacing="1" border="0" width="100%">
		<tr>
			<td width="20%" align="right"><?php echo _NAME; ?></td>
			<td width="80%">
				<input class="inputbox" type="text" name="title" size="50" maxlength="250" value="<?php echo htmlspecialchars( $row->title, ENT_QUOTES );?>" />
			</td>
		</tr>

		<tr>
			<td valign="top" align="right"><?php echo _SECTION; ?></td>
			<td>
				<?php echo $clist; ?>
			</td>
		</tr>

		<tr>
			<td valign="top" align="right"><?php echo _URL; ?></td>
			<td>
				<input class="inputbox" type="text" name="url" value="<?php echo $row->url; ?>" size="50" maxlength="250" />
			</td>
		</tr>

		<tr>
			<td valign="top" align="right"><?php echo _URL_DESC; ?></td>
			<td>
				<textarea class="inputbox" cols="30" rows="6" name="description" style="width:300px" width="300"><?php echo htmlspecialchars( $row->description, ENT_QUOTES );?></textarea>
			</td>
		</tr>

	</table>

	<input type="hidden" name="id" value="<?php echo $row->id; ?>" />
	<input type="hidden" name="option" value="<?php echo $option;?>" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="ordering" value="<?php echo $row->ordering; ?>" />
	<input type="hidden" name="approved" value="<?php echo $row->approved; ?>" />
	<input type="hidden" name="Returnid" value="<?php echo $Returnid; ?>" />
	</form>
<?php
	}
}
?>
