<?php
// $Id: search.php,v 1.4 2004/03/19 17:41:13 rcastley Exp $
/**
* Search code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.4 $
**/

defined( '_VALID_MOS' ) or die( '      ' );

/**
* To be implemented in Version 4.6
*/
function mosLogSearch( $search_term ) {
	global $database;
	global $mosConfig_enable_log_searches;

	if (@$mosConfig_enable_log_searches) {
		$database->setQuery( "SELECT hits"
		. "\nFROM #__core_log_searches"
		. "\nWHERE LOWER(search_term)='$search_term'" );
		$hits = intval( $database->loadResult() );
		echo $database->getErrorMsg();
		if ($hits) {
			$database->setQuery( "UPDATE #__core_log_searches SET hits=(hits+1)"
			. "\nWHERE LOWER(search_term)='$search_term'" );
			$database->query();
			echo $database->getErrorMsg();
		} else {
			$database->setQuery( "INSERT INTO #__core_log_searches VALUES"
			. "\n('$search_term','1')" );
			$database->query();
			echo $database->getErrorMsg();
		}
	}
}

require_once( $mainframe->getPath( 'front_html' ) );

$gid = $my->gid;

search_html::openhtml( htmlspecialchars( $searchword ) );

$searchword = mosGetParam( $_REQUEST, 'searchword', '' );
$searchword = $database->getEscaped( trim( $searchword ) );

$search_ignore = array();
@include "$mosConfig_absolute_path/language/$mosConfig_lang.ignore.php";

search_html::searchbox( htmlspecialchars( $searchword ) );
if (!$searchword) {
	search_html::message( _NOKEYWORD );
} else if (in_array( $searchword, $search_ignore )) {
	search_html::message( _IGNOREKEYWORD );
} else {
	search_html::searchintro( htmlspecialchars( $searchword ) );

	mosLogSearch( $searchword );

	$totalRows = 0;

	// current content
	$obj = new mosContent( $database );
	$rows = $obj->search( $searchword );
	$totalRows += count( $rows );
	unset( $obj );

	// archived content
	$obj = new mosContent( $database );
	$archived = $obj->search( $searchword, '-1', 'Archived ' );
	unset( $obj );

	// this needs to be more dynamic??? not hardcoded
	require_once( "components/com_weblinks/weblinks.class.php" );

	$obj = new mosWeblink( $database );
	// merge the weblinks results, columns must match format of content
	$rows = array_merge( $rows, $obj->search( $searchword ) );
	unset( $obj );

	// bring current and archived together, with the latter at the end
	$rows = array_merge( $rows, $archived );
	$totalRows = count( $rows );

	for ($i=0, $n=count($rows); $i < $n; $i++) {
		$row = &$rows[$i]->text;
		$row = preg_replace( "'<script[^>]*>.*?</script>'si", "", $row );
		$row = str_replace( '{mosimage}', '', $row );
		$row = preg_replace( '/<a\s+.*?href="([^"]+)"[^>]*>([^<]+)<\/a>/is','\2 (\1)', $row );
		$row = preg_replace( '/<!--.+?-->/', '', $row);
		$row = preg_replace( '/{.+?}/', '', $row);
		$row = substr( strip_tags( $row ), 0, 50 );
	}

	if ($n) {
		search_html::display( $rows );
	} else {
		search_html::displaynoresult();
	}

	search_html::conclusion( $totalRows, htmlspecialchars( $searchword ) );
}
?>
