<?php
// $Id: frontpage.php,v 1.39 2004/04/06 21:28:52 eddieajau Exp $
/**
* Content code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.39 $
**/

defined( '_VALID_MOS' ) or die( '      ' );

//require_once( $mainframe->getPath( 'front_html' ) );
require_once( $mainframe->getPath( 'front_html', 'com_content') );

frontpage( $option );

/**
* Select all the content items that are within the 'frontpage' date display times
*
* The following parameters are available to the frontpage
* count=n : display a maximum of n lines
* intro=m : only show the intro for the first m items
* image=b : b=true shows images otherwise just text
* @param database A database connection object
*/
function frontpage( $option ) {
	global $database, $mainframe, $my, $Itemid;
	global $mosConfig_offset;

	$access = !$mainframe->getCfg( 'shownoauth' );

	$menu= new mosMenu( $database );
	$menu->load( $Itemid );
	$params = mosParseParams( $menu->params );

	$count = isset( $params->count ) ? $params->count : 6;
	$intro = isset( $params->intro ) ? $params->intro : 3;
	$image = @$params->image ? MASK_IMAGES : 0;
	$header = @$params->header;
	$empty = @$params->empty;
	$orderby = @$params->orderby;

	switch (strtolower( $orderby )) {
		case 'date':
			$orderby = "a.created";
			break;
		case 'rdate':
			$orderby = "a.created DESC";
			break;
		default:
			$orderby = "f.ordering, a.ordering ASC, a.catid, a.sectionid";
			break;
	}

	if ($header) {
		echo "<span class=\"frontpageheader\">$header</span>";
	}

	$t = new mosTemplate( $database );
	$t->load( 0 );

	$now = date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );

	$database->setQuery( "SELECT ROUND(v.rating_sum/v.rating_count) AS rating, v.rating_count,"
	. "\na.*, u.name AS author, u.usertype"
	. "\nFROM #__content AS a"
	. "\nINNER JOIN #__content_frontpage AS f ON f.content_id = a.id"
	. "\nLEFT JOIN #__users AS u ON u.id = a.created_by"
	. "\nLEFT JOIN #__content_rating AS v ON a.id = v.content_id"
	. "\nWHERE a.state='1'"
	. ($access ? "\n	AND a.access <= '$my->gid'" : "")
	. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
	. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())"
	. "\nORDER BY $orderby"
	. ($count ? " LIMIT $count" : "")
	);
	//echo $database->explain();
	//echo $database->getQuery();
	$rows = $database->loadObjectList();
	echo $database->getErrorMsg();

	$n = count( $rows );
	if ($count && $count < $n) {
		$n = $count;
	}

	if ($n > 0) {
		$col=$t->col_main;

		echo "\n<table dir=rtl width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";

		$i2=0;
		$n2=$n;
		$intro2 = $intro;
		// Leading story
		if ($col==3) {
			echo "<tr>\n";
			echo "<td valign=\"top\" colspan=\"2\">\n";
			show( $rows[$i2], MASK_READON|$image, $option );
			echo "</td>\n";
			echo "</tr>\n";
			$i2++;
			$n2--;
			$intro2--;
		}

		for ($i=0; $i < $n2; $i++) {
			if (!($i%2) || $col==1) {
				echo "<tr>\n";
			}
			echo $col==1 ? "<td valign=\"top\">\n" : "<td width=\"50%\" valign=\"top\">\n";
			if ($i < $intro2 || $intro==0) {
				show( $rows[$i+$i2], MASK_READON|$image, $option );
			} else {
				HTML_content::showLinks( $rows, $intro, $n );
				echo "</td>\n</tr>\n";
				break;
			}
			echo "</td>\n";

			if ($i%2 || $col==1) {
				echo "</tr>\n";
			}
		}
		echo "\n</table>";

	} else {
		if ($empty) {
			echo "<br /><br />$empty";
		} else {
			echo "<br /><br />No items to display";
		}
	}
}

function show( $row, $mask=0, $option ) {
	global $mainframe, $my, $acl;
	global $mosConfig_live_site, $mosConfig_absolute_path;

	if ($row->id === null || $row->state != 1) {
		mosNotAuth();
		return;
	}

	$mask |= $mainframe->getCfg( 'hideAuthor' ) ? MASK_HIDEAUTHOR : 0;
	$mask |= $mainframe->getCfg( 'hideCreateDate' ) ? MASK_HIDECREATEDATE : 0;
	$mask |= $mainframe->getCfg( 'hideModifyDate' ) ? MASK_HIDEMODIFYDATE : 0;
	$mask |= $mainframe->getCfg( 'vote' ) ? MASK_VOTES : 0;

	$mask |= MASK_HIDEPDF;
	$mask |= MASK_HIDEPRINT;
	$mask |= MASK_HIDEEMAIL;
	$mask |= $mainframe->getCfg( 'link_titles' ) ? MASK_LINK_TITLES : 0;

	//do images the mosbot way
	$row->text = $row->introtext;
	$bots = mosReadDirectory( "$mosConfig_absolute_path/mambots", "\.php$" );
	sort( $bots );
	foreach ($bots as $bot) {
		require "mambots/$bot";
	}

	// record the hit
	if (!($mask&MASK_READON)) {
		$row->hit();
	}

	$access = new stdClass();
	$access->canEdit = $acl->acl_check( 'action', 'edit', 'users', $my->usertype, 'content', 'all' );
	$access->canEditOwn = $acl->acl_check( 'action', 'edit', 'users', $my->usertype, 'content', 'own' );

	HTML_content::show( $row, $mask, $access, 0, $option );
}
?>
