<?php
// $Id: content.html.php,v 1.41 2004/04/07 11:56:01 rcastley Exp $
/**
* Content code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.41 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

require_once( "includes/HTML_toolbar.php" );

// option masks
define( "MASK_BACKTOLIST", 0x0001 );
define( "MASK_READON",     0x0002 );
define( "MASK_POPUP",      0x0004 );
define( "MASK_HIDEPDF",    0x0008 );
define( "MASK_HIDEPRINT",  0x0010 );
define( "MASK_HIDEEMAIL",  0x0020 );
define( "MASK_IMAGES",     0x0040 );
define( "MASK_VOTES",      0x0080 );
define( "MASK_VOTEFORM",   0x0100 );

define( "MASK_HIDEAUTHOR",     0x0200 );
define( "MASK_HIDECREATEDATE", 0x0400 );
define( "MASK_HIDEMODIFYDATE", 0x0800 );

define( "MASK_LINK_TITLES", 0x1000 );

// mos_content.mask masks
define( 'MASK_HIDE_TITLE', 0x0001 );
define( 'MASK_HIDE_INTRO', 0x0002 );

/**
* Utility class for writing the HTML for content
*/
class HTML_content {
	function showContentList( &$title, &$categories, &$items, $access, $id=0, $sectionid=0, $gid, $pageNav="" ) {
		global $Itemid, $my;
		global $mosConfig_hideAuthor, $mosConfig_offset, $mosConfig_live_site;

		if ($sectionid!=0) {
			$id = $sectionid;
		}

		if (get_class( $title ) == 'mossection') {
			$catid = 0;
		} else {
			$catid = $title->id;
		}
?>
<table dir=rtl width="100%" cellpadding="1" cellspacing="0" border="0" align="center" class="contentpane">
  <tr>
    <td colspan="2" class="contentheading" width="100%"><?php echo $title->name; ?></td>
  </tr>
  <tr>
    <td width="60%" valign="top" class="contentdescription" colspan="2">
      <?php	if ($title->image) { ?>
      <img src="<?php echo $mosConfig_live_site;?>/images/stories/<?php echo $title->image;?>" align="<?php echo $title->image_position;?>" hspace="6" alt="<?php echo $title->image;?>" />
      <?php	}
      ?>
      <?php echo $title->description;
      ?> </td>
  </tr>
  <?php	if ($items) { ?>
  <tr>
    <td colspan="2">
	<table dir=rtl width="100%" border="0" cellspacing="0" cellpadding="1">
        <tr>
          <td colspan="4" align="left"><?php echo _PN_DISPLAY_NR."&nbsp;"; $pageNav->writeLimitBox ("index.php?option=content&amp;task=category&amp;sectionid=$sectionid&amp;id=$catid&amp;Itemid=$Itemid"); ?></td>
        </tr>
        <tr>
          <td class="sectiontableheader">&nbsp;<?php echo _DATE; ?></td>
          <td class="sectiontableheader"><?php echo _HEADER_TITLE; ?></td>
      <?php	if (!$mosConfig_hideAuthor) { ?>
          <td align="center" class="sectiontableheader"><?php echo _HEADER_AUTHOR; ?></td>
      <?php	} else { ?>
          <td align="center" class="sectiontableheader">&nbsp;</td>
      <?php	} ?>
          <td align="center" class="sectiontableheader"><?php echo _HEADER_HITS; ?></td>
        </tr>
        <?php
      foreach ($items as $row) {

      	$arrDateTime = explode(" ", $row->created);
      	$arrDate = explode("-", $arrDateTime[0]);
      	$arrTime = explode(":", $arrDateTime[1]);

		$row->created = strftime ("%m / %d", mktime ($arrTime[0],$arrTime[1],$arrTime[2],$arrDate[1],$arrDate[2],$arrDate[0]) + ($mosConfig_offset*60*60) );

	    ?>
        <tr>
          <td align="right"><?php echo $row->created; ?></td>
          <?php if($row->access <= $gid){ ?>
          <td><a href="<?php echo sefRelToAbs("index.php?option=content&amp;task=view&amp;id=".$row->id."&amp;Itemid=".$Itemid); ?>"><?php echo $row->title; ?></a>
		    <?php if ($access->canEdit || ($access->canEditOwn && $row->created_by == $my->id)){?>
			<?php if ($row->state == 0) {
				$highlight_unpublished = "("._CMN_UNPUBLISHED.")";
				} else {
				$highlight_unpublished = "";
				}
			?>
		  <?php echo $highlight_unpublished; ?><a href="<?php echo sefRelToAbs("index.php?option=content&amp;task=edit&amp;id=".$row->id."&amp;sectionid=".$sectionid."&amp;Itemid=$Itemid"); ?>" title="<?php echo _E_EDIT;?>">
            <img src="<?php echo $mosConfig_live_site;?>/images/M_images/edit.png" width="13" height="14" align="middle" border="0" alt="<?php echo _E_EDIT;?>" /></a>
		  </td>
          <?php } ?>
          <?php } else { ?>
          <td><?php echo $row->title." : "; ?><a href="<?php echo sefRelToAbs("index.php?option=com_registration&amp;task=register"); ?>"><?php echo _READ_MORE_REGISTER; ?></a></td>
          <?php } ?>
          <?php	if (!$mosConfig_hideAuthor) { ?>
          <td align="center"><?php echo $row->created_by_alias ? $row->created_by_alias : $row->author; ?></td>
          <?php	} else { ?>
          <td align="center">&nbsp;</td>
          <?php	} ?>
          <td align="center"><?php echo $row->hits ? $row->hits : '-'; ?></td>
        </tr>
        <?php		} ?>
        <tr>
          <td align="center" colspan="4" class="sectiontableheader"><?php echo $pageNav->writePagesLinks("index.php?option=content&amp;task=category&amp;sectionid=$sectionid&amp;id=$catid&amp;Itemid=$Itemid"); ?></td>
        </tr>
        <tr>
          <td colspan="4" align="left"><?php echo $pageNav->writePagesCounter(); ?></td>
        </tr>
      </table></td>
    <?php if ($access->canEdit || $access->canEditOwn) { ?>
  <tr>
    <td colspan="2"> <a href="<?php echo sefRelToAbs("index.php?option=content&amp;task=new&amp;sectionid=".$id."&amp;cid=".$row->id."&amp;Itemid=".$Itemid); ?>">
      <img src="<?php echo $mosConfig_live_site;?>/images/M_images/new.png" width="13" height="14" align="middle" border="0" alt="<?php echo _CMN_NEW;?>" />&nbsp;<?php echo _CMN_NEW;?>...</a>
    </td>
  </tr>
  <?php } ?></tr>
  <?php	} ?>
  <tr>
    <td colspan="2">&nbsp;</td>
  </tr>
  <?php
        if (count( $categories ) > 1 || (count( $categories ) < 2 && count( $items ) < 1)) {
        	foreach ($categories as $row) {
        		if ($catid == $row->id) {
			?>
  <tr>
    <td colspan="2"><img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" />&nbsp;&nbsp;<b><?php echo $row->name;?></b></td>
  </tr>
  <?php
        		} else {
			?>
  <tr>
    <td colspan="2"><img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" />&nbsp;
      <?php if ($row->access<=$gid) { ?>
    	<a href="<?php echo sefRelToAbs("index.php?option=content&amp;task=category&amp;sectionid=".$id."&amp;id=".$row->id."&amp;Itemid=".$Itemid); ?>" class="category"><?php echo $row->name;?></a>
      <i>(<?php echo $row->numitems; echo _CHECKED_IN_ITEMS;?>)</i>
      <?php } else {
      	echo $row->name;
    	?>
	<a href="<?php echo sefRelToAbs("index.php?option=com_registration&amp;task=register"); ?>">
	( <?php echo _E_REGISTERED; ?> )</a>
      <?php
    	} ?>
    </td>
  </tr>
  <?php
        		}
        	}
        }
	  ?>
</table>
<?php
	}

	function showBlogList( &$items ) {
		$maxWithIntro = 5;
		?>
<table dir=rtl border="0" cellspacing="0" cellpadding="6" class="contentpane">
  <?php
		$col_main = 1;
		$col = 0;

		for ($i=0, $n=count( $items ); $i < $n; $i++) {
			if ($col == 0) {
				echo "\n		<tr>";
			}
			if ($n < $maxWithIntro) {

			}

			$col++;
			if ($col == $col_main) {
				$col = 0;
				echo "\n		</tr>";
			}
		}
?>
</table>
<?php
	}

	/**
	* Show a content item
	* @param object An object with the record data
	* @param boolean If <code>false</code>, the print button links to a popup window.  If <code>true</code> then the print button invokes the browser print method.
	*/
	function show( $row, $mask=0, $access, $page=0, $option ) {
		global $mainframe, $my, $hide_js, $database, $acl;
		global $mosConfig_sitename, $Itemid, $mosConfig_live_site, $task, $mosConfig_vote;

		$gid = $my->gid;
		$template = $mainframe->getTemplate();

		$mod_date = null; $create_date = null;
		if (intval( $row->modified ) <> 0) {
			$mod_date = mosFormatDate( $row->modified );
		}
		if (intval( $row->created ) <> 0) {
			$create_date = mosFormatDate( $row->created );
		}

		// Find out correct Itemid for items
		// (can not just use global because of items on the frontpage)
		if ($option="content" && $task="view") {
			$database->setQuery("SELECT m.id "
			."\nFROM #__content AS i"
			."\nLEFT JOIN #__sections AS s ON i.sectionid=s.id"
			."\nLEFT JOIN #__menu AS m ON m.componentid=s.id "
			."\nWHERE m.type='content_section' AND i.id=".$row->id);
			$_Itemid = $database->loadResult();
		}

		$link_on = '';
		$link_text = '';
		if ($mask&MASK_READON) {
			if ($row->access <= $gid ) {
				$link_on = sefRelToAbs("index.php?option=content&amp;task=view&amp;id=".$row->id."&Itemid=".$_Itemid);
				if (strlen( trim( $row->fulltext ) )) {
					$link_text = _READ_MORE;
				}
			} else {
				$link_on = sefRelToAbs("index.php?option=com_registration&amp;task=register");
				if (strlen( trim( $row->fulltext ) )) {
					$link_text = _READ_MORE_REGISTER;
				}
			}
		}

?>
<?php	if ($mask&MASK_POPUP) { ?>
<title><?php echo "$mosConfig_sitename :: $row->title"; ?></title>
<link rel="stylesheet" href="<?php echo "$mosConfig_live_site/templates/$template/css/template_css.css";?>" type="text/css" />
<?php	} ?>
<table dir=rtl cellpadding="0" cellspacing="1" border="0" width="100%" class="contentpaneopen">
  <tr>
    <?php $colcount=0; ?>
    <td class="contentheading" width="100%">
	<?php if (!($row->mask&MASK_HIDE_TITLE)) { ?>
		<?php if ($mask&MASK_LINK_TITLES && $link_on!="") { ?>
		<a href="<?php echo $link_on;?>" class="contentpagetitle"><?php echo $row->title;?></a>
		<?php } else {
			echo $row->title;
		}?>
	  <?php } ?>
      <?php if (($access->canEdit) || ($access->canEditOwn && $row->created_by == $my->id) && !($mask&MASK_POPUP)) { ?>
		<a href="<?php echo sefRelToAbs("index.php?option=content&amp;task=edit&amp;id=$row->id&Itemid=$_Itemid&Returnid=$Itemid"); ?>" title="<?php echo _E_EDIT;?>">
      <img src="<?php echo $mosConfig_live_site;?>/images/M_images/edit.png" width="13" height="14" align="middle" border=0 alt="<?php echo _E_EDIT;?>" />
      </a>

	<?php } ?>&nbsp;
	</td>
    <?php if (!($mask&MASK_HIDEPDF) && !$hide_js && !($mask&MASK_POPUP)) { ?>
    <td align="left"><a href="javascript:void window.open('<?php echo $mosConfig_live_site; ?>/index2.php?option=content&amp;do_pdf=1&amp;id=<?php echo $row->id; ?>', 'win2', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no');" title="<?php echo _CMN_PDF;?>"><img
    src="<?php echo $mosConfig_live_site;?>/images/M_images/pdf_button.png" border="0" alt="<?php echo _CMN_PDF;?>" /></a>&nbsp;</td>
    <?php } ?>
	<?php if (!($mask&MASK_HIDEPRINT) && !$hide_js && !($mask&MASK_POPUP)) { ?>
    <td align="left"><a href="javascript:void window.open('<?php echo $mosConfig_live_site; ?>/index2.php?option=content&amp;task=view&amp;id=<?php echo $row->id; ?>&amp;pop=1&amp;page=<?php echo $page;?>', 'win2', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no');" title="<?php echo _CMN_PRINT;?>"><img
    src="<?php echo $mosConfig_live_site;?>/images/M_images/printButton.png" border="0" alt="<?php echo _CMN_PRINT;?>" /></a>&nbsp;</td>
    <?php	} ?>
	<?php if (!($mask&MASK_HIDEPRINT) && !$hide_js && $mask&MASK_POPUP) { ?>
    <td align="left"><a href="#" onclick="javascript:window.print(); return false" title="<?php echo _CMN_PRINT;?>"><img
    src="<?php echo $mosConfig_live_site;?>/images/M_images/printButton.png" border="0" alt="<?php echo _CMN_PRINT;?>" /></a>&nbsp;</td>
    <?php	} ?>
    <?php if (!($mask&MASK_HIDEEMAIL) && !$hide_js && !($mask&MASK_POPUP)) { ?>
    <td align="left"><a href="javascript:void window.open('<?php echo $mosConfig_live_site; ?>/index2.php?option=content&amp;task=emailform&amp;id=<?php echo $row->id; ?>', 'win2', 'status=no,toolbar=no,scrollbars=no,titlebar=no,menubar=no,resizable=yes,width=400,height=200,directories=no,location=no');" title="<?php echo _CMN_EMAIL;?>"><img
    src="<?php echo $mosConfig_live_site;?>/images/M_images/emailButton.png" border='0' alt="<?php echo _CMN_EMAIL; ?>" />&nbsp;</a></td>
    <?php	} ?>
  </tr>

</table>
<table dir=rtl cellpadding="0" cellspacing="1" border="0" width="100%" class="contentpaneopen">
  <tr>
    <td width="70%" align="right" valign="top">
      <?php	if (!($mask&MASK_HIDEAUTHOR)) {
if ($row->author != "" && !($mask&MASK_HIDEAUTHOR)) {
	$grp = $acl->getAroGroup( $row->created_by );
	$is_frontend_user = $acl->is_group_child_of( intval( $grp->group_id ), 'Public Frontend', 'ARO' );
	$by = $is_frontend_user ? _AUTHOR_BY : _WRITTEN_BY;
?>
		<span class="small"><?php echo $by. " ".($row->created_by_alias ? $row->created_by_alias : $row->author);?></span>&nbsp;&nbsp;
<?php
}
  }
	if ($mask&MASK_VOTES && !($mask&MASK_POPUP)){
		HTML_content::vote_rating( $row );
	}
	 ?>
	</td>
    <td valign="top" align="left">
	<?php echo @$row->toc ? $row->toc : ""; ?>
    </td>
  </tr>

  <tr>
	<td valign="top" colspan="2">

	  <?php
	if (($mask&MASK_VOTEFORM) && !($mask&MASK_POPUP) && $task != "blogsection") {
		HTML_content::vote_form( $row->id, $option );
		}
	?>
  </td>
  </tr>
  <tr>
    <td valign="top" colspan="2">
	  <?php
	if ($task=="view") {
	// Custom code here
	}
	if (!($mask&MASK_HIDECREATEDATE)) {
		echo "<span class=\"createdate\">".$create_date."</span><br>\n".$row->text;
	} else {
		echo $row->text;
	}
	?>
	</td>
  </tr>
  <?php	if ($mod_date <> '' && !($mask&MASK_HIDEMODIFYDATE)) { ?>
  <tr>
    <td class="modifydate" colspan="2" align="right"><?php echo _LAST_UPDATED;?> (
      <?php echo $mod_date; ?>
      )</td>
  </tr>
  <?php	} ?>
  <?php	if ( $mask&MASK_POPUP && !$hide_js) { ?>
  <tr>
    <td <?php if ($colcount>1) { echo "colspan=\"$colcount\"";} ?> align="center"> <a href='javascript:window.close();'><span class="small"><?php echo _PROMPT_CLOSE;?></span></a></td>
  </tr>
  <?php	} ?>
  <?php	if ($mask&MASK_READON && $link_text) { ?>
  <tr>
    <td <?php if ($colcount>1) { echo "colspan=\"$colcount\"";} ?> align="right">
      <a href="<?php echo $link_on;?>" class="readon"><?php echo $link_text;?></a>
    </td>
  </tr>
  <?php	} ?>
</table>
<br />
<?php
	}

	/**
	* Display the 'stars' vote rating
	*/
	function vote_rating( $row ) {
		global $mosConfig_live_site;
		$img = '';
		for ($i=0; $i < $row->rating; $i++) {
			$img .= "<img src=\"$mosConfig_live_site/images/M_images/rating_star.png\" width=\"11\" height=\"10\" border=\"0\" alt=\"star\" valign=\"middle\" />";
		}
		for ($i=$row->rating; $i < 5; $i++) {
			$img .= "<img src=\"$mosConfig_live_site/images/M_images/rating_star_blank.png\" width=\"11\" height=\"10\" border=\"0\" alt=\"star\" valign=\"middle\" />";
		}
?>
	<span class="content_rating">
	<?php echo _USER_RATING;?>:<?php echo $img;?>&nbsp;/&nbsp;<?php echo $row->rating_count ? $row->rating_count : "0";?>
	</span>
<?php
	}
	/**
	* Display the form form for a content item
	*/
	function vote_form( $id, $option ) {
		global $Itemid;
		?>

<form method="post" action="<?php echo sefRelToAbs("index.php"); ?>">

  <tr>
    <td colspan="4">
		<span class="content_vote">
		<?php echo _VOTE_POOR;?>
      <input type="radio" name="user_rating" value="1" />
      <input type="radio" name="user_rating" value="2"/>
      <input type="radio" name="user_rating" value="3"/>
      <input type="radio" name="user_rating" value="4"/>
      <input type="radio" name="user_rating" value="5" checked />
		<?php echo _VOTE_BEST;?>
      <input class="button" type="submit" name="submit_vote" value="<?php echo _RATE_BUTTON;?>" />
      <input type="hidden" name="task" value="vote" />
      <input type="hidden" name="pop" value="0" />
      <input type="hidden" name="option" value="content" />
      <input type="hidden" name="Itemid" value="<?php echo $Itemid; ?>" />
      <input type="hidden" name="cid" value="<?php echo $id; ?>" />
      <input type="hidden" name="url" value="<?php echo $_SERVER['REQUEST_URI']; ?>" />
		</span>
		</td>
  </tr>

</form>
<?php
	}

	function showLinks( &$rows, $limitstart, $limit ) {
		global $database;
		$n = min( count( $rows ), $limit );
		?>
<table dir=rtl cellpadding="0" cellspacing="5" border="0" width="100%" class="contentpaneopen">
  <tr>
    <td> <strong><?php echo _MORE; ?></strong> </td>
  </tr>
  <?php for ($i=$limitstart; $i < $n; $i++) {
	// Find out correct Itemid for items
	// (can not just use global because of items on the frontpage)
	$database->setQuery("SELECT m.id "
	."\nFROM #__content AS i"
	."\nLEFT JOIN #__sections AS s ON i.sectionid=s.id"
	."\nLEFT JOIN #__menu AS m ON m.componentid=s.id "
	."\nWHERE m.type='content_section' AND i.id=".$rows[$i]->id);
	$_Itemid = $database->loadResult();
?>
  <tr>
    <td> <a class="blogsection" href="<?php echo sefRelToAbs("index.php?option=content&amp;task=view&amp;id=".$rows[$i]->id."&Itemid=".$_Itemid); ?>">
      <?php echo $rows[$i]->title;?></a></td>
  </tr>
  <?php
  }
?>
</table>
<?php
	}

	/**
	* Writes the edit form for new and existing content item
	*
	* A new record is defined when <var>$row</var> is passed witht the <var>id</var>
	* property set to 0.
	* @param mosContent The category object
	* @param string The html for the groups select list
	*/
	function editContent( &$row, $section, &$lists, &$images, &$access, $myid, $sectionid, $task, $Itemid ) {
		mosMakeHtmlSafe( $row );
		$Returnid = intval( mosGetParam( $_REQUEST, 'Returnid', $Itemid ) );
?>
<link rel="stylesheet" type="text/css" media="all" href="includes/js/calendar/calendar-mos.css" title="green" />
<!-- import the calendar script -->
<script type="text/javascript" src="includes/js/calendar/calendar.js"></script>
<!-- import the language module -->
<script type="text/javascript" src="includes/js/calendar/lang/calendar-en.js"></script>
<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
<script language="Javascript" src="includes/js/overlib_mini.js"></script>
<script language="javascript" src="includes/js/dhtml.js"></script>
<?php
$docinfo = "<strong>"._E_SUBJECT."</strong> ";
$docinfo .= $row->title."<br />";
$docinfo .= "<strong>"._E_EXPIRES."</strong> ";
$docinfo .= $row->publish_down."<br />";
$docinfo .= "<strong>"._E_VERSION."</strong> ";
$docinfo .= $row->version."<br />";
$docinfo .= "<strong>"._E_CREATED."</strong> ";
$docinfo .= $row->created."<br />";
$docinfo .= "<strong>"._E_LAST_MOD."</strong> ";
$docinfo .= $row->modified."<br />";
$docinfo .= "<strong>"._E_HITS."</strong> ";
$docinfo .= $row->hits."<br />";
      ?>
<table dir=rtl cellspacing="0" cellpadding="0" border="0" width="100%">
  <tr>
    <td class="contentheading" ><?php echo $section;?> / <?php echo $row->id ? _E_EDIT : _E_ADD;?>&nbsp;
<?php echo _E_CONTENT;?> &nbsp;&nbsp;&nbsp;<a href="javascript: void(0);" onMouseOver="return overlib('<table dir=rtl border=0 width=250 height=100%><?php echo $docinfo; ?></table>', CAPTION, '<?php echo _E_ITEM_INFO;?>', BELOW, RIGHT);" onMouseOut="return nd();">
      <strong>[]</strong></a></td>
    <td width="50%">
      <?php
      mosToolBar::startTable();
      mosToolBar::spacer();
      mosToolBar::save();
      mosToolBar::spacer(25);
      mosToolBar::cancel();
      mosToolBar::endtable();
?>
    </td>
  </tr>
</table>
<table dir=rtl cellspacing="0" cellpadding="4" border="0" width="100%">
  <tr>
    <td id="tab1" class="offtab" onClick="dhtml.cycleTab(this.id)"><?php echo _E_CONTENT; ?></td>
    <td id="tab2" class="offtab" onClick="dhtml.cycleTab(this.id)"><?php echo _E_IMAGES; ?></td>
    <td id="tab3" class="offtab" onClick="dhtml.cycleTab(this.id)"><?php echo _E_PUBLISHING; ?></td>
    <td id="tab4" class="offtab" onClick="dhtml.cycleTab(this.id)"><?php echo _E_METADATA; ?></td>
    <td width="90%" class="tabpadding">&nbsp;</td>
  </tr>
</table><body onUnload="WarnUser()">
<script language="javascript" type="text/javascript">
	var folderimages = new Array;
<?php	$i = 0;
foreach ($images as $k=>$items) {
	foreach ($items as $v) {
		echo "\n	folderimages[".$i++."] = new Array( '$k','$v->value','$v->text' );";
	}
}
?>
	function submitbutton(pressbutton) {
		var form = document.adminForm;
		if (pressbutton == 'cancel') {
			submitform( pressbutton );
			return;
		}

      		//var goodexit=false;
			// assemble the images back into one field
			document.adminForm.goodexit.value=1
			var temp = new Array;
			for (var i=0, n=document.adminForm.imagelist.options.length; i < n; i++) {
				temp[i] = document.adminForm.imagelist.options[i].value;
			}
			document.adminForm.images.value = temp.join( '\n' );
			try {
			document.adminForm.onsubmit();
			}
			catch(e){}
		// do field validation
			if (form.title.value == "") {
				alert ( "<?php echo _E_WARNTITLE; ?>" );
			} else if (parseInt('<?php echo $row->sectionid;?>')) {
				if (getSelectedValue('adminForm','catid') < 1) {
					alert ( "<?php echo _E_WARNCAT; ?>" );
				} else {
					<?php getEditorContents( 'editor1', 'introtext' ) ; ?>
					<?php getEditorContents( 'editor2', 'fulltext' ) ; ?>
					submitform(pressbutton);
				}
			} else if (form.introtext.value == "") {
                        	alert ( "<?php echo _E_WARNTEXT; ?>" );
			} else {
				<?php getEditorContents( 'editor1', 'introtext' ) ; ?>
				<?php getEditorContents( 'editor2', 'fulltext' ) ; ?>
				submitform(pressbutton);
			}
	}

	function setgood(){
	  document.adminForm.goodexit.value=1;
	}

	function WarnUser(){
    if (document.adminForm.goodexit.value==0) {
         alert('<?php echo _E_WARNUSER;?>');
				 window.location="<?php echo sefRelToAbs("index.php?option=content&task=".$task."&sectionid=".$sectionid."&id=".$row->id."&Itemid=".$Itemid); ?>"
		}
	}


</script>
<form action="index.php" method="POST" name="adminForm" onSubmit="javascript:setgood();">
  <input type="hidden" name="images" value="" />
  <div id="page1" class="pagetext">
    <table dir=rtl cellpadding="3" cellspacing="0" border="0" width="100%" class="adminform">
      <tr>
        <td><?php echo _E_TITLE; ?></td>
      </tr>
      <tr>
        <td> <input class="inputbox" type="text" name="title" size="50" maxlength="100" value="<?php echo $row->title; ?>" />
      </td>
      </tr>
      <?php if ($row->sectionid) { ?>
      <tr>
        <td><?php echo _E_CATEGORY; ?></td>
      </tr>
      <tr>
        <td> <?php echo $lists['catid']; ?> </td>
      </tr>
      <?php } ?>
      <tr>
<?php	if (intval( $row->sectionid ) > 0) { ?>
        <td><?php echo _E_INTRO.' ('._CMN_REQUIRED.')'; ?>:</td>
<?php	} else { ?>
        <td><?php echo _E_MAIN.' ('._CMN_REQUIRED.')'; ?>:</td>
<?php	} ?>
      </tr>
      <tr>
        <td>
			<?php
			// parameters : areaname, content, hidden field, width, height, rows, cols
			editorArea( 'editor1',  $row->introtext , 'introtext', '500', '200', '45', '5' ) ; ?>
      </td>
      </tr>
<?php	if (intval( $row->sectionid ) > 0) { ?>
	  <tr>
        <td><?php echo _E_MAIN.' ('._CMN_OPTIONAL.')'; ?>:</td>
      </tr>
      <tr>
        <td>
	 		<?php
			if (intval( $row->sectionid ) > 0) {
				// parameters : areaname, content, hidden field, width, height, rows, cols
				editorArea( 'editor2',  $row->fulltext , 'fulltext', '500', '400', '45', '10' ) ;
				}
			?>
      </td>
      </tr>
<?php	} ?>
    </table>
  </div>
  <div id="page2" class="pagetext">
    <table dir=rtl cellpadding="3" cellspacing="0" border="0" width="100%" class="adminform">
    	<tr>
				<td colspan="6"><?php echo _CMN_SUBFOLDER; ?> :: <?php echo $lists['folders'];?></td>
		</tr>
      <tr>
        <td align="top"><?php echo _E_GALLERY_IMAGES; ?></td>
        <td align="top"><?php echo _E_CONTENT_IMAGES; ?></td>
        <td align="top"><?php echo _E_EDIT_IMAGE; ?></td>
      <tr>
        <td valign="top"><?php echo $lists['imagefiles'];?> <br /> <input class="button" type="button" value="<?php echo _E_INSERT; ?>" onClick="addSelectedToList('adminForm','imagefiles','imagelist')" />
      </td>
        <td valign="top"><?php echo $lists['imagelist'];?> <br />
        <input class="button" type="button" value="<?php echo _E_UP; ?>" onClick="moveInList('adminForm','imagelist',adminForm.imagelist.selectedIndex,-1)" />
        <input class="button" type="button" value="<?php echo _E_DOWN; ?>" onClick="moveInList('adminForm','imagelist',adminForm.imagelist.selectedIndex,+1)" />
        <input class="button" type="button" value="<?php echo _E_REMOVE; ?>" onClick="delSelectedFromList('adminForm','imagelist')" />
      </td>
        <td valign="top"> <table dir=rtl>
            <tr>
              <td align="left"><?php echo _E_SOURCE; ?></td>
              <td> <input class="inputbox" type="text" name= "_source" value="" size="15" />
            </td>
            </tr>
            <tr>
              <td align="left" valign="top"><?php echo _E_ALIGN; ?></td>
              <td> <?php echo $lists['_align']; ?> </td>
            </tr>
            <tr>
              <td align="left"><?php echo _E_ALT; ?></td>
              <td><input class="inputbox" type="text" name="_alt" value="" size="15" /></td>
            </tr>
            <tr>
              <td align="left"><?php echo _E_BORDER; ?></td>
              <td> <input class="inputbox" type="text" name="_border" value="" size="3" maxlength="1" /></td>
            </tr>
            <tr>
              <td align="left"></td>
              <td> <input class="button" type="button" value="<?php echo _E_APPLY; ?>" onClick="applyImageProps()" /></td>
            </tr>
        </table></td>
      </tr>
      <tr>
        <td> <img name="view_imagefiles" src="images/M_images/blank.png" width="50" alt="No Image" /></td>
        <td> <img name="view_imagelist" src="images/M_images/blank.png" width="50" alt="No Image" /></td>
      </tr>
    </table>
  </div>
  <div id="page3" class="pagetext">
    <table dir=rtl cellpadding="3" cellspacing="0" border="0" width="100%" class="adminform">
      <?php if ($access->canPublish) { ?>
      <tr>
        <td align="right"><?php echo _E_STATE; ?></td>
        <td><?php echo $lists['state']; ?></td>
      </tr>
      <?php } ?>
      <tr>
        <td align="right"><?php echo _E_ACCESS_LEVEL; ?></td>
        <td><?php echo $lists['access']; ?></td>
      </tr>
      <tr>
        <td align="right"><?php echo _E_AUTHOR_ALIAS; ?></td>
        <td><input type="text" name="created_by_alias" size="50" maxlength="100" value="<?php echo $row->created_by_alias; ?>" class="inputbox" /></td>
      </tr>
      <tr>
        <td align="right"><?php echo _E_ORDERING; ?></td>
        <td><?php echo $lists['ordering']; ?> </td>
      </tr>
      <tr>
        <td align="right"><?php echo _E_START_PUB; ?></td>
        <td><input class="inputbox" type="text" name="publish_up" id="publish_up" size="25" maxlength="19" value="<?php echo $row->publish_up; ?>" />
        <input type="reset" class="button" value="..." onClick="return showCalendar('publish_up', 'y-mm-dd');" /></td>
      </tr>
      <tr>
        <td align="right"><?php echo _E_FINISH_PUB; ?></td>
        <td><input class="inputbox" type="text" name="publish_down" id="publish_down" size="25" maxlength="19" value="<?php echo $row->publish_down; ?>" />
        <input type="reset" class="button" value="..." onClick="return showCalendar('publish_down', 'y-mm-dd');" /></td>
      </tr>
      <tr>
        <td align="right"><?php echo _E_SHOW_FP; ?></td>
        <td><input type="checkbox" name="frontpage" value="1" <?php echo $row->frontpage ? 'checked="checked"' : ''; ?> /></td>
      </tr>
      <tr>
        <td align="right"><?php echo _E_HIDE_TITLE; ?></td>
        <td><input type="checkbox" name="mask_hide_title" value="<?php echo MASK_HIDE_TITLE;?>" <?php echo $row->mask&MASK_HIDE_TITLE ? 'checked="checked"' : ''; ?> /></td>
      </tr>
    </table>
  </div>
  <div id="page4" class="pagetext">
    <table dir=rtl cellpadding="3" cellspacing="0" border="0" width="100%" class="adminform">
      <tr>
        <td align="right" valign="top"><?php echo _E_M_DESC; ?></td>
        <td><textarea class="inputbox" cols="45" rows="3" name="metadesc"><?php echo str_replace('&','&amp;',$row->metadesc); ?></textarea></td>
      </tr>
      <tr>
        <td align="right" valign="top"><?php echo _E_M_KEY; ?></td>
        <td><textarea class="inputbox" cols="45" rows="3" name="metakey"><?php echo str_replace('&','&amp;',$row->metakey); ?></textarea></td>
      </tr>
    </table>
  </div>
  <input type="hidden" name="goodexit" value=0>
  <input type="hidden" name="option" value="content" />
  <input type="hidden" name="Returnid" value="<?php echo $Returnid; ?>" />
  <input type="hidden" name="id" value="<?php echo $row->id; ?>" />
  <input type="hidden" name="version" value="<?php echo $row->version; ?>" />
  <input type="hidden" name="sectionid" value="<?php echo $row->sectionid; ?>" />
  <input type="hidden" name="created_by" value="<?php echo $row->created_by; ?>" />
  <input type="hidden" name="task" value="" />
</form>
<script language="javascript" type="text/javascript">
	dhtml.cycleTab('tab1');
</script>
<?php
	}

	function emailForm( $uid, $title, $template='' ) {
		global $mosConfig_sitename;
?>
<script language="javascript" type="text/javascript">
	function submitbutton() {
		var form = document.frontendForm;

		// do field validation
		if (form.email.value == "" || form.youremail.value == "") {
			alert( '<?php echo addslashes( _EMAIL_ERR_NOINFO ); ?>' );
			return false;
		}
		return true;
	}
	</script>
<title><?php echo $mosConfig_sitename; ?> :: <?php echo $title; ?></title>
<link rel="stylesheet" href="templates/<?php echo $template; ?>/css/template_css.css" type="text/css" />
<body class="contentpane">
<form action="index2.php?option=content&task=emailsend" name="frontendForm" method="POST" onSubmit="return submitbutton();">
  <table dir=rtl cellspacing="2" cellpadding="2" border="0">
    <tr>
      <td colspan="2"><?php echo _EMAIL_FRIEND; ?></td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td width="130"><?php echo _EMAIL_FRIEND_ADDR; ?></td>
      <td><input type="text" name="email" class="inputbox" size="25"></td>
    </tr>
    <tr>
      <td height="27"><?php echo _EMAIL_YOUR_NAME; ?></td>
      <td><input type="text" name="yourname" class="inputbox" size="25"></td>
    </tr>
    <tr>
      <td><?php echo _EMAIL_YOUR_MAIL; ?></td>
      <td><input type="text" name="youremail" class="inputbox" size="25"></td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2"><input type="submit" name="submit" class="button" value="<?php echo _BUTTON_SUBMIT_MAIL; ?>">
        &nbsp;&nbsp; <input type="button" name="cancel" value="<?php echo _BUTTON_CANCEL; ?>" class="button" onClick="window.close();"></td>
    </tr>
  </table>
  <input type="hidden" name="id" value="<?php echo $uid; ?>">
</form>
<?php
	}

	function emailSent( $to, $template='' ) {
		global $mosConfig_sitename;
?>
<title><?php echo $mosConfig_sitename; ?></title>
<link rel="stylesheet" href="templates/<?php echo $template; ?>/css/template_css.css" type="text/css" />
<body class="contentpane">
<span class="contentheading"><?php echo _EMAIL_SENT." $to";?></span> <br />
<br />
<br />

<?php if (!$hide_js) { php?>
 <a href='javascript:window.close();'>
		<span class="small"><?php echo _PROMPT_CLOSE;?></span>
 </a>
<?php
}
	}

}
?>
