<?php
// $Id: banners.class.php,v 1.6 2003/12/08 18:16:05 rcastley Exp $
/**
* Content code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.6 $
**/

defined( '_VALID_MOS' ) or die( '      ' );

//
// Classes and helper functions to the banner system
//
class mosBannerClient extends mosDBTable {
	var	$cid = null;
	var $name = "";
	var $contact = "";
	var $email = "";
	var $extrainfo = "";
	var $checked_out = 0;
	var $checked_out_time = 0;
	var $editor	= "";

	function mosBannerClient( &$_db ) {
		$this->mosDBTable( '#__bannerclient', 'cid', $_db );
	}

	function check() {
		// check for valid client name
		if (trim($this->name == "")) {
			$this->_error = "   ";
			return false;
		}

		// check for valid client contact
		if (trim($this->contact == "")) {
			$this->_error = "    ";
			return false;
		}

		// check for valid client email
		if ((trim($this->email == "")) || (preg_match("/[\w\.\-]+@\w+[\w\.\-]*?\.\w{1,4}/", $this->email )==false)) {
			$this->_error = "  ";
			return false;
		}
		return true;
	}
}

class mosBanner extends mosDBTable {
	var $bid				= null;	// int(11) NOT NULL auto_increment,
	var $cid				= null;	// int(11) NOT NULL default '0',
	var $type				= "";	// varchar(10) NOT NULL default 'banner',
	var $name				= "";	// varchar(50) NOT NULL default '',
	var $imptotal			= 0;	// int(11) NOT NULL default '0',
	var $impmade			= 0;	// int(11) NOT NULL default '0',
	var $clicks				= 0;	// int(11) NOT NULL default '0',
	var $imageurl			= "";	// varchar(100) NOT NULL default '',
	var $clickurl			= "";	//  varchar(200) NOT NULL default '',
	var $date				= null;	// datetime default NULL,
	var $showBanner			= 0;	// tinyint(1) NOT NULL default '0',
	var $checked_out		= 0;	// tinyint(1) NOT NULL default '0',
	var $checked_out_time	= 0;	// time default NULL,
	var $editor				= "";	// varchar(50) default NULL,
	var $custombannercode	= "";	// text,

	function mosBanner( &$_db ) {
		$this->mosDBTable( '#__banner', 'bid', $_db );
		$this->set("date",date("Y-m-d G:i:s"));
	}

	function clicks() {
		$this->_db->setQuery( "UPDATE #__banner SET clicks=(clicks+1) WHERE bid=$this->bid" );
		$this->_db->query();
	}

	function check() {
		// check for valid client id
		if (is_null($this->cid) || $this->cid == 0) {
			$this->_error = "  ";
			return false;
		}

		if(trim($this->name) == "") {
			$this->_error = "   ";
			return false;
		}

		if(trim($this->imageurl) == "") {
			$this->_error = "   ";
			return false;
		}
		if(trim($this->clickurl) == "" && trim($this->custombannercode) == "") {
			$this->_error = "        ";
			return false;
		}

		return true;
	}
}
?>