<?php
// $Id: template_installer.php,v 1.11 2004/01/13 02:18:28 eddieajau Exp $
/**
* Template installer event handler
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.11 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

require_once($mosConfig_absolute_path . "/administrator/classes/html/HTML_installer.php");
require_once($mosConfig_absolute_path . "/administrator/includes/installer_common.php");

$task = mosGetParam( $_REQUEST, "task", "" );

// Check if file uploads are enabled
if(!(bool)ini_get('file_uploads')){
	HTML_installer::showInstallMessage("The installer can't continue before file uploads are enabled. Please use the install from directory method.",'Installer - Error',$option);
	exit();
}

switch($task)
{
	case "uploadfile":
	// Check that the zlib is available
	if(!extension_loaded('zlib'))
	{
		HTML_installer::showInstallMessage("       zlib",'  ',$option);
		exit();
	}
	if(!isset($userfile) || $userfile == "")
	{
		HTML_installer::showInstallMessage("  ",'   ',$option);
		exit();
	}
	$resultdir = uploadFile($userfile,$userfile_name,$option);
	if(! $resultdir === false)
	{
		$installer = new mosInstallerTemplate($userfile_name);
		if(!$installer->install())
		{
			HTML_installer::showInstallMessage($installer->getError(),'   ', $option);
			cleanupInstall($userfile_name,$installer->unpackDir());
			exit();
		}
		cleanupInstall($userfile_name,$installer->unpackDir());
	} else {
		HTML_installer::showInstallMessage("     ",'    ',$option);
		exit();
	}

	mosRedirect("index2.php?option=com_templates");
	break;

	case "remove":
	if(is_array($cid) && count($cid) >1) {
		foreach($cid as $delid) {
			unInstallTemplate($delid,$option);
		}
	} else if (is_array($cid)) {
		$delid = $cid[0];
		unInstallTemplate($delid,$option);
	} else {
		unInstallTemplate($cid,$option);
	}
	mosRedirect("index2.php?option=com_templates");
	break;

	default:
	//showInstalledTemplates($option);
	HTML_installer::showInstallForm('  ',$option,dirname(__FILE__));
	break;
}

function unInstallTemplate($tname,$option) {
	global $database,$mosConfig_absolute_path;

	// Delete directories
	// mosDebugVar($com_admin_dirname);
	deldir($mosConfig_absolute_path . "/templates/" . $tname);
}

function showInstalledTemplates($option)
{
	global $database;

	$database->setQuery( "SELECT * FROM #__templates ORDER BY cur_template" );
	$database->query();
	$rows = $database->loadObjectList();
	HTML_installer::showInstalledTemplates($rows, $option);
}
?>