<?php
// $Id: module_installer.php,v 1.18 2004/01/13 02:18:28 eddieajau Exp $
/**
* Module installer event handler
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.18 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

require_once($mosConfig_absolute_path . "/administrator/classes/html/HTML_installer.php");
require_once($mosConfig_absolute_path . "/administrator/includes/installer_common.php");
// Extract functions
require_once($mosConfig_absolute_path . "/administrator/classes/pclzip.lib.php");
require_once($mosConfig_absolute_path . "/administrator/classes/pclerror.lib.php");
require_once($mosConfig_absolute_path . "/administrator/classes/pcltrace.lib.php");
require_once($mosConfig_absolute_path . "/administrator/classes/pcltar.lib.php");

$task		= mosGetParam( $_REQUEST, "task", "" );

// Check if file uploads are enabled
if(!(bool)ini_get('file_uploads')){
	HTML_installer::showInstallMessage("            ",'  ',$option);
	exit();
}


switch($task)
{
	case "uploadfile":
	// Check that the zlib is available
	if(!extension_loaded('zlib'))
	{
		HTML_installer::showInstallMessage("       Zlib  ",'  ',$option);
		exit();
	}
	if(!isset($userfile) || $userfile == "")
	{
		HTML_installer::showInstallMessage('  ','  ',$option);
		exit();
	}
	$resultdir = uploadFile($userfile,$userfile_name,$option, $msg);
	if(! $resultdir === false)
	{
		$installer = new mosInstallerModule($userfile_name);
		if(!$installer->install())
		{
			HTML_installer::showInstallMessage($installer->getError(),'  ', $option);
			cleanupInstall($userfile_name,$installer->unpackDir());
			exit();
		}
		cleanupInstall($userfile_name,$installer->unpackDir());
	} else {
		HTML_installer::showInstallMessage("      ",'  ',$option);
		exit();
	}
	mosRedirect("index2.php?option=$option");
	break;

	case "remove":
	if(is_array($cid) && count($cid) >1)
	{
		foreach($cid as $delid)
		{
			unInstallModule($delid,$option);
		}
	}
	else
	{
		$delid = $cid[0];
		unInstallModule($delid,$option);
	}

	mosRedirect("index2.php?option=$option");
	break;

	default:
	showInstalledModules($option);
	HTML_installer::showInstallForm('  ',$option,dirname(__FILE__));
	break;
}

function showInstalledModules($_option)
{
	global $database;

	$database->setQuery( "SELECT * FROM #__modules WHERE module LIKE 'mod_%' ORDER BY module" );
	$res = $database->query();
	$rows = $database->loadObjectList();
	HTML_installer::showInstalledModules($rows, $_option);

}

function uninstallModule($id,$option)
{
	global $database,$mosConfig_absolute_path;
	$database->setQuery( "select * FROM #__modules WHERE id = '$id'" );
	$database->query();
	$database->loadObject($row);

	if($row->iscore)
	{
		HTML_installer::showInstallMessage("$row->name       <br>    ",'  ', $option);
		exit();
	}

	$database->setQuery( "DELETE FROM #__modules WHERE id = '$id'" );
	$database->query();
	$database->setQuery( "DELETE FROM #__modules_menu WHERE moduleid = '$id'" );
	$database->query();

	// delete the module file
	unlink($mosConfig_absolute_path . "/modules/" . $row->module . ".php");
}

?>
