<?php
// $Id: pageNavigation.php,v 1.11 2003/09/26 13:10:10 eddieajau Exp $
/**
* Page navigation
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.11 $
**/

defined( '_VALID_MOS' ) or die( '      ' );

/**
* Page navigation support class
*/
class mosPageNav {
/** @var int The record number to start dislpaying from */
	var $limitstart = null;
/** @var int Number of rows to display per page */
	var $limit = null;
/** @var int Total number of rows */
	var $total = null;

	function mosPageNav( $total, $limitstart, $limit ) {
		$this->total = intval( $total );
		$this->limitstart = max( $limitstart, 0 );
		$this->limit = max( $limit, 1 );
		if ($this->limit > $this->total) {
			$this->limitstart = 0;
		}
		if (($this->limit-1)*$this->limitstart > $this->total) {
			$this->limitstart -= $this->limitstart % $this->limit;
		}
	}

/**
* Writes the html limit # input box
*/
	function writeLimitBox () {
		$limits = array();
		for ($i=5; $i <= 30; $i+=5) {
			$limits[] = mosHTML::makeOption( "$i" );
		}
		$limits[] = mosHTML::makeOption( "50" );

	// build the html select list
		echo mosHTML::selectList( $limits, 'limit', 'class="inputbox" size="1" onchange="document.adminForm.submit();"',
			'value', 'text', $this->limit );
		echo "\n<input type=\"hidden\" name=\"limitstart\" value=\"$this->limitstart\" />";
	}

/**
* Writes the html for the pages counter, eg, Results 1-10 of x
*/
	function writePagesCounter() {
		$from_result = $this->limitstart+1;
		if ($this->limitstart + $this->limit < $this->total) {
			$to_result = $this->limitstart + $this->limit;
		} else {
			$to_result = $this->total;
		}
		if ($this->total > 0) {
			echo "\n " . $from_result . " - " . $to_result . "  " . $this->total;
		} else {
			echo "\n   ";
		}
	}

/**
* Writes the html links for pages, eg, previous, next, 1 2 3 ... x
*/
	function writePagesLinks() {
		$displayed_pages = 10;
		$total_pages = ceil( $this->total / $this->limit );
		$this_page = ceil( ($this->limitstart+1) / $this->limit );
		$start_loop = (floor(($this_page-1)/$displayed_pages))*$displayed_pages+1;
		if ($start_loop + $displayed_pages - 1 < $total_pages) {
			$stop_loop = $start_loop + $displayed_pages - 1;
		} else {
			$stop_loop = $total_pages;
		}

		if ($this_page > 1) {
			$page = ($this_page - 2) * $this->limit;
			echo "\n<a href=\"#beg\" class=\"pagenav\" title=\" \" onclick=\"javascript: document.adminForm.limitstart.value=0; document.adminForm.submit();\"><<  </a>";
			echo "\n<a href=\"#prev\" class=\"pagenav\" title=\" \" onclick=\"javascript: document.adminForm.limitstart.value=$page; document.adminForm.submit();\"><  </a>";
		} else {
			echo "\n<span class=\"pagenav\"><<  </span>";
			echo "\n<span class=\"pagenav\"><  </span>";
		}

		for ($i=$start_loop; $i <= $stop_loop; $i++) {
			$page = ($i - 1) * $this->limit;
			if ($i == $this_page) {
				echo "\n<span class=\"pagenav\"> $i </span>";
			} else {
				echo "\n<a href=\"#$i\" class=\"pagenav\" onclick=\"javascript: document.adminForm.limitstart.value=$page; document.adminForm.submit();\"><strong>$i</strong></a>";
			}
		}

		if ($this_page < $total_pages) {
			$page = $this_page * $this->limit;
			$end_page = ($total_pages-1) * $this->limit;
			echo "\n<a href=\"#next\" class=\"pagenav\" title=\" \" onclick=\"javascript: document.adminForm.limitstart.value=$page; document.adminForm.submit();\">   ></a>";
			echo "\n<a href=\"#end\" class=\"pagenav\" title=\" \" onclick=\"javascript: document.adminForm.limitstart.value=$end_page; document.adminForm.submit();\">   >></a>";
		} else {
			echo "\n<span class=\"pagenav\">  ></span>";
			echo "\n<span class=\"pagenav\">  >></span>";
		}
	}
}

?>