<?php
// $Id: admin.weblinks.php,v 1.16 2003/12/15 23:51:10 eddieajau Exp $
/**
* Weblink admin component code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.16 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

// ensure user has access to this function
if (!($acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'all' )
		| $acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'com_weblinks' ))) {
	mosRedirect( 'index2.php', _NOT_AUTH );
}

require_once( $mainframe->getPath( 'admin_html' ) );
require_once( $mainframe->getPath( 'class' ) );

$cid = mosGetParam( $_POST, 'cid', array(0) );

switch ($task) {
	case "new":
		editWeblink( $option, 0 );
		break;

	case "edit":
		editWeblink( $option, $cid[0] );
		break;

	case "save":
		saveWeblink( $option );
		break;

	case "remove":
		removeWeblinks( $cid, $option );
		break;

	case "publish":
		publishWeblinks( $cid, 1, $option );
		break;

	case "unpublish":
		publishWeblinks( $cid, 0, $option );
		break;

	case "approve":
		break;

	case "cancel":
		cancelWeblink( $option );
		break;

	case "orderup":
		orderWeblinks( $cid[0], -1, $option );
		break;

	case "orderdown":
		orderWeblinks( $cid[0], 1, $option );
		break;

	default:
		showWeblinks( $option );
		break;
}

/**
* Compiles a list of records
* @param database A database connector object
*/
function showWeblinks( $option ) {
	global $database, $mainframe;

	$catid = $mainframe->getUserStateFromRequest( "catid{$option}", 'catid', 0 );
	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );
	$search = $mainframe->getUserStateFromRequest( "search{$option}", 'search', '' );
	$search = $database->getEscaped( trim( strtolower( $search ) ) );

	$where = array();

	if ($catid > 0) {
		$where[] = "a.catid='$catid'";
	}
	if ($search) {
		$where[] = "LOWER(a.title) LIKE '%$search%'";
	}

	// get the total number of records
	$database->setQuery( "SELECT count(*) FROM #__weblinks AS a"
		. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
	);
	$total = $database->loadResult();
	echo $database->getErrorMsg();

	include_once( "includes/pageNavigation.php" );
	$pageNav = new mosPageNav( $total, $limitstart, $limit  );

	$database->setQuery( "SELECT a.*, cc.name AS category, u.name AS editor"
		. "\nFROM #__weblinks AS a"
		. "\nLEFT JOIN #__categories AS cc ON cc.id = a.catid"
		. "\nLEFT JOIN #__users AS u ON u.id = a.checked_out"
		. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
		. "\nORDER BY a.catid, a.ordering"
		. "\nLIMIT $pageNav->limitstart,$pageNav->limit"
	);

	$rows = $database->loadObjectList();
	if ($database->getErrorNum()) {
		echo $database->stderr();
		return false;
	}

	// get list of categories
	$categories[] = mosHTML::makeOption( '0', ' ' );
	$categories[] = mosHTML::makeOption( '-1', '-  ' );
	$database->setQuery( "SELECT id AS value, title AS text FROM #__categories"
		. "\nWHERE section='com_weblinks' ORDER BY ordering" );
	$categories = array_merge( $categories, $database->loadObjectList() );

	$clist = mosHTML::selectList( $categories, 'catid', 'class="inputbox" size="1" onchange="document.adminForm.submit();"',
		'value', 'text', $catid );

	HTML_weblinks::showWeblinks( $option, $rows, $clist, $search, $pageNav );
}

/**
* Compiles information to add or edit
* @param integer The unique id of the record to edit (0 if new)
*/
function editWeblink( $option, $uid ) {
	global $database, $my, $mosConfig_absolute_path, $mosConfig_live_site;

	$row = new mosWeblink( $database );
	// load the row from the db table
	$row->load( $uid );

// get list of categories
	$categories[] = mosHTML::makeOption( '0', ' ' );
	$database->setQuery( "SELECT id AS value, name AS text FROM #__categories"
		. "\nWHERE section='$option' ORDER BY ordering" );
	$categories = array_merge( $categories, $database->loadObjectList() );

	if (count( $categories ) < 1) {
		mosRedirect( "index2.php?option=categories&section=$option",
			'         ' );
	}

	$clist = mosHTML::selectList( $categories, 'catid', 'class="inputbox" size="1"',
		'value', 'text', intval( $row->catid ) );

	// fail if checked out not by 'me'
	if ($row->checked_out && $row->checked_out <> $my->id) {
		mosRedirect( "index2.php?option=$option",
			'The module $row->title is currently being edited by another administrator.' );
	}

	if ($uid) {
		$row->checkout( $my->id );
	} else {
		// initialise new record
		$row->published = 0;
		$row->approved = 0;
	}

// build the html select list for ordering
	$order = mosGetOrderingList( "SELECT ordering AS value, title AS text"
		. "\nFROM #__weblinks"
		. "\nWHERE catid='$row->catid' ORDER BY ordering"
	);
	$olist = mosHTML::selectList( $order, 'ordering', 'class="inputbox" size="1"',
		'value', 'text', intval( $row->ordering ) );

// make the select list for the image positions
	$yesno[] = mosHTML::makeOption( '0', '' );
	$yesno[] = mosHTML::makeOption( '1', '' );

// build the html select list
	$applist = mosHTML::selectList( $yesno, 'approved', 'class="inputbox" size="2"',
		'value', 'text', $row->approved );

	HTML_weblinks::editWeblink( $option, $row, $clist, $olist, $applist );
}

/**
* Saves the record on an edit form submit
* @param database A database connector object
*/
function saveWeblink( $option ) {
	global $database, $my;

	$row = new mosWeblink( $database );
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	$row->date = date( "Y-m-d H:i:s" );
	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();
	$row->updateOrder( "catid='$row->catid'" );

	mosRedirect( "index2.php?option=$option" );
}

/**
* Deletes one or more records
* @param array An array of unique category id numbers
* @param string The current url option
*/
function removeWeblinks( $cid, $option ) {
	global $database;

	if (!is_array( $cid ) || count( $cid ) < 1) {
		echo "<script> alert('Select an item to delete'); window.history.go(-1);</script>\n";
		exit;
	}
	if (count( $cid )) {
		$cids = implode( ',', $cid );
		$database->setQuery( "DELETE FROM #__weblinks WHERE id IN ($cids)" );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		}
	}

	mosRedirect( "index2.php?option=$option" );
}

/**
* Publishes or Unpublishes one or more records
* @param array An array of unique category id numbers
* @param integer 0 if unpublishing, 1 if publishing
* @param string The current url option
*/
function publishWeblinks( $cid=null, $publish=1,  $option ) {
	global $database, $my;

	$catid = mosGetParam( $_POST, 'catid', array(0) );

	if (!is_array( $cid ) || count( $cid ) < 1) {
		$action = $publish ? 'publish' : 'unpublish';
		echo "<script> alert('   $action'); window.history.go(-1);</script>\n";
		exit;
	}

	$cids = implode( ',', $cid );

	$database->setQuery( "UPDATE #__weblinks SET published='$publish'"
		. "\nWHERE id IN ($cids) AND (checked_out=0 OR (checked_out='$my->id'))"
	);
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (count( $cid ) == 1) {
		$row = new mosWeblink( $database );
		$row->checkin( $cid[0] );
	}
	mosRedirect( "index2.php?option=$option" );
}
/**
* Moves the order of a record
* @param integer The increment to reorder by
*/
function orderWeblinks( $uid, $inc, $option ) {
	global $database;
	$row = new mosWeblink( $database );
	$row->load( $uid );
	$row->move( $inc, "published >= 0" );

	mosRedirect( "index2.php?option=$option" );
}

/**
* Cancels an edit operation
* @param string The current url option
*/
function cancelWeblink( $option ) {
	global $database;
	$row = new mosWeblink( $database );
	$row->bind( $_POST );
	$row->checkin();
	mosRedirect( "index2.php?option=$option" );
}
?>