<?php
// $Id: admin.poll.php,v 1.14 2003/12/15 23:51:10 eddieajau Exp $
/**
* Poll admin component code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.14 $
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( '      ' );

// ensure user has access to this function
if (!($acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'all' )
		| $acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'com_poll' ))) {
	mosRedirect( 'index2.php', _NOT_AUTH );
}

require_once( $mainframe->getPath( 'admin_html' ) );
require_once( $mainframe->getPath( 'class' ) );

$task = mosGetParam( $_REQUEST, 'task', '' );
$cid = mosGetParam( $_REQUEST, 'cid', array(0) );
if (!is_array( $cid )) {
	$cid = array(0);
}

switch( $task ) {
	case "new":
		editPoll( 0, $option );
		break;

	case "edit":
		editPoll( $cid[0], $option );
		break;

	case "save":
		savePoll( $option );
		break;

	case "remove":
		removePoll( $cid, $option );
		break;

	case "publish":
		publishPolls( $cid, 1, $option );
		break;

	case "unpublish":
		publishPolls( $cid, 0, $option );
		break;

	case "cancel":
		cancelPoll( $option );
		break;

	default:
		showPolls( $option );
		break;
}

function showPolls( $option ) {
	global $database, $mainframe;

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );

	$database->setQuery( "SELECT COUNT(*) FROM #__polls" );
	$total = $database->loadResult();
	echo $database->getErrorMsg();

	require_once( "includes/pageNavigation.php" );
	$pageNav = new mosPageNav( $total, $limitstart, $limit  );

	$database->setQuery( "SELECT m.*, u.name AS editor,"
		. "\n	COUNT(d.id) AS numoptions"
		. "\nFROM #__polls AS m"
		. "\nLEFT JOIN #__users AS u ON u.id = m.checked_out"
		. "\nLEFT JOIN #__poll_data AS d ON d.pollid = m.id AND d.text <> ''"
		. "\nGROUP BY m.id"
		. "\nLIMIT $pageNav->limitstart,$pageNav->limit"
	);
	$rows = $database->loadObjectList();

	if ($database->getErrorNum()) {
		echo $database->stderr();
		return false;
	}

	HTML_poll::showPolls( $rows, $pageNav, $option );
}

function editPoll( $uid=0, $option='com_poll' ) {
	global $database, $my;

	$row = new mosPoll( $database );
	// load the row from the db table
	$row->load( $uid );

	// fail if checked out not by 'me'
	if ($row->checked_out && $row->checked_out <> $my->id) {
		mosRedirect( "index2.php?option=$option",
		'The poll $row->title is currently being edited by another administrator.' );
	}

	$options = array();

	if ($uid) {
		$row->checkout( $my->id );
		$query = "SELECT id, text FROM #__poll_data"
			. "\nWHERE pollid='$uid' ORDER BY id";
		$database->setQuery($query);
		$options = $database->loadObjectList();
	} else {
		$row->lag = 3600*24;
	}

	// get a list of the menu items

	// get selected pages
	$database->setQuery( "SELECT menuid AS value FROM #__modules_menu WHERE moduleid=1" );
	$modulepage = $database->loadResult();

	if ($modulepage==0) {
		// All pages
		$database->setQuery( "SELECT m.*"
		. "\nFROM #__menu m"
		. "\nLEFT JOIN #__modules_menu AS b"
		. "\nON b.menuid=1"
		. "\nWHERE menutype='mainmenu' AND type != 'url' AND type != 'separator'"
		. "\nORDER BY ordering"
		);
	} else {
		// By modules selected pages
		$database->setQuery( "SELECT m.*"
		. "\nFROM #__modules_menu AS b"
		. "\nLEFT JOIN #__menu AS m"
		. "\nON b.menuid=m.id"
		. "\nWHERE b.moduleid=1 AND m.menutype='mainmenu' AND m.type != 'url' AND m.type != 'separator'"
		. "\nORDER BY m.ordering"
		);
	}
	$mitems = $database->loadObjectList();

	// get selected pages
	$database->setQuery( "SELECT menuid AS value FROM #__poll_menu WHERE pollid='$row->id'" );
	$lookup = $database->loadObjectList();

	// establish the hierarchy of the menu
	$children = array();
	// first pass - collect children
	foreach ($mitems as $v ) {
		$id = $v->id;
		$pt = $v->parent;
		$list = @$children[$pt] ? $children[$pt] : array();
		array_push( $list, $v );
		$children[$pt] = $list;
	}
	// second pass - get an indent list of the items
	$list = mosTreeRecurse( $mitems[0]->parent, '', array(), $children );

	// prepare an array with 'all' as the first item
	$mitems = array( mosHTML::makeOption( 0, '' ) );
	// append the rest of the menu items to the array
	foreach ($list as $item) {
		$mitems[] = mosHTML::makeOption( $item->id, $item->treename );
	}

	// build the html select list
	$menulist = mosHTML::selectList( $mitems, 'selections[]', 'class="inputbox" size="10" multiple="multiple"',
	'value', 'text', $lookup );

	HTML_poll::editPoll($row, $options, $menulist);
}

function savePoll( $option ) {
	global $database, $my;

	// save the poll parent information
	$row = new mosPoll( $database );
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$isNew = ($row->id == 0);

	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();
	// save the poll options
	$options = mosGetParam( $_POST, 'polloption', array() );

	foreach ($options as $i=>$text) {
		// 'slash' the options
		if (!get_magic_quotes_gpc()) {
			$text = addslashes( $text );
		}

		if ($isNew) {
			$database->setQuery( "INSERT INTO #__poll_data (pollid,text) VALUES ($row->id,'$text')" );
			$database->query();
		} else {
			$database->setQuery( "UPDATE #__poll_data SET text='$text' WHERE id='$i' AND pollid='$row->id'" );
			$database->query();
		}
	}

	// update the menu visibility
	$selections = mosGetParam( $_POST, 'selections', array() );

	$database->setQuery( "DELETE from #__poll_menu where pollid='$row->id'" );
	$database->query();

	for ($i=0, $n=count($selections); $i < $n; $i++) {
		$database->setQuery( "INSERT INTO #__poll_menu"
		. "\nSET pollid='$row->id', menuid='$selections[$i]'"
		);
		$database->query();
	}

	mosRedirect( "index2.php?option=$option" );
}

function removePoll( $cid, $option ) {
	global $database;
	$msg = '';
	for ($i=0, $n=count($cid); $i < $n; $i++) {
		$poll = new mosPoll( $database );
		if (!$poll->delete( $cid[$i] )) {
			$msg .= $poll->getError();
		}
	}
	mosRedirect( "index2.php?option=$option&mosmsg=$msg" );
}

/**
* Publishes or Unpublishes one or more records
* @param array An array of unique category id numbers
* @param integer 0 if unpublishing, 1 if publishing
* @param string The current url option
*/
function publishPolls( $cid=null, $publish=1, $option ) {
	global $database, $my;

	$catid = mosGetParam( $_POST, 'catid', array(0) );

	if (!is_array( $cid ) || count( $cid ) < 1) {
		$action = $publish ? 'publish' : 'unpublish';
		echo "<script> alert('Select an item to $action'); window.history.go(-1);</script>\n";
		exit;
	}

	$cids = implode( ',', $cid );

	$database->setQuery( "UPDATE #__polls SET published='$publish'"
	. "\nWHERE id IN ($cids) AND (checked_out=0 OR (checked_out='$my->id'))"
	);
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (count( $cid ) == 1) {
		$row = new mosPoll( $database );
		$row->checkin( $cid[0] );
	}
	mosRedirect( "index2.php?option=$option" );
}

function cancelPoll( $option ) {
	global $database;
	$row = new mosPoll( $database );
	$row->bind( $_POST );
	$row->checkin();
	mosRedirect( "index2.php?option=$option" );
}
?>